/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PartitionSchemePropertyDialog
extends AbstractSqlServerPropertyDialog {
    private PartitionSchemeSqlServer partScheme;
    private JComboBox cbMappingType;
    private JPanel panelBoundaryValues;
    private BoundaryValuesModel model;
    private JTextField tfPartFunction;
    private JComboBox cbSingleFGroup;
    private JPanel pMappingTable;
    private TypesTable mappingTable;
    private TypesTableModel modelMappingTable;
    private DataBaseSqlServer database;
    public JComboBox cbox1;

    public PartitionSchemePropertyDialog(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partScheme = (PartitionSchemeSqlServer)object;
        this.database = this.partScheme.getPartitionFunction().getDatabase();
        this.setHeight(200);
        this.initGeneral();
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initGeneral() {
        this.initPartitionFunction();
        this.initMappingType();
        this.initSingleFileGroup();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.partScheme.getName());
        this.tfPartFunction.setText(this.partScheme.getPartitionFunction().getName());
        this.cbMappingType.setSelectedItem(this.partScheme.getMappingType());
        this.cbSingleFGroup.setSelectedItem(this.partScheme.getSingleFileGroup());
        this.fillComboItems(this.database.getFilegroups().toArray(), this.cbox1, (Object)null);
        this.cbox1.insertItemAt(" ", 0);
        this.getCommentsList().insert(this.partScheme.getComment(), 0);
        if (this.partScheme.getPartitionFunction().getBValuesSet() != null) {
            Object[] partfunctBV = this.partScheme.getPartitionFunction().getBValuesSet().toArray();
            for (int i = 0; i < partfunctBV.length; ++i) {
                Object[] mappingTable;
                String boundaryValue = (String)partfunctBV[i];
                String commnet = (String)partfunctBV[++i];
                String fileGroup = " ";
                if (this.partScheme.getMappingTableSet() != null && i < (mappingTable = this.partScheme.getMappingTableSet().toArray()).length) {
                    fileGroup = (String)mappingTable[i];
                }
                this.modelMappingTable.addRow(new Object[]{boundaryValue, fileGroup, commnet});
            }
            String fileGroup = " ";
            if (this.partScheme.getMappingTableSet().contains("MAXVALUE")) {
                fileGroup = (String)this.partScheme.getMappingTableSet().lastElement();
            }
            this.modelMappingTable.addRow(new Object[]{"MAXVALUE", fileGroup, " "});
        }
    }

    @Override
    protected void setProperties() {
        this.partScheme.setName(this.tfName.getText());
        this.partScheme.setMappingType((String)this.cbMappingType.getSelectedItem());
        if (this.cbSingleFGroup.isEnabled()) {
            this.partScheme.setSingleFileGroup((FileGroupSqlServer)this.cbSingleFGroup.getSelectedItem());
        } else {
            this.partScheme.setSingleFileGroup(null);
        }
        this.partScheme.clear();
        this.modelMappingTable.initMappingTablePair();
        this.partScheme.setComment(this.getCommentsList().getText());
    }

    private void initPartitionFunction() {
        JLabel label = new JLabel(Messages.getString("PartitionSchemePropertyDialog.PartitionFunction"));
        this.general.add(label);
        this.tfPartFunction = new JTextField();
        this.tfPartFunction.setPreferredSize(this.tfName.getPreferredSize());
        this.tfPartFunction.setEditable(false);
        this.general.add(this.tfPartFunction);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfPartFunction, 50);
    }

    private void initMappingType() {
        JLabel label = new JLabel(Messages.getString("PartitionSchemePropertyDialog.MappingType"));
        this.general.add(label);
        this.cbMappingType = new JComboBox<String>(PartitionSchemeSqlServer.getMapTypeChoices());
        this.cbMappingType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbMappingType.setEditable(false);
        this.cbMappingType.addActionListener(new MappingTypeListener());
        this.general.add(this.cbMappingType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbMappingType, 80);
    }

    private void initSingleFileGroup() {
        JLabel label = new JLabel(Messages.getString("PartitionSchemePropertyDialog.SingleFileGroup"));
        this.general.add(label);
        this.cbSingleFGroup = new JComboBox();
        this.cbSingleFGroup.setPreferredSize(this.tfName.getPreferredSize());
        this.fillComboItems(this.getFileGroups(), this.cbSingleFGroup);
        this.cbSingleFGroup.setEnabled(this.partScheme.isSingleFileGroupSelected());
        this.general.add(this.cbSingleFGroup);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbSingleFGroup, 110);
    }

    private Object[] getFileGroups() {
        if (this.database != null) {
            return this.database.getFilegroups().toArray();
        }
        return new Object[0];
    }

    private void initMappingTable() {
        this.pMappingTable = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PartitionSchemePropertyDialog.PartitionMappingTable"), this.pMappingTable);
        this.mappingTable = new TypesTable();
        this.mappingTable.setPreferredScrollableViewportSize(new Dimension(410, 150));
        JScrollPane pane = new JScrollPane(this.mappingTable);
        this.modelMappingTable = (TypesTableModel)this.mappingTable.getModel();
        this.setBG(this.mappingTable);
        this.pMappingTable.add(pane);
    }

    @Override
    protected void addTabs() {
        this.initMappingTable();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelBoundaryValues.getLayout();
    }

    class TypesTableModel
    extends DefaultTableModel
    implements TableModelListener {
        String[] cNames = new String[]{Messages.getString("PartitionSchemePropertyDialog.BoundaryValue"), Messages.getString("PartitionSchemePropertyDialog.FileGroup"), Messages.getString("PartitionSchemePropertyDialog.Comments")};

        public TypesTableModel() {
            this.addTableModelListener(this);
        }

        public void initMappingTablePair() {
            int rowCount = PartitionSchemePropertyDialog.this.modelMappingTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                PartitionSchemePropertyDialog.this.partScheme.setMappingTable((String)this.getValueAt(i, 0));
                Object fileGroupName = this.getValueAt(i, 1);
                if (fileGroupName != null) {
                    PartitionSchemePropertyDialog.this.partScheme.setMappingTable(fileGroupName.toString());
                    continue;
                }
                PartitionSchemePropertyDialog.this.partScheme.setMappingTable(" ");
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!PartitionSchemePropertyDialog.this.isEditable()) {
                return false;
            }
            return col == 1;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            if (this.getValueAt(0, c) != null) {
                return this.getValueAt(0, c).getClass();
            }
            return null;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
        }
    }

    public class MappingTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int tabIndex = PartitionSchemePropertyDialog.this.getPane().indexOfComponent(PartitionSchemePropertyDialog.this.pMappingTable);
            if (PartitionSchemePropertyDialog.this.cbMappingType.getSelectedItem().toString().equalsIgnoreCase("SINGLE FILE GROUP")) {
                PartitionSchemePropertyDialog.this.cbSingleFGroup.setEnabled(true);
                PartitionSchemePropertyDialog.this.partScheme.clear();
                PartitionSchemePropertyDialog.this.getPane().setEnabledAt(tabIndex, false);
            } else {
                PartitionSchemePropertyDialog.this.cbSingleFGroup.setEnabled(false);
                PartitionSchemePropertyDialog.this.cbSingleFGroup.setSelectedIndex(0);
                PartitionSchemePropertyDialog.this.getPane().setEnabledAt(tabIndex, true);
            }
        }
    }

    class TypesTable
    extends JTable {
        TypesTableModel dataModel;

        public TypesTable() {
            this.dataModel = new TypesTableModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            tableColumn.getColumn(0).setCellRenderer(new UsersTableCellRenderer());
            tableColumn.getColumn(2).setCellRenderer(new UsersTableCellRenderer());
            tableColumn.getColumn(1).setCellEditor(new SchemaComboBoxEditor());
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 3; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(100);
                    continue;
                }
                if (i == 1) {
                    column.setPreferredWidth(150);
                    continue;
                }
                column.setPreferredWidth(150);
            }
        }
    }

    public class SchemaComboBoxEditor
    extends DefaultCellEditor {
        public SchemaComboBoxEditor() {
            super(new JComboBox());
            PartitionSchemePropertyDialog.this.cbox1 = (JComboBox)this.getComponent();
        }
    }

    class UsersTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        UsersTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }

    class BoundaryValuesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("PartitionSchemePropertyDialog.BoundaryValue"), Messages.getString("PartitionSchemePropertyDialog.Comment")};

        BoundaryValuesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = PartitionSchemePropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }
}

