/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionFunctionSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PartitionFunctionPropertyDialog
extends AbstractSqlServerPropertyDialog {
    private PartitionFunctionSqlServer partFunction;
    private JTextField tfInputType;
    private JComboBox cbRangeType;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private JPanel panelBoundaryValues;
    private BoundaryValuesModel model;
    private BoundaryValues boundaryValues;

    public PartitionFunctionPropertyDialog(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partFunction = (PartitionFunctionSqlServer)object;
        this.setHeight(200);
        this.initGeneral();
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    private void initGeneral() {
        this.initInputType();
        this.initRangeType();
    }

    @Override
    public void initProperties() {
        this.tfName.setText(this.partFunction.getName());
        this.tfInputType.setText(this.partFunction.getInputType());
        this.cbRangeType.setSelectedItem(this.partFunction.getRangeType());
        this.getCommentsList().insert(this.partFunction.getComment(), 0);
        if (this.partFunction.getBValuesSet() != null) {
            Object[] props = this.partFunction.getBValuesSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                Object[] obj = new Object[2];
                obj[0] = p;
                if (i + 1 < props.length) {
                    String pplus = (String)props[++i];
                    obj[1] = pplus;
                }
                this.model.addRow(obj);
            }
        }
    }

    @Override
    protected void setProperties() {
        int icol = this.boundaryValues.getEditingColumn();
        int irow = this.boundaryValues.getEditingRow();
        if (icol > -1 && irow > -1 && irow < this.boundaryValues.getRowCount()) {
            this.boundaryValues.getCellEditor(irow, icol).stopCellEditing();
        }
        this.partFunction.setName(this.tfName.getText());
        this.partFunction.setInputType(this.tfInputType.getText());
        this.partFunction.setRangeType((String)this.cbRangeType.getSelectedItem());
        this.partFunction.setComment(this.getCommentsList().getText());
        this.partFunction.clear();
        this.model.initPropSet();
    }

    private void initInputType() {
        JLabel label = new JLabel(Messages.getString("PartitionFunctionPropertyDialog.InputType"));
        this.general.add(label);
        this.tfInputType = new JTextField();
        this.tfInputType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfInputType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfInputType, 50);
    }

    private void initRangeType() {
        JLabel label = new JLabel(Messages.getString("PartitionFunctionPropertyDialog.RangeType"));
        this.general.add(label);
        this.cbRangeType = new JComboBox<String>(PartitionFunctionSqlServer.getLEFT_RIGHT());
        this.cbRangeType.setPreferredSize(this.tfName.getPreferredSize());
        this.cbRangeType.setEditable(false);
        this.general.add(this.cbRangeType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbRangeType, 80);
    }

    @Override
    protected void addTabs() {
        this.initBoundaryValues();
    }

    private void initBoundaryValues() {
        this.initAllBoundaryValues();
        this.initBoundaryValuesButtons();
    }

    private void initBoundaryValuesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("PartitionFunctionPropertyDialog.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("PartitionFunctionPropertyDialog.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddBoundaryValuesActionListener());
        this.panelBoundaryValues.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 145);
        this.bnRemoveProperty.addActionListener(new RemoveUsersActionListener());
        this.panelBoundaryValues.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 145);
        PartitionFunctionPropertyDialog.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllBoundaryValues() {
        this.panelBoundaryValues = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PartitionFunctionPropertyDialog.BoundaryValues"), this.panelBoundaryValues);
        this.boundaryValues = new BoundaryValues();
        this.boundaryValues.setPreferredScrollableViewportSize(new Dimension(414, 135));
        JScrollPane pane = new JScrollPane(this.boundaryValues);
        pane.setPreferredSize(new Dimension(414, 140));
        this.model = (BoundaryValuesModel)this.boundaryValues.getModel();
        this.setBG(this.boundaryValues);
        this.panelBoundaryValues.add(pane);
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelBoundaryValues.getLayout();
    }

    class BoundaryValuesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("PartitionFunctionPropertyDialog.BoundaryValue"), Messages.getString("PartitionFunctionPropertyDialog.Comment")};

        BoundaryValuesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return PartitionFunctionPropertyDialog.this.isEditable();
        }

        public void initPropSet() {
            int rowCount = PartitionFunctionPropertyDialog.this.model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (((String)this.getValueAt(i, 0)).equalsIgnoreCase("")) continue;
                PartitionFunctionPropertyDialog.this.partFunction.setBoundaryValues((String)this.getValueAt(i, 0));
                PartitionFunctionPropertyDialog.this.partFunction.setBoundaryValues((String)this.getValueAt(i, 1));
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = PartitionFunctionPropertyDialog.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    class BoundaryValues
    extends JTable {
        BoundaryValuesModel dataModel;

        public BoundaryValues() {
            this.dataModel = new BoundaryValuesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new BoundaryValuesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    private class AddBoundaryValuesActionListener
    implements ActionListener {
        private AddBoundaryValuesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            PartitionFunctionPropertyDialog.this.model.addRow(new Object[]{propertyName, propertyValue});
        }
    }

    private class RemoveUsersActionListener
    implements ActionListener {
        private RemoveUsersActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PartitionFunctionPropertyDialog.this.model.getRowCount() >= 1) {
                Iterator it = PartitionFunctionPropertyDialog.this.partFunction.getPartitionScheme().iterator();
                String baundaryValue = (String)PartitionFunctionPropertyDialog.this.model.getValueAt(PartitionFunctionPropertyDialog.this.model.getRowCount() - 1, 0);
                while (it.hasNext()) {
                    PartitionSchemeSqlServer partScheme = (PartitionSchemeSqlServer)it.next();
                    partScheme.removeBoundaruValue(baundaryValue);
                }
                PartitionFunctionPropertyDialog.this.model.removeRow(PartitionFunctionPropertyDialog.this.model.getRowCount() - 1);
            }
        }
    }

    class BoundaryValuesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        BoundaryValuesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }
}

