/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.string.StringUtilities;

public class PKPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private static final String NO_INDEX = NO;
    private static final String LOCAL_PARTITIONED = "LOCAL PARTITIONED";
    private static final String GLOBAL_PARTITIONED = "GLOBAL PARTITIONED";
    private static final String BY_INDEX_NAME = "BY INDEX NAME";
    private static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    private static final String[] USING_INDEX_CHOICES = new String[]{NO_INDEX, "LOCAL PARTITIONED", "GLOBAL PARTITIONED", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static final String NO_SORT = NO;
    private static final String SORTED = "SORTED";
    private static final String REVERSE = "REVERSE";
    private static final String[] SORT_CHOICES = new String[]{NO_SORT, "SORTED", "REVERSE"};
    private PKProxyOraclev9i pkProxy;
    private JTextField tfTable;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbRely;
    private JComboBox cbUsingIndex;
    private JComboBox cbExTable;
    private JPanel usingIndex;
    private JComboBox cbExistingIndex;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JComboBox cbIndexSort;
    private JComboBox cbComputeStatistics;
    private JTextArea taCreateIndexStatement;
    private JScrollPane spCreateIndexStatement;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel partitioning;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private String comment;
    private String commentInRDBMS;

    public PKPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.pkProxy = (PKProxyOraclev9i)object;
        this.setHeight(430);
        this.initCommentsView(165);
        this.initCommentsInRDBMS(165);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("PKPropertyDialogOracle.PrimaryKeyProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initRely();
        this.initUsingIndex();
        this.initExTable();
        if (this.isEditable()) {
            this.initPropagatePropsButton(290);
        }
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initInitially() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.Initially"));
        this.general.add(label);
        this.cbInitially = new JComboBox<String>(PKProxyOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitially);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbInitially, 80);
    }

    private void initDeferrable() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.Deferrable"));
        this.general.add(label);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeferrable);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDeferrable, 110);
    }

    private void initEnable() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.Enable"));
        this.general.add(label);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnable);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbEnable, 140);
    }

    private void initValidate() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.Validate"));
        this.general.add(label);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.cbValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PKPropertyDialogOraclev9i.this.cbRely.setEnabled(PKPropertyDialogOraclev9i.this.cbValidate.getSelectedItem().equals(AbstractPropertyDialog.NO));
            }
        });
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidate);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbValidate, 170);
    }

    private void initRely() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Rely"));
        this.general.add(label);
        this.cbRely = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRely);
        this.cbRely.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRely);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbRely, 200);
    }

    private void initUsingIndex() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.UsingIndexL"));
        this.general.add(label);
        this.cbUsingIndex = new JComboBox<String>(USING_INDEX_CHOICES);
        this.cbUsingIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = (String)PKPropertyDialogOraclev9i.this.cbUsingIndex.getSelectedItem();
                int usingIndexTabIndex = PKPropertyDialogOraclev9i.this.getPane().indexOfComponent(PKPropertyDialogOraclev9i.this.usingIndex);
                if (usingIndexTabIndex > -1) {
                    PKPropertyDialogOraclev9i.this.getPane().setEnabledAt(usingIndexTabIndex, !value.equalsIgnoreCase(NO_INDEX));
                }
                if (value.equalsIgnoreCase(PKPropertyDialogOraclev9i.BY_INDEX_NAME)) {
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setEnabled(true);
                    PKPropertyDialogOraclev9i.this.enableUsingIndexProps(true);
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setText("");
                } else if (value.equalsIgnoreCase(PKPropertyDialogOraclev9i.BY_CREATE_INDEX_STATEMENT)) {
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setEnabled(true);
                    PKPropertyDialogOraclev9i.this.enableUsingIndexProps(false);
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setSelectedItem(null);
                } else if (!value.equalsIgnoreCase(NO_INDEX)) {
                    PKPropertyDialogOraclev9i.this.enableUsingIndexProps(true);
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setEnabled(false);
                    PKPropertyDialogOraclev9i.this.taCreateIndexStatement.setText("");
                    PKPropertyDialogOraclev9i.this.cbExistingIndex.setSelectedItem(null);
                }
                if (value.equalsIgnoreCase(PKPropertyDialogOraclev9i.GLOBAL_PARTITIONED)) {
                    PKPropertyDialogOraclev9i.this.setPartitioning(true);
                } else {
                    PKPropertyDialogOraclev9i.this.setPartitioning(false);
                }
            }
        });
        this.setBG(this.cbUsingIndex);
        this.cbUsingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUsingIndex);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbUsingIndex, 230);
    }

    private void enableUsingIndexProps(boolean enable) {
        this.cbTableSpace.setEnabled(enable);
        this.cbLogging.setEnabled(enable);
        this.cbSegment.setEnabled(enable);
        this.cbIndexSort.setEnabled(enable);
        this.cbComputeStatistics.setEnabled(enable);
    }

    private void initExTable() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.ExceptionsTable"));
        this.general.add(label);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExTable);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbExTable, 260);
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("IndexPropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(PKPropertyDialogOraclev9i.this.getStorageDesign().getPKProxySet().getElements());
                list.remove(PKPropertyDialogOraclev9i.this.pkProxy);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                new PropertiesPropagationDialog(PKPropertyDialogOraclev9i.this.getAppView(), PKPropertyDialogOraclev9i.this.pkProxy, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private void initIndexSort() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.IndexSort"));
        this.usingIndex.add(label);
        this.cbIndexSort = new JComboBox<String>(SORT_CHOICES);
        this.setBG(this.cbIndexSort);
        this.cbIndexSort.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbIndexSort);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 140);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbIndexSort, 140);
    }

    private void initTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("PKPropertyDialogOracle.TableSpace"));
        this.usingIndex.add(lbTableSpace);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbTableSpace);
        this.setLabelConstraints(this.getUsingIndexLayout(), lbTableSpace, 50);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbTableSpace, 50);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.Logging"));
        this.usingIndex.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbLogging);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 80);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbLogging, 80);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.Segment"));
        this.usingIndex.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbSegment);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 110);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbSegment, 110);
    }

    private void initComputeStatistics() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.ComputeStatistics"));
        this.usingIndex.add(label);
        this.cbComputeStatistics = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStatistics);
        this.cbComputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbComputeStatistics);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 170);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbComputeStatistics, 170);
    }

    private void initExistingIndex() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.ExistingIndex"));
        this.usingIndex.add(label);
        this.cbExistingIndex = new JComboBox();
        this.setBG(this.cbExistingIndex);
        this.cbExistingIndex.addActionListener(new ExistingIndexListener());
        this.cbExistingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbExistingIndex);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 20);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbExistingIndex, 20);
    }

    private void initCreateIndexStatement() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.CreateIndexStatement"));
        this.usingIndex.add(label);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 200);
        this.taCreateIndexStatement = new JTextArea();
        this.spCreateIndexStatement = new JScrollPane(this.taCreateIndexStatement);
        this.spCreateIndexStatement.setPreferredSize(new Dimension(425, 140));
        this.spCreateIndexStatement.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCreateIndexStatement.setLineWrap(true);
        this.usingIndex.add(this.spCreateIndexStatement);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.spCreateIndexStatement, 10, 230);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initPartitioningView();
        this.initUsingIndexView();
    }

    protected SpringLayout getUsingIndexLayout() {
        return (SpringLayout)this.usingIndex.getLayout();
    }

    private void initUsingIndexView() {
        this.usingIndex = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.UsingIndex"), this.usingIndex);
        this.initExistingIndex();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initIndexSort();
        this.initComputeStatistics();
        this.initCreateIndexStatement();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 310));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initPartitioningView() {
        this.partitioning = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("PKPropertyDialogOracle.GlobalPartitioning"), this.partitioning);
        this.initPartitioning();
    }

    protected SpringLayout getPartitioningLayout() {
        return (SpringLayout)this.partitioning.getLayout();
    }

    private void initPartitioning() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.AllColumns"));
        this.partitioning.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 290));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(sp);
        this.setLabelConstraints(this.getPartitioningLayout(), label, 12, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), sp, 10, 30);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("PKPropertyDialogOracle.SelectedColumns"));
        this.partitioning.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 290));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(sp);
        this.setLabelConstraints(this.getPartitioningLayout(), label, 292, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), sp, 290, 30);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("PKPropertyDialogOracle.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partitioning.add(this.bnAdd);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnAdd, 175, 145);
        this.bnRemove = new JButton(Messages.getString("PKPropertyDialogOracle.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partitioning.add(this.bnRemove);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnRemove, 175, 175);
        PKPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void setPartitioning(boolean use) {
        this.allColumnsList.setEnabled(use);
        this.selectedColumnsList.setEnabled(use);
        this.bnAdd.setEnabled(use && this.allColumnsList.getSelectedIndex() != -1);
        this.bnAdd.setEnabled(use && this.selectedColumnsList.getSelectedIndex() != -1);
        this.allColumnsModel.clear();
        this.selectedColumnsModel.clear();
        if (use) {
            this.initPartColumns(this.pkProxy.getIndexGlobalPL());
        }
    }

    @Override
    public void initProperties() {
        this.initCaption(this.pkProxy.getName());
        this.tfName.setText(this.pkProxy.getName());
        this.tfTable.setText(this.pkProxy.getTable().getName());
        ColumnProxy[] proxies = this.pkProxy.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        this.cbInitially.setSelectedItem(this.pkProxy.getInitially());
        this.cbDeferrable.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getDeferrable()));
        this.cbEnable.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getEnable()));
        this.cbValidate.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getValidate()));
        this.cbRely.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getRely()));
        this.cbUsingIndex.setSelectedItem(this.translate(this.pkProxy.getUsingIndex(), PKProxyOraclev9i.getUsingIndexChoices(), USING_INDEX_CHOICES));
        this.cbExTable.setSelectedItem(this.pkProxy.getExceptionsTable());
        this.cbExistingIndex.addItem(null);
        Iterator iterator = this.pkProxy.getTableProxy().getIndexes().iterator();
        while (iterator.hasNext()) {
            this.cbExistingIndex.addItem(iterator.next());
        }
        this.cbExistingIndex.setSelectedItem(this.pkProxy.getExistingIndex());
        this.cbTableSpace.setSelectedItem(this.pkProxy.getTableSpace());
        this.cbLogging.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getLogging()));
        this.cbSegment.setSelectedItem(this.pkProxy.getIndexSegment());
        this.cbIndexSort.setSelectedItem(this.translate(this.pkProxy.getIndexSort(), PKProxyOraclev9i.getIndexSortChoices(), SORT_CHOICES));
        this.cbComputeStatistics.setSelectedItem(PKPropertyDialogOraclev9i.translateYesNoForDisplay(this.pkProxy.getComputeStatistics()));
        this.taCreateIndexStatement.insert(this.pkProxy.getCreateIndexStatement(), 0);
        if (this.pkProxy.getIndexGlobalPL() != null) {
            this.setPartitioning(true);
        }
        this.comment = this.pkProxy.getObject().getComment();
        this.commentInRDBMS = this.pkProxy.getObject().getCommentInRDBMS();
        if (this.pkProxy.isCommentChanged()) {
            this.getCommentsList().insert(this.pkProxy.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.pkProxy.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.pkProxy.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    private void initPartColumns(IndexGlobalPartitionsListOracle partList) {
        ColumnProxy[] columnSet = this.pkProxy.getColumnProxies();
        if (partList != null) {
            block0: for (String colId : partList.getColumnSet()) {
                for (int i = 0; i < columnSet.length; ++i) {
                    ColumnProxy col = columnSet[i];
                    if (!col.getObjectID().equals(colId)) continue;
                    this.selectedColumnsModel.addElement(col);
                    continue block0;
                }
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedColumnsModel.contains(col)) continue;
            this.allColumnsModel.addElement(col);
        }
    }

    @Override
    protected void setProperties() {
        if (this.pkProxy != null) {
            String commentText;
            IndexGlobalPartitionsListOracle partList;
            this.pkProxy.setName(this.tfName.getText());
            this.pkProxy.setInitially((String)this.cbInitially.getSelectedItem());
            this.pkProxy.setDeferrable(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.pkProxy.setEnable(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.pkProxy.setValidate(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            this.pkProxy.setRely(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbRely.getSelectedItem()));
            this.pkProxy.setUsingIndex(this.translate((String)this.cbUsingIndex.getSelectedItem(), USING_INDEX_CHOICES, PKProxyOraclev9i.getUsingIndexChoices()));
            Object selected = this.cbExTable.getSelectedItem();
            if (selected instanceof TableProxyOracle) {
                this.pkProxy.setExceptionsTable((TableProxyOracle)selected);
            } else {
                this.pkProxy.setExceptionsTable(null);
            }
            this.pkProxy.setExistingIndex((IndexProxyOracle)this.cbExistingIndex.getSelectedItem());
            selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.pkProxy.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.pkProxy.setTableSpace(null);
            }
            this.pkProxy.setLogging(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOracle) {
                this.pkProxy.setIndexSegment((SegmentOracle)selected);
            } else {
                this.pkProxy.setIndexSegment(null);
            }
            this.pkProxy.setIndexSort(this.translate((String)this.cbIndexSort.getSelectedItem(), SORT_CHOICES, PKProxyOraclev9i.getIndexSortChoices()));
            this.pkProxy.setComputeStatistics(PKPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbComputeStatistics.getSelectedItem()));
            this.pkProxy.setCreateIndexStatement(this.taCreateIndexStatement.getText());
            if (((String)this.cbUsingIndex.getSelectedItem()).equalsIgnoreCase(GLOBAL_PARTITIONED)) {
                if (this.pkProxy.getIndexGlobalPL() != null) {
                    partList = this.pkProxy.getIndexGlobalPL();
                } else {
                    partList = this.getStorageDesign().getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                    this.pkProxy.setIndexGlobalPL(partList);
                }
                Object[] columnSet = this.selectedColumnsModel.toArray();
                partList.clear();
                for (int i = 0; i < columnSet.length; ++i) {
                    Object ob = columnSet[i];
                    if (!(ob instanceof RelationalObjectProxy)) continue;
                    partList.setGlobalPartColumns(((RelationalObjectProxy)ob).getObjectID());
                }
            } else {
                partList = this.pkProxy.getIndexGlobalPL();
                if (partList != null) {
                    this.pkProxy.setIndexGlobalPL(null);
                    this.getStorageDesign().getIndexGlobalPartitionsListSet().remove(partList);
                }
            }
            if (StringUtilities.isNotEmpty(commentText = this.getCommentsList().getText()) && !this.comment.equals(commentText)) {
                this.pkProxy.setComment(commentText);
                this.pkProxy.setCommentChanged(true);
            } else {
                this.pkProxy.setComment("");
                this.pkProxy.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equals(commentInRDBMSText)) {
                this.pkProxy.setCommentInRDBMS(commentInRDBMSText);
                this.pkProxy.setCommentInRDBMSChanged(true);
            } else {
                this.pkProxy.setCommentInRDBMS("");
                this.pkProxy.setCommentInRDBMSChanged(false);
            }
        }
    }

    private class ExistingIndexListener
    implements ActionListener {
        private ExistingIndexListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PKPropertyDialogOraclev9i.this.cbUsingIndex.getSelectedItem().equals(PKPropertyDialogOraclev9i.BY_INDEX_NAME)) {
                PKPropertyDialogOraclev9i.this.enableUsingIndexProps(PKPropertyDialogOraclev9i.this.cbExistingIndex.getSelectedItem() == null);
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PKPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev9i.this.bnAdd.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev9i.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PKPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PKPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    PKPropertyDialogOraclev9i.this.bnRemove.setEnabled(false);
                } else {
                    PKPropertyDialogOraclev9i.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PKPropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = PKPropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PKPropertyDialogOraclev9i.this.selectedColumnsModel.contains(ob)) continue;
                    PKPropertyDialogOraclev9i.this.selectedColumnsModel.addElement(ob);
                    PKPropertyDialogOraclev9i.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PKPropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = PKPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PKPropertyDialogOraclev9i.this.allColumnsModel.contains(ob)) continue;
                    PKPropertyDialogOraclev9i.this.allColumnsModel.addElement(ob);
                    PKPropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

