/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MaterializedViewLogOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.FilterComboBox;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class MaterializedViewLogPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private MaterializedViewLogOraclev9i materializedViewLog;
    private JButton btnAddColumn;
    private JButton btnAddAllColumns;
    private JButton btnRemoveColumn;
    private JButton btnRemoveAllColumns;
    private FilterComboBox cmbMasterTable;
    private FilterComboBox.FilterComboBoxModel tablesModel;
    private List<TableProxyOracle> tablesList = new ArrayList<TableProxyOracle>();
    private List<String> tablesNamesList = new ArrayList<String>();
    private JComboBox cmbTablespace;
    private JComboBox cmbLogging;
    private JComboBox cmbBufferMode;
    private JIntegerField tfPercentFree;
    private JIntegerField tfInitrans;
    private JIntegerField tfFreelists;
    private JIntegerField tfPercentUsed;
    private JIntegerField tfFreelistGroups;
    private JComboBox cmbRowIDLogged;
    private JComboBox cmbCache;
    private JComboBox cmbPrimaryKeyLogged;
    private JTextField tfDegree;
    private JComboBox cmbParallelDegree;
    private JComboBox cmbNewValues;
    private JComboBox cmbSequenceLogged;
    private JComboBox cmbObjectIDLogged;
    private JCheckBox cbCommitSCN;
    private JIntegerField tfInitialExtent;
    private JComboBox cmbInitialExtent;
    private JIntegerField tfNextExtent;
    private JComboBox cmbNextExtent;
    private JIntegerField tfMinExtent;
    private JComboBox cmbMinExtent;
    private JIntegerField tfMaxExtent;
    private JComboBox cmbMaxExtent;
    private JCheckBox cbUnlimited;
    private JIntegerField tfPercentIncrease;
    private JComboBox cmbSegment;
    private FilteredColumnsJList availableColumnsList;
    private ColumnsFilterModel availableColumnsFilterModel;
    private JTextField columnsFilter;
    private SelectedColumnsModel selectedColumnsListModel;
    private JList selectedColumnsList;
    private JLabel lbFilter;
    private int mMinHeight = 550;
    private int minWidth = 740;
    private List currentNonSelectedColumnsList = new ArrayList();
    private ToStringComparator toStringComparator = new ToStringComparator();
    private String tableLongName = "";
    private JComboBox cmbPurge;
    private JComboBox cmbRefresh;
    private JTextField tfStartWith;
    private JTextField tfNext;
    private JTextField tfRepeatInterval;
    private JTextField tfStagingLog;
    GUIConfiguration configuration = GUIConfiguration.getInstance();
    private static final Logger LOGGER = new Logger(MaterializedViewLogPropertyDialogOraclev9i.class);

    public MaterializedViewLogPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.materializedViewLog = (MaterializedViewLogOraclev9i)object;
        this.setHeight(680);
        this.initNotesView(280);
        super.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = MaterializedViewLogPropertyDialogOraclev9i.this.getWidth();
                int h = MaterializedViewLogPropertyDialogOraclev9i.this.getHeight();
                w = Math.max(MaterializedViewLogPropertyDialogOraclev9i.this.getMinimumWidth(), w);
                h = Math.max(MaterializedViewLogPropertyDialogOraclev9i.this.getMinimumHeight(), h);
                MaterializedViewLogPropertyDialogOraclev9i.this.setSize(new Dimension(w, h));
            }
        });
        Settings.DialogSettings ds = view.getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = this.getMinimumWidth();
            int h = this.getMinimumHeight();
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
        } else {
            int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
            int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
            this.setSize(w, h);
            this.setLocation(ds.rec.getLocation());
        }
        this.initGeneral();
        this.initNotes();
        this.initComments();
        this.reloadTables();
        this.initProperties();
    }

    private void reloadTables() {
        this.cmbMasterTable.removeAllItems();
        Iterator tsblesIt = this.getStorageDesign().getTableProxySet().iterator();
        while (tsblesIt.hasNext()) {
            TableProxyOracle t = (TableProxyOracle)tsblesIt.next();
            this.tablesList.add(t);
            this.tablesNamesList.add(t.getLongName());
        }
        Collections.sort(this.tablesNamesList, this.toStringComparator);
        if (this.tablesNamesList.size() > 0) {
            this.tablesModel.initComboBoxModel(this.tablesNamesList.toArray(new String[0]));
        }
        if (this.cmbMasterTable.getSelectedItem() != null) {
            this.reloadColumns();
        }
    }

    private void reloadColumns() {
        this.availableColumnsFilterModel.clear();
        this.selectedColumnsListModel.clear();
        this.columnsFilter.setText("");
        String selectedtableName = (String)this.cmbMasterTable.getSelectedItem();
        if (selectedtableName != null && !selectedtableName.equals("")) {
            TableProxyOracle t22 = null;
            for (TableProxyOracle t22 : this.tablesList) {
                this.tableLongName = t22.getLongName();
                if (!t22.getLongName().equals(selectedtableName)) continue;
            }
            if (t22 != null) {
                for (ColumnProxyOracle columnProxyOracle : Arrays.asList(t22.getColumnProxies())) {
                    if (((Column)columnProxyOracle.getObject()).isPKElement()) continue;
                    this.availableColumnsFilterModel.add(columnProxyOracle);
                }
                this.availableColumnsFilterModel.setInitialState();
                if (this.availableColumnsFilterModel.getSize() > 0) {
                    this.availableColumnsList.setEnabled(true);
                    this.columnsFilter.setEnabled(true);
                    this.btnAddAllColumns.setEnabled(true);
                } else {
                    this.availableColumnsList.setEnabled(false);
                    this.columnsFilter.setEnabled(false);
                    this.btnAddAllColumns.setEnabled(false);
                }
            }
        }
    }

    private void initGeneral() {
        this.general.removeAll();
        this.general.setLayout((LayoutManager)new MigLayout("fill", "grow"));
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout("fill", "[120!]0[grow]25"));
        JLabel lbMasterTable = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.MasterTable"));
        this.cmbMasterTable = new FilterComboBox(new String[]{""});
        this.tablesModel = (FilterComboBox.FilterComboBoxModel)this.cmbMasterTable.getModel();
        this.cmbMasterTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaterializedViewLogPropertyDialogOraclev9i.this.reloadColumns();
            }
        });
        this.cmbMasterTable.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                MaterializedViewLogPropertyDialogOraclev9i.this.setFilterIcon();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MaterializedViewLogPropertyDialogOraclev9i.this.setFilterIcon();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                MaterializedViewLogPropertyDialogOraclev9i.this.setFilterIcon();
            }
        });
        ImageIcon icnFilter = (ImageIcon)this.configuration.getIcon("START_FILTER_ICON");
        this.lbFilter = new JLabel(icnFilter, 0);
        this.lbFilter.setToolTipText(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.ComboBoxIsNotFiltered"));
        JPanel fPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[grow][]"));
        fPanel.add((Component)this.cmbMasterTable, new CC().growX());
        fPanel.add(this.lbFilter);
        northPanel.add(lbMasterTable);
        northPanel.add((Component)fPanel, new CC().growX().wrap());
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "grow"));
        JTabbedPane tabPane = new JTabbedPane();
        JPanel propertiesPanel = new JPanel((LayoutManager)new MigLayout("fill", "grow"));
        tabPane.addTab(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Properties"), propertiesPanel);
        JPanel storagePanel = new JPanel((LayoutManager)new MigLayout("fillX, flowy", "[]", "[]0[]"));
        tabPane.addTab(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Storage"), storagePanel);
        JPanel purgePanel = new JPanel((LayoutManager)new MigLayout("fillX, flowy", "[]", "[]0[]"));
        tabPane.addTab(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.Purge"), purgePanel);
        JPanel refreshPanel = new JPanel((LayoutManager)new MigLayout("fill", "grow"));
        tabPane.addTab(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.Refresh"), refreshPanel);
        JPanel pPanel = new JPanel((LayoutManager)new MigLayout("fill", "grow"));
        JPanel pNorthPanel = new JPanel((LayoutManager)new MigLayout("fill", "[130!]0[grow]0[130!]0[grow]"));
        JPanel pCenterPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[grow]0[]0[grow]0", "0[grow]0"));
        pCenterPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Columns")));
        JLabel lbRowIDLogged = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.RowIDLogged"));
        this.cmbRowIDLogged = new JComboBox<String>(MaterializedViewLogOraclev9i.rowIDLoggedItems);
        JLabel lbCache = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Cache"));
        this.cmbCache = new JComboBox<String>(MaterializedViewLogOraclev9i.cacheItems);
        JLabel lbPrimaryKeyLogged = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.PKLogged"));
        this.cmbPrimaryKeyLogged = new JComboBox<String>(MaterializedViewLogOraclev9i.pkLoggedItems);
        JLabel lbDegree = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Degree"));
        this.tfDegree = new JIntegerField();
        this.tfDegree.setEnabled(false);
        JLabel lbParallelDegree = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Parallel"));
        this.cmbParallelDegree = new JComboBox<String>(MaterializedViewLogOraclev9i.parallelDegreeItems);
        this.cmbParallelDegree.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MaterializedViewLogPropertyDialogOraclev9i.this.cmbParallelDegree.getSelectedItem() != null) {
                    if (MaterializedViewLogPropertyDialogOraclev9i.this.cmbParallelDegree.getSelectedItem().equals("YES")) {
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfDegree.setEnabled(true);
                    } else {
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfDegree.setEnabled(false);
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfDegree.setText("");
                    }
                }
            }
        });
        JLabel lbNewValues = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.NewValues"));
        this.cmbNewValues = new JComboBox<String>(MaterializedViewLogOraclev9i.newValuesItems);
        JLabel lbSequenceLogged = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.SequenceLogged"));
        this.cmbSequenceLogged = new JComboBox<String>(MaterializedViewLogOraclev9i.seqLoggedItems);
        JLabel lbObjectIDLogged = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.ObjectIDLogged"));
        this.cmbObjectIDLogged = new JComboBox<String>(MaterializedViewLogOraclev9i.objectIDLoggedItems);
        this.cbCommitSCN = new JCheckBox(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.CommitSCN"));
        pNorthPanel.add(lbRowIDLogged);
        pNorthPanel.add((Component)this.cmbRowIDLogged, new CC().growX().gapRight("10"));
        pNorthPanel.add(lbCache);
        pNorthPanel.add((Component)this.cmbCache, new CC().span(new int[]{4}).growX().wrap());
        pNorthPanel.add(lbPrimaryKeyLogged);
        pNorthPanel.add((Component)this.cmbPrimaryKeyLogged, new CC().growX().gapRight("10"));
        pNorthPanel.add(lbParallelDegree);
        pNorthPanel.add((Component)this.cmbParallelDegree, new CC().width("100!"));
        pNorthPanel.add(lbDegree);
        pNorthPanel.add((Component)this.tfDegree, new CC().growX().wrap());
        pNorthPanel.add(lbNewValues);
        pNorthPanel.add((Component)this.cmbNewValues, new CC().growX().gapRight("10"));
        pNorthPanel.add(lbSequenceLogged);
        pNorthPanel.add((Component)this.cmbSequenceLogged, new CC().span(new int[]{4}).growX().wrap());
        pNorthPanel.add(lbObjectIDLogged);
        pNorthPanel.add((Component)this.cmbObjectIDLogged, new CC().growX().gapRight("10"));
        pNorthPanel.add(new JLabel(""));
        pNorthPanel.add(this.cbCommitSCN);
        JPanel availableColumnsPanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "0[grow]0", "2[grow]0"));
        availableColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Available")));
        this.availableColumnsList = new FilteredColumnsJList();
        this.availableColumnsFilterModel = (ColumnsFilterModel)this.availableColumnsList.getModel();
        this.availableColumnsList.setCellRenderer(new AllColumnsRenderer());
        JScrollPane availableColumnsScrollPane = new JScrollPane(this.availableColumnsList);
        this.availableColumnsList.setEnabled(false);
        this.availableColumnsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.getSelectedIndex() == -1) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnAddColumn.setEnabled(false);
                } else {
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnAddColumn.setEnabled(true);
                }
            }
        });
        this.availableColumnsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnAddColumn.doClick();
                }
            }
        });
        JPanel availableColumnsFilterPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[80!]0[]0", "0[]0[]0"));
        JLabel filterLabel = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Filter"));
        this.columnsFilter = new JTextField();
        this.columnsFilter.setEnabled(false);
        this.columnsFilter.getDocument().addDocumentListener(new ColumnsFilterListener());
        availableColumnsFilterPanel.add((Component)filterLabel, new CC().width("80!"));
        availableColumnsFilterPanel.add((Component)this.columnsFilter, new CC().growX());
        availableColumnsPanel.add((Component)availableColumnsFilterPanel, new CC().dockNorth());
        availableColumnsPanel.add((Component)availableColumnsScrollPane, new CC().grow());
        this.btnAddColumn = new JButton(this.configuration.getIcon("MOVE_RIGHT_S_ICON", 16));
        this.btnAddColumn.addActionListener(new AddColumnsActionListener());
        this.btnAddColumn.setEnabled(false);
        this.btnAddColumn.setToolTipText(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.AddColumns"));
        this.btnAddAllColumns = new JButton(this.configuration.getIcon("MOVE_RIGHT_ALL_S_ICON", 16));
        this.btnAddAllColumns.addActionListener(new AddAllColumnsActionListener());
        this.btnAddAllColumns.setEnabled(false);
        this.btnAddAllColumns.setToolTipText(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.AddAllColumns"));
        this.btnRemoveColumn = new JButton(this.configuration.getIcon("MOVE_LEFT_S_ICON", 16));
        this.btnRemoveColumn.addActionListener(new RemoveColumnActionListener());
        this.btnRemoveColumn.setEnabled(false);
        this.btnRemoveColumn.setToolTipText(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.RemoveColumns"));
        this.btnRemoveAllColumns = new JButton(this.configuration.getIcon("MOVE_LEFT_ALL_S_ICON", 16));
        this.btnRemoveAllColumns.addActionListener(new RemoveAllColumnsActionListener());
        this.btnRemoveAllColumns.setEnabled(false);
        this.btnRemoveAllColumns.setToolTipText(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.RemoveAllColumns"));
        JPanel jpButtons = new JPanel();
        jpButtons.setLayout(new BoxLayout(jpButtons, 3));
        jpButtons.add(this.btnAddColumn);
        jpButtons.add(this.btnAddAllColumns);
        jpButtons.add(this.btnRemoveColumn);
        jpButtons.add(this.btnRemoveAllColumns);
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(jpButtons);
        verticalBox.add(Box.createVerticalGlue());
        JPanel selectedColumnsPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[grow]0", "0[]0"));
        selectedColumnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Selected")));
        this.selectedColumnsListModel = new SelectedColumnsModel();
        this.selectedColumnsList = new JList(this.selectedColumnsListModel);
        this.selectedColumnsList.setCellRenderer(new SelectedColumnsRenderer());
        this.selectedColumnsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveColumn.setEnabled(false);
                } else {
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveColumn.setEnabled(true);
                }
            }
        });
        this.selectedColumnsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveColumn.doClick();
                }
            }
        });
        JScrollPane selectedColumnsSPane = new JScrollPane(this.selectedColumnsList);
        this.selectedColumnsList.setEnabled(false);
        selectedColumnsPanel.add((Component)selectedColumnsSPane, new CC().grow());
        pCenterPanel.add((Component)availableColumnsPanel, new CC().width("300:300:").grow());
        pCenterPanel.add((Component)verticalBox, new CC().width("30!"));
        pCenterPanel.add((Component)selectedColumnsPanel, new CC().width("300:300:").grow());
        pPanel.add((Component)pNorthPanel, new CC().growX().dockNorth());
        pPanel.add((Component)pCenterPanel, new CC().grow());
        propertiesPanel.add((Component)pPanel, new CC().grow());
        JPanel defineStoragePanel = new JPanel((LayoutManager)new MigLayout("fill, flowy", "[grow]", "0[grow]0[grow]"));
        defineStoragePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.DefineStorage")));
        JPanel useStorageTmeplatePanel = new JPanel((LayoutManager)new MigLayout("fill", "10[140!]0[grow]"));
        useStorageTmeplatePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.PredefinedStorageTemplates")));
        JPanel defineStorageNorthPanel = new JPanel((LayoutManager)new MigLayout("fill", "[110!]0[grow]0[110!]0[grow]0[110!]0[grow]"));
        JLabel lbSegment = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.UseStorageTemplate"));
        this.cmbSegment = new JComboBox();
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cmbSegment);
        }
        useStorageTmeplatePanel.add(lbSegment);
        useStorageTmeplatePanel.add((Component)this.cmbSegment, new CC().minWidth("100").growX());
        JLabel lbTablespace = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Tablespace"));
        this.cmbTablespace = new JComboBox();
        this.cmbTablespace.addItem(null);
        Iterator tsIt = this.getStorageDesign().getTableSpaceSet().iterator();
        while (tsIt.hasNext()) {
            this.cmbTablespace.addItem(tsIt.next());
        }
        JLabel lbLogging = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Logging"));
        this.cmbLogging = new JComboBox<String>(MaterializedViewLogOraclev9i.loggingItems);
        JLabel lbBufferMode = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.BufferMode"));
        this.cmbBufferMode = new JComboBox<String>(MaterializedViewLogOraclev9i.bufferModeItems);
        JLabel lbPercentFree = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.PercentFree"));
        this.tfPercentFree = new JIntegerField();
        JLabel lbInitrans = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Initrans"));
        this.tfInitrans = new JIntegerField();
        JLabel lbFreelists = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Freelists"));
        this.tfFreelists = new JIntegerField();
        JLabel lbPercentUsed = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.PercentUsed"));
        this.tfPercentUsed = new JIntegerField();
        JLabel lbFreelistGroups = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.FreelistGroups"));
        this.tfFreelistGroups = new JIntegerField();
        defineStorageNorthPanel.add(lbTablespace);
        defineStorageNorthPanel.add((Component)this.cmbTablespace, new CC().minWidth("100").growX().gapRight("10"));
        defineStorageNorthPanel.add(lbPercentFree);
        defineStorageNorthPanel.add((Component)this.tfPercentFree, new CC().gapRight("10").minWidth("100").growX());
        defineStorageNorthPanel.add(lbPercentUsed);
        defineStorageNorthPanel.add((Component)this.tfPercentUsed, new CC().minWidth("100").growX().wrap());
        defineStorageNorthPanel.add(lbLogging);
        defineStorageNorthPanel.add((Component)this.cmbLogging, new CC().gapRight("10").growX());
        defineStorageNorthPanel.add(lbInitrans);
        defineStorageNorthPanel.add((Component)this.tfInitrans, new CC().gapRight("10").growX().wrap());
        defineStorageNorthPanel.add(lbBufferMode);
        defineStorageNorthPanel.add((Component)this.cmbBufferMode, new CC().gapRight("10").growX());
        defineStorageNorthPanel.add(lbFreelists);
        defineStorageNorthPanel.add((Component)this.tfFreelists, new CC().gapRight("10").growX());
        defineStorageNorthPanel.add(lbFreelistGroups);
        defineStorageNorthPanel.add((Component)this.tfFreelistGroups, new CC().growX());
        JPanel extentsPanel = new JPanel((LayoutManager)new MigLayout("fill", "[110!][grow][]"));
        extentsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Extents")));
        JLabel lbInitialExtent = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.InitialExtent"));
        this.tfInitialExtent = new JIntegerField();
        this.cmbInitialExtent = new JComboBox<String>(MaterializedViewLogOraclev9i.units);
        JLabel lbNextExtent = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.NextExtent"));
        this.tfNextExtent = new JIntegerField();
        this.cmbNextExtent = new JComboBox<String>(MaterializedViewLogOraclev9i.units);
        JLabel lbMinExtent = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.MinExtent"));
        this.tfMinExtent = new JIntegerField();
        this.cmbMinExtent = new JComboBox<String>(MaterializedViewLogOraclev9i.units);
        JLabel lbMaxExtent = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.MaxExtent"));
        this.tfMaxExtent = new JIntegerField();
        this.cmbMaxExtent = new JComboBox<String>(MaterializedViewLogOraclev9i.units);
        this.cbUnlimited = new JCheckBox(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Unlimited"));
        JLabel lbPercentIncrease = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.PercentIncrease"));
        this.tfPercentIncrease = new JIntegerField();
        this.cbUnlimited.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.tfMaxExtent.setEnabled(false);
                    MaterializedViewLogPropertyDialogOraclev9i.this.cmbMaxExtent.setEnabled(false);
                } else {
                    MaterializedViewLogPropertyDialogOraclev9i.this.tfMaxExtent.setEnabled(true);
                    MaterializedViewLogPropertyDialogOraclev9i.this.cmbMaxExtent.setEnabled(true);
                }
            }
        });
        extentsPanel.add(lbInitialExtent);
        extentsPanel.add((Component)this.tfInitialExtent, new CC().growX().spanX(3));
        extentsPanel.add((Component)this.cmbInitialExtent, new CC().wrap());
        extentsPanel.add(lbNextExtent);
        extentsPanel.add((Component)this.tfNextExtent, new CC().growX().spanX(3));
        extentsPanel.add((Component)this.cmbNextExtent, new CC().wrap());
        extentsPanel.add(lbMinExtent);
        extentsPanel.add((Component)this.tfMinExtent, new CC().growX().spanX(3));
        extentsPanel.add((Component)this.cmbMinExtent, new CC().wrap());
        extentsPanel.add(lbMaxExtent);
        extentsPanel.add((Component)this.tfMaxExtent, new CC().growX());
        extentsPanel.add(this.cmbMaxExtent);
        extentsPanel.add((Component)this.cbUnlimited, new CC().wrap());
        extentsPanel.add(lbPercentIncrease);
        extentsPanel.add((Component)this.tfPercentIncrease, new CC().growX().spanX(3));
        defineStoragePanel.add((Component)defineStorageNorthPanel, new CC().growX());
        defineStoragePanel.add((Component)extentsPanel, new CC().growX());
        storagePanel.add((Component)defineStoragePanel, new CC().growX());
        storagePanel.add((Component)useStorageTmeplatePanel, new CC().growX());
        JLabel lbPurgeType = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.Type"));
        this.cmbPurge = new JComboBox<String>(MaterializedViewLogOraclev9i.purgeItems);
        JLabel lblStartWith = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.StartWith"));
        this.tfStartWith = new JTextField();
        this.tfStartWith.setEnabled(false);
        JLabel lblNext = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.Next"));
        this.tfNext = new JTextField();
        this.tfNext.setEnabled(false);
        JLabel lblRepeatInterval = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.RepeatInterval"));
        this.tfRepeatInterval = new JTextField();
        this.tfRepeatInterval.setEnabled(false);
        this.cmbPurge.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MaterializedViewLogPropertyDialogOraclev9i.this.cmbPurge.getSelectedItem() != null) {
                    if (MaterializedViewLogPropertyDialogOraclev9i.this.cmbPurge.getSelectedItem().equals("DEFERRED")) {
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfStartWith.setEnabled(true);
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfNext.setEnabled(true);
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfRepeatInterval.setEnabled(true);
                    } else {
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfStartWith.setEnabled(false);
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfNext.setEnabled(false);
                        MaterializedViewLogPropertyDialogOraclev9i.this.tfRepeatInterval.setEnabled(false);
                    }
                }
            }
        });
        JPanel prPanel = new JPanel((LayoutManager)new MigLayout("fill", "grow"));
        JPanel prNorthPanel = new JPanel((LayoutManager)new MigLayout("fill", "[110!]0[grow]0[110!]0[grow]"));
        prNorthPanel.add((Component)lbPurgeType, new CC());
        prNorthPanel.add((Component)this.cmbPurge, new CC().growX().wrap());
        prNorthPanel.add(lblStartWith);
        prNorthPanel.add((Component)this.tfStartWith, new CC().growX().wrap());
        prNorthPanel.add(lblNext);
        prNorthPanel.add((Component)this.tfNext, new CC().growX().wrap());
        prNorthPanel.add(lblRepeatInterval);
        prNorthPanel.add((Component)this.tfRepeatInterval, new CC().growX());
        prPanel.add((Component)prNorthPanel, new CC().growX().dockNorth());
        purgePanel.add((Component)prPanel, new CC().grow());
        JLabel lbRefresh = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.Type"));
        this.cmbRefresh = new JComboBox<String>(MaterializedViewLogOraclev9i.refreshItems);
        JLabel lblStagingLog = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev9i.StagingLog"));
        this.tfStagingLog = new JTextField();
        JPanel rPanel = new JPanel((LayoutManager)new MigLayout("fill", "grow"));
        JPanel rNorthPanel = new JPanel((LayoutManager)new MigLayout("fill", "[110!]0[grow]0[110!]0[grow]"));
        rNorthPanel.add((Component)lbRefresh, new CC());
        rNorthPanel.add((Component)this.cmbRefresh, new CC().growX().wrap());
        rNorthPanel.add(lblStagingLog);
        rNorthPanel.add((Component)this.tfStagingLog, new CC().growX());
        rPanel.add((Component)rNorthPanel, new CC().growX().dockNorth());
        refreshPanel.add((Component)rPanel, new CC().grow());
        centerPanel.add((Component)tabPane, new CC().grow());
        this.general.add((Component)northPanel, new CC().dockNorth());
        this.general.add((Component)centerPanel, new CC().grow());
    }

    private void initNotes() {
        this.notes.removeAll();
        this.notes.setLayout((LayoutManager)new MigLayout("fill", "grow"));
        this.taNotes = new JTextArea();
        JScrollPane spNotes = new JScrollPane(this.taNotes);
        this.taNotes.setLineWrap(true);
        this.notes.add((Component)spNotes, new CC().grow());
    }

    private void initComments() {
        this.comments.removeAll();
        this.comments.setLayout((LayoutManager)new MigLayout("fill, flowy", "[grow]", "[][grow]"));
        JLabel lbComments = new JLabel(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.Comments"));
        this.taComments = new JTextArea();
        this.spComments = new JScrollPane(this.taComments);
        this.taComments.setLineWrap(true);
        this.comments.add(lbComments);
        this.comments.add((Component)this.spComments, new CC().grow());
    }

    @Override
    public void initProperties() {
        this.initCaption(this.materializedViewLog.getName());
        this.tfName.setText(this.materializedViewLog.getName());
        String masterTableName = "";
        if (this.materializedViewLog.getTableProxy() != null) {
            masterTableName = this.materializedViewLog.getTableProxy().getLongName();
        }
        this.cmbMasterTable.setSelectedItem(masterTableName);
        this.cmbMasterTable.setEnabled(masterTableName.equals(""));
        this.cmbRowIDLogged.setSelectedItem("YES".equalsIgnoreCase(this.materializedViewLog.getRowIDLogged()) ? "YES" : "NO");
        this.cmbPrimaryKeyLogged.setSelectedItem("YES".equalsIgnoreCase(this.materializedViewLog.getPkLogged()) ? "YES" : "NO");
        this.cmbNewValues.setSelectedItem("YES".equalsIgnoreCase(this.materializedViewLog.getNewValues()) ? "Including" : "Excluding");
        this.cmbCache.setSelectedItem(this.materializedViewLog.getCache());
        this.cmbParallelDegree.setSelectedItem(this.materializedViewLog.getParallel());
        this.tfDegree.setText(this.materializedViewLog.getDegree());
        this.cmbSequenceLogged.setSelectedItem("YES".equalsIgnoreCase(this.materializedViewLog.getSequenceLogged()) ? "YES" : "NO");
        this.cmbObjectIDLogged.setSelectedItem("YES".equalsIgnoreCase(this.materializedViewLog.getObjectIDLogged()) ? "YES" : "NO");
        this.cbCommitSCN.setSelected(this.materializedViewLog.isCommitSCN());
        ArrayList<ColumnProxyOracle> tempL = new ArrayList<ColumnProxyOracle>();
        String cols = this.materializedViewLog.getColumns();
        for (ColumnProxyOracle c : this.availableColumnsFilterModel.filterItems) {
            if (!cols.contains(c.getObjectID())) continue;
            tempL.add(c);
            this.selectedColumnsListModel.addElement(c);
        }
        Iterator it = tempL.iterator();
        while (it.hasNext()) {
            this.availableColumnsFilterModel.remove(it.next());
        }
        if (this.availableColumnsFilterModel.getSize() > 0) {
            this.availableColumnsList.setEnabled(true);
            this.columnsFilter.setEnabled(true);
            this.btnAddAllColumns.setEnabled(true);
        } else {
            this.availableColumnsList.setEnabled(false);
            this.columnsFilter.setEnabled(false);
            this.btnAddAllColumns.setEnabled(false);
        }
        if (this.selectedColumnsListModel.getSize() > 0) {
            this.selectedColumnsList.setEnabled(true);
            this.btnRemoveAllColumns.setEnabled(true);
        } else {
            this.selectedColumnsList.setEnabled(false);
            this.btnRemoveAllColumns.setEnabled(false);
        }
        this.cmbTablespace.setSelectedItem(this.materializedViewLog.getTablespace());
        this.cmbLogging.setSelectedItem("YES".equalsIgnoreCase(this.materializedViewLog.getLogging()) ? "YES" : "NO");
        this.cmbBufferMode.setSelectedItem(this.materializedViewLog.getBufferPool());
        this.tfPercentFree.setText(this.materializedViewLog.getPercentFree());
        this.tfInitrans.setText(this.materializedViewLog.getInitrans());
        this.tfFreelists.setText(this.materializedViewLog.getFreelists());
        this.tfPercentUsed.setText(this.materializedViewLog.getPercentUsed());
        this.tfFreelistGroups.setText(this.materializedViewLog.getFreelistGroups());
        this.tfInitialExtent.setText(this.materializedViewLog.getInitialExtent());
        this.cmbInitialExtent.setSelectedItem(this.materializedViewLog.getInitialExtentUnit());
        this.tfMinExtent.setText(this.materializedViewLog.getMinExtent());
        this.cmbMinExtent.setSelectedItem(this.materializedViewLog.getMinExtentUnit());
        this.tfPercentIncrease.setText(this.materializedViewLog.getPercentIncrease());
        this.tfNextExtent.setText(this.materializedViewLog.getNextExtent());
        this.cmbNextExtent.setSelectedItem(this.materializedViewLog.getNextExtentUnit());
        this.tfMaxExtent.setText(this.materializedViewLog.getMaxExtent());
        this.cmbMaxExtent.setSelectedItem(this.materializedViewLog.getMaxExtentUnit());
        this.cbUnlimited.setSelected(this.materializedViewLog.isMaxExtentUnlimited());
        this.cmbSegment.setSelectedItem(this.materializedViewLog.getSegment());
        this.cmbPurge.setSelectedItem(this.materializedViewLog.getPurgeType());
        this.tfStartWith.setText(this.materializedViewLog.getPurgeSWExpression());
        this.tfNext.setText(this.materializedViewLog.getPurgeNextExpression());
        this.tfRepeatInterval.setText(this.materializedViewLog.getPurgeRIExpression());
        this.cmbRefresh.setSelectedItem(this.materializedViewLog.getRefreshType());
        this.tfStagingLog.setText(this.materializedViewLog.getRefreshSLName());
        this.taNotes.setText(this.materializedViewLog.getComment());
        this.taComments.setText(this.materializedViewLog.getNotes());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setProperties() {
        if (this.materializedViewLog != null) {
            void var2_3;
            String selectedtableName = (String)this.cmbMasterTable.getSelectedItem();
            Object var2_2 = null;
            if (selectedtableName != null && !selectedtableName.equals("")) {
                for (TableProxyOracle tableProxyOracle : this.tablesList) {
                    if (tableProxyOracle.getLongName().equals(selectedtableName)) break;
                }
            }
            this.materializedViewLog.setTableProxy((TableProxyOracle)var2_3);
            if (var2_3 != null) {
                this.materializedViewLog.setName(var2_3.getName());
            }
            this.materializedViewLog.setRowIDLogged((String)this.cmbRowIDLogged.getSelectedItem());
            this.materializedViewLog.setPkLogged((String)this.cmbPrimaryKeyLogged.getSelectedItem());
            this.materializedViewLog.setNewValues("Including".equalsIgnoreCase((String)this.cmbNewValues.getSelectedItem()) ? "YES" : "NO");
            this.materializedViewLog.setCache((String)this.cmbCache.getSelectedItem());
            this.materializedViewLog.setParallel((String)this.cmbParallelDegree.getSelectedItem());
            this.materializedViewLog.setDegree(this.tfDegree.getText());
            this.materializedViewLog.setSequenceLogged((String)this.cmbSequenceLogged.getSelectedItem());
            this.materializedViewLog.setObjectIDLogged((String)this.cmbObjectIDLogged.getSelectedItem());
            this.materializedViewLog.setCommitSCN(this.cbCommitSCN.isSelected());
            Object cols = "";
            Object columnNames = "";
            Iterator it = this.selectedColumnsListModel.items.iterator();
            boolean first = true;
            while (it.hasNext()) {
                ColumnProxyOracle col = (ColumnProxyOracle)it.next();
                if (first) {
                    cols = col.getObjectID();
                    columnNames = col.getName();
                    first = false;
                    continue;
                }
                cols = (String)cols + "," + col.getObjectID();
                columnNames = (String)columnNames + "," + col.getName();
            }
            this.materializedViewLog.setColumns((String)cols);
            this.materializedViewLog.setColumnNames((String)columnNames);
            this.materializedViewLog.getColumnProxiesList().clear();
            this.materializedViewLog.getColumnProxiesList().addAll(this.currentNonSelectedColumnsList);
            this.materializedViewLog.setLogging((String)this.cmbLogging.getSelectedItem());
            Object o = this.cmbSegment.getSelectedItem();
            if (o != null) {
                SegmentOracle so = (SegmentOracle)this.cmbSegment.getSelectedItem();
                this.materializedViewLog.setSegment(so);
            } else {
                this.materializedViewLog.setSegment(null);
                this.materializedViewLog.setTablespace((TableSpaceOracle)this.cmbTablespace.getSelectedItem());
                this.materializedViewLog.setBufferPool((String)this.cmbBufferMode.getSelectedItem());
                this.materializedViewLog.setFreelists(this.tfFreelists.getText());
                this.materializedViewLog.setFreelistGroups(this.tfFreelistGroups.getText());
                this.materializedViewLog.setPercentFree(this.tfPercentFree.getText());
                this.materializedViewLog.setPercentUsed(this.tfPercentUsed.getText());
                this.materializedViewLog.setInitrans(this.tfInitrans.getText());
                this.materializedViewLog.setInitialExtent(this.tfInitialExtent.getText());
                this.materializedViewLog.setInitialExtentUnit((String)this.cmbInitialExtent.getSelectedItem());
                this.materializedViewLog.setNextExtent(this.tfNextExtent.getText());
                this.materializedViewLog.setNextExtentUnit((String)this.cmbNextExtent.getSelectedItem());
                this.materializedViewLog.setMinExtent(this.tfMinExtent.getText());
                this.materializedViewLog.setMinExtentUnit((String)this.cmbMinExtent.getSelectedItem());
                this.materializedViewLog.setMaxExtent(this.tfMaxExtent.getText());
                this.materializedViewLog.setMaxExtentUnit((String)this.cmbMaxExtent.getSelectedItem());
                this.materializedViewLog.setMaxExtentUnlimited(this.cbUnlimited.isSelected());
                this.materializedViewLog.setPercentIncrease(this.tfPercentIncrease.getText());
            }
            this.materializedViewLog.setPurgeType((String)this.cmbPurge.getSelectedItem());
            this.materializedViewLog.setPurgeSWExpression(this.tfStartWith.getText());
            this.materializedViewLog.setPurgeNextExpression(this.tfNext.getText());
            this.materializedViewLog.setPurgeRIExpression(this.tfRepeatInterval.getText());
            this.materializedViewLog.setRefreshType((String)this.cmbRefresh.getSelectedItem());
            this.materializedViewLog.setRefreshSLName(this.tfStagingLog.getText());
            this.materializedViewLog.setComment(this.getCommentsList().getText());
            this.materializedViewLog.setNotes(this.taNotes.getText());
        }
    }

    protected int getMinimumWidth() {
        return this.minWidth;
    }

    protected int getMinimumHeight() {
        return this.mMinHeight;
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    private void setFilterIcon() {
        if (this.cmbMasterTable != null) {
            if (this.cmbMasterTable.filterUsed) {
                this.lbFilter.setIcon((ImageIcon)this.configuration.getIcon("STOP_FILTER_ICON"));
                this.lbFilter.setToolTipText(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.ComboBoxIsFiltered"));
            } else {
                this.lbFilter.setIcon((ImageIcon)this.configuration.getIcon("START_FILTER_ICON"));
                this.lbFilter.setToolTipText(Messages.getString("MaterializedViewLogPropertyDialogOraclev10g.ComboBoxIsNotFiltered"));
            }
        }
    }

    private class ColumnsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            MaterializedViewLogPropertyDialogOraclev9i.this.currentNonSelectedColumnsList.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
            Collections.sort(this.filterItems, MaterializedViewLogPropertyDialogOraclev9i.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            MaterializedViewLogPropertyDialogOraclev9i.this.currentNonSelectedColumnsList.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = MaterializedViewLogPropertyDialogOraclev9i.this.columnsFilter.getText();
            for (int i = 0; i < MaterializedViewLogPropertyDialogOraclev9i.this.currentNonSelectedColumnsList.size(); ++i) {
                ColumnProxyOracle col = (ColumnProxyOracle)MaterializedViewLogPropertyDialogOraclev9i.this.currentNonSelectedColumnsList.get(i);
                if (MaterializedViewLogPropertyDialogOraclev9i.match(col.getName(), term)) {
                    this.filterItems.add(MaterializedViewLogPropertyDialogOraclev9i.this.currentNonSelectedColumnsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, MaterializedViewLogPropertyDialogOraclev9i.this.toStringComparator);
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, MaterializedViewLogPropertyDialogOraclev9i.this.toStringComparator);
            MaterializedViewLogPropertyDialogOraclev9i.this.currentNonSelectedColumnsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            MaterializedViewLogPropertyDialogOraclev9i.this.currentNonSelectedColumnsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    private class SelectedColumnsModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();

        private SelectedColumnsModel() {
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        private List getItems() {
            return this.items;
        }

        @Override
        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        private void clear() {
            this.items.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.items.contains(element);
        }

        private void addElement(Object o) {
            this.items.add(o);
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        private void removeElement(Object o) {
            this.items.remove(o);
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    class FilteredColumnsJList
    extends JList {
        public FilteredColumnsJList() {
            this.setModel((ListModel)new ColumnsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof ColumnsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class AllColumnsRenderer
    extends JLabel
    implements ListCellRenderer {
        private AllColumnsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColumnProxyOracle col = (ColumnProxyOracle)value;
            this.setText(col.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ColumnsFilterListener
    implements DocumentListener {
        private ColumnsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.refilter();
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object o;
                ArrayList<Object> removalList = new ArrayList<Object>();
                int[] selectedColumnsIndices = MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.getSelectedIndices();
                for (int i = 0; i < selectedColumnsIndices.length; ++i) {
                    o = MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.getElementAt(selectedColumnsIndices[i]);
                    if (MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsListModel.contains(o)) continue;
                    MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsListModel.addElement(o);
                    removalList.add(o);
                }
                Iterator it = removalList.iterator();
                while (it.hasNext()) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.remove(it.next());
                }
                if (MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.getSize() > 0) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.setSelectedIndex(-1);
                    o = MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.getElementAt(selectedColumnsIndices[0]);
                    if (o == null) {
                        MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.setSelectedIndex(selectedColumnsIndices[0] - 1);
                    } else {
                        MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.setSelectedIndex(selectedColumnsIndices[0]);
                    }
                } else {
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnAddColumn.setEnabled(false);
                }
                if (MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.getSize() > 0) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.setEnabled(true);
                    MaterializedViewLogPropertyDialogOraclev9i.this.columnsFilter.setEnabled(true);
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnAddAllColumns.setEnabled(true);
                } else {
                    MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.setEnabled(false);
                    MaterializedViewLogPropertyDialogOraclev9i.this.columnsFilter.setEnabled(false);
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnAddAllColumns.setEnabled(false);
                }
                if (MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsListModel.getSize() > 0) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.setEnabled(true);
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveAllColumns.setEnabled(true);
                } else {
                    MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.setEnabled(false);
                    MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveAllColumns.setEnabled(false);
                }
            }
            catch (Exception ex) {
                LOGGER.error("MaterializedViewLogPropertyDialogOraclev10g ", ex);
            }
        }
    }

    private class AddAllColumnsActionListener
    implements ActionListener {
        private AddAllColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.getSize(); ++i) {
                Object o = MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.getElementAt(i);
                if (MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsListModel.contains(o)) continue;
                MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsListModel.addElement(o);
            }
            MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.clear();
            MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.setEnabled(true);
            MaterializedViewLogPropertyDialogOraclev9i.this.btnAddColumn.setEnabled(false);
            MaterializedViewLogPropertyDialogOraclev9i.this.btnAddAllColumns.setEnabled(false);
            MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveAllColumns.setEnabled(true);
            MaterializedViewLogPropertyDialogOraclev9i.this.columnsFilter.setEnabled(false);
        }
    }

    private class RemoveColumnActionListener
    implements ActionListener {
        private RemoveColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList removalList = new ArrayList();
                ArrayList selectedObjects = new ArrayList();
                int[] selectedSubviewsIndices = MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndices();
                for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                    Object o = MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                    selectedObjects.add(o);
                    if (((ColumnsFilterModel)MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.getModel()).contains(o)) continue;
                    ((ColumnsFilterModel)MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.getModel()).add(o);
                    removalList.add(o);
                }
                Iterator it = removalList.iterator();
                while (it.hasNext()) {
                    MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsListModel.removeElement(it.next());
                }
            }
            catch (Exception ex) {
                LOGGER.error(" Standard Report Config dialog - Error when deselecting subview ", ex);
            }
        }
    }

    private class RemoveAllColumnsActionListener
    implements ActionListener {
        private RemoveAllColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.getModel().getSize(); ++i) {
                ColumnProxyOracle col = (ColumnProxyOracle)MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsList.getModel().getElementAt(i);
                if (MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.contains(col)) continue;
                MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.add(col);
            }
            MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsFilterModel.setInitialState();
            MaterializedViewLogPropertyDialogOraclev9i.this.selectedColumnsListModel.clear();
            MaterializedViewLogPropertyDialogOraclev9i.this.btnAddAllColumns.setEnabled(true);
            MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveColumn.setEnabled(false);
            MaterializedViewLogPropertyDialogOraclev9i.this.btnRemoveAllColumns.setEnabled(false);
            MaterializedViewLogPropertyDialogOraclev9i.this.columnsFilter.setEnabled(true);
            ((ColumnsFilterModel)MaterializedViewLogPropertyDialogOraclev9i.this.availableColumnsList.getModel()).refilter();
        }
    }

    private class SelectedColumnsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SelectedColumnsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColumnProxyOracle col = (ColumnProxyOracle)value;
            this.setText(col.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

