/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DimensionOraclev9iPropertyDialog
extends AbstractOraclePropertyDialog {
    private DimensionOracle dimension;
    private JComboBox cbOwner;

    public DimensionOraclev9iPropertyDialog(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.dimension = (DimensionOracle)object;
        this.setHeight(110);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 420;
    }

    @Override
    public String getCaption() {
        return Messages.getString("DimensionOraclev9iPropertyDialog.DimensionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("DimensionOraclev9iPropertyDialog.User"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.dimension.getName());
        this.tfName.setText(this.dimension.getName());
        this.cbOwner.setSelectedItem(this.dimension.getUser());
        this.getCommentsList().insert(this.dimension.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.dimension != null) {
            this.dimension.setUser((UserOracle)this.cbOwner.getSelectedItem());
            this.dimension.setName(this.tfName.getText());
            this.dimension.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbOwner.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }
}

