/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ContextOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class ContextPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private ContextOraclev9i context;
    protected JTextField tfNamespace;
    protected JTextField tfPackage;
    protected JComboBox cbInitialized;
    protected JComboBox cbAccessedGlobally;

    public ContextPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.context = (ContextOraclev9i)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ContextPropertyDialogOraclev9i.ContextProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initNamespace();
        this.initPackage();
        this.initInitialized();
        this.initAccessedGlobally();
        this.general.remove(this.lbName);
        this.general.remove(this.tfName);
    }

    private void initNamespace() {
        JLabel label = new JLabel(Messages.getString("ContextPropertyDialogOraclev9i.Namespace"));
        this.general.add(label);
        this.tfNamespace = new JTextField("", 26);
        this.general.add(this.tfNamespace);
        this.setLabelConstraints(label, 20);
        this.setObjectConstraints(this.tfNamespace, 20);
    }

    private void initPackage() {
        JLabel label = new JLabel(Messages.getString("ContextPropertyDialogOraclev9i.Package"));
        this.general.add(label);
        this.tfPackage = new JTextField("", 26);
        this.general.add(this.tfPackage);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfPackage, 50);
    }

    private void initInitialized() {
        JLabel label = new JLabel(Messages.getString("ContextPropertyDialogOraclev9i.Initialized"));
        this.general.add(label);
        String[] initializedOptions = new String[]{NONE, ContextOraclev9i.initializedChoices[1], ContextOraclev9i.initializedChoices[2]};
        this.cbInitialized = new JComboBox<String>(initializedOptions);
        this.setBG(this.cbInitialized);
        this.cbInitialized.addActionListener(new InitializedListener());
        this.cbInitialized.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitialized);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbInitialized, 80);
    }

    private void initAccessedGlobally() {
        JLabel label = new JLabel(Messages.getString("ContextPropertyDialogOraclev9i.AccessedGlobally"));
        this.general.add(label);
        this.cbAccessedGlobally = new JComboBox<String>(YES_NO);
        this.setBG(this.cbAccessedGlobally);
        this.cbAccessedGlobally.addActionListener(new AccessedGloballyListener());
        this.cbAccessedGlobally.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAccessedGlobally);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbAccessedGlobally, 110);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.context.getName());
        this.tfName.setText(this.context.getName());
        this.tfNamespace.setText(this.context.getNamespace());
        this.tfPackage.setText(this.context.getPackage());
        this.cbInitialized.setSelectedItem(ContextPropertyDialogOraclev9i.translateNoneYesNoForDisplay(this.context.getInitialized()));
        this.cbAccessedGlobally.setSelectedItem(ContextPropertyDialogOraclev9i.translateYesNoForDisplay(this.context.getAccessedGlobally()));
        this.taComments.setText(this.context.getComment());
    }

    @Override
    protected void setProperties() {
        if (this.context != null) {
            this.context.setName(this.tfNamespace.getText());
            this.context.setNamespace(this.tfNamespace.getText());
            this.context.setPackage(this.tfPackage.getText());
            this.context.setInitialized(ContextPropertyDialogOraclev9i.translateNoneYesNoForStorage((String)this.cbInitialized.getSelectedItem()));
            this.context.setAccessedGlobally(ContextPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbAccessedGlobally.getSelectedItem()));
            this.context.setComment(this.taComments.getText());
        }
    }

    @Override
    protected boolean canExit() {
        String newName = this.tfNamespace.getText().trim();
        if ("".equalsIgnoreCase(newName)) {
            MessageDialogs.showErrorMessage(this, Messages.getString("ContextPropertyDialog.NameCanNotBeEmpty"));
            this.tfNamespace.requestFocus();
            return false;
        }
        if (!this.allowName(newName)) {
            MessageDialogs.showErrorMessage(this, MessageFormat.format(Messages.getString("ContextPropertyDialog.NameNotUnique"), newName));
            this.tfNamespace.requestFocus();
            return false;
        }
        return true;
    }

    private class InitializedListener
    implements ActionListener {
        private InitializedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContextPropertyDialogOraclev9i.this.cbAccessedGlobally.setEnabled(((String)ContextPropertyDialogOraclev9i.this.cbInitialized.getSelectedItem()).equals(AbstractPropertyDialog.NONE));
        }
    }

    private class AccessedGloballyListener
    implements ActionListener {
        private AccessedGloballyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContextPropertyDialogOraclev9i.this.cbInitialized.setEnabled(((String)ContextPropertyDialogOraclev9i.this.cbAccessedGlobally.getSelectedItem()).equals(AbstractPropertyDialog.NO));
        }
    }
}

