/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.TableProxyOraclev12c;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TablePropertyDialogOraclev10g;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.gui.swing.JListUtils;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class TablePropertyDialogOraclev11g
extends TablePropertyDialogOraclev10g {
    private static final String IN_MEMORY_TAB_NAME = Messages.getString("TablePropertyDialogOracle.InMemoryProperties");
    private static final String RANGE_INTERVAL_TAB_NAME = Messages.getString("PartitionPropertyTabOraclev11g.RangeIntervalClause");
    private int mainPanelMinHeight = 650;
    private JComboBox cbCompressionType;
    private JPanel inMemoryPropsPanel;
    private JPanel rangeIntervalPanel;
    private JComboBox cbInMemory;
    private JComboBox cbInMemoryCompression;
    private JComboBox cbInMemoryPriority;
    private JComboBox cbInMemoryDistribute;
    private JComboBox cbInMemoryDuplicate;
    private JComboBox cbRefConstraint;
    private JPositiveIntegerField ifSystemPartitions;
    private JSearchTextField allIntervalExpressionTablespacesFilterBox;
    private JSearchTextField selectedIntervalExpressionTablespacesFilterBox;
    private JButton bnAddIntervalExpressionTablespaces;
    private JButton bnRemoveIntervalExpressionTablespaces;
    private ArrayList currentAll_IntervalExpressionTablespacesList;
    private ArrayList currentSelected_IntervalExpressionTablespacesList;
    private DefaultListModel allIntervalExpressionTablespacesModel;
    private DefaultListModel selectedIntervalExpressionTablespacesModel;
    private JList allIntervalExpressionsTablespacesList;
    private JList selectedIntervalExpressionsTablespacesList;
    private RSyntaxTextArea taInterval;
    private int intervalTabIndex;
    private JScrollPane allIntervalExpressionTablespacesSP;
    private JScrollPane selectedIntervalExpressionTablespacesSP;

    public TablePropertyDialogOraclev11g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        super.initTree(root);
        JLabel lblCompressionType = new JLabel(Messages.getString("TablePropertyDialogOracle.CompressionType"));
        String[] compressionTypeValues = this.storageDesign instanceof StorageDesignOraclev12c ? TableProxyOraclev11g.getCompressionTypeValues12c() : TableProxyOraclev11g.getCompressionTypeValues();
        this.cbCompressionType = new JComboBox<String>(compressionTypeValues);
        this.cbDataSegmentCompression.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TablePropertyDialogOraclev11g.this.cbCompressionType.setEnabled(TablePropertyDialogOraclev11g.this.cbDataSegmentCompression.getSelectedItem().equals(AbstractPropertyDialog.YES));
            }
        });
        this.pnDataCompression.remove(this.lblCache);
        this.pnDataCompression.remove(this.cbCache);
        this.pnDataCompression.add((Component)lblCompressionType, new CC().width("130!"));
        this.pnDataCompression.add((Component)this.cbCompressionType, new CC().width("100!"));
        JPanel pn1 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]80[]0[]", "0[]0"));
        pn1.add((Component)this.lblCache, new CC().width(this.defaultLabelWidth));
        pn1.add((Component)this.cbCache, new CC().width("60!"));
        this.pnGeneralGrid.add(pn1);
        JLabel lblAllowAnySchema = new JLabel(Messages.getString("TablePropertyDialogOracle.AllowAnySchema"));
        this.cbAllowAnySchema = new JComboBox<String>(EMPTY_YES_NO);
        JLabel lblAllowNonSchema = new JLabel(Messages.getString("TablePropertyDialogOracle.AllowNonSchema"));
        this.cbAllowNonSchema = new JComboBox<String>(EMPTY_YES_NO);
        JPanel pn2 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]120[]0[]", "0[]0"));
        pn2.add((Component)lblAllowAnySchema, new CC().width(this.defaultLabelWidth));
        pn2.add((Component)this.cbAllowAnySchema, new CC().width("60!"));
        pn2.add((Component)lblAllowNonSchema, new CC().width("110!"));
        pn2.add((Component)this.cbAllowNonSchema, new CC().width("60!"));
        this.pnXMLTypePropertiesGrid.add(pn2);
        this.cbPartType.removeActionListener(this.partitionTypeListener);
        this.cbPartType.removeAllItems();
        Iterator<String> it = Arrays.asList(PartitionListOraclev11g.getPartitionTypes()).iterator();
        while (it.hasNext()) {
            this.cbPartType.addItem(it.next());
        }
        this.cbPartType.addActionListener(new PartitionTypeListener());
        this.pnPartitioningGrid.remove(this.pnUseSubpartitionsStorageTemplate);
        this.pnHashPQuantity.removeAll();
        JLabel lblSubPartType = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.SubpartitionType"));
        this.cbSubpartType = new JComboBox<String>(PartitionListOraclev11g.getSubpartitionTypes());
        this.cbSubpartType.setEnabled(false);
        this.cbSubpartType.addActionListener(new SubpartitionTypeListener());
        JPanel pn3 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]50[]0[]", "0[]0"));
        pn3.add((Component)lblSubPartType, new CC().width(this.defaultLabelWidth));
        pn3.add((Component)this.cbSubpartType, new CC().width("60!"));
        pn3.add((Component)this.lblUseSubpartitionsStorageTemplate, new CC().width("150!"));
        pn3.add((Component)this.cbUseSubpartitionsStorageTemplate, new CC().width("60!"));
        this.pnPartitioningGrid.add(pn3);
        this.pnHashPQuantity.add((Component)this.lblHashPQuantity, new CC().width(this.defaultLabelWidth));
        this.pnHashPQuantity.add((Component)this.ifHashPQuantity, new CC().width("60!"));
        this.pnHashPQuantity.add((Component)this.lblSubPartQuantity, new CC().width("150!"));
        this.pnHashPQuantity.add((Component)this.ifSubPartQuantity, new CC().width("60!"));
        this.pnPartitioningGrid.add(this.pnHashPQuantity);
        JLabel lblRefConstraint = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.ReferenceConstraint"));
        this.cbRefConstraint = new JComboBox<Object>(this.getRefConstraints().toArray());
        this.cbRefConstraint.setEnabled(false);
        JLabel lblSysPartitions = new JLabel(Messages.getString("PartitionPropertyTabOraclev11g.SystemPartitions"));
        this.ifSystemPartitions = new JPositiveIntegerField();
        this.ifSystemPartitions.setEnabled(false);
        JPanel pn4 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]50[]0[grow]", "0[]0"));
        pn4.add((Component)lblSysPartitions, new CC().width(this.defaultLabelWidth));
        pn4.add((Component)this.ifSystemPartitions, new CC().width("60!"));
        pn4.add((Component)lblRefConstraint, new CC().width("150!"));
        pn4.add((Component)this.cbRefConstraint, new CC().minWidth("150").growX());
        this.pnPartitioningGrid.add(pn4);
        this.cbUseSubpartitionsStorageTemplate.removeActionListener(this.partitionTypeListener1);
        this.cbUseSubpartitionsStorageTemplate.addActionListener(new PartitionTypeListener());
        JLabel lblLobStorageType = new JLabel(Messages.getString("TablePropertyDialogOracle.LobStorageType"));
        this.cbLobStorageType = new JComboBox<String>(TableProxyOraclev11g.getLobStorageTypeValues());
        JPanel pn5 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]50[]0[]", "0[]0"));
        pn5.add((Component)lblLobStorageType, new CC().width(this.defaultLabelWidth));
        pn5.add((Component)this.cbLobStorageType, new CC().width("100!"));
        pn5.add((Component)new JLabel(), new CC().width("10!"));
        pn5.add((Component)new JLabel(), new CC().width("10!"));
        this.pnXMLTypePropertiesGrid.add(pn5);
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            this.addToTree(root, this.getInMemoryPanel());
        }
        this.addToTree(this.partitioningNode, this.getRangeIntervalPanel());
    }

    private JPanel getRangeIntervalPanel() {
        if (this.rangeIntervalPanel == null) {
            this.rangeIntervalPanel = this.createPage(RANGE_INTERVAL_TAB_NAME);
            JPanel pn0 = new JPanel((LayoutManager)new MigLayout("", "0[]0[grow]0", "0[grow]0"));
            JLabel lblIntervalExpression = new JLabel(Messages.getString("TablePropertyDialogOraclev11g.IntervalExpression"));
            this.taInterval = new RSyntaxTextArea();
            this.taInterval.setLineWrap(true);
            this.taInterval.setEnabled(false);
            JScrollPane spIntervalExpression = new JScrollPane((Component)this.taInterval);
            spIntervalExpression.setPreferredSize(new Dimension(395, 200));
            pn0.add((Component)lblIntervalExpression, new CC().width(this.defaultLabelWidth));
            pn0.add((Component)spIntervalExpression, new CC().grow());
            JPanel pnTablespaces = new JPanel((LayoutManager)new MigLayout("", "0[grow]0[32!]0[grow]0", "0[grow]0"));
            pnTablespaces.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev11g.Tablespaces")));
            JPanel allJP = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "10[]5[grow]0"));
            allJP.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev11g.All")));
            this.currentAll_IntervalExpressionTablespacesList = new ArrayList();
            this.allIntervalExpressionTablespacesFilterBox = new JSearchTextField(false, true, Messages.getString("TablePropertyDialogOraclev11g.Name"));
            this.allIntervalExpressionTablespacesFilterBox.setEnabled(false);
            this.allIntervalExpressionTablespacesFilterBox.setPreferredSize(new Dimension(150, 20));
            this.allIntervalExpressionTablespacesFilterBox.getDocument().addDocumentListener(new FilterAllIntervalExpressionTablespacesListener());
            this.allIntervalExpressionTablespacesModel = new DefaultListModel();
            this.allIntervalExpressionsTablespacesList = new JList(this.allIntervalExpressionTablespacesModel);
            this.allIntervalExpressionsTablespacesList.setBorder(new EmptyBorder(3, 3, 3, 3));
            this.allIntervalExpressionsTablespacesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        TablePropertyDialogOraclev11g.this.bnAddIntervalExpressionTablespaces.doClick();
                    }
                }
            });
            ListSelectionModel allIntervalExpressionTablespacesListSelectionModel = this.allIntervalExpressionsTablespacesList.getSelectionModel();
            allIntervalExpressionTablespacesListSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (TablePropertyDialogOraclev11g.this.isEditable() && !e.getValueIsAdjusting()) {
                        if (TablePropertyDialogOraclev11g.this.allIntervalExpressionsTablespacesList.getSelectedIndex() == -1) {
                            TablePropertyDialogOraclev11g.this.bnAddIntervalExpressionTablespaces.setEnabled(false);
                        } else {
                            TablePropertyDialogOraclev11g.this.bnAddIntervalExpressionTablespaces.setEnabled(true);
                        }
                    }
                }
            });
            this.allIntervalExpressionTablespacesSP = new JScrollPane(this.allIntervalExpressionsTablespacesList);
            this.allIntervalExpressionTablespacesSP.setPreferredSize(new Dimension(100, 100));
            allJP.add((Component)this.allIntervalExpressionTablespacesFilterBox, new CC().wrap());
            allJP.add((Component)this.allIntervalExpressionTablespacesSP, new CC().grow());
            pnTablespaces.add((Component)allJP, new CC().grow());
            JPanel jpButtons = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
            this.bnAddIntervalExpressionTablespaces = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
            this.bnAddIntervalExpressionTablespaces.setMaximumSize(new Dimension(32, 32));
            this.bnAddIntervalExpressionTablespaces.setToolTipText(BTN_ADD);
            this.bnAddIntervalExpressionTablespaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel.isEmpty()) {
                        for (Object ob : TablePropertyDialogOraclev11g.this.allIntervalExpressionsTablespacesList.getSelectedValuesList()) {
                            if (!TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel.contains(ob)) {
                                TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel.addElement(ob);
                                TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel.removeElement(ob);
                                TablePropertyDialogOraclev11g.this.currentAll_IntervalExpressionTablespacesList.remove(ob);
                                TablePropertyDialogOraclev11g.this.currentSelected_IntervalExpressionTablespacesList.add(ob);
                            }
                            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentSelected_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesFilterBox.getText(), false);
                            TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesFilterBox.setEnabled(true);
                            if (TablePropertyDialogOraclev11g.this.currentAll_IntervalExpressionTablespacesList.size() != 0) continue;
                            TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesFilterBox.setText("");
                            TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesFilterBox.setEnabled(false);
                        }
                    }
                }
            });
            this.bnAddIntervalExpressionTablespaces.setEnabled(false);
            jpButtons.add((Component)this.bnAddIntervalExpressionTablespaces, new CC().wrap());
            this.bnRemoveIntervalExpressionTablespaces = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
            this.bnRemoveIntervalExpressionTablespaces.setMaximumSize(new Dimension(32, 32));
            this.bnRemoveIntervalExpressionTablespaces.setToolTipText(BTN_REMOVE);
            this.bnRemoveIntervalExpressionTablespaces.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel.isEmpty()) {
                        for (Object ob : TablePropertyDialogOraclev11g.this.selectedIntervalExpressionsTablespacesList.getSelectedValuesList()) {
                            if (!TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel.contains(ob)) {
                                TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel.addElement(ob);
                                TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel.removeElement(ob);
                                TablePropertyDialogOraclev11g.this.currentAll_IntervalExpressionTablespacesList.add(ob);
                                TablePropertyDialogOraclev11g.this.currentSelected_IntervalExpressionTablespacesList.remove(ob);
                            }
                            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentAll_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesFilterBox.getText(), true);
                            TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesFilterBox.setEnabled(true);
                            if (TablePropertyDialogOraclev11g.this.currentSelected_IntervalExpressionTablespacesList.size() != 0) continue;
                            TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesFilterBox.setText("");
                            TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesFilterBox.setEnabled(false);
                        }
                    }
                }
            });
            this.bnRemoveIntervalExpressionTablespaces.setEnabled(false);
            jpButtons.add(this.bnRemoveIntervalExpressionTablespaces);
            pnTablespaces.add(jpButtons);
            JPanel selectedJP = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "10[]5[grow]0"));
            selectedJP.setBorder(BorderFactory.createTitledBorder(Messages.getString("TablePropertyDialogOraclev11g.Selected")));
            this.currentSelected_IntervalExpressionTablespacesList = new ArrayList();
            this.selectedIntervalExpressionTablespacesFilterBox = new JSearchTextField(false, true, Messages.getString("TablePropertyDialogOraclev11g.Name"));
            this.selectedIntervalExpressionTablespacesFilterBox.setEnabled(false);
            this.selectedIntervalExpressionTablespacesFilterBox.setPreferredSize(new Dimension(150, 20));
            this.selectedIntervalExpressionTablespacesFilterBox.getDocument().addDocumentListener(new FilterSelectedIntervalExpressionTablespacesListener());
            this.selectedIntervalExpressionTablespacesModel = new DefaultListModel();
            this.selectedIntervalExpressionsTablespacesList = new JList(this.selectedIntervalExpressionTablespacesModel);
            this.selectedIntervalExpressionsTablespacesList.setBorder(new EmptyBorder(3, 3, 3, 3));
            this.selectedIntervalExpressionsTablespacesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (evt.getClickCount() == 2) {
                        TablePropertyDialogOraclev11g.this.bnRemoveIntervalExpressionTablespaces.doClick();
                    }
                }
            });
            ListSelectionModel selectedIntervalExpressionTablespacesSelectionModel = this.selectedIntervalExpressionsTablespacesList.getSelectionModel();
            selectedIntervalExpressionTablespacesSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        if (TablePropertyDialogOraclev11g.this.selectedIntervalExpressionsTablespacesList.getSelectedIndex() == -1) {
                            TablePropertyDialogOraclev11g.this.bnRemoveIntervalExpressionTablespaces.setEnabled(false);
                        } else {
                            TablePropertyDialogOraclev11g.this.bnRemoveIntervalExpressionTablespaces.setEnabled(true);
                        }
                    }
                }
            });
            this.selectedIntervalExpressionTablespacesSP = new JScrollPane(this.selectedIntervalExpressionsTablespacesList);
            this.selectedIntervalExpressionTablespacesSP.setPreferredSize(new Dimension(100, 100));
            selectedJP.add((Component)this.selectedIntervalExpressionTablespacesFilterBox, new CC().wrap());
            selectedJP.add((Component)this.selectedIntervalExpressionTablespacesSP, new CC().grow());
            pnTablespaces.add((Component)selectedJP, new CC().grow());
            JPanel jp = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[100::]5[grow]0"));
            jp.add((Component)pn0, new CC().grow().wrap());
            jp.add((Component)pnTablespaces, new CC().grow());
            this.rangeIntervalPanel.add((Component)jp, "Center");
        }
        return this.rangeIntervalPanel;
    }

    private JPanel getInMemoryPanel() {
        if (this.inMemoryPropsPanel == null) {
            this.inMemoryPropsPanel = this.createPage(IN_MEMORY_TAB_NAME);
            JPanel pnInMemoryGridlGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lblInMemory = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemory"));
            this.cbInMemory = new JComboBox<String>(EMPTY_YES_NO);
            this.cbInMemory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean inMemoryEnabled = TablePropertyDialogOraclev11g.this.cbInMemory.getSelectedItem().equals(AbstractPropertyDialog.YES);
                    TablePropertyDialogOraclev11g.this.cbInMemoryCompression.setEnabled(inMemoryEnabled);
                    TablePropertyDialogOraclev11g.this.cbInMemoryPriority.setEnabled(inMemoryEnabled);
                    TablePropertyDialogOraclev11g.this.cbInMemoryDistribute.setEnabled(inMemoryEnabled);
                    TablePropertyDialogOraclev11g.this.cbInMemoryDuplicate.setEnabled(inMemoryEnabled);
                }
            });
            JPanel pn0 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]", "0[]0"));
            pn0.add((Component)lblInMemory, new CC().width(this.defaultLabelWidth));
            pn0.add((Component)this.cbInMemory, new CC().width("60!"));
            pnInMemoryGridlGrid.add(pn0);
            JLabel lblInMemoryCompression = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryCompression"));
            this.cbInMemoryCompression = new JComboBox<String>(TableProxyOraclev12c.getInMemoryCompressionValues());
            JLabel lblInMemoryPriority = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryPriority"));
            this.cbInMemoryPriority = new JComboBox<String>(TableProxyOraclev12c.getInMemoryPriorityValues());
            JPanel pn1 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]50[]0[]", "0[]0"));
            pn1.add((Component)lblInMemoryCompression, new CC().width(this.defaultLabelWidth));
            pn1.add((Component)this.cbInMemoryCompression, new CC().width("130!"));
            pn1.add((Component)lblInMemoryPriority, new CC().width("120!"));
            pn1.add((Component)this.cbInMemoryPriority, new CC().width("80!"));
            pnInMemoryGridlGrid.add(pn1);
            JLabel lblInMemoryDistribute = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryDistribute"));
            this.cbInMemoryDistribute = new JComboBox<String>(TableProxyOraclev12c.getInMemoryDistributeValues());
            JLabel lblInMemoryDuplicate = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryDuplicate"));
            this.cbInMemoryDuplicate = new JComboBox<String>(TableProxyOraclev12c.getInMemoryDuplicateValues());
            JPanel pn2 = new JPanel((LayoutManager)new MigLayout("", "0[]0[]50[]0[]", "0[]0"));
            pn2.add((Component)lblInMemoryDistribute, new CC().width(this.defaultLabelWidth));
            pn2.add((Component)this.cbInMemoryDistribute, new CC().width("130!"));
            pn2.add((Component)lblInMemoryDuplicate, new CC().width("120!"));
            pn2.add((Component)this.cbInMemoryDuplicate, new CC().width("110!"));
            pnInMemoryGridlGrid.add(pn2);
            JPanel jp = new JPanel(new BorderLayout());
            jp.add((Component)pnInMemoryGridlGrid, "North");
            this.inMemoryPropsPanel.add((Component)jp, "Center");
        }
        return this.inMemoryPropsPanel;
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.cbCompressionType.setSelectedItem(((TableProxyOraclev11g)this.table).getCompressionType());
        this.cbAllowAnySchema.setSelectedItem(TablePropertyDialogOraclev11g.translateYesNoForDisplay(((TableProxyOraclev11g)this.table).getAllowAnySchema()));
        this.cbAllowNonSchema.setSelectedItem(TablePropertyDialogOraclev11g.translateYesNoForDisplay(((TableProxyOraclev11g)this.table).getAllowNonSchema()));
        this.cbLobStorageType.setSelectedItem(((TableProxyOraclev11g)this.table).getLobStorageType());
        PartitionListOraclev11g partList = (PartitionListOraclev11g)this.partList;
        if (partList != null) {
            this.cbSubpartType.setSelectedItem(partList.getSubpartitionType());
            this.cbRefConstraint.setSelectedItem(partList.getRefConstraint());
            this.ifSystemPartitions.setValue((long)partList.getSystemPartitions());
            this.taInterval.setText(partList.getIntervalExpression());
        } else {
            this.cbRefConstraint.setSelectedItem(null);
            this.ifSystemPartitions.setValue(1L);
        }
        if (partList != null) {
            Iterator tsIt = partList.getIntervalTablespaceSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedIntervalExpressionTablespacesModel.addElement(ts);
                this.currentSelected_IntervalExpressionTablespacesList.add(ts);
            }
        }
        if (this.selectedIntervalExpressionTablespacesModel.size() > 0) {
            this.selectedIntervalExpressionTablespacesFilterBox.setEnabled(true);
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedIntervalExpressionTablespacesModel.contains(ts)) continue;
            this.allIntervalExpressionTablespacesModel.addElement(ts);
            this.currentAll_IntervalExpressionTablespacesList.add(ts);
        }
        if (this.allIntervalExpressionTablespacesModel.size() > 0) {
            this.allIntervalExpressionTablespacesFilterBox.setEnabled(true);
        }
        if (this.table instanceof TableProxyOraclev12c) {
            TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)this.table;
            this.cbInMemory.setSelectedItem(TablePropertyDialogOraclev11g.translateYesNoForDisplay(tableProxy12c.getInMemory()));
            this.cbInMemoryCompression.setSelectedItem(tableProxy12c.getInMemoryCompression());
            this.cbInMemoryPriority.setSelectedItem(tableProxy12c.getInMemoryPriority());
            this.cbInMemoryDistribute.setSelectedItem(tableProxy12c.getInMemoryDistribute());
            this.cbInMemoryDuplicate.setSelectedItem(tableProxy12c.getInMemoryDuplicate());
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            super.setProperties();
            if (this.cbCompressionType.isEnabled()) {
                ((TableProxyOraclev11g)this.table).setCompressionType((String)this.cbCompressionType.getSelectedItem());
            }
            if (this.cbAllowAnySchema.isEnabled()) {
                ((TableProxyOraclev11g)this.table).setAllowAnySchema(TablePropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowAnySchema.getSelectedItem()));
                ((TableProxyOraclev11g)this.table).setAllowNonSchema(TablePropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowNonSchema.getSelectedItem()));
            }
            if (this.cbLobStorageType.isEnabled()) {
                ((TableProxyOraclev11g)this.table).setLobStorageType((String)this.cbLobStorageType.getSelectedItem());
            }
            if (((String)this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(YES)) {
                if (this.partList == null) {
                    this.partList = (PartitionListOraclev11g)this.getStorageDesign().getPartitionListSet().createPartitionList();
                }
                PartitionListOraclev11g partList = (PartitionListOraclev11g)this.partList;
                String partitionType = (String)this.cbPartType.getSelectedItem();
                String subpartitionType = "";
                FKProxyOracle refConstraint = null;
                int systemPartitions = 1;
                String intervalExpression = "";
                partList.getIntervalTablespaceSet().clear();
                if (partitionType.equals("RANGE")) {
                    intervalExpression = this.taInterval.getText();
                    Object[] intervalTSSet = this.selectedIntervalExpressionTablespacesModel.toArray();
                    for (int i = 0; i < intervalTSSet.length; ++i) {
                        Object ts = intervalTSSet[i];
                        if (!(ts instanceof TableSpaceOracle)) continue;
                        partList.setIntervalTablespaceSet(((TableSpaceOracle)ts).getObjectID());
                    }
                    subpartitionType = (String)this.cbSubpartType.getSelectedItem();
                } else if (partitionType.equals("LIST") || partitionType.startsWith("HASH")) {
                    subpartitionType = (String)this.cbSubpartType.getSelectedItem();
                } else if (partitionType.equals("REFERENCE")) {
                    refConstraint = (FKProxyOracle)this.cbRefConstraint.getSelectedItem();
                } else if (partitionType.equals("SYSTEM")) {
                    systemPartitions = this.ifSystemPartitions.getIntValue();
                }
                partList.setSubpartitionType(subpartitionType);
                partList.setRefConstraint(refConstraint);
                partList.setSystemPartitions(systemPartitions);
                partList.setIntervalExpression(intervalExpression);
            }
            if (this.table instanceof TableProxyOraclev12c) {
                TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)this.table;
                tableProxy12c.setInMemory(TablePropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbInMemory.getSelectedItem()));
                tableProxy12c.setInMemoryCompression((String)this.cbInMemoryCompression.getSelectedItem());
                tableProxy12c.setInMemoryPriority((String)this.cbInMemoryPriority.getSelectedItem());
                tableProxy12c.setInMemoryDistribute((String)this.cbInMemoryDistribute.getSelectedItem());
                tableProxy12c.setInMemoryDuplicate((String)this.cbInMemoryDuplicate.getSelectedItem());
            }
        }
    }

    private List getRefConstraints() {
        FKProxyOracle fkProxy;
        ArrayList<FKProxyOracle> comboItems = new ArrayList<FKProxyOracle>();
        if (this.storageObject instanceof TableProxyOracle) {
            for (FKProxyOracle fKey : ((TableProxyOracle)this.storageObject).getFKeys()) {
                TableProxyOracle remoteTableProxy;
                FKContainer remoteTable = fKey.getFKTable();
                if (remoteTable == null || (remoteTableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(remoteTable.getObjectID())) == null || remoteTableProxy == this.storageObject || !remoteTableProxy.getPartitioned().equalsIgnoreCase(YES)) continue;
                comboItems.add(fKey);
            }
        }
        if (this.partList != null && (fkProxy = ((PartitionListOraclev11g)this.partList).getRefConstraint()) != null && !comboItems.contains(fkProxy)) {
            comboItems.add(fkProxy);
        }
        return comboItems;
    }

    private void enableRelevantPartitionFields(boolean partitioned) {
        boolean hashNoStorageTemplate;
        String partType = "";
        boolean hashByQuantity = false;
        boolean subpartitioned = false;
        boolean hashSubPart = false;
        boolean enableColumns = false;
        if (partitioned) {
            partType = (String)this.cbPartType.getSelectedItem();
            hashByQuantity = partType.equalsIgnoreCase("HASH BY QUANTITY");
            subpartitioned = this.isSubpartitioned(partType);
            hashSubPart = this.isHashSubpartitioned(partType);
            enableColumns = partType.equalsIgnoreCase("RANGE") || partType.equalsIgnoreCase("LIST") || partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || hashByQuantity || subpartitioned;
        }
        this.cbUseSubpartitionsStorageTemplate.setEnabled(subpartitioned);
        this.ifHashPQuantity.setEnabled(hashByQuantity);
        this.ifSubPartQuantity.setEnabled(hashSubPart);
        this.cbSubpartType.setEnabled(partType.equals("RANGE") || partType.equals("LIST") || partType.startsWith("HASH"));
        this.cbRefConstraint.setEnabled(partType.equals("REFERENCE"));
        this.ifSystemPartitions.setEnabled(partType.equals("SYSTEM"));
        this.taInterval.setEnabled(partType.equals("RANGE"));
        this.allIntervalExpressionTablespacesFilterBox.setEnabled(partType.equals("RANGE") && this.allIntervalExpressionTablespacesModel.size() > 0);
        this.selectedIntervalExpressionTablespacesFilterBox.setEnabled(partType.equals("RANGE") && this.selectedIntervalExpressionTablespacesModel.size() > 0);
        this.allIntervalExpressionsTablespacesList.clearSelection();
        this.allIntervalExpressionsTablespacesList.setEnabled(partType.equals("RANGE"));
        this.selectedIntervalExpressionsTablespacesList.clearSelection();
        this.selectedIntervalExpressionsTablespacesList.setEnabled(partType.equals("RANGE"));
        this.partitioningAllColumnsList.setEnabled(enableColumns);
        this.partitioningSelectedColumnsList.setEnabled(enableColumns);
        if (subpartitioned) {
            this.bnAddSubPartColumns.setEnabled(this.allSubPartColumnsList.getSelectedIndex() != -1);
            this.bnRemoveSubPartColumns.setEnabled(this.selectedSubPartColumnsList.getSelectedIndex() != -1);
        }
        if (hashByQuantity) {
            this.bnAddHashPTS.setEnabled(this.allHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveHashPTS.setEnabled(this.selectedHashPTSList.getSelectedIndex() != -1);
            boolean hashByQuantityIndexOrg = this.isIndexOrg();
            this.allIOTOverflowHashPTSList.setEnabled(hashByQuantityIndexOrg);
            this.selectedIOTOverflowHashPTSList.setEnabled(hashByQuantityIndexOrg);
            this.bnAddIOTOverflowHashPTS.setEnabled(hashByQuantityIndexOrg && this.allIOTOverflowHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveIOTOverflowHashPTS.setEnabled(hashByQuantityIndexOrg && this.selectedIOTOverflowHashPTSList.getSelectedIndex() != -1);
        }
        boolean bl = hashNoStorageTemplate = hashSubPart && ((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()).equalsIgnoreCase(NO);
        if (hashNoStorageTemplate) {
            this.bnAddSubPartTS.setEnabled(this.allSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveSubPartTS.setEnabled(this.selectedSubPartTSList.getSelectedIndex() != -1);
        }
    }

    @Override
    protected boolean isHashSubpartitioned(String partType) {
        return this.cbSubpartType.getSelectedItem().equals("HASH") && this.isSubpartitioned(partType);
    }

    @Override
    protected boolean isSubpartitioned(String partType) {
        return !this.cbSubpartType.getSelectedItem().equals("") && (partType.equals("RANGE") || partType.equals("LIST") || partType.startsWith("HASH"));
    }

    @Override
    protected int getMinimumHeight() {
        return this.mainPanelMinHeight;
    }

    private class PartitionTypeListener
    implements ActionListener {
        private PartitionTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String type = (String)TablePropertyDialogOraclev11g.this.cbPartType.getSelectedItem();
            TablePropertyDialogOraclev11g.this.partitioningAllColumnsList.getSelectionModel().clearSelection();
            TablePropertyDialogOraclev11g.this.allSubPartColumnsList.getSelectionModel().clearSelection();
            if (type.equalsIgnoreCase("LIST") && TablePropertyDialogOraclev11g.this.partitioningSelectedColumnsModel.toArray().length > 1) {
                TablePropertyDialogOraclev11g.this.partitioningAllColumnsModel.clear();
                TablePropertyDialogOraclev11g.this.partitioningSelectedColumnsModel.clear();
                TablePropertyDialogOraclev11g.this.currentAll_PartitioningColumnsList.clear();
                TablePropertyDialogOraclev11g.this.currentSelected_PartitioningColumnsList.clear();
                TablePropertyDialogOraclev11g.this.initPartColumns(TablePropertyDialogOraclev11g.this.partList);
            }
            if (type.equalsIgnoreCase("COMPOSITE BY LIST") && TablePropertyDialogOraclev11g.this.selectedSubPartColumnsModel.toArray().length > 1) {
                TablePropertyDialogOraclev11g.this.allSubPartColumnsModel.clear();
                TablePropertyDialogOraclev11g.this.selectedSubPartColumnsModel.clear();
                TablePropertyDialogOraclev11g.this.currentAll_SubPartColumnsList.clear();
                TablePropertyDialogOraclev11g.this.currentSelected_SubPartColumnsList.clear();
                TablePropertyDialogOraclev11g.this.initSubPartColumns(TablePropertyDialogOraclev11g.this.partList);
            }
            TablePropertyDialogOraclev11g.this.enableRelevantPartitionFields(true);
        }
    }

    private class SubpartitionTypeListener
    implements ActionListener {
        private SubpartitionTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev11g.this.allSubPartColumnsList.getSelectionModel().clearSelection();
            String type = (String)TablePropertyDialogOraclev11g.this.cbPartType.getSelectedItem();
            if (TablePropertyDialogOraclev11g.this.isListSubpartitioned(type) && TablePropertyDialogOraclev11g.this.selectedSubPartColumnsModel.toArray().length > 1) {
                TablePropertyDialogOraclev11g.this.allSubPartColumnsModel.clear();
                TablePropertyDialogOraclev11g.this.selectedSubPartColumnsModel.clear();
                TablePropertyDialogOraclev11g.this.initSubPartColumns(TablePropertyDialogOraclev11g.this.partList);
            }
            TablePropertyDialogOraclev11g.this.enableRelevantPartitionFields(TablePropertyDialogOraclev11g.this.isPartitioned());
        }
    }

    class FilterAllIntervalExpressionTablespacesListener
    implements DocumentListener {
        FilterAllIntervalExpressionTablespacesListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentAll_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesFilterBox.getText(), true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentAll_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesFilterBox.getText(), true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentAll_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.allIntervalExpressionTablespacesFilterBox.getText(), true);
        }
    }

    class FilterSelectedIntervalExpressionTablespacesListener
    implements DocumentListener {
        FilterSelectedIntervalExpressionTablespacesListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentSelected_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesFilterBox.getText(), false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentSelected_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesFilterBox.getText(), false);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JListUtils.filter(TablePropertyDialogOraclev11g.this.currentSelected_IntervalExpressionTablespacesList, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesModel, TablePropertyDialogOraclev11g.this.selectedIntervalExpressionTablespacesFilterBox.getText(), false);
        }
    }
}

