/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionsListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UniqueOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexGlobalPartitionsListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class UniqueConstraintPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private static final String NO_INDEX = NO;
    private static final String LOCAL = "LOCAL";
    private static final String GLOBAL_BY_RANGE = "GLOBAL BY RANGE";
    private static final String GLOBAL_HASH_PARTITIONED_BY_QUANTITY = "GLOBAL HASH PARTITIONED BY QUANTITY";
    private static final String GLOBAL_HASH_PARTITIONED_BY_LIST = "GLOBAL HASH PARTITIONED BY LIST";
    private static final String BY_INDEX_NAME = "BY INDEX NAME";
    private static final String BY_CREATE_INDEX_STATEMENT = "BY CREATE INDEX STATEMENT";
    private static final String[] USING_INDEX_CHOICES = new String[]{NO_INDEX, "LOCAL", "GLOBAL BY RANGE", "GLOBAL HASH PARTITIONED BY QUANTITY", "GLOBAL HASH PARTITIONED BY LIST", "BY INDEX NAME", "BY CREATE INDEX STATEMENT"};
    private static final String NO_SORT = NO;
    private static final String SORTED = "SORTED";
    private static final String REVERSE = "REVERSE";
    private static final String[] SORT_CHOICES = new String[]{NO_SORT, "SORTED", "REVERSE"};
    private UniqueOraclev10g unique;
    private JTextField tfTable;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbRely;
    private JComboBox cbUsingIndex;
    private JComboBox cbExTable;
    private JPanel usingIndex;
    private JComboBox cbExistingIndex;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JPositiveIntegerField ifCompress;
    private JComboBox cbIndexSort;
    private JComboBox cbComputeStatistics;
    private JTextArea taCreateIndexStatement;
    private JScrollPane spCreateIndexStatement;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel partitioning;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JPanel hashSubPartQuantityTS;
    private JIntegerField ifHashPQuantity;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JList allIOTOverflowHashPTSList;
    private JList selectedIOTOverflowHashPTSList;
    private DefaultListModel allIOTOverflowHashPTSModel;
    private DefaultListModel selectedIOTOverflowHashPTSModel;
    private JButton bnAddIOTOverflowHashPTS;
    private JButton bnRemoveIOTOverflowHashPTS;
    private String comment;
    private String commentInRDBMS;

    public UniqueConstraintPropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.unique = (UniqueOraclev10g)object;
        this.setHeight(460);
        this.initCommentsView(180);
        this.initCommentsInRDBMS(180);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("UniqueConstraintPropertyDialogOracle.UniqueConstraintProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initRely();
        this.initUsingIndex();
        this.initExTable();
        if (this.isEditable()) {
            this.initPropagatePropsButton(290);
        }
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initInitially() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.Initially"));
        this.general.add(label);
        this.cbInitially = new JComboBox<String>(UniqueOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitially);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbInitially, 80);
    }

    private void initDeferrable() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.Deferrable"));
        this.general.add(label);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeferrable);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDeferrable, 110);
    }

    private void initEnable() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.Enable"));
        this.general.add(label);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnable);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbEnable, 140);
    }

    private void initValidate() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.Validate"));
        this.general.add(label);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.cbValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UniqueConstraintPropertyDialogOraclev10g.this.cbRely.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.cbValidate.getSelectedItem().equals(AbstractPropertyDialog.NO));
            }
        });
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidate);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbValidate, 170);
    }

    private void initRely() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogOraclev9i.Rely"));
        this.general.add(label);
        this.cbRely = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRely);
        this.cbRely.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRely);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbRely, 200);
    }

    private void initUsingIndex() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.UsingIndexL"));
        this.general.add(label);
        this.cbUsingIndex = new JComboBox<String>(USING_INDEX_CHOICES);
        this.setBG(this.cbUsingIndex);
        this.cbUsingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.cbUsingIndex.addActionListener(new PartitionTypeListener());
        this.cbUsingIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = (String)UniqueConstraintPropertyDialogOraclev10g.this.cbUsingIndex.getSelectedItem();
                int usingIndexTabIndex = UniqueConstraintPropertyDialogOraclev10g.this.getPane().indexOfComponent(UniqueConstraintPropertyDialogOraclev10g.this.usingIndex);
                if (usingIndexTabIndex > -1) {
                    UniqueConstraintPropertyDialogOraclev10g.this.getPane().setEnabledAt(usingIndexTabIndex, !value.equalsIgnoreCase(NO_INDEX));
                }
                if (value.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.BY_INDEX_NAME)) {
                    UniqueConstraintPropertyDialogOraclev10g.this.cbExistingIndex.setEnabled(true);
                    UniqueConstraintPropertyDialogOraclev10g.this.enableUsingIndexProps(true);
                    UniqueConstraintPropertyDialogOraclev10g.this.taCreateIndexStatement.setEnabled(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.taCreateIndexStatement.setText("");
                } else if (value.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.BY_CREATE_INDEX_STATEMENT)) {
                    UniqueConstraintPropertyDialogOraclev10g.this.taCreateIndexStatement.setEnabled(true);
                    UniqueConstraintPropertyDialogOraclev10g.this.enableUsingIndexProps(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.cbExistingIndex.setEnabled(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.cbExistingIndex.setSelectedItem(null);
                } else if (!value.equalsIgnoreCase(NO_INDEX)) {
                    UniqueConstraintPropertyDialogOraclev10g.this.enableUsingIndexProps(true);
                    UniqueConstraintPropertyDialogOraclev10g.this.taCreateIndexStatement.setEnabled(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.cbExistingIndex.setEnabled(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.taCreateIndexStatement.setText("");
                    UniqueConstraintPropertyDialogOraclev10g.this.cbExistingIndex.setSelectedItem(null);
                }
            }
        });
        this.general.add(this.cbUsingIndex);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbUsingIndex, 230);
    }

    private void enableUsingIndexProps(boolean enable) {
        this.cbTableSpace.setEnabled(enable);
        this.cbLogging.setEnabled(enable);
        this.cbSegment.setEnabled(enable);
        this.ifCompress.setEnabled(enable);
        this.cbIndexSort.setEnabled(enable);
        this.cbComputeStatistics.setEnabled(enable);
    }

    private void initExTable() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.ExceptionsTable"));
        this.general.add(label);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExTable);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbExTable, 260);
    }

    private void initPropagatePropsButton(int yCoord) {
        JButton bnPropagateProps = new JButton(Messages.getString("IndexPropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(UniqueConstraintPropertyDialogOraclev10g.this.getStorageDesign().getUniqueSet().getElements());
                list.remove(UniqueConstraintPropertyDialogOraclev10g.this.unique);
                Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
                new PropertiesPropagationDialog(UniqueConstraintPropertyDialogOraclev10g.this.getAppView(), UniqueConstraintPropertyDialogOraclev10g.this.unique, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, yCoord);
    }

    private void initIndexSort() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.IndexSort"));
        this.usingIndex.add(label);
        this.cbIndexSort = new JComboBox<String>(SORT_CHOICES);
        this.setBG(this.cbIndexSort);
        this.cbIndexSort.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbIndexSort);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 170);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbIndexSort, 170);
    }

    private void initTableSpace() {
        JLabel lbTableSpace = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.TableSpace"));
        this.usingIndex.add(lbTableSpace);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbTableSpace);
        this.setLabelConstraints(this.getUsingIndexLayout(), lbTableSpace, 50);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbTableSpace, 50);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.Logging"));
        this.usingIndex.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbLogging);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 80);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbLogging, 80);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.Segment"));
        this.usingIndex.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbSegment);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 110);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbSegment, 110);
    }

    private void initCompress() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogOracle.Compress"));
        this.usingIndex.add(label);
        this.ifCompress = new JPositiveIntegerField();
        this.ifCompress.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.ifCompress);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 140);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.ifCompress, 140);
    }

    private void initComputeStatistics() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.ComputeStatistics"));
        this.usingIndex.add(label);
        this.cbComputeStatistics = new JComboBox<String>(YES_NO);
        this.setBG(this.cbComputeStatistics);
        this.cbComputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbComputeStatistics);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 200);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbComputeStatistics, 200);
    }

    private void initExistingIndex() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.ExistingIndex"));
        this.usingIndex.add(label);
        this.cbExistingIndex = new JComboBox();
        this.setBG(this.cbExistingIndex);
        this.cbExistingIndex.addActionListener(new ExistingIndexListener());
        this.cbExistingIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.usingIndex.add(this.cbExistingIndex);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 20);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.cbExistingIndex, 20);
    }

    private void initCreateIndexStatement() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.CreateIndexStatement"));
        this.usingIndex.add(label);
        this.setLabelConstraints(this.getUsingIndexLayout(), label, 230);
        this.taCreateIndexStatement = new JTextArea();
        this.spCreateIndexStatement = new JScrollPane(this.taCreateIndexStatement);
        this.spCreateIndexStatement.setPreferredSize(new Dimension(425, 140));
        this.spCreateIndexStatement.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCreateIndexStatement.setLineWrap(true);
        this.usingIndex.add(this.spCreateIndexStatement);
        this.setObjectConstraints(this.getUsingIndexLayout(), this.spCreateIndexStatement, 10, 260);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initPartitioningView();
        this.initGlobalHashPartitionsByQuantityView();
        this.initUsingIndexView();
    }

    protected SpringLayout getUsingIndexLayout() {
        return (SpringLayout)this.usingIndex.getLayout();
    }

    private void initUsingIndexView() {
        this.usingIndex = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UniqueConstraintPropertyDialogOracle.UsingIndex"), this.usingIndex);
        this.initExistingIndex();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initCompress();
        this.initIndexSort();
        this.initComputeStatistics();
        this.initCreateIndexStatement();
    }

    private void initGlobalHashPartitionsByQuantityView() {
        this.hashSubPartQuantityTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UniqueConstraintPropertyDialogOraclev10g.GlobalHashPartitionsByQuantity"), this.hashSubPartQuantityTS);
        this.initGlobalHashPartitionsByQuantity();
    }

    private void initGlobalHashPartitionsByQuantity() {
        this.initHashPQuantity();
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
        this.initAllIOTOverflowHashPTSList();
        this.initSelectedIOTOverflowHashPTSList();
        this.initIOTOverflowHashPTSButtons();
    }

    protected SpringLayout getHashSubPartTSQuantityLayout() {
        return (SpringLayout)this.hashSubPartQuantityTS.getLayout();
    }

    private void initHashPQuantity() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOraclev10g.HashPQuantity"));
        this.hashSubPartQuantityTS.add(label);
        this.ifHashPQuantity = new JIntegerField(0, 26);
        this.hashSubPartQuantityTS.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), label, 20);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.ifHashPQuantity, 20);
    }

    private void initAllHashPTSList() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOraclev10g.AllTableSpaces"));
        this.hashSubPartQuantityTS.add(label);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allHashPTSList);
        sp.setPreferredSize(new Dimension(144, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(sp);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), label, 12, 54);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), sp, 10, 72);
    }

    private void initSelectedHashPTSList() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOraclev10g.HashPTableSpaces"));
        this.hashSubPartQuantityTS.add(label);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedHashPTSList);
        sp.setPreferredSize(new Dimension(145, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(sp);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), label, 292, 54);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), sp, 290, 72);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashSubPartQuantityTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnAddHashPTS, 175, 120);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashSubPartQuantityTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnRemoveHashPTS, 175, 150);
        UniqueConstraintPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void initAllIOTOverflowHashPTSList() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOraclev10g.AllTableSpaces"));
        this.hashSubPartQuantityTS.add(label);
        this.allIOTOverflowHashPTSModel = new DefaultListModel();
        this.allIOTOverflowHashPTSList = new JList(this.allIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.allIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIOTOverflowHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allIOTOverflowHashPTSList);
        sp.setPreferredSize(new Dimension(144, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(sp);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), label, 12, 224);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), sp, 10, 242);
    }

    private void initSelectedIOTOverflowHashPTSList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.IOTOverflowTS"));
        this.hashSubPartQuantityTS.add(label);
        this.selectedIOTOverflowHashPTSModel = new DefaultListModel();
        this.selectedIOTOverflowHashPTSList = new JList(this.selectedIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIOTOverflowHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedIOTOverflowHashPTSList);
        sp.setPreferredSize(new Dimension(145, 140));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashSubPartQuantityTS.add(sp);
        this.setLabelConstraints(this.getHashSubPartTSQuantityLayout(), label, 292, 224);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), sp, 290, 242);
    }

    private void initIOTOverflowHashPTSButtons() {
        this.bnAddIOTOverflowHashPTS = new JButton(ADD_CAPTION);
        this.bnAddIOTOverflowHashPTS.addActionListener(new AddIOTOverflowHashPTSActionListener());
        this.bnAddIOTOverflowHashPTS.setEnabled(false);
        this.hashSubPartQuantityTS.add(this.bnAddIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnAddIOTOverflowHashPTS, 175, 280);
        this.bnRemoveIOTOverflowHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
        this.bnRemoveIOTOverflowHashPTS.addActionListener(new RemoveIOTOverflowHashPTSActionListener());
        this.hashSubPartQuantityTS.add(this.bnRemoveIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashSubPartTSQuantityLayout(), this.bnRemoveIOTOverflowHashPTS, 175, 310);
        UniqueConstraintPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddIOTOverflowHashPTS, this.bnRemoveIOTOverflowHashPTS);
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UniqueConstraintPropertyDialogOracle.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 360));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    private void initPartitioningView() {
        this.partitioning = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("UniqueConstraintPropertyDialogOracle.GlobalPartitioning"), this.partitioning);
        this.initPartitioning();
    }

    protected SpringLayout getPartitioningLayout() {
        return (SpringLayout)this.partitioning.getLayout();
    }

    private void initPartitioning() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.AllColumns"));
        this.partitioning.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 340));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(sp);
        this.setLabelConstraints(this.getPartitioningLayout(), label, 12, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), sp, 10, 30);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("UniqueConstraintPropertyDialogOracle.SelectedColumns"));
        this.partitioning.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 340));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioning.add(sp);
        this.setLabelConstraints(this.getPartitioningLayout(), label, 292, 12);
        this.setObjectConstraints(this.getPartitioningLayout(), sp, 290, 30);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("UniqueConstraintPropertyDialogOracle.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partitioning.add(this.bnAdd);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnAdd, 175, 165);
        this.bnRemove = new JButton(Messages.getString("UniqueConstraintPropertyDialogOracle.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partitioning.add(this.bnRemove);
        this.setObjectConstraints(this.getPartitioningLayout(), this.bnRemove, 175, 195);
        UniqueConstraintPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void setPartitioning(boolean use) {
        this.allColumnsList.setEnabled(use);
        this.selectedColumnsList.setEnabled(use);
        this.bnAdd.setEnabled(use && this.allColumnsList.getSelectedIndex() != -1);
        this.bnAdd.setEnabled(use && this.selectedColumnsList.getSelectedIndex() != -1);
        this.allColumnsModel.clear();
        this.selectedColumnsModel.clear();
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        IndexGlobalPartitionsListOraclev10g partList = (IndexGlobalPartitionsListOraclev10g)this.unique.getUsingIndexGlobalPL();
        this.initPartColumns(partList);
        this.ifHashPQuantity.setValue((long)partList.getHashPQuantity());
        this.initHashPTS(partList);
        this.initIOTOverflowHashPTS(partList);
    }

    private void initHashPTS(IndexGlobalPartitionsListOraclev10g partList) {
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        if (partList != null) {
            Iterator tsIt = partList.getHashPartitionsTableSpacesSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedHashPTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedHashPTSModel.contains(ts)) continue;
            this.allHashPTSModel.addElement(ts);
        }
    }

    private void initIOTOverflowHashPTS(IndexGlobalPartitionsListOraclev10g partList) {
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        if (partList != null) {
            Iterator tsIt = partList.getIOTOverflowHashPTSSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedIOTOverflowHashPTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedIOTOverflowHashPTSModel.contains(ts)) continue;
            this.allIOTOverflowHashPTSModel.addElement(ts);
        }
    }

    private void initPartColumns(IndexGlobalPartitionsListOracle partList) {
        this.selectedColumnsModel.removeAllElements();
        this.allColumnsModel.removeAllElements();
        ColumnProxy[] columnSet = this.unique.getColumnProxies();
        if (partList != null) {
            block0: for (String colId : partList.getColumnSet()) {
                for (int i = 0; i < columnSet.length; ++i) {
                    ColumnProxy col = columnSet[i];
                    if (!col.getObjectID().equals(colId)) continue;
                    this.selectedColumnsModel.addElement(col);
                    continue block0;
                }
            }
        }
        for (int i = 0; i < columnSet.length; ++i) {
            ColumnProxy col = columnSet[i];
            if (this.selectedColumnsModel.contains(col)) continue;
            this.allColumnsModel.addElement(col);
        }
    }

    @Override
    public void initProperties() {
        this.initCaption(this.unique.getName());
        this.tfName.setText(this.unique.getName());
        this.tfTable.setText(this.unique.getTable().getName());
        ColumnProxy[] proxies = this.unique.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        this.cbInitially.setSelectedItem(this.unique.getInitially());
        this.cbDeferrable.setSelectedItem(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForDisplay(this.unique.getDeferrable()));
        this.cbEnable.setSelectedItem(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForDisplay(this.unique.getEnable()));
        this.cbValidate.setSelectedItem(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForDisplay(this.unique.getValidate()));
        this.cbRely.setSelectedItem(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForDisplay(this.unique.getRely()));
        this.cbUsingIndex.setSelectedItem(this.translate(this.unique.getUsingIndex(), UniqueOraclev10g.getUsingIndexChoices(), USING_INDEX_CHOICES));
        this.cbExTable.setSelectedItem(this.unique.getExceptionsTable());
        this.cbExistingIndex.addItem(null);
        Iterator iterator = this.unique.getTableProxy().getIndexes().iterator();
        while (iterator.hasNext()) {
            this.cbExistingIndex.addItem(iterator.next());
        }
        this.cbExistingIndex.setSelectedItem(this.unique.getExistingIndex());
        this.cbTableSpace.setSelectedItem(this.unique.getTableSpace());
        this.cbLogging.setSelectedItem(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForDisplay(this.unique.getLogging()));
        this.cbSegment.setSelectedItem(this.unique.getIndexSegment());
        this.ifCompress.setValue((long)this.unique.getCompress());
        this.cbIndexSort.setSelectedItem(this.translate(this.unique.getIndexSort(), UniqueOraclev10g.getIndexSortChoices(), SORT_CHOICES));
        this.cbComputeStatistics.setSelectedItem(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForDisplay(this.unique.getComputeStatistics()));
        this.taCreateIndexStatement.insert(this.unique.getCreateIndexStatement(), 0);
        if (this.unique.getUsingIndexGlobalPL() != null) {
            this.setPartitioning(true);
        }
        this.comment = this.unique.getObject().getComment();
        this.commentInRDBMS = this.unique.getObject().getCommentInRDBMS();
        if (this.unique.isCommentChanged()) {
            this.getCommentsList().insert(this.unique.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.unique.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.unique.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.unique != null) {
            IndexGlobalPartitionsListOracle partList;
            this.unique.setName(this.tfName.getText());
            this.unique.setInitially((String)this.cbInitially.getSelectedItem());
            this.unique.setDeferrable(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.unique.setEnable(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.unique.setValidate(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            this.unique.setRely(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbRely.getSelectedItem()));
            this.unique.setUsingIndex(this.translate((String)this.cbUsingIndex.getSelectedItem(), USING_INDEX_CHOICES, UniqueOraclev10g.getUsingIndexChoices()));
            Object selected = this.cbExTable.getSelectedItem();
            if (selected instanceof TableProxyOracle) {
                this.unique.setExceptionsTable((TableProxyOracle)selected);
            } else {
                this.unique.setExceptionsTable(null);
            }
            this.unique.setExistingIndex((IndexProxyOracle)this.cbExistingIndex.getSelectedItem());
            selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.unique.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.unique.setTableSpace(null);
            }
            this.unique.setLogging(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOracle) {
                this.unique.setIndexSegment((SegmentOracle)selected);
            } else {
                this.unique.setIndexSegment(null);
            }
            this.unique.setCompress(this.ifCompress.getIntValue());
            this.unique.setIndexSort(this.translate((String)this.cbIndexSort.getSelectedItem(), SORT_CHOICES, UniqueOraclev10g.getIndexSortChoices()));
            this.unique.setComputeStatistics(UniqueConstraintPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbComputeStatistics.getSelectedItem()));
            this.unique.setCreateIndexStatement(this.taCreateIndexStatement.getText());
            String partitioned = (String)this.cbUsingIndex.getSelectedItem();
            if (!partitioned.equalsIgnoreCase(NO_INDEX) && !partitioned.equalsIgnoreCase(LOCAL)) {
                partList = this.unique.getUsingIndexGlobalPL() != null ? (IndexGlobalPartitionsListOraclev10g)this.unique.getUsingIndexGlobalPL() : (IndexGlobalPartitionsListOraclev10g)this.getStorageDesign().getIndexGlobalPartitionsListSet().createIndexGlobalPartitionsList();
                this.unique.setUsingIndexGlobalPL(partList);
                Object[] columnSet = this.selectedColumnsModel.toArray();
                ((IndexGlobalPartitionsListOraclev10g)partList).clear();
                for (int i = 0; i < columnSet.length; ++i) {
                    Object ob = columnSet[i];
                    if (!(ob instanceof RelationalObjectProxy)) continue;
                    partList.setGlobalPartColumns(((RelationalObjectProxy)ob).getObjectID());
                }
                if (partitioned.equalsIgnoreCase(GLOBAL_HASH_PARTITIONED_BY_QUANTITY)) {
                    ((IndexGlobalPartitionsListOraclev10g)partList).setHashPQuantity(this.ifHashPQuantity.getIntValue());
                    Object[] tsSet = this.selectedHashPTSModel.toArray();
                    for (int i = 0; i < tsSet.length; ++i) {
                        Object ts = tsSet[i];
                        if (!(ts instanceof TableSpaceOraclev10g)) continue;
                        ((IndexGlobalPartitionsListOraclev10g)partList).setHashPTableSpaces(((TableSpaceOraclev10g)ts).getObjectID());
                    }
                    Object[] tsIOTSet = this.selectedIOTOverflowHashPTSModel.toArray();
                    for (int i = 0; i < tsIOTSet.length; ++i) {
                        Object ts = tsIOTSet[i];
                        if (!(ts instanceof TableSpaceOraclev10g)) continue;
                        ((IndexGlobalPartitionsListOraclev10g)partList).setIOTOverflowHashPTSSet(((TableSpaceOraclev10g)ts).getObjectID());
                    }
                } else {
                    ((IndexGlobalPartitionsListOraclev10g)partList).setHashPQuantity(0);
                    ((IndexGlobalPartitionsListOraclev10g)partList).setHashPTableSpaces("");
                    ((IndexGlobalPartitionsListOraclev10g)partList).setIOTOverflowHashPTSSet("");
                }
            } else if (this.unique.getUsingIndexGlobalPL() != null) {
                partList = this.unique.getUsingIndexGlobalPL();
                this.unique.setUsingIndexGlobalPL(null);
                this.getStorageDesign().getIndexGlobalPartitionsListSet().remove(partList);
            }
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equals(commentText)) {
                this.unique.setComment(commentText);
                this.unique.setCommentChanged(true);
            } else {
                this.unique.setComment("");
                this.unique.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equals(commentInRDBMSText)) {
                this.unique.setCommentInRDBMS(commentInRDBMSText);
                this.unique.setCommentInRDBMSChanged(true);
            } else {
                this.unique.setCommentInRDBMS("");
                this.unique.setCommentInRDBMSChanged(false);
            }
        }
    }

    public class PartitionTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String type = (String)UniqueConstraintPropertyDialogOraclev10g.this.cbUsingIndex.getSelectedItem();
            if (type.equalsIgnoreCase(NO_INDEX) || type.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.LOCAL) || type.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.BY_INDEX_NAME) || type.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.BY_CREATE_INDEX_STATEMENT)) {
                UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAdd.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemove.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
            } else if (type.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.GLOBAL_BY_RANGE)) {
                UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAdd.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() != -1);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemove.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() != -1);
                UniqueConstraintPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.initPartColumns(UniqueConstraintPropertyDialogOraclev10g.this.unique.getUsingIndexGlobalPL());
            } else if (type.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.GLOBAL_HASH_PARTITIONED_BY_QUANTITY)) {
                UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAdd.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() != -1);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemove.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() != -1);
                UniqueConstraintPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSList.getSelectedIndex() != -1);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSList.getSelectedIndex() != -1);
                if (((TableProxyOracle)UniqueConstraintPropertyDialogOraclev10g.this.unique.getTableProxy()).getOrganization().equalsIgnoreCase("INDEX")) {
                    UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(true);
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(true);
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.getSelectedIndex() != -1);
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedIndex() != -1);
                    UniqueConstraintPropertyDialogOraclev10g.this.initIOTOverflowHashPTS((IndexGlobalPartitionsListOraclev10g)UniqueConstraintPropertyDialogOraclev10g.this.unique.getUsingIndexGlobalPL());
                } else {
                    UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                }
                UniqueConstraintPropertyDialogOraclev10g.this.initPartColumns(UniqueConstraintPropertyDialogOraclev10g.this.unique.getUsingIndexGlobalPL());
                UniqueConstraintPropertyDialogOraclev10g.this.initHashPTS((IndexGlobalPartitionsListOraclev10g)UniqueConstraintPropertyDialogOraclev10g.this.unique.getUsingIndexGlobalPL());
            } else if (type.equalsIgnoreCase(UniqueConstraintPropertyDialogOraclev10g.GLOBAL_HASH_PARTITIONED_BY_LIST)) {
                UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.setEnabled(true);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAdd.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() != -1);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemove.setEnabled(UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() != -1);
                UniqueConstraintPropertyDialogOraclev10g.this.ifHashPQuantity.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                UniqueConstraintPropertyDialogOraclev10g.this.initPartColumns(UniqueConstraintPropertyDialogOraclev10g.this.unique.getUsingIndexGlobalPL());
            }
        }
    }

    private class ExistingIndexListener
    implements ActionListener {
        private ExistingIndexListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UniqueConstraintPropertyDialogOraclev10g.this.cbUsingIndex.getSelectedItem().equals(UniqueConstraintPropertyDialogOraclev10g.BY_INDEX_NAME)) {
                UniqueConstraintPropertyDialogOraclev10g.this.enableUsingIndexProps(UniqueConstraintPropertyDialogOraclev10g.this.cbExistingIndex.getSelectedItem() == null);
            }
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSList.getSelectedIndex() == -1) {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(false);
                } else {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSModel.isEmpty()) {
                Object[] selectedObjects = UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSModel.contains(ob)) continue;
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSModel.addElement(ob);
                    UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSModel.isEmpty()) {
                Object[] selectedObjects = UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSModel.contains(ob)) continue;
                    UniqueConstraintPropertyDialogOraclev10g.this.allHashPTSModel.addElement(ob);
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AllIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                } else {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                } else {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AddIOTOverflowHashPTSActionListener
    implements ActionListener {
        private AddIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.isEmpty()) {
                Object[] selectedObjects = UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.contains(ob)) continue;
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.addElement(ob);
                    UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveIOTOverflowHashPTSActionListener
    implements ActionListener {
        private RemoveIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.isEmpty()) {
                Object[] selectedObjects = UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.contains(ob)) continue;
                    UniqueConstraintPropertyDialogOraclev10g.this.allIOTOverflowHashPTSModel.addElement(ob);
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedIOTOverflowHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.getSelectedIndex() == -1) {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAdd.setEnabled(false);
                } else {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedIndex() == -1) {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemove.setEnabled(false);
                } else {
                    UniqueConstraintPropertyDialogOraclev10g.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UniqueConstraintPropertyDialogOraclev10g.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = UniqueConstraintPropertyDialogOraclev10g.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsModel.contains(ob)) continue;
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsModel.addElement(ob);
                    UniqueConstraintPropertyDialogOraclev10g.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (UniqueConstraintPropertyDialogOraclev10g.this.allColumnsModel.contains(ob)) continue;
                    UniqueConstraintPropertyDialogOraclev10g.this.allColumnsModel.addElement(ob);
                    UniqueConstraintPropertyDialogOraclev10g.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

