/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.SegmentOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.LocalIndexPropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class TBPartitionPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog
implements ListSelectionListener {
    private PartitionOracle partition;
    private JTextField tfValueList;
    private JIntegerField ifPosition;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;
    private JIntegerField ifIotCompress;
    private JComboBox cbIotOverflowSegment;
    private JComboBox cbSegmentCompression;
    private JIntegerField ifSubPartQuantity;
    private JPanel subPartTS;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel subPartOrderPanel;
    private JTable subPartitionsOrderTable;
    private List subPartitions;
    private DefaultListSelectionModel subPartSelectionModel;
    private SubPartitionsOrderModel subPartitionsOrderModel;
    private boolean subPartOrdered = false;
    private JList list;
    private JPanel indexesButtonPanel;
    private DefaultListModel listModel;
    private JButton edit;

    public TBPartitionPropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partition = (PartitionOracle)object;
        this.setHeight(370);
        this.initCommentsView(300);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TBPartitionPropertyDialogOracle.PartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initPosition();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
        this.initSegmentCompression();
        this.initIOTCompress();
        this.initIOTOverflowSegment();
        this.initSubPartQuantity();
    }

    private void initValueList() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.ValueList"));
        this.general.add(label);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initPosition() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Position"));
        this.general.add(label);
        this.ifPosition = new JIntegerField(0, 26);
        this.general.add(this.ifPosition);
        this.ifPosition.setEnabled(false);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifPosition, 80);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    private void initSegmentCompression() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SegCompression"));
        this.general.add(label);
        this.cbSegmentCompression = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbSegmentCompression);
        this.cbSegmentCompression.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegmentCompression);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbSegmentCompression, 200);
    }

    private void initIOTCompress() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.IOTCompress"));
        this.general.add(label);
        this.ifIotCompress = new JIntegerField(0, 26);
        this.general.add(this.ifIotCompress);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifIotCompress, 230);
    }

    private void initIOTOverflowSegment() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.OverflowSegment"));
        this.general.add(label);
        this.cbIotOverflowSegment = new JComboBox();
        this.setBG(this.cbIotOverflowSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIotOverflowSegment);
        }
        this.cbIotOverflowSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIotOverflowSegment);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbIotOverflowSegment, 260);
    }

    private void initSubPartQuantity() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SubPartQuantity"));
        this.general.add(label);
        this.ifSubPartQuantity = new JIntegerField(0, 26);
        this.general.add(this.ifSubPartQuantity);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.ifSubPartQuantity, 290);
    }

    private DefaultListModel getLocIndexes() {
        if (this.listModel == null) {
            this.listModel = new DefaultListModel();
        }
        return this.listModel;
    }

    private void initIndexesTab() {
        JPanel constraintPanel = new JPanel();
        JScrollPane pane = new JScrollPane(this.getList());
        pane.setPreferredSize(new Dimension(390, 270));
        constraintPanel.add((Component)this.getIndexesButtonPanel(), "North");
        constraintPanel.add((Component)pane, "Center");
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.LocalIndexes"), constraintPanel);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getIndexesButtonPanel() {
        if (this.indexesButtonPanel == null) {
            this.indexesButtonPanel = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.edit = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.edit.setToolTipText(Messages.getString("TBPartitionPropertyDialogOracle.Properties"));
            this.edit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TBPartitionPropertyDialogOraclev10g.this.editSelected();
                }
            });
            this.edit.setEnabled(false);
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.edit);
            toolBar.addSeparator();
            this.indexesButtonPanel.add(toolBar);
            this.indexesButtonPanel.setPreferredSize(new Dimension(390, 30));
        }
        return this.indexesButtonPanel;
    }

    private void editSelected() {
        Object selected = this.list.getSelectedValue();
        LocalIndexPropertyDialogOraclev10g editor = new LocalIndexPropertyDialogOraclev10g(this.partition.getDesign().getAppView(), this.getStorageDesign(), this.partition, (StorageObject)selected);
        editor.show();
    }

    private JList getList() {
        this.list = new JList(this.getLocIndexes());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new IndexesCellRenderer());
        this.list.addMouseListener(new listMouseListener());
        this.list.addListSelectionListener(this);
        return this.list;
    }

    @Override
    protected void addTabs() {
        StorageObject partition = this.getStorageObject();
        if (((PartitionOracle)partition).getPartitionList() != null) {
            this.initSubPartTSView();
            this.initSubPartOrderTab();
        }
        this.initIndexesTab();
    }

    private void initSubPartTSView() {
        this.subPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionTableSpaces"), this.subPartTS);
        this.initSubPartTS();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initAllSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.AllTableSpaces"));
        this.subPartTS.add(label);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 290));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 8, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 6, 22);
    }

    private void initSelectedSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("TBPartitionPropertyDialogOracle.SelectedTableSpaces"));
        this.subPartTS.add(label);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 290));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 292, 4);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 290, 22);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Add"));
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 160, 135);
        this.bnRemoveSubPartTS = new JButton(Messages.getString("TBPartitionPropertyDialogOracle.Remove"));
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 160, 165);
        TBPartitionPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    private void initSubPartOrderTab() {
        this.subPartOrderPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionsOrder"), this.subPartOrderPanel);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        btnProperties.addActionListener(new SubPartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            btnUp.addActionListener(new SubMoveUpAction());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            btnDown.addActionListener(new SubMoveDownAction());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.subPartOrderPanel.add(buttonGeneral);
        this.setObjectConstraints(this.getSubPartOrderLayout(), buttonGeneral, 10, 0);
        this.subPartitionsOrderModel = new SubPartitionsOrderModel();
        this.subPartSelectionModel = new DefaultListSelectionModel();
        this.subPartSelectionModel.setSelectionMode(2);
        this.subPartitionsOrderTable = new JTable(this.subPartitionsOrderModel);
        this.subPartitionsOrderTable.setSelectionModel(this.subPartSelectionModel);
        JScrollPane sp = new JScrollPane(this.subPartitionsOrderTable);
        sp.setPreferredSize(new Dimension(400, 270));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartOrderPanel.add(sp);
        this.setObjectConstraints(this.getSubPartOrderLayout(), sp, 6, 40);
    }

    private SpringLayout getSubPartOrderLayout() {
        return (SpringLayout)this.subPartOrderPanel.getLayout();
    }

    private StorageObjectCollection getSubPartitions() {
        PartitionListOracle partList = this.partition.getPartitionList();
        if (partList != null) {
            String subpartType = partList.getSubpartitionType();
            if (subpartType.equals("HASH")) {
                return this.partition.getPartitions();
            }
            if (subpartType.equals("LIST")) {
                return this.partition.getListPartitions();
            }
            if (subpartType.equals("RANGE")) {
                return ((PartitionOraclev11g)this.partition).getRangeSubpartitions();
            }
        }
        return null;
    }

    private boolean subMoveToIndex(Object object, int index) {
        if (this.subPartitions.contains(object) && this.subPartitions.size() > index && index >= 0) {
            this.subPartitions.remove(object);
            this.subPartitions.add(index, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel selModel, int[] selection) {
        selModel.clearSelection();
        if (selection.length > 0) {
            for (int i = selection.length - 1; i > -1; --i) {
                selModel.addSelectionInterval(selection[i], selection[i]);
            }
        }
    }

    @Override
    public void initProperties() {
        int i;
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.tfValueList.setText(this.partition.getValueList());
        this.ifPosition.setValue((long)this.partition.getPosition());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.cbLogging.setSelectedItem(TBPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.partition.getLogging()));
        this.selectObject(this.cbSegment, this.partition.getSegment());
        this.cbSegmentCompression.setSelectedItem(TBPartitionPropertyDialogOraclev10g.translateYesNoForDisplay(this.partition.getDataSegmentCompression()));
        this.ifIotCompress.setValue((long)this.partition.getIOTCompress());
        this.selectObject(this.cbIotOverflowSegment, this.partition.getIOTOverflowSegment());
        PartitionListOracle pl = this.partition.getPartitionList();
        if (pl == null || this.partition.hasSubPartitions() || !pl.getSubpartitionType().equalsIgnoreCase("HASH")) {
            this.ifSubPartQuantity.setEnabled(false);
            int ind = this.getPane().indexOfComponent(this.subPartTS);
            if (ind > -1) {
                this.getPane().setEnabledAt(ind, false);
            }
        } else {
            this.ifSubPartQuantity.setValue((long)this.partition.getSubPartitionsQuantity());
        }
        if (pl != null) {
            String partitionType = pl.getPartitionType();
            if (partitionType.equalsIgnoreCase("REFERENCE") || partitionType.equalsIgnoreCase("SYSTEM")) {
                this.tfValueList.setEnabled(false);
            }
            this.subPartitions = new ArrayList();
            StorageObjectCollection subParts = this.getSubPartitions();
            if (subParts != null) {
                subParts.setForbiddenCreateElement(true);
                subParts.addAllElementsTo(this.subPartitions);
            }
            Iterator tsIt = this.partition.getSubPartTSSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedSubPartTSModel.addElement(ts);
            }
            TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
            for (i = 0; i < tsSet.length; ++i) {
                TableSpaceOracle ts = tsSet[i];
                if (this.selectedSubPartTSModel.contains(ts)) continue;
                this.allSubPartTSModel.addElement(ts);
            }
        } else if (this.partition instanceof PartitionOraclev11g) {
            AbstractStorageObjectOracle owningPartition = ((PartitionOraclev11g)this.partition).getSubPartitionOf();
            if (owningPartition instanceof PartitionOracle) {
                pl = ((PartitionOracle)owningPartition).getPartitionList();
            } else if (owningPartition instanceof ListPartitionOracle) {
                pl = ((ListPartitionOracle)owningPartition).getPartitionList();
            } else if (owningPartition instanceof HashPartitionOracle) {
                pl = ((HashPartitionOracle)owningPartition).getPartitionList();
            }
        }
        TableProxyOracle table = null;
        if (pl != null) {
            SnapshotOracle snapshot;
            table = pl.getTable();
            if (table == null && (snapshot = pl.getSnapshot()) != null) {
                table = snapshot.getImplementedTable();
            }
        } else if (this.partition instanceof PartitionOraclev11g) {
            table = ((PartitionOraclev11g)this.partition).getPartOfStorageTable();
        }
        if (table != null) {
            boolean indexOrg = table.getOrganization().equals(TableProxyOracle.getOrganizationChoices()[1]);
            boolean normalPartition = this.partition.getPartitionList() != null;
            this.cbLogging.setEnabled(normalPartition);
            this.ifIotCompress.setEnabled(indexOrg);
            this.cbIotOverflowSegment.setEnabled(normalPartition && indexOrg);
            IndexProxy[] indexSet = table.getIndexProxies();
            for (i = 0; i < indexSet.length; ++i) {
                IndexProxyOracle index = (IndexProxyOracle)indexSet[i];
                if (index == null || !index.getIndexPartitioned().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(index);
            }
            for (BitmapJoinIndexOraclev10g bji : table.getBjIndexes()) {
                if (!bji.getLocalPartitioning().equalsIgnoreCase("YES")) continue;
                this.listModel.addElement(bji);
            }
            for (UniqueOraclev10g unique : table.getUniqueKeys()) {
                if (!unique.getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(unique);
            }
            for (PKProxyOraclev10g pk : table.getPrimaryKeys()) {
                if (!pk.getUsingIndex().equalsIgnoreCase("local")) continue;
                this.listModel.addElement(pk);
            }
        }
        for (int i2 = 0; i2 < this.listModel.size(); ++i2) {
            LocalIndexProperties lip;
            StorageObject index;
            if (this.listModel.get(i2) instanceof IndexProxyOraclev10g) {
                index = (IndexProxyOraclev10g)this.listModel.get(i2);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setIndex(index);
                lip.setPartition(this.partition);
                continue;
            }
            if (this.listModel.get(i2) instanceof BitmapJoinIndexOraclev10g) {
                index = (BitmapJoinIndexOraclev10g)this.listModel.get(i2);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setIndex(index);
                lip.setPartition(this.partition);
                continue;
            }
            if (this.listModel.get(i2) instanceof UniqueOraclev10g) {
                index = (UniqueOraclev10g)this.listModel.get(i2);
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
                if (lip != null) continue;
                lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
                lip.setIndex(index);
                lip.setPartition(this.partition);
                continue;
            }
            if (!(this.listModel.get(i2) instanceof PKProxyOraclev10g)) continue;
            index = (PKProxyOraclev10g)this.listModel.get(i2);
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().getLocalIndexPropertiesFor(this.partition, index);
            if (lip != null) continue;
            lip = this.getStorageDesign().getLocalIndexPropertiesSet().createLocalIndexProperties();
            lip.setIndex(index);
            lip.setPartition(this.partition);
        }
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            StorageObjectCollection storedSubParts;
            int size;
            this.partition.setName(this.tfName.getText());
            this.partition.setValueList(this.tfValueList.getText());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOraclev10g) {
                this.partition.setTableSpace((TableSpaceOraclev10g)selected);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setLogging(TBPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev10g) {
                this.partition.setSegment((SegmentOraclev10g)selected);
            } else {
                this.partition.setSegment(null);
            }
            this.partition.setDataSegmentCompression(TBPartitionPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbSegmentCompression.getSelectedItem()));
            this.partition.setIOTCompress(this.ifIotCompress.getIntValue());
            selected = this.cbIotOverflowSegment.getSelectedItem();
            if (selected instanceof SegmentOraclev10g) {
                this.partition.setIOTOverflowSegment((SegmentOraclev10g)selected);
            } else {
                this.partition.setIOTOverflowSegment(null);
            }
            this.partition.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
            if (this.selectedSubPartTSModel != null) {
                this.partition.getSubPartTSSet().clear();
                Object[] tsSet = this.selectedSubPartTSModel.toArray();
                for (int i = 0; i < tsSet.length; ++i) {
                    Object ts = tsSet[i];
                    if (!(ts instanceof TableSpaceOraclev10g)) continue;
                    this.partition.setSubPartitionsTableSpaces(((TableSpaceOraclev10g)ts).getObjectID());
                }
            }
            if (this.subPartOrdered && (size = (storedSubParts = this.getSubPartitions()).size()) == this.subPartitions.size()) {
                this.subPartOrdered = false;
                for (int i = 0; i < size; ++i) {
                    storedSubParts.justRemove(storedSubParts.getElement(0));
                }
                for (int i = 0; i < size; ++i) {
                    if (this.subPartitions.get(i) instanceof PartitionOracle) {
                        PartitionOracle p = (PartitionOracle)this.subPartitions.get(i);
                        p.setParent(storedSubParts);
                        storedSubParts.add(p);
                        p.setPosition(i + 1);
                        continue;
                    }
                    storedSubParts.add((ModelObject)this.subPartitions.get(i));
                }
            }
            this.partition.setComment(this.getCommentsList().getText());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.edit.setEnabled(false);
            } else {
                this.edit.setEnabled(true);
            }
        }
    }

    @Override
    protected void clearOnDispose() {
        StorageObjectCollection subParts;
        PartitionListOracle partitionList = this.partition.getPartitionList();
        if (partitionList != null && (subParts = this.getSubPartitions()) != null) {
            subParts.setForbiddenCreateElement(partitionList.getSubpartitionType().equals(""));
        }
    }

    class IndexesCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public IndexesCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Index) {
                this.setText(((Index)value).getName());
            } else {
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }

    private class listMouseListener
    extends MouseAdapter {
        private listMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TBPartitionPropertyDialogOraclev10g.this.editSelected();
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev10g.this.allSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev10g.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev10g.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    TBPartitionPropertyDialogOraclev10g.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    TBPartitionPropertyDialogOraclev10g.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = TBPartitionPropertyDialogOraclev10g.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.contains(ob)) continue;
                    TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.addElement(ob);
                    TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.contains(ob)) continue;
                    TBPartitionPropertyDialogOraclev10g.this.allSubPartTSModel.addElement(ob);
                    TBPartitionPropertyDialogOraclev10g.this.selectedSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class SubPartitionPropertiesAction
    implements ActionListener {
        private SubPartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.getSelectedRow();
            if (row > -1 && row < TBPartitionPropertyDialogOraclev10g.this.subPartitions.size()) {
                StorageObject selected = (StorageObject)TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(row);
                selected.showPropertyDialog();
            }
        }
    }

    private class SubMoveUpAction
    implements ActionListener {
        private SubMoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(objectNumber);
                    TBPartitionPropertyDialogOraclev10g.this.subMoveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                TBPartitionPropertyDialogOraclev10g.this.setSelection(TBPartitionPropertyDialogOraclev10g.this.subPartSelectionModel, selection);
                TBPartitionPropertyDialogOraclev10g.this.subPartOrdered = true;
                TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubMoveDownAction
    implements ActionListener {
        private SubMoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < TBPartitionPropertyDialogOraclev10g.this.subPartitions.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(objectNumber);
                    TBPartitionPropertyDialogOraclev10g.this.subMoveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                TBPartitionPropertyDialogOraclev10g.this.setSelection(TBPartitionPropertyDialogOraclev10g.this.subPartSelectionModel, selection);
                TBPartitionPropertyDialogOraclev10g.this.subPartOrdered = true;
                TBPartitionPropertyDialogOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubPartitionsOrderModel
    extends AbstractTableModel {
        private SubPartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (TBPartitionPropertyDialogOraclev10g.this.subPartitions == null) {
                return 0;
            }
            return TBPartitionPropertyDialogOraclev10g.this.subPartitions.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TBPartitionPropertyDialogOracle.SubPartitionName");
            }
            if (column == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StorageObject sel = (StorageObject)TBPartitionPropertyDialogOraclev10g.this.subPartitions.get(row);
            if (col == 0) {
                return sel.getName();
            }
            if (col == 1) {
                if (sel instanceof PartitionOracle) {
                    return ((PartitionOracle)sel).getValueList();
                }
                if (sel instanceof ListStorageTemplatePartitionOracle) {
                    return ((ListStorageTemplatePartitionOracle)sel).getValueList();
                }
                return "";
            }
            return new Integer(row * col);
        }
    }
}

