/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.ListPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ListStorageTemplatePartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractPropertyTabOracle;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.SnapshotPropertyDialogOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TablePropertyDialogOraclev10g;
import oracle.dbtools.crest.util.gui.swing.JPositiveIntegerField;

public class PartitionPropertyTabOraclev10g
extends AbstractPropertyTabOracle {
    private AbstractOraclePropertyDialog parentDialog;
    protected StorageObject ownerStorageObject;
    protected PartitionListOraclev10g partList;
    protected boolean useColumnProxies = false;
    protected JTabbedPane tpPartitions;
    protected JPanel pnPartGeneral;
    protected JComboBox cbPartType;
    private JComboBox cbUseSubpartitionsStorageTemplate;
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAdd;
    private JButton bnRemove;
    private JTextArea taColumns;
    private JPanel hashPTS;
    private int hashPTSTabIndex;
    private JPositiveIntegerField ifHashPQuantity;
    private JList allHashPTSList;
    private JList selectedHashPTSList;
    private DefaultListModel allHashPTSModel;
    private DefaultListModel selectedHashPTSModel;
    private JButton bnAddHashPTS;
    private JButton bnRemoveHashPTS;
    private JList allIOTOverflowHashPTSList;
    private JList selectedIOTOverflowHashPTSList;
    private DefaultListModel allIOTOverflowHashPTSModel;
    private DefaultListModel selectedIOTOverflowHashPTSModel;
    private JButton bnAddIOTOverflowHashPTS;
    private JButton bnRemoveIOTOverflowHashPTS;
    private JPanel subPartColumns;
    private int subPartColumnsTabIndex;
    protected JList allSubPartColumnsList;
    private JList selectedSubPartColumnsList;
    protected DefaultListModel allSubPartColumnsModel;
    protected DefaultListModel selectedSubPartColumnsModel;
    private JButton bnAddSubPartColumns;
    private JButton bnRemoveSubPartColumns;
    private JTextArea taSubPartColumns;
    private JPanel subPartTS;
    private int subPartTSTabIndex;
    private JPositiveIntegerField ifSubPartQuantity;
    private JList allSubPartTSList;
    private JList selectedSubPartTSList;
    private DefaultListModel allSubPartTSModel;
    private DefaultListModel selectedSubPartTSModel;
    private JButton bnAddSubPartTS;
    private JButton bnRemoveSubPartTS;
    private JPanel partitionsOrder;
    private JTable partitionsOrderTable;
    private List partitions;
    private DefaultListSelectionModel partSelectionModel;
    private PartitionsOrderModel partitionsOrderModel;
    private boolean ordered = false;
    private JTable subPartitionsOrderTable;
    private List subPartitions;
    private DefaultListSelectionModel subPartSelectionModel;
    private SubPartitionsOrderModel subPartitionsOrderModel;
    private boolean subPartOrdered = false;

    public PartitionPropertyTabOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject ownerStorageObject, AbstractOraclePropertyDialog parentDialog) {
        super(view, storageDesign, ownerStorageObject);
        this.parentDialog = parentDialog;
        this.ownerStorageObject = ownerStorageObject;
        if (ownerStorageObject instanceof TableProxyOracle) {
            this.partList = (PartitionListOraclev10g)((TableProxyOracle)ownerStorageObject).getPartitionList();
            this.useColumnProxies = true;
        } else if (ownerStorageObject instanceof SnapshotOracle) {
            this.partList = (PartitionListOraclev10g)((SnapshotOracle)ownerStorageObject).getPartitionList();
            this.useColumnProxies = false;
        }
    }

    @Override
    protected int getDialogWidth() {
        return 480;
    }

    public JPanel addTab(JTabbedPane parentPane) {
        JPanel pnPartitions = new JPanel(new BorderLayout());
        parentPane.addTab(Messages.getString("PartitionPropertyTabOraclev10g.Partitioning"), pnPartitions);
        this.tpPartitions = new JTabbedPane();
        pnPartitions.add((Component)this.tpPartitions, "Center");
        this.pnPartGeneral = new JPanel(new SpringLayout());
        this.hashPTS = new JPanel(new SpringLayout());
        this.subPartColumns = new JPanel(new SpringLayout());
        this.subPartTS = new JPanel(new SpringLayout());
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.General"), this.pnPartGeneral);
        this.addIntervalTab();
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.HashPartTableSpaces"), this.hashPTS);
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.SubPartColumns"), this.subPartColumns);
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.HashSubPartTableSpaces"), this.subPartTS);
        this.tpPartitions.addTab(Messages.getString("PartitionPropertyTabOraclev10g.PartitionsOrder"), this.partitionsOrder);
        this.hashPTSTabIndex = this.tpPartitions.indexOfComponent(this.hashPTS);
        this.subPartColumnsTabIndex = this.tpPartitions.indexOfComponent(this.subPartColumns);
        this.subPartTSTabIndex = this.tpPartitions.indexOfComponent(this.subPartTS);
        this.initPartitioning();
        return pnPartitions;
    }

    protected void addIntervalTab() {
    }

    protected SpringLayout getHashPTSLayout() {
        return (SpringLayout)this.hashPTS.getLayout();
    }

    protected SpringLayout getSubPartTSLayout() {
        return (SpringLayout)this.subPartTS.getLayout();
    }

    protected SpringLayout getSubPartColumnsLayout() {
        return (SpringLayout)this.subPartColumns.getLayout();
    }

    protected SpringLayout getGeneralPartitioningLayout() {
        return (SpringLayout)this.pnPartGeneral.getLayout();
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initPartitioning() {
        this.initGeneralPartitioning();
        this.initHashPTS();
        this.initSubPartColumns();
        this.initSubPartTS();
        this.initPartitionsOrderPanel();
    }

    protected void initGeneralPartitioning() {
        this.initPartType();
        this.initUseSubpartitionsStorageTemplate(50);
        this.initHashPQuantity(80);
        this.initSubPartQuantity(110);
        if (this.useColumnProxies) {
            this.initAllColumnsList(144, 380);
            this.initSelectedColumnsList(144, 380);
            this.initButtons();
        } else {
            this.initColumnsTextArea(140, 385);
        }
    }

    protected void initColumnsTextArea(int yCoord, int depth) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.PartitioningColumns"));
        this.pnPartGeneral.add(label);
        this.taColumns = new JTextArea();
        JScrollPane spColumns = new JScrollPane(this.taColumns);
        spColumns.setPreferredSize(new Dimension(395, depth));
        spColumns.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(spColumns);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), spColumns, 10, yCoord + 20);
    }

    private void initHashPTS() {
        this.initAllHashPTSList();
        this.initSelectedHashPTSList();
        this.initHashPTSButtons();
        this.initAllIOTOverflowHashPTSList();
        this.initSelectedIOTOverflowHashPTSList();
        this.initIOTOverflowHashPTSButtons();
    }

    private void initSubPartColumns() {
        if (this.useColumnProxies) {
            this.initAllSubPartColumnsList();
            this.initSelectedSubPartColumnsList();
            this.initSubPartColumnsButtons();
        } else {
            this.taSubPartColumns = new JTextArea();
            JScrollPane spColumns = new JScrollPane(this.taSubPartColumns);
            spColumns.setPreferredSize(new Dimension(395, 505));
            spColumns.setBorder(BorderFactory.createEtchedBorder(0));
            this.subPartColumns.add(spColumns);
            this.setObjectConstraints(this.getSubPartColumnsLayout(), spColumns, 10, 12);
        }
    }

    private void initSubPartTS() {
        this.initAllSubPartTSList();
        this.initSelectedSubPartTSList();
        this.initSubPartTSButtons();
    }

    private void initPartitionsOrderPanel() {
        this.initPartitionsOrder();
        this.initSubPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        btnProperties.addActionListener(new PartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            btnUp.addActionListener(new MoveUpAction2());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            btnDown.addActionListener(new MoveDownAction2());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.partitionsOrder.add(buttonGeneral);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), buttonGeneral, 10, 0);
        this.partitionsOrderModel = new PartitionsOrderModel();
        this.partSelectionModel = new DefaultListSelectionModel();
        this.partSelectionModel.setSelectionMode(2);
        this.partitionsOrderTable = new JTable(this.partitionsOrderModel);
        this.partitionsOrderTable.setSelectionModel(this.partSelectionModel);
        JScrollPane sp = new JScrollPane(this.partitionsOrderTable);
        sp.setPreferredSize(new Dimension(400, 240));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(sp);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), sp, 6, 40);
        this.getPartitions().setForbiddenCreateElement(true);
        this.partitions = new ArrayList();
        this.getPartitions().addAllElementsTo(this.partitions);
    }

    private void initSubPartitionsOrder() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SubPartitionTemplates"));
        this.partitionsOrder.add(label);
        this.setLabelConstraints(this.getPartitionsOrderLayout(), label, 300);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.Properties"));
        btnProperties.addActionListener(new SubPartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveUp"));
            btnUp.addActionListener(new SubMoveUpAction());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("PartitionPropertyTabOraclev10g.MoveDown"));
            btnDown.addActionListener(new SubMoveDownAction());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.partitionsOrder.add(buttonGeneral);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), buttonGeneral, 10, 315);
        this.subPartitionsOrderModel = new SubPartitionsOrderModel();
        this.subPartSelectionModel = new DefaultListSelectionModel();
        this.subPartSelectionModel.setSelectionMode(2);
        this.subPartitionsOrderTable = new JTable(this.subPartitionsOrderModel);
        this.subPartitionsOrderTable.setSelectionModel(this.subPartSelectionModel);
        JScrollPane sp = new JScrollPane(this.subPartitionsOrderTable);
        sp.setPreferredSize(new Dimension(400, 155));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(sp);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), sp, 6, 355);
        this.subPartitions = new ArrayList();
        StorageObjectCollection templates = this.getSubPartitionTemplates();
        if (templates != null) {
            templates.setForbiddenCreateElement(true);
            templates.addAllElementsTo(this.subPartitions);
        }
    }

    protected void initPartType() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.PartitionType"));
        this.pnPartGeneral.add(label);
        this.cbPartType = new JComboBox<String>(this.getPartitionTypes());
        this.setBG(this.cbPartType);
        this.cbPartType.addActionListener(new PartitionTypeListener());
        this.pnPartGeneral.add(this.cbPartType);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 20);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbPartType, 20);
    }

    protected String[] getPartitionTypes() {
        return PartitionListOraclev10g.getPartitionTypes();
    }

    protected void initUseSubpartitionsStorageTemplate(int yCoord) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.UseSPTemplate"));
        this.pnPartGeneral.add(label);
        this.cbUseSubpartitionsStorageTemplate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbUseSubpartitionsStorageTemplate);
        this.cbUseSubpartitionsStorageTemplate.setPreferredSize(this.cbPartType.getPreferredSize());
        this.cbUseSubpartitionsStorageTemplate.addActionListener(new PartitionTypeListener());
        this.pnPartGeneral.add(this.cbUseSubpartitionsStorageTemplate);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.cbUseSubpartitionsStorageTemplate, yCoord);
    }

    protected void initHashPQuantity(int yCoord) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.HashPQuantity"));
        this.pnPartGeneral.add(label);
        this.ifHashPQuantity = new JPositiveIntegerField();
        this.ifHashPQuantity.setPreferredSize(this.cbPartType.getPreferredSize());
        this.pnPartGeneral.add(this.ifHashPQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifHashPQuantity, yCoord);
    }

    protected void initSubPartQuantity(int yCoord) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SubPartQuantity"));
        this.pnPartGeneral.add(label);
        this.ifSubPartQuantity = new JPositiveIntegerField();
        this.ifSubPartQuantity.setPreferredSize(this.cbPartType.getPreferredSize());
        this.pnPartGeneral.add(this.ifSubPartQuantity);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.ifSubPartQuantity, yCoord);
    }

    private void initAllHashPTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.hashPTS.add(label);
        this.allHashPTSModel = new DefaultListModel();
        this.allHashPTSList = new JList(this.allHashPTSModel);
        ListSelectionModel listSelectionModel = this.allHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allHashPTSList);
        sp.setPreferredSize(new Dimension(144, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 8, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 6, 72);
    }

    private void initSelectedHashPTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.HashPTableSpaces"));
        this.hashPTS.add(label);
        this.selectedHashPTSModel = new DefaultListModel();
        this.selectedHashPTSList = new JList(this.selectedHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedHashPTSList);
        sp.setPreferredSize(new Dimension(145, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 292, 54);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 290, 72);
    }

    private void initHashPTSButtons() {
        this.bnAddHashPTS = new JButton(ADD_CAPTION);
        this.bnAddHashPTS.addActionListener(new AddHashPTSActionListener());
        this.bnAddHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddHashPTS, 175, 135);
        this.bnRemoveHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveHashPTS.setEnabled(false);
        this.bnRemoveHashPTS.addActionListener(new RemoveHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveHashPTS, 175, 165);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddHashPTS, this.bnRemoveHashPTS);
    }

    private void initAllIOTOverflowHashPTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.hashPTS.add(label);
        this.allIOTOverflowHashPTSModel = new DefaultListModel();
        this.allIOTOverflowHashPTSList = new JList(this.allIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.allIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIOTOverflowHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allIOTOverflowHashPTSList);
        sp.setPreferredSize(new Dimension(144, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 8, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 6, 312);
    }

    private void initSelectedIOTOverflowHashPTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.IOTOverflowTS"));
        this.hashPTS.add(label);
        this.selectedIOTOverflowHashPTSModel = new DefaultListModel();
        this.selectedIOTOverflowHashPTSList = new JList(this.selectedIOTOverflowHashPTSModel);
        ListSelectionModel listSelectionModel = this.selectedIOTOverflowHashPTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIOTOverflowHashPTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedIOTOverflowHashPTSList);
        sp.setPreferredSize(new Dimension(145, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.hashPTS.add(sp);
        this.setLabelConstraints(this.getHashPTSLayout(), label, 292, 294);
        this.setObjectConstraints(this.getHashPTSLayout(), sp, 290, 312);
    }

    private void initIOTOverflowHashPTSButtons() {
        this.bnAddIOTOverflowHashPTS = new JButton(ADD_CAPTION);
        this.bnAddIOTOverflowHashPTS.addActionListener(new AddIOTOverflowHashPTSActionListener());
        this.bnAddIOTOverflowHashPTS.setEnabled(false);
        this.hashPTS.add(this.bnAddIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnAddIOTOverflowHashPTS, 175, 370);
        this.bnRemoveIOTOverflowHashPTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
        this.bnRemoveIOTOverflowHashPTS.addActionListener(new RemoveIOTOverflowHashPTSActionListener());
        this.hashPTS.add(this.bnRemoveIOTOverflowHashPTS);
        this.setObjectConstraints(this.getHashPTSLayout(), this.bnRemoveIOTOverflowHashPTS, 175, 400);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddIOTOverflowHashPTS, this.bnRemoveIOTOverflowHashPTS);
    }

    private ColumnProxy[] getColumnProxies() {
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            return ((TableProxyOracle)this.ownerStorageObject).getColumnProxies();
        }
        return new ColumnProxy[0];
    }

    protected void initPartColumns(PartitionListOraclev10g partList) {
        if (this.useColumnProxies) {
            ColumnProxy[] columnSet = this.getColumnProxies();
            if (partList != null) {
                block0: for (String colId : partList.getColumnSet()) {
                    for (int i = 0; i < columnSet.length; ++i) {
                        ColumnProxy col = columnSet[i];
                        if (!col.getObjectID().equals(colId)) continue;
                        this.selectedColumnsModel.addElement(col);
                        continue block0;
                    }
                }
            }
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy col = columnSet[i];
                if (this.selectedColumnsModel.contains(col)) continue;
                this.allColumnsModel.addElement(col);
            }
        } else if (this.ownerStorageObject instanceof SnapshotOracle) {
            this.taColumns.setText(((SnapshotOracle)this.ownerStorageObject).getColumns());
        }
    }

    private void initHashPTS(PartitionListOraclev10g partList) {
        if (partList != null) {
            Iterator tsIt = partList.getHashPartitionsTableSpacesSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedHashPTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedHashPTSModel.contains(ts)) continue;
            this.allHashPTSModel.addElement(ts);
        }
    }

    private void initIOTOverflowHashPTS(PartitionListOraclev10g partList) {
        if (partList != null) {
            Iterator tsIt = partList.getIOTOverflowHashPTSSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedIOTOverflowHashPTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedIOTOverflowHashPTSModel.contains(ts)) continue;
            this.allIOTOverflowHashPTSModel.addElement(ts);
        }
    }

    protected void initSubPartColumns(PartitionListOraclev10g partList) {
        if (this.useColumnProxies) {
            ColumnProxy[] columnSet = this.getColumnProxies();
            if (partList != null) {
                block0: for (String colId : partList.getSubPartitionsColumnsSet()) {
                    for (int i = 0; i < columnSet.length; ++i) {
                        ColumnProxy col = columnSet[i];
                        if (!col.getObjectID().equals(colId)) continue;
                        this.selectedSubPartColumnsModel.addElement(col);
                        continue block0;
                    }
                }
            }
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy col = columnSet[i];
                if (this.selectedSubPartColumnsModel.contains(col)) continue;
                this.allSubPartColumnsModel.addElement(col);
            }
        } else if (this.ownerStorageObject instanceof SnapshotOracle) {
            this.taSubPartColumns.setText(((SnapshotOracle)this.ownerStorageObject).getSubPartColumns());
        }
    }

    private void initSubPartTS(PartitionListOraclev10g partList) {
        if (partList != null) {
            Iterator tsIt = partList.getSubPartitionsTableSpacesSet().iterator();
            while (tsIt.hasNext()) {
                ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                if (!(ts instanceof TableSpaceOracle)) continue;
                this.selectedSubPartTSModel.addElement(ts);
            }
        }
        TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tsSet.length; ++i) {
            TableSpaceOracle ts = tsSet[i];
            if (this.selectedSubPartTSModel.contains(ts)) continue;
            this.allSubPartTSModel.addElement(ts);
        }
    }

    protected void initAllColumnsList(int yCoord, int depth) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllColumns"));
        this.pnPartGeneral.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, depth));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(sp);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 8, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), sp, 6, yCoord + 18);
    }

    protected void initSelectedColumnsList(int yCoord, int depth) {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SelectedColumns"));
        this.pnPartGeneral.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, depth));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.pnPartGeneral.add(sp);
        this.setLabelConstraints(this.getGeneralPartitioningLayout(), label, 292, yCoord);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), sp, 290, yCoord + 18);
    }

    protected void initButtons() {
        this.bnAdd = new JButton(ADD_CAPTION);
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.pnPartGeneral.add(this.bnAdd);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnAdd, 175, 265);
        this.bnRemove = new JButton(REMOVE_CAPTION);
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.pnPartGeneral.add(this.bnRemove);
        this.setObjectConstraints(this.getGeneralPartitioningLayout(), this.bnRemove, 175, 295);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    private void initAllSubPartColumnsList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllColumns"));
        this.subPartColumns.add(label);
        this.allSubPartColumnsModel = new DefaultListModel();
        this.allSubPartColumnsList = new JList(this.allSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.allSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartColumnsList);
        sp.setPreferredSize(new Dimension(144, 490));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(sp);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), label, 8, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), sp, 6, 22);
    }

    private void initSelectedSubPartColumnsList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SelectedColumns"));
        this.subPartColumns.add(label);
        this.selectedSubPartColumnsModel = new DefaultListModel();
        this.selectedSubPartColumnsList = new JList(this.selectedSubPartColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartColumnsList);
        sp.setPreferredSize(new Dimension(145, 490));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartColumns.add(sp);
        this.setLabelConstraints(this.getSubPartColumnsLayout(), label, 292, 4);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), sp, 290, 22);
    }

    private void initSubPartColumnsButtons() {
        this.bnAddSubPartColumns = new JButton(ADD_CAPTION);
        this.bnAddSubPartColumns.addActionListener(new AddSubPartColumnsActionListener());
        this.bnAddSubPartColumns.setEnabled(false);
        this.subPartColumns.add(this.bnAddSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnAddSubPartColumns, 175, 230);
        this.bnRemoveSubPartColumns = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartColumns.setEnabled(false);
        this.bnRemoveSubPartColumns.addActionListener(new RemoveSubPartColumnsActionListener());
        this.subPartColumns.add(this.bnRemoveSubPartColumns);
        this.setObjectConstraints(this.getSubPartColumnsLayout(), this.bnRemoveSubPartColumns, 175, 260);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddSubPartColumns, this.bnRemoveSubPartColumns);
    }

    private void initAllSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.AllTableSpaces"));
        this.subPartTS.add(label);
        this.allSubPartTSModel = new DefaultListModel();
        this.allSubPartTSList = new JList(this.allSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 440));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 8, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 6, 72);
    }

    private void initSelectedSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyTabOraclev10g.SelectedTableSpaces"));
        this.subPartTS.add(label);
        this.selectedSubPartTSModel = new DefaultListModel();
        this.selectedSubPartTSList = new JList(this.selectedSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 440));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.subPartTS.add(sp);
        this.setLabelConstraints(this.getSubPartTSLayout(), label, 292, 54);
        this.setObjectConstraints(this.getSubPartTSLayout(), sp, 290, 72);
    }

    private void initSubPartTSButtons() {
        this.bnAddSubPartTS = new JButton(ADD_CAPTION);
        this.bnAddSubPartTS.addActionListener(new AddSubPartTSActionListener());
        this.bnAddSubPartTS.setEnabled(false);
        this.subPartTS.add(this.bnAddSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnAddSubPartTS, 175, 230);
        this.bnRemoveSubPartTS = new JButton(REMOVE_CAPTION);
        this.bnRemoveSubPartTS.setEnabled(false);
        this.bnRemoveSubPartTS.addActionListener(new RemoveSubPartTSActionListener());
        this.subPartTS.add(this.bnRemoveSubPartTS);
        this.setObjectConstraints(this.getSubPartTSLayout(), this.bnRemoveSubPartTS, 175, 260);
        AbstractPropertyDialog.equalizeButtonSizes(this.bnAddSubPartTS, this.bnRemoveSubPartTS);
    }

    protected void initProperties() {
        if (this.partList != null) {
            this.cbPartType.setSelectedItem(this.partList.getPartitionType());
            this.ifHashPQuantity.setValue((long)this.partList.getHashPQuantity());
            this.ifSubPartQuantity.setValue((long)this.partList.getSubPartitionsQuantity());
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(AbstractPropertyDialog.translateYesNoForDisplay(this.partList.getUseSubpartStorageTemplate()));
            this.reinitPartitioning(true);
        } else {
            this.ifHashPQuantity.setValue(1L);
            this.ifSubPartQuantity.setValue(1L);
            this.cbUseSubpartitionsStorageTemplate.setSelectedItem(NO);
        }
    }

    protected void reinitPartitioning(boolean partitioned) {
        if (this.useColumnProxies) {
            this.allColumnsModel.clear();
            this.selectedColumnsModel.clear();
            this.allSubPartColumnsModel.clear();
            this.selectedSubPartColumnsModel.clear();
        }
        this.allHashPTSModel.clear();
        this.selectedHashPTSModel.clear();
        this.allIOTOverflowHashPTSModel.clear();
        this.selectedIOTOverflowHashPTSModel.clear();
        this.allSubPartTSModel.clear();
        this.selectedSubPartTSModel.clear();
        this.cbPartType.setEnabled(partitioned);
        this.enableRelevantPartitionFields(partitioned);
        if (partitioned) {
            this.initPartColumns(this.partList);
            this.initHashPTS(this.partList);
            this.initIOTOverflowHashPTS(this.partList);
            this.initSubPartColumns(this.partList);
            this.initSubPartTS(this.partList);
        }
    }

    protected void enableRelevantPartitionFields(boolean partitioned) {
        String partType = "";
        boolean hashByQuantity = false;
        boolean subpartitioned = false;
        boolean hashSubPart = false;
        boolean enableColumns = false;
        if (partitioned) {
            partType = (String)this.cbPartType.getSelectedItem();
            hashByQuantity = partType.equalsIgnoreCase("HASH BY QUANTITY");
            subpartitioned = this.isSubpartitioned(partType);
            hashSubPart = this.isHashSubpartitioned(partType);
            enableColumns = partType.equalsIgnoreCase("RANGE") || partType.equalsIgnoreCase("LIST") || partType.equalsIgnoreCase("HASH BY LIST OF PARTITIONS") || hashByQuantity || subpartitioned;
        }
        this.cbUseSubpartitionsStorageTemplate.setEnabled(subpartitioned);
        this.ifHashPQuantity.setEnabled(hashByQuantity);
        this.ifSubPartQuantity.setEnabled(hashSubPart);
        if (this.useColumnProxies) {
            this.allColumnsList.setEnabled(enableColumns);
            this.selectedColumnsList.setEnabled(enableColumns);
            this.bnAdd.setEnabled(enableColumns && this.allColumnsList.getSelectedIndex() != -1);
            this.bnRemove.setEnabled(enableColumns && this.selectedColumnsList.getSelectedIndex() != -1);
        } else {
            this.taColumns.setEnabled(enableColumns);
        }
        this.tpPartitions.setEnabledAt(this.subPartColumnsTabIndex, subpartitioned);
        if (subpartitioned && this.useColumnProxies) {
            this.bnAddSubPartColumns.setEnabled(this.allSubPartColumnsList.getSelectedIndex() != -1);
            this.bnRemoveSubPartColumns.setEnabled(this.selectedSubPartColumnsList.getSelectedIndex() != -1);
        }
        this.tpPartitions.setEnabledAt(this.hashPTSTabIndex, hashByQuantity);
        if (hashByQuantity) {
            this.bnAddHashPTS.setEnabled(this.allHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveHashPTS.setEnabled(this.selectedHashPTSList.getSelectedIndex() != -1);
            boolean hashByQuantityIndexOrg = this.isIndexOrg();
            this.allIOTOverflowHashPTSList.setEnabled(hashByQuantityIndexOrg);
            this.selectedIOTOverflowHashPTSList.setEnabled(hashByQuantityIndexOrg);
            this.bnAddIOTOverflowHashPTS.setEnabled(hashByQuantityIndexOrg && this.allIOTOverflowHashPTSList.getSelectedIndex() != -1);
            this.bnRemoveIOTOverflowHashPTS.setEnabled(hashByQuantityIndexOrg && this.selectedIOTOverflowHashPTSList.getSelectedIndex() != -1);
        }
        boolean hashNoStorageTemplate = hashSubPart && ((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()).equalsIgnoreCase(NO);
        this.tpPartitions.setEnabledAt(this.subPartTSTabIndex, hashNoStorageTemplate);
        if (hashNoStorageTemplate) {
            this.bnAddSubPartTS.setEnabled(this.allSubPartTSList.getSelectedIndex() != -1);
            this.bnRemoveSubPartTS.setEnabled(this.selectedSubPartTSList.getSelectedIndex() != -1);
        }
    }

    protected boolean isSubpartitioned(String partType) {
        return partType.equalsIgnoreCase("COMPOSITE BY HASH") || partType.equalsIgnoreCase("COMPOSITE BY LIST");
    }

    protected boolean isHashSubpartitioned(String partType) {
        return partType.equalsIgnoreCase("COMPOSITE BY HASH");
    }

    protected boolean isListSubpartitioned(String partType) {
        return partType.equalsIgnoreCase("COMPOSITE BY LIST");
    }

    protected boolean isPartitioned() {
        if (this.parentDialog instanceof TablePropertyDialogOraclev10g) {
            return ((TablePropertyDialogOraclev10g)this.parentDialog).isPartitioned();
        }
        if (this.parentDialog instanceof SnapshotPropertyDialogOraclev10g) {
            return ((SnapshotPropertyDialogOraclev10g)this.parentDialog).isPartitioned();
        }
        return false;
    }

    private boolean isIndexOrg() {
        if (this.parentDialog instanceof TablePropertyDialogOraclev10g) {
            return ((TablePropertyDialogOraclev10g)this.parentDialog).isIndexOrg();
        }
        if (this.parentDialog instanceof SnapshotPropertyDialogOraclev10g) {
            return ((SnapshotPropertyDialogOraclev10g)this.parentDialog).isIndexOrg();
        }
        return false;
    }

    protected void setProperties(boolean partitioned) {
        if (partitioned) {
            StorageObjectCollection storedTemplates;
            int i;
            StorageObjectCollection storedPartitions;
            int size;
            Object ts;
            boolean hashByQuantity;
            if (this.partList == null) {
                this.partList = (PartitionListOraclev10g)this.getStorageDesign().getPartitionListSet().createPartitionList();
            }
            String partType = (String)this.cbPartType.getSelectedItem();
            this.partList.setPartitionType(partType);
            this.partList.setUseSubpartStorageTemplate(AbstractPropertyDialog.translateYesNoForStorage((String)this.cbUseSubpartitionsStorageTemplate.getSelectedItem()));
            this.partList.setHashPQuantity(this.ifHashPQuantity.getIntValue());
            this.partList.setSubPartitionsQuantity(this.ifSubPartQuantity.getIntValue());
            if (this.ownerStorageObject instanceof TableProxyOracle) {
                ((TableProxyOracle)this.ownerStorageObject).setPartitionList(this.partList);
            } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                ((SnapshotOracle)this.ownerStorageObject).setPartitionList(this.partList);
            }
            this.partList.clear();
            if (this.useColumnProxies) {
                Object[] columnSet = this.selectedColumnsModel.toArray();
                for (int i2 = 0; i2 < columnSet.length; ++i2) {
                    Object ob = columnSet[i2];
                    if (!(ob instanceof RelationalObjectProxy)) continue;
                    this.partList.setColumnIDs(((RelationalObjectProxy)ob).getObjectID());
                }
            } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                ((SnapshotOracle)this.ownerStorageObject).setColumns(this.taColumns.getText());
            }
            if (hashByQuantity = partType.equalsIgnoreCase("HASH BY QUANTITY")) {
                Object[] tsSet = this.selectedHashPTSModel.toArray();
                for (int i3 = 0; i3 < tsSet.length; ++i3) {
                    ts = tsSet[i3];
                    if (!(ts instanceof TableSpaceOracle)) continue;
                    this.partList.setHashPTableSpaces(((TableSpaceOracle)ts).getObjectID());
                }
            }
            if (hashByQuantity && this.isIndexOrg()) {
                Object[] tsIOTSet = this.selectedIOTOverflowHashPTSModel.toArray();
                for (int i4 = 0; i4 < tsIOTSet.length; ++i4) {
                    ts = tsIOTSet[i4];
                    if (!(ts instanceof TableSpaceOracle)) continue;
                    this.partList.setIOTOverflowHashPTSSet(((TableSpaceOracle)ts).getObjectID());
                }
            }
            if (this.isSubpartitioned(partType)) {
                if (this.useColumnProxies) {
                    if (this.isSubpartitioned(partType)) {
                        Object[] columnSet = this.selectedSubPartColumnsModel.toArray();
                        for (int i5 = 0; i5 < columnSet.length; ++i5) {
                            Object ob = columnSet[i5];
                            if (!(ob instanceof RelationalObjectProxy)) continue;
                            this.partList.setSubPartitionsColumnIDs(((RelationalObjectProxy)ob).getObjectID());
                        }
                    }
                } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                    ((SnapshotOracle)this.ownerStorageObject).setSubPartColumns(this.taSubPartColumns.getText());
                }
                Object[] tsSet = this.selectedSubPartTSModel.toArray();
                for (int i6 = 0; i6 < tsSet.length; ++i6) {
                    ts = tsSet[i6];
                    if (!(ts instanceof TableSpaceOracle)) continue;
                    this.partList.setSubPartitionsTableSpaces(((TableSpaceOracle)ts).getObjectID());
                }
            }
            if (this.ordered && (size = (storedPartitions = this.getPartitions()).size()) == this.partitions.size()) {
                this.ordered = false;
                for (int i7 = 0; i7 < size; ++i7) {
                    storedPartitions.justRemove(storedPartitions.getElement(0));
                }
                for (i = 0; i < size; ++i) {
                    if (this.partitions.get(i) instanceof PartitionOracle) {
                        PartitionOracle p = (PartitionOracle)this.partitions.get(i);
                        p.setParent(storedPartitions);
                        storedPartitions.add(p);
                        p.setPosition(i + 1);
                        continue;
                    }
                    storedPartitions.add((ModelObject)this.partitions.get(i));
                }
            }
            if (this.subPartOrdered && (size = (storedTemplates = this.getSubPartitionTemplates()).size()) == this.subPartitions.size()) {
                this.subPartOrdered = false;
                for (int i8 = 0; i8 < size; ++i8) {
                    storedTemplates.justRemove(storedTemplates.getElement(0));
                }
                for (i = 0; i < size; ++i) {
                    if (this.subPartitions.get(i) instanceof PartitionOracle) {
                        PartitionOracle p = (PartitionOracle)this.subPartitions.get(i);
                        p.setParent(storedTemplates);
                        storedTemplates.add(p);
                        p.setPosition(i + 1);
                        continue;
                    }
                    storedTemplates.add((ModelObject)this.subPartitions.get(i));
                }
            }
        } else if (this.partList != null) {
            if (this.ownerStorageObject instanceof TableProxyOracle) {
                ((TableProxyOracle)this.ownerStorageObject).setPartitionList(null);
            } else if (this.ownerStorageObject instanceof SnapshotOracle) {
                ((SnapshotOracle)this.ownerStorageObject).setPartitionList(null);
            }
            this.partList.remove();
            this.partList = null;
        }
    }

    private StorageObjectCollection getPartitions() {
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            return ((TableProxyOracle)this.ownerStorageObject).getPartitions();
        }
        if (this.ownerStorageObject instanceof SnapshotOracle) {
            return ((SnapshotOracle)this.ownerStorageObject).getPartitionsCollection();
        }
        return null;
    }

    private boolean moveToIndex(Object object, int index) {
        if (this.partitions.contains(object) && this.partitions.size() > index && index >= 0) {
            this.partitions.remove(object);
            this.partitions.add(index, object);
            return true;
        }
        return false;
    }

    private StorageObjectCollection getSubPartitionTemplates() {
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            return ((TableProxyOracle)this.ownerStorageObject).getListStorageTemplates();
        }
        return null;
    }

    private boolean subMoveToIndex(Object object, int index) {
        if (this.subPartitions.contains(object) && this.subPartitions.size() > index && index >= 0) {
            this.subPartitions.remove(object);
            this.subPartitions.add(index, object);
            return true;
        }
        return false;
    }

    private void setSelection(DefaultListSelectionModel selModel, int[] selection) {
        selModel.clearSelection();
        if (selection.length > 0) {
            for (int i = selection.length - 1; i > -1; --i) {
                selModel.addSelectionInterval(selection[i], selection[i]);
            }
        }
    }

    protected void postProcessingInApply() {
        this.getPartitions().setForbiddenCreateElement(true);
        StorageObjectCollection templates = this.getSubPartitionTemplates();
        if (templates != null) {
            templates.setForbiddenCreateElement(true);
        }
    }

    protected void clearOnDispose() {
        boolean partitioned = false;
        PartitionListOracle partitionList = null;
        if (this.ownerStorageObject instanceof TableProxyOracle) {
            TableProxyOracle tableProxy = (TableProxyOracle)this.ownerStorageObject;
            partitioned = tableProxy.getPartitioned().equals("YES");
            partitionList = tableProxy.getPartitionList();
        } else if (this.ownerStorageObject instanceof SnapshotOracle) {
            SnapshotOracle snapshot = (SnapshotOracle)this.ownerStorageObject;
            partitioned = snapshot.getPartitioned().equals("YES");
            partitionList = snapshot.getPartitionList();
        }
        this.getPartitions().setForbiddenCreateElement(!partitioned || partitionList == null || "HASH BY QUANTITY".equalsIgnoreCase(partitionList.getPartitionType()));
        StorageObjectCollection templates = this.getSubPartitionTemplates();
        if (templates != null) {
            templates.setForbiddenCreateElement(!partitioned || partitionList == null || !((PartitionListOraclev10g)partitionList).getUseSubpartStorageTemplate().equalsIgnoreCase("YES"));
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = PartitionPropertyTabOraclev10g.this.partitionsOrderTable.getSelectedRow();
            if (row > -1 && row < PartitionPropertyTabOraclev10g.this.partitions.size()) {
                StorageObject selected = (StorageObject)PartitionPropertyTabOraclev10g.this.partitions.get(row);
                selected.showPropertyDialog();
            }
        }
    }

    private class MoveUpAction2
    implements ActionListener {
        private MoveUpAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = PartitionPropertyTabOraclev10g.this.partitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = PartitionPropertyTabOraclev10g.this.partitions.get(objectNumber);
                    PartitionPropertyTabOraclev10g.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.partSelectionModel, selection);
                PartitionPropertyTabOraclev10g.this.ordered = true;
                PartitionPropertyTabOraclev10g.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class MoveDownAction2
    implements ActionListener {
        private MoveDownAction2() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = PartitionPropertyTabOraclev10g.this.partitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < PartitionPropertyTabOraclev10g.this.partitions.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = PartitionPropertyTabOraclev10g.this.partitions.get(objectNumber);
                    PartitionPropertyTabOraclev10g.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.partSelectionModel, selection);
                PartitionPropertyTabOraclev10g.this.ordered = true;
                PartitionPropertyTabOraclev10g.this.partitionsOrderTable.updateUI();
            }
        }
    }

    private class PartitionsOrderModel
    extends AbstractTableModel {
        private PartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (PartitionPropertyTabOraclev10g.this.partitions == null) {
                return 0;
            }
            return PartitionPropertyTabOraclev10g.this.partitions.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PartitionPropertyTabOraclev10g.PartitionName");
            }
            if (column == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StorageObject sel = (StorageObject)PartitionPropertyTabOraclev10g.this.partitions.get(row);
            if (col == 0) {
                return sel.getName();
            }
            if (col == 1) {
                if (sel instanceof PartitionOracle) {
                    return ((PartitionOracle)sel).getValueList();
                }
                if (sel instanceof ListPartitionOracle) {
                    return ((ListPartitionOracle)sel).getColumns();
                }
                return "";
            }
            return new Integer(row * col);
        }
    }

    private class SubPartitionPropertiesAction
    implements ActionListener {
        private SubPartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.getSelectedRow();
            if (row > -1 && row < PartitionPropertyTabOraclev10g.this.subPartitions.size()) {
                StorageObject selected = (StorageObject)PartitionPropertyTabOraclev10g.this.subPartitions.get(row);
                selected.showPropertyDialog();
            }
        }
    }

    private class SubMoveUpAction
    implements ActionListener {
        private SubMoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = PartitionPropertyTabOraclev10g.this.subPartitions.get(objectNumber);
                    PartitionPropertyTabOraclev10g.this.subMoveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.subPartSelectionModel, selection);
                PartitionPropertyTabOraclev10g.this.subPartOrdered = true;
                PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubMoveDownAction
    implements ActionListener {
        private SubMoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < PartitionPropertyTabOraclev10g.this.subPartitions.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = PartitionPropertyTabOraclev10g.this.subPartitions.get(objectNumber);
                    PartitionPropertyTabOraclev10g.this.subMoveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                PartitionPropertyTabOraclev10g.this.setSelection(PartitionPropertyTabOraclev10g.this.subPartSelectionModel, selection);
                PartitionPropertyTabOraclev10g.this.subPartOrdered = true;
                PartitionPropertyTabOraclev10g.this.subPartitionsOrderTable.updateUI();
            }
        }
    }

    private class SubPartitionsOrderModel
    extends AbstractTableModel {
        private SubPartitionsOrderModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (PartitionPropertyTabOraclev10g.this.subPartitions == null) {
                return 0;
            }
            return PartitionPropertyTabOraclev10g.this.subPartitions.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PartitionPropertyTabOraclev10g.TemplateName");
            }
            if (column == 1) {
                return Messages.getString("PartitionPropertyTabOraclev10g.ValueList");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StorageObject sel = (StorageObject)PartitionPropertyTabOraclev10g.this.subPartitions.get(row);
            if (col == 0) {
                return sel.getName();
            }
            if (col == 1) {
                if (sel instanceof PartitionOracle) {
                    return ((PartitionOracle)sel).getValueList();
                }
                if (sel instanceof ListStorageTemplatePartitionOracle) {
                    return ((ListStorageTemplatePartitionOracle)sel).getValueList();
                }
                return "";
            }
            return new Integer(row * col);
        }
    }

    public class PartitionTypeListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String type = (String)PartitionPropertyTabOraclev10g.this.cbPartType.getSelectedItem();
            if (PartitionPropertyTabOraclev10g.this.useColumnProxies) {
                PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectionModel().clearSelection();
                PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectionModel().clearSelection();
                if (type.equalsIgnoreCase("LIST") && PartitionPropertyTabOraclev10g.this.selectedColumnsModel.toArray().length > 1) {
                    PartitionPropertyTabOraclev10g.this.allColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.selectedColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.initPartColumns(PartitionPropertyTabOraclev10g.this.partList);
                }
                if (PartitionPropertyTabOraclev10g.this.isListSubpartitioned(type) && PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.toArray().length > 1) {
                    PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.clear();
                    PartitionPropertyTabOraclev10g.this.initSubPartColumns(PartitionPropertyTabOraclev10g.this.partList);
                }
            }
            PartitionPropertyTabOraclev10g.this.enableRelevantPartitionFields(PartitionPropertyTabOraclev10g.this.isPartitioned());
        }
    }

    private class AllHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.allHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AddHashPTSActionListener
    implements ActionListener {
        private AddHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.allHashPTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.allHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.allHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveHashPTSActionListener
    implements ActionListener {
        private RemoveHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.selectedHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.allHashPTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.allHashPTSModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.selectedHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AllIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private AllIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedIOTOverflowHashPTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIOTOverflowHashPTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveIOTOverflowHashPTS.setEnabled(true);
                }
            }
        }
    }

    private class AddIOTOverflowHashPTSActionListener
    implements ActionListener {
        private AddIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveIOTOverflowHashPTSActionListener
    implements ActionListener {
        private RemoveIOTOverflowHashPTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.allIOTOverflowHashPTSModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.selectedIOTOverflowHashPTSModel.removeElement(ob);
                }
            }
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (((String)PartitionPropertyTabOraclev10g.this.cbPartType.getSelectedItem()).equalsIgnoreCase("LIST")) {
                    if (PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectedIndices().length != 1 || PartitionPropertyTabOraclev10g.this.selectedColumnsModel.toArray().length >= 1) {
                        PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(false);
                    } else {
                        PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(true);
                    }
                } else if (PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemove.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedColumnsModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedColumnsModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.allColumnsModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.allColumnsModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AllSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.isListSubpartitioned((String)PartitionPropertyTabOraclev10g.this.cbPartType.getSelectedItem())) {
                    if (PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectedIndices().length != 1 || PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.toArray().length >= 1) {
                        PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(false);
                    } else {
                        PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(true);
                    }
                } else if (PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class SelectedSubPartColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartColumns.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartColumns.setEnabled(true);
                }
            }
        }
    }

    private class AddSubPartColumnsActionListener
    implements ActionListener {
        private AddSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.allSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveSubPartColumnsActionListener
    implements ActionListener {
        private RemoveSubPartColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.allSubPartColumnsModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.selectedSubPartColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AllSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.allSubPartTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnAddSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (PartitionPropertyTabOraclev10g.this.isEditable() && !e.getValueIsAdjusting()) {
                if (PartitionPropertyTabOraclev10g.this.selectedSubPartTSList.getSelectedIndex() == -1) {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartTS.setEnabled(false);
                } else {
                    PartitionPropertyTabOraclev10g.this.bnRemoveSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AddSubPartTSActionListener
    implements ActionListener {
        private AddSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.allSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.allSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.allSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveSubPartTSActionListener
    implements ActionListener {
        private RemoveSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = PartitionPropertyTabOraclev10g.this.selectedSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (PartitionPropertyTabOraclev10g.this.allSubPartTSModel.contains(ob)) continue;
                    PartitionPropertyTabOraclev10g.this.allSubPartTSModel.addElement(ob);
                    PartitionPropertyTabOraclev10g.this.selectedSubPartTSModel.removeElement(ob);
                }
            }
        }
    }
}

