/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v10g;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LocalIndexProperties;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.BitmapJoinIndexOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.HashPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.IndexProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListPartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ListStorageTemplatePartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableSpaceOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UniqueOraclev10g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class LocalIndexPropertyDialogOraclev10g
extends AbstractOraclePropertyDialog {
    private IndexProxyOraclev10g index = null;
    private BitmapJoinIndexOraclev10g bji = null;
    private UniqueOraclev10g unique = null;
    private PKProxyOraclev10g pk = null;
    private PartitionOraclev10g partition = null;
    private ListPartitionOraclev10g listPartition = null;
    private HashPartitionOraclev10g hashPartition = null;
    private ListStorageTemplatePartitionOraclev10g listTemplate = null;
    private JComboBox cbIndexTableSpace;
    private JComboBox cbIndexLogging;
    private JComboBox cbIndexSegment;
    private JComboBox cbKeyCompress;
    private JPanel indexHashSubPartTS;
    private JButton bnAddIndexHashSubPartTS;
    private JButton bnRemoveIndexHashSubPartTS;
    private JList allIndexHashSubPartTSList;
    private JList selectedIndexHashSubPartTSList;
    private DefaultListModel allIndexHashSubPartTSModel;
    private DefaultListModel selectedIndexHashSubPartTSModel;
    private InlineList indexHashPTSSet;
    private JTextField tfPartitionName;
    private LocalIndexProperties lip;
    private JComboBox cbSpLayerType;
    private JComboBox cbSpWorkTablespace;

    public LocalIndexPropertyDialogOraclev10g(ApplicationView view, StorageDesign storageDesign, StorageObject partition, StorageObject index) {
        super(view, storageDesign, partition);
        if (partition instanceof PartitionOraclev10g) {
            this.partition = (PartitionOraclev10g)partition;
        } else if (partition instanceof ListPartitionOraclev10g) {
            this.listPartition = (ListPartitionOraclev10g)partition;
        } else if (partition instanceof HashPartitionOraclev10g) {
            this.hashPartition = (HashPartitionOraclev10g)partition;
        } else if (partition instanceof ListStorageTemplatePartitionOraclev10g) {
            this.listTemplate = (ListStorageTemplatePartitionOraclev10g)partition;
        }
        if (index instanceof IndexProxyOraclev10g) {
            this.index = (IndexProxyOraclev10g)index;
        } else if (index instanceof BitmapJoinIndexOraclev10g) {
            this.bji = (BitmapJoinIndexOraclev10g)index;
        } else if (index instanceof UniqueOraclev10g) {
            this.unique = (UniqueOraclev10g)index;
        } else if (index instanceof PKProxyOraclev10g) {
            this.pk = (PKProxyOraclev10g)index;
        }
        if (partition != null && index != null) {
            this.lip = this.getStorageDesign().getLocalIndexPropertiesSet().getOrCreateLocalIndexPropertiesFor(partition, index);
        }
        this.setTitle(this.getCaption());
        this.setHeight(340);
        this.initLocalIndexes();
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    public void initLocalIndexes() {
        this.initLocIndexPartitionName();
        this.initLocIndexTableSpace();
        this.initKeyCompression();
        if (this.hashPartition == null) {
            this.initLocIndexLogging();
            this.initIndexSegment();
            this.initSpatialIndex();
        }
    }

    private void initSpatialIndex() {
        JPanel spPanel = new JPanel(new SpringLayout());
        spPanel.setPreferredSize(new Dimension(this.general.getWidth() - 20, 90));
        spPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LocalIndexPropertyDialogOracle.SpatialIndex")));
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.ConstrainToLayerType"));
        spPanel.add(label);
        this.cbSpLayerType = new JComboBox<String>(Index.getConstrainLayerTypeChoices());
        this.cbSpLayerType.setEnabled(false);
        this.cbSpLayerType.setPreferredSize(this.tfName.getPreferredSize());
        spPanel.add(this.cbSpLayerType);
        this.setLabelConstraints((SpringLayout)spPanel.getLayout(), label, 10);
        this.setObjectConstraints((SpringLayout)spPanel.getLayout(), this.cbSpLayerType, 10);
        JLabel lbWorkTablespace = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.WorkTablespace"));
        spPanel.add(lbWorkTablespace);
        this.cbSpWorkTablespace = new JComboBox();
        this.cbSpWorkTablespace.setEnabled(false);
        this.cbSpWorkTablespace.setPreferredSize(this.tfName.getPreferredSize());
        spPanel.add(this.cbSpWorkTablespace);
        this.setLabelConstraints((SpringLayout)spPanel.getLayout(), lbWorkTablespace, 40);
        this.setObjectConstraints((SpringLayout)spPanel.getLayout(), this.cbSpWorkTablespace, 40);
        this.general.add(spPanel);
        this.setObjectConstraints(spPanel, 10, 200);
    }

    private void initLocIndexPartitionName() {
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.PartitionName"));
        this.general.add(label);
        this.tfPartitionName = new JTextField();
        this.tfPartitionName.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfPartitionName);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfPartitionName, 50);
    }

    private void initLocIndexTableSpace() {
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.IndexTableSpace"));
        this.general.add(label);
        this.cbIndexTableSpace = new JComboBox();
        this.setBG(this.cbIndexTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbIndexTableSpace);
        }
        this.cbIndexTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIndexTableSpace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbIndexTableSpace, 80);
    }

    private void initKeyCompression() {
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOraclev10g.KeyCompression"));
        this.general.add(label);
        this.cbKeyCompress = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbKeyCompress);
        this.cbKeyCompress.setPreferredSize(this.cbIndexTableSpace.getPreferredSize());
        this.general.add(this.cbKeyCompress);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbKeyCompress, 110);
    }

    private void initLocIndexLogging() {
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.IndexLogging"));
        this.general.add(label);
        this.cbIndexLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbIndexLogging);
        this.cbIndexLogging.setPreferredSize(this.cbIndexTableSpace.getPreferredSize());
        this.general.add(this.cbIndexLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbIndexLogging, 140);
    }

    private void initIndexSegment() {
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.IndexSegment"));
        this.general.add(label);
        this.cbIndexSegment = new JComboBox();
        this.setBG(this.cbIndexSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbIndexSegment);
        }
        this.cbIndexSegment.setPreferredSize(this.cbIndexTableSpace.getPreferredSize());
        this.general.add(this.cbIndexSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbIndexSegment, 170);
    }

    @Override
    public String getCaption() {
        if (this.index != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.LocalIndex"), this.index.getName());
        }
        if (this.bji != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.BitmapJoinIndex"), this.bji.getName());
        }
        if (this.unique != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.UniqueKey"), this.unique.getName());
        }
        if (this.pk != null) {
            return MessageFormat.format(Messages.getString("LocalIndexPropertyDialogOracle.PrimaryKey"), this.pk.getName());
        }
        return "";
    }

    protected SpringLayout getIndexHashSubPartTSLayout() {
        return (SpringLayout)this.indexHashSubPartTS.getLayout();
    }

    @Override
    protected void addTabs() {
        this.initIndexHashSubPartTSView();
    }

    private void initIndexHashSubPartTSView() {
        this.indexHashSubPartTS = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("LocalIndexPropertyDialogOracle.IndexHashSubPartTableSpaces"), this.indexHashSubPartTS);
        this.initIndexHashSubPartTS();
    }

    private void initIndexHashSubPartTS() {
        this.initAllIndexHashSubPartTSList();
        this.initSelectedIndexHashSubPartTSList();
        this.initIndexHashSubPartTSButtons();
    }

    private void initAllIndexHashSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.AllTableSpaces"));
        this.indexHashSubPartTS.add(label);
        this.allIndexHashSubPartTSModel = new DefaultListModel();
        this.allIndexHashSubPartTSList = new JList(this.allIndexHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.allIndexHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllIndexHashSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allIndexHashSubPartTSList);
        sp.setPreferredSize(new Dimension(144, 260));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexHashSubPartTS.add(sp);
        this.setLabelConstraints(this.getIndexHashSubPartTSLayout(), label, 8, 12);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), sp, 6, 32);
    }

    private void initSelectedIndexHashSubPartTSList() {
        JLabel label = new JLabel(Messages.getString("LocalIndexPropertyDialogOracle.SelectedTableSpaces"));
        this.indexHashSubPartTS.add(label);
        this.selectedIndexHashSubPartTSModel = new DefaultListModel();
        this.selectedIndexHashSubPartTSList = new JList(this.selectedIndexHashSubPartTSModel);
        ListSelectionModel listSelectionModel = this.selectedIndexHashSubPartTSList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedIndexHashSubPartTSListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedIndexHashSubPartTSList);
        sp.setPreferredSize(new Dimension(145, 260));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexHashSubPartTS.add(sp);
        this.setLabelConstraints(this.getIndexHashSubPartTSLayout(), label, 292, 12);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), sp, 290, 32);
    }

    private void initIndexHashSubPartTSButtons() {
        this.bnAddIndexHashSubPartTS = new JButton(Messages.getString("LocalIndexPropertyDialogOracle.Add"));
        this.bnAddIndexHashSubPartTS.addActionListener(new AddIndexHashSubPartTSActionListener());
        this.bnAddIndexHashSubPartTS.setEnabled(false);
        this.indexHashSubPartTS.add(this.bnAddIndexHashSubPartTS);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), this.bnAddIndexHashSubPartTS, 160, 120);
        this.bnRemoveIndexHashSubPartTS = new JButton(Messages.getString("LocalIndexPropertyDialogOracle.Remove"));
        this.bnRemoveIndexHashSubPartTS.setEnabled(false);
        this.bnRemoveIndexHashSubPartTS.addActionListener(new RemoveIndexHashSubPartTSActionListener());
        this.indexHashSubPartTS.add(this.bnRemoveIndexHashSubPartTS);
        this.setObjectConstraints(this.getIndexHashSubPartTSLayout(), this.bnRemoveIndexHashSubPartTS, 160, 150);
        LocalIndexPropertyDialogOraclev10g.equalizeButtonSizes(this.bnAddIndexHashSubPartTS, this.bnRemoveIndexHashSubPartTS);
    }

    @Override
    public void initProperties() {
        this.tfName.setEditable(false);
        if (this.lip != null) {
            StorageObject index = this.lip.getIndex();
            this.tfName.setText(index.getName());
            this.tfPartitionName.setText(this.lip.getPartitionName());
            this.cbIndexTableSpace.setSelectedItem(this.lip.getTableSpace());
            this.cbKeyCompress.setSelectedItem(LocalIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.lip.getKeyCompress()));
            boolean enableCompress = false;
            if (index instanceof IndexProxyOracle) {
                enableCompress = ((IndexProxyOracle)index).getCompress() > 0;
            }
            this.cbKeyCompress.setEnabled(enableCompress);
            if (this.hashPartition == null) {
                this.cbIndexLogging.setSelectedItem(LocalIndexPropertyDialogOraclev10g.translateYesNoForDisplay(this.lip.getLogging()));
                this.cbIndexSegment.setSelectedItem(this.lip.getSegment());
                if (this.lip.isSpatialIndex()) {
                    this.cbSpLayerType.setEnabled(true);
                    this.cbSpLayerType.setSelectedItem(this.lip.getLayerType());
                    this.cbSpWorkTablespace.setEnabled(true);
                    this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbSpWorkTablespace);
                    this.cbSpWorkTablespace.setSelectedItem(this.lip.getWorkTablespace());
                }
            }
            PartitionListOracle partitionList = null;
            if (this.partition != null) {
                partitionList = this.partition.getPartitionList();
            } else if (this.listPartition != null) {
                partitionList = this.listPartition.getPartitionList();
            } else if (this.hashPartition != null) {
                partitionList = this.hashPartition.getPartitionList();
            }
            boolean compByHash = false;
            if (partitionList != null) {
                compByHash = partitionList.getSubpartitionType().equalsIgnoreCase("HASH");
            }
            if (compByHash) {
                this.recreateIndexHashPTSSet(this.lip.getHashSubPartitionsTableSpaces());
                this.bnAddIndexHashSubPartTS.setEnabled(this.allIndexHashSubPartTSList.getSelectedIndex() != -1);
                this.bnRemoveIndexHashSubPartTS.setEnabled(this.selectedIndexHashSubPartTSList.getSelectedIndex() != -1);
                Iterator tsIt = this.getIndexHashPTSSet().iterator();
                while (tsIt.hasNext()) {
                    ModelIDObject ts = this.getStorageDesign().getTableSpaceSet().getById((String)tsIt.next());
                    if (!(ts instanceof TableSpaceOracle)) continue;
                    this.selectedIndexHashSubPartTSModel.addElement(ts);
                }
                TableSpaceOracle[] tsSet = (TableSpaceOracle[])this.getStorageDesign().getTableSpaceSet().toArray();
                for (int i = 0; i < tsSet.length; ++i) {
                    TableSpaceOracle ts = tsSet[i];
                    if (this.selectedIndexHashSubPartTSModel.contains(ts)) continue;
                    this.allIndexHashSubPartTSModel.addElement(ts);
                }
            } else {
                this.getPane().setEnabledAt(this.getPane().indexOfComponent(this.indexHashSubPartTS), false);
            }
            this.getCommentsList().insert(this.lip.getComment(), 0);
        }
    }

    @Override
    protected void setProperties() {
        if (this.lip != null) {
            this.lip.setPartitionName(this.tfPartitionName.getText());
            this.lip.setTableSpace((TableSpaceOracle)this.cbIndexTableSpace.getSelectedItem());
            this.lip.setKeyCompress(LocalIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbKeyCompress.getSelectedItem()));
            if (this.hashPartition == null) {
                this.lip.setLogging(LocalIndexPropertyDialogOraclev10g.translateYesNoForStorage((String)this.cbIndexLogging.getSelectedItem()));
                this.lip.setSegment((SegmentOracle)this.cbIndexSegment.getSelectedItem());
                if (this.lip.isSpatialIndex()) {
                    this.lip.setLayerType((String)this.cbSpLayerType.getSelectedItem());
                    this.lip.setWorkTablespace((TableSpaceOracle)this.cbSpWorkTablespace.getSelectedItem());
                }
            }
            PartitionListOracle partitionList = null;
            if (this.partition != null) {
                partitionList = this.partition.getPartitionList();
            } else if (this.listPartition != null) {
                partitionList = this.listPartition.getPartitionList();
            } else if (this.hashPartition != null) {
                partitionList = this.hashPartition.getPartitionList();
            }
            boolean compByHash = false;
            if (partitionList != null) {
                compByHash = partitionList.getSubpartitionType().equalsIgnoreCase("HASH");
            }
            if (compByHash) {
                this.lip.clearHashSubPartTSSet();
                Object[] tsSet = this.selectedIndexHashSubPartTSModel.toArray();
                for (int i = 0; i < tsSet.length; ++i) {
                    Object ts = tsSet[i];
                    if (!(ts instanceof TableSpaceOraclev10g)) continue;
                    this.lip.setHashSubPartitionsTableSpaces(((TableSpaceOraclev10g)ts).getObjectID());
                }
            }
            this.lip.setComment(this.getCommentsList().getText());
            this.lip.setDirty(true);
        }
    }

    public static String getFirstToken(String string) {
        StringTokenizer tokens = new StringTokenizer(string, ",");
        String first = " ";
        if (tokens.hasMoreTokens()) {
            first = tokens.nextToken().trim();
        }
        return first.trim();
    }

    private void recreateIndexHashPTSSet(String props1) {
        StringTokenizer st = new StringTokenizer(props1, "|");
        this.indexHashPTSSet = new InlineList();
        while (st.hasMoreTokens()) {
            this.getIndexHashPTSSet().add(st.nextToken().trim());
        }
    }

    public InlineList getIndexHashPTSSet() {
        if (this.indexHashPTSSet == null) {
            this.indexHashPTSSet = new InlineList();
        }
        return this.indexHashPTSSet;
    }

    private class AllIndexHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private AllIndexHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (LocalIndexPropertyDialogOraclev10g.this.allIndexHashSubPartTSList.getSelectedIndex() == -1) {
                    LocalIndexPropertyDialogOraclev10g.this.bnAddIndexHashSubPartTS.setEnabled(false);
                } else {
                    LocalIndexPropertyDialogOraclev10g.this.bnAddIndexHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class SelectedIndexHashSubPartTSListSelectionHandler
    implements ListSelectionListener {
        private SelectedIndexHashSubPartTSListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (LocalIndexPropertyDialogOraclev10g.this.selectedIndexHashSubPartTSList.getSelectedIndex() == -1) {
                    LocalIndexPropertyDialogOraclev10g.this.bnRemoveIndexHashSubPartTS.setEnabled(false);
                } else {
                    LocalIndexPropertyDialogOraclev10g.this.bnRemoveIndexHashSubPartTS.setEnabled(true);
                }
            }
        }
    }

    private class AddIndexHashSubPartTSActionListener
    implements ActionListener {
        private AddIndexHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LocalIndexPropertyDialogOraclev10g.this.allIndexHashSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = LocalIndexPropertyDialogOraclev10g.this.allIndexHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (LocalIndexPropertyDialogOraclev10g.this.selectedIndexHashSubPartTSModel.contains(ob)) continue;
                    LocalIndexPropertyDialogOraclev10g.this.selectedIndexHashSubPartTSModel.addElement(ob);
                    LocalIndexPropertyDialogOraclev10g.this.allIndexHashSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveIndexHashSubPartTSActionListener
    implements ActionListener {
        private RemoveIndexHashSubPartTSActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!LocalIndexPropertyDialogOraclev10g.this.selectedIndexHashSubPartTSModel.isEmpty()) {
                Object[] selectedObjects = LocalIndexPropertyDialogOraclev10g.this.selectedIndexHashSubPartTSList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (LocalIndexPropertyDialogOraclev10g.this.allIndexHashSubPartTSModel.contains(ob)) continue;
                    LocalIndexPropertyDialogOraclev10g.this.allIndexHashSubPartTSModel.addElement(ob);
                    LocalIndexPropertyDialogOraclev10g.this.selectedIndexHashSubPartTSModel.removeElement(ob);
                }
            }
        }
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append("|");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

