/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DirectoryOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ExternalTableSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FunctionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StoredProcedureOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JListUtils;

public class UserAndRolePermissionsDialogOracle
extends CustomDialogML {
    private static final long serialVersionUID = 2832957674589015374L;
    private final String TABLES = Messages.getString("UserAndRolePermissionsDialogOracle.Tables");
    private final String VIEWS = Messages.getString("UserAndRolePermissionsDialogOracle.Views");
    private final String SNAPSHOTS = Messages.getString("UserAndRolePermissionsDialogOracle.Snapshots");
    private final String MV_LOGS = "Materialized View Logs";
    private final String SEQUENCES = Messages.getString("UserAndRolePermissionsDialogOracle.Sequences");
    private final String PROCEDURES = Messages.getString("UserAndRolePermissionsDialogOracle.Procedures");
    private final String DIRECTORIES = Messages.getString("UserAndRolePermissionsDialogOracle.Directories");
    private final String STRUCT_TYPES = Messages.getString("UserAndRolePermissionsDialogOracle.StructuredTypes");
    private final String COLLECTION_TYPES = Messages.getString("UserAndRolePermissionsDialogOracle.CollectionTypes");
    private final String EXT_TABLES = Messages.getString("UserAndRolePermissionsDialogOracle.ExternalTables");
    private final String COLUMNS = Messages.getString("UserAndRolePermissionsDialogOracle.Columns");
    public final String CLEAR_FILTER = " ";
    public final String TABLE_T = "table";
    public final String VIEW_T = "view";
    public final String M_VIEW_T = "mview";
    public final String M_VIEW_LOG_T = "mviewl";
    public final String SEQUENCE_T = "seq";
    public final String PACKAGE_T = "pkg";
    public final String PROCEDURE_T = "proc";
    public final String FUNCTION_T = "func";
    public final String DIRECTORY_T = "dir";
    public final String STRUCT_TYPE_T = "str_t";
    public final String COLL_TYPE_T = "col_t";
    public final String EXT_TABLE_T = "ext_t";
    public final String COLUMN_T = "col";
    private Object storageObject;
    private StorageDesignOracle storageDesign;
    private JButton bnOK;
    private JButton bnApply;
    private JButton bnCancel;
    private final JPanel generalPanel;
    private JTable privilegedObjectsTable;
    private JTable privilegedObjectPrivilegesTable;
    private JButton buttonObjectAdd;
    private JButton buttonObjectRemove;
    private JButton buttonPrivilegeAdd;
    private JButton buttonPrivilegeRemove;
    private JPanel allObjectsPanel;
    private List<Object> privilegedObjectsContainerList;
    private List<Privilege> containerListPrivileges;
    private JPanel objectsPanel;
    private SelectedObjectsModel selObjModel = new SelectedObjectsModel();
    private TableRowSorter<SelectedObjectsModel> privilegedObjectsTableRowSorter;
    private JScrollPane tablesScrollPane;
    private JScrollPane viewsScrollPane;
    private JScrollPane sequencesScrollPane;
    private JScrollPane snapshotsScrollPane;
    private JScrollPane mvLogsScrollPane;
    private JScrollPane proceduresScrollPane;
    private JScrollPane directoriesScrollPane;
    private JScrollPane structuredTypesScrollPane;
    private JScrollPane collectionTypesScrollPane;
    private JScrollPane externalTablesScrollPane;
    private JScrollPane columnsScrollPane;
    private JDialog dialog;
    private DefaultListModel allTablesPanelListModel;
    private DefaultListModel allViewsPanelListModel;
    private DefaultListModel allSnapshotsPanelListModel;
    private DefaultListModel allMVLogsPanelListModel;
    private DefaultListModel allSequencesPanelListModel;
    private DefaultListModel allProceduresPanelListModel;
    private DefaultListModel allDirectoriesPanelListModel;
    private DefaultListModel allStructuredTypesPanelListModel;
    private DefaultListModel allCollectionTypesPanelListModel;
    private DefaultListModel allExternalTablesPanelListModel;
    private DefaultListModel allColumnsPanelListModel;
    private List currentAll_TablesList;
    private List currentAll_ColumnsList;
    private List currentAll_ViewsList;
    private List currentAll_SnapshotsList;
    private List currentAll_MVLogsList;
    private List currentAll_SequencesList;
    private List currentAll_ProceduresList;
    private List currentAll_DirectoriesList;
    private List currentAll_StructuredTypesList;
    private List currentAll_CollectionTypesList;
    private List currentAll_ExternalTablesList;
    private JList allTablesPanelList;
    private JList allViewsPanelList;
    private JList allSnapshotsPanelList;
    private JList allMVLogsPanelList;
    private JList allSequencesPanelList;
    private JList allProceduresPanelList;
    private JList allDirectoriesPanelList;
    private JList allStructuredTypesPanelList;
    private JList allCollectionTypesPanelList;
    private JList allExternalTablesPanelList;
    private JList allColumnsPanelList;
    private DefaultListModel availablePrivilegesModel;
    private ArrayList<PrivilegedObject> currentPrivilegedObjectList;
    private Privilege currentPrivilege;
    private JList availablePrivilegesList;
    private JScrollPane availablePrivilegesScrollPane;
    private TableProxySetOracle tablesSet;
    private ColumnProxySetOracle columnsSet;
    private TableViewProxySetOracle viewSet;
    private SnapshotSetOracle snapshotSet;
    private MaterializedViewLogSetOracle mvLogSet;
    private SequenceSetOracle sequenceSet;
    private JTabbedPane tablesTPane;
    private JComboBox cmbObjects;
    private JSearchTextField allObjectsFilterBox;
    private JComboBox cmbFilterType;
    private JPanel objListPanel;
    private ArrayList<PrivilegedObject> objWithRevokedPrivs = new ArrayList();
    private int dialogMinWidth = 680;
    private int dialogMinHeight = 500;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();

    public UserAndRolePermissionsDialogOracle(ApplicationView appView, StorageDesign storageDesign, StorageObject object) {
        super(appView);
        this.storageDesign = (StorageDesignOracle)storageDesign;
        this.storageObject = object;
        this.generalPanel = new JPanel((LayoutManager)new MigLayout("", "0[]0[32!]0[grow]0", "0[grow]0[grow]0"));
        this.initLeftPanel(this.generalPanel);
        this.initAllObjectsPanelAddRemoveButtons(this.generalPanel);
        this.initRightPanel(this.generalPanel, object);
        this.initBottomPanel(this.generalPanel);
        this.add((Component)this.generalPanel, new CC().grow());
    }

    private void initBottomPanel(JPanel panel) {
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(Messages.getString("UserAndRolePermissionsDialogOracle.OK"));
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnOK);
        this.bnApply = new JButton(Messages.getString("UserAndRolePermissionsDialogOracle.Apply"));
        this.bnApply.addActionListener(new ApplyAction());
        this.bnApply.setMnemonic(65);
        this.bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnApply);
        this.bnCancel = new JButton(Messages.getString("UserAndRolePermissionsDialogOracle.Cancel"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        pnButtons.add(this.bnCancel);
        panel.add((Component)pnButtons, new CC().spanX().alignX("right"));
    }

    @Override
    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    private void initAllObjectsPanelAddRemoveButtons(JPanel panel) {
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.buttonObjectAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonObjectAdd.addActionListener(new AddObjectActionListener());
        this.buttonObjectAdd.setEnabled(false);
        this.buttonObjectAdd.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Add"));
        this.buttonObjectAdd.setMaximumSize(new Dimension(32, 32));
        this.buttonObjectRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonObjectRemove.setEnabled(false);
        this.buttonObjectRemove.addActionListener(new RemoveObjectActionListener());
        this.buttonObjectRemove.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Remove"));
        this.buttonObjectRemove.setMaximumSize(new Dimension(32, 32));
        buttonPanel.add((Component)this.buttonObjectAdd, new CC().wrap());
        buttonPanel.add(this.buttonObjectRemove);
        panel.add(buttonPanel);
    }

    private void initPrivilegesAddRemoveButtons() {
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.buttonPrivilegeAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.buttonPrivilegeAdd.addActionListener(new AddPrivilegeActionListener());
        this.buttonPrivilegeAdd.setEnabled(false);
        this.buttonPrivilegeAdd.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Add"));
        this.buttonPrivilegeAdd.setMaximumSize(new Dimension(32, 32));
        this.buttonPrivilegeRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.buttonPrivilegeRemove.setEnabled(false);
        this.buttonPrivilegeRemove.addActionListener(new RemovePrivilegeActionListener());
        this.buttonPrivilegeRemove.setToolTipText(Messages.getString("UserAndRolePermissionsDialogOracle.Remove"));
        this.buttonPrivilegeRemove.setMaximumSize(new Dimension(32, 32));
        buttonPanel.add((Component)this.buttonPrivilegeAdd, new CC().wrap());
        buttonPanel.add(this.buttonPrivilegeRemove);
        this.objectsPanel.add(buttonPanel);
    }

    private void initLeftPanel(JPanel panel) {
        this.allObjectsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[]5[grow]0"));
        this.allObjectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.AvailableObjects")));
        this.currentAll_TablesList = new ArrayList();
        this.currentAll_ColumnsList = new ArrayList();
        this.currentAll_ViewsList = new ArrayList();
        this.currentAll_SnapshotsList = new ArrayList();
        this.currentAll_MVLogsList = new ArrayList();
        this.currentAll_SequencesList = new ArrayList();
        this.currentAll_ProceduresList = new ArrayList();
        this.currentAll_DirectoriesList = new ArrayList();
        this.currentAll_StructuredTypesList = new ArrayList();
        this.currentAll_CollectionTypesList = new ArrayList();
        this.currentAll_ExternalTablesList = new ArrayList();
        this.cmbObjects = new JComboBox<Object>(this.getObjectsNames().toArray());
        this.cmbObjects.setPreferredSize(new Dimension(130, 20));
        this.cmbObjects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    UserAndRolePermissionsDialogOracle.this.loadAllObjectsPanelList();
                    UserAndRolePermissionsDialogOracle.this.filterAllObjects();
                }
            }
        });
        this.allObjectsFilterBox = new JSearchTextField(false, true, "Name");
        this.allObjectsFilterBox.setPreferredSize(new Dimension(120, 20));
        this.allObjectsFilterBox.getDocument().addDocumentListener(new AllObjectsFilterListener());
        this.objListPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        this.initAllObjectsPanelList();
        this.loadAllObjectsPanelList();
        this.allObjectsPanel.add((Component)this.cmbObjects, new CC().wrap());
        this.allObjectsPanel.add((Component)this.allObjectsFilterBox, new CC().wrap());
        this.allObjectsPanel.add((Component)this.objListPanel, new CC().grow());
        panel.add((Component)this.allObjectsPanel, new CC().grow().minWidth("200").maxWidth("250"));
    }

    private void initAllObjectsPanelList() {
        this.tablesTPane = new JTabbedPane();
        this.allTablesPanelListModel = new DefaultListModel();
        this.allTablesPanelList = new JList(this.allTablesPanelListModel);
        this.tablesScrollPane = new JScrollPane(this.allTablesPanelList);
        this.tablesScrollPane.setPreferredSize(new Dimension(180, 432));
        this.allTablesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.clear();
                if (UserAndRolePermissionsDialogOracle.this.allTablesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.initColumns((TableProxyOracle)UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.get(UserAndRolePermissionsDialogOracle.this.allTablesPanelList.getSelectedIndex()));
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allTablesPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.tablesTPane.addTab(this.TABLES, this.configuration.getIcon("TABLE_ICON"), this.tablesScrollPane);
        this.allColumnsPanelListModel = new DefaultListModel();
        this.allColumnsPanelList = new JList(this.allColumnsPanelListModel);
        this.allColumnsPanelList.setCellRenderer(new ColumnsCellRenderer());
        this.columnsScrollPane = new JScrollPane(this.allColumnsPanelList);
        this.columnsScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allColumnsPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allColumnsPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allColumnsPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.tablesTPane.addTab(this.COLUMNS, this.configuration.getIcon("COLUMN_ICON"), this.columnsScrollPane);
        this.allViewsPanelListModel = new DefaultListModel();
        this.allViewsPanelList = new JList(this.allViewsPanelListModel);
        this.viewsScrollPane = new JScrollPane(this.allViewsPanelList);
        this.viewsScrollPane.setPreferredSize(new Dimension(180, 432));
        this.allViewsPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allViewsPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allViewsPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allSequencesPanelListModel = new DefaultListModel();
        this.allSequencesPanelList = new JList(this.allSequencesPanelListModel);
        this.sequencesScrollPane = new JScrollPane(this.allSequencesPanelList);
        this.sequencesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allSequencesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allSequencesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allSequencesPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allSnapshotsPanelListModel = new DefaultListModel();
        this.allSnapshotsPanelList = new JList(this.allSnapshotsPanelListModel);
        this.snapshotsScrollPane = new JScrollPane(this.allSnapshotsPanelList);
        this.allSnapshotsPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allSnapshotsPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allMVLogsPanelListModel = new DefaultListModel();
        this.allMVLogsPanelList = new JList(this.allMVLogsPanelListModel);
        this.mvLogsScrollPane = new JScrollPane(this.allMVLogsPanelList);
        this.allMVLogsPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allMVLogsPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allMVLogsPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allProceduresPanelListModel = new DefaultListModel();
        this.allProceduresPanelList = new JList(this.allProceduresPanelListModel);
        this.proceduresScrollPane = new JScrollPane(this.allProceduresPanelList);
        this.proceduresScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allProceduresPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allProceduresPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allProceduresPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allDirectoriesPanelListModel = new DefaultListModel();
        this.allDirectoriesPanelList = new JList(this.allDirectoriesPanelListModel);
        this.directoriesScrollPane = new JScrollPane(this.allDirectoriesPanelList);
        this.directoriesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allDirectoriesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allDirectoriesPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allStructuredTypesPanelListModel = new DefaultListModel();
        this.allStructuredTypesPanelList = new JList(this.allStructuredTypesPanelListModel);
        this.structuredTypesScrollPane = new JScrollPane(this.allStructuredTypesPanelList);
        this.structuredTypesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allStructuredTypesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allStructuredTypesPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allCollectionTypesPanelListModel = new DefaultListModel();
        this.allCollectionTypesPanelList = new JList(this.allCollectionTypesPanelListModel);
        this.collectionTypesScrollPane = new JScrollPane(this.allCollectionTypesPanelList);
        this.collectionTypesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allCollectionTypesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allCollectionTypesPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
        this.allExternalTablesPanelListModel = new DefaultListModel();
        this.allExternalTablesPanelList = new JList(this.allExternalTablesPanelListModel);
        this.externalTablesScrollPane = new JScrollPane(this.allExternalTablesPanelList);
        this.externalTablesScrollPane.setPreferredSize(new Dimension(180, 400));
        this.allExternalTablesPanelList.getSelectionModel().addListSelectionListener(new allObjectsPanelSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.setEnabled(true);
                }
            }
        });
        this.allExternalTablesPanelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectAdd.doClick();
                }
            }
        });
    }

    private void loadAllObjectsPanelList() {
        this.objListPanel.removeAll();
        String selItem = (String)this.cmbObjects.getSelectedItem();
        if (selItem.equals(this.TABLES)) {
            this.objListPanel.add((Component)this.tablesTPane, new CC().grow());
        } else if (selItem.equals(this.VIEWS)) {
            this.objListPanel.add((Component)this.viewsScrollPane, new CC().grow());
        } else if (selItem.equals(this.SNAPSHOTS)) {
            this.objListPanel.add((Component)this.snapshotsScrollPane, new CC().grow());
        } else if (selItem.equals("Materialized View Logs")) {
            this.objListPanel.add((Component)this.mvLogsScrollPane, new CC().grow());
        } else if (selItem.equals(this.SEQUENCES)) {
            this.objListPanel.add((Component)this.sequencesScrollPane, new CC().grow());
        } else if (selItem.equals(this.PROCEDURES)) {
            this.objListPanel.add((Component)this.proceduresScrollPane, new CC().grow());
        } else if (selItem.equals(this.DIRECTORIES)) {
            this.objListPanel.add((Component)this.directoriesScrollPane, new CC().grow());
        } else if (selItem.equals(this.STRUCT_TYPES)) {
            this.objListPanel.add((Component)this.structuredTypesScrollPane, new CC().grow());
        } else if (selItem.equals(this.COLLECTION_TYPES)) {
            this.objListPanel.add((Component)this.collectionTypesScrollPane, new CC().grow());
        } else if (selItem.equals(this.EXT_TABLES)) {
            this.objListPanel.add((Component)this.externalTablesScrollPane, new CC().grow());
        }
        this.objListPanel.updateUI();
    }

    private PermissionsOracle getPermissionPerObject(StorageObject type, StorageObject object) {
        Iterator it = this.storageDesign.getPermissionsSet().iterator();
        ColumnProxyOracle column = null;
        if (object instanceof ColumnProxyOracle) {
            column = (ColumnProxyOracle)object;
        }
        while (it.hasNext()) {
            PermissionsOracle perm = (PermissionsOracle)it.next();
            if (perm.getUser() != type && perm.getRole() != type || perm.getTable() != object && perm.getView() != object && perm.getProc() != object && perm.getFunctionOracle() != object && perm.getPackage() != object && perm.getSequence() != object && perm.getSnapshot() != object && perm.getDirectoryOracle() != object && perm.getStructuredTypeOracle() != object && perm.getCollectionTypeOracle() != object && perm.getExternalTableOracle() != object && (column == null || perm.getColumnsTable() == null || !perm.getColumnsTable().getObjectID().equals(column.getTableProxy().getObjectID()) || !perm.getColumns().contains(column.getName()) && !perm.getColumnsWithGrantOption().contains(column.getName()))) continue;
            return perm;
        }
        return null;
    }

    private void checkPermissions(Object ob) {
        PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)this.storageObject, (StorageObject)ob);
        if (permissionsOracle == null) {
            if (ob instanceof TableProxyOracle) {
                this.allTablesPanelListModel.addElement(ob);
                this.currentAll_TablesList.add(ob);
            } else if (ob instanceof ColumnProxyOracle) {
                this.allColumnsPanelListModel.addElement(ob);
                this.currentAll_ColumnsList.add(ob);
            } else if (ob instanceof TableViewProxyOracle) {
                this.allViewsPanelListModel.addElement(ob);
                this.currentAll_ViewsList.add(ob);
            } else if (ob instanceof SnapshotOracle) {
                this.allSnapshotsPanelListModel.addElement(ob);
                this.currentAll_SnapshotsList.add(ob);
            } else if (ob instanceof MaterializedViewLogOracle) {
                this.allMVLogsPanelListModel.addElement(ob);
                this.currentAll_MVLogsList.add(ob);
            } else if (ob instanceof SequenceOracle) {
                this.allSequencesPanelListModel.addElement(ob);
                this.currentAll_SequencesList.add(ob);
            } else if (ob instanceof StoredProcedureOracle || ob instanceof FunctionOracle || ob instanceof PackageOracle) {
                this.allProceduresPanelListModel.addElement(ob);
                this.currentAll_ProceduresList.add(ob);
            } else if (ob instanceof DirectoryOracle) {
                this.allDirectoriesPanelListModel.addElement(ob);
                this.currentAll_DirectoriesList.add(ob);
            } else if (ob instanceof StructuredTypeProxyOracle) {
                this.allStructuredTypesPanelListModel.addElement(ob);
                this.currentAll_StructuredTypesList.add(ob);
            } else if (ob instanceof CollectionTypeProxyOracle) {
                this.allCollectionTypesPanelListModel.addElement(ob);
                this.currentAll_CollectionTypesList.add(ob);
            } else if (ob instanceof ExternalTableOracle) {
                this.allExternalTablesPanelListModel.addElement(ob);
                this.currentAll_ExternalTablesList.add(ob);
            }
        } else if (permissionsOracle != null) {
            this.privilegedObjectPrivilegesTable.updateUI();
            PrivilegedObject po = new PrivilegedObject(ob);
            ArrayList<Privilege> pPrivilege = new ArrayList<Privilege>();
            if (ob instanceof ColumnProxyOracle) {
                StringTokenizer st3 = new StringTokenizer(permissionsOracle.getPrivs((ColumnProxyOracle)ob), ",");
                while (st3.hasMoreTokens()) {
                    String item = st3.nextToken().trim();
                    Privilege p = new Privilege(item.trim());
                    p.setName(item);
                    pPrivilege.add(p);
                }
                StringTokenizer st4 = new StringTokenizer(permissionsOracle.getPrivsWithGrantOption((ColumnProxyOracle)ob), ",");
                while (st4.hasMoreTokens()) {
                    String item1 = st4.nextToken().trim();
                    Privilege p = new Privilege(item1.trim());
                    p.setName(item1);
                    p.setGrantOption(true);
                    pPrivilege.add(p);
                }
            } else {
                StringTokenizer st = new StringTokenizer(permissionsOracle.getPrivileges(), ",");
                while (st.hasMoreTokens()) {
                    String item = st.nextToken().trim();
                    Privilege p = new Privilege(item.trim());
                    p.setName(item);
                    pPrivilege.add(p);
                }
                StringTokenizer st1 = new StringTokenizer(permissionsOracle.getPrivilegesWithGrantOption(), ",");
                while (st1.hasMoreTokens()) {
                    String item1 = st1.nextToken().trim();
                    Privilege p = new Privilege(item1.trim());
                    p.setName(item1);
                    p.setGrantOption(true);
                    pPrivilege.add(p);
                }
                StringTokenizer st2 = new StringTokenizer(permissionsOracle.getPrivilegesWithHierarchyOption(), ",");
                while (st2.hasMoreTokens()) {
                    String item2 = st2.nextToken().trim();
                    Privilege p = new Privilege(item2.trim());
                    p.setName(item2);
                    p.setHierarchy(true);
                    pPrivilege.add(p);
                }
            }
            po.setPrivileges(pPrivilege);
            this.privilegedObjectsContainerList.add(po);
            this.privilegedObjectsTable.updateUI();
            this.privilegedObjectsTableRowSorter = new TableRowSorter<SelectedObjectsModel>(this.selObjModel);
            this.privilegedObjectsTableRowSorter.setSortsOnUpdates(true);
            if (this.privilegedObjectsContainerList.size() > 0) {
                this.privilegedObjectsTable.setRowSorter(this.privilegedObjectsTableRowSorter);
                this.privilegedObjectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.privilegedObjectsTable, 1);
            }
        }
    }

    private void initTables() {
        this.tablesSet = (TableProxySetOracle)this.storageDesign.getTableProxySet();
        for (Object ob : this.tablesSet.getElements()) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allTablesPanelListModel);
    }

    private void initViews() {
        this.viewSet = (TableViewProxySetOracle)this.storageDesign.getTableViewProxySet();
        for (Object ob : this.viewSet.getElements()) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allViewsPanelListModel);
    }

    private void initSnapshots() {
        this.snapshotSet = this.storageDesign.getSnapshotSet();
        for (Object ob : this.snapshotSet) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allSnapshotsPanelListModel);
    }

    private void initMVLogs() {
        this.mvLogSet = this.storageDesign.getMaterializedViewLogSet();
        for (Object ob : this.mvLogSet) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allMVLogsPanelListModel);
    }

    private void initSequences() {
        this.sequenceSet = this.storageDesign.getSequenceSet();
        for (Object ob : this.sequenceSet) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allSequencesPanelListModel);
    }

    private void initStoredProcedures() {
        for (Object ob : this.storageDesign.getPackageSet()) {
            this.checkPermissions(ob);
        }
        for (Object ob : this.storageDesign.getStoredProcedureSet()) {
            this.checkPermissions(ob);
        }
        for (Object ob : this.storageDesign.getFunctionSet()) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allProceduresPanelListModel);
    }

    private void initDirectories() {
        for (Object ob : this.storageDesign.getDirectorySet()) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allDirectoriesPanelListModel);
    }

    private void initStructuredTypes() {
        Iterator it = this.storageDesign.getStructuredTypeProxySet().iterator();
        while (it.hasNext()) {
            Object ob = it.next();
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allStructuredTypesPanelListModel);
    }

    private void initCollectionTypes() {
        Iterator it = this.storageDesign.getCollectionTypeProxySet().iterator();
        while (it.hasNext()) {
            Object ob = it.next();
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allCollectionTypesPanelListModel);
    }

    private void initExternalTables() {
        ExternalTableSetOracle ts = this.storageDesign.getExternalTableSet();
        for (Object ob : ts) {
            this.checkPermissions(ob);
        }
        JListUtils.sort(this.allExternalTablesPanelListModel);
    }

    private void initColumns() {
        this.columnsSet = (ColumnProxySetOracle)this.storageDesign.getColumnProxySet();
        for (Object ob : this.columnsSet.getElements()) {
            this.checkPermissions(ob);
        }
    }

    private void initColumns(TableProxyOracle table) {
        if (table != null) {
            for (ColumnProxy obj : Arrays.asList(table.getColumnProxies())) {
                PermissionsOracle permissionsOracle = this.getPermissionPerObject((StorageObject)this.storageObject, obj);
                if (permissionsOracle != null) continue;
                this.allColumnsPanelListModel.addElement(obj);
            }
        }
        JListUtils.sort(this.allColumnsPanelListModel);
    }

    private void initRightPanel(JPanel panel, StorageObject object) {
        this.objectsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0[32!]0[grow]0", "0[grow]0[250!]0"));
        this.objectsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.Objects")));
        this.initPrivilegedObjectInfo();
        this.initAvailablePrivileges();
        this.initPrivilegesAddRemoveButtons();
        this.initGrantedObjectProvileges(object);
        this.loadObjectsAndPrivileges();
        panel.add((Component)this.objectsPanel, new CC().grow().wrap());
    }

    private void initPrivilegedObjectInfo() {
        JPanel privilegedObjectsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        this.privilegedObjectsContainerList = new ArrayList<Object>();
        this.privilegedObjectsTable = new JTable(this.selObjModel);
        this.privilegedObjectsTable.getTableHeader().setReorderingAllowed(false);
        this.privilegedObjectsTable.setSelectionMode(2);
        JLabel lblFilter = new JLabel(Messages.getString("UserAndRolePermissionsDialogOracle.FilterByType"));
        this.cmbFilterType = new JComboBox<Object>(this.getObjectTypesList().toArray());
        this.cmbFilterType.setPreferredSize(new Dimension(70, 20));
        this.cmbFilterType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UserAndRolePermissionsDialogOracle.this.filterByType();
            }
        });
        JPanel filterPanel = new JPanel((LayoutManager)new MigLayout("", "0[]10[]10[]0", "0[]0"));
        filterPanel.add(lblFilter);
        filterPanel.add(this.cmbFilterType);
        TableColumn col0 = this.privilegedObjectsTable.getColumnModel().getColumn(0);
        col0.setWidth(35);
        col0.setMaxWidth(35);
        TableColumn col1 = this.privilegedObjectsTable.getColumnModel().getColumn(1);
        col1.setWidth(148);
        TableColumn col2 = this.privilegedObjectsTable.getColumnModel().getColumn(2);
        col2.setWidth(225);
        this.privilegedObjectsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRow() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectRemove.setEnabled(false);
                    UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.clear();
                    UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
                } else {
                    UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList = new ArrayList();
                    UserAndRolePermissionsDialogOracle.this.buttonObjectRemove.setEnabled(true);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRowCount() > 1) {
                        PrivilegedObject selected = null;
                        int[] selRows = UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRows();
                        for (int i = 0; i < selRows.length; ++i) {
                            PrivilegedObject po = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.convertRowIndexToModel(selRows[i]));
                            UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.add(po);
                            selected = po;
                        }
                        if (UserAndRolePermissionsDialogOracle.this.cmbFilterType.getSelectedItem().equals(" ")) {
                            UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.clear();
                            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
                            UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                        } else {
                            UserAndRolePermissionsDialogOracle.this.loadAvailableObjectPrivileges(selected, new ArrayList<Object>(), true);
                            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
                        }
                    } else {
                        PrivilegedObject selected = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.convertRowIndexToModel(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRow()));
                        UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.add(selected);
                        ArrayList<Object> grantedPrivileges = UserAndRolePermissionsDialogOracle.this.loadGrantedObjectProvileges(selected);
                        UserAndRolePermissionsDialogOracle.this.loadAvailableObjectPrivileges(selected, grantedPrivileges, false);
                    }
                    UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.getSelectionModel().setSelectionInterval(0, 0);
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.clearSelection();
                }
            }
        });
        this.privilegedObjectsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonObjectRemove.doClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedObjectsTable);
        privilegedObjectsPanel.add((Component)filterPanel, new CC().wrap());
        privilegedObjectsPanel.add((Component)scrollPane, new CC().grow());
        this.objectsPanel.add((Component)privilegedObjectsPanel, new CC().spanX().grow().wrap());
    }

    private void loadObjectsAndPrivileges() {
        this.initTables();
        this.initViews();
        this.initSnapshots();
        this.initMVLogs();
        this.initSequences();
        this.initStoredProcedures();
        this.initDirectories();
        this.initStructuredTypes();
        this.initCollectionTypes();
        this.initExternalTables();
        this.initColumns();
    }

    private void initAvailablePrivileges() {
        JPanel availablePrivilegesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        availablePrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.AvailablePrivileges")));
        this.availablePrivilegesModel = new DefaultListModel();
        this.availablePrivilegesList = new JList(this.availablePrivilegesModel);
        this.availablePrivilegesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.getSelectedIndex() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.setEnabled(true);
                }
            }
        });
        this.availablePrivilegesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeAdd.doClick();
                }
            }
        });
        JListUtils.sort(this.availablePrivilegesModel);
        this.availablePrivilegesScrollPane = new JScrollPane(this.availablePrivilegesList);
        availablePrivilegesPanel.add((Component)this.availablePrivilegesScrollPane, new CC().grow());
        this.objectsPanel.add((Component)availablePrivilegesPanel, new CC().minWidth("150").grow());
    }

    private void loadAvailableObjectPrivileges(PrivilegedObject privilegedObject, ArrayList<Object> grantedPrivileges, boolean loadAll) {
        StorageObject so = (StorageObject)privilegedObject.getObject();
        String[] availablePrivileges = PermissionsOracle.getValidPrivilegeValues(so);
        this.availablePrivilegesModel.clear();
        if (availablePrivileges != null) {
            Iterator<String> it = Arrays.asList(availablePrivileges).iterator();
            while (it.hasNext()) {
                String current = it.next().trim();
                if (this.storageObject instanceof RoleOracle && "REFERENCES".equals(current) && so instanceof TableProxyOracle || !loadAll && grantedPrivileges.contains(current)) continue;
                this.availablePrivilegesModel.addElement(current);
            }
        }
    }

    private ArrayList<Object> loadGrantedObjectProvileges(PrivilegedObject obj) {
        this.containerListPrivileges.clear();
        ArrayList<Privilege> privileges = obj.getPrivileges();
        Iterator<Privilege> it = privileges.iterator();
        ArrayList<Object> trimmedPrivileges = new ArrayList<Object>();
        while (it.hasNext()) {
            Privilege current = it.next();
            this.containerListPrivileges.add(current);
            trimmedPrivileges.add(current.getObject());
        }
        return trimmedPrivileges;
    }

    private void initGrantedObjectProvileges(StorageObject object) {
        TableColumn col0;
        JPanel grantedObjectPrivilegesPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0"));
        grantedObjectPrivilegesPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("UserAndRolePermissionsDialogOracle.GrantedPrivileges")));
        this.containerListPrivileges = new ArrayList<Privilege>();
        ColumnHierarchyRenderer columnHierarchyRenderer = new ColumnHierarchyRenderer();
        if (object instanceof RoleOracle) {
            this.privilegedObjectPrivilegesTable = new JTable(new RoleGrantedPrivilegessModel());
            this.privilegedObjectPrivilegesTable.getTableHeader().setReorderingAllowed(false);
            col0 = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(0);
            TableColumn col1 = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(1);
            col0.setWidth(178);
            col1.setWidth(60);
            col1.setMaxWidth(60);
            col1.setCellRenderer(columnHierarchyRenderer);
        } else if (object instanceof UserOracle) {
            this.privilegedObjectPrivilegesTable = new JTable(new UserGrantedPrivilegessModel());
            this.privilegedObjectPrivilegesTable.getTableHeader().setReorderingAllowed(false);
            col0 = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(0);
            TableColumn col1 = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(1);
            TableColumn col2 = this.privilegedObjectPrivilegesTable.getColumnModel().getColumn(2);
            col0.setWidth(118);
            col1.setWidth(60);
            col1.setMaxWidth(60);
            col2.setWidth(60);
            col2.setMaxWidth(60);
            col2.setCellRenderer(columnHierarchyRenderer);
        }
        this.privilegedObjectPrivilegesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectedRow() == -1) {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(false);
                } else {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeRemove.setEnabled(true);
                    UserAndRolePermissionsDialogOracle.this.currentPrivilege = UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectedRow());
                }
            }
        });
        this.privilegedObjectPrivilegesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserAndRolePermissionsDialogOracle.this.buttonPrivilegeRemove.doClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.privilegedObjectPrivilegesTable);
        grantedObjectPrivilegesPanel.add((Component)scrollPane, new CC().grow());
        this.objectsPanel.add((Component)grantedObjectPrivilegesPanel, new CC().grow());
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("UserAndRolePermissionsDialogOracle.Permissions"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.setModal(true);
            this.dialog.pack();
        }
        return this.dialog;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    protected void savePermissions() {
        PermissionsOracle perm = null;
        this.cmbFilterType.setSelectedItem(" ");
        PermissionsSetOracle ps = this.storageDesign.getPermissionsSet();
        for (int i = 0; i < this.privilegedObjectsTable.getRowCount(); ++i) {
            String columnWithGrantOptionPrivileges;
            String columnPrivileges;
            ColumnProxyOracle column;
            PrivilegedObject obj = (PrivilegedObject)this.privilegedObjectsContainerList.get(i);
            Object object = obj.getObject();
            perm = this.getPermissionPerObject((StorageObject)this.storageObject, (StorageObject)object);
            if (perm == null) {
                perm = ps.createPermissions();
                for (Privilege p : obj.getPrivileges()) {
                    if (object instanceof ColumnProxyOracle) {
                        column = (ColumnProxyOracle)object;
                        perm.setColumnsTable(column.getTableProxy());
                        columnPrivileges = "";
                        columnPrivileges = columnPrivileges.concat(column.getName());
                        columnWithGrantOptionPrivileges = "";
                        columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(column.getName());
                        if (p.getGrantOption()) {
                            columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(", ").concat((String)p.getObject());
                        } else {
                            columnPrivileges = columnPrivileges.concat(", ").concat((String)p.getObject());
                        }
                        if (columnPrivileges.indexOf(",") > -1) {
                            perm.setColumnList(columnPrivileges);
                        }
                        if (columnWithGrantOptionPrivileges.indexOf(",") > -1) {
                            perm.setColumnListWithGrantOption(columnWithGrantOptionPrivileges);
                        }
                    } else {
                        if (object instanceof TableProxyOracle) {
                            perm.setTable((TableProxyOracle)object);
                        } else if (object instanceof TableViewProxyOracle) {
                            perm.setView((TableViewProxyOracle)object);
                        } else if (object instanceof SnapshotOracle) {
                            perm.setSnapshot((SnapshotOracle)object);
                        } else if (object instanceof SequenceOracle) {
                            perm.setSequence((SequenceOracle)object);
                        } else if (object instanceof StoredProcedureOracle) {
                            perm.setProc((StoredProcedureOracle)object);
                        } else if (object instanceof FunctionOracle) {
                            perm.setFunctionOracle((FunctionOracle)object);
                        } else if (object instanceof PackageOracle) {
                            perm.setPackage((PackageOracle)object);
                        } else if (object instanceof DirectoryOracle) {
                            perm.setDirectoryOracle((DirectoryOracle)object);
                        } else if (object instanceof StructuredTypeProxyOracle) {
                            perm.setStructuredTypeOracle((StructuredTypeProxyOracle)object);
                        } else if (object instanceof CollectionTypeProxyOracle) {
                            perm.setCollectionTypeOracle((CollectionTypeProxyOracle)object);
                        } else if (object instanceof ExternalTableOracle) {
                            perm.setExternalTableOracle((ExternalTableOracle)object);
                        }
                        perm.setPrivileges((String)p.getObject());
                        if (p.getGrantOption()) {
                            perm.setPrivilegesWithGrantOption((String)p.getObject());
                        }
                        if (p.getHierarchy()) {
                            perm.setPrivilegesWithHierarchyOption((String)p.getObject());
                        }
                    }
                    if (perm.getUser() != null && perm.getRole() != null) continue;
                    if (this.storageObject instanceof UserOracle) {
                        perm.setUser((UserOracle)this.storageObject);
                        continue;
                    }
                    if (!(this.storageObject instanceof RoleOracle)) continue;
                    perm.setRole((RoleOracle)this.storageObject);
                }
                continue;
            }
            if (perm == null) continue;
            perm.clear();
            perm.clearColPermissions();
            for (Privilege p : obj.getPrivileges()) {
                if (object instanceof ColumnProxyOracle) {
                    column = (ColumnProxyOracle)object;
                    perm.setColumnsTable(column.getTableProxy());
                    columnPrivileges = "";
                    columnPrivileges = columnPrivileges.concat(column.getName());
                    columnWithGrantOptionPrivileges = "";
                    columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(column.getName());
                    if (p.getGrantOption()) {
                        columnWithGrantOptionPrivileges = columnWithGrantOptionPrivileges.concat(", ").concat((String)p.getObject());
                    } else {
                        columnPrivileges = columnPrivileges.concat(", ").concat((String)p.getObject());
                    }
                    if (columnPrivileges.indexOf(",") > -1) {
                        perm.setColumnList(columnPrivileges);
                    }
                    if (columnWithGrantOptionPrivileges.indexOf(",") <= -1) continue;
                    perm.setColumnListWithGrantOption(columnWithGrantOptionPrivileges);
                    continue;
                }
                perm.setPrivileges((String)p.getObject());
                if (p.getGrantOption()) {
                    perm.setPrivilegesWithGrantOption((String)p.getObject());
                }
                if (!p.getHierarchy()) continue;
                perm.setPrivilegesWithHierarchyOption((String)p.getObject());
            }
        }
        Iterator<PrivilegedObject> it = this.objWithRevokedPrivs.iterator();
        while (it.hasNext()) {
            StorageObject so = (StorageObject)it.next().getObject();
            PermissionsOracle currentObjectPermission = this.getPermissionPerObject((StorageObject)this.storageObject, so);
            ps.remove(currentObjectPermission);
        }
    }

    private void filterByType() {
        this.privilegedObjectsTable.clearSelection();
        RowFilter rf = null;
        try {
            rf = this.cmbFilterType.getSelectedItem().equals(" ") ? RowFilter.regexFilter("", 0) : RowFilter.regexFilter("^" + this.cmbFilterType.getSelectedItem(), 0);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.privilegedObjectsTableRowSorter.setRowFilter(rf);
    }

    private ArrayList<String> getObjectsNames() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(this.TABLES);
        types.add(this.VIEWS);
        types.add(this.SNAPSHOTS);
        types.add(this.SEQUENCES);
        types.add(this.PROCEDURES);
        types.add(this.DIRECTORIES);
        types.add(this.STRUCT_TYPES);
        types.add(this.COLLECTION_TYPES);
        types.add(this.EXT_TABLES);
        return types;
    }

    private ArrayList<String> getObjectTypesList() {
        ArrayList<String> types = new ArrayList<String>();
        types.add(" ");
        types.add("table");
        types.add("view");
        types.add("mview");
        types.add("mviewl");
        types.add("seq");
        types.add("pkg");
        types.add("proc");
        types.add("func");
        types.add("dir");
        types.add("str_t");
        types.add("col_t");
        types.add("ext_t");
        types.add("col");
        return types;
    }

    private void filterAllObjects() {
        DefaultListModel model = null;
        List list = null;
        boolean done = false;
        if (this.cmbObjects.getSelectedItem().equals(this.TABLES)) {
            JListUtils.filter(this.currentAll_TablesList, this.allTablesPanelListModel, this.allObjectsFilterBox.getText(), true);
            JListUtils.filter(this.currentAll_ColumnsList, this.allColumnsPanelListModel, this.allObjectsFilterBox.getText(), true);
            done = true;
        } else if (this.cmbObjects.getSelectedItem().equals(this.COLUMNS)) {
            model = this.allColumnsPanelListModel;
            list = this.currentAll_ColumnsList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.VIEWS)) {
            model = this.allViewsPanelListModel;
            list = this.currentAll_ViewsList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.SNAPSHOTS)) {
            model = this.allSnapshotsPanelListModel;
            list = this.currentAll_SnapshotsList;
        } else if (this.cmbObjects.getSelectedItem().equals("Materialized View Logs")) {
            model = this.allMVLogsPanelListModel;
            list = this.currentAll_MVLogsList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.SEQUENCES)) {
            model = this.allSequencesPanelListModel;
            list = this.currentAll_SequencesList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.PROCEDURES)) {
            model = this.allProceduresPanelListModel;
            list = this.currentAll_ProceduresList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.DIRECTORIES)) {
            model = this.allDirectoriesPanelListModel;
            list = this.currentAll_DirectoriesList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.STRUCT_TYPES)) {
            model = this.allStructuredTypesPanelListModel;
            list = this.currentAll_StructuredTypesList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.COLLECTION_TYPES)) {
            model = this.allCollectionTypesPanelListModel;
            list = this.currentAll_CollectionTypesList;
        } else if (this.cmbObjects.getSelectedItem().equals(this.EXT_TABLES)) {
            model = this.allExternalTablesPanelListModel;
            list = this.currentAll_ExternalTablesList;
        }
        if (!done) {
            JListUtils.filter(list, model, this.allObjectsFilterBox.getText(), true);
        }
        this.objListPanel.updateUI();
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    private class SelectedObjectsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2600753990274250235L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserAndRolePermissionsDialogOracle.Type"), Messages.getString("UserAndRolePermissionsDialogOracle.Object"), Messages.getString("UserAndRolePermissionsDialogOracle.PrivilegesPermissions")};

        private SelectedObjectsModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PrivilegedObject po = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(row);
            if (col == 0) {
                Object o = po.getObject();
                if (o instanceof TableProxyOracle) {
                    return "table";
                }
                if (o instanceof TableViewProxyOracle) {
                    return "view";
                }
                if (o instanceof SnapshotOracle) {
                    return "mview";
                }
                if (o instanceof MaterializedViewLogOracle) {
                    return "mviewl";
                }
                if (o instanceof SequenceOracle) {
                    return "seq";
                }
                if (o instanceof PackageOracle) {
                    return "pkg";
                }
                if (o instanceof StoredProcedureOracle) {
                    return "proc";
                }
                if (o instanceof FunctionOracle) {
                    return "func";
                }
                if (o instanceof DirectoryOracle) {
                    return "dir";
                }
                if (o instanceof StructuredTypeProxyOracle) {
                    return "str_t";
                }
                if (o instanceof CollectionTypeProxyOracle) {
                    return "col_t";
                }
                if (o instanceof ExternalTableOracle) {
                    return "ext_t";
                }
                if (o instanceof ColumnProxyOracle) {
                    return "col";
                }
                return "";
            }
            if (col == 1) {
                Object o = po.getObject();
                if (o instanceof ColumnProxyOracle) {
                    return ((ColumnProxyOracle)o).getTableProxy().getName() + "." + ((ColumnProxyOracle)o).getName();
                }
                return o;
            }
            if (col == 2) {
                Object pr = "";
                ArrayList<Privilege> p = po.getPrivileges();
                Iterator<Privilege> it = p.iterator();
                while (it.hasNext()) {
                    pr = (String)pr + "," + it.next().getObject();
                }
                return po.getPrivileges().size() == 0 ? "" : ((String)pr).substring(1, ((String)pr).length());
            }
            return "";
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndRolePermissionsDialogOracle.this.savePermissions();
            UserAndRolePermissionsDialogOracle.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndRolePermissionsDialogOracle.this.savePermissions();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UserAndRolePermissionsDialogOracle.this.close();
        }
    }

    private class AddObjectActionListener
    implements ActionListener {
        private AddObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String selItem;
            if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowSorter() != null) {
                UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowSorter().setSortKeys(null);
            }
            if ((selItem = (String)UserAndRolePermissionsDialogOracle.this.cmbObjects.getSelectedItem()).equals(UserAndRolePermissionsDialogOracle.this.TABLES)) {
                if (UserAndRolePermissionsDialogOracle.this.tablesTPane.getSelectedIndex() == 0) {
                    Object[] selectedTables = UserAndRolePermissionsDialogOracle.this.allTablesPanelList.getSelectedValues();
                    for (int i = 0; i < selectedTables.length; ++i) {
                        PrivilegedObject privilegedObject = new PrivilegedObject(selectedTables[i]);
                        if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                        UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                        UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.removeElement(selectedTables[i]);
                        UserAndRolePermissionsDialogOracle.this.currentAll_TablesList.remove(selectedTables[i]);
                    }
                } else if (UserAndRolePermissionsDialogOracle.this.tablesTPane.getSelectedIndex() == 1) {
                    Object[] selectedColumns = UserAndRolePermissionsDialogOracle.this.allColumnsPanelList.getSelectedValues();
                    for (int i = 0; i < selectedColumns.length; ++i) {
                        PrivilegedObject privilegedObject = new PrivilegedObject(selectedColumns[i]);
                        if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                        UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                        UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.removeElement(selectedColumns[i]);
                        UserAndRolePermissionsDialogOracle.this.currentAll_ColumnsList.remove(selectedColumns[i]);
                    }
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.VIEWS)) {
                Object[] selectedViews = UserAndRolePermissionsDialogOracle.this.allViewsPanelList.getSelectedValues();
                for (int i = 0; i < selectedViews.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedViews[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel.removeElement(selectedViews[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_ViewsList.remove(selectedViews[i]);
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.SNAPSHOTS)) {
                Object[] selectedSnapshots = UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelList.getSelectedValues();
                for (int i = 0; i < selectedSnapshots.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedSnapshots[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel.removeElement(selectedSnapshots[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_SnapshotsList.remove(selectedSnapshots[i]);
                }
            } else if (selItem.equals("Materialized View Logs")) {
                Object[] selectedMVLogs = UserAndRolePermissionsDialogOracle.this.allMVLogsPanelList.getSelectedValues();
                for (int i = 0; i < selectedMVLogs.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedMVLogs[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allMVLogsPanelListModel.removeElement(selectedMVLogs[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_MVLogsList.remove(selectedMVLogs[i]);
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.SEQUENCES)) {
                Object[] selectedSequences = UserAndRolePermissionsDialogOracle.this.allSequencesPanelList.getSelectedValues();
                for (int i = 0; i < selectedSequences.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedSequences[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel.removeElement(selectedSequences[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_SequencesList.remove(selectedSequences[i]);
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.PROCEDURES)) {
                Object[] selectedProcedures = UserAndRolePermissionsDialogOracle.this.allProceduresPanelList.getSelectedValues();
                for (int i = 0; i < selectedProcedures.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedProcedures[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel.removeElement(selectedProcedures[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_ProceduresList.remove(selectedProcedures[i]);
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.DIRECTORIES)) {
                Object[] selectedDirs = UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelList.getSelectedValues();
                for (int i = 0; i < selectedDirs.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedDirs[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel.removeElement(selectedDirs[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_DirectoriesList.remove(selectedDirs[i]);
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.STRUCT_TYPES)) {
                Object[] selectedST = UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelList.getSelectedValues();
                for (int i = 0; i < selectedST.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedST[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel.removeElement(selectedST[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_StructuredTypesList.remove(selectedST[i]);
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.COLLECTION_TYPES)) {
                Object[] selectedCT = UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelList.getSelectedValues();
                for (int i = 0; i < selectedCT.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedCT[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel.removeElement(selectedCT[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_CollectionTypesList.remove(selectedCT[i]);
                }
            } else if (selItem.equals(UserAndRolePermissionsDialogOracle.this.EXT_TABLES)) {
                Object[] selectedExtTables = UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelList.getSelectedValues();
                for (int i = 0; i < selectedExtTables.length; ++i) {
                    PrivilegedObject privilegedObject = new PrivilegedObject(selectedExtTables[i]);
                    if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.contains(privilegedObject)) continue;
                    UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.add(privilegedObject);
                    UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel.removeElement(selectedExtTables[i]);
                    UserAndRolePermissionsDialogOracle.this.currentAll_ExternalTablesList.remove(selectedExtTables[i]);
                }
            }
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectionModel().setSelectionInterval(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowCount() - 1, UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowCount() - 1);
            UserAndRolePermissionsDialogOracle.this.filterByType();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.setRowSorter(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTableRowSorter);
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.setAutoCreateRowSorter(true);
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTableRowSorter.setSortsOnUpdates(true);
            WindowsTableHeader.setSortedHeader(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable, 1);
        }
    }

    private class RemoveObjectActionListener
    implements ActionListener {
        private RemoveObjectActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowSorter() != null) {
                UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getRowSorter().setSortKeys(null);
            }
            UserAndRolePermissionsDialogOracle.this.objWithRevokedPrivs.clear();
            int[] selectedPrivilegedObjects = UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.getSelectedRows();
            for (int i = 0; i < selectedPrivilegedObjects.length; ++i) {
                PrivilegedObject selectedObject = (PrivilegedObject)UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.get(selectedPrivilegedObjects[i]);
                Object current = selectedObject.getObject();
                UserAndRolePermissionsDialogOracle.this.objWithRevokedPrivs.add(selectedObject);
                if (selectedObject.getObject() instanceof TableProxyOracle && !UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.TABLES);
                    UserAndRolePermissionsDialogOracle.this.tablesTPane.setSelectedIndex(0);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allTablesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allTablesPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_TablesList.add(current);
                }
                if (selectedObject.getObject() instanceof ColumnProxyOracle) {
                    ColumnProxyOracle column = (ColumnProxyOracle)selectedObject.getObject();
                    TableProxyOracle table = column.getTableProxy();
                    boolean hasPrivs = false;
                    for (PrivilegedObject privilegedObject : UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList) {
                        if (!(privilegedObject.getObject() instanceof TableProxyOracle) || !((TableProxyOracle)privilegedObject.getObject()).getObjectID().equals(table.getObjectID())) continue;
                        hasPrivs = true;
                        break;
                    }
                    if (!hasPrivs) {
                        UserAndRolePermissionsDialogOracle.this.allTablesPanelList.setSelectedValue(column.getTableProxy(), true);
                        if (!UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.contains(current)) {
                            UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel.addElement(current);
                            UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.TABLES);
                            UserAndRolePermissionsDialogOracle.this.tablesTPane.setSelectedIndex(1);
                            JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allColumnsPanelListModel);
                            UserAndRolePermissionsDialogOracle.this.allColumnsPanelList.setSelectedValue(current, true);
                            UserAndRolePermissionsDialogOracle.this.currentAll_ColumnsList.add(current);
                        }
                    }
                }
                if (selectedObject.getObject() instanceof TableViewProxyOracle && !UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.VIEWS);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allViewsPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allViewsPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_ViewsList.add(current);
                }
                if (selectedObject.getObject() instanceof SnapshotOracle && !UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.SNAPSHOTS);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allSnapshotsPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_SnapshotsList.add(current);
                }
                if (selectedObject.getObject() instanceof MaterializedViewLogOracle && !UserAndRolePermissionsDialogOracle.this.allMVLogsPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allMVLogsPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem("Materialized View Logs");
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allMVLogsPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allMVLogsPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_MVLogsList.add(current);
                }
                if (selectedObject.getObject() instanceof SequenceOracle && !UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.SEQUENCES);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allSequencesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allSequencesPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_SequencesList.add(current);
                }
                if ((selectedObject.getObject() instanceof StoredProcedureOracle || selectedObject.getObject() instanceof PackageOracle || selectedObject.getObject() instanceof FunctionOracle) && !UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.PROCEDURES);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allProceduresPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allProceduresPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_ProceduresList.add(current);
                }
                if (selectedObject.getObject() instanceof DirectoryOracle && !UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.DIRECTORIES);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allDirectoriesPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_DirectoriesList.add(current);
                }
                if (selectedObject.getObject() instanceof StructuredTypeProxyOracle && !UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.STRUCT_TYPES);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allStructuredTypesPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_StructuredTypesList.add(current);
                }
                if (selectedObject.getObject() instanceof CollectionTypeProxyOracle && !UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel.contains(current)) {
                    UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel.addElement(current);
                    UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.COLLECTION_TYPES);
                    JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelListModel);
                    UserAndRolePermissionsDialogOracle.this.allCollectionTypesPanelList.setSelectedValue(current, true);
                    UserAndRolePermissionsDialogOracle.this.currentAll_CollectionTypesList.add(current);
                }
                if (!(selectedObject.getObject() instanceof ExternalTableOracle) || UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel.contains(current)) continue;
                UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel.addElement(current);
                UserAndRolePermissionsDialogOracle.this.cmbObjects.setSelectedItem(UserAndRolePermissionsDialogOracle.this.EXT_TABLES);
                JListUtils.sort(UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelListModel);
                UserAndRolePermissionsDialogOracle.this.allExternalTablesPanelList.setSelectedValue(current, true);
                UserAndRolePermissionsDialogOracle.this.currentAll_ExternalTablesList.add(current);
            }
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.removeAll(UserAndRolePermissionsDialogOracle.this.objWithRevokedPrivs);
            UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.clear();
            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.clear();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.clearSelection();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.clearSelection();
            if (UserAndRolePermissionsDialogOracle.this.privilegedObjectsContainerList.size() > 0) {
                UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.setRowSorter(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTableRowSorter);
                UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable, 1);
                UserAndRolePermissionsDialogOracle.this.filterAllObjects();
            } else {
                UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.setAutoCreateRowSorter(false);
                UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.setRowSorter(null);
            }
        }
    }

    private class AddPrivilegeActionListener
    implements ActionListener {
        private AddPrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<Object> tempList = new ArrayList<Object>();
            Object[] selected = UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                Privilege current = new Privilege(selected[i]);
                if (UserAndRolePermissionsDialogOracle.this.containerListPrivileges.contains(current)) continue;
                tempList.add(selected[i]);
                for (PrivilegedObject po : UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList) {
                    if (UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.size() > 1 && UserAndRolePermissionsDialogOracle.this.containerListPrivileges.size() == 0) {
                        po.removeAllPrivileges();
                    }
                    po.addPrivilege(current);
                }
                UserAndRolePermissionsDialogOracle.this.containerListPrivileges.add(current);
            }
            Iterator i = tempList.iterator();
            while (i.hasNext()) {
                UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.removeElement(i.next());
            }
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectionModel().setSelectionInterval(UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getRowCount() - 1, UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getRowCount() - 1);
        }
    }

    private class RemovePrivilegeActionListener
    implements ActionListener {
        private RemovePrivilegeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] selected = UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.getSelectedRows();
            ArrayList<Privilege> tempList = new ArrayList<Privilege>();
            for (int i = 0; i < selected.length; ++i) {
                UserAndRolePermissionsDialogOracle.this.currentPrivilege = UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(selected[i]);
                Object current = UserAndRolePermissionsDialogOracle.this.currentPrivilege.getObject();
                tempList.add(UserAndRolePermissionsDialogOracle.this.currentPrivilege);
                if (UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.contains(current)) continue;
                UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel.addElement(current);
                for (PrivilegedObject po : UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList) {
                    po.removePrivilege(UserAndRolePermissionsDialogOracle.this.currentPrivilege);
                }
                JListUtils.sort(UserAndRolePermissionsDialogOracle.this.availablePrivilegesModel);
                UserAndRolePermissionsDialogOracle.this.availablePrivilegesList.setSelectedValue(current, true);
            }
            UserAndRolePermissionsDialogOracle.this.containerListPrivileges.removeAll(tempList);
            UserAndRolePermissionsDialogOracle.this.privilegedObjectsTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.updateUI();
            UserAndRolePermissionsDialogOracle.this.privilegedObjectPrivilegesTable.clearSelection();
        }
    }

    private class AllObjectsFilterListener
    implements DocumentListener {
        private AllObjectsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UserAndRolePermissionsDialogOracle.this.filterAllObjects();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UserAndRolePermissionsDialogOracle.this.filterAllObjects();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            UserAndRolePermissionsDialogOracle.this.filterAllObjects();
        }
    }

    class ColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        ColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColumnProxyOracle column = (ColumnProxyOracle)value;
            this.setText(column.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class PrivilegedObject {
        Object obj = null;
        ArrayList<Privilege> privileges = new ArrayList();
        ArrayList<Privilege> privilegesWithGrantOption = new ArrayList();

        PrivilegedObject(Object object) {
            this.obj = object;
        }

        void addPrivilege(Privilege privilege) {
            this.privileges.add(privilege);
        }

        void removePrivilege(Privilege privilege) {
            this.privileges.remove(privilege);
        }

        Object getObject() {
            return this.obj;
        }

        ArrayList<Privilege> getPrivileges() {
            return this.privileges;
        }

        void setPrivileges(ArrayList<Privilege> privs) {
            this.privileges = privs;
        }

        void addPrivilegeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.add(privilege);
        }

        void removeWithGrantOption(Privilege privilege) {
            this.privilegesWithGrantOption.remove(privilege);
        }

        ArrayList<Privilege> getPrivilegeWithGrantOption() {
            return this.privilegesWithGrantOption;
        }

        void setPrivilegeWithGrantOption(ArrayList<Privilege> privs) {
            this.privilegesWithGrantOption = privs;
        }

        void removeAllPrivileges() {
            this.privileges.clear();
        }
    }

    class Privilege {
        Object obj = null;
        String name = "";
        boolean grantOption = false;
        boolean hierarchy = false;

        Privilege(Object object) {
            this.obj = object;
        }

        Object getObject() {
            return this.obj;
        }

        void setName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        void setGrantOption(boolean grantOption) {
            this.grantOption = grantOption;
        }

        boolean getGrantOption() {
            return this.grantOption;
        }

        void setHierarchy(boolean hierarchy) {
            this.hierarchy = hierarchy;
        }

        boolean getHierarchy() {
            return this.hierarchy;
        }
    }

    public class ColumnHierarchyRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -8185097460651240900L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Object obj = null;
            Iterator<PrivilegedObject> it = UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.iterator();
            if (it.hasNext()) {
                PrivilegedObject po = it.next();
                obj = po.getObject();
            }
            boolean val = (Boolean)value;
            if (!table.getModel().getValueAt(row, 0).equals("SELECT") || !(obj instanceof TableProxyOracle) && !(obj instanceof TableViewProxyOracle)) {
                this.setOpaque(true);
                this.setEnabled(false);
                this.setSelected(false);
                return new JLabel("");
            }
            this.setOpaque(false);
            this.setEnabled(true);
            this.setSelected(val);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    private class RoleGrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8480891404209029651L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserAndRolePermissionsDialogOracle.Privilege"), Messages.getString("UserAndRolePermissionsDialogOracle.Hierarchy")};

        private RoleGrantedPrivilegessModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserAndRolePermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Object obj = null;
            Iterator<PrivilegedObject> it = UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.iterator();
            if (it.hasNext()) {
                PrivilegedObject po = it.next();
                obj = po.getObject();
            }
            FKContainer o = null;
            if (columnIndex == 0) {
                return false;
            }
            if (columnIndex == 1) {
                if (this.getValueAt(rowIndex, 0).equals("SELECT") && (obj instanceof TableProxyOracle || obj instanceof TableViewProxyOracle)) {
                    if (obj instanceof TableProxyOracle) {
                        o = (Table)((TableProxyOracle)obj).getObject();
                    } else if (obj instanceof TableViewProxyOracle) {
                        o = (TableView)((TableViewProxyOracle)obj).getObject();
                    }
                    StructuredType bot = o.getBasedOnStructuredType();
                    if (bot != null && !bot.isFinal()) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Privilege privilege = UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (value instanceof Boolean) {
                privilege.setHierarchy((Boolean)value);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Privilege p = UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (col == 0) {
                return ((String)p.getObject()).trim();
            }
            if (col == 1) {
                return p.hierarchy;
            }
            return "";
        }
    }

    private class UserGrantedPrivilegessModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 2441829494099422701L;
        final String[] COL_NAMES = new String[]{Messages.getString("UserAndRolePermissionsDialogOracle.Privilege"), Messages.getString("UserAndRolePermissionsDialogOracle.Grant"), Messages.getString("UserAndRolePermissionsDialogOracle.Hierarchy")};

        private UserGrantedPrivilegessModel() {
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return UserAndRolePermissionsDialogOracle.this.containerListPrivileges.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Object obj = null;
            Iterator<PrivilegedObject> it = UserAndRolePermissionsDialogOracle.this.currentPrivilegedObjectList.iterator();
            if (it.hasNext()) {
                PrivilegedObject po = it.next();
                obj = po.getObject();
            }
            FKContainer o = null;
            if (columnIndex == 0) {
                return false;
            }
            if (columnIndex == 1) {
                return true;
            }
            if (columnIndex == 2) {
                if (this.getValueAt(rowIndex, 0).equals("SELECT") && (obj instanceof TableProxyOracle || obj instanceof TableViewProxyOracle)) {
                    if (obj instanceof TableProxyOracle) {
                        o = (Table)((TableProxyOracle)obj).getObject();
                    } else if (obj instanceof TableViewProxyOracle) {
                        o = (TableView)((TableViewProxyOracle)obj).getObject();
                    }
                    StructuredType bot = o.getBasedOnStructuredType();
                    if (bot != null && !bot.isFinal()) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Privilege privilege = UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (value instanceof Boolean) {
                if (col == 1) {
                    privilege.setGrantOption((Boolean)value);
                } else if (col == 2) {
                    privilege.setHierarchy((Boolean)value);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            Privilege p = UserAndRolePermissionsDialogOracle.this.containerListPrivileges.get(row);
            if (col == 0) {
                return ((String)p.getObject()).trim();
            }
            if (col == 1) {
                return p.grantOption;
            }
            if (col == 2) {
                return p.hierarchy;
            }
            return "";
        }
    }

    private class PrivilegedObjectsFilterListener
    implements DocumentListener {
        private PrivilegedObjectsFilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
        }
    }

    private class allObjectsPanelSelectionListener
    implements ListSelectionListener {
        private allObjectsPanelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }
}

