/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.NotNullConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TableCheckConstraintPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    protected TableCheckConstraintOracle tcc;
    private JTextArea taConstraint;
    private JComboBox cbInitially;
    private JComboBox cbDeferrable;
    private JComboBox cbEnable;
    private JComboBox cbValidate;
    private JComboBox cbExTable;

    public TableCheckConstraintPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.tcc = (TableCheckConstraintOracle)object;
        this.setHeight(370);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TableCheckConstraintPropertyDialogOracle.TableCheckConstraintProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initConstraint();
        this.initInitially();
        this.initDeferrable();
        this.initEnable();
        this.initValidate();
        this.initExTable();
    }

    private void initConstraint() {
        JLabel label = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogOracle.Constraint"));
        this.general.add(label);
        this.taConstraint = new JTextArea();
        JScrollPane sp = new JScrollPane(this.taConstraint);
        sp.setPreferredSize(new Dimension(395, 100));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.taConstraint.setLineWrap(true);
        this.taConstraint.setEnabled(false);
        this.general.add(sp);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(sp, 10, 70);
    }

    private void initInitially() {
        JLabel label = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogOracle.Initially"));
        this.general.add(label);
        this.cbInitially = new JComboBox<String>(NotNullConstraintOracle.getInitiallyChoices());
        this.setBG(this.cbInitially);
        this.cbInitially.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbInitially);
        this.setLabelConstraints(label, 190);
        this.setObjectConstraints(this.cbInitially, 190);
    }

    private void initDeferrable() {
        JLabel label = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogOracle.Deferrable"));
        this.general.add(label);
        this.cbDeferrable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDeferrable);
        this.cbDeferrable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDeferrable);
        this.setLabelConstraints(label, 220);
        this.setObjectConstraints(this.cbDeferrable, 220);
    }

    private void initEnable() {
        JLabel label = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogOracle.Enable"));
        this.general.add(label);
        this.cbEnable = new JComboBox<String>(YES_NO);
        this.setBG(this.cbEnable);
        this.cbEnable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnable);
        this.setLabelConstraints(label, 250);
        this.setObjectConstraints(this.cbEnable, 250);
    }

    private void initValidate() {
        JLabel label = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogOracle.Validate"));
        this.general.add(label);
        this.cbValidate = new JComboBox<String>(YES_NO);
        this.setBG(this.cbValidate);
        this.cbValidate.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbValidate);
        this.setLabelConstraints(label, 280);
        this.setObjectConstraints(this.cbValidate, 280);
    }

    private void initExTable() {
        JLabel label = new JLabel(Messages.getString("TableCheckConstraintPropertyDialogOracle.ExceptionsTable"));
        this.general.add(label);
        this.cbExTable = new JComboBox();
        this.setBG(this.cbExTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableProxySet().getElements().toArray(), this.cbExTable);
        }
        this.cbExTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbExTable);
        this.setLabelConstraints(label, 310);
        this.setObjectConstraints(this.cbExTable, 310);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.tcc.getName());
        this.tfName.setText(this.tcc.getName());
        if (this.tcc.getTableConstraint() != null) {
            this.taConstraint.setText(this.tcc.getTableConstraint().getRule());
            this.cbInitially.setSelectedItem(this.tcc.getInitially());
            this.cbDeferrable.setSelectedItem(TableCheckConstraintPropertyDialogOracle.translateYesNoForDisplay(this.tcc.getDeferrable()));
            this.cbEnable.setSelectedItem(TableCheckConstraintPropertyDialogOracle.translateYesNoForDisplay(this.tcc.getEnable()));
            this.cbValidate.setSelectedItem(TableCheckConstraintPropertyDialogOracle.translateYesNoForDisplay(this.tcc.getValidate()));
            this.cbExTable.setSelectedItem(this.tcc.getExceptionsTable());
        }
        this.getCommentsList().insert(this.tcc.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.tcc != null) {
            this.tcc.setName(this.tfName.getText());
            this.tcc.setInitially((String)this.cbInitially.getSelectedItem());
            this.tcc.setDeferrable(TableCheckConstraintPropertyDialogOracle.translateYesNoForStorage((String)this.cbDeferrable.getSelectedItem()));
            this.tcc.setEnable(TableCheckConstraintPropertyDialogOracle.translateYesNoForStorage((String)this.cbEnable.getSelectedItem()));
            this.tcc.setValidate(TableCheckConstraintPropertyDialogOracle.translateYesNoForStorage((String)this.cbValidate.getSelectedItem()));
            Object selected = this.cbExTable.getSelectedItem();
            if (selected instanceof TableProxyOracle) {
                this.tcc.setExceptionsTable((TableProxyOracle)selected);
            } else {
                this.tcc.setExceptionsTable(null);
            }
            this.tcc.setComment(this.getCommentsList().getText());
        }
    }
}

