/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class LobStoragePropertyDialogOracle
extends AbstractOraclePropertyDialog {
    protected LobStorageOracle lobStorage;
    private JTextField tfColumn;
    private JTextField tfLobSegmentName;
    private JComboBox cbTableSpace;
    private JComboBox cbStorageInRow;
    protected JComboBox cbLogging;
    private JComboBox cbCache;
    private JIntegerField ifChunk;
    private JComboBox cbOldVersions;
    private JIntegerField ifPctVersion;
    private JIntegerField ifFreePools;
    private JPanel storageProperties;
    private JIntegerField ifSCInitialExtent;
    private JIntegerField ifSCNextExtent;
    private JIntegerField ifSCMinExtents;
    private JTextField tfSCMaxExtents;
    private JIntegerField ifSCPctIncrease;
    private JComboBox cbSCBufferPool;
    private JIntegerField ifSCFreeLists;
    private JIntegerField ifSCFreeListsGroups;

    public LobStoragePropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.lobStorage = (LobStorageOracle)object;
        this.setHeight(this.getDialogHeight());
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    protected int getDialogHeight() {
        return 390;
    }

    @Override
    protected int getDialogWidth() {
        return 500;
    }

    @Override
    public String getCaption() {
        return Messages.getString("LobStoragePropertyDialogOracle.LobStorageProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        int ycoord = 50;
        ycoord += this.initLobColumn(ycoord);
        ycoord += this.initLobStorageType(ycoord);
        ycoord += this.initLobSegmentName(ycoord);
        ycoord += this.initTableSpace(ycoord);
        ycoord += this.initStorageInRow(ycoord);
        ycoord += this.initCompression(ycoord);
        ycoord += this.initCompressionType(ycoord);
        ycoord += this.initDuplication(ycoord);
        ycoord += this.initLogging(ycoord);
        ycoord += this.initCache(ycoord);
        ycoord += this.initChunk(ycoord);
        ycoord += this.initOldVersions(ycoord);
        ycoord += this.initPctVersion(ycoord);
        this.initFreePools(ycoord);
    }

    private int initLobColumn(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.LobColumn"));
        this.general.add(label);
        this.tfColumn = new JTextField("", 26);
        this.tfColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.tfColumn);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfColumn, ycoord);
        return 30;
    }

    protected int initLobStorageType(int ycoord) {
        return 0;
    }

    private int initLobSegmentName(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.LobSegmentName"));
        this.general.add(label);
        this.tfLobSegmentName = new JTextField("", 26);
        this.general.add(this.tfLobSegmentName);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.tfLobSegmentName, ycoord);
        return 30;
    }

    private int initTableSpace(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbTableSpace, ycoord);
        return 30;
    }

    private int initStorageInRow(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.StorageInRow"));
        this.general.add(label);
        this.cbStorageInRow = new JComboBox<String>(LobStorageOracle.getStorageInRowChoices());
        this.setBG(this.cbStorageInRow);
        this.cbStorageInRow.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbStorageInRow);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbStorageInRow, ycoord);
        return 30;
    }

    protected int initCompression(int ycoord) {
        return 0;
    }

    protected int initCompressionType(int ycoord) {
        return 0;
    }

    protected int initDuplication(int ycoord) {
        return 0;
    }

    protected int initLogging(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbLogging, ycoord);
        return 30;
    }

    private int initCache(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.Cache"));
        this.general.add(label);
        this.cbCache = new JComboBox<String>(LobStorageOracle.getCacheChoices());
        this.setBG(this.cbCache);
        this.cbCache.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCache);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbCache, ycoord);
        return 30;
    }

    private int initChunk(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.Chunk"));
        this.general.add(label);
        this.ifChunk = new JIntegerField(0, 26);
        this.general.add(this.ifChunk);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.ifChunk, ycoord);
        return 30;
    }

    private int initOldVersions(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.OldVersions"));
        this.general.add(label);
        this.cbOldVersions = new JComboBox<String>(LobStorageOracle.getOldVersionChoices());
        this.cbOldVersions.addActionListener(new VersionListener());
        this.setBG(this.cbOldVersions);
        this.cbOldVersions.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOldVersions);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.cbOldVersions, ycoord);
        return 30;
    }

    private int initPctVersion(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.PCTVersion"));
        this.general.add(label);
        this.ifPctVersion = new JIntegerField(0, 26);
        this.general.add(this.ifPctVersion);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.ifPctVersion, ycoord);
        return 30;
    }

    private int initFreePools(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.FreePools"));
        this.general.add(label);
        this.ifFreePools = new JIntegerField(0, 26);
        this.general.add(this.ifFreePools);
        this.setLabelConstraints(label, ycoord);
        this.setObjectConstraints(this.ifFreePools, ycoord);
        return 30;
    }

    @Override
    protected void addTabs() {
        this.storageProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("SegmentPropertyDialogOracle.SegmentProperties"), this.storageProperties);
        this.initStorageProperties();
    }

    protected SpringLayout getStoragePropertiesLayout() {
        return (SpringLayout)this.storageProperties.getLayout();
    }

    private void initStorageProperties() {
        this.initSCInitialExtent(20);
        this.initSCNextExtent(50);
        this.initSCMinExtents(80);
        this.initSCMaxExtents(110);
        this.initSCPctIncrease(140);
        this.initSCBufferPool(170);
        this.initSCFreeLists(200);
        this.initSCFreeListsGroups(230);
    }

    private void initSCInitialExtent(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCInitialExtent"));
        this.storageProperties.add(label);
        this.ifSCInitialExtent = new JIntegerField(0, 26);
        this.storageProperties.add(this.ifSCInitialExtent);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.ifSCInitialExtent, ycoord);
    }

    private void initSCNextExtent(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCNextExtent"));
        this.storageProperties.add(label);
        this.ifSCNextExtent = new JIntegerField(0, 26);
        this.storageProperties.add(this.ifSCNextExtent);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.ifSCNextExtent, ycoord);
    }

    private void initSCMinExtents(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCMinExtents"));
        this.storageProperties.add(label);
        this.ifSCMinExtents = new JIntegerField(0, 26);
        this.storageProperties.add(this.ifSCMinExtents);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.ifSCMinExtents, ycoord);
    }

    private void initSCMaxExtents(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCMaxExtents"));
        this.storageProperties.add(label);
        this.tfSCMaxExtents = new JTextField("UNLIMITED", 26);
        this.storageProperties.add(this.tfSCMaxExtents);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.tfSCMaxExtents, ycoord);
    }

    private void initSCPctIncrease(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCPCTIncrease"));
        this.storageProperties.add(label);
        this.ifSCPctIncrease = new JIntegerField(0, 26);
        this.storageProperties.add(this.ifSCPctIncrease);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.ifSCPctIncrease, ycoord);
    }

    private void initSCBufferPool(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCBufferPool"));
        this.storageProperties.add(label);
        this.cbSCBufferPool = new JComboBox<String>(LobStorageOracle.getSCBufferPoolValues());
        this.setBG(this.cbSCBufferPool);
        this.cbSCBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.storageProperties.add(this.cbSCBufferPool);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.cbSCBufferPool, ycoord);
    }

    private void initSCFreeLists(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCFreeLists"));
        this.storageProperties.add(label);
        this.ifSCFreeLists = new JIntegerField(0, 26);
        this.storageProperties.add(this.ifSCFreeLists);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.ifSCFreeLists, ycoord);
    }

    private void initSCFreeListsGroups(int ycoord) {
        JLabel label = new JLabel(Messages.getString("LobStoragePropertyDialogOracle.SCFreeListsGrps"));
        this.storageProperties.add(label);
        this.ifSCFreeListsGroups = new JIntegerField(0, 26);
        this.storageProperties.add(this.ifSCFreeListsGroups);
        this.setLabelConstraints(this.getStoragePropertiesLayout(), label, ycoord);
        this.setObjectConstraints(this.getStoragePropertiesLayout(), this.ifSCFreeListsGroups, ycoord);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.lobStorage.getName());
        this.tfName.setText(this.lobStorage.getName());
        this.tfColumn.setText(this.lobStorage.getColumn());
        this.tfLobSegmentName.setText(this.lobStorage.getLobSegmentName());
        this.selectObject(this.cbTableSpace, this.lobStorage.getTableSpace());
        this.cbStorageInRow.setSelectedItem(this.lobStorage.getStorageInRow());
        this.cbLogging.setSelectedItem(LobStoragePropertyDialogOracle.translateYesNoForDisplay(this.lobStorage.getLogging()));
        this.cbCache.setSelectedItem(this.lobStorage.getCache());
        this.ifChunk.setValue((long)this.lobStorage.getChunk());
        this.cbOldVersions.setSelectedItem(this.lobStorage.getOldVersions());
        this.ifFreePools.setValue((long)this.lobStorage.getFreepools());
        this.ifPctVersion.setValue((long)this.lobStorage.getPCTVersion());
        this.ifSCInitialExtent.setValue(this.lobStorage.getSCInitialExtent());
        this.ifSCNextExtent.setValue(this.lobStorage.getSCNextExtent());
        this.ifSCMinExtents.setValue((long)this.lobStorage.getSCMinExtents());
        this.tfSCMaxExtents.setText(this.lobStorage.getSCMaxExtents());
        this.ifSCPctIncrease.setValue((long)this.lobStorage.getSCPctIncrease());
        this.cbSCBufferPool.setSelectedItem(this.lobStorage.getSCBufferPool());
        this.ifSCFreeLists.setValue((long)this.lobStorage.getSCFreeLists());
        this.ifSCFreeListsGroups.setValue((long)this.lobStorage.getSCFreelistGroups());
        this.getCommentsList().insert(this.lobStorage.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.lobStorage != null) {
            this.lobStorage.setName(this.tfName.getText());
            this.lobStorage.setColumn(this.tfColumn.getText());
            this.lobStorage.setLobSegmentName(this.tfLobSegmentName.getText());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.lobStorage.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.lobStorage.setTableSpace(null);
            }
            this.lobStorage.setStorageInRow((String)this.cbStorageInRow.getSelectedItem());
            this.lobStorage.setLogging(LobStoragePropertyDialogOracle.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            this.lobStorage.setCache((String)this.cbCache.getSelectedItem());
            this.lobStorage.setChunk(this.ifChunk.getIntValue());
            this.lobStorage.setOldVersions((String)this.cbOldVersions.getSelectedItem());
            this.lobStorage.setFreepools(this.ifFreePools.getIntValue());
            this.lobStorage.setPCTVersion(this.ifPctVersion.getIntValue());
            this.lobStorage.setSCInitialExtent(this.ifSCInitialExtent.getIntValue());
            this.lobStorage.setSCNextExtent(this.ifSCNextExtent.getIntValue());
            this.lobStorage.setSCMinExtents(this.ifSCMinExtents.getIntValue());
            this.lobStorage.setSCMaxExtents(this.tfSCMaxExtents.getText());
            this.tfSCMaxExtents.setText(this.lobStorage.getSCMaxExtents());
            this.lobStorage.setSCPctIncrease(this.ifSCPctIncrease.getIntValue());
            this.lobStorage.setSCBufferPool((String)this.cbSCBufferPool.getSelectedItem());
            this.lobStorage.setSCFreeLists(this.ifSCFreeLists.getIntValue());
            this.lobStorage.setSCFreelistGroups(this.ifSCFreeListsGroups.getIntValue());
            this.lobStorage.setComment(this.getCommentsList().getText());
        }
    }

    private class VersionListener
    implements ActionListener {
        private VersionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((String)LobStoragePropertyDialogOracle.this.cbOldVersions.getSelectedItem()).equalsIgnoreCase(LobStorageOracle.getOldVersionChoices()[0])) {
                LobStoragePropertyDialogOracle.this.ifPctVersion.setEnabled(false);
            } else {
                LobStoragePropertyDialogOracle.this.ifPctVersion.setEnabled(true);
            }
        }
    }
}

