/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.PlSqlSourceStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractDatatypePropertiesDialog;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ObjectPermissionsDialogOracle;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DefaultPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private JComboBox cbOwner;
    private JButton bnPermissions;
    private ObjectPermissionsDialogOracle dialog;
    private boolean propertiesSet;

    public DefaultPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.setHeight(280);
        if (this.showCommentsTab()) {
            this.initCommentsView();
        }
        if (this.showNotesTab()) {
            this.initNotesView();
        }
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    protected boolean showCommentsTab() {
        return true;
    }

    protected boolean showNotesTab() {
        return true;
    }

    @Override
    public String getCaption() {
        String objectTypeName = this.getStorageObject().getObjectTypeName();
        if (objectTypeName.equals("Package")) {
            return Messages.getString("DefaultPropertyDialogOracle.PackageProperties");
        }
        return objectTypeName + " " + Messages.getString("DefaultPropertyDialogOracle.Properties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("DefaultPropertyDialogOracle.User"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogOracle.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlSqlSourceStorageObjectOracle storageObject = (PlSqlSourceStorageObjectOracle)DefaultPropertyDialogOracle.this.getStorageObject();
                ArrayList list = new ArrayList();
                list.addAll(storageObject.getObjectSet().getElementsList());
                list.remove(storageObject);
                new PropertiesPropagationDialog(DefaultPropertyDialogOracle.this.getAppView(), storageObject, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 220);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("DefaultPropertyDialogOracle.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 220);
    }

    @Override
    public void initProperties() {
        PlSqlSourceStorageObjectOracle storageObject = (PlSqlSourceStorageObjectOracle)this.getStorageObject();
        this.initCaption(storageObject.getName());
        this.tfName.setText(storageObject.getName());
        if (storageObject.isNameFixed()) {
            this.tfName.setEnabled(false);
            this.tfName.setToolTipText(AbstractDatatypePropertiesDialog.NAME_IS_FROZEN);
        }
        if (this.showCommentsTab()) {
            this.taComments.setText(storageObject.getComment());
        }
        if (this.showNotesTab()) {
            this.taNotes.setText(storageObject.getNotes());
        }
        this.cbOwner.setSelectedItem(storageObject.getOwner());
    }

    @Override
    protected void setProperties() {
        PlSqlSourceStorageObjectOracle storageObject = (PlSqlSourceStorageObjectOracle)this.getStorageObject();
        if (storageObject != null) {
            storageObject.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            storageObject.setName(this.tfName.getText());
            if (this.showCommentsTab()) {
                storageObject.setComment(this.taComments.getText());
            }
            if (this.showNotesTab()) {
                storageObject.setNotes(this.taNotes.getText());
            }
        }
        this.propertiesSet = true;
    }

    public boolean isPropertiesSet() {
        return this.propertiesSet;
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbOwner.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultPropertyDialogOracle.this.dialog = new ObjectPermissionsDialogOracle(DefaultPropertyDialogOracle.this.getAppView(), DefaultPropertyDialogOracle.this.getStorageDesign(), DefaultPropertyDialogOracle.this.getStorageObject());
            DefaultPropertyDialogOracle.this.dialog.showDialog();
        }
    }
}

