/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterColumnOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class ClusterColumnPropertyDialogOracle
extends AbstractOraclePropertyDialog {
    private ClusterColumnOracle column;
    private JComboBox cbDataType;
    private JTextField tfSize;
    private JIntegerField ifScale;
    private JIntegerField ifPosition;

    public ClusterColumnPropertyDialogOracle(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ClusterColumnOracle)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("ClusterColumnPropertyDialogOracle.ClusterColumnProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initDataType();
        this.initSize();
        this.initScale();
        this.initPosition();
    }

    private void initDataType() {
        JLabel label = new JLabel(Messages.getString("ClusterColumnPropertyDialogOracle.DataType"));
        this.general.add(label);
        this.cbDataType = new JComboBox<String>(ClusterColumnOracle.getDataTypesChoices());
        this.cbDataType.addActionListener(new DataTypeListener());
        this.setBG(this.cbDataType);
        this.cbDataType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataType);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbDataType, 50);
    }

    private void initSize() {
        JLabel label = new JLabel(Messages.getString("ClusterColumnPropertyDialogOracle.PrecisionSize"));
        this.general.add(label);
        this.tfSize = new JTextField("", 26);
        this.general.add(this.tfSize);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfSize, 80);
    }

    private void initScale() {
        JLabel label = new JLabel(Messages.getString("ClusterColumnPropertyDialogOracle.Scale"));
        this.general.add(label);
        this.ifScale = new JIntegerField(0, 26);
        this.general.add(this.ifScale);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.ifScale, 110);
    }

    private void initPosition() {
        JLabel label = new JLabel(Messages.getString("ClusterColumnPropertyDialogOracle.Position"));
        this.general.add(label);
        this.ifPosition = new JIntegerField(0, 26);
        this.general.add(this.ifPosition);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifPosition, 140);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.column.getName());
        this.tfName.setText(this.column.getName());
        this.cbDataType.setSelectedItem(this.column.getDataType());
        this.tfSize.setText(this.column.getLengthPrecision());
        this.ifScale.setValue((long)this.column.getScale());
        this.ifPosition.setValue((long)this.column.getPosition());
        this.getCommentsList().insert(this.column.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            this.column.setName(this.tfName.getText());
            this.column.setLengthPrecision(this.tfSize.getText());
            this.column.setScale(this.ifScale.getIntValue());
            this.column.setDataType((String)this.cbDataType.getSelectedItem());
            this.column.setPosition(this.ifPosition.getIntValue());
            this.column.setComment(this.getCommentsList().getText());
        }
    }

    private class DataTypeListener
    implements ActionListener {
        private DataTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String dataType = (String)ClusterColumnPropertyDialogOracle.this.cbDataType.getSelectedItem();
            ClusterColumnPropertyDialogOracle.this.tfSize.setEnabled(ClusterColumnPropertyDialogOracle.this.column.isLengthPrecAllowed(dataType));
            ClusterColumnPropertyDialogOracle.this.ifScale.setEnabled(ClusterColumnPropertyDialogOracle.this.column.isScaleAllowed(dataType));
        }
    }
}

