/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.InstanceDescriptorColumnDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TablePartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableSpaceDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.InstanceDescriptorColumnPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.PermissionsPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.v80.TablePartitionPropertyDialogDB2v80;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class TablePropertyDialogDB2v80
extends AbstractDB2PropertyDialog {
    protected TableProxyDB2v80 table;
    protected JComboBox cbOwner;
    protected JComboBox cbTableSpace;
    protected JComboBox cbDataBase;
    protected JIntegerField ifObid;
    protected JTextField tfEditProc;
    protected JTextField tfValidProc;
    protected JComboBox cbAudit;
    protected JComboBox cbDataCapture;
    protected JComboBox cbRestrictOnDrop;
    protected JComboBox cbCCSID;
    protected JTextField tfLabel;
    protected JPanel columns;
    protected JPanel indices;
    protected JPanel catalogStats;
    protected JPanel designStats;
    protected JList columnList;
    protected JList indexList;
    protected DefaultListModel columnListModel;
    protected DefaultListModel indexListModel;
    protected JIntegerField ifCARDF;
    protected JTextField tfCreatedBy;
    protected JIntegerField ifRecLength;
    protected JIntegerField ifNPAGES;
    protected JIntegerField ifPCTPAGES;
    protected JIntegerField ifMaxRows;
    protected JIntegerField ifInitialRows;
    protected JDecimalField dfAURInsert;
    protected JDecimalField dfAURDelete;
    protected JDecimalField dfAURNetGrowth;
    protected JDecimalField dfAGInsert;
    protected JDecimalField dfAGDelete;
    protected JDecimalField dfAGData;
    protected JIntegerField ifGrowthHorizon;
    protected JIntegerField ifPCTFilling;
    protected JComboBox cbGrowthMethod;
    protected JComboBox cbInsertMethod;
    protected JTextPane taSpaceCalcs;
    protected JPanel spaceCalcs;
    protected JCheckBox chbUsePCTFilling;
    protected JScrollPane spSpaceCalcs;
    protected JScrollPane spColumns;
    protected JScrollPane spIndices;
    protected JIntegerField ifNumParts;
    protected JComboBox cbPartitioned;
    protected JComboBox cbMaterializedQuery;
    protected JComboBox cbTableAccess;
    protected JComboBox cbMQStatus;
    protected JComboBox cbMQMaintenance;
    protected JComboBox cbMQQueryOptimization;
    protected JComboBox cbMQIdentityColumnAttr;
    protected JComboBox cbMQColumnDefaults;
    protected JPanel materializedQuery;
    protected JPanel partitioningKey;
    protected JTextArea queryArea;
    private DefaultListModel allColumnsModel;
    private JList allColumnsList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JTable selectedColumnsTable;
    private IndexTableModel selectedColumnsModel;
    private String comment;
    private String commentInRDBMS;
    private JPanel partitionsOrder;
    private DefaultListModel partitionsModel;
    private JList partitionsList;
    private JButton bnPermissions;
    private PermissionsPropertyDialogDB2 dialog;
    private JPanel instDescriptorPanel;
    private List eList;
    private JTable etable;
    private int attrCounter = 0;

    public TablePropertyDialogDB2v80(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.table = (TableProxyDB2v80)object;
        this.setHeight(620);
        this.initCommentsView(245);
        this.initCommentsInRDBMS(250);
        this.initSpaceCalcsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TablePropertyDialogDB2v80.TableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initTableSpace();
        this.initDataBase();
        this.initOBID();
        this.initEditProc();
        this.initValidProc();
        this.initAudit();
        this.initDataCapture();
        this.initRestrictOnDrop();
        this.initCCSID();
        this.initLabel();
        this.initSpaceCalcs();
        this.initPartitioned();
        this.initNumParts();
        this.initHasMaterializedQuery();
        this.initTableAccess();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
        this.initPermissionsButton();
    }

    protected void initOwner() {
        JButton button = new JButton("...");
        button.setPreferredSize(new Dimension(30, 20));
        button.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.OwnerProperties"));
        button.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(button);
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 50);
        this.setObjectConstraints(button, 50);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = TablePropertyDialogDB2v80.this.cbOwner.getSelectedItem();
                if (object != null && object instanceof Owner) {
                    Owner db = (Owner)object;
                    db.showPropertyDialog();
                }
            }
        });
    }

    protected void initTableSpace() {
        JButton button = new JButton("...");
        button.setPreferredSize(new Dimension(30, 20));
        button.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.TablespaceProperties"));
        button.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(button);
        JLabel lbTableSpace = new JLabel(Messages.getString("TablePropertyDialogDB2v80.TableSpace"));
        this.general.add(lbTableSpace);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.cbTableSpace.addActionListener(new ComboListener());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(lbTableSpace, 80);
        this.setObjectConstraints(this.cbTableSpace, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 80);
        this.setObjectConstraints(button, 80);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = TablePropertyDialogDB2v80.this.cbTableSpace.getSelectedItem();
                if (object != null && object instanceof TableSpaceDB2) {
                    TableSpaceDB2 st = (TableSpaceDB2)object;
                    st.showPropertyDialog();
                }
            }
        });
    }

    protected void initDataBase() {
        JButton button = new JButton("...");
        button.setPreferredSize(new Dimension(30, 20));
        button.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.DataBaseProperties"));
        button.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(button);
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.DataBase"));
        this.general.add(label);
        this.cbDataBase = new JComboBox();
        this.setBG(this.cbDataBase);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getDataBaseSet().toArray(), this.cbDataBase);
        }
        this.cbDataBase.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.cbDataBase.setEnabled(false);
        this.general.add(this.cbDataBase);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDataBase, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.setObjectConstraints(button, 110);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = TablePropertyDialogDB2v80.this.cbDataBase.getSelectedItem();
                if (object != null && object instanceof DataBaseDB2) {
                    DataBaseDB2 db = (DataBaseDB2)object;
                    db.showPropertyDialog();
                }
            }
        });
    }

    protected void initOBID() {
        JLabel label = new JLabel("OBID");
        this.general.add(label);
        this.ifObid = new JIntegerField(0, 26);
        this.general.add(this.ifObid);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.ifObid, 140);
    }

    protected void initEditProc() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.EditProc"));
        this.general.add(label);
        this.tfEditProc = new JTextField("", 26);
        this.general.add(this.tfEditProc);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.tfEditProc, 170);
    }

    protected void initValidProc() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.ValidProc"));
        this.general.add(label);
        this.tfValidProc = new JTextField("", 26);
        this.general.add(this.tfValidProc);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.tfValidProc, 200);
    }

    protected void initAudit() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Audit"));
        this.general.add(label);
        this.cbAudit = new JComboBox<String>(TableProxyDB2.getAuditChoices());
        this.setBG(this.cbAudit);
        this.cbAudit.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAudit);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbAudit, 230);
    }

    protected void initDataCapture() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.DataCapture"));
        this.general.add(label);
        this.cbDataCapture = new JComboBox<String>(TableProxyDB2.getDataCaptureValues());
        this.setBG(this.cbDataCapture);
        this.cbDataCapture.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDataCapture);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbDataCapture, 260);
    }

    protected void initRestrictOnDrop() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.DropRestrict"));
        this.general.add(label);
        this.cbRestrictOnDrop = new JComboBox<String>(YES_NO);
        this.setBG(this.cbRestrictOnDrop);
        this.cbRestrictOnDrop.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRestrictOnDrop);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbRestrictOnDrop, 290);
    }

    protected void initCCSID() {
        JLabel label = new JLabel("CCSID");
        this.general.add(label);
        this.cbCCSID = new JComboBox<String>(TableProxyDB2.getCcsidValues());
        this.setBG(this.cbCCSID);
        this.cbCCSID.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCCSID);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbCCSID, 320);
    }

    protected void initLabel() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Label"));
        this.general.add(label);
        this.tfLabel = new JTextField("", 26);
        this.general.add(this.tfLabel);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.tfLabel, 350);
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initMaterializedQueryView();
        this.initPartitioningKeyView();
        this.initPartitionsOrderView();
        this.initInstanceDescriptorView();
    }

    private void initInstanceDescriptorView() {
        this.instDescriptorPanel = new JPanel();
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.InstanceDescriptor"), this.instDescriptorPanel);
        this.initInstanceDescriptor();
    }

    private void initInstanceDescriptor() {
        ElementModel dataModel = new ElementModel();
        this.eList = new ArrayList();
        this.etable = new JTable(dataModel);
        this.etable.setSelectionMode(0);
        this.etable.setFocusTraversalKeysEnabled(false);
        TableColumn column = this.etable.getColumnModel().getColumn(0);
        column.setPreferredWidth(400);
        column = this.etable.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        this.etable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                InstanceDescriptorColumnDB2 element;
                int row;
                if (e.getClickCount() == 2 && (row = TablePropertyDialogDB2v80.this.etable.getSelectedRow()) != -1 && TablePropertyDialogDB2v80.this.eList.size() > 0 && row < TablePropertyDialogDB2v80.this.eList.size() && !(element = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(row)).isDialogVisible()) {
                    InstanceDescriptorColumnPropertyDialogDB2 dialog = new InstanceDescriptorColumnPropertyDialogDB2(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.table.getStorageDesign(), element);
                    dialog.initProperties();
                    dialog.show();
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.etable);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Properties"));
        btnProperties.addActionListener(new PropertiesAction());
        JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", 16));
        btnAdd.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Add"));
        btnAdd.addActionListener(new AddAction());
        JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", 16));
        btnRemove.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Remove"));
        btnRemove.addActionListener(new RemoveAction());
        JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
        btnUp.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveUp"));
        btnUp.addActionListener(new MoveUpColAction());
        JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
        btnDown.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveDown"));
        btnDown.addActionListener(new MoveDownColAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(btnAdd);
        toolBar.add(btnRemove);
        toolBar.add(btnUp);
        toolBar.add(btnDown);
        buttonPanel.add(toolBar);
        buttonPanel.setPreferredSize(new Dimension(395, 30));
        scrollpane.setPreferredSize(new Dimension(395, 490));
        this.instDescriptorPanel.add((Component)buttonPanel, "North");
        this.instDescriptorPanel.add(scrollpane);
    }

    protected String generateName() {
        String name = "InstanceDescriptorCol";
        int newNumber = 0;
        int lastNumber = this.eList.size();
        if (lastNumber != 0) {
            newNumber = this.attrCounter = lastNumber + 1;
        } else {
            ++this.attrCounter;
            newNumber = this.attrCounter;
        }
        String attrName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.instDescrExists(attrName)) {
            newNumber = ++this.attrCounter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    private boolean instDescrExists(String name) {
        for (int i = 0; i < this.eList.size(); ++i) {
            InstanceDescriptorColumnDB2 element = (InstanceDescriptorColumnDB2)this.eList.get(i);
            if (!name.equalsIgnoreCase(element.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveElementToIndex(InstanceDescriptorColumnDB2 object, int index) {
        if (this.eList.contains(object) && this.eList.size() > index && index >= 0) {
            this.eList.remove(object);
            this.eList.add(index, object);
            return true;
        }
        return false;
    }

    protected void initMaterializedQueryView() {
        this.materializedQuery = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.MaterializedQuery"), this.materializedQuery);
        this.initMaterializedQuery();
    }

    private void initMaterializedQuery() {
        this.initMQQueryDefinition();
        this.initMQStatus();
        this.initMQMaintenance();
        this.initMQQueryOptimization();
        this.initMQIdentityColumnAttr();
        this.initMQColumnDefaults();
    }

    private void initMQQueryDefinition() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Query"));
        this.materializedQuery.add(label);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), label, 10);
        this.queryArea = new JTextArea();
        JScrollPane sp = new JScrollPane(this.queryArea);
        sp.setPreferredSize(new Dimension(395, 340));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.queryArea.setLineWrap(true);
        this.materializedQuery.add(sp);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), sp, 10, 30);
    }

    protected SpringLayout getMaterializedQueryLayout() {
        return (SpringLayout)this.materializedQuery.getLayout();
    }

    private void initMQStatus() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Status"));
        this.materializedQuery.add(label);
        this.cbMQStatus = new JComboBox<String>(TableProxyDB2v80.MQ_STATUS_STATES);
        this.setBG(this.cbMQStatus);
        this.cbMQStatus.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQStatus);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), label, 390);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQStatus, 390);
    }

    private void initMQMaintenance() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Maintenance"));
        this.materializedQuery.add(label);
        this.cbMQMaintenance = new JComboBox<String>(TableProxyDB2v80.MQ_MAINTENANCE_STATES);
        this.setBG(this.cbMQMaintenance);
        this.cbMQMaintenance.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQMaintenance);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), label, 420);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQMaintenance, 420);
    }

    private void initMQQueryOptimization() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.QueryOptimization"));
        this.materializedQuery.add(label);
        this.cbMQQueryOptimization = new JComboBox<String>(TableProxyDB2v80.MQ_QUERY_OPTIMIZATION_STATES);
        this.setBG(this.cbMQQueryOptimization);
        this.cbMQQueryOptimization.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQQueryOptimization);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), label, 450);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQQueryOptimization, 450);
    }

    private void initMQIdentityColumnAttr() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.IdentityColumnAttr"));
        this.materializedQuery.add(label);
        this.cbMQIdentityColumnAttr = new JComboBox<String>(TableProxyDB2v80.MQ_IDENTITY_COLUMN_ATTR_STATES);
        this.setBG(this.cbMQIdentityColumnAttr);
        this.cbMQIdentityColumnAttr.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQIdentityColumnAttr);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), label, 480);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQIdentityColumnAttr, 480);
    }

    private void initMQColumnDefaults() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.ColumnDefaults"));
        this.materializedQuery.add(label);
        this.cbMQColumnDefaults = new JComboBox<String>(TableProxyDB2v80.MQ_COLUMN_DEFAULTS_STATES);
        this.setBG(this.cbMQColumnDefaults);
        this.cbMQColumnDefaults.setPreferredSize(this.tfName.getPreferredSize());
        this.materializedQuery.add(this.cbMQColumnDefaults);
        this.setLabelConstraints(this.getMaterializedQueryLayout(), label, 510);
        this.setObjectConstraints(this.getMaterializedQueryLayout(), this.cbMQColumnDefaults, 510);
    }

    protected void initPartitioningKeyView() {
        this.partitioningKey = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.PartitioningKey"), this.partitioningKey);
        this.initPartitioningKey();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.Properties"));
        btnProperties.addActionListener(new PartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveUp"));
            btnUp.addActionListener(new MoveUpAction());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.MoveDown"));
            btnDown.addActionListener(new MoveDownAction());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.partitionsOrder.add((Component)buttonGeneral, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        JScrollPane sp = new JScrollPane(this.partitionsList);
        sp.setPreferredSize(new Dimension(400, 490));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(sp);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), sp, 6, 40);
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    private void initPartitioningKey() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AllColumns"));
        this.partitioningKey.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setCellRenderer(new AllListColumnsCellRenderer());
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(395, 210));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioningKey.add(sp);
        this.setLabelConstraints(this.getPartitioningKeyLayout(), label, 12, 14);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), sp, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.SelectedColumns"));
        this.partitioningKey.add(label);
        this.selectedColumnsTable = new JTable(new IndexTableModel());
        this.selectedColumnsModel = (IndexTableModel)this.selectedColumnsTable.getModel();
        this.setUpSortOrderColumn(this.selectedColumnsTable.getColumnModel().getColumn(1));
        ListSelectionModel listSelectionModel = this.selectedColumnsTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsTable);
        sp.setPreferredSize(new Dimension(395, 200));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitioningKey.add(sp);
        this.setLabelConstraints(this.getPartitioningKeyLayout(), label, 12, 298);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), sp, 10, 322);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("TablePropertyDialogDB2v80.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.partitioningKey.add(this.bnAdd);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), this.bnAdd, 150, 260);
        this.bnRemove = new JButton(Messages.getString("TablePropertyDialogDB2v80.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.partitioningKey.add(this.bnRemove);
        this.setObjectConstraints(this.getPartitioningKeyLayout(), this.bnRemove, 210, 260);
        TablePropertyDialogDB2v80.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getPartitioningKeyLayout() {
        return (SpringLayout)this.partitioningKey.getLayout();
    }

    protected void initPartitioned() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.Partitioned"));
        this.general.add(label);
        this.cbPartitioned = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPartitioned);
        this.cbPartitioned.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartitioned);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbPartitioned, 380);
    }

    protected void initNumParts() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.NumParts"));
        this.general.add(label);
        this.ifNumParts = new JIntegerField(0, 26);
        this.ifNumParts.setEditable(false);
        this.general.add(this.ifNumParts);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.ifNumParts, 410);
    }

    protected void initHasMaterializedQuery() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.MaterializedQueryL"));
        this.general.add(label);
        this.cbMaterializedQuery = new JComboBox<String>(YES_NO);
        this.setBG(this.cbMaterializedQuery);
        this.cbMaterializedQuery.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbMaterializedQuery);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbMaterializedQuery, 440);
    }

    protected void initTableAccess() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.TableAccess"));
        this.general.add(label);
        this.cbTableAccess = new JComboBox<String>(TableProxyDB2v80.TABLE_ACCESS_STATES);
        this.setBG(this.cbTableAccess);
        this.cbTableAccess.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableAccess);
        this.setLabelConstraints(label, 470);
        this.setObjectConstraints(this.cbTableAccess, 470);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("TablePropertyDialogDB2v80.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(TablePropertyDialogDB2v80.this.getStorageDesign().getTableProxySet().getElements());
                list.remove(TablePropertyDialogDB2v80.this.table);
                new PropertiesPropagationDialog(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.table, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 515);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("TablePropertyDialogDB2v80.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 265, 515);
    }

    public void setUpSortOrderColumn(TableColumn sortColumn) {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("ASC");
        comboBox.addItem("DESC");
        comboBox.setSelectedItem("ASC");
        sortColumn.setCellEditor(new DefaultCellEditor(comboBox));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText(Messages.getString("TablePropertyDialogDB2v80.ClickForComboBox"));
        sortColumn.setCellRenderer(renderer);
        TableCellRenderer headerRenderer = sortColumn.getHeaderRenderer();
        if (headerRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)headerRenderer).setToolTipText(Messages.getString("TablePropertyDialogDB2v80.ClickSortOrder"));
        }
    }

    private void initCatalogStatsView() {
        this.catalogStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.CatalogStats"), this.catalogStats);
        this.initCatalogStats();
    }

    private void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    private void initCatalogStats() {
        this.initCARDF();
        this.initCreatedBy();
        this.initRecLength();
        this.initNPAGES();
        this.initPCTPAGES();
    }

    private void initDesignStats() {
        this.initMaxRows();
        this.initInitialRows();
        this.initAURInsert();
        this.initAURDelete();
        this.initAURNetGrowth();
        this.initAGInsert();
        this.initAGDelete();
        this.initAGData();
        this.initGrowthHorizon();
        this.initGrowthMethod();
        this.initInsertMethod();
        this.initUsePCTFilling();
    }

    protected SpringLayout getCatalogStatsLayout() {
        return (SpringLayout)this.catalogStats.getLayout();
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    private void initCARDF() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.NumberOfRows"));
        this.catalogStats.add(label);
        this.ifCARDF = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifCARDF);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 20);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifCARDF, 20);
    }

    private void initCreatedBy() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.CreatedBy"));
        this.catalogStats.add(label);
        this.tfCreatedBy = new JTextField("", 26);
        this.catalogStats.add(this.tfCreatedBy);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 50);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.tfCreatedBy, 50);
    }

    private void initRecLength() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.RecordLength"));
        this.catalogStats.add(label);
        this.ifRecLength = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifRecLength);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 80);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifRecLength, 80);
    }

    private void initNPAGES() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.NumberOfPages"));
        this.catalogStats.add(label);
        this.ifNPAGES = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNPAGES);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 110);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNPAGES, 110);
    }

    private void initPCTPAGES() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.PCTPages"));
        this.catalogStats.add(label);
        this.ifPCTPAGES = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifPCTPAGES);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 140);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifPCTPAGES, 140);
    }

    private void initMaxRows() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.MaxRows"));
        this.designStats.add(label);
        this.ifMaxRows = new JIntegerField(0, 26);
        this.designStats.add(this.ifMaxRows);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifMaxRows, 20);
    }

    private void initInitialRows() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.InitialRows"));
        this.designStats.add(label);
        this.ifInitialRows = new JIntegerField(0, 26);
        this.designStats.add(this.ifInitialRows);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifInitialRows, 50);
    }

    private void initAURInsert() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AURInsert"));
        this.designStats.add(label);
        this.dfAURInsert = new JDecimalField(0.0, 26);
        this.dfAURInsert.addActionListener(new AURFieldListener());
        this.designStats.add(this.dfAURInsert);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURInsert, 80);
    }

    private void initAURDelete() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AURDelete"));
        this.designStats.add(label);
        this.dfAURDelete = new JDecimalField(0.0, 26);
        this.dfAURDelete.addActionListener(new AURFieldListener());
        this.designStats.add(this.dfAURDelete);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 110);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURDelete, 110);
    }

    private void initAURNetGrowth() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AURNetGrowth"));
        this.designStats.add(label);
        this.dfAURNetGrowth = new JDecimalField(0.0, 26);
        this.dfAURNetGrowth.setEditable(false);
        this.designStats.add(this.dfAURNetGrowth);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 140);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAURNetGrowth, 140);
    }

    private void initAGInsert() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AGInsert"));
        this.designStats.add(label);
        this.dfAGInsert = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGInsert);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 170);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGInsert, 170);
    }

    private void initAGDelete() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AGDelete"));
        this.designStats.add(label);
        this.dfAGDelete = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGDelete);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 200);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGDelete, 200);
    }

    private void initAGData() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.AGData"));
        this.designStats.add(label);
        this.dfAGData = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfAGData);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 230);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfAGData, 230);
    }

    private void initGrowthHorizon() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.GrowthHorizon"));
        this.designStats.add(label);
        this.ifGrowthHorizon = new JIntegerField(0, 26);
        this.designStats.add(this.ifGrowthHorizon);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 260);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifGrowthHorizon, 260);
    }

    private void initGrowthMethod() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.GrowthMethod"));
        this.designStats.add(label);
        this.cbGrowthMethod = new JComboBox<String>(TableProxyDB2.getGrowthMethodChoices());
        this.setBG(this.cbGrowthMethod);
        this.cbGrowthMethod.setPreferredSize(this.tfName.getPreferredSize());
        this.designStats.add(this.cbGrowthMethod);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 290);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.cbGrowthMethod, 290);
    }

    protected void initSpaceCalcsView() {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TablePropertyDialogDB2v80.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextPane();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        this.taSpaceCalcs.setParagraphAttributes(as, true);
        this.spSpaceCalcs = new JScrollPane(this.taSpaceCalcs);
        this.spSpaceCalcs.setPreferredSize(new Dimension(395, 520));
        this.spSpaceCalcs.setBorder(BorderFactory.createEtchedBorder(0));
        this.spaceCalcs.add(this.spSpaceCalcs);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), this.spSpaceCalcs, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private void initInsertMethod() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.InsertMethod"));
        this.designStats.add(label);
        this.cbInsertMethod = new JComboBox<String>(TableProxyDB2.getInsertMethodChoices());
        this.setBG(this.cbInsertMethod);
        this.cbInsertMethod.setPreferredSize(this.tfName.getPreferredSize());
        this.designStats.add(this.cbInsertMethod);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 320);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.cbInsertMethod, 320);
    }

    private String formatText(String text) {
        StringBuffer buffer = new StringBuffer(text);
        buffer.append(' ');
        while (buffer.length() < 30) {
            buffer.append(' ');
        }
        buffer.append("\t");
        return buffer.toString();
    }

    private String formatInt(int number) {
        StringBuffer buffer = new StringBuffer();
        String snumber = Integer.toString(number);
        for (int i = 0; i < 15 - snumber.length(); ++i) {
            buffer.append(' ');
        }
        buffer.append(snumber);
        return buffer.toString();
    }

    protected void initSpaceCalcs() {
        if (this.table != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.InitialPagesUsed"))).append(this.formatInt(this.table.getInitialNumberUsedPages())).append("\n");
            sb.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.MaxPagesUsed"))).append(this.formatInt(this.table.getMaxNumberUsedPages())).append("\n\n");
            if (this.table.getTableSpace() != null) {
                String rem;
                sb.append(Messages.getString("TablePropertyDialogDB2v80.ForTablespace")).append(this.table.getTableSpace().getName());
                sb.append('\n');
                if (this.table.getTableSpace().getStorageTemplate() != null) {
                    sb.append("(" + Messages.getString("TablePropertyDialogDB2v80.StorageTemplate")).append(this.table.getTableSpace().getStorageTemplate().getName());
                    sb.append(")\n");
                }
                sb.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.ProposedPRIQTY"))).append(this.formatInt(this.table.getTableSpace().getProposedPRIQTY())).append("\n");
                sb.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.ProposedSECQTY"))).append(this.formatInt(this.table.getTableSpace().getProposedSECQTY())).append("\n");
                if (this.table.getTableSpace().getStorageTemplate() != null) {
                    sb.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.CurrentPRIQTY"))).append(this.formatInt(this.table.getTableSpace().getStorageTemplate().getSgPriqty())).append("\n");
                    sb.append(this.formatText(Messages.getString("TablePropertyDialogDB2v80.CurrentSECQTY"))).append(this.formatInt(this.table.getTableSpace().getStorageTemplate().getSgSeqty())).append("\n");
                }
                if (!(rem = this.table.getTableSpace().getProposedQTYRemarks()).equals("")) {
                    sb.append(Messages.getString("TablePropertyDialogDB2v80.RemarksOnProposedPRIQTYAndSECQTY")).append(rem);
                }
            }
            this.taSpaceCalcs.setText(sb.toString());
        }
    }

    private void initUsePCTFilling() {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.UsePCTFillingForVarTypes"));
        this.designStats.add(label);
        this.chbUsePCTFilling = new JCheckBox("");
        this.chbUsePCTFilling.addActionListener(new CheckBoxListener());
        this.designStats.add(this.chbUsePCTFilling);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 350);
        SpringLayout.Constraints labelCons = this.getDesignStatsLayout().getConstraints(this.chbUsePCTFilling);
        labelCons.setX(Spring.constant(175));
        labelCons.setY(Spring.constant(350));
        label = new JLabel(Messages.getString("TablePropertyDialogDB2v80.PCTFilling"));
        labelCons = this.getDesignStatsLayout().getConstraints(label);
        labelCons.setX(Spring.constant(220));
        labelCons.setY(Spring.constant(350));
        this.designStats.add(label);
        this.ifPCTFilling = new JIntegerField(0, 3);
        this.setBG(this.ifPCTFilling);
        this.designStats.add(this.ifPCTFilling);
        labelCons = this.getDesignStatsLayout().getConstraints(this.ifPCTFilling);
        labelCons.setX(Spring.constant(290));
        labelCons.setY(Spring.constant(350));
        this.setPCTFillingUse(false);
    }

    protected void setPCTFillingUse(boolean use) {
        this.ifPCTFilling.setEditable(use);
        this.ifPCTFilling.setEnabled(use);
    }

    @Override
    public void initProperties() {
        int ind;
        this.initCaption(this.table.getName());
        this.tfName.setText(this.table.getName());
        this.selectObject(this.cbOwner, this.table.getOwner());
        this.selectObject(this.cbTableSpace, this.table.getTableSpace());
        this.selectObject(this.cbDataBase, this.table.getDataBase());
        this.ifObid.setValue((long)this.table.getObid());
        this.tfEditProc.setText(this.table.getEditProc());
        this.tfValidProc.setText(this.table.getValidProc());
        this.cbAudit.setSelectedItem(this.table.getAudit());
        this.cbDataCapture.setSelectedItem(this.table.getDataCapture() ? TableProxyDB2.getDataCaptureValues()[1] : TableProxyDB2.getDataCaptureValues()[0]);
        this.cbRestrictOnDrop.setSelectedItem(this.table.getDropRestrict() ? YES_NO[0] : YES_NO[1]);
        this.cbCCSID.setSelectedItem(this.table.getCcsid());
        this.tfLabel.setText(this.table.getLabel());
        this.ifNumParts.setValue((long)this.table.getNumParts());
        this.cbPartitioned.setSelectedItem(TablePropertyDialogDB2v80.translateYesNoForDisplay(this.table.getPartitioned()));
        this.cbMaterializedQuery.setSelectedItem(TablePropertyDialogDB2v80.translateYesNoForDisplay(this.table.getMaterializedQuery()));
        this.cbTableAccess.setSelectedItem(this.table.getTableAccess());
        this.ifCARDF.setValue(this.table.getNumberOfRows());
        this.tfCreatedBy.setText(this.table.getCreatedBy());
        this.ifRecLength.setValue((long)this.table.getRecordLength());
        this.ifNPAGES.setValue((long)this.table.getNumberOfPages());
        this.ifPCTPAGES.setValue((long)this.table.getPercentageOfPages());
        this.ifMaxRows.setValue(this.table.getMaxRowNumber());
        this.ifInitialRows.setValue(this.table.getInitialRowNumber());
        this.dfAURInsert.setValue(this.table.getAnnualUpdateRateInsert());
        this.dfAURDelete.setValue(this.table.getAnnualUpdateRateDelete());
        this.dfAURNetGrowth.setValue(this.table.getAnnualUpdateRateNetGrowth());
        this.dfAGInsert.setValue(this.table.getActiveGroupInsert());
        this.dfAGDelete.setValue(this.table.getActiveGroupDelete());
        this.dfAGData.setValue(this.table.getActiveGroupData());
        this.ifGrowthHorizon.setValue((long)this.table.getGrowthHorizon());
        this.cbGrowthMethod.setSelectedItem(this.table.getGrowthMethod());
        this.cbInsertMethod.setSelectedItem(this.table.getInsertMethod());
        this.ifPCTFilling.setValue((long)this.table.getPctFilling());
        this.chbUsePCTFilling.setSelected(this.table.isUsePCTFilling());
        this.setPCTFillingUse(this.table.isUsePCTFilling());
        this.queryArea.setText(this.table.getMqQueryDefinition());
        this.cbMQStatus.setSelectedItem(this.table.getMqStatus());
        this.cbMQMaintenance.setSelectedItem(this.table.getMqMaintenance());
        this.cbMQQueryOptimization.setSelectedItem(this.table.getMqQueryOptimization());
        this.cbMQIdentityColumnAttr.setSelectedItem(this.table.getMqIdentityColumnAttr());
        this.cbMQColumnDefaults.setSelectedItem(this.table.getMqColumnDefaults());
        Table t = (Table)this.table.getObject();
        if (t.isRoot() && t.isBST()) {
            ind = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (ind > -1) {
                this.getPane().setEnabledAt(ind, true);
            }
            this.eList.addAll(this.table.getInstDescriptorCols().getElementsList());
        } else {
            ind = this.getPane().indexOfComponent(this.instDescriptorPanel);
            if (ind > -1) {
                this.getPane().setEnabledAt(ind, false);
            }
        }
        this.allColumnsModel.clear();
        ColumnProxy[] columnSet = this.table.getColumnProxies();
        for (int i = 0; i < columnSet.length; ++i) {
            if (this.table.getPartitioningKeySet().contains(columnSet[i].getObjectID())) {
                this.selectedColumnsModel.addRow(new Object[]{columnSet[i].getName(), this.table.getPartKeySortOrder(columnSet[i].getObjectID())});
                continue;
            }
            this.allColumnsModel.addElement(columnSet[i]);
        }
        this.comment = this.table.getObject().getComment();
        this.commentInRDBMS = this.table.getObject().getCommentInRDBMS();
        if (this.table.isCommentChanged()) {
            this.getCommentsList().insert(this.table.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.table.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.table.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initSpaceCalcs();
        this.partitionsModel.clear();
        Iterator it = this.table.getTablePartitions().iterator();
        while (it.hasNext()) {
            try {
                TablePartitionDB2 part = (TablePartitionDB2)it.next();
                this.partitionsModel.addElement(part);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            String commentText;
            this.table.setName(this.tfName.getText());
            Object selected = this.cbOwner.getSelectedItem();
            if (selected instanceof Owner) {
                this.table.setOwner((Owner)selected);
            } else {
                this.table.setOwner(null);
            }
            selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceDB2v80) {
                this.table.setTableSpace((TableSpaceDB2v80)selected);
            } else {
                this.table.setTableSpace(null);
            }
            this.table.setObid(this.ifObid.getIntValue());
            this.table.setEditProc(this.tfEditProc.getText());
            this.table.setValidProc(this.tfValidProc.getText());
            selected = this.cbAudit.getSelectedItem();
            this.table.setAudit(String.valueOf(selected));
            selected = this.cbDataCapture.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(TableProxyDB2.getDataCaptureValues()[1]);
            this.table.setDataCapture(result);
            selected = this.cbRestrictOnDrop.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.table.setDropRestrict(result);
            this.table.setCcsid(String.valueOf(this.cbCCSID.getSelectedItem()));
            this.table.setLabel(this.tfLabel.getText());
            this.table.setPartitioned(TablePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbPartitioned.getSelectedItem()));
            this.table.setMaterializedQuery(TablePropertyDialogDB2v80.translateYesNoForStorage((String)this.cbMaterializedQuery.getSelectedItem()));
            this.table.setTableAccess((String)this.cbTableAccess.getSelectedItem());
            this.table.setNumberOfRows(this.ifCARDF.getIntValue());
            this.table.setCreatedBy(this.tfCreatedBy.getText());
            this.table.setRecordLength(this.ifRecLength.getIntValue());
            this.table.setNumberOfPages(this.ifNPAGES.getIntValue());
            this.table.setPercentageOfPages(this.ifPCTPAGES.getIntValue());
            this.table.setMaxRowNumber(this.ifMaxRows.getIntValue());
            this.table.setInitialRowNumber(this.ifInitialRows.getIntValue());
            this.table.setAnnualUpdateRateInsert(this.dfAURInsert.getFloatValue());
            this.table.setAnnualUpdateRateDelete(this.dfAURDelete.getFloatValue());
            this.table.setActiveGroupInsert(this.dfAGInsert.getFloatValue());
            this.table.setActiveGroupDelete(this.dfAGDelete.getFloatValue());
            this.table.setActiveGroupData(this.dfAGData.getFloatValue());
            this.table.setGrowthHorizon(this.ifGrowthHorizon.getIntValue());
            this.table.setGrowthMethod((String)this.cbGrowthMethod.getSelectedItem());
            this.table.setInsertMethod((String)this.cbInsertMethod.getSelectedItem());
            this.table.setPctFilling(this.ifPCTFilling.getIntValue());
            this.table.setUsePCTFilling(this.chbUsePCTFilling.isSelected());
            this.table.setMqQueryDefinition(this.queryArea.getText());
            this.table.setMqStatus((String)this.cbMQStatus.getSelectedItem());
            this.table.setMqMaintenance((String)this.cbMQMaintenance.getSelectedItem());
            this.table.setMqQueryOptimization((String)this.cbMQQueryOptimization.getSelectedItem());
            this.table.setMqIdentityColumnAttr((String)this.cbMQIdentityColumnAttr.getSelectedItem());
            this.table.setMqColumnDefaults((String)this.cbMQColumnDefaults.getSelectedItem());
            Object[] partKeySet = this.selectedColumnsModel.getRows();
            this.table.clear();
            String name = null;
            String order = null;
            for (int i = 0; i < partKeySet.length; ++i) {
                Object partKey = partKeySet[i];
                if (!(partKey instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(partKey.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                order = st.nextToken().trim();
                ColumnProxy column = this.table.getColumnProxyByName(name);
                if (column == null) continue;
                this.table.setPartitioningKey(column.getObjectID());
                this.table.setPartitioningKey(order);
            }
            if (((String)this.cbPartitioned.getSelectedItem()).equalsIgnoreCase(YES)) {
                int size = this.table.getTablePartitions().size();
                for (int i = 0; i < size; ++i) {
                    this.table.getTablePartitions().justRemove(this.table.getTablePartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof TablePartitionDB2)) continue;
                    TablePartitionDB2 p = (TablePartitionDB2)this.partitionsModel.get(i);
                    p.addObjectListener(this.table);
                    p.setPartNumber(i + 1);
                    p.setParent(this.table.getTablePartitions());
                    this.table.getTablePartitions().add(p);
                }
            }
            if (StringUtilities.isNotEmpty(commentText = this.getCommentsList().getText()) && !this.comment.equalsIgnoreCase(commentText)) {
                this.table.setComment(commentText);
                this.table.setCommentChanged(true);
            } else {
                this.table.setComment("");
                this.table.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.table.setCommentInRDBMS(commentInRDBMSText);
                this.table.setCommentInRDBMSChanged(true);
            } else {
                this.table.setCommentInRDBMS("");
                this.table.setCommentInRDBMSChanged(false);
            }
            this.initSpaceCalcs();
            Object[] obj = this.table.getInstDescriptorCols().toArray();
            for (int i = obj.length - 1; i >= 0; --i) {
                InstanceDescriptorColumnDB2 element = (InstanceDescriptorColumnDB2)obj[i];
                if (this.eList.contains(element)) continue;
                element.remove();
            }
            Object[] eSet = this.eList.toArray();
            for (int i = 0; i < eSet.length; ++i) {
                Object ob = eSet[i];
                if (!(ob instanceof InstanceDescriptorColumnDB2)) continue;
                if (!this.table.getInstDescriptorCols().contains((InstanceDescriptorColumnDB2)ob)) {
                    this.getStorageDesign().getInstanceDescriptorColumnSet().addInstanceDescriptorColumn((InstanceDescriptorColumnDB2)ob);
                    ((InstanceDescriptorColumnDB2)ob).setTable(this.table);
                    continue;
                }
                this.table.getInstDescriptorCols().moveElementToIndex((InstanceDescriptorColumnDB2)ob, i);
            }
        }
    }

    private class ComboListener
    implements ActionListener {
        private ComboListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            Object selected = cb.getSelectedItem();
            if (selected != null && selected instanceof TableSpaceDB2) {
                TableSpaceDB2 ts = (TableSpaceDB2)selected;
                TablePropertyDialogDB2v80.this.cbDataBase.setSelectedItem(ts.getDataBase());
            }
        }
    }

    public class ElementModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TablePropertyDialogDB2v80.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("TablePropertyDialogDB2v80.Name");
            }
            if (column == 1) {
                return Messages.getString("TablePropertyDialogDB2v80.Datatype");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InstanceDescriptorColumnDB2 element = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(row);
            if (col == 0) {
                return element.getName();
            }
            if (col == 1) {
                return element.getDataType();
            }
            return new Integer(row * col);
        }
    }

    private class PropertiesAction
    implements ActionListener {
        private PropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstanceDescriptorColumnDB2 element;
            int row = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (row != -1 && TablePropertyDialogDB2v80.this.eList.size() > 0 && row < TablePropertyDialogDB2v80.this.eList.size() && !(element = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(row)).isDialogVisible()) {
                InstanceDescriptorColumnPropertyDialogDB2 dialog = new InstanceDescriptorColumnPropertyDialogDB2(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.table.getStorageDesign(), element);
                dialog.initProperties();
                dialog.show();
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InstanceDescriptorColumnDB2 element = new InstanceDescriptorColumnDB2();
            element.setName(TablePropertyDialogDB2v80.this.generateName());
            element.setDesign(TablePropertyDialogDB2v80.this.table.getDesign());
            TablePropertyDialogDB2v80.this.eList.add(element);
            TablePropertyDialogDB2v80.this.etable.updateUI();
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (objectNumber != -1 && TablePropertyDialogDB2v80.this.eList.size() > 0 && objectNumber < TablePropertyDialogDB2v80.this.eList.size()) {
                InstanceDescriptorColumnDB2 element = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(objectNumber);
                TablePropertyDialogDB2v80.this.eList.remove(element);
                TablePropertyDialogDB2v80.this.etable.updateUI();
            }
        }
    }

    private class MoveUpColAction
    implements ActionListener {
        private MoveUpColAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (objectNumber > -1 && objectNumber < TablePropertyDialogDB2v80.this.eList.size()) {
                InstanceDescriptorColumnDB2 element = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(objectNumber);
                TablePropertyDialogDB2v80.this.moveElementToIndex(element, objectNumber - 1);
                TablePropertyDialogDB2v80.this.etable.changeSelection(objectNumber - 1, 0, false, false);
                TablePropertyDialogDB2v80.this.etable.updateUI();
            }
        }
    }

    private class MoveDownColAction
    implements ActionListener {
        private MoveDownColAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = TablePropertyDialogDB2v80.this.etable.getSelectedRow();
            if (objectNumber > -1 && objectNumber < TablePropertyDialogDB2v80.this.eList.size()) {
                InstanceDescriptorColumnDB2 element = (InstanceDescriptorColumnDB2)TablePropertyDialogDB2v80.this.eList.get(objectNumber);
                TablePropertyDialogDB2v80.this.moveElementToIndex(element, objectNumber + 1);
                TablePropertyDialogDB2v80.this.etable.changeSelection(objectNumber + 1, 0, false, false);
                TablePropertyDialogDB2v80.this.etable.updateUI();
            }
        }
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePartitionDB2 selected = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsList.getSelectedValue();
            if (selected != null && !selected.isDialogVisible()) {
                TablePartitionPropertyDialogDB2v80 dialog = new TablePartitionPropertyDialogDB2v80(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = TablePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < objectNumber.length; ++i) {
                if (objectNumber[i] == -1 || objectNumber[i] <= 0) continue;
                TablePartitionDB2 part = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i]);
                TablePartitionDB2 old = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i] - 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(part, objectNumber[i] - 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            TablePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TablePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = TablePropertyDialogDB2v80.this.partitionsList.getSelectedIndices();
            for (int i = objectNumber.length - 1; i >= 0; --i) {
                if (objectNumber[i] == -1 || TablePropertyDialogDB2v80.this.partitionsModel.size() - 1 <= objectNumber[i]) continue;
                TablePartitionDB2 part = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i]);
                TablePartitionDB2 old = (TablePartitionDB2)TablePropertyDialogDB2v80.this.partitionsModel.get(objectNumber[i] + 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(part, objectNumber[i] + 1);
                TablePropertyDialogDB2v80.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            TablePropertyDialogDB2v80.this.partitionsList.clearSelection();
            TablePropertyDialogDB2v80.this.partitionsList.updateUI();
        }
    }

    class AllListColumnsCellRenderer
    extends JLabel
    implements ListCellRenderer {
        AllListColumnsCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ColumnProxy col = (ColumnProxy)value;
            this.setText(" " + col.getName());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(TablePropertyDialogDB2v80.this.selectedColumnsTable.getSelectionBackground());
            } else {
                this.setBackground(TablePropertyDialogDB2v80.this.selectedColumnsTable.getBackground());
            }
            return this;
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogDB2v80.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogDB2v80.this.allColumnsList.getSelectedIndex() == -1) {
                    TablePropertyDialogDB2v80.this.bnAdd.setEnabled(false);
                } else {
                    TablePropertyDialogDB2v80.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    class IndexTableModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("TablePropertyDialogDB2v80.ColumnName"), Messages.getString("TablePropertyDialogDB2v80.SortOrder")};

        IndexTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return TablePropertyDialogDB2v80.this.isEditable();
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = TablePropertyDialogDB2v80.this.selectedColumnsModel.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getRows() {
            int rowCount = TablePropertyDialogDB2v80.this.selectedColumnsModel.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = this.getValueAt(i, 1) == null || ((String)this.getValueAt(i, 1)).equalsIgnoreCase("") ? (String)this.getValueAt(i, 0) + ",ASC" : (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TablePropertyDialogDB2v80.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TablePropertyDialogDB2v80.this.selectedColumnsTable.getSelectedRowCount() == -1) {
                    TablePropertyDialogDB2v80.this.bnRemove.setEnabled(false);
                } else {
                    TablePropertyDialogDB2v80.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TablePropertyDialogDB2v80.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = TablePropertyDialogDB2v80.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    ColumnProxy ob = (ColumnProxy)selectedObjects[i];
                    TablePropertyDialogDB2v80.this.allColumnsModel.removeElement(ob);
                    TablePropertyDialogDB2v80.this.selectedColumnsModel.addRow(new String[]{ob.getName(), ""});
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogDB2v80.this.selectedColumnsModel.getRowCount() > 0) {
                int[] selectedObjectsIndex = TablePropertyDialogDB2v80.this.selectedColumnsTable.getSelectedRows();
                for (int i = 0; i < selectedObjectsIndex.length; ++i) {
                    String colName = (String)TablePropertyDialogDB2v80.this.selectedColumnsModel.getValueAt(selectedObjectsIndex[i], 0);
                    TablePropertyDialogDB2v80.this.allColumnsModel.addElement(TablePropertyDialogDB2v80.this.table.getColumn(colName));
                    TablePropertyDialogDB2v80.this.selectedColumnsModel.removeRow(selectedObjectsIndex[i]);
                }
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TablePropertyDialogDB2v80.this.dialog == null) {
                TablePropertyDialogDB2v80.this.dialog = new PermissionsPropertyDialogDB2(TablePropertyDialogDB2v80.this.getAppView(), TablePropertyDialogDB2v80.this.getStorageDesign(), TablePropertyDialogDB2v80.this.table);
            }
            TablePropertyDialogDB2v80.this.dialog.show();
        }
    }

    private class AURFieldListener
    implements ActionListener {
        private AURFieldListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogDB2v80.this.dfAURNetGrowth.setValue(TablePropertyDialogDB2v80.this.dfAURInsert.getFloatValue() - TablePropertyDialogDB2v80.this.dfAURDelete.getFloatValue());
        }
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogDB2v80.this.setPCTFillingUse(TablePropertyDialogDB2v80.this.chbUsePCTFilling.isSelected());
        }
    }
}

