/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.PermissionsDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.storage.db2.ColumnsPermissionsDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class PermissionsPropertyDialogDB2
extends JDialog
implements AbstractEditorConstants {
    private static String EMPTY_VALUE = "";
    private static String CHECKED = "v";
    private static String CHECKED_WITH_GRANT_OPTION = "v->";
    protected static final String EDIT = Messages.getString("PermissionsPropertyDialogDB2.Edit");
    private static String COLUMN_CHECKED = Messages.getString("PermissionsPropertyDialogDB2.C");
    private StorageObject storageObject;
    private ArrayList usersSet;
    private ApplicationView appView;
    private AbstractStorageDesignDB2 storageDesign;
    private JButton bnCancel;
    private JPanel jpanel;
    private ColumnsPermissionsDialogDB2 dialog;
    private Action escape = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogDB2.this.bnCancel.doClick();
        }
    };
    private UsersTable usersTable;

    public PermissionsPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view.getFrame());
        this.appView = view;
        this.storageDesign = (AbstractStorageDesignDB2)storageDesign;
        this.storageObject = object;
        this.setResizable(false);
        this.storageObject.setDialogVisible(true, this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                PermissionsPropertyDialogDB2.this.storageObject.setDialogVisible(false, null);
            }
        });
        this.jpanel = new JPanel(new BorderLayout());
        this.setTitle(this.getCaption());
        this.setDefaultCloseOperation(2);
        JPanel bottomPanel = new JPanel();
        if (this.isEditable()) {
            if (this.storageObject instanceof TableProxyDB2) {
                JButton bnColumns = new JButton(Messages.getString("PermissionsPropertyDialogDB2.Columns"));
                bnColumns.addActionListener(new ColumnsPermissionsListener(this));
                bnColumns.setCursor(Cursor.getPredefinedCursor(12));
                bnColumns.setMnemonic(79);
                bottomPanel.add((Component)bnColumns, "Before");
            }
            JButton bnOK = new JButton(Messages.getString("PermissionsPropertyDialogDB2.OK"));
            bnOK.addActionListener(new OKAction());
            bnOK.setCursor(Cursor.getPredefinedCursor(12));
            bnOK.setMnemonic(79);
            bottomPanel.add(bnOK);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton(Messages.getString("PermissionsPropertyDialogDB2.Apply"));
            bnApply.addActionListener(new ApplyAction());
            bnApply.setCursor(Cursor.getPredefinedCursor(12));
            bnApply.setMnemonic(65);
            bottomPanel.add(bnApply);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        }
        this.bnCancel = new JButton(this.isEditable() ? Messages.getString("PermissionsPropertyDialogDB2.Cancel") : Messages.getString("PermissionsPropertyDialogDB2.Close"));
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escape);
        bottomPanel.add(this.bnCancel);
        this.jpanel.add((Component)bottomPanel, "South");
        this.getContentPane().add(this.jpanel);
        this.initUsersTable();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
        this.setModal(true);
    }

    protected boolean isEditable() {
        return !ApplicationView.IS_VIEWER && !ApplicationView.LOGICAL_MODEL_ONLY;
    }

    public void initProperties() {
        for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
            Owner user = (Owner)this.usersTable.getValueAt(i, 0);
            for (int k = 0; k < this.usersTable.getColumnCount(); ++k) {
                if (!(this.usersTable.getValueAt(i, k) instanceof JButton)) continue;
                JButton button = (JButton)this.usersTable.getValueAt(i, k);
                if (this.getPermission(user, this.storageObject) != null) {
                    if (this.getPermission(user, this.storageObject).getPrivileges().indexOf(this.usersTable.getColumnName(k)) > -1) {
                        button.setText(CHECKED);
                        button.updateUI();
                        continue;
                    }
                    if (this.getPermission(user, this.storageObject).getPrivilegesWithGrantOption().indexOf(this.usersTable.getColumnName(k)) > -1) {
                        button.setText(CHECKED_WITH_GRANT_OPTION);
                        button.updateUI();
                        continue;
                    }
                    if (this.getPermission(user, this.storageObject).hasColPrivilege(this.usersTable.getColumnName(k))) {
                        button.setText(COLUMN_CHECKED);
                        button.updateUI();
                        continue;
                    }
                    button.setText(EMPTY_VALUE);
                    button.updateUI();
                    continue;
                }
                button.setText(EMPTY_VALUE);
                button.updateUI();
            }
        }
    }

    private void initUsersTable() {
        Iterator it = this.storageDesign.getOwnerSet().iterator();
        this.usersSet = new ArrayList();
        while (it.hasNext()) {
            Owner owner = (Owner)it.next();
            if (owner.getName().equalsIgnoreCase("[Implicit]")) continue;
            this.usersSet.add(owner);
        }
        int colNum = 0;
        if (this.storageObject instanceof TableProxyDB2) {
            if (((TableProxyDB2)this.storageObject).getOwner() != null) {
                this.usersSet.remove(((TableProxyDB2)this.storageObject).getOwner());
            }
            if (!this.usersSet.contains(this.storageDesign.getPublicAtAllLocations())) {
                this.usersSet.add(this.storageDesign.getPublicAtAllLocations());
            }
            colNum = PermissionsDB2.getTablePrivilegesValues().length;
        } else if (this.storageObject instanceof TableViewProxyDB2) {
            if (((TableViewProxyDB2)this.storageObject).getOwner() != null) {
                this.usersSet.remove(((TableViewProxyDB2)this.storageObject).getOwner());
            }
            if (!this.usersSet.contains(this.storageDesign.getPublicAtAllLocations())) {
                this.usersSet.add(this.storageDesign.getPublicAtAllLocations());
            }
            colNum = PermissionsDB2.getViewPrivilegesValues().length;
        } else if (this.storageObject instanceof AUXTableDB2) {
            if (((AUXTableDB2)this.storageObject).getOwner() != null) {
                this.usersSet.remove(((AUXTableDB2)this.storageObject).getOwner());
            }
            colNum = PermissionsDB2.getAuxTablePrivilegesValues().length;
        }
        this.usersTable = new UsersTable();
        this.usersTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.usersTable);
        scrollpane.setPreferredSize(new Dimension(90 * colNum + 50, 280));
        scrollpane.setHorizontalScrollBar(new JScrollBar());
        scrollpane.setHorizontalScrollBarPolicy(30);
        this.jpanel.add(scrollpane);
        this.usersTable.updateUI();
        UsersModel tableModel = (UsersModel)this.usersTable.getModel();
        for (int i = 0; i < this.usersSet.size(); ++i) {
            Owner user = (Owner)this.usersSet.get(i);
            String[] list = this.storageObject instanceof TableProxyDB2 ? (String[])PermissionsDB2.getTablePermissionsValues().toArray() : (this.storageObject instanceof TableViewProxyDB2 ? (String[])PermissionsDB2.getViewPermissionsValues().toArray() : (String[])PermissionsDB2.getAuxTablePermissionsValues().toArray());
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(user);
            for (int j = 0; j < list.length; ++j) {
                JButton button = new JButton();
                vect.addElement(button);
            }
            Object[] objects = vect.toArray();
            tableModel.addRow(objects);
        }
    }

    protected void setProperties() {
        for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
            Owner user = (Owner)this.usersTable.getValueAt(i, 0);
            PermissionsDB2 perm = this.getPermission(user, this.storageObject);
            if (this.hasSelectedUserPrivileges(i)) {
                if (perm == null) {
                    perm = this.storageDesign.getPermissionsSet().createPermissions();
                    perm.setUser(user);
                    if (this.storageObject instanceof TableProxyDB2) {
                        perm.setTable((TableProxyDB2)this.storageObject);
                    } else if (this.storageObject instanceof TableViewProxyDB2) {
                        perm.setView((TableViewProxyDB2)this.storageObject);
                    } else if (this.storageObject instanceof AUXTableDB2) {
                        perm.setAuxTable((AUXTableDB2)this.storageObject);
                    }
                }
                perm.clear();
                for (int k = 0; k < this.usersTable.getColumnCount(); ++k) {
                    if (!(this.usersTable.getValueAt(i, k) instanceof JButton)) continue;
                    JButton button = (JButton)this.usersTable.getValueAt(i, k);
                    if (button.getText().equals(CHECKED)) {
                        perm.setPrivileges(this.usersTable.getColumnName(k));
                        continue;
                    }
                    if (!button.getText().equals(CHECKED_WITH_GRANT_OPTION)) continue;
                    perm.setPrivilegesWithGrantOption(this.usersTable.getColumnName(k));
                }
                continue;
            }
            if (perm == null) continue;
            this.storageDesign.getPermissionsSet().remove(perm);
        }
    }

    public String getCaption() {
        return Messages.getString("PermissionsPropertyDialogDB2.Permissions");
    }

    public ArrayList getUsersSet() {
        return this.usersSet;
    }

    private PermissionsDB2 getPermission(StorageObject user, StorageObject proxy) {
        for (PermissionsDB2 perm : this.storageDesign.getPermissionsSet()) {
            if (perm.getUser() != user || perm.getTable() != proxy && perm.getView() != proxy && perm.getAuxTable() != proxy) continue;
            return perm;
        }
        return null;
    }

    private boolean hasSelectedUserPrivileges(int row) {
        for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
            if (!(this.usersTable.getValueAt(row, k) instanceof JButton)) continue;
            JButton button = (JButton)this.usersTable.getValueAt(row, k);
            if (button.getText().equals(CHECKED)) {
                return true;
            }
            if (button.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                return true;
            }
            if (!button.getText().equals(COLUMN_CHECKED)) continue;
            return true;
        }
        return false;
    }

    public void setColumnPermissions(StorageObject user, String priv) {
        int row = 0;
        if (user instanceof Owner) {
            for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                if (this.usersTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv)) continue;
                JButton button = (JButton)this.usersTable.getValueAt(row, k);
                button.setText(COLUMN_CHECKED);
                this.usersTable.updateUI();
            }
        }
    }

    public void clearColumnPermissions(StorageObject user, String priv) {
        int row = 0;
        if (user instanceof Owner) {
            for (int i = 0; i < this.usersTable.getRowCount(); ++i) {
                if (this.usersTable.getValueAt(i, 0) != user) continue;
                row = i;
                break;
            }
            for (int k = 1; k < this.usersTable.getColumnCount(); ++k) {
                JButton button;
                if (!((UsersModel)this.usersTable.getModel()).getColumnName(k).equalsIgnoreCase(priv) || !(button = (JButton)this.usersTable.getValueAt(row, k)).getText().equalsIgnoreCase(COLUMN_CHECKED)) continue;
                button.setText(EMPTY_VALUE);
            }
        }
    }

    private class ColumnsPermissionsListener
    implements ActionListener {
        PermissionsPropertyDialogDB2 permDialog;

        public ColumnsPermissionsListener(PermissionsPropertyDialogDB2 permDialog) {
            this.permDialog = permDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StorageObject selectedUser = null;
            if (PermissionsPropertyDialogDB2.this.usersTable.getSelectedRow() > -1) {
                selectedUser = (StorageObject)PermissionsPropertyDialogDB2.this.usersTable.getValueAt(PermissionsPropertyDialogDB2.this.usersTable.getSelectedRow(), 0);
            }
            if (selectedUser != null && (PermissionsPropertyDialogDB2.this.dialog == null || PermissionsPropertyDialogDB2.this.dialog.getUser() != selectedUser)) {
                PermissionsPropertyDialogDB2.this.dialog = new ColumnsPermissionsDialogDB2(PermissionsPropertyDialogDB2.this.appView, PermissionsPropertyDialogDB2.this.storageDesign, PermissionsPropertyDialogDB2.this.storageObject, selectedUser, this.permDialog);
            }
            if (PermissionsPropertyDialogDB2.this.dialog != null) {
                PermissionsPropertyDialogDB2.this.dialog.show();
            }
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogDB2.this.setProperties();
            PermissionsPropertyDialogDB2.this.storageObject.setDirty(true);
            PermissionsPropertyDialogDB2.this.dispose();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogDB2.this.setProperties();
            PermissionsPropertyDialogDB2.this.storageObject.setDirty(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionsPropertyDialogDB2.this.dispose();
        }
    }

    class UsersTable
    extends JTable {
        UsersModel dataModel;

        public UsersTable() {
            this.dataModel = new UsersModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return new LabelTableCellRenderer();
            }
            return new ButtonTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ButtonTableCellEditor();
        }
    }

    public class UsersModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            Object[] perms = PermissionsPropertyDialogDB2.this.storageObject instanceof TableProxyDB2 ? PermissionsDB2.getTablePermissionsValues().toArray() : (PermissionsPropertyDialogDB2.this.storageObject instanceof TableViewProxyDB2 ? PermissionsDB2.getViewPermissionsValues().toArray() : PermissionsDB2.getAuxTablePermissionsValues().toArray());
            return perms.length + 1;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            Object[] perms = PermissionsPropertyDialogDB2.this.storageObject instanceof TableProxyDB2 ? PermissionsDB2.getTablePermissionsValues().toArray() : (PermissionsPropertyDialogDB2.this.storageObject instanceof TableViewProxyDB2 ? PermissionsDB2.getViewPermissionsValues().toArray() : PermissionsDB2.getAuxTablePermissionsValues().toArray());
            if (column == 0) {
                return Messages.getString("PermissionsPropertyDialogDB2.User");
            }
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (column != i) continue;
                return perms[i - 1].toString();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!PermissionsPropertyDialogDB2.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ButtonTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton button;

        ButtonTableCellEditor() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                JButton currentButton = (JButton)e.getSource();
                if (currentButton.getText() == null) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(CHECKED)) {
                    currentButton.setText(CHECKED_WITH_GRANT_OPTION);
                } else if (currentButton.getText().equals(CHECKED_WITH_GRANT_OPTION)) {
                    currentButton.setText(EMPTY_VALUE);
                } else if (currentButton.getText().equals(EMPTY_VALUE)) {
                    currentButton.setText(CHECKED);
                }
            } else {
                this.button.setText(this.button.getText().toString());
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.button = (JButton)value;
            if (this.button != null) {
                this.button.setOpaque(true);
                this.button.setBackground(table.getBackground());
                this.button.setActionCommand(EDIT);
                this.button.addActionListener(this);
                this.button.setBorderPainted(true);
                return this.button;
            }
            return null;
        }
    }

    class ButtonTableCellRenderer
    extends JButton
    implements TableCellRenderer {
        ButtonTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setText((String)(value == null ? "" : "  " + ((JButton)value).getText()));
            return this;
        }
    }

    class LabelTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        LabelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.setHorizontalAlignment(2);
            this.setText((String)(value == null ? "" : "  " + value.toString()));
            return this;
        }
    }
}

