/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AliasDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StoredProcedureDB2;
import oracle.dbtools.crest.model.design.storage.db2.SynonymDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableViewProxyDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AliasPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.StoredProcedurePropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.SynonymPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TablePropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableViewPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.UserPermissionsDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class OwnerPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private Owner owner;
    private JPanel tables;
    private DefaultListModel tablesListModel;
    private JList tablesList;
    private JScrollPane spTables;
    private JPanel views;
    private DefaultListModel viewsListModel;
    private JList viewsList;
    private JScrollPane spViews;
    private JPanel synonyms;
    private DefaultListModel synonymsListModel;
    private JList synonymsList;
    private JScrollPane spSynonyms;
    private JPanel aliases;
    private DefaultListModel aliasesListModel;
    private JList aliasesList;
    private JScrollPane spAliases;
    private JPanel indexes;
    private DefaultListModel indexesListModel;
    private JList indexesList;
    private JScrollPane spIndexes;
    private JPanel storedProcedures;
    private DefaultListModel storedProceduresListModel;
    private JList storedProceduresList;
    private JScrollPane spStoredProcedures;
    private JPanel privs;
    private JComboBox cbGrantOption;
    private DefaultListModel allPrivsModel;
    private DefaultListModel selectedPrivsModel;
    private JList allPrivsList;
    private JList selectedPrivsList;
    private JButton bnPrivsAdd;
    private JButton bnPrivsRemove;
    private JButton bnPermissions;
    private UserPermissionsDialogDB2 dialog;
    private JComboBox cbSchemaObject;

    public OwnerPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.owner = (Owner)object;
        this.setHeight(250);
        this.initCommentsView(180);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("OwnerPropertyDialogDB2.OwnerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initSchemaObject();
        this.initPermissionsButton();
    }

    private void initSchemaObject() {
        JLabel lbImplementsSchema = new JLabel(Messages.getString("OwnerPropertyDialogDB2.ImplementsSchema"));
        this.general.add(lbImplementsSchema);
        this.cbSchemaObject = new JComboBox();
        this.setBG(this.cbSchemaObject);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getPhysicalDesign().getSchemaObjectSet().toArray(), this.cbSchemaObject);
        }
        this.cbSchemaObject.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSchemaObject);
        this.setLabelConstraints(lbImplementsSchema, 50);
        this.setObjectConstraints(this.cbSchemaObject, 50);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("OwnerPropertyDialogDB2.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 170);
    }

    @Override
    protected void addTabs() {
        this.initPrivilegesView();
        this.initTablesView();
        this.initStoredProceduresView();
        this.initViewsView();
        this.initSynonymsView();
        this.initAliasesView();
        this.initIndexesView();
    }

    private void initPrivilegesView() {
        this.privs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogDB2.SystemPrivileges"), this.privs);
        this.initPrivileges();
    }

    private void initPrivileges() {
        this.initAllPrivsList();
        this.initSelectedPrivsList();
        this.initPrivsButtons();
        this.initGrantOption();
    }

    protected SpringLayout getPrivsLayout() {
        return (SpringLayout)this.privs.getLayout();
    }

    private void initGrantOption() {
        JLabel label = new JLabel(Messages.getString("OwnerPropertyDialogDB2.GrantOption"));
        this.privs.add(label);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.privs.add(this.cbGrantOption);
        this.setLabelConstraints(this.getPrivsLayout(), label, 170);
        this.setObjectConstraints(this.getPrivsLayout(), this.cbGrantOption, 170);
    }

    private void initAllPrivsList() {
        JLabel label = new JLabel(Messages.getString("OwnerPropertyDialogDB2.AllPrivileges"));
        this.privs.add(label);
        this.allPrivsModel = new DefaultListModel();
        this.allPrivsList = new JList(this.allPrivsModel);
        ListSelectionModel listSelectionModel = this.allPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allPrivsList);
        sp.setPreferredSize(new Dimension(144, 120));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(sp);
        this.setLabelConstraints(this.getPrivsLayout(), label, 12, 14);
        this.setObjectConstraints(this.getPrivsLayout(), sp, 10, 32);
    }

    private void initSelectedPrivsList() {
        JLabel label = new JLabel(Messages.getString("OwnerPropertyDialogDB2.SelectedPrivileges"));
        this.privs.add(label);
        this.selectedPrivsModel = new DefaultListModel();
        this.selectedPrivsList = new JList(this.selectedPrivsModel);
        ListSelectionModel listSelectionModel = this.selectedPrivsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedPrivsList);
        sp.setPreferredSize(new Dimension(145, 120));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.privs.add(sp);
        this.setLabelConstraints(this.getPrivsLayout(), label, 292, 14);
        this.setObjectConstraints(this.getPrivsLayout(), sp, 290, 32);
    }

    private void initPrivsButtons() {
        this.bnPrivsAdd = new JButton(Messages.getString("OwnerPropertyDialogDB2.Add"));
        this.bnPrivsAdd.addActionListener(new AddPrivsActionListener());
        this.bnPrivsAdd.setEnabled(false);
        this.privs.add(this.bnPrivsAdd);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsAdd, 175, 65);
        this.bnPrivsRemove = new JButton(Messages.getString("OwnerPropertyDialogDB2.Remove"));
        this.bnPrivsRemove.setEnabled(false);
        this.bnPrivsRemove.addActionListener(new RemovePrivsActionListener());
        this.privs.add(this.bnPrivsRemove);
        this.setObjectConstraints(this.getPrivsLayout(), this.bnPrivsRemove, 175, 95);
        OwnerPropertyDialogDB2.equalizeButtonSizes(this.bnPrivsAdd, this.bnPrivsRemove);
    }

    private void initStoredProceduresView() {
        this.storedProcedures = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogDB2.StoredProcedures"), this.storedProcedures);
        this.initStoredProcedures();
    }

    private void initStoredProcedures() {
        this.storedProceduresListModel = new DefaultListModel();
        this.storedProceduresList = new JList(this.storedProceduresListModel);
        this.storedProceduresList.addMouseListener(new listMouseListenerStoredProcedure());
        this.spStoredProcedures = new JScrollPane(this.storedProceduresList);
        this.spStoredProcedures.setPreferredSize(new Dimension(395, 180));
        this.spStoredProcedures.setBorder(BorderFactory.createEtchedBorder(0));
        this.storedProcedures.add(this.spStoredProcedures);
        this.setObjectConstraints(this.getStoredProceduresLayout(), this.spStoredProcedures, 10, 12);
    }

    private SpringLayout getStoredProceduresLayout() {
        return (SpringLayout)this.storedProcedures.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogDB2.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexesListModel = new DefaultListModel();
        this.indexesList = new JList(this.indexesListModel);
        this.indexesList.addMouseListener(new listMouseListenerIndex());
        this.spIndexes = new JScrollPane(this.indexesList);
        this.spIndexes.setPreferredSize(new Dimension(395, 180));
        this.spIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(this.spIndexes);
        this.setObjectConstraints(this.getIndexesLayout(), this.spIndexes, 10, 12);
    }

    private SpringLayout getIndexesLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initAliasesView() {
        this.aliases = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogDB2.Aliases"), this.aliases);
        this.initAliases();
    }

    private void initAliases() {
        this.aliasesListModel = new DefaultListModel();
        this.aliasesList = new JList(this.aliasesListModel);
        this.aliasesList.addMouseListener(new listMouseListenerAlias());
        this.spAliases = new JScrollPane(this.aliasesList);
        this.spAliases.setPreferredSize(new Dimension(395, 180));
        this.spAliases.setBorder(BorderFactory.createEtchedBorder(0));
        this.aliases.add(this.spAliases);
        this.setObjectConstraints(this.getAliasesLayout(), this.spAliases, 10, 12);
    }

    private SpringLayout getAliasesLayout() {
        return (SpringLayout)this.aliases.getLayout();
    }

    private void initSynonymsView() {
        this.synonyms = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogDB2.Synonyms"), this.synonyms);
        this.initSynonyms();
    }

    private void initSynonyms() {
        this.synonymsListModel = new DefaultListModel();
        this.synonymsList = new JList(this.synonymsListModel);
        this.synonymsList.addMouseListener(new listMouseListenerSynonym());
        this.spSynonyms = new JScrollPane(this.synonymsList);
        this.spSynonyms.setPreferredSize(new Dimension(395, 180));
        this.spSynonyms.setBorder(BorderFactory.createEtchedBorder(0));
        this.synonyms.add(this.spSynonyms);
        this.setObjectConstraints(this.getSynonymsLayout(), this.spSynonyms, 10, 12);
    }

    private SpringLayout getSynonymsLayout() {
        return (SpringLayout)this.synonyms.getLayout();
    }

    private void initViewsView() {
        this.views = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogDB2.Views"), this.views);
        this.initViews();
    }

    private void initViews() {
        this.viewsListModel = new DefaultListModel();
        this.viewsList = new JList(this.viewsListModel);
        this.viewsList.addMouseListener(new listMouseListenerView());
        this.spViews = new JScrollPane(this.viewsList);
        this.spViews.setPreferredSize(new Dimension(395, 180));
        this.spViews.setBorder(BorderFactory.createEtchedBorder(0));
        this.views.add(this.spViews);
        this.setObjectConstraints(this.getViewsLayout(), this.spViews, 10, 12);
    }

    private SpringLayout getViewsLayout() {
        return (SpringLayout)this.views.getLayout();
    }

    private void initTablesView() {
        this.tables = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("OwnerPropertyDialogDB2.Tables"), this.tables);
        this.initTables();
    }

    private void initTables() {
        this.tablesListModel = new DefaultListModel();
        this.tablesList = new JList(this.tablesListModel);
        this.tablesList.addMouseListener(new listMouseListenerTable());
        this.spTables = new JScrollPane(this.tablesList);
        this.spTables.setPreferredSize(new Dimension(395, 180));
        this.spTables.setBorder(BorderFactory.createEtchedBorder(0));
        this.tables.add(this.spTables);
        this.setObjectConstraints(this.getTablesLayout(), this.spTables, 10, 12);
    }

    private SpringLayout getTablesLayout() {
        return (SpringLayout)this.tables.getLayout();
    }

    @Override
    public void initProperties() {
        this.initCaption(this.owner.getName());
        this.tfName.setText(this.owner.getName());
        String[] privileges = (String[])Owner.getPrivilegesValues().toArray();
        for (int i = 0; i < privileges.length; ++i) {
            if (this.owner.getSystemPrivilegesSet().contains(privileges[i])) {
                this.selectedPrivsModel.addElement(privileges[i]);
                continue;
            }
            this.allPrivsModel.addElement(privileges[i]);
        }
        this.cbGrantOption.setSelectedItem(OwnerPropertyDialogDB2.translateYesNoForDisplay(this.owner.getGrantOption()));
        if (this.owner.getName().equalsIgnoreCase("[Implicit]")) {
            this.selectedPrivsList.setEnabled(false);
            this.allPrivsList.setEnabled(false);
            this.cbGrantOption.setEnabled(false);
        }
        this.getCommentsList().insert(this.owner.getComment(), 0);
        if (this.owner.isNullInstance()) {
            this.tfName.setEditable(false);
            this.getCommentsList().setEditable(false);
        }
        Object[] tableProxyDB2s = this.getStorageDesign().getTableProxySet().toArray();
        for (int i = 0; i < tableProxyDB2s.length; ++i) {
            TableProxyDB2 tableProxyDB2;
            if (!(tableProxyDB2s[i] instanceof TableProxyDB2) || (tableProxyDB2 = (TableProxyDB2)tableProxyDB2s[i]).getOwner() == null || !tableProxyDB2.getOwner().equals(this.owner)) continue;
            this.tablesListModel.addElement(tableProxyDB2);
        }
        Object[] viewProxyDB2s = this.getStorageDesign().getTableViewProxySet().toArray();
        for (int i = 0; i < viewProxyDB2s.length; ++i) {
            TableViewProxyDB2 viewProxyDB2;
            if (!(viewProxyDB2s[i] instanceof TableViewProxyDB2) || (viewProxyDB2 = (TableViewProxyDB2)viewProxyDB2s[i]).getOwner() == null || !viewProxyDB2.getOwner().equals(this.owner)) continue;
            this.viewsListModel.addElement(viewProxyDB2);
        }
        SynonymDB2[] synonymDB2s = (SynonymDB2[])this.getStorageDesign().getSynonymSet().toArray();
        for (int i = 0; i < synonymDB2s.length; ++i) {
            SynonymDB2 synonymDB2 = synonymDB2s[i];
            if (synonymDB2.getOwner() == null || !synonymDB2.getOwner().equals(this.owner)) continue;
            this.synonymsListModel.addElement(synonymDB2);
        }
        AliasDB2[] aliasDB2s = (AliasDB2[])this.getStorageDesign().getAliasSet().toArray();
        for (int i = 0; i < aliasDB2s.length; ++i) {
            AliasDB2 aliasDB2 = aliasDB2s[i];
            if (aliasDB2.getOwner() == null || !aliasDB2.getOwner().equals(this.owner)) continue;
            this.aliasesListModel.addElement(aliasDB2);
        }
        Object[] indexes = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < indexes.length; ++i) {
            IndexProxyDB2 index;
            if (!(indexes[i] instanceof IndexProxyDB2) || (index = (IndexProxyDB2)indexes[i]).getOwner() == null || !index.getOwner().equals(this.owner)) continue;
            this.indexesListModel.addElement(index);
        }
        StoredProcedureDB2[] storedProcedureDB2s = (StoredProcedureDB2[])this.getStorageDesign().getStoredProcedureSet().toArray();
        for (int i = 0; i < storedProcedureDB2s.length; ++i) {
            StoredProcedureDB2 storedProcedureDB2 = storedProcedureDB2s[i];
            if (storedProcedureDB2.getOwner() == null || !storedProcedureDB2.getOwner().equals(this.owner)) continue;
            this.storedProceduresListModel.addElement(storedProcedureDB2);
        }
        this.cbSchemaObject.setSelectedItem(this.owner.getSchemaObject());
    }

    @Override
    protected void setProperties() {
        if (this.owner != null) {
            this.owner.setSchemaObject((SchemaObject)this.cbSchemaObject.getSelectedItem());
            this.owner.setName(this.tfName.getText());
            Object[] privileges = this.selectedPrivsModel.toArray();
            this.owner.clear();
            for (int i = 0; i < privileges.length; ++i) {
                this.owner.setSystemPrivileges((String)privileges[i]);
            }
            this.owner.setGrantOption(OwnerPropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.owner.setComment(this.getCommentsList().getText());
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OwnerPropertyDialogDB2.this.dialog == null) {
                OwnerPropertyDialogDB2.this.dialog = new UserPermissionsDialogDB2(OwnerPropertyDialogDB2.this.getAppView(), OwnerPropertyDialogDB2.this.getStorageDesign(), OwnerPropertyDialogDB2.this.owner);
            }
            OwnerPropertyDialogDB2.this.dialog.showDialog();
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (OwnerPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (OwnerPropertyDialogDB2.this.allPrivsList.getSelectedIndex() == -1) {
                    OwnerPropertyDialogDB2.this.bnPrivsAdd.setEnabled(false);
                } else {
                    OwnerPropertyDialogDB2.this.bnPrivsAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (OwnerPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (OwnerPropertyDialogDB2.this.selectedPrivsList.getSelectedIndex() == -1) {
                    OwnerPropertyDialogDB2.this.bnPrivsRemove.setEnabled(false);
                } else {
                    OwnerPropertyDialogDB2.this.bnPrivsRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddPrivsActionListener
    implements ActionListener {
        private AddPrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!OwnerPropertyDialogDB2.this.allPrivsModel.isEmpty()) {
                Object[] selectedObjects = OwnerPropertyDialogDB2.this.allPrivsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (OwnerPropertyDialogDB2.this.selectedPrivsModel.contains(ob)) continue;
                    OwnerPropertyDialogDB2.this.selectedPrivsModel.addElement(ob);
                    OwnerPropertyDialogDB2.this.allPrivsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemovePrivsActionListener
    implements ActionListener {
        private RemovePrivsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!OwnerPropertyDialogDB2.this.selectedPrivsModel.isEmpty()) {
                Object[] selectedObjects = OwnerPropertyDialogDB2.this.selectedPrivsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (OwnerPropertyDialogDB2.this.allPrivsModel.contains(ob)) continue;
                    OwnerPropertyDialogDB2.this.allPrivsModel.addElement(ob);
                    OwnerPropertyDialogDB2.this.selectedPrivsModel.removeElement(ob);
                }
            }
        }
    }

    private class listMouseListenerStoredProcedure
    extends MouseAdapter {
        private listMouseListenerStoredProcedure() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            StoredProcedureDB2 selected;
            if (e.getClickCount() == 2 && (selected = (StoredProcedureDB2)OwnerPropertyDialogDB2.this.storedProceduresList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                StoredProcedurePropertyDialogDB2 dialog = new StoredProcedurePropertyDialogDB2(OwnerPropertyDialogDB2.this.owner.getDesign().getAppView(), OwnerPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerIndex
    extends MouseAdapter {
        private listMouseListenerIndex() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyDB2)OwnerPropertyDialogDB2.this.indexesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                IndexPropertyDialogDB2 dialog = new IndexPropertyDialogDB2(OwnerPropertyDialogDB2.this.owner.getDesign().getAppView(), OwnerPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerAlias
    extends MouseAdapter {
        private listMouseListenerAlias() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AliasDB2 selected;
            if (e.getClickCount() == 2 && (selected = (AliasDB2)OwnerPropertyDialogDB2.this.aliasesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                AliasPropertyDialogDB2 dialog = new AliasPropertyDialogDB2(OwnerPropertyDialogDB2.this.owner.getDesign().getAppView(), OwnerPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerSynonym
    extends MouseAdapter {
        private listMouseListenerSynonym() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SynonymDB2 selected;
            if (e.getClickCount() == 2 && (selected = (SynonymDB2)OwnerPropertyDialogDB2.this.synonymsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                SynonymPropertyDialogDB2 dialog = new SynonymPropertyDialogDB2(OwnerPropertyDialogDB2.this.owner.getDesign().getAppView(), OwnerPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerView
    extends MouseAdapter {
        private listMouseListenerView() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableViewProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableViewProxyDB2)OwnerPropertyDialogDB2.this.viewsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableViewPropertyDialogDB2 dialog = new TableViewPropertyDialogDB2(OwnerPropertyDialogDB2.this.owner.getDesign().getAppView(), OwnerPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerTable
    extends MouseAdapter {
        private listMouseListenerTable() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableProxyDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableProxyDB2)OwnerPropertyDialogDB2.this.tablesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TablePropertyDialogDB2 dialog = new TablePropertyDialogDB2(OwnerPropertyDialogDB2.this.owner.getDesign().getAppView(), OwnerPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

