/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexPartitionDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPartitionPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JDecimalField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private IndexProxyDB2 index;
    protected JTextField cbTable;
    protected JTextField cbUnique;
    protected JComboBox cbOwner;
    protected JComboBox cbWhereNotNull;
    protected JComboBox cbStorageTemplate;
    protected JComboBox cbClusterType;
    protected JIntegerField ifNumParts;
    protected JComboBox cbPieceSize;
    protected JComboBox cbBufferPool;
    protected JComboBox cbClose;
    protected JComboBox cbDefer;
    protected JComboBox cbCopy;
    protected JPanel catalogStats;
    protected JPanel designStats;
    private JPanel partitionsOrder;
    private DefaultListModel partitionsModel;
    private JList partitionsList;
    protected JIntegerField ifISOBIT;
    protected JTextField tfCreatedBy;
    protected JIntegerField ifFirstKeyCard;
    protected JIntegerField ifFullKeyCard;
    protected JIntegerField ifNumberLeaf;
    protected JIntegerField ifNumberLevels;
    protected JIntegerField ifCatalogSpace;
    protected JIntegerField ifClusterRatio;
    protected JComboBox cbClustered;
    protected JIntegerField ifMaintenanceInterval;
    protected JIntegerField ifSpaceAllocInterval;
    protected JIntegerField ifInitial;
    protected JIntegerField ifFrequencyCount;
    protected JDecimalField dfFrequencyPercent;
    protected JDecimalField dfUpdateRatePercent;
    protected JTextPane taSpaceCalcs;
    protected JPanel spaceCalcs;
    protected JPanel columnsView;
    protected JTable columnsTable;
    protected ColumnsSortOrderModel sortModel;
    private String comment;
    private String commentInRDBMS;

    public IndexPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.index = (IndexProxyDB2)object;
        this.setHeight(500);
        this.initCommentsView(185);
        this.initCommentsInRDBMS(185);
        this.initSpaceCalcsView(this.getPane().getPreferredSize().height - 70);
        this.initColumnsView(this.getPane().getPreferredSize().height - 70);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogDB2.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initUnique();
        this.initOwner();
        this.initWhereNotNull();
        this.initStorageTemplate();
        this.initPieceSize();
        this.initBufferPool();
        this.initClose();
        this.initDefer();
        this.initCopy();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    protected void initTable() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.RelationalIndex"));
        this.general.add(label);
        this.cbTable = new JTextField();
        this.setBG(this.cbTable);
        this.cbTable.setEnabled(false);
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbTable, 50);
    }

    protected void initUnique() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.RelIndexStatus"));
        this.general.add(label);
        this.cbUnique = new JTextField();
        this.setBG(this.cbUnique);
        this.cbUnique.setEnabled(false);
        this.cbUnique.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbUnique);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbUnique, 80);
    }

    protected void initOwner() {
        JButton button = new JButton("...");
        button.setPreferredSize(new Dimension(30, 20));
        button.setToolTipText(Messages.getString("IndexPropertyDialogDB2.OwnerProperties"));
        button.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(button);
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbOwner, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 110);
        this.setObjectConstraints(button, 110);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = IndexPropertyDialogDB2.this.cbOwner.getSelectedItem();
                if (object != null && object instanceof Owner) {
                    Owner db = (Owner)object;
                    db.showPropertyDialog();
                }
            }
        });
    }

    protected void initWhereNotNull() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.WhereNotNull"));
        this.general.add(label);
        this.cbWhereNotNull = new JComboBox<String>(YES_NO);
        this.setBG(this.cbWhereNotNull);
        this.cbWhereNotNull.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbWhereNotNull);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbWhereNotNull, 140);
    }

    protected void initStorageTemplate() {
        JButton button = new JButton("...");
        button.setPreferredSize(new Dimension(30, 20));
        button.setToolTipText(Messages.getString("IndexPropertyDialogDB2.StorageTemplateProperties"));
        button.setMargin(new Insets(0, 0, 5, 0));
        this.general.add(button);
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.StorageTemplate"));
        this.general.add(label);
        this.cbStorageTemplate = new JComboBox();
        this.setBG(this.cbStorageTemplate);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getStorageTemplateSet().toArray(), this.cbStorageTemplate);
        }
        this.cbStorageTemplate.setPreferredSize(new Dimension(this.tfName.getPreferredSize().width - 40, 20));
        this.general.add(this.cbStorageTemplate);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(button, 170);
        this.setObjectConstraints(this.cbStorageTemplate, this.getDialogWidth() - 15 - this.tfName.getPreferredSize().width, 170);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = IndexPropertyDialogDB2.this.cbStorageTemplate.getSelectedItem();
                if (object != null && object instanceof StorageTemplateDB2) {
                    StorageTemplateDB2 st = (StorageTemplateDB2)object;
                    st.showPropertyDialog();
                }
            }
        });
    }

    protected void initClusterType() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.ClusterType"));
        this.general.add(label);
        this.cbClusterType = new JComboBox<String>(IndexProxyDB2.getClusterTypeValues());
        this.setBG(this.cbClusterType);
        this.cbClusterType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClusterType);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbClusterType, 200);
        this.cbClusterType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexPropertyDialogDB2.this.enablePieceSize();
            }
        });
    }

    protected void initNumParts() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.NumParts"));
        this.general.add(label);
        this.ifNumParts = new JIntegerField(0, 26);
        this.ifNumParts.setEditable(false);
        this.general.add(this.ifNumParts);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.ifNumParts, 230);
    }

    protected void initPieceSize() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.PieceSize"));
        this.general.add(label);
        this.cbPieceSize = new JComboBox<String>(IndexProxyDB2.getPieceSizesValues());
        this.setBG(this.cbPieceSize);
        this.cbPieceSize.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPieceSize);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbPieceSize, 260);
    }

    protected void initBufferPool() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.BufferPool"));
        this.general.add(label);
        this.cbBufferPool = new JComboBox();
        this.setBG(this.cbBufferPool);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getBufferPoolSet().toArray(), this.cbBufferPool);
        }
        this.cbBufferPool.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbBufferPool);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.cbBufferPool, 290);
    }

    protected void initClose() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.Close"));
        this.general.add(label);
        this.cbClose = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClose);
        this.cbClose.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClose);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbClose, 320);
    }

    protected void initDefer() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.Defer"));
        this.general.add(label);
        this.cbDefer = new JComboBox<String>(YES_NO);
        this.setBG(this.cbDefer);
        this.cbDefer.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDefer);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbDefer, 350);
    }

    protected void initCopy() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.Copy"));
        this.general.add(label);
        this.cbCopy = new JComboBox<String>(YES_NO);
        this.setBG(this.cbCopy);
        this.cbCopy.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCopy);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbCopy, 380);
    }

    @Override
    protected void addTabs() {
        this.initCatalogStatsView();
        this.initDesignStatsView();
        this.initPartitionsOrderView();
    }

    protected void initCatalogStatsView() {
        this.catalogStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.CatalogStats"), this.catalogStats);
        this.initCatalogStats();
    }

    protected void initDesignStatsView() {
        this.designStats = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.DesignStats"), this.designStats);
        this.initDesignStats();
    }

    private void initPartitionsOrderView() {
        this.partitionsOrder = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.PartitionsOrder"), this.partitionsOrder);
        this.initPartitionsOrder();
    }

    private void initPartitionsOrder() {
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JButton btnProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("IndexPropertyDialogDB2.Properties"));
        btnProperties.addActionListener(new PartitionPropertiesAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            JButton btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", 16));
            btnUp.setToolTipText(Messages.getString("IndexPropertyDialogDB2.MoveUp"));
            btnUp.addActionListener(new MoveUpAction());
            JButton btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", 16));
            btnDown.setToolTipText(Messages.getString("IndexPropertyDialogDB2.MoveDown"));
            btnDown.addActionListener(new MoveDownAction());
            toolBar.addSeparator();
            toolBar.add(btnUp);
            toolBar.add(btnDown);
        }
        buttonGeneral.add(toolBar);
        this.partitionsOrder.add((Component)buttonGeneral, "North");
        this.partitionsModel = new DefaultListModel();
        this.partitionsList = new JList(this.partitionsModel);
        JScrollPane sp = new JScrollPane(this.partitionsList);
        sp.setPreferredSize(new Dimension(400, 360));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.partitionsOrder.add(sp);
        this.setObjectConstraints(this.getPartitionsOrderLayout(), sp, 6, 40);
    }

    protected SpringLayout getPartitionsOrderLayout() {
        return (SpringLayout)this.partitionsOrder.getLayout();
    }

    protected void initCatalogStats() {
        this.initISOBID();
        this.initCreatedBy();
        this.initFirstKeyCard();
        this.initFullKeyCard();
        this.initNumberLeaf();
        this.initNumberLevels();
        this.initCatalogSpace();
        this.initClusterRatio();
        this.initClustered();
    }

    protected void initDesignStats() {
        this.initMaintenanceInterval();
        this.initSpaceAllocInterval();
        this.initInitial();
        this.initFrequencyCount();
        this.initFrequencyPercent();
        this.initUpdateRatePercent();
    }

    protected SpringLayout getCatalogStatsLayout() {
        return (SpringLayout)this.catalogStats.getLayout();
    }

    protected SpringLayout getDesignStatsLayout() {
        return (SpringLayout)this.designStats.getLayout();
    }

    private void initISOBID() {
        JLabel label = new JLabel("ISOBID");
        this.catalogStats.add(label);
        this.ifISOBIT = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifISOBIT);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 20);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifISOBIT, 20);
    }

    protected void initCreatedBy() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.CreatedBy"));
        this.catalogStats.add(label);
        this.tfCreatedBy = new JTextField("", 26);
        this.catalogStats.add(this.tfCreatedBy);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 50);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.tfCreatedBy, 50);
    }

    protected void initFirstKeyCard() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.FirstKeyCard"));
        this.catalogStats.add(label);
        this.ifFirstKeyCard = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifFirstKeyCard);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 80);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifFirstKeyCard, 80);
    }

    protected void initFullKeyCard() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.FullKeyCard"));
        this.catalogStats.add(label);
        this.ifFullKeyCard = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifFullKeyCard);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 110);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifFullKeyCard, 110);
    }

    protected void initNumberLeaf() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.NumberLeaf"));
        this.catalogStats.add(label);
        this.ifNumberLeaf = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNumberLeaf);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 140);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNumberLeaf, 140);
    }

    protected void initNumberLevels() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.NumberLevels"));
        this.catalogStats.add(label);
        this.ifNumberLevels = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifNumberLevels);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 170);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifNumberLevels, 170);
    }

    protected void initCatalogSpace() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.CatalogSpace"));
        this.catalogStats.add(label);
        this.ifCatalogSpace = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifCatalogSpace);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 200);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifCatalogSpace, 200);
    }

    protected void initClusterRatio() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.ClusterRatio"));
        this.catalogStats.add(label);
        this.ifClusterRatio = new JIntegerField(0, 26);
        this.catalogStats.add(this.ifClusterRatio);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 230);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.ifClusterRatio, 230);
    }

    private void initClustered() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.Clustered"));
        this.catalogStats.add(label);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.catalogStats.add(this.cbClustered);
        this.setLabelConstraints(this.getCatalogStatsLayout(), label, 260);
        this.setObjectConstraints(this.getCatalogStatsLayout(), this.cbClustered, 260);
    }

    protected void initMaintenanceInterval() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.MaintInterval"));
        this.designStats.add(label);
        this.ifMaintenanceInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifMaintenanceInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 20);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifMaintenanceInterval, 20);
    }

    protected void initSpaceAllocInterval() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.SpaceAllocInterval"));
        this.designStats.add(label);
        this.ifSpaceAllocInterval = new JIntegerField(0, 26);
        this.designStats.add(this.ifSpaceAllocInterval);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 50);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifSpaceAllocInterval, 50);
    }

    protected void initInitial() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.Initial"));
        this.designStats.add(label);
        this.ifInitial = new JIntegerField(0, 26);
        this.designStats.add(this.ifInitial);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 80);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifInitial, 80);
    }

    protected void initFrequencyCount() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.FrequencyCount"));
        this.designStats.add(label);
        this.ifFrequencyCount = new JIntegerField(0, 26);
        this.designStats.add(this.ifFrequencyCount);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 110);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.ifFrequencyCount, 110);
    }

    protected void initFrequencyPercent() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.FrequencyPercent"));
        this.designStats.add(label);
        this.dfFrequencyPercent = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfFrequencyPercent);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 140);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfFrequencyPercent, 140);
    }

    protected void initUpdateRatePercent() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogDB2.UpdRatePercent"));
        this.designStats.add(label);
        this.dfUpdateRatePercent = new JDecimalField(0.0, 26);
        this.designStats.add(this.dfUpdateRatePercent);
        this.setLabelConstraints(this.getDesignStatsLayout(), label, 170);
        this.setObjectConstraints(this.getDesignStatsLayout(), this.dfUpdateRatePercent, 170);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.index.getName());
        this.tfName.setText(this.index.getName());
        this.cbTable.setText(this.index.getIndex().getName());
        this.initNumParts();
        this.initClusterType();
        this.cbUnique.setText(this.index.getIndex().getIndexState());
        this.selectObject(this.cbOwner, this.index.getOwner());
        this.cbWhereNotNull.setSelectedItem(this.index.isWhereNotNull() ? YES_NO[0] : YES_NO[1]);
        this.selectObject(this.cbStorageTemplate, this.index.getStorageTemplate());
        this.cbClusterType.setSelectedItem(this.index.getClusterType());
        this.ifNumParts.setValue((long)this.index.getNumParts());
        this.cbPieceSize.setSelectedItem(this.index.getPieceSize());
        this.selectObject(this.cbBufferPool, this.index.getBufferPool());
        this.cbClose.setSelectedItem(this.index.isClose() ? YES_NO[0] : YES_NO[1]);
        this.cbDefer.setSelectedItem(this.index.isDefer() ? YES_NO[0] : YES_NO[1]);
        this.cbCopy.setSelectedItem(this.index.isCopy() ? YES_NO[0] : YES_NO[1]);
        this.ifISOBIT.setValue((long)this.index.getIsobid());
        this.tfCreatedBy.setText(this.index.getCreatedBy());
        this.ifFirstKeyCard.setValue((long)this.index.getFirstKeyCard());
        this.ifFullKeyCard.setValue((long)this.index.getFullKeyCard());
        this.ifNumberLeaf.setValue((long)this.index.getNumberLeaf());
        this.ifNumberLevels.setValue((long)this.index.getNumberLevels());
        this.ifCatalogSpace.setValue((long)this.index.getCatalogSpace());
        this.ifClusterRatio.setValue((long)this.index.getClusterRatio());
        this.cbClustered.setSelectedItem(this.index.isClustered() ? YES_NO[0] : YES_NO[1]);
        this.ifMaintenanceInterval.setValue((long)this.index.getMaintenanceInterval());
        this.ifSpaceAllocInterval.setValue((long)this.index.getSpaceAllocationInterval());
        this.ifInitial.setValue(this.index.getInitial());
        this.ifFrequencyCount.setValue(this.index.getFrequencyCount());
        this.dfFrequencyPercent.setValue(this.index.getFrequencyPercent());
        this.dfUpdateRatePercent.setValue(this.index.getUpdateRatePercent());
        this.comment = this.index.getObject().getComment();
        this.commentInRDBMS = this.index.getObject().getCommentInRDBMS();
        if (this.index.isCommentChanged()) {
            this.getCommentsList().insert(this.index.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.index.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.index.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.initSpaceCalcs();
        this.initColumnsSortOrder();
        this.enablePieceSize();
        this.partitionsModel.clear();
        Iterator it = this.index.getIndexPartitions().iterator();
        while (it.hasNext()) {
            try {
                IndexPartitionDB2 part = (IndexPartitionDB2)it.next();
                this.partitionsModel.addElement(part);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    @Override
    protected void setProperties() {
        if (this.index != null) {
            this.index.setName(this.tfName.getText());
            Object selected = this.cbOwner.getSelectedItem();
            if (selected instanceof Owner) {
                this.index.setOwner((Owner)selected);
            } else {
                this.index.setOwner(null);
            }
            selected = this.cbWhereNotNull.getSelectedItem();
            boolean result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.index.setWhereNotNull(result);
            selected = this.cbStorageTemplate.getSelectedItem();
            if (selected instanceof StorageTemplateDB2) {
                this.index.setStorageTemplate((StorageTemplateDB2)selected);
            } else {
                this.index.setStorageTemplate(null);
            }
            this.index.setClusterType((String)this.cbClusterType.getSelectedItem());
            this.index.setPieceSize((String)this.cbPieceSize.getSelectedItem());
            selected = this.cbBufferPool.getSelectedItem();
            if (selected instanceof BufferPoolDB2) {
                this.index.setBufferPool((BufferPoolDB2)selected);
            } else {
                this.index.setBufferPool(null);
            }
            selected = this.cbClose.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.index.setClose(result);
            selected = this.cbDefer.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.index.setDefer(result);
            selected = this.cbCopy.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.index.setCopy(result);
            this.index.setIsobid(this.ifISOBIT.getIntValue());
            this.index.setCreatedBy(this.tfCreatedBy.getText());
            this.index.setFirstKeyCard(this.ifFirstKeyCard.getIntValue());
            this.index.setFullKeyCard(this.ifFullKeyCard.getIntValue());
            this.index.setNumberLeaf(this.ifNumberLeaf.getIntValue());
            this.index.setNumberLevels(this.ifNumberLevels.getIntValue());
            this.index.setCatalogSpace(this.ifCatalogSpace.getIntValue());
            this.index.setClusterRatio(this.ifClusterRatio.getIntValue());
            selected = this.cbClustered.getSelectedItem();
            result = String.valueOf(selected).equalsIgnoreCase(YES_NO[0]);
            this.index.setClustered(result);
            this.index.setMaintenanceInterval(this.ifMaintenanceInterval.getIntValue());
            this.index.setSpaceAllocationInterval(this.ifSpaceAllocInterval.getIntValue());
            this.index.setInitial(this.ifInitial.getIntValue());
            this.index.setFrequencyCount(this.ifFrequencyCount.getIntValue());
            this.index.setFrequencyPercent(this.dfFrequencyPercent.getFloatValue());
            this.index.setUpdateRatePercent(this.dfUpdateRatePercent.getFloatValue());
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.index.setComment(commentText);
                this.index.setCommentChanged(true);
            } else {
                this.index.setComment("");
                this.index.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.index.setCommentInRDBMS(commentInRDBMSText);
                this.index.setCommentInRDBMSChanged(true);
            } else {
                this.index.setCommentInRDBMS("");
                this.index.setCommentInRDBMSChanged(false);
            }
            this.initSpaceCalcs();
            this.applyColumnsSortOrder();
            if (((String)this.cbClusterType.getSelectedItem()).equalsIgnoreCase("CLUSTERED_PARTITIONED")) {
                int size = this.index.getIndexPartitions().size();
                for (int i = 0; i < size; ++i) {
                    this.index.getIndexPartitions().justRemove(this.index.getIndexPartitions().getElement(0));
                }
                for (int i = 0; i < this.partitionsModel.toArray().length; ++i) {
                    if (!(this.partitionsModel.get(i) instanceof IndexPartitionDB2)) continue;
                    IndexPartitionDB2 p = (IndexPartitionDB2)this.partitionsModel.get(i);
                    p.addObjectListener(this.index);
                    p.setPartNumber(i + 1);
                    p.setParent(this.index.getIndexPartitions());
                    this.index.getIndexPartitions().add(p);
                }
            }
        }
    }

    protected void initSpaceCalcsView(int height) {
        this.spaceCalcs = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.SpaceCalcs"), this.spaceCalcs);
        this.taSpaceCalcs = new JTextPane();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        this.taSpaceCalcs.setParagraphAttributes(as, true);
        JScrollPane sp = new JScrollPane(this.taSpaceCalcs);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.spaceCalcs.add(sp);
        this.setObjectConstraints(this.getSpaceCalcsLayout(), sp, 10, 12);
        this.taSpaceCalcs.setEditable(false);
    }

    protected SpringLayout getSpaceCalcsLayout() {
        return (SpringLayout)this.spaceCalcs.getLayout();
    }

    private String formatText(String text) {
        StringBuffer buffer = new StringBuffer(text);
        buffer.append(' ');
        while (buffer.length() < 30) {
            buffer.append(' ');
        }
        buffer.append("\t");
        return buffer.toString();
    }

    private String formatInt(int number) {
        StringBuffer buffer = new StringBuffer();
        String snumber = Integer.toString(number);
        for (int i = 0; i < 15 - snumber.length(); ++i) {
            buffer.append(' ');
        }
        buffer.append(snumber);
        return buffer.toString();
    }

    protected void initSpaceCalcs() {
        if (this.index != null) {
            String rem;
            StringBuffer sb = new StringBuffer();
            sb.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.InitNumberOfUsedPages"))).append(this.formatInt(this.index.getInitialNumberUsedPages())).append("\n");
            sb.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.MaxNumberOfUsedPages"))).append(this.formatInt(this.index.getMaxNumberUsedPages())).append("\n\n");
            sb.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.ProposedPRIQTY"))).append(this.formatInt(this.index.getProposedPRIQTY())).append("\n");
            sb.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.ProposedSECQTY"))).append(this.formatInt(this.index.getProposedSECQTY())).append("\n");
            if (this.index.getStorageTemplate() != null) {
                sb.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.CurrentPRIQTY"))).append(this.formatInt(this.index.getStorageTemplate().getSgPriqty())).append("\n");
                sb.append(this.formatText(Messages.getString("IndexPropertyDialogDB2.CurrentSECQTY"))).append(this.formatInt(this.index.getStorageTemplate().getSgSeqty())).append("\n\n");
            }
            if (!(rem = this.index.getProposedQTYRemarks()).equals("")) {
                sb.append(Messages.getString("IndexPropertyDialogDB2.RemarksOnProposedPRIQTYAndSECQTY")).append(rem);
            }
            this.taSpaceCalcs.setText(sb.toString());
        } else {
            this.taSpaceCalcs.setText("");
        }
    }

    protected void initColumnsView(int height) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogDB2.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(sp);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.index.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection colNodes = this.sortModel.getColumnsSortOrederColl();
        Iterator it = colNodes.iterator();
        Index ind = (Index)this.index.getObject();
        while (it.hasNext()) {
            ColumnsSortOrderModel.ColumnNode cn = (ColumnsSortOrderModel.ColumnNode)it.next();
            Column col = (Column)ind.getElementByID(cn.objectId);
            if (col == null) continue;
            ind.setColumnSortOrder(col, cn.sortOrder);
        }
    }

    private void enablePieceSize() {
        String part = (String)this.cbClusterType.getSelectedItem();
        this.cbPieceSize.setEnabled(!part.equalsIgnoreCase("CLUSTERED_PARTITIONED"));
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("IndexPropertyDialogDB2.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(IndexPropertyDialogDB2.this.getStorageDesign().getIndexProxySet().getElements());
                list.remove(IndexPropertyDialogDB2.this.index);
                new PropertiesPropagationDialog(IndexPropertyDialogDB2.this.getAppView(), IndexPropertyDialogDB2.this.index, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 420);
    }

    private class PartitionPropertiesAction
    implements ActionListener {
        private PartitionPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IndexPartitionDB2 selected = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsList.getSelectedValue();
            if (selected != null && !selected.isDialogVisible()) {
                IndexPartitionPropertyDialogDB2 dialog = new IndexPartitionPropertyDialogDB2(IndexPropertyDialogDB2.this.getAppView(), IndexPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = IndexPropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = 0; i < objectNumber.length; ++i) {
                if (objectNumber[i] == -1 || objectNumber[i] <= 0) continue;
                IndexPartitionDB2 part = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(objectNumber[i]);
                IndexPartitionDB2 old = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(objectNumber[i] - 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(part, objectNumber[i] - 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            IndexPropertyDialogDB2.this.partitionsList.clearSelection();
            IndexPropertyDialogDB2.this.partitionsList.updateUI();
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objectNumber = IndexPropertyDialogDB2.this.partitionsList.getSelectedIndices();
            for (int i = objectNumber.length - 1; i >= 0; --i) {
                if (objectNumber[i] == -1 || IndexPropertyDialogDB2.this.partitionsModel.size() - 1 <= objectNumber[i]) continue;
                IndexPartitionDB2 part = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(objectNumber[i]);
                IndexPartitionDB2 old = (IndexPartitionDB2)IndexPropertyDialogDB2.this.partitionsModel.get(objectNumber[i] + 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(part, objectNumber[i] + 1);
                IndexPropertyDialogDB2.this.partitionsModel.setElementAt(old, objectNumber[i]);
            }
            IndexPropertyDialogDB2.this.partitionsList.clearSelection();
            IndexPropertyDialogDB2.this.partitionsList.updateUI();
        }
    }
}

