/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.DataBaseDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.IndexProxyDB2v70;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.DataBasePropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.IndexPropertyDialogDB2;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.TableSpacePropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class BufferPoolPropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private JIntegerField ifMinBuffers;
    private JIntegerField ifMaxBuffers;
    private BufferPoolDB2 bufferPool;
    private JPanel tableSpaces;
    private DefaultListModel tsListModel;
    private JList tsList;
    private JScrollPane spTS;
    private JPanel indexes;
    private DefaultListModel indexesListModel;
    private JList indexesList;
    private JScrollPane spIndexes;
    private JPanel databases;
    private DefaultListModel dbListModel;
    private JList dbList;
    private JScrollPane spDB;
    private JPanel usePrivilegesPanel;
    private DefaultListModel allUsersModel;
    private DefaultListModel selectedUsersModel;
    private JList allUsersList;
    private JList selectedUsersList;
    private JButton bnAdd;
    private JButton bnRemove;
    private JComboBox cbAllBufferpools;
    private JComboBox cbGrantOption;

    public BufferPoolPropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.bufferPool = (BufferPoolDB2)object;
        this.setHeight(250);
        this.initCommentsView(180);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("BufferPoolPropertyDialogDB2.BufferPoolProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.tfName.setEditable(false);
        this.initMinBuffers();
        this.initMaxBuffers();
    }

    @Override
    protected void addTabs() {
        this.initUsePrivilegesView();
        this.initTableSpacesView();
        this.initIndexesView();
        this.initDatabaseView();
    }

    private void initUsePrivilegesView() {
        this.usePrivilegesPanel = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.UsePrivileges"), this.usePrivilegesPanel);
        this.initUsePrivileges();
    }

    private void initUsePrivileges() {
        this.initToUsers();
        this.initAllBufferpools();
        this.initGrantOption();
    }

    private void initToUsers() {
        this.initAllUsersList();
        this.initSelectedUsersList();
        this.initButtons();
    }

    private void initAllUsersList() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.AllUsers"));
        this.usePrivilegesPanel.add(label);
        this.allUsersModel = new DefaultListModel();
        this.allUsersList = new JList(this.allUsersModel);
        ListSelectionModel listSelectionModel = this.allUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allUsersList);
        sp.setPreferredSize(new Dimension(144, 90));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 12, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 10, 32);
    }

    private void initSelectedUsersList() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.SelectedUsers"));
        this.usePrivilegesPanel.add(label);
        this.selectedUsersModel = new DefaultListModel();
        this.selectedUsersList = new JList(this.selectedUsersModel);
        ListSelectionModel listSelectionModel = this.selectedUsersList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedUsersList);
        sp.setPreferredSize(new Dimension(145, 90));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.usePrivilegesPanel.add(sp);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 292, 14);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), sp, 290, 32);
    }

    private void initButtons() {
        this.bnAdd = new JButton(Messages.getString("BufferPoolPropertyDialogDB2.Add"));
        this.bnAdd.addActionListener(new AddColumnsActionListener());
        this.bnAdd.setEnabled(false);
        this.usePrivilegesPanel.add(this.bnAdd);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnAdd, 175, 55);
        this.bnRemove = new JButton(Messages.getString("BufferPoolPropertyDialogDB2.Remove"));
        this.bnRemove.setEnabled(false);
        this.bnRemove.addActionListener(new RemoveColumnsActionListener());
        this.usePrivilegesPanel.add(this.bnRemove);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.bnRemove, 175, 85);
        BufferPoolPropertyDialogDB2.equalizeButtonSizes(this.bnAdd, this.bnRemove);
    }

    protected SpringLayout getUsePrivilegesLayout() {
        return (SpringLayout)this.usePrivilegesPanel.getLayout();
    }

    private void initAllBufferpools() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.AllBufferpools"));
        this.usePrivilegesPanel.add(label);
        this.cbAllBufferpools = new JComboBox<String>(YES_NO);
        this.setBG(this.cbAllBufferpools);
        this.cbAllBufferpools.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbAllBufferpools);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 140);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbAllBufferpools, 140);
    }

    private void initGrantOption() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.GrantOption"));
        this.usePrivilegesPanel.add(label);
        this.cbGrantOption = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGrantOption);
        this.cbGrantOption.setPreferredSize(this.tfName.getPreferredSize());
        this.usePrivilegesPanel.add(this.cbGrantOption);
        this.setLabelConstraints(this.getUsePrivilegesLayout(), label, 170);
        this.setObjectConstraints(this.getUsePrivilegesLayout(), this.cbGrantOption, 170);
    }

    private void initDatabaseView() {
        this.databases = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.Databases"), this.databases);
        this.initDatabase();
    }

    private void initDatabase() {
        this.dbListModel = new DefaultListModel();
        this.dbList = new JList(this.dbListModel);
        this.dbList.addMouseListener(new listMouseListenerDB());
        this.spDB = new JScrollPane(this.dbList);
        this.spDB.setPreferredSize(new Dimension(395, 180));
        this.spDB.setBorder(BorderFactory.createEtchedBorder(0));
        this.databases.add(this.spDB);
        this.setObjectConstraints(this.getDBLayout(), this.spDB, 10, 12);
    }

    private SpringLayout getDBLayout() {
        return (SpringLayout)this.databases.getLayout();
    }

    private void initIndexesView() {
        this.indexes = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.Indexes"), this.indexes);
        this.initIndexes();
    }

    private void initIndexes() {
        this.indexesListModel = new DefaultListModel();
        this.indexesList = new JList(this.indexesListModel);
        this.indexesList.addMouseListener(new listMouseListenerIndex());
        this.spIndexes = new JScrollPane(this.indexesList);
        this.spIndexes.setPreferredSize(new Dimension(395, 180));
        this.spIndexes.setBorder(BorderFactory.createEtchedBorder(0));
        this.indexes.add(this.spIndexes);
        this.setObjectConstraints(this.getIndexesLayout(), this.spIndexes, 10, 12);
    }

    private SpringLayout getIndexesLayout() {
        return (SpringLayout)this.indexes.getLayout();
    }

    private void initTableSpacesView() {
        this.tableSpaces = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("BufferPoolPropertyDialogDB2.TableSpaces"), this.tableSpaces);
        this.initTableSpaces();
    }

    private void initTableSpaces() {
        this.tsListModel = new DefaultListModel();
        this.tsList = new JList(this.tsListModel);
        this.tsList.addMouseListener(new listMouseListenerTS());
        this.spTS = new JScrollPane(this.tsList);
        this.spTS.setPreferredSize(new Dimension(395, 180));
        this.spTS.setBorder(BorderFactory.createEtchedBorder(0));
        this.tableSpaces.add(this.spTS);
        this.setObjectConstraints(this.getTSLayout(), this.spTS, 10, 12);
    }

    protected SpringLayout getTSLayout() {
        return (SpringLayout)this.tableSpaces.getLayout();
    }

    private void initMinBuffers() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.MinBuffers"));
        this.general.add(label);
        this.ifMinBuffers = new JIntegerField(0, 26);
        this.general.add(this.ifMinBuffers);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.ifMinBuffers, 50);
    }

    private void initMaxBuffers() {
        JLabel label = new JLabel(Messages.getString("BufferPoolPropertyDialogDB2.MaxBuffers"));
        this.general.add(label);
        this.ifMaxBuffers = new JIntegerField(0, 26);
        this.general.add(this.ifMaxBuffers);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifMaxBuffers, 80);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.bufferPool.getName());
        this.tfName.setText(this.bufferPool.getName());
        this.ifMinBuffers.setValue((long)this.bufferPool.getMinBuffers());
        this.ifMaxBuffers.setValue((long)this.bufferPool.getMaxBuffers());
        Owner[] userSet = (Owner[])this.getStorageDesign().getOwnerSet().toArray();
        for (int i = 0; i < userSet.length; ++i) {
            Owner user = userSet[i];
            if (user.getName().equalsIgnoreCase("[Implicit]")) continue;
            if (this.bufferPool.getUserSet().contains(user.getName())) {
                this.selectedUsersModel.addElement(user);
                continue;
            }
            this.allUsersModel.addElement(user);
        }
        this.cbAllBufferpools.setSelectedItem(BufferPoolPropertyDialogDB2.translateYesNoForDisplay(this.bufferPool.getAllBufferpools()));
        this.cbGrantOption.setSelectedItem(BufferPoolPropertyDialogDB2.translateYesNoForDisplay(this.bufferPool.getGrantOption()));
        this.getCommentsList().insert(this.bufferPool.getComment(), 0);
        TableSpaceDB2[] tss = (TableSpaceDB2[])this.getStorageDesign().getTableSpaceSet().toArray();
        for (int i = 0; i < tss.length; ++i) {
            TableSpaceDB2 ts = tss[i];
            if (ts.getBufferPool() == null || !ts.getBufferPool().equals(this.bufferPool)) continue;
            this.tsListModel.addElement(ts);
        }
        Object[] indexes = this.getStorageDesign().getIndexProxySet().toArray();
        for (int i = 0; i < indexes.length; ++i) {
            IndexProxyDB2 index;
            if (!(indexes[i] instanceof IndexProxyDB2) || (index = (IndexProxyDB2)indexes[i]).getBufferPool() == null || !index.getBufferPool().equals(this.bufferPool)) continue;
            this.indexesListModel.addElement(index);
        }
        DataBaseDB2[] dbs = (DataBaseDB2[])this.getStorageDesign().getDataBaseSet().toArray();
        for (int i = 0; i < dbs.length; ++i) {
            DataBaseDB2 db = dbs[i];
            if (db.getBufferPool() == null || !db.getBufferPool().equals(this.bufferPool)) continue;
            this.dbListModel.addElement(db);
        }
    }

    @Override
    protected void setProperties() {
        if (this.bufferPool != null) {
            this.bufferPool.setMinBuffers(this.ifMinBuffers.getIntValue());
            this.bufferPool.setMaxBuffers(this.ifMaxBuffers.getIntValue());
            Object[] userSet = this.selectedUsersModel.toArray();
            this.bufferPool.clear();
            for (int i = 0; i < userSet.length; ++i) {
                Object ob = userSet[i];
                if (!(ob instanceof Owner)) continue;
                this.bufferPool.setUsers(((Owner)ob).getName());
            }
            this.bufferPool.setAllBufferpools(BufferPoolPropertyDialogDB2.translateYesNoForStorage((String)this.cbAllBufferpools.getSelectedItem()));
            this.bufferPool.setGrantOption(BufferPoolPropertyDialogDB2.translateYesNoForStorage((String)this.cbGrantOption.getSelectedItem()));
            this.bufferPool.setComment(this.getCommentsList().getText());
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BufferPoolPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogDB2.this.allUsersList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogDB2.this.bnAdd.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogDB2.this.bnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (BufferPoolPropertyDialogDB2.this.isEditable() && !e.getValueIsAdjusting()) {
                if (BufferPoolPropertyDialogDB2.this.selectedUsersList.getSelectedIndex() == -1) {
                    BufferPoolPropertyDialogDB2.this.bnRemove.setEnabled(false);
                } else {
                    BufferPoolPropertyDialogDB2.this.bnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BufferPoolPropertyDialogDB2.this.allUsersModel.isEmpty()) {
                Object[] selectedObjects = BufferPoolPropertyDialogDB2.this.allUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BufferPoolPropertyDialogDB2.this.selectedUsersModel.contains(ob)) continue;
                    BufferPoolPropertyDialogDB2.this.selectedUsersModel.addElement(ob);
                    BufferPoolPropertyDialogDB2.this.allUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!BufferPoolPropertyDialogDB2.this.selectedUsersModel.isEmpty()) {
                Object[] selectedObjects = BufferPoolPropertyDialogDB2.this.selectedUsersList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (BufferPoolPropertyDialogDB2.this.allUsersModel.contains(ob)) continue;
                    BufferPoolPropertyDialogDB2.this.allUsersModel.addElement(ob);
                    BufferPoolPropertyDialogDB2.this.selectedUsersModel.removeElement(ob);
                }
            }
        }
    }

    private class listMouseListenerDB
    extends MouseAdapter {
        private listMouseListenerDB() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DataBaseDB2 selected;
            if (e.getClickCount() == 2 && (selected = (DataBaseDB2)BufferPoolPropertyDialogDB2.this.dbList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                DataBasePropertyDialogDB2 dialog = new DataBasePropertyDialogDB2(BufferPoolPropertyDialogDB2.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerIndex
    extends MouseAdapter {
        private listMouseListenerIndex() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IndexProxyDB2v70 selected;
            if (e.getClickCount() == 2 && (selected = (IndexProxyDB2v70)BufferPoolPropertyDialogDB2.this.indexesList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                IndexPropertyDialogDB2 dialog = new IndexPropertyDialogDB2(BufferPoolPropertyDialogDB2.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }

    private class listMouseListenerTS
    extends MouseAdapter {
        private listMouseListenerTS() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TableSpaceDB2 selected;
            if (e.getClickCount() == 2 && (selected = (TableSpaceDB2)BufferPoolPropertyDialogDB2.this.tsList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TableSpacePropertyDialogDB2 dialog = new TableSpacePropertyDialogDB2(BufferPoolPropertyDialogDB2.this.bufferPool.getDesign().getAppView(), BufferPoolPropertyDialogDB2.this.getStorageDesign(), selected);
                dialog.show();
            }
        }
    }
}

