/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.datatype.db2.MDBlob;
import oracle.dbtools.crest.model.datatype.db2.MDClob;
import oracle.dbtools.crest.model.datatype.db2.MDDBClob;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.AUXTableDB2;
import oracle.dbtools.crest.model.design.storage.db2.ColumnProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableSpaceDB2;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.swingui.editor.storage.db2.PermissionsPropertyDialogDB2;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class AUXTablePropertyDialogDB2
extends AbstractDB2PropertyDialog {
    private AUXTableDB2 auxTable;
    private JComboBox cbOwner;
    private JComboBox cbTableSpace;
    private JComboBox cbDatabase;
    private JComboBox cbTable;
    private JComboBox cbColumn;
    private JIntegerField ifPartNumber;
    private JButton bnPermissions;
    private PermissionsPropertyDialogDB2 dialog;

    public AUXTablePropertyDialogDB2(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.auxTable = (AUXTableDB2)object;
        this.setHeight(300);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AUXTablePropertyDialogDB2.AUXTableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initOwner();
        this.initTableSpace();
        this.initDatabase();
        this.initTable();
        this.initColumn();
        this.initPartNumber();
        this.initPermissionsButton();
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("AUXTablePropertyDialogDB2.Owner"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getOwnerSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getOwnerSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.cbOwner, 50);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("AUXTablePropertyDialogDB2.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTableSpace.addActionListener(new TableSpaceListener());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbTableSpace, 80);
    }

    private void initDatabase() {
        JLabel label = new JLabel(Messages.getString("AUXTablePropertyDialogDB2.Database"));
        this.general.add(label);
        this.cbDatabase = new JComboBox();
        this.setBG(this.cbDatabase);
        this.cbDatabase.setEnabled(false);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getDataBaseSet().toArray(), this.cbDatabase);
        }
        this.cbDatabase.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDatabase);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbDatabase, 110);
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("AUXTablePropertyDialogDB2.Table"));
        this.general.add(label);
        this.cbTable = new JComboBox();
        this.setBG(this.cbTable);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getLobTables(), this.cbTable);
        }
        this.cbTable.setPreferredSize(this.tfName.getPreferredSize());
        this.cbTable.addActionListener(new LobTableListener());
        this.general.add(this.cbTable);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbTable, 140);
    }

    private void initColumn() {
        JLabel label = new JLabel(Messages.getString("AUXTablePropertyDialogDB2.Column"));
        this.general.add(label);
        this.cbColumn = new JComboBox();
        this.setBG(this.cbColumn);
        this.cbColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbColumn);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbColumn, 170);
    }

    private void initPartNumber() {
        JLabel label = new JLabel(Messages.getString("AUXTablePropertyDialogDB2.PartNumber"));
        this.general.add(label);
        this.ifPartNumber = new JIntegerField(-1, 26);
        this.general.add(this.ifPartNumber);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.ifPartNumber, 200);
    }

    private void initPermissionsButton() {
        this.bnPermissions = new JButton(Messages.getString("AUXTablePropertyDialogDB2.Permissions"));
        this.bnPermissions.setIcon(this.getAppView().getConfiguration().getIcon("PERMISSIONS_ICON", 16));
        this.bnPermissions.addActionListener(new PermissionsListener());
        this.general.add(this.bnPermissions);
        this.setObjectConstraints(this.bnPermissions, 270, 240);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.auxTable.getName());
        this.tfName.setText(this.auxTable.getName());
        this.selectObject(this.cbOwner, this.auxTable.getOwner());
        this.selectObject(this.cbTableSpace, this.auxTable.getTableSpace());
        this.selectObject(this.cbDatabase, this.auxTable.getDatabase());
        this.selectObject(this.cbTable, this.auxTable.getTable());
        this.resetColumns(this.auxTable.getTable());
        this.selectObject(this.cbColumn, this.auxTable.getColumn());
        this.ifPartNumber.setValue((long)this.auxTable.getPartNumber());
        this.getCommentsList().insert(this.auxTable.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.auxTable != null) {
            Object selected = this.cbOwner.getSelectedItem();
            if (selected instanceof Owner) {
                this.auxTable.setOwner((Owner)selected);
            } else {
                this.auxTable.setOwner(null);
            }
            this.auxTable.setName(this.tfName.getText());
            selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceDB2) {
                this.auxTable.setTableSpace((TableSpaceDB2)selected);
            } else {
                this.auxTable.setTableSpace(null);
            }
            selected = this.cbTable.getSelectedItem();
            if (selected instanceof TableProxyDB2) {
                this.auxTable.setTable((TableProxyDB2)selected);
            } else {
                this.auxTable.setTable(null);
            }
            selected = this.cbColumn.getSelectedItem();
            if (selected instanceof ColumnProxyDB2) {
                this.auxTable.setColumn((ColumnProxyDB2)selected);
            } else {
                this.auxTable.setColumn(null);
            }
            this.auxTable.setPartNumber(this.ifPartNumber.getIntValue());
            this.auxTable.setComment(this.getCommentsList().getText());
        }
    }

    private Object[] getLobTables() {
        ArrayList<TableProxyDB2> lobTables = new ArrayList<TableProxyDB2>();
        Iterator it = this.getStorageDesign().getTableProxySet().iterator();
        while (it.hasNext()) {
            TableProxyDB2 table = (TableProxyDB2)it.next();
            if (!this.hasLobColumns(table)) continue;
            lobTables.add(table);
        }
        return lobTables.toArray();
    }

    private boolean hasLobColumns(TableProxyDB2 table) {
        ColumnProxy[] columns = table.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            ColumnProxy columnProxy = columns[i];
            if (!this.isLobColumn(columnProxy.getDataType())) continue;
            return true;
        }
        return false;
    }

    private Object[] getLobColumns(TableProxyDB2 table) {
        ArrayList<ColumnProxy> lobColumns = new ArrayList<ColumnProxy>();
        ColumnProxy[] columns = table.getColumnProxies();
        for (int i = 0; i < columns.length; ++i) {
            ColumnProxy columnProxy = columns[i];
            if (!this.isLobColumn(columnProxy.getDataType())) continue;
            lobColumns.add(columnProxy);
        }
        return lobColumns.toArray();
    }

    private boolean isLobColumn(Datatype type) {
        return type instanceof MDClob || type instanceof MDBlob || type instanceof MDDBClob;
    }

    private void resetColumns(TableProxyDB2 table) {
        if (table != null) {
            this.cbColumn.removeAllItems();
            this.cbColumn.addItem("");
            if (this.getStorageDesign() != null) {
                this.fillComboItems(this.getLobColumns(table), this.cbColumn);
            }
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Owner owner;
        Object selectedOwner = this.cbOwner.getSelectedItem();
        if (selectedOwner instanceof Owner && !(owner = (Owner)selectedOwner).isNullInstance()) {
            newName = owner.getName() + "." + (String)newName;
        }
        return this.getStorageObject().allowName((String)newName, true);
    }

    private class TableSpaceListener
    implements ActionListener {
        private TableSpaceListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            Object selected = cb.getSelectedItem();
            if (selected != null && selected instanceof TableSpaceDB2) {
                TableSpaceDB2 ts = (TableSpaceDB2)selected;
                AUXTablePropertyDialogDB2.this.cbDatabase.setSelectedItem(ts.getDataBase());
            }
        }
    }

    private class LobTableListener
    implements ActionListener {
        private LobTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            Object selected = cb.getSelectedItem();
            if (selected != null && selected instanceof TableProxyDB2) {
                AUXTablePropertyDialogDB2.this.resetColumns((TableProxyDB2)selected);
            } else {
                AUXTablePropertyDialogDB2.this.cbColumn.removeAllItems();
                AUXTablePropertyDialogDB2.this.cbColumn.addItem("");
            }
        }
    }

    private class PermissionsListener
    implements ActionListener {
        private PermissionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AUXTablePropertyDialogDB2.this.dialog == null) {
                AUXTablePropertyDialogDB2.this.dialog = new PermissionsPropertyDialogDB2(AUXTablePropertyDialogDB2.this.getAppView(), AUXTablePropertyDialogDB2.this.getStorageDesign(), AUXTablePropertyDialogDB2.this.auxTable);
            }
            AUXTablePropertyDialogDB2.this.dialog.show();
        }
    }
}

