/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.db2.FKProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.db2.v80.TableProxyDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableSpaceOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class DBMigrationDialog
extends CustomDialog {
    private JDialog dialog;
    private JButton bnCancel;
    private JButton bnOK;
    private JComboBox cbTargetST;
    private StorageDesign sourceST;
    private JCheckBox chbTableSpaces;
    private JCheckBox chbIndexes;
    private JCheckBox chbForeignKeys;
    private JProgressBar progressBar;
    private Map map;

    public DBMigrationDialog(ApplicationView appView, StorageDesign sourceST) {
        super(appView);
        this.sourceST = sourceST;
        this.add((Component)this.initGeneralPanel(), "Center");
        this.add((Component)this.initButtonsPanel(), "South");
        this.initMap();
    }

    private JPanel initGeneralPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(Messages.getString("DBMigrationDialog.SelectTargetDatabase"));
        this.cbTargetST = new JComboBox();
        this.cbTargetST.setPreferredSize(new Dimension(200, 20));
        pnTop.add(label);
        pnTop.add(this.cbTargetST);
        for (StorageDesign storageDesign : this.sourceST.getPhysicalDesign().getStorageDesignFactory().getSorageDesigns()) {
            if (!(storageDesign instanceof StorageDesignOraclev9i)) continue;
            this.cbTargetST.addItem(storageDesign);
        }
        JPanel pnMain = new JPanel(new BorderLayout(20, 20));
        JPanel pnGrid = new JPanel(new GridLayout(0, 1, 20, 20));
        pnMain.setBorder(BorderFactory.createEtchedBorder());
        this.chbTableSpaces = new JCheckBox(Messages.getString("DBMigrationDialog.TransferTableSpaces"), true);
        this.chbIndexes = new JCheckBox(Messages.getString("DBMigrationDialog.TransferIndexes"), true);
        this.chbForeignKeys = new JCheckBox(Messages.getString("DBMigrationDialog.TransferForeignKeys"), true);
        pnGrid.add(this.chbTableSpaces);
        pnGrid.add(this.chbIndexes);
        pnGrid.add(this.chbForeignKeys);
        pnMain.add((Component)new JPanel(), "North");
        pnMain.add((Component)new JPanel(), "West");
        pnMain.add((Component)pnGrid, "Center");
        this.progressBar = new JProgressBar();
        pnMain.add((Component)this.progressBar, "South");
        jpanel.add((Component)pnTop, "North");
        jpanel.add((Component)pnMain, "Center");
        return jpanel;
    }

    private JPanel initButtonsPanel() {
        JPanel pnButtons = new JPanel(new FlowLayout(2));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        pnButtons.add(this.bnOK);
        pnButtons.add(this.bnCancel);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnOK.setEnabled(this.cbTargetST.getItemCount() > 0);
        return pnButtons;
    }

    public Action createOKButton() {
        AbstractAction action = new AbstractAction(Messages.getString("DBMigrationDialog.OK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMigrationDialog.this.migrate();
                DBMigrationDialog.this.close();
            }
        };
        return action;
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("DBMigrationDialog.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMigrationDialog.this.close();
            }
        };
        return action;
    }

    public void showDialog() {
        this.getDialog().show();
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("DBMigrationDialog.DatabaseMigration"), false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void initMap() {
        this.map = new TreeMap();
        this.map.put("PCA", "CAS");
        this.map.put("PCC", "CCS");
        this.map.put("PCZ", "CCS");
        this.map.put("PFA", "AIS");
        this.map.put("PFC", "HCL");
        this.map.put("PFI", "PI");
        this.map.put("PFU", "FUS");
        this.map.put("PMN", "MNT");
        this.map.put("PRC", "ARC");
        this.map.put("PRM", "REM");
        this.map.put("DBA", "MF");
    }

    private String getOwnerName(String designName) {
        String owner = (String)this.map.get(designName.toUpperCase().trim());
        if (owner == null) {
            owner = designName;
        }
        return owner;
    }

    private void migrate() {
        StorageDesignOraclev9i target = (StorageDesignOraclev9i)this.cbTargetST.getSelectedItem();
        if (target != null && this.sourceST instanceof StorageDesignDB2v80) {
            StorageDesignDB2v80 source = (StorageDesignDB2v80)this.sourceST;
            this.progressBar.setMaximum(source.getTableProxySet().size());
            String desName = source.getPhysicalDesign().getName();
            String prefix = this.getOwnerName(desName);
            TableSpaceOraclev9i targetTS = null;
            TableSpaceOraclev9i targetIndexTS = null;
            if (this.chbTableSpaces.isSelected()) {
                targetTS = (TableSpaceOraclev9i)target.getTableSpaceSet().createTableSpace();
                targetTS.setName(prefix + "_DATA1");
            }
            if (this.chbIndexes.isSelected()) {
                targetIndexTS = (TableSpaceOraclev9i)target.getTableSpaceSet().createTableSpace();
                targetIndexTS.setName(prefix + "_INDEX1");
            }
            Iterator it = source.getTableProxySet().iterator();
            while (it.hasNext()) {
                this.progressBar.setValue(this.progressBar.getValue() + 1);
                TableProxyDB2v80 sourceProxy = (TableProxyDB2v80)it.next();
                TableProxyOracle targetProxy = (TableProxyOracle)target.getTableProxySet().getProxy(sourceProxy.getObjectID());
                if (targetProxy == null) continue;
                if (this.chbTableSpaces.isSelected()) {
                    targetProxy.setTableSpace(targetTS);
                }
                int count = 0;
                if (targetProxy.getPrimaryKeys().size() > 0) {
                    PKProxyOraclev9i pkProxy = (PKProxyOraclev9i)targetProxy.getPrimaryKeys().getElement(0);
                    pkProxy.setName(targetProxy.getName() + "_PK");
                    pkProxy.setUsingIndex(PKProxyOraclev9i.getUsingIndexChoices()[3]);
                    pkProxy.setTableSpace(targetIndexTS);
                    pkProxy.setExistingIndex(null);
                    count = 1;
                }
                if (this.chbIndexes.isSelected()) {
                    IndexProxy[] indexProxies = sourceProxy.getIndexProxies();
                    for (int i = 0; i < indexProxies.length; ++i) {
                        IndexProxy sourceIndex = indexProxies[i];
                        IndexProxyOraclev9i targetIndex = (IndexProxyOraclev9i)targetProxy.getIndexes().getById(sourceIndex.getObjectID());
                        if (targetIndex == null || targetIndex.getIndex().isPK()) continue;
                        targetIndex.setName(targetProxy.getName() + "_X" + ++count);
                        targetIndex.setTableSpace(targetIndexTS);
                    }
                }
                if (!this.chbForeignKeys.isSelected()) continue;
                Iterator fit = sourceProxy.getFkeys().iterator();
                count = 0;
                while (fit.hasNext()) {
                    FKProxyDB2 sourceFK = (FKProxyDB2)fit.next();
                    FKProxyOracle targetFK = (FKProxyOracle)targetProxy.getFKeys().getById(sourceFK.getObjectID());
                    if (targetFK == null) continue;
                    targetFK.setName(targetProxy.getName() + "_FK" + ++count);
                }
            }
        }
    }
}

