/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.relational.AbstractColumnGroupsPanel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class ColumnGroupColumnsPanel
extends AbstractColumnGroupsPanel {
    private static final long serialVersionUID = 7046246439014784518L;
    private static final int PREFERRED_HEIGHT = 145;
    private static final int PREFERRED_WIDTH = 145;
    private static final String COLUMNS = Messages.getString("ColumnGroupColumnsPanel.Columns");
    private JPanel mainPanel;
    private JButton btnAddColumns;
    private JButton btnRemoveColumns;
    private JList allColumnsList;
    private JPanel buttonsPanel;
    private JToolBar toolBar;
    private DefaultListModel allColumnsModel;
    private List<Column> selectedColumnsList;
    private JPanel pnSelected;
    private JTable selectedColumnsTable;
    private JScrollPane selectedColumnsScrollPane;
    private JScrollPane allColumnsScrollPane;
    private JPanel pnAttributes;

    public ColumnGroupColumnsPanel(Table.ColumnGroup columnGroup, boolean editable, int buttonsSize, boolean showDesc) {
        super(columnGroup, editable, buttonsSize, showDesc);
    }

    @Override
    protected void init(List<Column> alteredTableColumns) {
        this.allColumnsModel.clear();
        for (Column column : alteredTableColumns) {
            if (this.selectedColumnsList.contains(column)) continue;
            this.allColumnsModel.addElement(column);
        }
    }

    @Override
    public void init(Table.ColumnGroup columnGroup, List<Column> allTableColumns, List<Column> alteredTableColumns) {
        this.selectedColumnsList.clear();
        List<String> cgColumns = columnGroup.getColumns();
        for (int i = 0; i < cgColumns.size(); ++i) {
            String objID = cgColumns.get(i);
            for (Column c : allTableColumns) {
                if (!c.getObjectID().equalsIgnoreCase(objID)) continue;
                this.selectedColumnsList.add(c);
            }
        }
        this.init(alteredTableColumns);
        ((SelectedColumnsModel)this.selectedColumnsTable.getModel()).fireTableDataChanged();
    }

    public List<Column> getSelectedColumns() {
        return this.selectedColumnsList;
    }

    @Override
    protected void createUIComponents() {
        this.setLayout(new BorderLayout(0, 10));
        this.setName(COLUMNS);
        this.setBorder(BorderFactory.createTitledBorder(COLUMNS));
        this.selectedColumnsList = new ArrayList<Column>();
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        this.allColumnsList.setEnabled(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddColumns = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.buttonsSize));
        this.btnRemoveColumns = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.buttonsSize));
        this.buttonsPanel = new JPanel();
        this.toolBar = new JToolBar(1);
        this.toolBar.add(this.btnAddColumns);
        this.toolBar.add(this.btnRemoveColumns);
        this.buttonsPanel.add(this.toolBar);
        this.selectedColumnsTable = new JTable(new SelectedColumnsModel());
        this.selectedColumnsScrollPane = new JScrollPane(this.selectedColumnsTable);
        this.selectedColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnSelected = new JPanel(new BorderLayout());
        this.pnSelected.add(this.selectedColumnsScrollPane);
        this.allColumnsScrollPane = new JScrollPane(this.allColumnsList);
        this.allColumnsScrollPane.setPreferredSize(new Dimension(145, 145));
        this.pnAttributes = new JPanel(new BorderLayout());
        this.pnAttributes.add(this.allColumnsScrollPane);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 2));
        this.mainPanel.add(this.pnAttributes);
        this.mainPanel.add(this.buttonsPanel);
        this.mainPanel.add(this.pnSelected);
        this.add(this.mainPanel);
    }

    @Override
    protected void initUIComponents() {
        this.allColumnsList.getSelectionModel().addListSelectionListener(new AllColumnsListSelectionListener());
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new SelectedColumnsListSelectionListener());
        this.initColumnsButtons(this.mainPanel);
        this.initSelectedColumnsList(this.mainPanel);
    }

    private void initSelectedColumnsList(JPanel jpanel) {
        TableColumn col0 = this.selectedColumnsTable.getColumnModel().getColumn(0);
        col0.setWidth(220);
        this.selectedColumnsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                } else {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                }
            }
        });
    }

    private void initColumnsButtons(JPanel jpanel) {
        this.toolBar.setFloatable(false);
        this.btnAddColumns.addActionListener(new AddColumnsActionListener());
        this.btnAddColumns.setEnabled(false);
        this.btnAddColumns.setToolTipText(Messages.getString("ColumnGroupColumnsPanel.Add"));
        this.btnRemoveColumns.setEnabled(false);
        this.btnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveColumns.setToolTipText(Messages.getString("ColumnGroupColumnsPanel.Remove"));
    }

    public void onAddColumn(Column column) {
    }

    public void onRemoveColumn(Column column) {
    }

    private boolean moveToIndex(Object object, int index) {
        if (this.selectedColumnsList.contains(object) && this.selectedColumnsList.size() > index && index >= 0) {
            this.selectedColumnsList.remove(object);
            this.selectedColumnsList.add(index, (Column)object);
            return true;
        }
        return false;
    }

    public JTable getSelectedColumnsTable() {
        return this.selectedColumnsTable;
    }

    public void setSelectedColumnsTable(JTable selectedColumnsTable) {
        this.selectedColumnsTable = selectedColumnsTable;
    }

    public JScrollPane getAllColumnsScrollPane() {
        return this.allColumnsScrollPane;
    }

    public void setAllColumnsScrollPane(JScrollPane allColumnsScrollPane) {
        this.allColumnsScrollPane = allColumnsScrollPane;
    }

    public JList getAllColumnsList() {
        return this.allColumnsList;
    }

    public void setAllColumnsList(JList allColumnsList) {
        this.allColumnsList = allColumnsList;
    }

    public List<Column> getSelectedColumnsList() {
        return this.selectedColumnsList;
    }

    public void setSelectedColumnsList(List<Column> selectedColumnsList) {
        this.selectedColumnsList = selectedColumnsList;
    }

    public class SelectedColumnsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8480891404209029651L;
        private String[] COL_NAMES = new String[]{Messages.getString("ColumnGroupColumnsPanel.Column")};

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ColumnGroupColumnsPanel.this.selectedColumnsList.size();
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Column column = ColumnGroupColumnsPanel.this.selectedColumnsList.get(row);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Column column = ColumnGroupColumnsPanel.this.selectedColumnsList.get(row);
            if (col == 0) {
                return column.getName();
            }
            return "";
        }

        public void clearList() {
            ColumnGroupColumnsPanel.this.selectedColumnsList.clear();
        }
    }

    private class AllColumnsListSelectionListener
    implements ListSelectionListener {
        private AllColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ColumnGroupColumnsPanel.this.editable && !e.getValueIsAdjusting()) {
                if (ColumnGroupColumnsPanel.this.allColumnsList.getSelectedIndex() == -1) {
                    ColumnGroupColumnsPanel.this.btnAddColumns.setEnabled(false);
                } else {
                    ColumnGroupColumnsPanel.this.btnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class SelectedColumnsListSelectionListener
    implements ListSelectionListener {
        private SelectedColumnsListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (ColumnGroupColumnsPanel.this.editable && !e.getValueIsAdjusting()) {
                if (ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRow() == -1) {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(false);
                } else {
                    ColumnGroupColumnsPanel.this.btnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    public class AddColumnsActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ColumnGroupColumnsPanel.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = ColumnGroupColumnsPanel.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Column column = (Column)selectedObjects[i];
                    if (ColumnGroupColumnsPanel.this.selectedColumnsList.contains(column)) continue;
                    ColumnGroupColumnsPanel.this.selectedColumnsList.add(column);
                    ColumnGroupColumnsPanel.this.allColumnsModel.removeElement(column);
                }
            }
            ColumnGroupColumnsPanel.this.allColumnsList.getSelectionModel().clearSelection();
            ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
            ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(ColumnGroupColumnsPanel.this.selectedColumnsTable.getRowCount() - 1, ColumnGroupColumnsPanel.this.selectedColumnsTable.getRowCount() - 1);
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] selected = ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            for (i = 0; i < selected.length; ++i) {
                Column column = ColumnGroupColumnsPanel.this.selectedColumnsList.get(selected[i]);
                if (ColumnGroupColumnsPanel.this.allColumnsModel.contains(column)) continue;
                ColumnGroupColumnsPanel.this.allColumnsModel.addElement(column);
                ColumnGroupColumnsPanel.this.allColumnsList.setSelectedValue(column, true);
            }
            for (i = selected.length - 1; i >= 0; --i) {
                ColumnGroupColumnsPanel.this.onRemoveColumn(ColumnGroupColumnsPanel.this.selectedColumnsList.remove(selected[i]));
            }
            ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
            ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().clearSelection();
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < ColumnGroupColumnsPanel.this.selectedColumnsList.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Column obj = ColumnGroupColumnsPanel.this.selectedColumnsList.get(objectNumber);
                    ColumnGroupColumnsPanel.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
                ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(objectNumber + 1, objectNumber + 1);
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectedRows();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Column obj = ColumnGroupColumnsPanel.this.selectedColumnsList.get(objectNumber);
                    ColumnGroupColumnsPanel.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                ColumnGroupColumnsPanel.this.selectedColumnsTable.updateUI();
                ColumnGroupColumnsPanel.this.selectedColumnsTable.getSelectionModel().setSelectionInterval(objectNumber - 1, objectNumber - 1);
            }
        }
    }
}

