/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.swingui.editor.process.TransformationPropertiesDialogEx;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TranformationTaskPropertiesDialog
extends CustomDialog
implements AbstractEditorConstants {
    private TransformationTask task;
    private JTabbedPane tpane;
    protected JPanel generalPanel;
    protected JPanel rpPanel = new JPanel();
    protected JPanel docPanel = new JPanel();
    protected JLabel lbName;
    protected JTextField tfName;
    private JTextArea taComment;
    private JButton bnCancel;
    private JCheckBox chbVisible;
    protected JTable docTable;
    protected List docList = new ArrayList();
    protected JTable rpTable;
    protected List rpList = new ArrayList();
    protected JScrollPane rpPane;
    protected JScrollPane docPane;
    private JPanel sourcePanel;
    private JPanel targetPanel;
    private JPanel primaryPanel;
    private JList selectedSourcesList;
    private JList allSourcesList;
    private DefaultListModel allSourcesModel;
    private DefaultListModel selectedSourcesModel;
    private JButton btnAddSources;
    private JButton btnRemoveSources;
    private JList selectedTargetsList;
    private JList allTargetsList;
    private DefaultListModel allTargetsModel;
    private DefaultListModel selectedTargetsModel;
    private JButton btnAddTargets;
    private JButton btnRemoveTargets;
    private DefaultListModel primaryModel;
    private JList primaryList;
    private JDialog dialog;
    private JButton bnOK;

    public TranformationTaskPropertiesDialog(ApplicationView view, TransformationTask object) {
        super(view);
        this.task = object;
        this.setLayout(new BorderLayout());
        this.tpane = new JTabbedPane();
        this.tpane.setPreferredSize(new Dimension(400, 280));
        this.initGeneralView();
        this.add((Component)this.tpane, "Center");
        JPanel bottomPanel = new JPanel();
        this.bnOK = new JButton(BTN_OK);
        this.bnOK.addActionListener(new OKAction());
        this.bnOK.setMnemonic(79);
        JButton btnApply = new JButton(BTN_APPLY);
        btnApply.addActionListener(new ApplyAction());
        btnApply.setMnemonic(65);
        this.bnCancel = new JButton(BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(this.bnOK);
        bottomPanel.add(btnApply);
        bottomPanel.add(this.bnCancel);
        bottomPanel.add(bnHelp);
        this.add((Component)bottomPanel, "South");
    }

    public String getCaption() {
        return Messages.getString("TranformationTaskPropertiesDialog.TransformationPackageProperties");
    }

    @Override
    protected void close() {
        this.task.setDialogVisible(false, null);
        this.getDialog().dispose();
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.getContentPane().add(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "TRANSFORMATION_TASK_PROPERTIES_DIALOG";
    }

    protected void initGeneralView() {
        this.generalPanel = new JPanel(new SpringLayout());
        this.tpane.addTab(Messages.getString("TranformationTaskPropertiesDialog.General"), this.generalPanel);
        JLabel lbName = new JLabel(LB_NAME);
        CommonUtil.setLabelConstraints((SpringLayout)this.generalPanel.getLayout(), lbName, 5, 5);
        this.generalPanel.add(lbName);
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(325, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.generalPanel.getLayout(), this.tfName, 100, 5);
        this.generalPanel.add(this.tfName);
        JLabel lbComment = new JLabel(LB_COMMENT);
        CommonUtil.setLabelConstraints((SpringLayout)this.generalPanel.getLayout(), lbComment, 5, 35);
        this.generalPanel.add(lbComment);
        this.taComment = new JTextArea();
        this.taComment.setPreferredSize(new Dimension(325, 100));
        CommonUtil.setObjectConstraints((SpringLayout)this.generalPanel.getLayout(), this.taComment, 100, 35);
        this.generalPanel.add(this.taComment);
        JLabel lbVisible = new JLabel(LB_VISIBLE);
        CommonUtil.setLabelConstraints((SpringLayout)this.generalPanel.getLayout(), lbVisible, 5, 145);
        this.generalPanel.add(lbVisible);
        this.chbVisible = new JCheckBox();
        CommonUtil.setObjectConstraints((SpringLayout)this.generalPanel.getLayout(), this.chbVisible, 100, 145);
        this.generalPanel.add(this.chbVisible);
        this.initSourcesTab();
        this.initTargetsTab();
        this.initPrimaryTab();
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    public void initProperties(ModelIDObject object) {
        if (object instanceof TransformationTask) {
            InfoStore s;
            this.task = (TransformationTask)object;
            this.tfName.setText(this.task.getName());
            this.taComment.setText(this.task.getComment());
            ((JDialog)this.getDialog()).setTitle(this.task.getName());
            this.task.setDialogVisible(true, (JDialog)this.getDialog());
            this.chbVisible.setSelected(this.task.isMainViewVisible());
            Iterator sources = this.task.getInfoStoreSet().iterator();
            List selectedSources = this.task.getSources();
            while (sources.hasNext()) {
                s = (InfoStore)sources.next();
                if (selectedSources.contains(s)) {
                    this.selectedSourcesModel.addElement(s);
                    continue;
                }
                this.allSourcesModel.addElement(s);
            }
            Iterator targets = this.task.getInfoStoreSet().iterator();
            List selectedTargets = this.task.getTargets();
            while (targets.hasNext()) {
                s = (InfoStore)targets.next();
                if (selectedTargets.contains(s)) {
                    this.selectedTargetsModel.addElement(s);
                    continue;
                }
                this.allTargetsModel.addElement(s);
            }
            Iterator it = this.task.getTransformationSet().iterator();
            while (it.hasNext()) {
                Transformation tr = (Transformation)it.next();
                if (!tr.isPrimary()) continue;
                this.primaryModel.addElement(tr);
            }
        }
    }

    private void initPrimaryTab() {
        this.primaryPanel = new JPanel();
        this.tpane.addTab(Messages.getString("TranformationTaskPropertiesDialog.PrimaryTransformations"), this.primaryPanel);
        this.initPrimaryList();
    }

    private void initPrimaryList() {
        JPanel jp = new JPanel(new BorderLayout());
        jp.setBorder(BorderFactory.createEmptyBorder());
        this.primaryModel = new DefaultListModel();
        this.primaryList = new JList(this.primaryModel);
        this.primaryList.addMouseListener(new PrimaryListener());
        JScrollPane sp = new JScrollPane(this.primaryList);
        sp.setPreferredSize(new Dimension(420, 257));
        jp.add(sp);
        this.primaryPanel.add(jp);
    }

    protected SpringLayout getSourcesLayout() {
        return (SpringLayout)this.sourcePanel.getLayout();
    }

    protected SpringLayout getPrimaryLayout() {
        return (SpringLayout)this.primaryPanel.getLayout();
    }

    private void initSourcesTab() {
        this.sourcePanel = new JPanel();
        this.sourcePanel.setLayout(new BoxLayout(this.sourcePanel, 2));
        this.tpane.addTab(Messages.getString("TranformationTaskPropertiesDialog.Sources"), this.sourcePanel);
        this.initAllSourcesList();
        this.initSourcesButtons();
        this.initSelectedSourcesList();
    }

    private void initAllSourcesList() {
        JPanel jp1 = new JPanel(new BorderLayout());
        jp1.setBorder(BorderFactory.createTitledBorder(Messages.getString("TranformationTaskPropertiesDialog.All")));
        this.allSourcesModel = new DefaultListModel();
        this.allSourcesList = new JList(this.allSourcesModel);
        ListSelectionModel listSelectionModel = this.allSourcesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllSourcesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSourcesList);
        sp.setPreferredSize(new Dimension(162, 223));
        jp1.add(sp);
        this.sourcePanel.add(jp1);
    }

    private void initSelectedSourcesList() {
        JPanel jp1 = new JPanel(new BorderLayout());
        jp1.setBorder(BorderFactory.createTitledBorder(Messages.getString("TranformationTaskPropertiesDialog.Selected")));
        this.selectedSourcesModel = new DefaultListModel();
        this.selectedSourcesList = new JList(this.selectedSourcesModel);
        ListSelectionModel listSelectionModel = this.selectedSourcesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedSourcesListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSourcesList);
        sp.setPreferredSize(new Dimension(162, 223));
        jp1.add(sp);
        this.sourcePanel.add(jp1);
    }

    private void initSourcesButtons() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddSources = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddSources.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Add"));
        this.btnAddSources.addActionListener(new AddSourcesActionListener());
        this.btnAddSources.setEnabled(false);
        this.btnAddSources.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveSources = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveSources.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Remove"));
        this.btnRemoveSources.setEnabled(false);
        this.btnRemoveSources.addActionListener(new RemoveSourcesActionListener());
        this.btnRemoveSources.setPreferredSize(new Dimension(32, 32));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.btnAddSources);
        verticalBox.add(this.btnRemoveSources);
        verticalBox.add(Box.createVerticalGlue());
        this.sourcePanel.add(verticalBox);
    }

    protected SpringLayout getTargetsLayout() {
        return (SpringLayout)this.targetPanel.getLayout();
    }

    private void initTargetsTab() {
        this.targetPanel = new JPanel();
        this.targetPanel.setLayout(new BoxLayout(this.targetPanel, 2));
        this.tpane.addTab(Messages.getString("TranformationTaskPropertiesDialog.Targets"), this.targetPanel);
        this.initAllTargetsList();
        this.initTargetsButtons();
        this.initSelectedTargetsList();
    }

    private void initAllTargetsList() {
        JPanel jp1 = new JPanel(new BorderLayout());
        jp1.setBorder(BorderFactory.createTitledBorder(Messages.getString("TranformationTaskPropertiesDialog.All")));
        this.allTargetsModel = new DefaultListModel();
        this.allTargetsList = new JList(this.allTargetsModel);
        ListSelectionModel listSelectionModel = this.allTargetsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllTargetsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allTargetsList);
        sp.setPreferredSize(new Dimension(162, 223));
        jp1.add(sp);
        this.targetPanel.add(jp1);
    }

    private void initSelectedTargetsList() {
        JPanel jp1 = new JPanel(new BorderLayout());
        jp1.setBorder(BorderFactory.createTitledBorder(Messages.getString("TranformationTaskPropertiesDialog.Selected")));
        this.selectedTargetsModel = new DefaultListModel();
        this.selectedTargetsList = new JList(this.selectedTargetsModel);
        ListSelectionModel listSelectionModel = this.selectedTargetsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedTargetsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedTargetsList);
        sp.setPreferredSize(new Dimension(162, 223));
        jp1.add(sp);
        this.targetPanel.add(jp1);
    }

    private void initTargetsButtons() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddTargets = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddTargets.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Add"));
        this.btnAddTargets.addActionListener(new AddTargetsActionListener());
        this.btnAddTargets.setEnabled(false);
        this.btnAddTargets.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveTargets = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveTargets.setToolTipText(Messages.getString("TranformationTaskPropertiesDialog.Remove"));
        this.btnRemoveTargets.setEnabled(false);
        this.btnRemoveTargets.addActionListener(new RemoveTargetsActionListener());
        this.btnRemoveTargets.setPreferredSize(new Dimension(32, 32));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.btnAddTargets);
        verticalBox.add(this.btnRemoveTargets);
        verticalBox.add(Box.createVerticalGlue());
        this.targetPanel.add(verticalBox);
    }

    public String getNotesField() {
        return null;
    }

    public String getSynonymField() {
        return null;
    }

    public void setNotesField(String notesField) {
    }

    public void setSynonymField(String synonymField) {
    }

    protected void setProperties() {
        this.task.setName(this.tfName.getText());
        this.task.setComment(this.taComment.getText());
        Object[] sourcesSet = this.selectedSourcesModel.toArray();
        this.task.removeAllSources();
        for (int i = 0; i < sourcesSet.length; ++i) {
            Object ob = sourcesSet[i];
            if (!(ob instanceof InfoStore)) continue;
            this.task.addSource((InfoStore)ob);
        }
        Object[] targetsSet = this.selectedTargetsModel.toArray();
        this.task.removeAllTargets();
        for (int i = 0; i < targetsSet.length; ++i) {
            Object ob = targetsSet[i];
            if (!(ob instanceof InfoStore)) continue;
            this.task.addTarget((InfoStore)ob);
        }
        this.task.setMainViewVisible(this.chbVisible.isSelected());
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranformationTaskPropertiesDialog.this.setProperties();
            TranformationTaskPropertiesDialog.this.task.setDirty(true);
            TranformationTaskPropertiesDialog.this.close();
        }
    }

    private class ApplyAction
    implements ActionListener {
        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranformationTaskPropertiesDialog.this.setProperties();
            TranformationTaskPropertiesDialog.this.task.setDirty(true);
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TranformationTaskPropertiesDialog.this.close();
        }
    }

    private class PrimaryListener
    extends MouseAdapter {
        private PrimaryListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Transformation selected;
            if (e.getClickCount() == 2 && (selected = (Transformation)TranformationTaskPropertiesDialog.this.primaryList.getSelectedValue()) != null && !selected.isDialogVisible()) {
                TransformationPropertiesDialogEx dialog = new TransformationPropertiesDialogEx(TranformationTaskPropertiesDialog.this.task.getDesign().getAppView(), selected);
                dialog.initProperties(selected);
                dialog.show();
            }
        }
    }

    private class AllSourcesListSelectionHandler
    implements ListSelectionListener {
        private AllSourcesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.allSourcesList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnAddSources.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnAddSources.setEnabled(true);
                }
            }
        }
    }

    private class SelectedSourcesListSelectionHandler
    implements ListSelectionListener {
        private SelectedSourcesListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.selectedSourcesList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnRemoveSources.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnRemoveSources.setEnabled(true);
                }
            }
        }
    }

    private class AddSourcesActionListener
    implements ActionListener {
        private AddSourcesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TranformationTaskPropertiesDialog.this.allSourcesModel.isEmpty()) {
                Object[] selectedObjects = TranformationTaskPropertiesDialog.this.allSourcesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TranformationTaskPropertiesDialog.this.selectedSourcesModel.contains(ob)) continue;
                    TranformationTaskPropertiesDialog.this.selectedSourcesModel.addElement(ob);
                    TranformationTaskPropertiesDialog.this.allSourcesModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveSourcesActionListener
    implements ActionListener {
        private RemoveSourcesActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TranformationTaskPropertiesDialog.this.selectedSourcesModel.isEmpty()) {
                Object[] selectedObjects = TranformationTaskPropertiesDialog.this.selectedSourcesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TranformationTaskPropertiesDialog.this.allSourcesModel.contains(ob)) continue;
                    TranformationTaskPropertiesDialog.this.allSourcesModel.addElement(ob);
                    TranformationTaskPropertiesDialog.this.selectedSourcesModel.removeElement(ob);
                }
            }
        }
    }

    private class AllTargetsListSelectionHandler
    implements ListSelectionListener {
        private AllTargetsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.allTargetsList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnAddTargets.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnAddTargets.setEnabled(true);
                }
            }
        }
    }

    private class SelectedTargetsListSelectionHandler
    implements ListSelectionListener {
        private SelectedTargetsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (TranformationTaskPropertiesDialog.this.selectedTargetsList.getSelectedIndex() == -1) {
                    TranformationTaskPropertiesDialog.this.btnRemoveTargets.setEnabled(false);
                } else {
                    TranformationTaskPropertiesDialog.this.btnRemoveTargets.setEnabled(true);
                }
            }
        }
    }

    private class AddTargetsActionListener
    implements ActionListener {
        private AddTargetsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TranformationTaskPropertiesDialog.this.allTargetsModel.isEmpty()) {
                Object[] selectedObjects = TranformationTaskPropertiesDialog.this.allTargetsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TranformationTaskPropertiesDialog.this.selectedTargetsModel.contains(ob)) continue;
                    TranformationTaskPropertiesDialog.this.selectedTargetsModel.addElement(ob);
                    TranformationTaskPropertiesDialog.this.allTargetsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveTargetsActionListener
    implements ActionListener {
        private RemoveTargetsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TranformationTaskPropertiesDialog.this.selectedTargetsModel.isEmpty()) {
                Object[] selectedObjects = TranformationTaskPropertiesDialog.this.selectedTargetsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TranformationTaskPropertiesDialog.this.allTargetsModel.contains(ob)) continue;
                    TranformationTaskPropertiesDialog.this.allTargetsModel.addElement(ob);
                    TranformationTaskPropertiesDialog.this.selectedTargetsModel.removeElement(ob);
                }
            }
        }
    }
}

