/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.model.design.process.InfoStore;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.process.ExternalDataPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.gui.swing.JCharField;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.dbtools.crest.util.gui.swing.LNComboTableCellRenderer;

public class StorePropertiesDialogEx
extends AbstractPropertiesDialog {
    private InfoStore store;
    private JTextField tfSynonym;
    private JComboBox cbType;
    private JComboBox cbRDBMS;
    private JTextField tfObjectType;
    private JTextField tfImplementationName;
    private JTextField tfScope;
    private List aList;
    private List eList;
    private List ifList;
    private JPanel pnAttributes;
    private JTable aTable;
    private EntityTable eTable;
    private JPanel pnEntity;
    private JPanel pnProcess;
    private List pList;
    private JTable pTable;
    private JTable iftable;
    private JPanel pnInfoFlow;
    private JPanel pnSystemObjective;
    private JEditorPane editorPane;
    private JTextField tfOwner;
    private JPanel pnDataFile;
    private JPanel pnDataFileGrid;
    private JTextField tfSource;
    private JTextField tfFileName;
    private JTextField tfLocation;
    private JComboBox cbFileType;
    private JCharField tfFieldSeparator;
    private JComboBox cbTransferType;
    private JCheckBox chSelfDescribing;
    private JIntegerField tfSkipRecords;
    private JCharField tfTextDelimiter;
    private JPanel pnDataElement;
    private List dList;
    private JTable edTable;
    private List newExtDatas;
    private JButton btnDEAdd;
    private JButton btnDERemove;
    private JButton btnDEProperties;
    private JButton btnAttributeProperties;
    private JButton btnEntityProperties;
    private JButton btnProcessProperties;
    private JButton btnInformationFlowProperties;

    public StorePropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(InfoStore.INFOSTORE_TYPES_DISPLAY);
        this.cbType.setFont(this.cbType.getFont().deriveFont(0));
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbType, this.cbType));
        JLabel lbRDBMS = new JLabel(LB_RDBMS_TYPE);
        lbRDBMS.setPreferredSize(this.getDefaultSize());
        this.cbRDBMS = new JComboBox<Object>(this.getRDBMSSites());
        this.cbRDBMS.setSelectedItem(this.getDefaultRDBMSSite());
        this.cbRDBMS.setFont(this.cbRDBMS.getFont().deriveFont(0));
        this.cbRDBMS.setPreferredSize(this.getDefaultSize());
        this.cbRDBMS.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbRDBMS, this.cbRDBMS));
        JLabel lbObjectType = new JLabel(LB_OBJECT_TYPE);
        lbObjectType.setPreferredSize(this.getDefaultSize());
        this.tfObjectType = new JTextField();
        this.tfObjectType.setPreferredSize(this.getDefaultSize());
        this.tfObjectType.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbObjectType, this.tfObjectType));
        JLabel lbImplementationName = new JLabel(LB_IMPLEMENTATION_NAME);
        lbImplementationName.setPreferredSize(this.getDefaultSize());
        this.tfImplementationName = new JTextField();
        this.tfImplementationName.setPreferredSize(this.getDefaultSize());
        this.tfImplementationName.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbImplementationName, this.tfImplementationName));
        JLabel lbScope = new JLabel(LB_SCOPE);
        lbScope.setPreferredSize(this.getDefaultSize());
        this.tfScope = new JTextField();
        this.tfScope.setPreferredSize(this.getDefaultSize());
        this.tfScope.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbScope, this.tfScope));
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = ((JComboBox)e.getSource()).getSelectedIndex();
                String type = InfoStore.INFOSTORE_TYPES_INTERNAL[sel];
                if (type.equalsIgnoreCase("RDBMS")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setSelectedItem(StorePropertiesDialogEx.this.getDefaultRDBMSSite());
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(true);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(true);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(false);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(false);
                    StorePropertiesDialogEx.this.enableControls();
                } else if (type.equalsIgnoreCase("Object")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(false);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(true);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(true);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(false);
                    StorePropertiesDialogEx.this.enableControls();
                } else if (type.equalsIgnoreCase("Temporary")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(false);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(false);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(false);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(true);
                    StorePropertiesDialogEx.this.enableControls();
                } else if (type.equalsIgnoreCase("File")) {
                    StorePropertiesDialogEx.this.cbRDBMS.setEnabled(false);
                    StorePropertiesDialogEx.this.tfObjectType.setEnabled(false);
                    StorePropertiesDialogEx.this.tfImplementationName.setEnabled(false);
                    StorePropertiesDialogEx.this.tfScope.setEnabled(false);
                    StorePropertiesDialogEx.this.enableControls();
                }
            }
        });
    }

    private Object[] getRDBMSSites() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.getDesignObject().getDesign().getRDBMSSiteSet().iterator();
        while (it.hasNext()) {
            list.add(((RDBMSSite)it.next()).getName());
        }
        return list.toArray();
    }

    private String getDefaultRDBMSSite() {
        String s = this.getDesignObject().getDesign().getRDBMSSiteSet().getDefaultRDBMSSite(this.getAppView().getSettings()).getName();
        return s;
    }

    @Override
    public String getCaption() {
        return Messages.getString("StorePropertiesDialogEx.InformationStoreProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof InfoStore) {
            this.store = (InfoStore)object;
            this.initDefaults(false);
            this.tfSynonym.setText(this.store.getSynonym());
            this.cbType.setSelectedItem(this.translate(this.store.getType(), InfoStore.INFOSTORE_TYPES_INTERNAL, InfoStore.INFOSTORE_TYPES_DISPLAY));
            if (!"".equals(this.store.getRdbmsSite())) {
                this.cbRDBMS.setSelectedItem(this.store.getRdbmsSite());
            } else {
                this.cbRDBMS.setSelectedItem(this.getDefaultRDBMSSite());
            }
            this.tfObjectType.setText(this.store.getObjectType());
            this.tfImplementationName.setText(this.store.getImplementationName());
            this.tfScope.setText(this.store.getScope());
            this.aList.addAll(this.store.getAttributes());
            this.ifList.addAll(this.store.getIncomingFlows());
            this.ifList.addAll(this.store.getOutgoingFlows());
            this.pList.addAll(this.store.getProcesses());
            this.editorPane.setText(this.store.getSystemObjective());
            this.tfOwner.setText(this.store.getOwner());
            this.tfSource.setText(this.store.getSource());
            this.tfFileName.setText(this.store.getFileName());
            this.tfLocation.setText(this.store.getLocation());
            this.cbFileType.setSelectedItem(this.translate(this.store.getFileType(), InfoStore.FILE_TYPES_INTERNAL, InfoStore.FILE_TYPES_DISPLAY));
            this.tfFieldSeparator.setText(this.store.getFieldSeparator());
            this.cbTransferType.setSelectedItem(this.translate(this.store.getTransferType(), InfoStore.TRANSFER_TYPES_INTERNAL, InfoStore.TRANSFER_TYPES_DISPLAY));
            this.tfSkipRecords.setValue((long)this.store.getSkipRecords());
            this.tfTextDelimiter.setText(this.store.getTextDelimiter());
            this.chSelfDescribing.setSelected(this.store.isSelfDescribing());
            this.dList.addAll(this.store.getDatas());
            this.updateEntityList();
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.store.setName(this.tfName.getText());
        this.store.setNotes(this.taNotes.getText());
        this.store.setComment(this.taComments.getText());
        this.store.setSynonym(this.tfSynonym.getText());
        this.store.setSystemObjective(this.editorPane.getText());
        this.store.setType(this.translate((String)this.cbType.getSelectedItem(), InfoStore.INFOSTORE_TYPES_DISPLAY, InfoStore.INFOSTORE_TYPES_INTERNAL));
        if ("RDBMS".equalsIgnoreCase(InfoStore.INFOSTORE_TYPES_INTERNAL[this.cbType.getSelectedIndex()])) {
            this.store.setRdbmsSite((String)this.cbRDBMS.getSelectedItem());
        }
        if (this.tfObjectType.isEnabled()) {
            this.store.setObjectType(this.tfObjectType.getText());
        } else {
            this.store.setObjectType("");
        }
        if (this.tfImplementationName.isEnabled()) {
            this.store.setImplementationName(this.tfImplementationName.getText());
        } else {
            this.store.setImplementationName("");
        }
        if (this.tfScope.isEnabled()) {
            this.store.setScope(this.tfScope.getText());
        } else {
            this.store.setScope("");
        }
        if ("File".equalsIgnoreCase(InfoStore.INFOSTORE_TYPES_INTERNAL[this.cbType.getSelectedIndex()])) {
            this.store.setOwner(this.tfOwner.getText());
            this.store.setSource(this.tfSource.getText());
            this.store.setFileName(this.tfFileName.getText());
            this.store.setLocation(this.tfLocation.getText());
            this.store.setFileType(this.translate((String)this.cbFileType.getSelectedItem(), InfoStore.FILE_TYPES_DISPLAY, InfoStore.FILE_TYPES_INTERNAL));
            this.store.setFieldSeparator(this.tfFieldSeparator.getText());
            this.store.setTransferType(this.translate((String)this.cbTransferType.getSelectedItem(), InfoStore.TRANSFER_TYPES_DISPLAY, InfoStore.TRANSFER_TYPES_INTERNAL));
            this.store.setSelfDescribing(this.chSelfDescribing.isSelected());
            this.store.setSkipRecords(this.tfSkipRecords.getIntValue());
            this.store.setTextDelimiter(this.tfTextDelimiter.getText());
            this.store.getDatas().clear();
            for (ExternalData data : this.dList) {
                this.store.addData(data);
            }
        } else {
            this.store.setOwner("");
            this.store.setSource("");
            this.store.setFileName("");
            this.store.setLocation("");
            this.store.setFileType("");
            this.store.setFieldSeparator("");
            this.store.setTransferType("");
            this.store.setSelfDescribing(false);
            this.store.setSkipRecords(0);
            this.store.setTextDelimiter("");
            this.store.getDatas().clear();
        }
        this.store.getEntityImplementations().clear();
        for (int i = 0; i < this.eList.size(); ++i) {
            Entity entity = (Entity)this.eList.get(i);
            Object impl = ((JComboBox)this.eTable.getModel().getValueAt(i, 1)).getSelectedItem();
            this.store.addEntityImpl(entity, impl);
        }
        this.updateEntityList();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.newExtDatas.clear();
        StorePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.store.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.store.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getEntityPanel());
        this.addToTree(root, this.getProcessPanel());
        this.addToTree(root, this.getInformationFlowsPanel());
        this.addToTree(root, this.getSystemObjectivePanel());
        this.addToTree(root, this.getDataFileSpecPanel());
        this.addToTree(root, this.getDataElementsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "INFORMATION_STORE_PROPERTIES_DIALOG";
    }

    private JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = this.createPage(Messages.getString("StorePropertiesDialogEx.Attributes"));
            this.aList = new ArrayList();
            this.aTable = new JTable(new AttributesModel());
            this.aTable.setSelectionMode(0);
            this.aTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = StorePropertiesDialogEx.this.aTable.getSelectedRow();
                    if (row > -1) {
                        if (e.getClickCount() == 2 && StorePropertiesDialogEx.this.aList.size() > 0 && row < StorePropertiesDialogEx.this.aList.size()) {
                            Attribute attribute = (Attribute)StorePropertiesDialogEx.this.aList.get(row);
                            attribute.showPropertyDialog();
                        }
                        StorePropertiesDialogEx.this.btnAttributeProperties.setEnabled(true);
                    } else {
                        StorePropertiesDialogEx.this.btnAttributeProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.aTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnAttributeProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnAttributeProperties.setEnabled(false);
            this.btnAttributeProperties.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            this.btnAttributeProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = StorePropertiesDialogEx.this.aTable.getSelectedRow();
                    if (row > -1 && StorePropertiesDialogEx.this.aList.size() > 0 && row < StorePropertiesDialogEx.this.aList.size()) {
                        Attribute attribute = (Attribute)StorePropertiesDialogEx.this.aList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnAttributeProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnAttributes.add(aPanel);
        }
        return this.pnAttributes;
    }

    private JPanel getEntityPanel() {
        if (this.pnEntity == null) {
            this.pnEntity = this.createPage(Messages.getString("StorePropertiesDialogEx.Entities"));
            this.eList = new ArrayList();
            this.eTable = new EntityTable();
            this.eTable.setSelectionMode(0);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = StorePropertiesDialogEx.this.eTable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && StorePropertiesDialogEx.this.eList.size() > 0 && row < StorePropertiesDialogEx.this.eList.size()) {
                            Entity entity = (Entity)StorePropertiesDialogEx.this.eList.get(row);
                            entity.showPropertyDialog();
                        }
                        StorePropertiesDialogEx.this.btnEntityProperties.setEnabled(true);
                    } else {
                        StorePropertiesDialogEx.this.btnEntityProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.eTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnEntityProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnEntityProperties.setEnabled(false);
            this.btnEntityProperties.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            this.btnEntityProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = StorePropertiesDialogEx.this.eTable.getSelectedRow();
                    if (row != -1 && StorePropertiesDialogEx.this.eList.size() > 0 && row < StorePropertiesDialogEx.this.eList.size()) {
                        Entity entity = (Entity)StorePropertiesDialogEx.this.eList.get(row);
                        entity.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnEntityProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel ePanel = new JPanel(new BorderLayout());
            ePanel.add((Component)buttonGeneral, "North");
            ePanel.add(scrollpane);
            this.pnEntity.add(ePanel);
        }
        return this.pnEntity;
    }

    private JPanel getProcessPanel() {
        if (this.pnProcess == null) {
            this.pnProcess = this.createPage(Messages.getString("StorePropertiesDialogEx.Processes"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new ProcessTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int row = StorePropertiesDialogEx.this.pTable.getSelectedRow();
                        if (row != -1) {
                            if (e.getClickCount() == 2 && StorePropertiesDialogEx.this.pList.size() > 0 && row < StorePropertiesDialogEx.this.pList.size()) {
                                Process process = (Process)StorePropertiesDialogEx.this.pList.get(row);
                                process.showPropertyDialog();
                            }
                            StorePropertiesDialogEx.this.btnProcessProperties.setEnabled(true);
                        } else {
                            StorePropertiesDialogEx.this.btnProcessProperties.setEnabled(false);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.pTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnProcessProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnProcessProperties.setEnabled(false);
            this.btnProcessProperties.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            this.btnProcessProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = StorePropertiesDialogEx.this.pTable.getSelectedRow();
                    if (row != -1 && StorePropertiesDialogEx.this.pList.size() > 0 && row < StorePropertiesDialogEx.this.pList.size()) {
                        Process process = (Process)StorePropertiesDialogEx.this.pList.get(row);
                        process.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnProcessProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnProcess.add(pPanel);
        }
        return this.pnProcess;
    }

    private JPanel getInformationFlowsPanel() {
        if (this.pnInfoFlow == null) {
            this.pnInfoFlow = this.createPage(Messages.getString("StorePropertiesDialogEx.InformationFlows"));
            this.ifList = new ArrayList();
            this.iftable = new JTable(new InformationFlowsModel());
            this.iftable.setSelectionMode(0);
            this.iftable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row = StorePropertiesDialogEx.this.iftable.getSelectedRow();
                    if (row != -1) {
                        if (e.getClickCount() == 2 && StorePropertiesDialogEx.this.ifList.size() > 0 && row < StorePropertiesDialogEx.this.ifList.size()) {
                            Flow flow = (Flow)StorePropertiesDialogEx.this.ifList.get(row);
                            flow.showPropertyDialog();
                        }
                        StorePropertiesDialogEx.this.btnInformationFlowProperties.setEnabled(true);
                    } else {
                        StorePropertiesDialogEx.this.btnInformationFlowProperties.setEnabled(false);
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.iftable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnInformationFlowProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnInformationFlowProperties.setEnabled(false);
            this.btnInformationFlowProperties.setToolTipText(Messages.getString("StorePropertiesDialogEx.Properties"));
            this.btnInformationFlowProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = StorePropertiesDialogEx.this.iftable.getSelectedRow();
                    if (row != -1 && StorePropertiesDialogEx.this.ifList.size() > 0 && row < StorePropertiesDialogEx.this.ifList.size()) {
                        Flow flow = (Flow)StorePropertiesDialogEx.this.ifList.get(row);
                        flow.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnInformationFlowProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel ifPanel = new JPanel(new BorderLayout());
            ifPanel.add((Component)buttonGeneral, "North");
            ifPanel.add(scrollpane);
            this.pnInfoFlow.add(ifPanel);
        }
        return this.pnInfoFlow;
    }

    private JPanel getSystemObjectivePanel() {
        if (this.pnSystemObjective == null) {
            this.pnSystemObjective = this.createPage(Messages.getString("StorePropertiesDialogEx.SystemObjective"));
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(340, 140));
            JScrollPane scrollPane = new JScrollPane(this.editorPane);
            scrollPane.setPreferredSize(new Dimension(335, 343));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add(scrollPane);
            this.pnSystemObjective.add(panel);
        }
        return this.pnSystemObjective;
    }

    private JPanel getDataFileSpecPanel() {
        if (this.pnDataFile == null) {
            this.pnDataFile = this.createPage(Messages.getString("StorePropertiesDialogEx.DataFileSpecification"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnDataFileGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbOwner = new JLabel(LB_OWNER);
            lbOwner.setPreferredSize(this.getDefaultSize());
            this.tfOwner = new JTextField();
            this.tfOwner.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbOwner, this.tfOwner));
            JLabel lbSource = new JLabel(LB_SOURCE);
            lbSource.setPreferredSize(this.getDefaultSize());
            this.tfSource = new JTextField();
            this.tfSource.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbSource, this.tfSource));
            JLabel lbFileName = new JLabel(LB_FILE_NAME);
            lbFileName.setPreferredSize(this.getDefaultSize());
            this.tfFileName = new JTextField();
            this.tfFileName.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbFileName, this.tfFileName));
            JLabel lbLocation = new JLabel(LB_LOCATION);
            lbLocation.setPreferredSize(this.getDefaultSize());
            this.tfLocation = new JTextField();
            this.tfLocation.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbLocation, this.tfLocation));
            JLabel lbFileType = new JLabel(LB_FILE_TYPE);
            lbFileType.setPreferredSize(this.getDefaultSize());
            this.cbFileType = new JComboBox<String>(InfoStore.FILE_TYPES_DISPLAY);
            this.cbFileType.setFont(this.cbFileType.getFont().deriveFont(0));
            this.cbFileType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbFileType, this.cbFileType));
            JLabel lbFieldSeparator = new JLabel(LB_FIELD_SEPARATOR);
            lbFieldSeparator.setPreferredSize(this.getDefaultSize());
            this.tfFieldSeparator = new JCharField();
            this.tfFieldSeparator.setPreferredSize(new Dimension(20, 20));
            JPanel lbpanel = new JPanel(new BorderLayout());
            lbpanel.setPreferredSize(new Dimension(30, 20));
            lbpanel.add((Component)this.tfFieldSeparator, "West");
            this.pnDataFileGrid.add(this.createRow(lbFieldSeparator, lbpanel));
            JLabel lbTransferType = new JLabel(LB_TRANSFER_TYPE);
            lbTransferType.setPreferredSize(this.getDefaultSize());
            this.cbTransferType = new JComboBox<String>(InfoStore.TRANSFER_TYPES_DISPLAY);
            this.cbTransferType.setFont(this.cbTransferType.getFont().deriveFont(0));
            this.cbTransferType.setPreferredSize(this.getDefaultSize());
            this.pnDataFileGrid.add(this.createRow(lbTransferType, this.cbTransferType));
            JLabel lbIsSelfDescribing = new JLabel(LB_SELF_DESCRIBING);
            lbIsSelfDescribing.setPreferredSize(this.getDefaultSize());
            this.chSelfDescribing = new JCheckBox();
            this.pnDataFileGrid.add(this.createRow(lbIsSelfDescribing, this.chSelfDescribing));
            JLabel lbSkipRecords = new JLabel(LB_SKIP_RECORDS);
            lbSkipRecords.setPreferredSize(this.getDefaultSize());
            this.tfSkipRecords = new JIntegerField();
            this.tfSkipRecords.setPreferredSize(new Dimension(20, 20));
            JPanel srpanel = new JPanel(new BorderLayout());
            srpanel.setPreferredSize(new Dimension(30, 20));
            srpanel.add((Component)this.tfSkipRecords, "West");
            this.pnDataFileGrid.add(this.createRow(lbSkipRecords, srpanel));
            JLabel lbTextDelimiter = new JLabel(LB_TEXT_DELIMITER);
            lbTextDelimiter.setPreferredSize(this.getDefaultSize());
            this.tfTextDelimiter = new JCharField();
            this.tfTextDelimiter.setPreferredSize(new Dimension(20, 20));
            JPanel tdpanel = new JPanel(new BorderLayout());
            tdpanel.setPreferredSize(new Dimension(20, 20));
            tdpanel.add((Component)this.tfTextDelimiter, "West");
            this.pnDataFileGrid.add(this.createRow(lbTextDelimiter, tdpanel));
            jpanel.add((Component)this.pnDataFileGrid, "North");
            this.pnDataFile.add((Component)jpanel, "Center");
        }
        return this.pnDataFile;
    }

    private JPanel getDataElementsPanel() {
        if (this.pnDataElement == null) {
            this.pnDataElement = this.createPage(Messages.getString("StorePropertiesDialogEx.DataElements"));
            this.dList = new ArrayList();
            this.newExtDatas = new ArrayList();
            this.edTable = new JTable(new ExternalDataModel());
            this.edTable.setSelectionMode(0);
            this.edTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = StorePropertiesDialogEx.this.edTable.getSelectedRow()) > -1 && StorePropertiesDialogEx.this.dList.size() > 0 && row < StorePropertiesDialogEx.this.dList.size()) {
                        ExternalData extData = (ExternalData)StorePropertiesDialogEx.this.dList.get(row);
                        ExternalDataPropertiesDialog dialog = new ExternalDataPropertiesDialog(StorePropertiesDialogEx.this.store.getDesign().getAppView(), extData);
                        dialog.initProperties(extData);
                        dialog.setModal(true);
                        dialog.show();
                        StorePropertiesDialogEx.this.edTable.updateUI();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.edTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnDEProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDEProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDEProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = StorePropertiesDialogEx.this.edTable.getSelectedRow();
                    if (row > -1 && StorePropertiesDialogEx.this.dList.size() > 0 && row < StorePropertiesDialogEx.this.dList.size()) {
                        ExternalData extData = (ExternalData)StorePropertiesDialogEx.this.dList.get(row);
                        ExternalDataPropertiesDialog dialog = new ExternalDataPropertiesDialog(StorePropertiesDialogEx.this.store.getDesign().getAppView(), extData);
                        dialog.initProperties(extData);
                        dialog.setModal(true);
                        dialog.show();
                        StorePropertiesDialogEx.this.edTable.updateUI();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnDEProperties);
            if (this.isEditable()) {
                this.btnDEAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnDEAdd.setToolTipText(BTN_ADD);
                this.btnDEAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExternalData extData = StorePropertiesDialogEx.this.store.getDesign().getProcessModel().createExternalData();
                        extData.setType(StorePropertiesDialogEx.this.store.getDesign().getDomainSet().getDefaultDomain().getLogicalDatatype());
                        StorePropertiesDialogEx.this.newExtDatas.add(extData);
                        StorePropertiesDialogEx.this.dList.add(extData);
                        StorePropertiesDialogEx.this.edTable.updateUI();
                    }
                });
                this.btnDERemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnDERemove.setToolTipText(BTN_REMOVE);
                this.btnDERemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = StorePropertiesDialogEx.this.edTable.getSelectedRow();
                        if (objectNumber != -1 && StorePropertiesDialogEx.this.dList.size() > 0 && objectNumber < StorePropertiesDialogEx.this.dList.size()) {
                            StorePropertiesDialogEx.this.dList.remove(objectNumber);
                            StorePropertiesDialogEx.this.edTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnDEAdd);
                toolBar.add(this.btnDERemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 300));
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnDataElement.add(aPanel);
        }
        return this.pnDataElement;
    }

    private void enableControls() {
        if (this.isEditable()) {
            boolean enable = "File".equalsIgnoreCase(InfoStore.INFOSTORE_TYPES_INTERNAL[this.cbType.getSelectedIndex()]);
            this.tfOwner.setEnabled(enable);
            this.tfSource.setEnabled(enable);
            this.tfFileName.setEnabled(enable);
            this.tfLocation.setEnabled(enable);
            this.cbFileType.setEnabled(enable);
            this.tfFieldSeparator.setEnabled(enable);
            this.cbTransferType.setEnabled(enable);
            this.chSelfDescribing.setEnabled(enable);
            this.tfSkipRecords.setEnabled(enable);
            this.tfTextDelimiter.setEnabled(enable);
            this.tfOwner.repaint();
            this.btnDEProperties.setEnabled(enable);
            this.btnDEAdd.setEnabled(enable);
            this.btnDERemove.setEnabled(enable);
            this.edTable.setEnabled(enable);
        }
    }

    private void updateEntityList() {
        this.eList.clear();
        this.eTable.clearTable();
        for (Attribute attribute : this.aList) {
            if (this.eList.contains(attribute.getContainer())) continue;
            this.eList.add(attribute.getContainer());
            Vector<Object> vect = new Vector<Object>();
            vect.addElement(attribute.getContainer());
            JLNComboBox cb = new JLNComboBox();
            List list = this.store.getImplementationsForEntity((Entity)attribute.getContainer());
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                cb.addItem(it2.next());
            }
            cb.setSelectedItem(this.store.getEntityImpl((Entity)attribute.getContainer()));
            vect.addElement(cb);
            Object[] objects = vect.toArray();
            ((ComboModel)this.eTable.getModel()).addRow(objects);
        }
        this.eTable.updateUI();
    }

    @Override
    protected int getMinimumHeight() {
        return 420;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    class EntityTable
    extends JTable {
        ComboModel dataModel;

        public EntityTable() {
            this.dataModel = new ComboModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return super.getCellRenderer(row, col);
            }
            return new LNComboTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ComboTableCellEditor();
        }
    }

    private class AttributesModel
    extends AbstractTableModel {
        private AttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.aList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StorePropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute attribute = (Attribute)StorePropertiesDialogEx.this.aList.get(row);
            if (col == 0) {
                return attribute.getLongName();
            }
            return new Integer(row * col);
        }
    }

    private class ProcessTableModel
    extends AbstractTableModel {
        private ProcessTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StorePropertiesDialogEx.Processes");
            }
            if (column == 1) {
                return Messages.getString("StorePropertiesDialogEx.Synonym");
            }
            if (column == 2) {
                return Messages.getString("StorePropertiesDialogEx.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Process process = (Process)StorePropertiesDialogEx.this.pList.get(row);
            if (col == 0) {
                return process.getName();
            }
            if (col == 1) {
                return process.getSynonym();
            }
            if (col == 2) {
                return process.getProcessTypeName();
            }
            return new Integer(row * col);
        }
    }

    private class InformationFlowsModel
    extends AbstractTableModel {
        private InformationFlowsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.ifList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StorePropertiesDialogEx.InformationFlows");
            }
            if (column == 1) {
                return Messages.getString("StorePropertiesDialogEx.Synonym");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Flow flow = (Flow)StorePropertiesDialogEx.this.ifList.get(row);
            if (col == 0) {
                return flow.getName();
            }
            if (col == 1) {
                return flow.getSynonym();
            }
            return new Integer(row * col);
        }
    }

    private class ExternalDataModel
    extends AbstractTableModel {
        private ExternalDataModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return StorePropertiesDialogEx.this.dList.size();
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return Messages.getString("StorePropertiesDialogEx.ExternalDatas");
                }
                case 1: {
                    return Messages.getString("StorePropertiesDialogEx.Type");
                }
                case 2: {
                    return Messages.getString("StorePropertiesDialogEx.StartingPosition");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ExternalData extData = (ExternalData)StorePropertiesDialogEx.this.dList.get(row);
            switch (col) {
                case 0: {
                    return extData.getName();
                }
                case 1: {
                    if (extData.isStructured()) {
                        return extData.getRecordStructure() != null ? extData.getRecordStructure().getName() : "";
                    }
                    return extData.getType();
                }
                case 2: {
                    return Integer.toString(extData.getStartingPos());
                }
            }
            return new Integer(row * col);
        }
    }

    public class ComboModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("StorePropertiesDialogEx.Entity");
            }
            if (column == 1) {
                return Messages.getString("StorePropertiesDialogEx.Table");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }

    class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox combo;

        ComboTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.combo = (JComboBox)value;
            this.combo.setOpaque(true);
            return this.combo;
        }
    }
}

