/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.process;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Transformation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.process.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectSourceElementsDialog
extends CustomDialog
implements AbstractEditorConstants {
    private List aList;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    private Transformation process;
    public boolean cancel = true;
    protected JDialog dialog;

    public SelectSourceElementsDialog(ApplicationView view, Transformation process, List aList) {
        super(view);
        this.aList = aList;
        this.process = process;
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(new Dimension(500, 350));
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init();
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnCancel.setCursor(Cursor.getPredefinedCursor(12));
        bnOK.setPreferredSize(bnCancel.getPreferredSize());
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.generalPanel.add((Component)bottomPanel, "South");
        this.add((Component)this.generalPanel, "Center");
    }

    private void init() {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.aList.iterator();
        while (it.hasNext()) {
            this.selectedAttributesModel.addElement(new ElementItem((DesignObject)it.next()));
        }
        for (Object next : this.process.getSourceElements_WithParams()) {
            if (this.aList.contains(next)) continue;
            this.allAttributesModel.addElement(new ElementItem((DesignObject)next));
        }
    }

    private void initAllAttributesList() {
        JPanel attributesList = new JPanel();
        attributesList.setBorder(BorderFactory.createTitledBorder("Available"));
        this.allAttributesList = new JList(this.allAttributesModel);
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttributesList);
        sp.setPreferredSize(new Dimension(220, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    private void initSelectedAttributesList() {
        JPanel selectedList = new JPanel();
        selectedList.setBorder(BorderFactory.createTitledBorder("Selected"));
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedAttributesList);
        sp.setPreferredSize(new Dimension(220, 300));
        selectedList.add(sp);
        this.generalPanel.add((Component)selectedList, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.setPreferredSize(new Dimension(32, 32));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectSourceElementsDialog.Add"));
        this.btnRemoveAttributes = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectSourceElementsDialog.Remove"));
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(Box.createVerticalGlue());
        verticalBox.add(this.btnAddAttributes);
        verticalBox.add(this.btnRemoveAttributes);
        verticalBox.add(Box.createVerticalGlue());
        this.generalPanel.add((Component)verticalBox, "Center");
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectSourceElementsDialog.SelectSourceElements"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectSourceElementsDialog.this.cancel = false;
            SelectSourceElementsDialog.this.aList.clear();
            for (int i = 0; i < SelectSourceElementsDialog.this.selectedAttributesModel.size(); ++i) {
                ElementItem item = (ElementItem)SelectSourceElementsDialog.this.selectedAttributesModel.getElementAt(i);
                SelectSourceElementsDialog.this.aList.add(item.getElement());
            }
            SelectSourceElementsDialog.this.close();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectSourceElementsDialog.this.cancel = true;
            SelectSourceElementsDialog.this.close();
        }
    }

    private class ElementItem {
        private DesignObject element = null;

        public ElementItem(DesignObject element) {
            this.element = element;
        }

        public DesignObject getElement() {
            return this.element;
        }

        public String toString() {
            if (this.element != null) {
                return this.element.getLongName();
            }
            return "";
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectSourceElementsDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectSourceElementsDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectSourceElementsDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectSourceElementsDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectSourceElementsDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectSourceElementsDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectSourceElementsDialog.this.allAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectSourceElementsDialog.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectSourceElementsDialog.this.selectedAttributesModel.contains(ob)) continue;
                    SelectSourceElementsDialog.this.selectedAttributesModel.addElement(ob);
                    SelectSourceElementsDialog.this.allAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectSourceElementsDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectSourceElementsDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectSourceElementsDialog.this.allAttributesModel.contains(ob)) continue;
                    SelectSourceElementsDialog.this.allAttributesModel.addElement(ob);
                    SelectSourceElementsDialog.this.selectedAttributesModel.removeElement(ob);
                }
            }
        }
    }
}

