/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class SelectElementsDialog
extends CustomDialog
implements AbstractEditorConstants {
    private List aList;
    private List allElements;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    protected JDialog dialog;
    public boolean cancel = true;

    public SelectElementsDialog(ApplicationView view, List allElements, List selectedElements) {
        super(view);
        this.aList = selectedElements;
        this.allElements = allElements;
        this.generalPanel = new JPanel(new GridBagLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init();
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.add((Component)bottomPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.getDialog().setVisible(true);
    }

    private void init() {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.aList.iterator();
        while (it.hasNext()) {
            this.selectedAttributesModel.addElement(new ElementItem(it.next()));
        }
        for (Object next : this.allElements) {
            if (this.aList.contains(next)) continue;
            this.allAttributesModel.addElement(new ElementItem(next));
        }
    }

    private void initAllAttributesList() {
        JPanel attributesList = new JPanel(new GridBagLayout());
        attributesList.setPreferredSize(new Dimension(100, 100));
        attributesList.setMinimumSize(new Dimension(100, 100));
        attributesList.setMaximumSize(new Dimension(100, 100));
        attributesList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectElementsDialog.Available")));
        this.allAttributesList = new JList(this.allAttributesModel);
        this.allAttributesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    SelectElementsDialog.this.btnAddAttributes.doClick();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttributesList);
        attributesList.add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)attributesList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void initSelectedAttributesList() {
        JPanel selectedList = new JPanel(new GridBagLayout());
        selectedList.setPreferredSize(new Dimension(100, 100));
        selectedList.setMinimumSize(new Dimension(100, 100));
        selectedList.setMaximumSize(new Dimension(100, 100));
        selectedList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectElementsDialog.Selected")));
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        this.selectedAttributesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    SelectElementsDialog.this.btnRemoveAttributes.doClick();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedAttributesList);
        selectedList.add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)selectedList, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectElementsDialog.Add"));
        this.btnRemoveAttributes = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectElementsDialog.Remove"));
        Box buttonsPanel = Box.createVerticalBox();
        buttonsPanel.setPreferredSize(new Dimension(32, 32));
        buttonsPanel.setMinimumSize(new Dimension(32, 32));
        buttonsPanel.setMaximumSize(new Dimension(32, 32));
        buttonsPanel.add(Box.createVerticalGlue());
        buttonsPanel.add(this.btnAddAttributes);
        buttonsPanel.add(this.btnRemoveAttributes);
        buttonsPanel.add(Box.createVerticalGlue());
        this.generalPanel.add((Component)buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectElementsDialog.SelectElements"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = SelectElementsDialog.this.dialog.getWidth();
                    int h = SelectElementsDialog.this.dialog.getHeight();
                    w = Math.max(500, w);
                    h = Math.max(410, h);
                    SelectElementsDialog.this.dialog.setSize(w, h);
                }
            });
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = 500;
                int h = 410;
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                int w = Math.max(500, (int)ds.rec.getSize().getWidth());
                int h = Math.max(410, (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectElementsDialog.this.cancel = false;
            SelectElementsDialog.this.aList.clear();
            for (int i = 0; i < SelectElementsDialog.this.selectedAttributesModel.size(); ++i) {
                ElementItem item = (ElementItem)SelectElementsDialog.this.selectedAttributesModel.getElementAt(i);
                SelectElementsDialog.this.aList.add(item.getElement());
            }
            SelectElementsDialog.this.close();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectElementsDialog.this.cancel = true;
            SelectElementsDialog.this.getDialog().dispose();
        }
    }

    private class ElementItem {
        private Object element = null;

        public ElementItem(Object element) {
            this.element = element;
        }

        public Object getElement() {
            return this.element;
        }

        public String toString() {
            if (this.element != null) {
                if (this.element instanceof DesignObject) {
                    return ((DesignObject)this.element).getLongName();
                }
                return this.element.toString();
            }
            return "";
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectElementsDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectElementsDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectElementsDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectElementsDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectElementsDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectElementsDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectElementsDialog.this.allAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectElementsDialog.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectElementsDialog.this.selectedAttributesModel.contains(ob)) continue;
                    SelectElementsDialog.this.selectedAttributesModel.addElement(ob);
                    SelectElementsDialog.this.allAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectElementsDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectElementsDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectElementsDialog.this.allAttributesModel.contains(ob)) continue;
                    SelectElementsDialog.this.allAttributesModel.addElement(ob);
                    SelectElementsDialog.this.selectedAttributesModel.removeElement(ob);
                }
            }
        }
    }
}

