/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SQLDimensionPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SQLStatementsDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;

public class SQLAccessToAWPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private SQLAccessToAW sqlAccessToAW;
    private SQLAccessToAW origin;
    private JTextField tfObjTypeName;
    private JTextField tfTableTypeName;
    private JTextField tfAWName;
    private Slice slice;
    private JCheckBox chGenerateGIDs;
    private JCheckBox chUseObjectTypes;
    private JCheckBox chUseModel;
    private Cube cube;
    private JButton btnSQL;
    private JCheckBox chUseRowtoCell;
    private JButton btnAddSL;
    private JButton btnRemoveSL;
    private JTable dimsTable;
    private List selectedDimensions;
    private List allDimensions;
    private JTable sTable;
    private JButton btnMeasureProperties;
    private JButton btnAdd;
    private JButton btnRemoveMeasure;
    private List selectedMeasureWrappers;
    private List allMeasureWrappers;
    private JPanel pnDimensions;
    private JPanel pnMeasures;
    private JButton btnDimensionProperties;

    public SQLAccessToAWPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbAWName = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.AWName"));
        lbAWName.setPreferredSize(this.getDefaultSize());
        this.tfAWName = new JTextField("");
        this.tfAWName.setPreferredSize(this.getDefaultSize());
        this.tfAWName.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbAWName, this.tfAWName));
        JLabel lbReadOnly = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.IncludeGIDs"));
        lbReadOnly.setPreferredSize(this.getDefaultSize());
        this.chGenerateGIDs = new JCheckBox();
        this.chGenerateGIDs.setPreferredSize(this.getDefaultSize());
        this.chGenerateGIDs.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbReadOnly, this.chGenerateGIDs));
        JLabel lbCreateObjType = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.UseObjectTypes"));
        lbCreateObjType.setPreferredSize(this.getDefaultSize());
        this.chUseObjectTypes = new JCheckBox();
        this.chUseObjectTypes.setPreferredSize(this.getDefaultSize());
        this.chUseObjectTypes.setEnabled(this.isEditable());
        this.addRowToGeneralPanel(this.createRow(lbCreateObjType, this.chUseObjectTypes));
        JLabel lbObjTypeName = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.ObjectTypeName"));
        lbObjTypeName.setPreferredSize(this.getDefaultSize());
        this.tfObjTypeName = new JTextField("");
        this.tfObjTypeName.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbObjTypeName, this.tfObjTypeName));
        JLabel lbTableTypeName = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.TableTypeName"));
        lbTableTypeName.setPreferredSize(this.getDefaultSize());
        this.tfTableTypeName = new JTextField("");
        this.tfTableTypeName.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbTableTypeName, this.tfTableTypeName));
        JLabel lbUseModel = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.UseModelClause"));
        lbUseModel.setPreferredSize(this.getDefaultSize());
        this.chUseModel = new JCheckBox();
        this.chUseModel.setEnabled(false);
        this.chUseModel.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbUseModel, this.chUseModel));
        JLabel lbUseRowtoCell = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.IncludeRowToCell"));
        lbUseRowtoCell.setPreferredSize(this.getDefaultSize());
        this.chUseRowtoCell = new JCheckBox();
        this.chUseRowtoCell.setEnabled(false);
        this.chUseRowtoCell.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbUseRowtoCell, this.chUseRowtoCell));
        this.tfObjTypeName.setEnabled(this.chUseObjectTypes.isSelected());
        this.tfTableTypeName.setEnabled(this.chUseObjectTypes.isSelected());
        this.chUseObjectTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLAccessToAWPropertiesDialogEx.this.enableControls();
            }
        });
        JLabel lbSQL = new JLabel(Messages.getString("SQLAccessToAWPropertiesDialogEx.SQLStatements"));
        lbSQL.setPreferredSize(this.getDefaultSize());
        this.btnSQL = new JButton(Messages.getString("SQLAccessToAWPropertiesDialogEx.SQL"));
        this.btnSQL.setPreferredSize(this.getDefaultSize());
        this.btnSQL.setHorizontalAlignment(0);
        this.addRowToGeneralPanel(this.createRow(lbSQL, this.btnSQL));
        this.btnSQL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setName(SQLAccessToAWPropertiesDialogEx.this.tfName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setComment(SQLAccessToAWPropertiesDialogEx.this.taComments.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setNotes(SQLAccessToAWPropertiesDialogEx.this.taNotes.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setDescription(SQLAccessToAWPropertiesDialogEx.this.taDescription.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setGenerateGIDs(SQLAccessToAWPropertiesDialogEx.this.chGenerateGIDs.isSelected());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setUseObjectType(SQLAccessToAWPropertiesDialogEx.this.chUseObjectTypes.isSelected());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setObjectADTName(SQLAccessToAWPropertiesDialogEx.this.tfObjTypeName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setTableADTName(SQLAccessToAWPropertiesDialogEx.this.tfTableTypeName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getSqlDimensionDefinitions().clear();
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getSqlDimensionDefinitions().addAll(SQLAccessToAWPropertiesDialogEx.this.selectedDimensions);
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setAWName(SQLAccessToAWPropertiesDialogEx.this.tfAWName.getText());
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.setUseRowToCellColumn(SQLAccessToAWPropertiesDialogEx.this.chUseRowtoCell.isSelected());
                if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasureWrappers().clear();
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasureWrappers().addAll(SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                } else {
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasures().clear();
                    SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.getMeasures().addAll(SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                }
                SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW.verifyDefinitions();
                SQLStatementsDialog dialog = new SQLStatementsDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), SQLAccessToAWPropertiesDialogEx.this.sqlAccessToAW, !SQLAccessToAWPropertiesDialogEx.this.isEditable());
                dialog.show();
            }
        });
    }

    private void enableControls() {
        if (this.isEditable()) {
            this.tfObjTypeName.setEnabled(this.chUseObjectTypes.isSelected());
            this.tfTableTypeName.setEnabled(this.chUseObjectTypes.isSelected());
            if (this.chUseObjectTypes.isSelected()) {
                String name = this.tfObjTypeName.getText().trim();
                if ("".equals(name)) {
                    this.tfObjTypeName.setText(this.tfName.getText() + "_row");
                }
                if ("".equals(name = this.tfTableTypeName.getText().trim())) {
                    this.tfTableTypeName.setText(this.tfName.getText() + "_table");
                }
            }
        }
    }

    @Override
    public String getCaption() {
        return Messages.getString("SQLAccessToAWPropertiesDialogEx.SQLAccessOracleAW");
    }

    @Override
    protected String getHelpIndex() {
        return "SQL_ACCESS_TO_ORACLE_AW_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof SQLAccessToAW) {
            this.origin = (SQLAccessToAW)object;
            this.origin.verifyDefinitions();
            this.slice = this.origin.getSlice();
            this.cube = this.origin.getCube();
            this.sqlAccessToAW = this.origin.makeCopy();
            this.initDefaults(false);
            this.taDescription.setText(this.sqlAccessToAW.getDescription());
            this.tfAWName.setText(this.sqlAccessToAW.getAWName());
            this.chGenerateGIDs.setSelected(this.sqlAccessToAW.isGenerateGIDs());
            this.chUseObjectTypes.setSelected(this.sqlAccessToAW.isUseObjectType());
            this.tfObjTypeName.setText(this.sqlAccessToAW.getObjectADTName());
            this.tfTableTypeName.setText(this.sqlAccessToAW.getTableADTName());
            this.chUseModel.setSelected(this.sqlAccessToAW.isUseModelClause());
            this.chUseRowtoCell.setSelected(this.sqlAccessToAW.isUseRowToCellColumn());
            this.selectedDimensions.addAll(this.sqlAccessToAW.getSqlDimensionDefinitions());
            this.allDimensions.addAll(this.sqlAccessToAW.getAllSQLDimensions());
            if (this.slice != null) {
                this.selectedMeasureWrappers.addAll(this.sqlAccessToAW.getMeasureWrappers());
                this.allMeasureWrappers.addAll(this.sqlAccessToAW.getAllMeasureWrappers());
            } else {
                this.selectedMeasureWrappers.addAll(this.sqlAccessToAW.getMeasures());
                this.allMeasureWrappers.addAll(this.sqlAccessToAW.getAllMeasures());
            }
            this.enableControls();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getDimensionsAndAttributesPanel());
        this.addToTree(root, this.getMeasuresPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.sqlAccessToAW.setName(this.tfName.getText());
        this.sqlAccessToAW.setComment(this.taComments.getText());
        this.sqlAccessToAW.setNotes(this.taNotes.getText());
        this.sqlAccessToAW.setDescription(this.taDescription.getText());
        this.sqlAccessToAW.setGenerateGIDs(this.chGenerateGIDs.isSelected());
        this.sqlAccessToAW.setUseObjectType(this.chUseObjectTypes.isSelected());
        this.sqlAccessToAW.setObjectADTName(this.tfObjTypeName.getText());
        this.sqlAccessToAW.setTableADTName(this.tfTableTypeName.getText());
        this.sqlAccessToAW.getSqlDimensionDefinitions().clear();
        this.sqlAccessToAW.getSqlDimensionDefinitions().addAll(this.selectedDimensions);
        this.sqlAccessToAW.setAWName(this.tfAWName.getText());
        this.sqlAccessToAW.setUseRowToCellColumn(this.chUseRowtoCell.isSelected());
        if (this.slice != null) {
            this.sqlAccessToAW.getMeasureWrappers().clear();
            this.sqlAccessToAW.getMeasureWrappers().addAll(this.selectedMeasureWrappers);
        } else {
            this.sqlAccessToAW.getMeasures().clear();
            this.sqlAccessToAW.getMeasures().addAll(this.selectedMeasureWrappers);
        }
        this.sqlAccessToAW.makeCopyTo(this.origin);
        this.origin.verifyDefinitions();
        SQLAccessToAWPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.sqlAccessToAW.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.sqlAccessToAW.setProperty(dp.getName(), dp.getValue());
        }
    }

    protected JPanel getDimensionsAndAttributesPanel() {
        if (this.pnDimensions == null) {
            this.pnDimensions = this.createPage(Messages.getString("SQLAccessToAWPropertiesDialogEx.DimensionsAndAttributes"));
            this.selectedDimensions = new ArrayList();
            this.allDimensions = new ArrayList();
            this.dimsTable = new JTable(new DimensionsTableModel());
            this.dimsTable.setSelectionMode(0);
            this.dimsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SQLAccessToAWPropertiesDialogEx.this.dimsTable.getSelectedRow()) != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size() > 0 && row < SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size()) {
                        SQLAccessToAW.SQLDimension sqldim = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(row);
                        SQLDimensionPropertiesDialog dialog = new SQLDimensionPropertiesDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), sqldim);
                        dialog.show();
                    }
                }
            });
            this.dimsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = SQLAccessToAWPropertiesDialogEx.this.dimsTable.getSelectedRow();
                        if (selectedRow == -1) {
                            SQLAccessToAWPropertiesDialogEx.this.btnDimensionProperties.setEnabled(false);
                            SQLAccessToAWPropertiesDialogEx.this.btnRemoveSL.setEnabled(false);
                        } else {
                            SQLAccessToAWPropertiesDialogEx.this.btnDimensionProperties.setEnabled(true);
                            SQLAccessToAWPropertiesDialogEx.this.btnRemoveSL.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.dimsTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnDimensionProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDimensionProperties.setEnabled(false);
            this.btnDimensionProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDimensionProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SQLAccessToAWPropertiesDialogEx.this.dimsTable.getSelectedRow();
                    if (row != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size() > 0 && row < SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size()) {
                        SQLAccessToAW.SQLDimension sqldim = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(row);
                        SQLDimensionPropertiesDialog dialog = new SQLDimensionPropertiesDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), sqldim);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnDimensionProperties);
            if (this.isEditable()) {
                this.btnAddSL = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddSL.setToolTipText(BTN_ADD);
                this.btnAddSL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SelectElementsDialog dialog = new SelectElementsDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), SQLAccessToAWPropertiesDialogEx.this.allDimensions, SQLAccessToAWPropertiesDialogEx.this.selectedDimensions);
                        dialog.setVisible(true);
                        SQLAccessToAWPropertiesDialogEx.this.dimsTable.updateUI();
                    }
                });
                this.btnRemoveSL = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveSL.setEnabled(false);
                this.btnRemoveSL.setToolTipText(BTN_REMOVE);
                this.btnRemoveSL.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = SQLAccessToAWPropertiesDialogEx.this.dimsTable.getSelectedRow();
                        if (objectNumber != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size() > 0 && objectNumber < SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size()) {
                            SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.remove(objectNumber);
                            SQLAccessToAWPropertiesDialogEx.this.dimsTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAddSL);
                toolBar.add(this.btnRemoveSL);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnDimensions.add(pPanel);
        }
        return this.pnDimensions;
    }

    protected JPanel getMeasuresPanel() {
        if (this.pnMeasures == null) {
            this.pnMeasures = this.createPage(Messages.getString("SQLAccessToAWPropertiesDialogEx.25"));
            this.selectedMeasureWrappers = new ArrayList();
            this.allMeasureWrappers = new ArrayList();
            this.sTable = new JTable(new MeasureWrappersModel());
            this.sTable.setSelectionMode(0);
            this.sTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = SQLAccessToAWPropertiesDialogEx.this.sTable.getSelectedRow()) != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && row < SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        ModelIDObject measure = null;
                        if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                            Slice.MeasureWrapper mw = (Slice.MeasureWrapper)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                            measure = (Measure)SQLAccessToAWPropertiesDialogEx.this.slice.getMultidimensionalDesign().getMeasureSet().getObjectByID(mw.getMeasure().getObjectID());
                        } else if (SQLAccessToAWPropertiesDialogEx.this.cube != null) {
                            measure = (Measure)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                            measure = (Measure)SQLAccessToAWPropertiesDialogEx.this.cube.getMultidimensionalDesign().getMeasureSet().getObjectByID(measure.getObjectID());
                        }
                        if (measure != null && !measure.isDialogVisible()) {
                            ((Measure)measure).showModal = true;
                            ((Measure)measure).showPropertyDialog();
                        }
                    }
                }
            });
            this.sTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = SQLAccessToAWPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (selectedRow == -1) {
                            SQLAccessToAWPropertiesDialogEx.this.btnMeasureProperties.setEnabled(false);
                            SQLAccessToAWPropertiesDialogEx.this.btnRemoveMeasure.setEnabled(false);
                        } else {
                            SQLAccessToAWPropertiesDialogEx.this.btnMeasureProperties.setEnabled(true);
                            SQLAccessToAWPropertiesDialogEx.this.btnRemoveMeasure.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.sTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnMeasureProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnMeasureProperties.setEnabled(false);
            this.btnMeasureProperties.setToolTipText(BTN_PROPERTIES);
            this.btnMeasureProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = SQLAccessToAWPropertiesDialogEx.this.sTable.getSelectedRow();
                    if (row != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && row < SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                        ModelIDObject measure = null;
                        if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                            Slice.MeasureWrapper mw = (Slice.MeasureWrapper)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                            measure = (Measure)SQLAccessToAWPropertiesDialogEx.this.slice.getMultidimensionalDesign().getMeasureSet().getObjectByID(mw.getMeasure().getObjectID());
                        } else if (SQLAccessToAWPropertiesDialogEx.this.cube != null) {
                            measure = (Measure)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                            measure = (Measure)SQLAccessToAWPropertiesDialogEx.this.cube.getMultidimensionalDesign().getMeasureSet().getObjectByID(measure.getObjectID());
                        }
                        if (measure != null && !measure.isDialogVisible()) {
                            ((Measure)measure).showModal = true;
                            ((Measure)measure).showPropertyDialog();
                        }
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnMeasureProperties);
            if (this.isEditable()) {
                this.btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAdd.setToolTipText(BTN_ADD);
                this.btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ArrayList list = new ArrayList();
                        list.addAll(SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                        SelectElementsDialog dialog = new SelectElementsDialog(SQLAccessToAWPropertiesDialogEx.this.getAppView(), SQLAccessToAWPropertiesDialogEx.this.allMeasureWrappers, SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers);
                        dialog.setVisible(true);
                        SQLAccessToAWPropertiesDialogEx.this.sTable.updateUI();
                    }
                });
                this.btnRemoveMeasure = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveMeasure.setEnabled(false);
                this.btnRemoveMeasure.setToolTipText(BTN_REMOVE);
                this.btnRemoveMeasure.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = SQLAccessToAWPropertiesDialogEx.this.sTable.getSelectedRow();
                        if (objectNumber != -1 && SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size() > 0 && objectNumber < SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size()) {
                            SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.remove(objectNumber);
                            SQLAccessToAWPropertiesDialogEx.this.sTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAdd);
                toolBar.add(this.btnRemoveMeasure);
            }
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnMeasures.add(pPanel);
        }
        return this.pnMeasures;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class DimensionsTableModel
    extends AbstractTableModel {
        private DimensionsTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("SQLAccessToAWPropertiesDialogEx.Dimension");
            }
            if (column == 1) {
                return Messages.getString("SQLAccessToAWPropertiesDialogEx.UseDimensionColumn");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!SQLAccessToAWPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1 && aValue instanceof Boolean) {
                SQLAccessToAW.SQLDimension sqld = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(row);
                sqld.setSelectedDimensionID((Boolean)aValue);
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SQLAccessToAW.SQLDimension sqld = (SQLAccessToAW.SQLDimension)SQLAccessToAWPropertiesDialogEx.this.selectedDimensions.get(row);
            if (col == 0) {
                return sqld.getDimension().getName();
            }
            if (col == 1) {
                return new Boolean(sqld.isSelectedDimensionID());
            }
            return null;
        }
    }

    private class MeasureWrappersModel
    extends AbstractTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SQLAccessToAWPropertiesDialogEx.Measure"), Messages.getString("SQLAccessToAWPropertiesDialogEx.AggregateFunction"), Messages.getString("SQLAccessToAWPropertiesDialogEx.MeasureAlias")};

        @Override
        public int getColumnCount() {
            if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                return this.COL_NAMES.length;
            }
            return 1;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                return this.COL_NAMES[col];
            }
            return this.COL_NAMES[0];
        }

        @Override
        public int getRowCount() {
            return SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (SQLAccessToAWPropertiesDialogEx.this.slice != null) {
                Slice.MeasureWrapper object = (Slice.MeasureWrapper)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(row);
                if (col == 0) {
                    return object.getMeasure().getName();
                }
                if (col == 1) {
                    return object.getAggrFunction().name;
                }
                if (col == 2) {
                    return object.getAggrFunction().measureAlias;
                }
                return "";
            }
            Measure object = (Measure)SQLAccessToAWPropertiesDialogEx.this.selectedMeasureWrappers.get(row);
            return object.getName();
        }
    }
}

