/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.SelectAttributesDialog;
import oracle.dbtools.crest.swingui.editor.StringEditor;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectDescriptiveAttributesDialog;
import oracle.dbtools.crest.swingui.editor.multidimensional.SelectElementsDialog;
import oracle.dbtools.crest.util.gui.swing.JLNComboBox;
import oracle.ide.Ide;

public class LevelPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Level level;
    private JComboBox cbLevelEntity;
    private JPanel pnSelectionCriteria;
    private JTextArea taSelectetionCriteria;
    private JPanel pnSelectionCriteriaDesc;
    private JTextArea taSelectetionCriteriaDesc;
    private JCheckBox chValueBasegHierarchy;
    private JComboBox cbRootIdent;
    private JTextField tfIdentValue;
    private JComboBox cbDefaultAttribute;
    private JComboBox cbEntityAttributes;
    private ContainerObject curEntity;
    private JPanel lkPanel;
    private JTable lkTable;
    private List lkList;
    private JPanel daPanel;
    private JTable daTable;
    private List daList;
    private Level.OraAWAttributes currentOraAWAttr;
    private JComboBox cbDescAttr;
    private JTable hTable;
    private List hList;
    private JButton bnHProperties;
    private JButton bnHAdd;
    private JButton bnHRemove;
    private List descAlist;
    private JTable pkTable;
    private List pkList;
    private JPanel pkPanel;
    private List calcAttrList;
    private JTable caTable;
    private JPanel caPanel;
    private JTable oraAWTable;
    private JPanel oraAWPanel;
    private List olapAttribues;
    private JPanel olapPanel;
    private JComboBox cbNameColumn;
    private JComboBox cbValueColumn;
    private JButton bnPKAdd;
    private JButton bnPKRemove;
    private JButton bnPKProperties;
    private static final String ADD_ATTRIBUTES_FROM_ENTITY = Messages.getString("LevelPropertiesDialogEx.ADD_ATTRIBUTES_FROM_ENTITY");
    private JButton btnLevelKeyProperties;
    private JButton btnRemoveLevelKeyProperty;
    private JButton btnDescriptiveAttributeProperties;
    private JButton btnRemoveDescriptiveAttribute;
    private JButton btnRemoveCalcAttribute;

    public LevelPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public LevelPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    protected int getMinimumWidth() {
        return 660;
    }

    @Override
    protected int getMinimumHeight() {
        return 550;
    }

    private void initGeneral() {
        JLabel lbLevelEntity = new JLabel(LB_LEVEL_ENTITY);
        lbLevelEntity.setPreferredSize(this.getDefaultSize());
        this.cbLevelEntity = new JComboBox();
        this.cbLevelEntity.setPreferredSize(this.getDefaultSize());
        this.cbLevelEntity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContainerObject ent = (ContainerObject)LevelPropertiesDialogEx.this.cbLevelEntity.getSelectedItem();
                if (ent != LevelPropertiesDialogEx.this.curEntity) {
                    LevelPropertiesDialogEx.this.curEntity = ent;
                    if (LevelPropertiesDialogEx.this.curEntity != null) {
                        LevelPropertiesDialogEx.this.fillComboItems(LevelPropertiesDialogEx.this.curEntity.getElementsCollection().toArray(), LevelPropertiesDialogEx.this.cbEntityAttributes, true);
                    }
                    LevelPropertiesDialogEx.this.lkList.clear();
                    LevelPropertiesDialogEx.this.lkTable.updateUI();
                    LevelPropertiesDialogEx.this.daList.clear();
                    LevelPropertiesDialogEx.this.daTable.updateUI();
                    LevelPropertiesDialogEx.this.setCBDescAttr();
                }
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbLevelEntity, this.cbLevelEntity));
        JLabel lbValueBasedHierarchy = new JLabel(LB_VALUE_BASED);
        lbValueBasedHierarchy.setPreferredSize(this.getDefaultSize());
        this.chValueBasegHierarchy = new JCheckBox();
        this.chValueBasegHierarchy.setPreferredSize(this.getDefaultSize());
        this.chValueBasegHierarchy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LevelPropertiesDialogEx.this.enableControls();
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbValueBasedHierarchy, this.chValueBasegHierarchy));
        JLabel lbRootIdent = new JLabel(LB_ROOT_IDENTIFICATION);
        lbRootIdent.setPreferredSize(this.getDefaultSize());
        this.cbRootIdent = new JComboBox<String>(Level.ROOT_IDENTS);
        this.cbRootIdent.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbRootIdent, this.cbRootIdent));
        JLabel lbIdentValue = new JLabel(LB_IDENTIFICATION_VALUE);
        lbIdentValue.setPreferredSize(this.getDefaultSize());
        this.tfIdentValue = new JTextField();
        this.tfIdentValue.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbIdentValue, this.tfIdentValue));
        JLabel lbDefaultAttribute = new JLabel(LB_DEFAULT_ATTRIBUTE);
        lbDefaultAttribute.setPreferredSize(this.getDefaultSize());
        this.cbDefaultAttribute = new JComboBox();
        this.cbDefaultAttribute.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDefaultAttribute, this.cbDefaultAttribute));
    }

    private void enableControls() {
        if (this.isEditable()) {
            boolean enabled = this.chValueBasegHierarchy.isSelected();
            this.cbRootIdent.setEnabled(enabled);
            this.tfIdentValue.setEnabled(enabled);
            this.pkTable.setEnabled(enabled);
            this.bnPKProperties.setEnabled(enabled);
            this.bnPKAdd.setEnabled(enabled);
            this.bnPKRemove.setEnabled(enabled);
        }
    }

    private void setCBDescAttr() {
        ContainerObject ent = this.level.getLevelEntity();
        if (ent != null) {
            ArrayList list = new ArrayList(ent.getElementsCollection());
            this.validateAWAttributes(this.currentOraAWAttr, list);
            list.add(0, null);
            this.cbDescAttr.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        }
    }

    public void validateAWAttributes(Level.OraAWAttributes oraAWAttributes, List list) {
        int i;
        if (oraAWAttributes.shortDesc != null && (i = list.indexOf(oraAWAttributes.shortDesc)) < 0) {
            oraAWAttributes.shortDesc = null;
        }
        if (oraAWAttributes.longDesc != null && (i = list.indexOf(oraAWAttributes.longDesc)) < 0) {
            oraAWAttributes.longDesc = null;
        }
        if (oraAWAttributes.timeEnd != null && (i = list.indexOf(oraAWAttributes.timeEnd)) < 0) {
            oraAWAttributes.timeEnd = null;
        }
        if (oraAWAttributes.timeSpan != null && (i = list.indexOf(oraAWAttributes.timeSpan)) < 0) {
            oraAWAttributes.timeSpan = null;
        }
    }

    List copySCAtt_to_NormalAttr(List scList) {
        ArrayList<ContainedObject> normList = new ArrayList<ContainedObject>();
        for (SlowChangingAttribute attr : scList) {
            if (attr.getAttribute() == null) continue;
            normList.add(attr.getAttribute());
        }
        return normList;
    }

    @Override
    public String getCaption() {
        return Messages.getString("LevelPropertiesDialogEx.LevelProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "LEVEL_PROPERTIES_DIALOG";
    }

    private List getDescriptiveAttributes() {
        ArrayList<SlowChangingAttribute> result = new ArrayList<SlowChangingAttribute>();
        Iterator it = this.level.getSlowChangingAttributes().iterator();
        while (it.hasNext()) {
            SlowChangingAttribute scha = new SlowChangingAttribute(this.level, (SlowChangingAttribute)it.next());
            result.add(scha);
        }
        return result;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Level) {
            this.level = (Level)object;
            this.initDefaults(false);
            Level level = this.level;
            Objects.requireNonNull(level);
            this.currentOraAWAttr = level.new Level.OraAWAttributes(this.level);
            this.taSelectetionCriteria.setText(this.level.getSelectionCriteria());
            this.taSelectetionCriteriaDesc.setText(this.level.getSelectionCriteriaDescription());
            this.taDescription.setText(this.level.getDescription());
            this.fillComboItems(this.getLevelEntities().toArray(), this.cbLevelEntity, true);
            this.fillComboItems(this.level.getDefaultAttributeCandidates().toArray(), this.cbDefaultAttribute, true);
            this.cbLevelEntity.setSelectedItem(this.level.getLevelEntity());
            if (this.level.getLevelEntity() != null) {
                this.fillComboItems(this.level.getLevelEntity().getElementsCollection().toArray(), this.cbEntityAttributes, true);
            }
            this.cbDefaultAttribute.setSelectedItem(this.level.getDefaultAttribute());
            this.fillComboItems(this.getOlapAttributes().toArray(), this.cbNameColumn, false);
            this.fillComboItems(this.getOlapAttributes().toArray(), this.cbValueColumn, false);
            this.cbNameColumn.setSelectedItem(this.level.getNameColumn());
            this.cbValueColumn.setSelectedItem(this.level.getValueColumn());
            this.chValueBasegHierarchy.setSelected(this.level.isValueBasedHierarchy());
            this.cbRootIdent.setSelectedItem(this.level.getRootIdentification());
            this.tfIdentValue.setText(this.level.getIdentificationValue());
            this.lkList.addAll(this.level.getLevelKey());
            this.lkTable.updateUI();
            this.daList.addAll(this.getDescriptiveAttributes());
            this.daTable.updateUI();
            this.pkList.addAll(this.level.getParentKey());
            this.pkTable.updateUI();
            this.calcAttrList.addAll(this.level.getCalculatedAttributes());
            this.caTable.updateUI();
            this.copyAWAttr(this.level.getOraAWAttributes(), this.currentOraAWAttr);
            this.level.validateAWAttributes(this.currentOraAWAttr, true);
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.enableControls();
            this.setCBDescAttr();
            this.initDynamicProperties();
        }
    }

    private void copyAWAttr(Level.OraAWAttributes source, Level.OraAWAttributes target) {
        target.level = source.level;
        target.shortDesc = source.shortDesc;
        target.longDesc = source.longDesc;
        target.timeSpan = source.timeSpan;
        target.timeEnd = source.timeEnd;
    }

    private List getLevelEntities() {
        ArrayList result = new ArrayList();
        result.addAll(this.level.getMultidimensionalDesign().getAllColntainers());
        return result;
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getSelectionCriteriaPanel());
        this.addToTree(root, this.getSelectionCriteriaDescPanel());
        this.addToTree(root, this.getLevelKeyPanel());
        this.addToTree(root, this.getDescriptiveAttributesPanel());
        this.addToTree(root, this.getParentKeyPanel());
        this.addToTree(root, this.getCalcAttributesPanel());
        this.addToTree(root, this.getOracleAWAttributesPanel());
        this.addToTree(root, this.getOracleNamesPanel());
        this.addToTree(root, this.getMSOlapPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    protected JPanel getSelectionCriteriaPanel() {
        if (this.pnSelectionCriteria == null) {
            this.pnSelectionCriteria = this.createPage(Messages.getString("LevelPropertiesDialogEx.SelectionCriteria"));
            this.taSelectetionCriteria = new JTextArea();
            this.pnSelectionCriteria.add(new JScrollPane(this.taSelectetionCriteria));
        }
        return this.pnSelectionCriteria;
    }

    protected JPanel getSelectionCriteriaDescPanel() {
        if (this.pnSelectionCriteriaDesc == null) {
            this.pnSelectionCriteriaDesc = this.createPage(Messages.getString("LevelPropertiesDialogEx.Sel.CriteriaDescription"));
            this.taSelectetionCriteriaDesc = new JTextArea();
            this.pnSelectionCriteriaDesc.add(new JScrollPane(this.taSelectetionCriteriaDesc));
        }
        return this.pnSelectionCriteriaDesc;
    }

    @Override
    protected void setProperties() {
        int col = this.caTable.getEditingColumn();
        int row = this.caTable.getEditingRow();
        if (row >= 0 && col >= 0) {
            this.caTable.getCellEditor(row, col).stopCellEditing();
        }
        col = this.daTable.getEditingColumn();
        row = this.daTable.getEditingRow();
        if (row >= 0 && col >= 0) {
            this.daTable.getCellEditor(row, col).stopCellEditing();
        }
        this.level.setName(this.tfName.getText());
        this.level.setComment(this.taComments.getText());
        this.level.setNotes(this.taNotes.getText());
        this.level.setDescription(this.taDescription.getText());
        this.level.setLevelEntity((ContainerObject)this.cbLevelEntity.getSelectedItem());
        this.level.setSelectionCriteria(this.taSelectetionCriteria.getText());
        this.level.setSelectionCriteriaDescription(this.taSelectetionCriteriaDesc.getText());
        boolean checked = this.chValueBasegHierarchy.isSelected();
        this.level.setValueBasedHierarchy(checked);
        this.level.getLevelKey().clear();
        for (DesignObject attribute : this.lkList) {
            this.level.addToLevelKey((ContainedObject)attribute);
        }
        this.level.getSlowChangingAttributes().clear();
        for (DesignObject attribute : this.daList) {
            this.level.addDescriptiveAttribute((SlowChangingAttribute)attribute);
        }
        if (checked) {
            this.level.setRootIdentification((String)this.cbRootIdent.getSelectedItem());
            this.level.setIdentificationValue(this.tfIdentValue.getText());
            this.level.getParentKey().clear();
            for (DesignObject attribute : this.pkList) {
                this.level.addToParentKey((ContainedObject)attribute);
            }
        }
        this.level.getCalculatedAttributes().clear();
        Iterator it = this.calcAttrList.iterator();
        while (it.hasNext()) {
            this.level.addCalculatedAttribute((CalculatedAttribute)it.next());
        }
        this.level.setDefaultAttribute((DesignObject)this.cbDefaultAttribute.getSelectedItem());
        ContainerObject ent = this.level.getLevelEntity();
        ArrayList list = new ArrayList();
        if (ent != null) {
            list.addAll(ent.getElementsCollection());
            this.validateAWAttributes(this.currentOraAWAttr, list);
        }
        this.copyAWAttr(this.currentOraAWAttr, this.level.getOraAWAttributes());
        this.level.setNameColumn((ContainedObject)this.cbNameColumn.getSelectedItem());
        this.level.setValueColumn((ContainedObject)this.cbValueColumn.getSelectedItem());
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        this.setCBDescAttr();
        LevelPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.level.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.level.setProperty(dp.getName(), dp.getValue());
        }
    }

    protected JPanel getLevelKeyPanel() {
        if (this.lkPanel == null) {
            this.lkPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.LevelKey"));
            this.lkList = new ArrayList();
            this.lkTable = new JTable(new LevelKeyModel());
            this.lkTable.setSelectionMode(0);
            this.lkTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = LevelPropertiesDialogEx.this.lkTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.lkList.size() > 0 && row < LevelPropertiesDialogEx.this.lkList.size()) {
                        ContainedObject attribute = (ContainedObject)LevelPropertiesDialogEx.this.lkList.get(row);
                        attribute.showModal = LevelPropertiesDialogEx.this.level.showModal || LevelPropertiesDialogEx.this.level.showForFirstTime();
                        attribute.showPropertyDialog();
                    }
                }
            });
            this.lkTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = LevelPropertiesDialogEx.this.lkTable.getSelectedRow();
                        if (selectedRow == -1) {
                            LevelPropertiesDialogEx.this.btnLevelKeyProperties.setEnabled(false);
                            LevelPropertiesDialogEx.this.btnRemoveLevelKeyProperty.setEnabled(false);
                        } else {
                            LevelPropertiesDialogEx.this.btnLevelKeyProperties.setEnabled(true);
                            LevelPropertiesDialogEx.this.btnRemoveLevelKeyProperty.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.lkTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnLevelKeyProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnLevelKeyProperties.setEnabled(false);
            this.btnLevelKeyProperties.setToolTipText(BTN_PROPERTIES);
            this.btnLevelKeyProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = LevelPropertiesDialogEx.this.lkTable.getSelectedRow();
                    if (row > -1 && LevelPropertiesDialogEx.this.lkList.size() > 0 && row < LevelPropertiesDialogEx.this.lkList.size()) {
                        ContainedObject attribute = (ContainedObject)LevelPropertiesDialogEx.this.lkList.get(row);
                        attribute.showModal = LevelPropertiesDialogEx.this.level.showModal || LevelPropertiesDialogEx.this.level.showForFirstTime();
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnLevelKeyProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ContainerObject ent = (ContainerObject)LevelPropertiesDialogEx.this.cbLevelEntity.getSelectedItem();
                        if (ent == null) {
                            JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("LevelPropertiesDialogEx.SetLevelEntityFirst"), Messages.getString("LevelPropertiesDialogEx.LevelEntityNotSet"), 0, 0, null, new String[]{Messages.getString("LevelPropertiesDialogEx.Ok")}, Messages.getString("LevelPropertiesDialogEx.Ok"));
                        } else {
                            SelectAttributesDialog dialog = new SelectAttributesDialog(LevelPropertiesDialogEx.this.getAppView(), LevelPropertiesDialogEx.this.lkList, ent);
                            dialog.setVisible(true);
                            LevelPropertiesDialogEx.this.lkTable.clearSelection();
                            int lastRow = LevelPropertiesDialogEx.this.lkTable.convertRowIndexToView(LevelPropertiesDialogEx.this.lkTable.getModel().getRowCount() - 1);
                            LevelPropertiesDialogEx.this.lkTable.setRowSelectionInterval(lastRow, lastRow);
                            LevelPropertiesDialogEx.this.lkTable.updateUI();
                        }
                    }
                });
                this.btnRemoveLevelKeyProperty = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveLevelKeyProperty.setEnabled(false);
                this.btnRemoveLevelKeyProperty.setToolTipText(BTN_REMOVE);
                this.btnRemoveLevelKeyProperty.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = LevelPropertiesDialogEx.this.lkTable.getSelectedRow();
                        if (objectNumber != -1 && LevelPropertiesDialogEx.this.lkList.size() > 0 && objectNumber < LevelPropertiesDialogEx.this.lkList.size()) {
                            LevelPropertiesDialogEx.this.lkList.remove(objectNumber);
                            LevelPropertiesDialogEx.this.lkTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemoveLevelKeyProperty);
            }
            buttonGeneral.add(toolBar);
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.lkPanel.add(aPanel);
        }
        return this.lkPanel;
    }

    private void updateHistoryElements(SlowChangingAttribute scha) {
        this.hList.clear();
        Iterator it = scha.getHistoryAttributes().iterator();
        while (it.hasNext()) {
            this.hList.add(it.next());
        }
        this.hTable.updateUI();
    }

    protected JPanel getDescriptiveAttributesPanel() {
        if (this.daPanel == null) {
            this.cbEntityAttributes = new JComboBox();
            this.daPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.DescriptiveAttributes"));
            this.daList = new ArrayList();
            this.daTable = new JTable(new DescriptiveAttributesModel());
            JComboBox<String> cbTypes = new JComboBox<String>(SlowChangingAttribute.TYPES);
            this.daTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(cbTypes));
            this.daTable.setSelectionMode(0);
            TableColumn tc = this.daTable.getColumnModel().getColumn(1);
            tc.setCellEditor(new DefaultCellEditor(this.cbEntityAttributes));
            this.daTable.getSelectionModel().addListSelectionListener(new SelectionListener());
            this.daTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SlowChangingAttribute attribute;
                    int row;
                    if (e.getClickCount() == 2 && (row = LevelPropertiesDialogEx.this.daTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && row < LevelPropertiesDialogEx.this.daList.size() && (attribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row)).getAttribute() != null) {
                        attribute.getAttribute().showPropertyDialog(LevelPropertiesDialogEx.this);
                    }
                }
            });
            this.daTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                        if (selectedRow == -1) {
                            LevelPropertiesDialogEx.this.btnDescriptiveAttributeProperties.setEnabled(false);
                            LevelPropertiesDialogEx.this.btnRemoveDescriptiveAttribute.setEnabled(false);
                        } else {
                            LevelPropertiesDialogEx.this.btnDescriptiveAttributeProperties.setEnabled(true);
                            LevelPropertiesDialogEx.this.btnRemoveDescriptiveAttribute.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.daTable);
            JPanel buttonGeneral = new JPanel(new BorderLayout());
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnDescriptiveAttributeProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnDescriptiveAttributeProperties.setEnabled(false);
            this.btnDescriptiveAttributeProperties.setToolTipText(BTN_PROPERTIES);
            this.btnDescriptiveAttributeProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SlowChangingAttribute attribute;
                    int row = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                    if (row > -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && row < LevelPropertiesDialogEx.this.daList.size() && (attribute = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row)).getAttribute() != null) {
                        attribute.getAttribute().showPropertyDialog(LevelPropertiesDialogEx.this);
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnDescriptiveAttributeProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ContainerObject ent = (ContainerObject)LevelPropertiesDialogEx.this.cbLevelEntity.getSelectedItem();
                        SlowChangingAttribute sca = new SlowChangingAttribute(LevelPropertiesDialogEx.this.level, "Attr" + (LevelPropertiesDialogEx.this.daList.size() + 1));
                        LevelPropertiesDialogEx.this.daList.add(sca);
                        LevelPropertiesDialogEx.this.daTable.clearSelection();
                        int lastRow = LevelPropertiesDialogEx.this.daTable.convertRowIndexToView(LevelPropertiesDialogEx.this.daTable.getModel().getRowCount() - 1);
                        LevelPropertiesDialogEx.this.daTable.setRowSelectionInterval(lastRow, lastRow);
                        LevelPropertiesDialogEx.this.daTable.updateUI();
                        LevelPropertiesDialogEx.this.setCBDescAttr();
                    }
                });
                this.btnRemoveDescriptiveAttribute = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveDescriptiveAttribute.setEnabled(false);
                this.btnRemoveDescriptiveAttribute.setToolTipText(BTN_REMOVE);
                this.btnRemoveDescriptiveAttribute.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                        if (objectNumber != -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && objectNumber < LevelPropertiesDialogEx.this.daList.size()) {
                            LevelPropertiesDialogEx.this.daList.remove(objectNumber);
                            LevelPropertiesDialogEx.this.daTable.updateUI();
                            LevelPropertiesDialogEx.this.setCBDescAttr();
                        }
                    }
                });
                JButton btnAddAttr = new JButton(configuration.getIcon("SYNC_DICT_WITH_MODEL", this.getPreferredIconSize()));
                btnAddAttr.setToolTipText(ADD_ATTRIBUTES_FROM_ENTITY);
                btnAddAttr.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ContainerObject ent = (ContainerObject)LevelPropertiesDialogEx.this.cbLevelEntity.getSelectedItem();
                        if (ent == null) {
                            JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("LevelPropertiesDialogEx.SetLevelEntityFirst"), Messages.getString("LevelPropertiesDialogEx.LevelEntityNotSet"), 0, 0, null, new String[]{Messages.getString("LevelPropertiesDialogEx.Ok")}, Messages.getString("LevelPropertiesDialogEx.Ok"));
                        } else {
                            ArrayList list = new ArrayList();
                            SelectDescriptiveAttributesDialog dialog = new SelectDescriptiveAttributesDialog(LevelPropertiesDialogEx.this.getAppView(), list, ent, LevelPropertiesDialogEx.this.level);
                            dialog.setVisible(true);
                            LevelPropertiesDialogEx.this.daList.addAll(list);
                            LevelPropertiesDialogEx.this.daTable.updateUI();
                            LevelPropertiesDialogEx.this.setCBDescAttr();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemoveDescriptiveAttribute);
                toolBar.add(btnAddAttr);
            }
            scrollpane.setPreferredSize(new Dimension(325, 165));
            JPanel aPanel = new JPanel(new BorderLayout());
            JPanel schpanel = new JPanel(new BorderLayout());
            schpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("LevelPropertiesDialogEx.Attributes")));
            JPanel jpanel = new JPanel(new GridLayout(1, 2));
            jpanel.add(toolBar);
            schpanel.add((Component)jpanel, "North");
            schpanel.add(scrollpane);
            this.hList = new ArrayList();
            this.descAlist = new ArrayList();
            JPanel history = new JPanel(new BorderLayout());
            history.setBorder(BorderFactory.createTitledBorder(Messages.getString("LevelPropertiesDialogEx.HistoryAttributes")));
            this.hTable = new JTable(new HistoryElementsModel());
            this.hTable.setSelectionMode(0);
            this.hTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = LevelPropertiesDialogEx.this.hTable.getSelectedRow()) != -1 && LevelPropertiesDialogEx.this.hList.size() > 0 && row < LevelPropertiesDialogEx.this.hList.size()) {
                        DesignObject object = (DesignObject)LevelPropertiesDialogEx.this.hList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane2 = new JScrollPane(this.hTable);
            scrollpane2.setPreferredSize(new Dimension(325, 100));
            JPanel buttonGeneral2 = new JPanel(new GridLayout(1, 2));
            buttonGeneral2.setPreferredSize(new Dimension(325, 35));
            this.bnHProperties = new JButton(configuration.getIcon("PROPERTIES_ICON", this.getPreferredIconSize()));
            this.bnHProperties.setToolTipText(Messages.getString("LevelPropertiesDialogEx.Properties"));
            this.bnHProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = LevelPropertiesDialogEx.this.hTable.getSelectedRow();
                    if (row != -1 && LevelPropertiesDialogEx.this.hList.size() > 0 && row < LevelPropertiesDialogEx.this.hList.size()) {
                        DesignObject object = (DesignObject)LevelPropertiesDialogEx.this.hList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar2 = new JToolBar(0);
            toolBar2.setFloatable(false);
            toolBar2.add(this.bnHProperties);
            if (this.isEditable()) {
                this.bnHAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.bnHAdd.setToolTipText(Messages.getString("LevelPropertiesDialogEx.Add"));
                this.bnHAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LevelPropertiesDialogEx.this.descAlist = LevelPropertiesDialogEx.this.copySCAtt_to_NormalAttr(LevelPropertiesDialogEx.this.daList);
                        SelectElementsDialog dialog = new SelectElementsDialog(LevelPropertiesDialogEx.this.getAppView(), LevelPropertiesDialogEx.this.descAlist, LevelPropertiesDialogEx.this.hList);
                        dialog.setVisible(true);
                        LevelPropertiesDialogEx.this.hTable.updateUI();
                        int row = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                        if (row != -1 && !dialog.cancel) {
                            SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
                            scha.getHistoryAttributes().clear();
                            for (ContainedObject attribute : LevelPropertiesDialogEx.this.hList) {
                                scha.addHistoryAttribute(attribute);
                            }
                        }
                    }
                });
                this.bnHRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.bnHRemove.setToolTipText(Messages.getString("LevelPropertiesDialogEx.Remove"));
                this.bnHRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = LevelPropertiesDialogEx.this.hTable.getSelectedRow();
                        if (objectNumber != -1 && LevelPropertiesDialogEx.this.hList.size() > 0 && objectNumber < LevelPropertiesDialogEx.this.hList.size()) {
                            LevelPropertiesDialogEx.this.hList.remove(objectNumber);
                            LevelPropertiesDialogEx.this.hTable.updateUI();
                            int row = LevelPropertiesDialogEx.this.daTable.getSelectedRow();
                            if (row != -1) {
                                SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
                                scha.getHistoryAttributes().clear();
                                for (ContainedObject attribute : LevelPropertiesDialogEx.this.hList) {
                                    scha.addHistoryAttribute(attribute);
                                }
                            }
                        }
                    }
                });
                toolBar2.addSeparator();
                toolBar2.add(this.bnHAdd);
                toolBar2.add(this.bnHRemove);
            }
            this.enableButtons(false);
            buttonGeneral2.add(toolBar2);
            history.add((Component)buttonGeneral2, "North");
            history.add(scrollpane2);
            buttonGeneral.add((Component)schpanel, "North");
            buttonGeneral.add(history);
            aPanel.add(buttonGeneral);
            this.daPanel.add(aPanel);
        }
        return this.daPanel;
    }

    private void enableButtons(boolean enable) {
        if (this.isEditable()) {
            this.bnHProperties.setEnabled(enable);
            this.bnHAdd.setEnabled(enable);
            this.bnHRemove.setEnabled(enable);
        }
    }

    protected JPanel getParentKeyPanel() {
        if (this.pkPanel == null) {
            this.pkPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.ParentKey"));
            this.pkList = new ArrayList();
            this.pkTable = new JTable(new ParentKeyModel());
            this.pkTable.setSelectionMode(0);
            this.pkTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = LevelPropertiesDialogEx.this.pkTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.pkList.size() > 0 && row < LevelPropertiesDialogEx.this.pkList.size()) {
                        ContainedObject attribute = (ContainedObject)LevelPropertiesDialogEx.this.pkList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.pkTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.bnPKProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.bnPKProperties.setToolTipText(BTN_PROPERTIES);
            this.bnPKProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = LevelPropertiesDialogEx.this.pkTable.getSelectedRow();
                    if (row > -1 && LevelPropertiesDialogEx.this.pkList.size() > 0 && row < LevelPropertiesDialogEx.this.pkList.size()) {
                        ContainedObject attribute = (ContainedObject)LevelPropertiesDialogEx.this.pkList.get(row);
                        attribute.showPropertyDialog();
                    }
                }
            });
            JToolBar tbParentKey = new JToolBar(0);
            tbParentKey.setFloatable(false);
            tbParentKey.add(this.bnPKProperties);
            if (this.isEditable()) {
                this.bnPKAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.bnPKAdd.setToolTipText(BTN_ADD);
                this.bnPKAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ContainerObject ent = LevelPropertiesDialogEx.this.level.getLevelEntity();
                        SelectAttributesDialog dialog = new SelectAttributesDialog(LevelPropertiesDialogEx.this.getAppView(), LevelPropertiesDialogEx.this.pkList, ent);
                        dialog.show();
                        LevelPropertiesDialogEx.this.pkTable.updateUI();
                    }
                });
                this.bnPKRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.bnPKRemove.setToolTipText(BTN_REMOVE);
                this.bnPKRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = LevelPropertiesDialogEx.this.pkTable.getSelectedRow();
                        if (objectNumber != -1 && LevelPropertiesDialogEx.this.pkList.size() > 0 && objectNumber < LevelPropertiesDialogEx.this.pkList.size()) {
                            LevelPropertiesDialogEx.this.pkList.remove(objectNumber);
                            LevelPropertiesDialogEx.this.pkTable.updateUI();
                        }
                    }
                });
                tbParentKey.addSeparator();
                tbParentKey.add(this.bnPKAdd);
                tbParentKey.add(this.bnPKRemove);
            }
            buttonGeneral.add(tbParentKey);
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pkPanel.add(aPanel);
        }
        return this.pkPanel;
    }

    protected JPanel getCalcAttributesPanel() {
        if (this.caPanel == null) {
            this.caPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.CalculatedAttributes"));
            this.calcAttrList = new ArrayList();
            this.caTable = new JTable(new ParametersModel());
            this.caTable.setSelectionMode(0);
            TableColumn tc = this.caTable.getColumnModel().getColumn(1);
            tc.setCellEditor(new FormulaEditor());
            JScrollPane scrollpane = new JScrollPane(this.caTable);
            this.caTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = LevelPropertiesDialogEx.this.caTable.getSelectedRow();
                        if (selectedRow == -1) {
                            LevelPropertiesDialogEx.this.btnRemoveCalcAttribute.setEnabled(false);
                        } else {
                            LevelPropertiesDialogEx.this.btnRemoveCalcAttribute.setEnabled(true);
                        }
                    }
                }
            });
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CalculatedAttribute param = LevelPropertiesDialogEx.this.level.createCalculatedAttribute();
                        LevelPropertiesDialogEx.this.calcAttrList.add(param);
                        LevelPropertiesDialogEx.this.caTable.clearSelection();
                        int lastRow = LevelPropertiesDialogEx.this.caTable.convertRowIndexToView(LevelPropertiesDialogEx.this.caTable.getModel().getRowCount() - 1);
                        LevelPropertiesDialogEx.this.caTable.setRowSelectionInterval(lastRow, lastRow);
                        LevelPropertiesDialogEx.this.caTable.updateUI();
                    }
                });
                this.btnRemoveCalcAttribute = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemoveCalcAttribute.setEnabled(false);
                this.btnRemoveCalcAttribute.setToolTipText(BTN_REMOVE);
                this.btnRemoveCalcAttribute.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = LevelPropertiesDialogEx.this.caTable.getSelectedRow();
                        if (objectNumber != -1 && LevelPropertiesDialogEx.this.calcAttrList.size() > 0 && objectNumber < LevelPropertiesDialogEx.this.calcAttrList.size()) {
                            LevelPropertiesDialogEx.this.calcAttrList.remove(objectNumber);
                            LevelPropertiesDialogEx.this.caTable.updateUI();
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemoveCalcAttribute);
                buttonGeneral.add(toolBar);
            }
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.caPanel.add(aPanel);
        }
        return this.caPanel;
    }

    protected JPanel getOracleAWAttributesPanel() {
        if (this.oraAWPanel == null) {
            this.oraAWPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.OracleAWAttributes"));
            this.cbDescAttr = new JComboBox();
            this.oraAWTable = new JTable(new AWAttributesModel());
            this.oraAWTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.cbDescAttr));
            this.oraAWTable.setSelectionMode(0);
            this.oraAWTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ContainedObject attr;
                    int row;
                    if (e.getClickCount() == 2 && (row = LevelPropertiesDialogEx.this.oraAWTable.getSelectedRow()) > -1 && LevelPropertiesDialogEx.this.daList.size() > 0 && row < LevelPropertiesDialogEx.this.daList.size() && (attr = (ContainedObject)LevelPropertiesDialogEx.this.oraAWTable.getModel().getValueAt(row, 1)) != null) {
                        attr.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.oraAWTable);
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add(scrollpane);
            this.oraAWPanel.add(aPanel);
        }
        return this.oraAWPanel;
    }

    protected JPanel getMSOlapPanel() {
        if (this.olapPanel == null) {
            this.olapPanel = this.createPage(Messages.getString("LevelPropertiesDialogEx.MSOlap"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel jpanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbNameColumn = new JLabel(LB_NAME_COLUMN);
            lbNameColumn.setPreferredSize(this.getDefaultSize());
            this.cbNameColumn = new JLNComboBox();
            this.cbNameColumn.setMaximumRowCount(20);
            this.cbNameColumn.setPreferredSize(this.getDefaultSize());
            jpanel2.add(this.createRow(lbNameColumn, this.cbNameColumn));
            JLabel lbValueColumn = new JLabel(LB_VALUE_COLUMN);
            lbValueColumn.setPreferredSize(this.getDefaultSize());
            this.cbValueColumn = new JLNComboBox();
            this.cbValueColumn.setMaximumRowCount(20);
            this.cbValueColumn.setPreferredSize(this.getDefaultSize());
            jpanel2.add(this.createRow(lbValueColumn, this.cbValueColumn));
            jpanel.add((Component)jpanel2, "North");
            this.olapPanel.add(jpanel);
        }
        return this.olapPanel;
    }

    private List getOlapAttributes() {
        if (this.olapAttribues == null) {
            this.olapAttribues = new ArrayList();
            this.olapAttribues.add(null);
            this.olapAttribues.addAll(this.level.getMultidimensionalDesign().getAllContained());
        }
        return this.olapAttribues;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class LevelKeyModel
    extends AbstractTableModel {
        private LevelKeyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.lkList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainedObject attribute = (ContainedObject)LevelPropertiesDialogEx.this.lkList.get(row);
            if (col == 0) {
                return attribute.getLongName();
            }
            return new Integer(row * col);
        }
    }

    private class DescriptiveAttributesModel
    extends AbstractTableModel {
        private DescriptiveAttributesModel() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.daList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 1) {
                return Messages.getString("LevelPropertiesDialogEx.Attribute");
            }
            if (column == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Name");
            }
            if (column == 2) {
                return Messages.getString("LevelPropertiesDialogEx.Indexed");
            }
            if (column == 3) {
                return Messages.getString("LevelPropertiesDialogEx.SlowChanging");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return LevelPropertiesDialogEx.this.isEditable();
        }

        public Class getColumnClass(int c) {
            if (c == 1) {
                return ContainedObject.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0 && aValue instanceof String) {
                SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
                scha.setName((String)aValue);
            } else if (column == 3) {
                SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
                scha.setType(String.valueOf(aValue));
                if (scha.getType().equalsIgnoreCase(SlowChangingAttribute.TYPES[3])) {
                    LevelPropertiesDialogEx.this.updateHistoryElements(scha);
                    LevelPropertiesDialogEx.this.enableButtons(true);
                } else {
                    scha.getHistoryAttributes().clear();
                    LevelPropertiesDialogEx.this.hList.clear();
                    LevelPropertiesDialogEx.this.hTable.updateUI();
                    LevelPropertiesDialogEx.this.enableButtons(false);
                }
            } else if (column == 2) {
                if (aValue instanceof Boolean) {
                    SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
                    scha.setIndexed((Boolean)aValue);
                }
            } else if (column == 1) {
                SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
                if (aValue instanceof ContainedObject) {
                    scha.setAttribute((ContainedObject)aValue);
                } else if (aValue == null) {
                    scha.setAttribute(null);
                }
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
            if (col == 1) {
                return scha.getAttribute();
            }
            if (col == 0) {
                return scha.getName();
            }
            if (col == 3) {
                return scha.getType();
            }
            return new Boolean(scha.isIndexed());
        }
    }

    public class SelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int row = ((ListSelectionModel)e.getSource()).getAnchorSelectionIndex();
            if (row != -1) {
                SlowChangingAttribute scha = (SlowChangingAttribute)LevelPropertiesDialogEx.this.daList.get(row);
                if (scha.getType().equalsIgnoreCase(SlowChangingAttribute.TYPES[3])) {
                    LevelPropertiesDialogEx.this.updateHistoryElements(scha);
                    LevelPropertiesDialogEx.this.enableButtons(true);
                } else {
                    scha.getHistoryAttributes().clear();
                    LevelPropertiesDialogEx.this.hList.clear();
                    LevelPropertiesDialogEx.this.hTable.updateUI();
                    LevelPropertiesDialogEx.this.enableButtons(false);
                }
            } else {
                LevelPropertiesDialogEx.this.enableButtons(false);
            }
        }
    }

    private class HistoryElementsModel
    extends AbstractTableModel {
        private HistoryElementsModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.hList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)LevelPropertiesDialogEx.this.hList.get(row);
            if (col == 0) {
                return object.getLongName();
            }
            return new Integer(row * col);
        }
    }

    private class ParentKeyModel
    extends AbstractTableModel {
        private ParentKeyModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.pkList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("LevelPropertiesDialogEx.Attributes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ContainedObject attribute = (ContainedObject)LevelPropertiesDialogEx.this.pkList.get(row);
            if (col == 0) {
                return attribute.getLongName();
            }
            return new Integer(row * col);
        }
    }

    private class ParametersModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return LevelPropertiesDialogEx.this.calcAttrList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("LevelPropertiesDialogEx.CalculatedAttribute");
            }
            return Messages.getString("LevelPropertiesDialogEx.Expression");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return LevelPropertiesDialogEx.this.isEditable();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CalculatedAttribute param = (CalculatedAttribute)LevelPropertiesDialogEx.this.calcAttrList.get(row);
            if (col == 0) {
                return param.getName();
            }
            return param.getFunction();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            CalculatedAttribute param = (CalculatedAttribute)LevelPropertiesDialogEx.this.calcAttrList.get(row);
            if (col == 0) {
                param.setName((String)value);
            } else if (col == 1) {
                param.setFunction((String)value);
            }
            this.fireTableCellUpdated(row, col);
        }
    }

    public class FormulaEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        StringEditor editor;
        String currentText;
        JButton button = new JButton();
        protected static final String EDIT = "edit";

        public FormulaEditor() {
            this.button.setActionCommand(EDIT);
            this.button.addActionListener(this);
            this.button.setBorderPainted(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EDIT.equals(e.getActionCommand())) {
                this.button.setText(this.currentText);
                this.editor = new StringEditor(LevelPropertiesDialogEx.this.getAppView(), this.currentText, Messages.getString("MeasurePropertiesDialogEx.FormulaEditor"), 550, 450, true);
                this.editor.setModal(true);
                this.editor.show();
                if (!this.editor.cancel) {
                    this.currentText = this.editor.getText();
                }
                this.fireEditingStopped();
            } else {
                this.currentText = this.editor.getText();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentText;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentText = (String)value;
            return this.button;
        }
    }

    class AWAttributesModel
    extends AbstractTableModel {
        String[] cNames = new String[]{Messages.getString("LevelPropertiesDialogEx.AWAttribute"), Messages.getString("LevelPropertiesDialogEx.EntityAttribute")};

        AWAttributesModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            return 4;
        }

        public void dataChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!LevelPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Level.OraAWAttributes oa = LevelPropertiesDialogEx.this.currentOraAWAttr;
            if (col == 0) {
                switch (row) {
                    case 0: {
                        return Messages.getString("LevelPropertiesDialogEx.ShortDescription");
                    }
                    case 1: {
                        return Messages.getString("LevelPropertiesDialogEx.LongDescription");
                    }
                    case 2: {
                        return Messages.getString("LevelPropertiesDialogEx.TimeSpan");
                    }
                    case 3: {
                        return Messages.getString("LevelPropertiesDialogEx.TimeEnd");
                    }
                }
                return "";
            }
            switch (row) {
                case 0: {
                    return oa.shortDesc;
                }
                case 1: {
                    return oa.longDesc;
                }
                case 2: {
                    return oa.timeSpan;
                }
                case 3: {
                    return oa.timeEnd;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int row, int columnIndex) {
            if (aValue != null && !(aValue instanceof ContainedObject)) {
                return;
            }
            if (columnIndex == 1) {
                switch (row) {
                    case 0: {
                        LevelPropertiesDialogEx.this.currentOraAWAttr.shortDesc = (ContainedObject)aValue;
                        break;
                    }
                    case 1: {
                        LevelPropertiesDialogEx.this.currentOraAWAttr.longDesc = (ContainedObject)aValue;
                        break;
                    }
                    case 2: {
                        LevelPropertiesDialogEx.this.currentOraAWAttr.timeSpan = (ContainedObject)aValue;
                        break;
                    }
                    case 3: {
                        LevelPropertiesDialogEx.this.currentOraAWAttr.timeEnd = (ContainedObject)aValue;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
    }
}

