/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.swingui.editor.multidimensional.MultidimensionalObjectPropertiesDialog;

public class HierarchyPropertiesDialogEx
extends MultidimensionalObjectPropertiesDialog {
    private Hierarchy hierarchy;
    private JCheckBox chValueBased;
    private JTable levelsTable;
    private List levelsList;
    private JTable linksTable;
    private List linksList;
    private JCheckBox chRaggedHier;
    private JCheckBox chDefaultdHier;
    private JPanel pnLevels;
    private JPanel pnLinks;
    private JButton btnLevelProperties;
    private JButton btnLinkProperties;

    public HierarchyPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    private void initGeneral() {
        JLabel lbValueBased = new JLabel(LB_VALUE_BASED);
        lbValueBased.setPreferredSize(this.getDefaultSize());
        this.chValueBased = new JCheckBox();
        this.chValueBased.setPreferredSize(this.getDefaultSize());
        this.chValueBased.setEnabled(false);
        this.chValueBased.setToolTipText(Messages.getString("HierarchyPropertiesDialogEx.FirstAttachedLevel"));
        this.addRowToGeneralPanel(this.createRow(lbValueBased, this.chValueBased));
        JLabel lbRaggedHier = new JLabel(Messages.getString("HierarchyPropertiesDialogEx.RaggedHierarchy"));
        lbRaggedHier.setPreferredSize(this.getDefaultSize());
        this.chRaggedHier = new JCheckBox();
        this.chRaggedHier.setPreferredSize(this.getDefaultSize());
        this.chRaggedHier.setEnabled(false);
        this.addRowToGeneralPanel(this.createRow(lbRaggedHier, this.chRaggedHier));
        JLabel lbDefaultHier = new JLabel(Messages.getString("HierarchyPropertiesDialogEx.DefaultHierarchy"));
        lbDefaultHier.setPreferredSize(this.getDefaultSize());
        this.chDefaultdHier = new JCheckBox();
        this.chDefaultdHier.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDefaultHier, this.chDefaultdHier));
    }

    @Override
    public String getCaption() {
        return Messages.getString("HierarchyPropertiesDialogEx.HierarchyProperties");
    }

    @Override
    protected String getHelpIndex() {
        return "HIERARCHY_PROPERTIES_DIALOG";
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Hierarchy) {
            this.hierarchy = (Hierarchy)object;
            this.initDefaults(false);
            this.taDescription.setText(this.hierarchy.getDescription());
            this.chValueBased.setSelected(this.hierarchy.isValueBasedHierarchy());
            this.chRaggedHier.setSelected(this.hierarchy.isRaggedHierarchy());
            this.chDefaultdHier.setSelected(this.hierarchy.isDefaultHierarchy());
            this.levelsList.addAll(this.hierarchy.getLevels());
            this.linksList.addAll(this.hierarchy.getLinks());
            this.initOracleNames();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.levelsList = new ArrayList();
        this.linksList = new ArrayList();
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getLevelsPanel());
        this.addToTree(root, this.getLinksPanel());
        this.addToTree(root, this.getOracleNamesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDescriptionPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected void setProperties() {
        this.hierarchy.setName(this.tfName.getText());
        this.hierarchy.setComment(this.taComments.getText());
        this.hierarchy.setNotes(this.taNotes.getText());
        this.hierarchy.setDescription(this.taDescription.getText());
        this.hierarchy.setDefaultHierarchy(this.chDefaultdHier.isSelected());
        this.setOracleNames();
        this.setResponsibleParties();
        this.setDocuments();
        HierarchyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.hierarchy.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.hierarchy.setProperty(dp.getName(), dp.getValue());
        }
    }

    protected JPanel getLevelsPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("HierarchyPropertiesDialogEx.Levels"));
            this.levelsTable = new JTable(new LevelTableModel());
            this.levelsTable.setSelectionMode(0);
            this.levelsTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = HierarchyPropertiesDialogEx.this.levelsTable.getSelectedRow()) != -1 && HierarchyPropertiesDialogEx.this.levelsList.size() > 0 && row < HierarchyPropertiesDialogEx.this.levelsList.size()) {
                        Level level = (Level)HierarchyPropertiesDialogEx.this.levelsList.get(row);
                        level.showPropertyDialog();
                    }
                }
            });
            this.levelsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = HierarchyPropertiesDialogEx.this.levelsTable.getSelectedRow();
                        if (selectedRow == -1) {
                            HierarchyPropertiesDialogEx.this.btnLevelProperties.setEnabled(false);
                        } else {
                            HierarchyPropertiesDialogEx.this.btnLevelProperties.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.levelsTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnLevelProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnLevelProperties.setEnabled(false);
            this.btnLevelProperties.setToolTipText(BTN_PROPERTIES);
            this.btnLevelProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = HierarchyPropertiesDialogEx.this.levelsTable.getSelectedRow();
                    if (row != -1 && HierarchyPropertiesDialogEx.this.levelsList.size() > 0 && row < HierarchyPropertiesDialogEx.this.levelsList.size()) {
                        Level level = (Level)HierarchyPropertiesDialogEx.this.levelsList.get(row);
                        level.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnLevelProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnLevels.add(pPanel);
        }
        return this.pnLevels;
    }

    protected JPanel getLinksPanel() {
        if (this.pnLinks == null) {
            this.pnLinks = this.createPage(Messages.getString("HierarchyPropertiesDialogEx.RollupLinks"));
            this.linksTable = new JTable(new LinkTableModel());
            this.linksTable.setSelectionMode(0);
            this.linksTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = HierarchyPropertiesDialogEx.this.linksTable.getSelectedRow()) != -1 && HierarchyPropertiesDialogEx.this.linksList.size() > 0 && row < HierarchyPropertiesDialogEx.this.linksList.size()) {
                        RollupLink link = (RollupLink)HierarchyPropertiesDialogEx.this.linksList.get(row);
                        link.showPropertyDialog();
                    }
                }
            });
            this.linksTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int selectedRow = HierarchyPropertiesDialogEx.this.linksTable.getSelectedRow();
                        if (selectedRow == -1) {
                            HierarchyPropertiesDialogEx.this.btnLinkProperties.setEnabled(false);
                        } else {
                            HierarchyPropertiesDialogEx.this.btnLinkProperties.setEnabled(true);
                        }
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.linksTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.btnLinkProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            this.btnLinkProperties.setEnabled(false);
            this.btnLinkProperties.setToolTipText(BTN_PROPERTIES);
            this.btnLinkProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = HierarchyPropertiesDialogEx.this.linksTable.getSelectedRow();
                    if (row != -1 && HierarchyPropertiesDialogEx.this.linksList.size() > 0 && row < HierarchyPropertiesDialogEx.this.linksList.size()) {
                        RollupLink link = (RollupLink)HierarchyPropertiesDialogEx.this.linksList.get(row);
                        link.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(this.btnLinkProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnLinks.add(pPanel);
        }
        return this.pnLinks;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class LevelTableModel
    extends AbstractTableModel {
        private LevelTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return HierarchyPropertiesDialogEx.this.levelsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("HierarchyPropertiesDialogEx.Levels");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Level object = (Level)HierarchyPropertiesDialogEx.this.levelsList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class LinkTableModel
    extends AbstractTableModel {
        private LinkTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return HierarchyPropertiesDialogEx.this.linksList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("HierarchyPropertiesDialogEx.RollupLinks");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            RollupLink object = (RollupLink)HierarchyPropertiesDialogEx.this.linksList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

