/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.imports.ddl.DDLStatementHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_EntityView;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.designrules.DRViewCaseType;
import oracle.dbtools.crest.model.designrules.DRViewMaxNameLength;
import oracle.dbtools.crest.model.designrules.DRViewValidCharacters;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.EntityViewBuilder;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QBUtils;
import oracle.dbtools.crest.swingui.editor.viewbuilder.QueryBuilderPanel;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.LNComboTableCellRenderer;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class EntityViewPropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private EntityView entityView;
    private JButton btnQueryBuilder;
    private JComboBox cbBaseOnStructuredType;
    private JComboBox cbType;
    private JDialog builder;
    private StructuredType st_type;
    private JPanel pnElementComments;
    private JTable tbElements;
    private RSyntaxTextArea taColumnComments;
    private RSyntaxTextArea taColumnNotes;
    private RSyntaxTextArea taColumnCommentsInRDBMS;
    private List lsElements;
    private JCheckBox chAutoJoin;
    private JTree tree;
    private JComboBox cbSubViews;
    private int currentElement;
    private JCheckBox chbDeprecated;
    private JPanel pnQuery;
    private RSyntaxTextArea taQueryText;
    private String savedUserDefinedSQL = "";
    private DefaultMutableTreeNode udpNode;

    public EntityViewPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public EntityViewPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("EntityViewPropertiesDialogEx.ViewProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof EntityView) {
            this.entityView = (EntityView)object;
            this.initDefaults();
            this.fillComboItems(this.getStructuredTypes().toArray(), this.cbBaseOnStructuredType, true);
            this.cbBaseOnStructuredType.setSelectedItem(this.entityView.getBasedOnStructuredType());
            this.cbType.setSelectedItem(this.entityView.getViewType());
            if (this.entityView.isBST()) {
                this.st_type = this.entityView.getBasedOnStructuredType();
            }
            if (this.btnQueryBuilder != null) {
                this.btnQueryBuilder.setEnabled(this.isEditable());
            }
            this.enablePanels(this.st_type != null);
            this.savedUserDefinedSQL = this.entityView.getUserDefinedSQL();
            this.taQueryText.setText(this.savedUserDefinedSQL);
            this.taQueryText.setCaretPosition(0);
            this.updateElementsList();
            this.enableQueryPanelFields(this.isEditable());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.chbDeprecated.setSelected(this.entityView.isDeprecated());
            this.initDynamicProperties();
            this.initUserDefinedProperties();
            this.initUDPGroupsTree(this.udpNode);
            String useObjectsFrom = this.entityView.getUseObjectsOnlyFrom();
            DesignPartView usedDPV = null;
            this.cbSubViews.addItem(this.entityView.getDesignPart().getMainView());
            Iterator svit = this.entityView.getDesignPart().getDesignSubviews().iterator();
            while (svit.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)svit.next();
                DesignPartView dpv = ph.getDesignPartView();
                this.cbSubViews.addItem(dpv);
                if (useObjectsFrom.length() <= 0 || !dpv.getDPVId().equalsIgnoreCase(useObjectsFrom)) continue;
                usedDPV = dpv;
            }
            if (usedDPV != null) {
                this.cbSubViews.setSelectedItem(usedDPV);
            }
        }
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRViewMaxNameLength(), this.entityView);
        this.checkDesignRule(new DRViewCaseType(), this.entityView);
        this.checkDesignRule(new DRViewValidCharacters(), this.entityView);
    }

    @Override
    protected int getMinimumTreeWidth() {
        return 210;
    }

    private void updateElementsList() {
        this.currentElement = -1;
        this.taColumnComments.setText("");
        this.taColumnComments.setEnabled(false);
        this.taColumnCommentsInRDBMS.setText("");
        this.taColumnCommentsInRDBMS.setEnabled(false);
        this.taColumnNotes.setText("");
        this.taColumnNotes.setEnabled(false);
        ContainedObject[] elements = this.entityView.getElements();
        List<ContainedObject> tempList = Arrays.asList(elements);
        for (int i = this.lsElements.size() - 1; i >= 0; --i) {
            ElementHelper elementHelper = (ElementHelper)this.lsElements.get(i);
            if (tempList.contains(elementHelper.getElement())) continue;
            this.lsElements.remove(i);
        }
        for (AbstractViewElement abstractViewElement : tempList) {
            if (this.listContainsElement(abstractViewElement)) continue;
            ElementHelper helper = new ElementHelper(abstractViewElement);
            this.lsElements.add(helper);
        }
        this.tbElements.updateUI();
        this.tbElements.clearSelection();
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedElement();
        super.showComponent(component);
    }

    private boolean listContainsElement(AbstractViewElement element) {
        for (ElementHelper helper : this.lsElements) {
            if (helper.getElement() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void setProperties() {
        this.entityView.setName(this.tfName.getText());
        this.entityView.setComment(this.taComments.getText());
        this.entityView.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.entityView.setNotes(this.taNotes.getText());
        this.entityView.setBasedOnStructuredType((StructuredType)this.cbBaseOnStructuredType.getSelectedItem());
        this.entityView.setViewType((String)this.cbType.getSelectedItem());
        if (this.cbSubViews.getSelectedIndex() > 0) {
            this.entityView.setUseObjectsOnlyFrom(((DesignPartView)this.cbSubViews.getSelectedItem()).getDPVId());
        } else {
            this.entityView.setUseObjectsOnlyFrom("");
        }
        boolean hasHeader = this.entityView.hasValidHeader();
        for (AbstractViewElement cv : this.entityView.getElementsCollection()) {
            String name = cv.getPresentationName(hasHeader);
            if (name.equals(cv.getName())) continue;
            cv.setName(name);
        }
        String queryText = this.taQueryText.getText();
        this.entityView.setUserDefinedSQL(queryText);
        if (this.queryTextChanged(queryText)) {
            this.entityView.setParsed(false);
            boolean failed = false;
            try {
                QueryBuilder queryBuilder = new QueryBuilder(true);
                QBUtils.initMetadata(this.entityView.getDesignPart(), queryBuilder, null, false);
                this.entityView.parseOlderStyleView(queryBuilder, null);
            }
            catch (QueryBuilderException e) {
                e.printStackTrace();
                failed = true;
            }
            if (!failed) {
                this.entityView.setParsed(true);
                if (this.applyMode) {
                    this.updateElementsList();
                }
            }
        }
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.entityView.setDeprecated(this.chbDeprecated.isSelected());
        EntityViewPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.entityView.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.entityView.setProperty(dp.getName(), dp.getValue());
        }
        EntityViewPropertiesDialogEx.stopCellEditing(this.userDefinedPropertiesTable);
        Iterator itGroupUDPTables = this.getGroupUDPTables().iterator();
        while (itGroupUDPTables.hasNext()) {
            EntityViewPropertiesDialogEx.stopCellEditing((JTable)itGroupUDPTables.next());
        }
        for (AbstractPropertiesDialog.UDProperty dp : this.allUDPList) {
            if (dp.getValue() == null || dp.getValue().trim().equals("")) continue;
            this.entityView.setProperty(dp.getUserDefinedProperty().getName(), dp.getValue());
        }
        this.checkNamingOptions();
        this.applyElementsComments();
        this.entityView.updateRemoteObjectListeners();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getElementCommentsPanel());
        this.addToTree(root, this.getQueryPanel());
        this.addToTree(root, this.getEngineeringPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.udpNode = this.addToTree(root, this.getUserDefinedPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "LOGICAL_VIEW_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbBaseOnStructuredType = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        lbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType = new JComboBox();
        this.cbBaseOnStructuredType.setPreferredSize(this.getDefaultSize());
        this.cbBaseOnStructuredType.setMaximumRowCount(8);
        this.cbBaseOnStructuredType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = EntityViewPropertiesDialogEx.this.cbBaseOnStructuredType.getSelectedItem();
                EntityViewPropertiesDialogEx.this.st_type = (StructuredType)obj;
                if (EntityViewPropertiesDialogEx.this.btnQueryBuilder != null) {
                    EntityViewPropertiesDialogEx.this.btnQueryBuilder.setEnabled(EntityViewPropertiesDialogEx.this.isEditable() && EntityViewPropertiesDialogEx.this.st_type == null);
                }
                EntityViewPropertiesDialogEx.this.enablePanels(EntityViewPropertiesDialogEx.this.st_type != null);
            }
        });
        this.addRowToGeneralPanel(this.createRow(lbBaseOnStructuredType, this.cbBaseOnStructuredType));
        JLabel lbType = new JLabel(LB_VIEW_TYPE);
        lbType.setPreferredSize(this.getDefaultSize());
        this.cbType = new JComboBox<String>(EntityView.VIEW_TYPES);
        this.cbType.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbType, this.cbType));
        JLabel lbDeprecated = new JLabel(LB_DEPRECATED);
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
    }

    private void enablePanels(boolean enable) {
    }

    private List getStructuredTypes() {
        ArrayList<StructuredType> result = new ArrayList<StructuredType>();
        Iterator it = this.entityView.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (!st.isInstantiable()) continue;
            result.add(st);
        }
        return result;
    }

    public JDialog getBuilder() {
        if (this.builder == null) {
            this.builder = new EntityViewBuilder(this.entityView).getDialog(this.getAppView());
            return this.builder;
        }
        return this.builder;
    }

    private void setElementSelected() {
        int row;
        if (this.currentElement > -1) {
            this.setPreviousSelectedElement();
        }
        if ((row = this.tbElements.getSelectedRow()) != -1 && this.lsElements.size() > 0 && row < this.lsElements.size()) {
            this.currentElement = row;
            ElementHelper helper = (ElementHelper)this.lsElements.get(row);
            this.taColumnComments.setText(helper.getComments());
            this.taColumnComments.setEnabled(true);
            this.taColumnCommentsInRDBMS.setText(helper.getCommentsInRDBMS());
            this.taColumnCommentsInRDBMS.setEnabled(true);
            this.taColumnNotes.setText(helper.getNotes());
            this.taColumnNotes.setEnabled(true);
        }
    }

    protected JPanel getElementCommentsPanel() {
        if (this.pnElementComments == null) {
            this.currentElement = -1;
            this.pnElementComments = this.createPage(PANEL_ELEMENT_COMMENTS);
            this.tbElements = new JTable(new ElementsModel());
            this.tbElements.setSelectionMode(0);
            this.tbElements.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    EntityViewPropertiesDialogEx.this.setElementSelected();
                }
            });
            this.tbElements.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (EntityViewPropertiesDialogEx.this.lsElements.isEmpty()) {
                        EntityViewPropertiesDialogEx.this.taColumnComments.setText("");
                        EntityViewPropertiesDialogEx.this.taColumnComments.setEnabled(false);
                        EntityViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setText("");
                        EntityViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setEnabled(false);
                        EntityViewPropertiesDialogEx.this.taColumnNotes.setText("");
                        EntityViewPropertiesDialogEx.this.taColumnNotes.setEnabled(false);
                    } else {
                        EntityViewPropertiesDialogEx.this.taColumnComments.setEnabled(true);
                        EntityViewPropertiesDialogEx.this.taColumnCommentsInRDBMS.setEnabled(true);
                        EntityViewPropertiesDialogEx.this.taColumnNotes.setEnabled(true);
                        EntityViewPropertiesDialogEx.this.setElementSelected();
                    }
                }
            });
            this.lsElements = new ArrayList();
            JScrollPane sp = new JScrollPane(this.tbElements);
            sp.setPreferredSize(new Dimension(200, 200));
            this.pnElementComments.add((Component)sp, "North");
            JTabbedPane tpComments = new JTabbedPane();
            this.taColumnComments = new RSyntaxTextArea();
            this.taColumnComments.setLineWrap(true);
            this.taColumnComments.setWrapStyleWord(true);
            this.taColumnComments.setBorder(null);
            this.taColumnComments.setAntiAliasingEnabled(true);
            this.taColumnComments.setFont(this.tfName.getFont());
            this.taColumnNotes = new RSyntaxTextArea();
            this.taColumnNotes.setLineWrap(true);
            this.taColumnNotes.setWrapStyleWord(true);
            this.taColumnNotes.setBorder(null);
            this.taColumnNotes.setAntiAliasingEnabled(true);
            this.taColumnNotes.setFont(this.tfName.getFont());
            this.taColumnCommentsInRDBMS = new RSyntaxTextArea();
            this.taColumnCommentsInRDBMS.setLineWrap(true);
            this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
            this.taColumnCommentsInRDBMS.setBorder(null);
            this.taColumnCommentsInRDBMS.setAntiAliasingEnabled(true);
            this.taColumnCommentsInRDBMS.setFont(this.tfName.getFont());
            tpComments.addTab(Messages.getString("EntityViewPropertiesDialogEx.CommentsInRDBMS"), new JScrollPane((Component)this.taColumnCommentsInRDBMS));
            tpComments.addTab(Messages.getString("EntityViewPropertiesDialogEx.Comments"), new JScrollPane((Component)this.taColumnComments));
            tpComments.addTab(Messages.getString("EntityViewPropertiesDialogEx.Notes"), new JScrollPane((Component)this.taColumnNotes));
            this.pnElementComments.add((Component)tpComments, "Center");
        }
        return this.pnElementComments;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = EntityViewPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (EntityViewPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            EntityViewPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            EntityViewPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_EntityView(this.entityView, null), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void setPreviousSelectedElement() {
        if (this.currentElement > -1) {
            ElementHelper helper = (ElementHelper)this.lsElements.get(this.currentElement);
            helper.setComments(this.taColumnComments.getText());
            helper.setCommentsInRDBMS(this.taColumnCommentsInRDBMS.getText());
            helper.setNotes(this.taColumnNotes.getText());
        }
    }

    private void applyElementsComments() {
        this.setPreviousSelectedElement();
        for (ElementHelper helper : this.lsElements) {
            helper.applyComments();
            helper.applyCommentsInRDBMS();
            helper.applyNotes();
        }
    }

    protected JPanel getQueryPanel() {
        if (this.pnQuery == null) {
            this.pnQuery = this.createPage(oracle.dbtools.crest.swingui.editor.relational.Messages.getString("TableViewPropertiesDialogEx.Query"));
            JPanel pnMain = new JPanel(new BorderLayout());
            JPanel jpanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbQueryBuilder = new JLabel(oracle.dbtools.crest.swingui.editor.relational.Messages.getString("TableViewPropertiesDialogEx.QueryBuilder"));
            lbQueryBuilder.setPreferredSize(this.getDefaultSize());
            this.btnQueryBuilder = new JButton(BTN_QUERY);
            this.btnQueryBuilder.setHorizontalAlignment(2);
            this.btnQueryBuilder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String queryText = EntityViewPropertiesDialogEx.this.taQueryText.getText();
                    EntityViewPropertiesDialogEx.this.entityView.setUserDefinedSQL(queryText);
                    if (EntityViewPropertiesDialogEx.this.queryTextChanged(queryText)) {
                        EntityViewPropertiesDialogEx.this.entityView.setParsed(false);
                    }
                    QueryBuilderPanel qb = new QueryBuilderPanel(EntityViewPropertiesDialogEx.this.entityView);
                    DesignPartView useDPV = null;
                    if (EntityViewPropertiesDialogEx.this.cbSubViews.getSelectedIndex() > 0) {
                        useDPV = (DesignPartView)EntityViewPropertiesDialogEx.this.cbSubViews.getSelectedItem();
                    }
                    qb.getDialog(EntityViewPropertiesDialogEx.this.getAppView(), false, useDPV, EntityViewPropertiesDialogEx.this.chAutoJoin.isSelected()).setVisible(true);
                    EntityViewPropertiesDialogEx.this.savedUserDefinedSQL = EntityViewPropertiesDialogEx.this.entityView.getUserDefinedSQL();
                    EntityViewPropertiesDialogEx.this.taQueryText.setText(EntityViewPropertiesDialogEx.this.savedUserDefinedSQL);
                    EntityViewPropertiesDialogEx.this.taQueryText.setCaretPosition(0);
                    EntityViewPropertiesDialogEx.this.updateElementsList();
                }
            });
            jpanel.add(this.createRow(lbQueryBuilder, this.btnQueryBuilder));
            JLabel lbAutoJoin = new JLabel(oracle.dbtools.crest.swingui.editor.relational.Messages.getString("TableViewPropertiesDialogEx.AutoJoinOnFKs"));
            lbAutoJoin.setPreferredSize(this.getDefaultSize());
            this.chAutoJoin = new JCheckBox();
            this.chAutoJoin.setPreferredSize(this.getDefaultSize());
            this.chAutoJoin.setSelected(ApplicationView.getInstance().getSettings().isAutoJoinOnFK());
            this.chAutoJoin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationView.getInstance().getSettings().setAutoJoinOnFK(EntityViewPropertiesDialogEx.this.chAutoJoin.isSelected());
                }
            });
            jpanel.add(this.createRow(lbAutoJoin, this.chAutoJoin));
            JLabel lbUseObjectsFrom = new JLabel(oracle.dbtools.crest.swingui.editor.relational.Messages.getString("TableViewPropertiesDialogEx.UseObjectsFrom"));
            lbUseObjectsFrom.setPreferredSize(this.getDefaultSize());
            this.cbSubViews = new JComboBox();
            this.cbSubViews.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbUseObjectsFrom, this.cbSubViews));
            JPanel pnQueryText = new JPanel(new BorderLayout());
            pnQueryText.setBorder(BorderFactory.createTitledBorder(BTN_QUERY));
            this.taQueryText = new RSyntaxTextArea();
            this.taQueryText.setSyntaxEditingStyle("text/sql");
            this.taQueryText.setEditable(false);
            this.taQueryText.setAntiAliasingEnabled(true);
            this.taQueryText.setCodeFoldingEnabled(true);
            this.taQueryText.setCurrentLineHighlightColor(new Color(225, 236, 255));
            this.taQueryText.setEditable(this.isEditable());
            pnQueryText.add((Component)new RTextScrollPane((RTextArea)this.taQueryText));
            pnQueryText.setPreferredSize(new Dimension(325, 100));
            pnMain.add((Component)jpanel, "North");
            pnMain.add(pnQueryText);
            this.pnQuery.add(pnMain);
        }
        return this.pnQuery;
    }

    private boolean queryTextChanged(String queryText) {
        if (queryText.equals(this.savedUserDefinedSQL)) {
            return false;
        }
        String formattedQueryText = DDLStatementHandler.clearCR(queryText);
        return !formattedQueryText.equals(DDLStatementHandler.clearCR(this.savedUserDefinedSQL));
    }

    private void enableQueryPanelFields(boolean enabled) {
        this.btnQueryBuilder.setEnabled(enabled);
        this.chAutoJoin.setEnabled(enabled);
        this.cbSubViews.setEnabled(enabled);
        this.taQueryText.setEnabled(enabled);
    }

    public class ElementHelper {
        AbstractViewElement element;
        String comments;
        String commentsInRDBMS;
        String notes;

        public ElementHelper(AbstractViewElement element) {
            this.element = element;
            this.comments = element.getComment();
            this.commentsInRDBMS = element.getCommentInRDBMS();
            this.notes = element.getNotes();
        }

        public String getCommentsInRDBMS() {
            return this.commentsInRDBMS;
        }

        public void setCommentsInRDBMS(String commentsInRDBMS) {
            this.commentsInRDBMS = commentsInRDBMS;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getNotes() {
            return this.notes;
        }

        public void setNotes(String notes) {
            this.notes = notes;
        }

        public AbstractViewElement getElement() {
            return this.element;
        }

        public String getName() {
            if (!"".equals(this.element.getAlias())) {
                return this.element.getAlias();
            }
            return this.element.getName();
        }

        public String getRefContainerName() {
            if (this.element.getReferencedContainer() != null) {
                return this.element.getReferencedContainer().getName();
            }
            return "";
        }

        public void applyComments() {
            this.element.setComment(this.comments);
        }

        public void applyCommentsInRDBMS() {
            this.element.setCommentInRDBMS(this.commentsInRDBMS);
        }

        public void applyNotes() {
            this.element.setNotes(this.notes);
        }
    }

    public class ElementsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityViewPropertiesDialogEx.this.lsElements.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EntityViewPropertiesDialogEx.Attribute");
            }
            if (column == 1) {
                return Messages.getString("EntityViewPropertiesDialogEx.ReferencedContainer");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ElementHelper helper = (ElementHelper)EntityViewPropertiesDialogEx.this.lsElements.get(row);
            if (col == 0) {
                return helper.getName();
            }
            if (col == 1) {
                return helper.getRefContainerName();
            }
            return new Integer(row * col);
        }
    }

    class ComboTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComboBox combo;

        ComboTableCellEditor() {
        }

        @Override
        public Object getCellEditorValue() {
            return this.combo;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.combo = (JComboBox)value;
            this.combo.setOpaque(true);
            return this.combo;
        }
    }

    class ColumnTable
    extends JTable {
        ComboModel dataModel;

        public ColumnTable() {
            this.dataModel = new ComboModel();
            this.setModel(this.dataModel);
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (col == 0) {
                return super.getCellRenderer(row, col);
            }
            return new LNComboTableCellRenderer();
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor();
            }
            return new ComboTableCellEditor();
        }
    }

    public class ComboModel
    extends DefaultTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EntityViewPropertiesDialogEx.Attribute");
            }
            if (column == 1) {
                return Messages.getString("EntityViewPropertiesDialogEx.Entity");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!EntityViewPropertiesDialogEx.this.isEditable()) {
                return false;
            }
            return columnIndex != 0;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

