/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObjectEvent;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.HierarchicalStrategy;
import oracle.dbtools.crest.model.design.impact.ImpA_Entity;
import oracle.dbtools.crest.model.design.logical.ApplyAttributesNamingStandards;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeCaseType;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeMaxNameLength;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeValidCharacters;
import oracle.dbtools.crest.model.designrules.logical.DREntityCaseType;
import oracle.dbtools.crest.model.designrules.logical.DREntityMaxNameLength;
import oracle.dbtools.crest.model.designrules.logical.DREntityValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.UpdateableUI;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.editor.UserDefinedPropertyGroup;
import oracle.dbtools.crest.swingui.editor.logical.AttributePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.logical.AttributesNamingStandards;
import oracle.dbtools.crest.swingui.editor.logical.KeyPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.GUID;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SelectObjectDialog;
import oracle.dbtools.crest.util.compare.StringComparator;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.DataTypeCellEditor;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;
import oracle.dbtools.crest.util.gui.swing.MultilineCellEditor;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.dbtools.crest.util.string.ToStringComparator;
import oracle.ide.Ide;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class EntityPropertiesDialogEx
extends LogicalObjectPropertiesDialog
implements UpdateableUI {
    private static final Logger LOGGER = new Logger(EntityPropertiesDialogEx.class);
    public static final String INTERVAL_STRING = " ";
    private static final String NAME = "Name";
    private Entity entity;
    private JTextField tfShortName;
    private JTextField tfSynonym;
    private JTextField tfAbbreviation;
    private JTextField tfDisplaySynonym;
    private JTextField tfLongName;
    private JComboBox cbEngStrategy;
    private JComboBox cbRelationalModel;
    private JComboBox cbReferences;
    private JComboBox cbAtributesInher;
    private String[] REF_TYPES_INTERNAL = new String[]{"None", "Identifying", "Arc implementation"};
    private String[] REF_TYPES_DISPLAY = new String[]{Messages.getString("EntityPropertiesDialogEx.None"), Messages.getString("EntityPropertiesDialogEx.Identifying"), Messages.getString("EntityPropertiesDialogEx.ArcImplementation")};
    private String[] ATTR_INH_TYPES_INTERNAL = new String[]{"Primary attributes only", "All atributes"};
    private String[] ATTR_INH_TYPES_DISPLAY = new String[]{Messages.getString("EntityPropertiesDialogEx.PrimaryAttributesOnly"), Messages.getString("EntityPropertiesDialogEx.AllAttributes")};
    private JComboBox cbBasedOnST;
    private JComboBox cbSuperType;
    private JButton btnSelectSuperType;
    private JTextField tfSource;
    private JComboBox cbBaseClassificationType;
    private BaseClassificationTypeCBListener baseClassificationTypeCBListener;
    private JTextField tfScope;
    private JPanel pnAttributes;
    private List<Attribute> attributesList;
    private JTable tbAttributes;
    private JTable coTable;
    private TableRowSorter coTableRowSorter;
    private JPanel pnOptions;
    private JButton bnCOAdd;
    private JButton bnCORemove;
    private JButton bnCOUp;
    private JButton bnCODown;
    private JButton bnCOCopy;
    private JButton bnCOPaste;
    private JButton bnSort;
    private int attrCounter = 0;
    protected ContainerObjectEvent sharedEvent = new ContainerObjectEvent();
    private int counter = 0;
    private JPanel pnRelations;
    private List relationsList;
    private JTable tbRelations;
    private JPanel pnKeys;
    private List<KeyObject> keysList;
    private JTable itable;
    private JPanel pnVolumes;
    private JPanel pnSubtypes;
    private JTextField tfMinVolume;
    private JTextField tfExpected;
    private JTextField tfMaximum;
    private JTextField tfGrowthPercent;
    private JTextField tfDiscrColumnName;
    private JTextField tfDiscrValue;
    private static final String[] YMD = new String[]{Messages.getString("EntityPropertiesDialogEx.Year"), Messages.getString("EntityPropertiesDialogEx.Month"), Messages.getString("EntityPropertiesDialogEx.Day")};
    private static final String[] YMD_INTERNAL = new String[]{"Year", "Month", "Day"};
    private JComboBox cbYearMonthDay;
    private static final String[] NF = new String[]{Messages.getString("EntityPropertiesDialogEx.None"), Messages.getString("EntityPropertiesDialogEx.First"), Messages.getString("EntityPropertiesDialogEx.Second"), Messages.getString("EntityPropertiesDialogEx.Third"), Messages.getString("EntityPropertiesDialogEx.Fourth")};
    private static final String[] NF_INTERNAL = new String[]{"None", "First", "Second", "Third", "Fourth"};
    private JComboBox cbNormalForm;
    private JComboBox cbAdequatelyNormalized;
    private JComboBox cbUseAttribute;
    private final Map keyMap = new HashMap();
    private JCheckBox chTypeSubst;
    private JCheckBox chGenerateDiscrColumn;
    private JCheckBox chCompleteSubtypes;
    private JCheckBox chCreateSurrogateKey;
    private StructuredType st_type;
    private JTree tree;
    private RSyntaxTextArea taColumnComments;
    private RSyntaxTextArea taColumnNotes;
    private RSyntaxTextArea taColumnCommentsInRDBMS;
    private JTextField tfColumnName;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JComboBox cbDatatype;
    private ActionListener cbDatatypeActionListener;
    private JTextField ifDTSize;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JPanel pnDType;
    private JPanel pnDTSize;
    private JPanel pnDTScale;
    private JPanel pnRef;
    private Attribute selectedAttribute = null;
    private JCheckBox chbPK;
    private JCheckBox chbFK;
    private JCheckBox chbMandatory;
    private JCheckBox chbAttributeDeprecated;
    private ActionListener chbPKActionListener;
    private boolean sizeEnabled = false;
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private boolean initialUseDomainPreferredList = true;
    private boolean initialUseLogicalTypePreferredList = true;
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List currentPreferredDomainList = new ArrayList();
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private boolean precisionEnabled = false;
    private JCheckBox chbReference;
    private JCheckBox chbDeprecated;
    private JComboBox cbUnits;
    private ButtonGroup group;
    private final int INIT = 0;
    private final int ADD = 1;
    private final int DELETE = 2;
    private final int INIT_SELECTED = 3;
    private int distinctTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().size();
    private int structuredTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().size();
    private int collectionTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().size();
    private String storedColumnDefaultDatatype = this.getAppView().getSettings().getColumnDefaultDatatype().trim();
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private TreeMap typesRDBMSSites = new TreeMap();
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private LogicalDesign.EntHolder currentEntHolder;
    private JPanel pnOverlapping;
    private JTable attribsJTable;
    private JPopupMenu sortAttributesMenu;
    private JSearchTextField filterBox;
    private boolean attributesfiltered = false;
    private JPanel pnClassificationTypes;
    private DefaultListModel allClassificationTypesModel;
    private DefaultListModel selectedClassificationTypesModel;
    private JList allClassificationTypesList;
    private JList selectedClassificationTypesList;
    private JButton buttonAddAdditionalClassificationType;
    private JButton buttonRemoveAdditionalClassificationType;
    private ToStringComparator toStringComparator = new ToStringComparator();
    private List tempClassificationTypes = new ArrayList();
    private JCheckBox chbUsePreferredClassificationTypes;
    private static final String ATTRIBUTES_TAB_NAME = Messages.getString("EntityPropertiesDialogEx.Attributes");
    private static final String CLASSIFICATION_TYPE_TAB_NAME = Messages.getString("EntityPropertiesDialogEx.ClassificationTypes");
    private LinkedHashMap attributesUserDefinedPropertiesMap;
    private List attrNames;
    private List headerNames;
    private JPanel pnAttributesUDP;
    private JTable tbAttributesUDP;
    private JTable tbAttributesUDPFixed;
    private JComboBox cmbAttributesUDPGroup;
    private String currentSelectedName = "";
    private int currentSelectedUse = -1;
    private Domain currentSelectedDomain = null;
    private LogicalDatatype currentSelectedLogical = null;
    private String currentSelectedDTSize = "";
    private String currentSelectedDTUnits = "";
    private String currentSelectedDTPrecision = "";
    private String currentSelectedDTScale = "";
    private DistinctType currentSelectedDistinct = null;
    private StructuredType currentSelectedStructured = null;
    private boolean currentSelectedReference = false;
    private CollectionType currentSelectedCollection = null;
    private DefaultMutableTreeNode udpNode;
    private TableModel indexModel;
    private TableModel relationsModel;
    private boolean coTableIsSingleRowSelected = true;
    JButton btnAddKey;

    public EntityPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("EntityPropertiesDialogEx.EntityProperties");
    }

    @Override
    protected int getMinimumHeight() {
        return 560;
    }

    @Override
    protected int getMinimumWidth() {
        return 880;
    }

    @Override
    protected void showComponent(Component component) {
        this.setPreviousSelectedAttribute();
        String componentName = component.getName();
        if (componentName.equals(ATTRIBUTES_TAB_NAME)) {
            this.selectFirstRow(this.coTable, this.attributesList);
        }
        super.showComponent(component);
    }

    protected boolean selectFirstRow(JTable table, List tableContents) {
        if (table.getSelectedRow() == -1 && tableContents.size() > 0) {
            table.updateUI();
            table.changeSelection(0, 1, false, false);
            table.requestFocus();
            return true;
        }
        return false;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Entity) {
            this.entity = (Entity)object;
            this.currentEntHolder = ((LogicalDesign)this.entity.getDesignPart()).getOverlappingKeys_EntHolder(this.entity);
            if (this.currentEntHolder != null) {
                Collections.sort(this.currentEntHolder.attrHolders, new StringComparator());
                Iterator ita = this.currentEntHolder.attrHolders.iterator();
                Map folded = this.entity.getFoldedAttributesMap();
                while (ita.hasNext()) {
                    boolean fold = false;
                    LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)ita.next();
                    String id1 = (String)folded.get(holder.attr1.getObjectID());
                    if (id1 != null && id1.equals(holder.attr2.getObjectID())) {
                        fold = true;
                    }
                    if (!fold && (id1 = (String)folded.get(holder.attr2.getObjectID())) != null && id1.equals(holder.attr1.getObjectID())) {
                        fold = true;
                    }
                    holder.overlap = fold;
                }
            }
            this.attribsJTable.updateUI();
            this.preserveKeysStructure(this.entity);
            this.initDefaults();
            this.tfShortName.setText(this.entity.getShortName());
            this.tfSynonym.setText(this.entity.getSynonym());
            this.tfDisplaySynonym.setText(this.entity.getSynonymToDisplay());
            this.tfLongName.setText(this.entity.getLongName());
            this.fillComboItems(HierarchicalStrategy.SUBTYPES_SELECTION_DISPLAY, this.cbEngStrategy, false);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(Messages.getString("EntityPropertiesDialogEx.AllModels"));
            this.entity.getDesign().getRelationalDesigns().addAllElementsTo(list);
            this.fillComboItems(list.toArray(), this.cbRelationalModel, false);
            this.cbRelationalModel.setSelectedItem(this.entity.getDesign().getRelationalDesign());
            this.fillComboItems(this.REF_TYPES_DISPLAY, this.cbReferences, false);
            this.cbReferences.setSelectedItem(this.translate(this.entity.getSubtypesRefType(), this.REF_TYPES_INTERNAL, this.REF_TYPES_DISPLAY));
            this.fillComboItems(this.ATTR_INH_TYPES_DISPLAY, this.cbAtributesInher, false);
            this.cbAtributesInher.setSelectedItem(this.translate(this.entity.getAttributeInherType(), this.ATTR_INH_TYPES_INTERNAL, this.ATTR_INH_TYPES_DISPLAY));
            this.chGenerateDiscrColumn.setSelected(this.entity.isGenerateDiscriminatorColumn());
            this.fillComboItems(this.entity.getElements(), this.cbUseAttribute, true);
            this.cbUseAttribute.setSelectedItem(this.entity.getDiscriminatorAttribute());
            this.tfDiscrColumnName.setText(this.entity.getDiscriminatorColumnName());
            this.tfDiscrValue.setText(this.entity.getDiscriminatorValue());
            this.chCompleteSubtypes.setSelected(this.entity.isCompleteSubtypes());
            this.chCreateSurrogateKey.setSelected(this.entity.isCreateSurrogateKey());
            this.chbDeprecated.setSelected(this.entity.isDeprecated());
            list.clear();
            Iterator it = this.entity.getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
            while (it.hasNext()) {
                StructuredType st = (StructuredType)it.next();
                if (!st.isInstantiable() && !st.hasInstantiableSubtype()) continue;
                list.add(st);
            }
            this.fillComboItems(list.toArray(), this.cbBasedOnST, true);
            this.cbBasedOnST.setSelectedItem(this.entity.getBasedOnStructuredType());
            if (this.entity.isBST()) {
                this.cbSuperType.setEnabled(false);
                this.btnSelectSuperType.setEnabled(false);
                this.st_type = this.entity.getBasedOnStructuredType();
            } else {
                this.cbSuperType.removeAllItems();
                it = this.entity.getDesign().getLogicalDesign().getEntitySet().iterator();
                list = new ArrayList();
                while (it.hasNext()) {
                    Entity ent = (Entity)it.next();
                    if (ent.isBST() || ent == this.entity) continue;
                    list.add(ent);
                }
                this.fillComboItems(list.toArray(), this.cbSuperType, true);
                this.cbSuperType.setSelectedItem(this.entity.getHierarchicalParent());
            }
            this.cbSuperType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EntityPropertiesDialogEx.this.cbSuperType.getSelectedItem() != null) {
                        Entity parent = (Entity)EntityPropertiesDialogEx.this.cbSuperType.getSelectedItem();
                        EntityPropertiesDialogEx.this.cbEngStrategy.setSelectedItem(EntityPropertiesDialogEx.this.translate(parent.getFwdEngineeringStrategyName(), HierarchicalStrategy.SUBTYPES_SELECTION_INTERNAL, HierarchicalStrategy.SUBTYPES_SELECTION_DISPLAY));
                    }
                }
            });
            this.tfSource.setText(this.entity.getSource());
            this.chbUsePreferredClassificationTypes.setSelected(this.dlSettings.isUsePreferredClassificationTypes());
            if (this.dlSettings.isUsePreferredClassificationTypes()) {
                this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("EntityPropertiesDialogEx.UseAllClassificationTypes"));
            } else {
                this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("EntityPropertiesDialogEx.UsePreferredClassificationTypes"));
            }
            this.reloadClassificationTypes(true);
            this.tfScope.setText(this.entity.getScope());
            String typeTemporaryName = this.dlSettings.getClassificationTypeNameByID("5");
            Object obj = this.cbBaseClassificationType.getSelectedItem();
            if (obj != null && obj instanceof ClassificationType) {
                ClassificationType ct = (ClassificationType)obj;
                if (ct.getTypeName().equals(typeTemporaryName)) {
                    this.tfScope.setEnabled(true);
                } else {
                    this.tfScope.setEnabled(false);
                    this.tfScope.setText("");
                }
            } else {
                this.tfScope.setEnabled(false);
                this.tfScope.setText("");
            }
            this.tfAbbreviation.setText(this.entity.getPreferredAbbreviation());
            this.attributesList.addAll(Arrays.asList((Attribute[])this.entity.getElements()));
            this.coTableRowSorter = new TableRowSorter<TableModel>(this.coTable.getModel());
            this.coTableRowSorter.setSortsOnUpdates(true);
            if (this.attributesList.size() > 0) {
                this.coTable.setRowSorter(this.coTableRowSorter);
                this.coTable.setAutoCreateRowSorter(true);
                WindowsTableHeader.setSortedHeader(this.coTable, 0);
            }
            this.relationsList.addAll(this.entity.getRelations());
            this.keysList.addAll(Arrays.asList(this.entity.getKeys()));
            this.initKeysSorter();
            if (this.entity.isBST() && !this.entity.isRoot()) {
                this.btnAddKey.setEnabled(false);
            }
            this.chTypeSubst.setSelected(this.entity.isAllowTypeSubstitution());
            if (!this.entity.isBST() || this.entity.isBST() && this.entity.getSubTypeSubstitutions().size() > 0) {
                this.chTypeSubst.setEnabled(false);
            }
            this.tfMinVolume.setText(this.entity.getMinVolumes());
            this.tfExpected.setText(this.entity.getExpectedVolumes());
            this.tfMaximum.setText(this.entity.getMaxVolumes());
            this.tfGrowthPercent.setText(this.entity.getGrowthPercent());
            this.cbYearMonthDay.setSelectedItem(this.translate(this.entity.getGrowthType(), YMD_INTERNAL, YMD));
            this.cbNormalForm.setSelectedItem(this.translate(this.entity.getNormalForm(), NF_INTERNAL, NF));
            this.cbAdequatelyNormalized.setSelectedItem(this.translate(this.entity.getAdequatelyNormalized(), YES_NO_INTERNAL, YES_NO));
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 0);
            Iterator it1 = Design.getDefaultRDBMSTypeSet().iterator();
            while (it1.hasNext()) {
                RDBMSType t = (RDBMSType)it1.next();
                this.typesRDBMSSites.put(t.getType(), t.getName());
            }
            this.initDynamicProperties();
            this.initUserDefinedProperties();
            this.initUDPGroupsTree(this.udpNode);
            this.initAttributesUDP(null);
            this.initTablesSorters();
        }
    }

    private void preserveKeysStructure(ContainerWithKeyObject cwko) {
        this.keyMap.clear();
        KeyObject[] keys = cwko.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i].isFK()) continue;
            ArrayList<ContainedObject> list = new ArrayList<ContainedObject>();
            ContainedObject[] cos = keys[i].getElements();
            for (int j = 0; j < cos.length; ++j) {
                list.add(cos[j]);
            }
            this.keyMap.put(keys[i], list);
        }
    }

    private void setEngineer(Entity current, String strategy, Object modelSelection) {
        if (!"Do not preset".equals(strategy) && current.isHierarchicalEntityType()) {
            ArrayList<Object> models = new ArrayList<Object>();
            if (modelSelection instanceof RelationalDesign) {
                models.add(modelSelection);
            } else {
                current.getDesign().getRelationalDesigns().addAllElementsTo(models);
            }
            List children = null;
            boolean currentFlag = true;
            boolean restFlag = false;
            if ("Single Table".equals(strategy)) {
                children = current.getAllHierarchicalChildren();
            } else if ("Table per child".equals(strategy)) {
                List all = current.getAllHierarchicalChildren();
                children = current.getHierarchicalLeaves();
                all.removeAll(children);
                currentFlag = false;
                restFlag = true;
                for (RelationalDesign relationalDesign : models) {
                    for (Entity ent : all) {
                        boolean temp = ent.getEngineerTo(relationalDesign.getObjectID());
                        if (!temp) continue;
                        ent.setEngineerTo(relationalDesign.getObjectID(), false);
                        ent.setDirty(true);
                    }
                }
            } else if ("Table for each entity".equals(strategy)) {
                children = current.getAllHierarchicalChildren();
                restFlag = true;
            }
            for (RelationalDesign relationalDesign : models) {
                boolean bl = current.getEngineerTo(relationalDesign.getObjectID());
                if (bl != currentFlag) {
                    current.setEngineerTo(relationalDesign.getObjectID(), currentFlag);
                    current.setDirty(true);
                }
                if (children == null) continue;
                for (Entity ent : children) {
                    bl = ent.getEngineerTo(relationalDesign.getObjectID());
                    if (bl == restFlag) continue;
                    ent.setEngineerTo(relationalDesign.getObjectID(), restFlag);
                    ent.setDirty(true);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setProperties() {
        Attribute attribute;
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        this.entity.setName(this.tfName.getText());
        this.entity.setComment(this.taComments.getText());
        this.entity.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.entity.setNotes(this.taNotes.getText());
        this.entity.setSynonym(this.tfSynonym.getText());
        this.entity.setSynonymToDisplay(this.tfDisplaySynonym.getText());
        this.entity.setShortName(this.tfShortName.getText());
        this.entity.setSource(this.tfSource.getText());
        this.entity.setScope(this.tfScope.getText());
        this.entity.setHierarchicalParent((Entity)this.cbSuperType.getSelectedItem());
        this.entity.setSubtypesRefType(this.translate((String)this.cbReferences.getSelectedItem(), this.REF_TYPES_DISPLAY, this.REF_TYPES_INTERNAL));
        this.entity.setAttributeInherType(this.translate((String)this.cbAtributesInher.getSelectedItem(), this.ATTR_INH_TYPES_DISPLAY, this.ATTR_INH_TYPES_INTERNAL));
        this.entity.setGenerateDiscriminatorColumn(this.chGenerateDiscrColumn.isSelected());
        this.entity.setDiscriminatorAttribute((Attribute)this.cbUseAttribute.getSelectedItem());
        this.entity.setDiscriminatorColumnName(this.tfDiscrColumnName.getText());
        this.entity.setDiscriminatorValue(this.tfDiscrValue.getText());
        this.entity.setCompleteSubtypes(this.chCompleteSubtypes.isSelected());
        this.entity.setCreateSurrogateKey(this.chCreateSurrogateKey.isSelected());
        this.entity.setDeprecated(this.chbDeprecated.isSelected());
        this.setEngineering();
        this.setEngineer(this.entity, this.translate((String)this.cbEngStrategy.getSelectedItem(), HierarchicalStrategy.SUBTYPES_SELECTION_DISPLAY, HierarchicalStrategy.SUBTYPES_SELECTION_INTERNAL), this.cbRelationalModel.getSelectedItem());
        List<String> ctTypes = this.entity.getAdditionalClassificationTypes();
        ctTypes.clear();
        for (int i = 0; i < this.selectedClassificationTypesModel.getSize(); ++i) {
            ClassificationType ct = (ClassificationType)this.selectedClassificationTypesModel.getElementAt(i);
            ctTypes.add(ct.getTypeID());
        }
        Object ctObj = this.cbBaseClassificationType.getSelectedItem();
        if (ctObj != null && ctObj instanceof ClassificationType) {
            ClassificationType classType = (ClassificationType)this.cbBaseClassificationType.getSelectedItem();
            if (classType != null) {
                this.entity.setTypeID(classType.getTypeID());
            } else {
                this.entity.setTypeID("");
            }
        } else {
            this.entity.setTypeID("");
        }
        this.dlSettings.setUsePreferredClassificationTypes(this.chbUsePreferredClassificationTypes.isSelected());
        StructuredType basedOnStructuredType = (StructuredType)this.cbBasedOnST.getSelectedItem();
        if (this.entity.getBasedOnStructuredType() != basedOnStructuredType) {
            this.entity.setBasedOnStructuredType(basedOnStructuredType);
            this.reloadKeys();
        }
        this.entity.setPreferredAbbreviation(this.tfAbbreviation.getText());
        Object[] keysSet = this.keysList.toArray();
        CandidateKey[] keys = (CandidateKey[])this.entity.getKeySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            void var9_20;
            CandidateKey ck = keys[i];
            if (this.keysList.contains(ck) || ck.isOidKey()) continue;
            boolean ispk = ck.isPK();
            Object var9_21 = null;
            if (ispk) {
                List list = ck.getRelations();
            }
            ck.remove();
            if (!ispk || var9_20 == null) continue;
            for (Relation rel : var9_20) {
                TVRelation tv = (TVRelation)rel.getViewFor(this.getAppView().getCurrentDPV());
                if (tv == null) continue;
                tv.resetEdgeParams();
            }
        }
        boolean hasPK = false;
        for (int k = 0; k < keysSet.length; ++k) {
            Object ob = keysSet[k];
            if (!(ob instanceof CandidateKey)) continue;
            CandidateKey candidateKey = (CandidateKey)ob;
            if (candidateKey.isPK()) {
                hasPK = true;
            }
            if (this.entity.getKeySet().contains((CandidateKey)ob)) continue;
            ArrayList el_copy = new ArrayList();
            el_copy.addAll(candidateKey.getNewElementsCollection());
            candidateKey.getNewElementsCollection().clear();
            candidateKey.getElementsCollection().clear();
            this.entity.add((CandidateKey)ob);
            for (DesignObject dobj : el_copy) {
                if (dobj instanceof Relation) {
                    Relation rel = (Relation)dobj;
                    if (rel.isOneToOne()) {
                        Entity ent = rel.getOtherEntity(this.entity);
                        if (rel.getDominantRole() != ent) {
                            rel.setDominantRole(ent);
                        }
                    }
                    if (candidateKey.isPK()) {
                        rel.setIdentifying(true);
                        TVRelation tv = (TVRelation)rel.getViewFor(this.getAppView().getCurrentDPV());
                        if (tv != null) {
                            tv.resetEdgeParams();
                        }
                    }
                }
                candidateKey.getNewElementsCollection().add(dobj);
            }
            candidateKey.updateElementsCollection();
        }
        if (!this.entity.isBST()) {
            void var9_28;
            void var9_26;
            if (!hasPK) {
                this.entity.setPK(null);
            }
            Object[] attributesSet = this.attributesList.toArray();
            Attribute[] atts = (Attribute[])this.entity.getElements();
            boolean bl = false;
            while (var9_26 < atts.length) {
                Attribute att = atts[var9_26];
                if (!this.attributesList.contains(att)) {
                    att.remove();
                }
                ++var9_26;
            }
            boolean bl2 = false;
            while (var9_28 < attributesSet.length) {
                attribute = (Attribute)attributesSet[var9_28];
                if (!this.entity.getAttributeSet().contains(attribute)) {
                    this.entity.getAttributeSet().add(attribute);
                    this.entity.add(attribute);
                }
                attribute.moveToIndex((int)var9_28);
                ++var9_28;
            }
        } else {
            this.attributesList.clear();
            this.attributesList.addAll(Arrays.asList((Attribute[])this.entity.getElements()));
            this.relationsList.clear();
            this.relationsList.addAll(this.entity.getRelations());
            this.reloadKeys();
        }
        this.entity.setMinVolumes(this.tfMinVolume.getText());
        this.entity.setExpectedVolumes(this.tfExpected.getText());
        this.entity.setMaxVolumes(this.tfMaximum.getText());
        this.entity.setGrowthPercent(this.tfGrowthPercent.getText());
        this.entity.setGrowthType(this.translate((String)this.cbYearMonthDay.getSelectedItem(), YMD, YMD_INTERNAL));
        this.entity.setNormalForm(this.translate((String)this.cbNormalForm.getSelectedItem(), NF, NF_INTERNAL));
        this.entity.setAdequatelyNormalized(this.translate((String)this.cbAdequatelyNormalized.getSelectedItem(), YES_NO, YES_NO_INTERNAL));
        this.entity.setAllowTypeSubstitution(this.chTypeSubst.isSelected());
        this.preserveKeysStructure(this.entity);
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        this.tfLongName.setText(this.entity.getLongName());
        this.checkNamingOptions();
        this.tbAttributes.updateUI();
        this.coTable.updateUI();
        this.itable.updateUI();
        for (int i = 0; i < this.relationsList.size(); ++i) {
            Relation relation = (Relation)this.relationsList.get(i);
            for (TVRelation tv : relation.getAllTVRelations()) {
                if (tv == null) continue;
                tv.resetEdgeParams();
            }
        }
        if (this.currentEntHolder != null) {
            Map folded = this.entity.getFoldedAttributesMap();
            folded.clear();
            for (LogicalDesign.AttrHolder attrHolder : this.currentEntHolder.attrHolders) {
                if (!attrHolder.overlap) continue;
                Attribute attr1 = (Attribute)this.entity.getElementByID(attrHolder.attr1.getObjectID());
                Attribute attr2 = (Attribute)this.entity.getElementByID(attrHolder.attr2.getObjectID());
                if (attr1 == null || attr2 == null) continue;
                folded.put(attrHolder.attr1.getObjectID(), attrHolder.attr2.getObjectID());
            }
        }
        EntityPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        EntityPropertiesDialogEx.stopCellEditing(this.userDefinedPropertiesTable);
        EntityPropertiesDialogEx.stopCellEditing(this.tbAttributesUDP);
        Iterator itGroupUDPTables = this.getGroupUDPTables().iterator();
        while (itGroupUDPTables.hasNext()) {
            EntityPropertiesDialogEx.stopCellEditing((JTable)itGroupUDPTables.next());
        }
        this.entity.clearProperties();
        for (DynamicProperty dynamicProperty : this.dynamicPropertiesList) {
            this.entity.setProperty(dynamicProperty.getName(), dynamicProperty.getValue());
        }
        for (AbstractPropertiesDialog.UDProperty uDProperty : this.allUDPList) {
            if (uDProperty.getValue() == null || uDProperty.getValue().trim().equals("")) continue;
            this.entity.setProperty(uDProperty.getUserDefinedProperty().getName(), uDProperty.getValue());
        }
        for (Map.Entry entry : this.attributesUserDefinedPropertiesMap.entrySet()) {
            attribute = (Attribute)entry.getKey();
            for (AbstractPropertiesDialog.UDProperty dp : (List)entry.getValue()) {
                if (dp.getValue() == null) continue;
                attribute.setProperty(dp.getUserDefinedProperty().getName(), dp.getValue());
            }
        }
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
        this.entity.updateRemoteObjectListeners();
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DREntityMaxNameLength(), this.entity);
        this.checkDesignRule(new DREntityCaseType(), this.entity);
        this.checkDesignRule(new DREntityValidCharacters(), this.entity);
        DRAttributeMaxNameLength columnMaxNameLength = new DRAttributeMaxNameLength();
        DRAttributeCaseType columnCaseType = new DRAttributeCaseType();
        DRAttributeValidCharacters columnValidCharacters = new DRAttributeValidCharacters();
        for (Attribute attribute : this.attributesList) {
            this.checkDesignRule(columnMaxNameLength, attribute);
            this.checkDesignRule(columnCaseType, attribute);
            this.checkDesignRule(columnValidCharacters, attribute);
        }
    }

    private void reloadKeys() {
        this.keysList.clear();
        this.keysList.addAll(Arrays.asList(this.entity.getKeys()));
        this.initKeysSorter();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getAttributesPanel());
        this.addToTree(root, this.getKeysPanel());
        this.addToTree(root, this.getRelationsPanel());
        this.addToTree(root, this.getSubtypesPanel());
        this.addToTree(root, this.getVolumesPanel());
        this.addToTree(root, this.getEngineeringPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getOverlappingPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.udpNode = this.addToTree(root, this.getUserDefinedPropertiesPanel());
        this.addToTree(root, this.getClassificationTypesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "ENTITY_PROPERTIES_DIALOG";
    }

    private void initGeneral() {
        JLabel lbShortName = new JLabel(LB_SHORT_NAME);
        lbShortName.setPreferredSize(this.getDefaultSize());
        this.tfShortName = new JTextField();
        this.tfShortName.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbShortName, this.tfShortName));
        JLabel lbSynonym = new JLabel(LB_SYNOMYMS);
        lbSynonym.setPreferredSize(this.getDefaultSize());
        this.tfSynonym = new JTextField();
        this.tfSynonym.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSynonym, this.tfSynonym));
        JLabel lbDisplSynonym = new JLabel(LB_SYNONYM_TO_DISPLAY);
        lbDisplSynonym.setPreferredSize(this.getDefaultSize());
        this.tfDisplaySynonym = new JTextField();
        this.tfDisplaySynonym.setPreferredSize(this.getDefaultSize());
        this.tfDisplaySynonym.setToolTipText(Messages.getString("EntityPropertiesDialogEx.DisplayName"));
        lbDisplSynonym.setToolTipText(Messages.getString("EntityPropertiesDialogEx.DisplayName"));
        this.addRowToGeneralPanel(this.createRow(lbDisplSynonym, this.tfDisplaySynonym));
        JLabel lbAbbr = new JLabel(LB_PREF_ABBREVIATION);
        lbAbbr.setPreferredSize(this.getDefaultSize());
        this.tfAbbreviation = new JTextField();
        this.tfAbbreviation.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbAbbr, this.tfAbbreviation));
        JLabel lbLongName = new JLabel(LB_LONG_NAME);
        lbLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName = new JTextField();
        this.tfLongName.setPreferredSize(this.getDefaultSize());
        this.tfLongName.setEditable(false);
        this.addRowToGeneralPanel(this.createRow(lbLongName, this.tfLongName));
        JLabel lbEngStrategy = new JLabel(LB_FWD_ENGINEER_STRATEGY);
        lbEngStrategy.setPreferredSize(this.getDefaultSize());
        this.cbEngStrategy.setPreferredSize(this.getDefaultSize());
        this.cbEngStrategy.setMaximumRowCount(8);
        JLabel lbBasedOnST = new JLabel(LB_BASED_ON_STRUCTURED_TYPE);
        lbBasedOnST.setPreferredSize(this.getDefaultSize());
        this.cbBasedOnST = new JComboBox();
        this.cbBasedOnST.setPreferredSize(this.getDefaultSize());
        this.cbBasedOnST.setMaximumRowCount(8);
        this.addRowToGeneralPanel(this.createRow(lbBasedOnST, this.cbBasedOnST));
        this.cbBasedOnST.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem() != null) {
                    EntityPropertiesDialogEx.this.cbSuperType.removeAllItems();
                    EntityPropertiesDialogEx.this.cbSuperType.setEnabled(false);
                    EntityPropertiesDialogEx.this.btnSelectSuperType.setEnabled(false);
                    Object obj = EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem();
                    if (EntityPropertiesDialogEx.this.st_type != null && obj != null) {
                        EntityPropertiesDialogEx.this.keysList.clear();
                        EntityPropertiesDialogEx.this.itable.updateUI();
                    }
                    EntityPropertiesDialogEx.this.st_type = (StructuredType)obj;
                    if (EntityPropertiesDialogEx.this.isEditable()) {
                        EntityPropertiesDialogEx.this.bnCOAdd.setEnabled(false);
                        EntityPropertiesDialogEx.this.bnCORemove.setEnabled(EntityPropertiesDialogEx.this.coTable.getSelectedRows().length > 0);
                    }
                } else {
                    EntityPropertiesDialogEx.this.cbSuperType.removeAllItems();
                    Iterator it = EntityPropertiesDialogEx.this.entity.getDesign().getLogicalDesign().getEntitySet().iterator();
                    ArrayList<Entity> list = new ArrayList<Entity>();
                    while (it.hasNext()) {
                        Entity ent = (Entity)it.next();
                        if (ent.isBST() || ent == EntityPropertiesDialogEx.this.entity) continue;
                        list.add(ent);
                    }
                    EntityPropertiesDialogEx.this.fillComboItems(list.toArray(), EntityPropertiesDialogEx.this.cbSuperType, true);
                    EntityPropertiesDialogEx.this.cbSuperType.setEnabled(true);
                    EntityPropertiesDialogEx.this.btnSelectSuperType.setEnabled(true);
                    if (EntityPropertiesDialogEx.this.isEditable()) {
                        EntityPropertiesDialogEx.this.bnCOAdd.setEnabled(true);
                        EntityPropertiesDialogEx.this.bnCORemove.setEnabled(EntityPropertiesDialogEx.this.coTable.getSelectedRows().length > 0);
                    }
                }
                EntityPropertiesDialogEx.this.enableAttributeOptions(true, 3);
            }
        });
        JLabel lbSuperType = new JLabel(LB_SUPER_TYPE);
        lbSuperType.setPreferredSize(this.getDefaultSize());
        this.cbSuperType = new JComboBox();
        this.cbSuperType.setPreferredSize(this.getDefaultSize());
        this.cbSuperType.setMaximumRowCount(8);
        this.btnSelectSuperType = new JButton(Messages.getString("EntityPropertiesDialogEx.Select"));
        this.btnSelectSuperType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList lovList = new ArrayList();
                int size = EntityPropertiesDialogEx.this.cbSuperType.getItemCount();
                for (int i = 0; i < size; ++i) {
                    Object element = EntityPropertiesDialogEx.this.cbSuperType.getItemAt(i);
                    lovList.add(element);
                }
                SelectObjectDialog d = new SelectObjectDialog(EntityPropertiesDialogEx.this.getAppView(), lovList, EntityPropertiesDialogEx.this.cbSuperType.getSelectedItem());
                d.showDialog();
                Object selectedSuperType = d.getSelectedObject();
                if (selectedSuperType != null) {
                    if (selectedSuperType == EntityPropertiesDialogEx.INTERVAL_STRING) {
                        EntityPropertiesDialogEx.this.cbSuperType.setSelectedItem(null);
                    } else {
                        EntityPropertiesDialogEx.this.cbSuperType.setSelectedItem(selectedSuperType);
                    }
                }
            }
        });
        JPanel pnSuperType = new JPanel(new BorderLayout(20, 0));
        pnSuperType.setPreferredSize(this.getDefaultSize());
        pnSuperType.add((Component)this.cbSuperType, "Center");
        pnSuperType.add((Component)this.btnSelectSuperType, "East");
        this.addRowToGeneralPanel(this.createRow(lbSuperType, pnSuperType));
        JLabel lbSource = new JLabel(LB_SOURCE);
        lbSource.setPreferredSize(this.getDefaultSize());
        this.tfSource = new JTextField();
        this.tfSource.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbSource, this.tfSource));
        JLabel lbTypeSubst = new JLabel(Messages.getString("EntityPropertiesDialogEx.AllowTypeSubstitution"));
        lbTypeSubst.setPreferredSize(this.getDefaultSize());
        this.chTypeSubst = new JCheckBox();
        this.chTypeSubst.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbTypeSubst, this.chTypeSubst));
        JLabel lbTCreateSurrgateKey = new JLabel(Messages.getString("EntityPropertiesDialogEx.CreateSurrogateKey"));
        lbTCreateSurrgateKey.setPreferredSize(this.getDefaultSize());
        this.chCreateSurrogateKey = new JCheckBox();
        this.chCreateSurrogateKey.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbTCreateSurrgateKey, this.chCreateSurrogateKey));
        JLabel lbDeprecated = new JLabel(Messages.getString("EntityPropertiesDialogEx.Deprecated"));
        lbDeprecated.setPreferredSize(this.getDefaultSize());
        this.chbDeprecated = new JCheckBox();
        this.chbDeprecated.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbDeprecated, this.chbDeprecated));
    }

    private void updateAttributeProps(Attribute attr) {
        Attribute attribute;
        int row = this.coTable.getSelectedRow();
        if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size() && attr.equals(attribute = this.attributesList.get(this.coTable.convertRowIndexToModel(row)))) {
            this.taColumnComments.setText(attribute.getComment());
            this.taColumnCommentsInRDBMS.setText(attribute.getCommentInRDBMS());
            this.taColumnNotes.setText(attribute.getNotes());
            this.tfColumnName.setText(attribute.getName());
            this.chbDeprecated.setSelected(attribute.isDeprecated());
        }
    }

    private void updateAttributePK(Attribute attribute, boolean selected) {
        int row = this.coTable.getSelectedRow();
        if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size()) {
            Attribute attr = this.attributesList.get(this.coTable.convertRowIndexToModel(row));
            if (attr.equals(attribute)) {
                this.chbPK.doClick();
            } else {
                this.updatePKStatus(attribute, selected);
            }
        }
    }

    private void updateAttributeMandatory(Attribute attribute, boolean selected) {
        Attribute attr;
        int row = this.coTable.getSelectedRow();
        if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size() && (attr = this.attributesList.get(this.coTable.convertRowIndexToModel(row))).equals(attribute)) {
            this.chbMandatory.doClick();
        }
    }

    private String getTooltip(String text) {
        if (text != null) {
            text = text.replaceAll("(\r\n|\n)", "<br/>");
            return "<html><p>" + text + "</p></html>";
        }
        return "";
    }

    private CandidateKey getPK() {
        for (CandidateKey candidateKey : this.keysList) {
            if (!candidateKey.isPK()) continue;
            return candidateKey;
        }
        return null;
    }

    private CandidateKey createAndAddKey(boolean primaryKey) {
        CandidateKey key = new CandidateKey(this.entity.getDesignPart());
        key.setName(this.generateKeyName());
        key.setDesign(this.entity.getDesign());
        key.setContainerObject(this.entity);
        key.setDesignObjectSet(this.entity.getKeySet());
        if (this.itable.getRowSorter() != null) {
            this.itable.getRowSorter().setSortKeys(null);
        }
        this.keysList.add(key);
        if (primaryKey) {
            key.setPK(true);
            this.entity.setPK(key);
        }
        if (this.keysList.size() == 1) {
            this.initKeysSorter();
        }
        WindowsTableHeader.setSortedHeader(this.itable, 0);
        int lastRow = this.itable.convertRowIndexToView(this.keysList.size() - 1);
        this.itable.setRowSelectionInterval(lastRow, lastRow);
        this.itable.updateUI();
        return key;
    }

    private void updatePKStatus(Attribute attribute, boolean belongstoPK) {
        CandidateKey ind = this.getPK();
        if (ind == null && belongstoPK) {
            ind = this.createAndAddKey(true);
            ind.setName(ApplyAttributesNamingStandards.createPrimaryIdentifierName(this.tfName.getText().trim(), this.tfShortName.getText().trim(), this.entity.getDesign().getDesignLevelSettings().getNamingStandardRule()));
        }
        if (ind != null && !belongstoPK) {
            ind.remove(attribute);
            return;
        }
        if (ind != null && belongstoPK) {
            if (!ind.contains(attribute)) {
                ind.add(attribute);
            }
            if (attribute.getNullsAllowed()) {
                attribute.setNullsAllowed(false);
            }
        }
    }

    protected String generateKeyName() {
        String key = "Key";
        int newNumber = 0;
        int lastNumber = this.keysList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        String keyName = key.concat("_").concat(Integer.toString(newNumber));
        while (this.keyExists(keyName)) {
            newNumber = ++this.counter;
            keyName = key.concat("_").concat(Integer.toString(newNumber));
        }
        return keyName;
    }

    private boolean keyExists(String name) {
        for (int i = 0; i < this.keysList.size(); ++i) {
            CandidateKey key = (CandidateKey)this.keysList.get(i);
            if (!name.equalsIgnoreCase(key.getName())) continue;
            return true;
        }
        return false;
    }

    protected String generateAttributeName() {
        String name = "Attribute";
        int newNumber = 0;
        int lastNumber = this.attributesList.size();
        if (lastNumber != 0) {
            newNumber = this.attrCounter = lastNumber + 1;
        } else {
            ++this.attrCounter;
            newNumber = this.attrCounter;
        }
        String attrName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.attributeExists(attrName)) {
            newNumber = ++this.attrCounter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    protected String generatePastedAttributeName(String pastedColumnName) {
        if (!this.attributeExists(pastedColumnName)) {
            return pastedColumnName;
        }
        int newNumber = 0;
        for (Attribute col : this.attributesList) {
            String colName = col.getName();
            if (colName.indexOf(pastedColumnName) < 0) continue;
            ++newNumber;
        }
        String colName = pastedColumnName.concat("_").concat(Integer.toString(newNumber));
        while (this.attributeExists(colName)) {
            colName = pastedColumnName.concat("_").concat(Integer.toString(++newNumber));
        }
        return colName;
    }

    private boolean attributeExists(String name) {
        for (int i = 0; i < this.attributesList.size(); ++i) {
            Attribute attribute = this.attributesList.get(i);
            if (!name.equalsIgnoreCase(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    private void deleteAttribute(JTable jtable) {
        RowSorter<? extends TableModel> sorter = this.coTable.getRowSorter();
        if (sorter != null) {
            sorter = this.coTable.getRowSorter();
            sorter.setSortKeys(null);
        }
        EntityPropertiesDialogEx.stopCellEditing(jtable);
        int[] rows = jtable.getSelectedRows();
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (int i = rows.length - 1; i >= 0; --i) {
            Attribute attribute;
            int objectNumber = rows[i];
            if (objectNumber != -1 && this.attributesList.size() > 0 && objectNumber < this.attributesList.size() && !(attribute = this.attributesList.get(this.coTable.convertRowIndexToModel(objectNumber))).isFKAttribute()) {
                list.add(attribute);
            }
            for (Object e : list) {
                this.attributesList.remove(e);
            }
            this.tbAttributes.clearSelection();
            this.tbAttributes.updateUI();
            this.coTable.clearSelection();
            this.coTable.updateUI();
            this.selectedAttribute = null;
            this.enableAttributeOptions(this.attributesList.size() > 0 && this.coTable.getSelectedRow() > 0, 2);
        }
        if (this.attributesList.size() > 0) {
            this.coTable.setRowSorter(this.coTableRowSorter);
            this.coTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.coTable, 0);
            this.filterBox.setEnabled(true);
            this.reFilter();
        } else {
            this.filterBox.setEnabled(false);
        }
    }

    protected JPanel getAttributesPanel() {
        if (this.pnAttributes == null) {
            this.pnAttributes = new JPanel(new BorderLayout());
            this.attributesList = new ArrayList<Attribute>();
            DataModel dataModel = new DataModel();
            this.tbAttributes = new AttributeTable(dataModel);
            this.tbAttributes.setSelectionMode(0);
            this.tbAttributes.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    if (event.getClickCount() == 1) {
                        int row = EntityPropertiesDialogEx.this.tbAttributes.rowAtPoint(event.getPoint());
                        int col = EntityPropertiesDialogEx.this.tbAttributes.columnAtPoint(event.getPoint());
                        if (row > -1 && col > 6 && col < 10) {
                            MultilineCellEditor cellEditor = new MultilineCellEditor((Dialog)EntityPropertiesDialogEx.this, row, col, EntityPropertiesDialogEx.this.tbAttributes);
                            cellEditor.setVisible(true);
                        } else if (col == 2) {
                            DataTypeCellEditor cellEditor = new DataTypeCellEditor(EntityPropertiesDialogEx.this, row, col, EntityPropertiesDialogEx.this.tbAttributes, EntityPropertiesDialogEx.this);
                            cellEditor.setVisible(true);
                        }
                    }
                }
            });
            TableColumn column = this.tbAttributes.getColumnModel().getColumn(0);
            column.setPreferredWidth(30);
            column.setMaxWidth(50);
            column.setMinWidth(25);
            column = this.tbAttributes.getColumnModel().getColumn(1);
            column.setPreferredWidth(295);
            DefaultCellEditor singleclick = new DefaultCellEditor(new JTextField());
            singleclick.setClickCountToStart(1);
            column.setCellEditor(singleclick);
            column = this.tbAttributes.getColumnModel().getColumn(2);
            column.setCellRenderer(new DataTypeCellRenderer());
            column.setPreferredWidth(275);
            column = this.tbAttributes.getColumnModel().getColumn(3);
            column.setMaxWidth(30);
            column.setMinWidth(30);
            column.setCellRenderer(new StatusCellRenderer());
            column = this.tbAttributes.getColumnModel().getColumn(4);
            column.setMaxWidth(30);
            column.setMinWidth(30);
            column.setCellRenderer(new StatusCellRenderer(false));
            column = this.tbAttributes.getColumnModel().getColumn(5);
            column.setMaxWidth(30);
            column.setMinWidth(30);
            column.setCellRenderer(new StatusCellRenderer());
            column = this.tbAttributes.getColumnModel().getColumn(6);
            column.setMaxWidth(30);
            column.setMinWidth(30);
            column.setCellRenderer(new StatusCellRenderer());
            column = this.tbAttributes.getColumnModel().getColumn(7);
            column.setPreferredWidth(170);
            column = this.tbAttributes.getColumnModel().getColumn(8);
            column.setPreferredWidth(220);
            column = this.tbAttributes.getColumnModel().getColumn(9);
            column.setPreferredWidth(170);
            JScrollPane scrollpane = new JScrollPane(this.tbAttributes);
            JPanel columnsPanel = new JPanel(new BorderLayout());
            columnsPanel.add(scrollpane);
            this.pnAttributes.add(columnsPanel);
        }
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.Details"), this.createExtendedAttributePanel());
        tabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.Overview"), this.pnAttributes);
        tabbedPane.addTab(Messages.getString("EntityPropertiesDialogEx.UDP"), null, this.createAttributesUDPPanel(), Messages.getString("EntityPropertiesDialogEx.UserDefinedProperties"));
        JPanel jpanel = this.createPage(ATTRIBUTES_TAB_NAME);
        jpanel.add(tabbedPane);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EntityPropertiesDialogEx.stopCellEditing(EntityPropertiesDialogEx.this.tbAttributes);
                EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
            }
        });
        return jpanel;
    }

    private void setAttributeSelected() {
        int row = this.coTable.getSelectedRow();
        if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size()) {
            Attribute attribute = this.attributesList.get(this.coTable.convertRowIndexToModel(row));
            this.initSelectedAttributeOptions(attribute, this.coTableIsSingleRowSelected);
        }
    }

    private void enableAttributeOptions(boolean enabled, int operation) {
        boolean basedOnStructuredTypeTable = this.cbBasedOnST.getSelectedItem() != null;
        boolean enableBasedOnStructureType = enabled && !basedOnStructuredTypeTable;
        this.tfColumnName.setEnabled(enableBasedOnStructureType);
        this.rbDomain.setEnabled(enableBasedOnStructureType);
        this.rbLogical.setEnabled(enableBasedOnStructureType);
        if (operation == 0) {
            this.rbStructured.setEnabled(enableBasedOnStructureType);
            this.rbDistinct.setEnabled(enableBasedOnStructureType);
            this.rbCollection.setEnabled(enableBasedOnStructureType);
        } else if (operation == 1 || operation == 2 || operation == 3) {
            if (this.structuredTypesCount > 0) {
                this.rbStructured.setEnabled(enableBasedOnStructureType);
            } else {
                this.rbStructured.setEnabled(false);
            }
            if (this.distinctTypesCount > 0) {
                this.rbDistinct.setEnabled(enableBasedOnStructureType);
            } else {
                this.rbDistinct.setEnabled(false);
            }
            if (this.collectionTypesCount > 0) {
                this.rbCollection.setEnabled(enableBasedOnStructureType);
            } else {
                this.rbCollection.setEnabled(false);
            }
            if (this.rbStructured.isSelected() && !this.rbStructured.isEnabled() || this.rbDistinct.isSelected() && !this.rbDistinct.isEnabled() || this.rbCollection.isSelected() && !this.rbCollection.isEnabled()) {
                this.rbDomain.setSelected(true);
            }
        }
        this.cbDatatype.setEnabled(enableBasedOnStructureType);
        this.ifDTSize.setEnabled(enableBasedOnStructureType);
        this.cbUnits.setEnabled(enableBasedOnStructureType);
        this.ifDTPrecision.setEnabled(enableBasedOnStructureType);
        this.ifDTScale.setEnabled(enableBasedOnStructureType);
        this.chbPK.setEnabled(enableBasedOnStructureType);
        this.chbMandatory.setEnabled(enabled);
        this.chbAttributeDeprecated.setEnabled(enabled);
        this.chbFK.setEnabled(false);
        this.taColumnComments.setEditable(enabled);
        this.taColumnCommentsInRDBMS.setEditable(enabled);
        this.taColumnNotes.setEditable(enabled);
        this.chbReference.setEnabled(enabled);
        if (!enabled) {
            this.rbDomain.setSelected(true);
            this.updateDTComboBox();
            this.tfColumnName.setText("");
            this.ifDTSize.setText("");
            this.cbUnits.setSelectedIndex(0);
            this.ifDTPrecision.setText("");
            this.ifDTScale.setText("");
            this.taColumnComments.setText("");
            this.taColumnCommentsInRDBMS.setText("");
            this.taColumnNotes.setText("");
        }
    }

    private void disableFKColumnOptions(Attribute attribute) {
        if (this.isEditable()) {
            boolean enableDataParams = !attribute.isFKElement() || this.getAppView().getSettings().isAllowSimilarTypesFK();
            boolean enable = !attribute.isFKElement();
            boolean enableDescr = !ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && !attribute.isFKElement();
            boolean basedOnStructuredTypeTable = this.cbBasedOnST.getSelectedItem() != null;
            boolean enableBasedOnStructureType = enable && !basedOnStructuredTypeTable;
            enableDataParams = enableDataParams && !basedOnStructuredTypeTable;
            this.rbDomain.setEnabled(enableBasedOnStructureType);
            this.rbLogical.setEnabled(enableBasedOnStructureType);
            if (!enable) {
                this.rbDistinct.setEnabled(enableBasedOnStructureType);
                this.rbStructured.setEnabled(enableBasedOnStructureType);
                this.rbCollection.setEnabled(enableBasedOnStructureType);
            } else {
                if (this.structuredTypesCount > 0) {
                    this.rbStructured.setEnabled(enableBasedOnStructureType);
                } else {
                    this.rbStructured.setEnabled(false);
                }
                if (this.distinctTypesCount > 0) {
                    this.rbDistinct.setEnabled(enableBasedOnStructureType);
                } else {
                    this.rbDistinct.setEnabled(false);
                }
                if (this.collectionTypesCount > 0) {
                    this.rbCollection.setEnabled(enableBasedOnStructureType);
                } else {
                    this.rbCollection.setEnabled(false);
                }
            }
            this.taColumnComments.setEditable(enableDescr);
            this.taColumnCommentsInRDBMS.setEditable(enableDescr);
            this.taColumnNotes.setEditable(enableDescr);
            this.cbDatatype.setEnabled(enableBasedOnStructureType);
            this.ifDTSize.setEnabled(enableDataParams);
            this.cbUnits.setEnabled(enableDataParams);
            this.ifDTPrecision.setEnabled(enableDataParams);
            this.ifDTScale.setEnabled(enableDataParams);
            this.chbMandatory.setEnabled(enable);
            this.chbAttributeDeprecated.setEnabled(enable);
            this.chbFK.setEnabled(false);
            this.chbUsePreferredList.setEnabled(enableBasedOnStructureType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDTComboBox() {
        block65: {
            block66: {
                block64: {
                    this.cbDatatype.removeAllItems();
                    this.pnDType.removeAll();
                    this.pnDType.updateUI();
                    if (!this.rbDomain.isSelected()) break block64;
                    Domain selDomain = null;
                    if (this.selectedAttribute != null) {
                        selDomain = this.selectedAttribute.getDomain();
                    }
                    if (selDomain == null) {
                        selDomain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                        List pDomains = this.getCurrentPreferredDomains();
                        allPreferredDomains.addAll(pDomains);
                        if (pDomains.size() > 0) {
                            for (Domain ldt : pDomains) {
                                if (selDomain == null) continue;
                                if (!ldt.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(selDomain)) continue;
                                    this.additionalPreferredDomains.add(selDomain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(selDomain)) {
                                    this.additionalPreferredDomains.remove(selDomain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                            this.additionalPreferredDomains.add(selDomain);
                        }
                        allPreferredDomains.addAll(this.additionalPreferredDomains);
                        boolean currentAdded = false;
                        for (Object e : allPreferredDomains) {
                            if (e == this.currentSelectedDomain) {
                                currentAdded = true;
                            }
                            this.cbDatatype.addItem(e);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        if (this.currentSelectedDomain != null && !currentAdded) {
                            this.cbDatatype.addItem(this.currentSelectedDomain);
                        }
                        this.cbDatatype.setSelectedItem(selDomain);
                        this.getAppView().getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator it = this.getDesignObject().getDesign().getDomainSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = obj;
                        }
                        this.cbDatatype.setSelectedItem(selDomain);
                        this.getAppView().getSettings().setUsePreferredDomains(false);
                    }
                    break block65;
                }
                if (!this.rbLogical.isSelected()) break block66;
                String size = "";
                String precision = "";
                String scale = "";
                String units = "";
                try {
                    this.cbDatatype.removeActionListener(this.cbDatatypeActionListener);
                    this.selLogicalDatatype = null;
                    if (this.selectedAttribute != null) {
                        this.selLogicalDatatype = this.selectedAttribute.getLogicalDatatype();
                        size = this.selectedAttribute.getDataTypeParameter("size");
                        precision = this.selectedAttribute.getDataTypeParameter("precision");
                        scale = this.selectedAttribute.getDataTypeParameter("scale");
                        String[] parts_n = size.split(INTERVAL_STRING);
                        if (parts_n.length == 2) {
                            size = parts_n[0];
                            units = parts_n[1];
                        }
                    }
                    if (this.initialUseLogicalTypePreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                        this.initialUseLogicalTypePreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<LogicalDatatype> allPreferredLogicalDatatypes = new ArrayList<LogicalDatatype>();
                        List list = this.getCurrentPreferredLogicalDatatypes();
                        allPreferredLogicalDatatypes.addAll(list);
                        if (list.size() > 0) {
                            for (LogicalDatatype ldt : list) {
                                if (this.selLogicalDatatype == null) continue;
                                if (!ldt.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                    this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                    continue;
                                }
                                if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                    this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                            this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                        }
                        allPreferredLogicalDatatypes.addAll(this.additionalPreferredLogicalTypes);
                        boolean currentAdded = false;
                        for (Object e : allPreferredLogicalDatatypes) {
                            if (e == this.currentSelectedLogical) {
                                currentAdded = true;
                            }
                            this.cbDatatype.addItem(e);
                            if (this.logicalDefaultDataType == null) {
                                this.logicalDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = e;
                        }
                        if (this.currentSelectedLogical != null && !currentAdded) {
                            this.cbDatatype.addItem(this.currentSelectedLogical);
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
                    } else {
                        Iterator it = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                        while (it.hasNext()) {
                            Object e = it.next();
                            this.cbDatatype.addItem(e);
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = e;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
                    }
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                }
                catch (Throwable throwable) {
                    this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
                    this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    if (this.ifDTSize.isEnabled()) {
                        try {
                            this.ifDTSize.setText(size != null && size != "" ? size : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTPrecision.isEnabled()) {
                        try {
                            this.ifDTPrecision.setValue((long)Integer.parseInt(precision != null && precision != "" ? precision : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTScale.isEnabled()) {
                        try {
                            this.ifDTScale.setValue((long)Integer.parseInt(scale != null && scale != "" ? scale : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.cbUnits.isEnabled()) {
                        this.cbUnits.setSelectedItem(units);
                    }
                    throw throwable;
                }
                if (this.ifDTSize.isEnabled()) {
                    try {
                        this.ifDTSize.setText(size != null && size != "" ? size : null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTPrecision.isEnabled()) {
                    try {
                        this.ifDTPrecision.setValue((long)Integer.parseInt(precision != null && precision != "" ? precision : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.ifDTScale.isEnabled()) {
                    try {
                        this.ifDTScale.setValue((long)Integer.parseInt(scale != null && scale != "" ? scale : null));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.cbUnits.isEnabled()) {
                    this.cbUnits.setSelectedItem(units);
                }
                break block65;
            }
            if (this.rbDistinct.isSelected()) {
                Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
            } else if (this.rbStructured.isSelected()) {
                Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
                this.pnDType.add(this.pnRef);
                this.chbReference.setSelected(false);
            } else if (this.rbCollection.isSelected()) {
                Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                while (it.hasNext()) {
                    this.cbDatatype.addItem(it.next());
                }
            }
        }
        this.cbDatatype.updateUI();
    }

    private void setPreviousSelectedAttribute() {
        if (this.selectedAttribute != null) {
            String cName;
            int newNumber = 0;
            String colName = cName = this.tfColumnName.getText();
            while (this.attributeExists(colName) && !this.selectedAttribute.getName().equalsIgnoreCase(this.tfColumnName.getText())) {
                colName = cName.concat("_").concat(Integer.toString(++newNumber));
            }
            this.selectedAttribute.setName(colName);
            if (this.rbDomain.isSelected()) {
                Object datatype = this.cbDatatype.getSelectedItem();
                if (datatype instanceof Domain) {
                    Domain domain = (Domain)datatype;
                    this.selectedAttribute.setUse((short)0);
                    if (this.selectedAttribute.getDomain() != domain) {
                        this.selectedAttribute.setDomain(domain);
                        if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                            this.selectedAttribute.setUseDomainConstraints(true);
                        }
                    }
                }
            } else if (this.rbLogical.isSelected()) {
                int scaleDefaultValue;
                this.selectedAttribute.setDataTypeParameter("size", "");
                this.selectedAttribute.setDataTypeParameter("precision", "");
                this.selectedAttribute.setDataTypeParameter("scale", "");
                this.selectedAttribute.setUse((short)1);
                this.selectedAttribute.setLogicalDatatype((LogicalDatatype)this.cbDatatype.getSelectedItem());
                Map defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
                String pdf = (String)defaults.get("precision_default_value");
                if (pdf == null) {
                    pdf = "";
                }
                String sizeDefaultValue = (String)defaults.get("size_default_value");
                String scdf = (String)defaults.get("scale_default_value");
                int n = scaleDefaultValue = scdf != "" && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
                if (this.sizeEnabled) {
                    String size = this.ifDTSize.getText();
                    if (size != "" && !size.equals(sizeDefaultValue)) {
                        if (this.cbUnits.getSelectedIndex() > 0) {
                            this.selectedAttribute.setDataTypeParameter("size", String.valueOf(size) + INTERVAL_STRING + this.cbUnits.getSelectedItem());
                        } else {
                            this.selectedAttribute.setDataTypeParameter("size", String.valueOf(size));
                        }
                    } else {
                        this.selectedAttribute.setDataTypeParameter("size", "");
                        this.selectedAttribute.setDataTypeParameter("precision", "");
                        this.selectedAttribute.setDataTypeParameter("scale", "");
                    }
                } else if (this.precisionEnabled) {
                    this.selectedAttribute.setDataTypeParameter("size", "");
                    if (!pdf.equals(this.ifDTPrecision.getText())) {
                        this.selectedAttribute.setDataTypeParameter("precision", this.ifDTPrecision.getText());
                    } else {
                        this.selectedAttribute.setDataTypeParameter("precision", "");
                    }
                    if (this.ifDTScale.getIntValue() != scaleDefaultValue) {
                        this.selectedAttribute.setDataTypeParameter("scale", String.valueOf(this.ifDTScale.getIntValue()));
                    } else {
                        this.selectedAttribute.setDataTypeParameter("scale", "");
                    }
                }
            } else if (this.rbDistinct.isSelected()) {
                this.selectedAttribute.setUse((short)2);
                this.selectedAttribute.setDistinctType((DistinctType)this.cbDatatype.getSelectedItem());
            } else if (this.rbStructured.isSelected()) {
                this.selectedAttribute.setUse((short)3);
                this.selectedAttribute.setReference(this.chbReference.isSelected());
                this.selectedAttribute.setStructuredType((StructuredType)this.cbDatatype.getSelectedItem());
            } else if (this.rbCollection.isSelected()) {
                this.selectedAttribute.setUse((short)4);
                this.selectedAttribute.setCollectionType((CollectionType)this.cbDatatype.getSelectedItem());
            }
            this.selectedAttribute.setComment(this.taColumnComments.getText());
            this.selectedAttribute.setCommentInRDBMS(this.taColumnCommentsInRDBMS.getText());
            this.selectedAttribute.setNotes(this.taColumnNotes.getText());
            EntityPropertiesDialogEx.stopCellEditing(this.tbAttributesUDP);
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
        }
        if (this.userDefinedPropertiesTable != null) {
            EntityPropertiesDialogEx.stopCellEditing(this.userDefinedPropertiesTable);
        }
        Iterator itGroupUDPTables = this.getGroupUDPTables().iterator();
        while (itGroupUDPTables.hasNext()) {
            EntityPropertiesDialogEx.stopCellEditing((JTable)itGroupUDPTables.next());
        }
    }

    private void initSelectedAttributeOptions(Attribute attribute, boolean setPrevious) {
        if (setPrevious) {
            this.setPreviousSelectedAttribute();
        }
        this.selectedAttribute = attribute;
        if (this.isEditable()) {
            this.enableAttributeOptions(true, 3);
        } else {
            this.enableAttributeOptions(false, 3);
        }
        this.tfColumnName.setText(attribute.getName());
        this.tfColumnName.setEnabled(this.isEditable() && !attribute.isNameFixed());
        if (attribute.isNameFixed()) {
            this.tfColumnName.setToolTipText(NAME_IS_FROZEN);
        } else {
            this.tfColumnName.setToolTipText(null);
        }
        short use = attribute.getUse();
        switch (use) {
            case 0: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDomain());
                break;
            }
            case 1: {
                this.rbLogical.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getLogicalDatatype());
                try {
                    if (this.isEditable()) {
                        this.cbUnits.setEnabled(true);
                    }
                    String size = attribute.getSize();
                    String[] parts_n = size.split(INTERVAL_STRING);
                    this.ifDTSize.setText(parts_n[0]);
                    if (parts_n.length == 2) {
                        this.cbUnits.setSelectedItem(parts_n[1]);
                    }
                }
                catch (Exception size) {
                    // empty catch block
                }
                try {
                    this.ifDTPrecision.setText(attribute.getDataTypePrecision());
                }
                catch (Exception size) {
                    // empty catch block
                }
                try {
                    this.ifDTScale.setValue(Integer.parseInt(attribute.getScale()) > 0 ? Integer.valueOf(Integer.parseInt(attribute.getScale())) : null);
                }
                catch (Exception size) {}
                break;
            }
            case 2: {
                this.rbDistinct.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDistinctType());
                break;
            }
            case 3: {
                this.rbStructured.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getStructuredType());
                this.chbReference.setSelected(attribute.isReference());
                break;
            }
            case 4: {
                this.rbCollection.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getCollectionType());
                break;
            }
            default: {
                this.rbDomain.setSelected(true);
                this.updateDTComboBox();
                this.cbDatatype.setSelectedItem(attribute.getDomain());
            }
        }
        this.chbPK.setSelected(this.isPK(attribute));
        this.chbFK.setSelected(attribute.isFKElement());
        this.chbMandatory.setSelected(!attribute.getNullsAllowed());
        this.chbAttributeDeprecated.setSelected(attribute.isDeprecated());
        this.taColumnComments.setText(attribute.getComment());
        this.taColumnCommentsInRDBMS.setText(attribute.getCommentInRDBMS());
        this.taColumnNotes.setText(attribute.getNotes());
        this.disableFKColumnOptions(attribute);
        if (this.isPK(attribute) || attribute.isFKElement()) {
            this.chbMandatory.setEnabled(false);
        }
        this.coTable.updateUI();
        boolean keepFKNamesSync = this.getAppView().getSettings().isKeepFKNamesSynchronized();
        if (attribute.isFKAttribute() && keepFKNamesSync || attribute.isNameFixed()) {
            this.tfColumnName.setEnabled(false);
        } else {
            this.tfColumnName.selectAll();
            this.tfColumnName.requestFocus();
        }
    }

    private void initCurrentSelectedDatatype() {
        this.currentSelectedName = this.selectedAttribute.getName();
        this.currentSelectedUse = this.selectedAttribute.getUse();
        this.currentSelectedDomain = null;
        this.currentSelectedLogical = null;
        this.currentSelectedDTSize = "";
        this.currentSelectedDTUnits = "";
        this.currentSelectedDTPrecision = "";
        this.currentSelectedDTScale = "";
        this.currentSelectedDistinct = null;
        this.currentSelectedStructured = null;
        this.currentSelectedReference = false;
        this.currentSelectedCollection = null;
    }

    private void saveCurrentSelectedOldDatatype() {
        Object selDatatype;
        if (!this.currentSelectedName.equals(this.selectedAttribute.getName())) {
            this.initCurrentSelectedDatatype();
        }
        if ((selDatatype = this.cbDatatype.getSelectedItem()) instanceof Domain) {
            this.currentSelectedDomain = (Domain)selDatatype;
        } else if (selDatatype instanceof LogicalDatatype) {
            this.currentSelectedLogical = (LogicalDatatype)selDatatype;
            this.currentSelectedDTSize = this.ifDTSize.getText();
            this.currentSelectedDTUnits = (String)this.cbUnits.getSelectedItem();
            this.currentSelectedDTPrecision = this.ifDTPrecision.getText();
            this.currentSelectedDTScale = this.ifDTScale.getText();
        } else if (selDatatype instanceof DistinctType) {
            this.currentSelectedDistinct = (DistinctType)selDatatype;
        } else if (selDatatype instanceof StructuredType) {
            this.currentSelectedStructured = (StructuredType)selDatatype;
            this.currentSelectedReference = this.chbReference.isSelected();
        } else if (selDatatype instanceof CollectionType) {
            this.currentSelectedCollection = (CollectionType)selDatatype;
        }
    }

    private void saveCurrentSelectedNewDatatype() {
        if (!this.currentSelectedName.equals(this.selectedAttribute.getName())) {
            this.initCurrentSelectedDatatype();
            return;
        }
        Object selDatatype = this.cbDatatype.getSelectedItem();
        if (this.rbDomain.isSelected()) {
            this.currentSelectedUse = 0;
            this.currentSelectedDomain = (Domain)selDatatype;
        } else if (this.rbLogical.isSelected()) {
            this.currentSelectedUse = 1;
            this.currentSelectedLogical = (LogicalDatatype)selDatatype;
            this.currentSelectedDTSize = this.ifDTSize.getText();
            this.currentSelectedDTUnits = (String)this.cbUnits.getSelectedItem();
            this.currentSelectedDTPrecision = this.ifDTPrecision.getText();
            this.currentSelectedDTScale = this.ifDTScale.getText();
        } else if (this.rbDistinct.isSelected()) {
            this.currentSelectedUse = 2;
            this.currentSelectedDistinct = (DistinctType)selDatatype;
        } else if (this.rbStructured.isSelected()) {
            this.currentSelectedUse = 3;
            this.currentSelectedStructured = (StructuredType)selDatatype;
            this.currentSelectedReference = this.chbReference.isSelected();
        } else if (this.rbCollection.isSelected()) {
            this.currentSelectedUse = 4;
            this.currentSelectedCollection = (CollectionType)selDatatype;
        }
    }

    private boolean loadCurrentSelectedNewDatatype() {
        if (!this.currentSelectedName.equals(this.selectedAttribute.getName())) {
            this.initCurrentSelectedDatatype();
            return false;
        }
        if (this.rbDomain.isSelected()) {
            if (this.currentSelectedDomain != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedDomain);
                return true;
            }
        } else if (this.rbLogical.isSelected()) {
            if (this.currentSelectedLogical != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedLogical);
                this.ifDTSize.setText(this.currentSelectedDTSize);
                this.cbUnits.setSelectedItem(this.currentSelectedDTUnits);
                this.ifDTPrecision.setText(this.currentSelectedDTPrecision);
                this.ifDTScale.setText(this.currentSelectedDTScale);
                return true;
            }
        } else if (this.rbDistinct.isSelected()) {
            if (this.currentSelectedDistinct != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedDistinct);
                return true;
            }
        } else if (this.rbStructured.isSelected()) {
            if (this.currentSelectedStructured != null) {
                this.cbDatatype.setSelectedItem(this.currentSelectedStructured);
                this.chbReference.setSelected(this.currentSelectedReference);
                return true;
            }
        } else if (this.rbCollection.isSelected() && this.currentSelectedCollection != null) {
            this.cbDatatype.setSelectedItem(this.currentSelectedCollection);
            return true;
        }
        return false;
    }

    private boolean isPK(ContainedObject contained) {
        for (KeyObject key : this.keysList) {
            if (!key.isPK() || !key.contains(contained)) continue;
            return true;
        }
        return false;
    }

    private void addAttribute(ActionEvent e) {
        RowSorter<? extends TableModel> sorter;
        boolean shift = false;
        boolean ctrl = false;
        if (e != null) {
            shift = (e.getModifiers() & 1) == 1;
            boolean bl = ctrl = (e.getModifiers() & 2) == 2;
        }
        if ((sorter = this.coTable.getRowSorter()) != null) {
            sorter.setSortKeys(null);
        }
        int irow = this.coTable.getSelectedRow();
        int rowCount = this.attributesList.size();
        Attribute attribute = new Attribute(this.entity.getDesignPart());
        attribute.setObjectID(new GUID().toString());
        attribute.setName(this.generateAttributeName());
        attribute.setDesign(this.entity.getDesign());
        attribute.setContainer(this.entity);
        attribute.setDesignObjectSet(this.entity.getAttributeSet());
        int added = rowCount;
        if (irow > -1) {
            if (shift) {
                if (rowCount == 0) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(irow, attribute);
                    added = irow;
                }
            } else if (ctrl) {
                if (rowCount == 0 || rowCount - 1 == irow) {
                    this.attributesList.add(attribute);
                } else {
                    this.attributesList.add(irow + 1, attribute);
                    added = irow + 1;
                }
            } else {
                this.attributesList.add(attribute);
            }
        } else {
            this.attributesList.add(attribute);
        }
        this.coTable.setRowSorter(this.coTableRowSorter);
        this.coTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.coTable, 0);
        this.tbAttributes.updateUI();
        this.coTable.updateUI();
        this.tbAttributes.changeSelection(added, 1, false, false);
        this.coTable.changeSelection(this.coTable.convertRowIndexToModel(added), 1, false, false);
        Enumeration<AbstractButton> columnDefaultdataTypeGroupEnumeration = this.group.getElements();
        while (columnDefaultdataTypeGroupEnumeration.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)columnDefaultdataTypeGroupEnumeration.nextElement();
            if (!rb.getText().trim().equalsIgnoreCase(this.storedColumnDefaultDatatype)) continue;
            rb.setSelected(true);
            this.updateDTComboBox();
            this.setDefaultDatatype();
        }
        this.initSelectedAttributeOptions(attribute, true);
        this.enableAttributeOptions(true, 1);
        this.filterBox.setEnabled(this.attributesList.size() > 0);
    }

    private void setDefaultDatatype() {
        if (this.rbDomain.isSelected()) {
            this.cbDatatype.setSelectedItem(this.domainDefaultDataType);
        } else if (this.rbLogical.isSelected()) {
            this.cbDatatype.setSelectedItem(this.logicalDefaultDataType);
        }
    }

    private void setSelectedDefaultDatatype() {
        if (this.selectedAttribute != null) {
            short use = this.selectedAttribute.getUse();
            switch (use) {
                case 0: {
                    if (this.rbDomain.isSelected()) {
                        this.cbDatatype.setSelectedItem(this.selectedAttribute.getDomain());
                        break;
                    }
                    this.setDefaultDatatype();
                    break;
                }
                case 1: {
                    if (this.rbLogical.isSelected()) {
                        this.cbDatatype.setSelectedItem(this.selectedAttribute.getLogicalDatatype());
                        try {
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                            String size = this.selectedAttribute.getSize();
                            String[] parts_n = size.split(INTERVAL_STRING);
                            this.ifDTSize.setText(parts_n[0]);
                            if (parts_n.length == 2) {
                                this.cbUnits.setSelectedItem(parts_n[1]);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            this.ifDTPrecision.setText(this.selectedAttribute.getDataTypePrecision());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            this.ifDTScale.setValue(Integer.parseInt(this.selectedAttribute.getScale()) != 0 ? Integer.valueOf(Integer.parseInt(this.selectedAttribute.getScale())) : null);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    this.setDefaultDatatype();
                    break;
                }
                case 2: {
                    if (this.rbDistinct.isSelected()) {
                        this.cbDatatype.setSelectedItem(this.selectedAttribute.getDistinctType());
                        break;
                    }
                    this.setDefaultDatatype();
                    break;
                }
                case 3: {
                    if (this.rbStructured.isSelected()) {
                        this.cbDatatype.setSelectedItem(this.selectedAttribute.getStructuredType());
                        this.chbReference.setSelected(this.selectedAttribute.isReference());
                        break;
                    }
                    this.setDefaultDatatype();
                    break;
                }
                case 4: {
                    if (this.rbCollection.isSelected()) {
                        this.cbDatatype.setSelectedItem(this.selectedAttribute.getCollectionType());
                        break;
                    }
                    this.setDefaultDatatype();
                    break;
                }
                default: {
                    this.setDefaultDatatype();
                    break;
                }
            }
        } else {
            this.setDefaultDatatype();
        }
    }

    private void coCopyAttributes() {
        this.getAppView().clearCopiedObjects();
        int[] rows = this.coTable.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            int ind = rows[i];
            if (ind <= -1 || ind >= this.attributesList.size()) continue;
            this.getAppView().addCopiedObject(this.attributesList.get(this.coTable.convertRowIndexToModel(ind)));
        }
        this.bnCOPaste.setEnabled(this.getAppView().getCopiedObjects().size() > 0);
    }

    private void coPasteAttributes() {
        List copiedObjects = this.getAppView().getCopiedObjects();
        for (Object obj : copiedObjects) {
            if (!(obj instanceof Attribute)) continue;
            Attribute source = (Attribute)obj;
            Attribute attribute = new Attribute(this.entity.getDesignPart());
            attribute.setName(this.generatePastedAttributeName(source.getName()));
            String name = attribute.getName();
            attribute.setDesign(this.entity.getDesign());
            attribute.setContainer(this.entity);
            attribute.setDesignObjectSet(this.entity.getAttributeSet());
            this.attributesList.add(attribute);
            source.copy(attribute);
            attribute.setName(name);
        }
        if (copiedObjects.size() > 0) {
            this.updateModels();
            this.coTable.updateUI();
            this.tbAttributes.updateUI();
        }
        this.reFilter();
    }

    private void updateModels() {
        ((AbstractTableModel)this.tbAttributes.getModel()).fireTableDataChanged();
        if (this.cmbAttributesUDPGroup.getSelectedItem().equals(INTERVAL_STRING)) {
            this.initAttributesUDP(null);
        } else {
            UserDefinedPropertyGroup group = (UserDefinedPropertyGroup)this.cmbAttributesUDPGroup.getSelectedItem();
            this.initAttributesUDP(group);
        }
        ((AbstractTableModel)this.tbAttributesUDPFixed.getModel()).fireTableDataChanged();
    }

    private JPanel createExtendedAttributePanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.coTable = new JTable(new AttributeModel());
        this.coTable.setSelectionMode(2);
        TableColumn column = this.coTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column.setMaxWidth(50);
        column.setMinWidth(25);
        JScrollPane scrollpane = new JScrollPane(this.coTable);
        JPanel buttonGeneral = new JPanel(new BorderLayout());
        buttonGeneral.setPreferredSize(new Dimension(250, 45));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
        btnProperties.setToolTipText(BTN_PROPERTIES);
        btnProperties.addActionListener(new COPropertiesAction());
        if (this.isEditable()) {
            MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.attributesList, this.coTable);
            String addTip = "<html><body>" + Messages.getString("EntityPropertiesDialogEx.AddTip1") + "<p>" + Messages.getString("EntityPropertiesDialogEx.AddTip2") + "<p>" + Messages.getString("EntityPropertiesDialogEx.AddTip3") + "</body></html>";
            this.bnCOAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.bnCOAdd.setToolTipText(addTip);
            this.bnCOAdd.addActionListener(new COAddAction());
            this.bnCORemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnCORemove.setEnabled(false);
            this.bnCORemove.setToolTipText(BTN_REMOVE);
            this.bnCORemove.addActionListener(new CORemoveAction());
            this.bnCOUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.bnCOUp.setEnabled(false);
            this.bnCOUp.setToolTipText(BTN_MOVE_UP);
            this.bnCOUp.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
            this.bnCODown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.bnCODown.setEnabled(false);
            this.bnCODown.setToolTipText(BTN_MOVE_DOWN);
            this.bnCODown.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
            this.bnCOCopy = new JButton(configuration.getIcon("COPY_ICON", this.getPreferredIconSize()));
            this.bnCOCopy.setEnabled(false);
            this.bnCOCopy.setToolTipText(Messages.getString("EntityPropertiesDialogEx.CopyAttributes"));
            this.bnCOCopy.addActionListener(new COCopyAction());
            this.bnCOPaste = new JButton(configuration.getIcon("PASTE_ICON", this.getPreferredIconSize()));
            this.bnCOPaste.setToolTipText(Messages.getString("EntityPropertiesDialogEx.PasteAttributes"));
            this.bnCOPaste.addActionListener(new COPasteAction());
            JMenuItem miSortAsc = new JMenuItem(Messages.getString("EntityPropertiesDialogEx.SortASC"), configuration.getIcon("SORT_ASC_ICON", this.getPreferredIconSize()));
            JMenuItem miSortDesc = new JMenuItem(Messages.getString("EntityPropertiesDialogEx.SortDESC"), configuration.getIcon("SORT_DESC_ICON", this.getPreferredIconSize()));
            this.sortAttributesMenu = new JPopupMenu();
            this.sortAttributesMenu.add(miSortAsc);
            this.sortAttributesMenu.add(miSortDesc);
            this.bnSort = new JButton(configuration.getIcon("SORT_ASC_ICON", this.getPreferredIconSize()));
            this.bnSort.setToolTipText(Messages.getString("EntityPropertiesDialogEx.SortASC_DESC"));
            this.bnSort.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    EntityPropertiesDialogEx.this.sortAttributesMenu.show(e.getComponent(), 0, 20);
                }
            });
            miSortAsc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collections.sort(EntityPropertiesDialogEx.this.attributesList, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            Attribute a1 = (Attribute)o1;
                            Attribute a2 = (Attribute)o2;
                            return a1.getName().compareTo(a2.getName());
                        }
                    });
                    EntityPropertiesDialogEx.this.coTable.updateUI();
                    EntityPropertiesDialogEx.this.entity.setDirty(true);
                }
            });
            miSortDesc.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Collections.sort(EntityPropertiesDialogEx.this.attributesList, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            Attribute a1 = (Attribute)o1;
                            Attribute a2 = (Attribute)o2;
                            return -a1.getName().compareTo(a2.getName());
                        }
                    });
                    EntityPropertiesDialogEx.this.coTable.updateUI();
                    EntityPropertiesDialogEx.this.entity.setDirty(true);
                }
            });
            this.coTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = EntityPropertiesDialogEx.this.coTable.getSelectedRow()) != -1) {
                        Attribute col;
                        EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
                        if (EntityPropertiesDialogEx.this.attributesList.size() > 0 && row < EntityPropertiesDialogEx.this.attributesList.size() && !(col = EntityPropertiesDialogEx.this.attributesList.get(EntityPropertiesDialogEx.this.coTable.convertRowIndexToModel(row))).isDialogVisible()) {
                            col.showModal = true;
                            AttributePropertiesDialogEx dialog = new AttributePropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), col, EntityPropertiesDialogEx.this.chbUsePreferredList.isSelected());
                            dialog.initProperties(col);
                            dialog.show();
                            if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                                EntityPropertiesDialogEx.this.initSelectedAttributeOptions(EntityPropertiesDialogEx.this.selectedAttribute, false);
                            }
                        }
                    }
                }
            });
            this.coTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        if (EntityPropertiesDialogEx.this.attributesList.isEmpty()) {
                            EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            btnProperties.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                        } else if (EntityPropertiesDialogEx.this.cbBasedOnST.getSelectedItem() != null) {
                            EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                            EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                        } else {
                            int[] rowIndices = EntityPropertiesDialogEx.this.coTable.getSelectedRows();
                            if (rowIndices.length == 0) {
                                EntityPropertiesDialogEx.this.bnCORemove.setEnabled(false);
                                btnProperties.setEnabled(false);
                                EntityPropertiesDialogEx.this.bnCOUp.setEnabled(false);
                                EntityPropertiesDialogEx.this.bnCODown.setEnabled(false);
                                EntityPropertiesDialogEx.this.bnCOCopy.setEnabled(false);
                                EntityPropertiesDialogEx.this.coTableIsSingleRowSelected = false;
                                EntityPropertiesDialogEx.this.manageControlsState(EntityPropertiesDialogEx.this.pnOptions, false, true);
                            } else {
                                if (rowIndices.length == 1) {
                                    EntityPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                                    btnProperties.setEnabled(true);
                                    EntityPropertiesDialogEx.this.bnCOCopy.setEnabled(true);
                                    EntityPropertiesDialogEx.this.manageControlsState(EntityPropertiesDialogEx.this.pnOptions, true, false);
                                    EntityPropertiesDialogEx.this.coTableIsSingleRowSelected = true;
                                    EntityPropertiesDialogEx.this.setAttributeSelected();
                                } else if (rowIndices.length > 1) {
                                    EntityPropertiesDialogEx.this.bnCORemove.setEnabled(true);
                                    btnProperties.setEnabled(false);
                                    EntityPropertiesDialogEx.this.bnCOCopy.setEnabled(true);
                                    EntityPropertiesDialogEx.this.manageControlsState(EntityPropertiesDialogEx.this.pnOptions, false, true);
                                    EntityPropertiesDialogEx.this.coTableIsSingleRowSelected = false;
                                }
                                if (!EntityPropertiesDialogEx.this.attributesfiltered) {
                                    EntityPropertiesDialogEx.this.bnCOUp.setEnabled(true);
                                    EntityPropertiesDialogEx.this.bnCODown.setEnabled(true);
                                }
                            }
                        }
                    }
                }
            });
        }
        this.filterBox = new JSearchTextField(false, true, Messages.getString("EntityPropertiesDialogEx.Name"));
        this.filterBox.setEnabled(false);
        this.filterBox.setPreferredSize(new Dimension(100, 17));
        this.filterBox.getDocument().addDocumentListener(new FilterItemsListener());
        this.filterBox.setToolTipText(Messages.getString("EntityPropertiesDialogEx.SearchAttribute"));
        buttonGeneral.add((Component)this.filterBox, "North");
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        if (this.isEditable()) {
            toolBar.addSeparator();
            toolBar.add(this.bnCOAdd);
            toolBar.add(this.bnCORemove);
            toolBar.add(this.bnCOUp);
            toolBar.add(this.bnCODown);
            toolBar.addSeparator();
            toolBar.add(this.bnCOCopy);
            toolBar.add(this.bnCOPaste);
            toolBar.add(this.bnSort);
        }
        buttonGeneral.add((Component)toolBar, "South");
        JPanel columnsPanel = new JPanel(new BorderLayout());
        columnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.AttributesL")));
        columnsPanel.add((Component)buttonGeneral, "North");
        columnsPanel.add(scrollpane);
        jpanel.add((Component)columnsPanel, "Center");
        this.coTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    EntityPropertiesDialogEx.this.deleteAttribute(EntityPropertiesDialogEx.this.coTable);
                }
            }
        });
        this.pnOptions = new JPanel(new BorderLayout());
        this.pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.AttributeProperties")));
        JPanel pnGrid = new JPanel(new BorderLayout());
        Dimension dim = new Dimension(60, 20);
        Dimension dimL = new Dimension(120, 20);
        JLabel lbColumnName = new JLabel(LB_NAME);
        lbColumnName.setPreferredSize(dimL);
        this.tfColumnName = new JTextField();
        this.tfColumnName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    EntityPropertiesDialogEx.this.moveUp();
                } else if (e.getKeyCode() == 40) {
                    EntityPropertiesDialogEx.this.moveDown();
                }
            }
        });
        Dimension dim1 = new Dimension(200, 20);
        Dimension dim2 = new Dimension(260, 20);
        this.tfColumnName.setPreferredSize(dim2);
        JPanel pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)this.createRow(lbColumnName, this.tfColumnName), "North");
        pnSize.add((Component)new JPanel(), "Center");
        pnGrid.add((Component)pnSize, "North");
        RBActionListener rbAL = new RBActionListener();
        this.rbDomain = new JRadioButton(LB_DOMAIN);
        this.rbLogical = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("EntityPropertiesDialogEx.Collection"));
        this.rbDomain.addActionListener(rbAL);
        this.rbLogical.addActionListener(rbAL);
        this.rbDistinct.addActionListener(rbAL);
        this.rbStructured.addActionListener(rbAL);
        this.rbCollection.addActionListener(rbAL);
        this.group = new ButtonGroup();
        this.group.add(this.rbDomain);
        this.group.add(this.rbLogical);
        this.group.add(this.rbDistinct);
        this.group.add(this.rbStructured);
        this.group.add(this.rbCollection);
        JPanel pnRadioGroup1 = new JPanel(new GridLayout(1, 0));
        pnRadioGroup1.add(this.rbDomain);
        pnRadioGroup1.add(this.rbLogical);
        pnRadioGroup1.add(this.rbDistinct);
        JPanel pnRadioGroup2 = new JPanel(new GridLayout(1, 0));
        pnRadioGroup2.add(this.rbStructured);
        pnRadioGroup2.add(this.rbCollection);
        pnRadioGroup2.add(new JPanel());
        JLabel lbDatatype = new JLabel(LB_DATATYPE);
        lbDatatype.setPreferredSize(dimL);
        JPanel pnDTGrid = new JPanel(new GridLayout(0, 1));
        JLabel lbEmpty = new JLabel();
        lbEmpty.setPreferredSize(dimL);
        pnDTGrid.add(this.createRow(lbDatatype, pnRadioGroup1));
        pnDTGrid.add(this.createRow(lbEmpty, pnRadioGroup2));
        pnGrid.add((Component)pnDTGrid, "Center");
        JPanel pnDT = new JPanel(new BorderLayout(0, 10));
        JPanel pnKey = new JPanel(new BorderLayout());
        pnKey.add((Component)pnDT, "Center");
        pnGrid.add((Component)pnKey, "South");
        JLabel lbType = new JLabel(LB_TYPE);
        lbType.setPreferredSize(dimL);
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setPreferredSize(dim1);
        this.cbDatatype.setMaximumRowCount(20);
        this.cbDatatypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean canBeUsedForPK = true;
                if (EntityPropertiesDialogEx.this.rbLogical.isSelected()) {
                    EntityPropertiesDialogEx.this.updateLogicalDatatypeOptions();
                    LogicalDatatype sel = (LogicalDatatype)EntityPropertiesDialogEx.this.cbDatatype.getSelectedItem();
                    if (sel != null) {
                        String selectedDataTypeName = sel.getName();
                        Design design = EntityPropertiesDialogEx.this.getDesignObject().getDesign();
                        LogicalDatatype logicaldatatype = (LogicalDatatype)design.getLogicalDatatypeSet().getByName(selectedDataTypeName);
                        MDDataType translatedDataType = logicaldatatype.createDataType(design.getSelectedRDBMSType().getName(), new HashMap());
                        String translatedDataTypeName = translatedDataType.getName();
                        canBeUsedForPK = LogicalDatatype.canBeUsedForPK(translatedDataTypeName);
                    }
                } else if (EntityPropertiesDialogEx.this.rbStructured.isSelected() && EntityPropertiesDialogEx.this.selectedAttribute != null && !EntityPropertiesDialogEx.this.selectedAttribute.isOid() || EntityPropertiesDialogEx.this.rbCollection.isSelected()) {
                    canBeUsedForPK = false;
                }
                if (!canBeUsedForPK) {
                    EntityPropertiesDialogEx.this.removeSelectedColumnFromPK();
                    EntityPropertiesDialogEx.this.removeSelectedColumnFromUK();
                } else {
                    EntityPropertiesDialogEx.this.chbPK.setEnabled(EntityPropertiesDialogEx.this.isEditable() && EntityPropertiesDialogEx.this.selectedAttribute != null);
                }
            }
        };
        this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
        JLabel lbPreferred = new JLabel(Messages.getString("EntityPropertiesDialogEx.Preferred"));
        lbPreferred.setHorizontalAlignment(0);
        lbPreferred.setPreferredSize(new Dimension(lbPreferred.getPreferredSize().width + 10, lbPreferred.getPreferredSize().height));
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)new JPanel(), "North");
        pnSize.add((Component)this.createRow(lbType, this.cbDatatype), "Center");
        pnSize.add((Component)this.createRow(lbPreferred, this.chbUsePreferredList), "East");
        pnDT.add((Component)pnSize, "North");
        this.pnDType = new JPanel(new BorderLayout());
        this.pnDType.setPreferredSize(new Dimension(200, 50));
        JLabel lbSize = new JLabel(INTERVAL_STRING + LB_SIZE);
        lbSize.setHorizontalAlignment(2);
        lbSize.setPreferredSize(dimL);
        this.ifDTSize = new JTextField();
        this.ifDTSize.setPreferredSize(dim2);
        this.pnDTSize = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTSize.add(this.createRow(lbSize, this.ifDTSize));
        this.pnDType.add((Component)this.pnDTSize, "North");
        pnDT.add((Component)this.pnDType, "Center");
        JLabel lbUnits = new JLabel(Messages.getString("EntityPropertiesDialogEx.Units"));
        lbUnits.setHorizontalAlignment(2);
        lbUnits.setPreferredSize(dimL);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.cbUnits.setPreferredSize(new Dimension(60, 20));
        JPanel pnUnits = new JPanel(new BorderLayout());
        pnUnits.add((Component)this.createRow(lbUnits, this.cbUnits), "West");
        pnUnits.add((Component)new JPanel(), "Center");
        this.pnDTSize.add(pnUnits);
        JLabel lbPrecision = new JLabel(LB_PRECISION);
        lbPrecision.setHorizontalAlignment(2);
        lbPrecision.setPreferredSize(dimL);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setAllowAsterisks(true);
        this.ifDTPrecision.setPreferredSize(dim2);
        this.pnDTScale = new JPanel(new GridLayout(0, 1, 0, 10));
        this.pnDTScale.add(this.createRow(lbPrecision, this.ifDTPrecision));
        JLabel lbScale = new JLabel(LB_SCALE);
        lbScale.setHorizontalAlignment(2);
        lbScale.setPreferredSize(dimL);
        this.ifDTScale = new JIntegerField();
        this.ifDTScale.setPreferredSize(dim2);
        this.pnDTScale.add(this.createRow(lbScale, this.ifDTScale));
        this.pnRef = new JPanel(new GridLayout(0, 1, 0, 10));
        JLabel lbRef = new JLabel("");
        lbRef.setHorizontalAlignment(0);
        lbRef.setPreferredSize(dim);
        this.chbReference = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.Reference"));
        this.ifDTSize.setPreferredSize(dim2);
        this.pnRef.add(this.createRow(lbRef, this.chbReference));
        JPanel pnKeys = new JPanel(new GridLayout(0, 1));
        pnKey.add((Component)pnKeys, "South");
        pnKeys.add(new JPanel());
        this.chbPK = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.PK"));
        this.chbPKActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                    EntityPropertiesDialogEx.this.updatePKStatus(EntityPropertiesDialogEx.this.selectedAttribute, EntityPropertiesDialogEx.this.chbPK.isSelected());
                    if (EntityPropertiesDialogEx.this.chbPK.isSelected()) {
                        EntityPropertiesDialogEx.this.chbMandatory.setSelected(true);
                        EntityPropertiesDialogEx.this.chbMandatory.setEnabled(false);
                    } else {
                        EntityPropertiesDialogEx.this.chbMandatory.setEnabled(true);
                    }
                }
            }
        };
        this.chbPK.addActionListener(this.chbPKActionListener);
        this.chbFK = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.FK"));
        this.chbFK.setEnabled(false);
        this.chbMandatory = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.Mandatory"));
        this.chbMandatory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                    EntityPropertiesDialogEx.this.selectedAttribute.setNullsAllowed(!EntityPropertiesDialogEx.this.chbMandatory.isSelected());
                }
            }
        });
        this.chbAttributeDeprecated = new JCheckBox(Messages.getString("EntityPropertiesDialogEx.Deprecated"));
        this.chbAttributeDeprecated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                    EntityPropertiesDialogEx.this.selectedAttribute.setDeprecated(EntityPropertiesDialogEx.this.chbAttributeDeprecated.isSelected());
                }
            }
        });
        JPanel pn1 = new JPanel(new GridLayout(1, 0));
        pn1.add(this.chbPK);
        pn1.add(this.chbFK);
        pn1.add(this.chbMandatory);
        pn1.add(this.chbAttributeDeprecated);
        lbEmpty = new JLabel("");
        lbEmpty.setPreferredSize(dim);
        pnKeys.add(this.createRow(lbEmpty, pn1));
        JTabbedPane tpComments = new JTabbedPane();
        this.taColumnComments = new RSyntaxTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnComments.setBorder(null);
        this.taColumnComments.setAntiAliasingEnabled(true);
        this.taColumnComments.setFont(this.tfName.getFont());
        this.taColumnNotes = new RSyntaxTextArea();
        this.taColumnNotes.setLineWrap(true);
        this.taColumnNotes.setWrapStyleWord(true);
        this.taColumnNotes.setBorder(null);
        this.taColumnNotes.setAntiAliasingEnabled(true);
        this.taColumnNotes.setFont(this.tfName.getFont());
        this.taColumnCommentsInRDBMS = new RSyntaxTextArea();
        this.taColumnCommentsInRDBMS.setLineWrap(true);
        this.taColumnCommentsInRDBMS.setWrapStyleWord(true);
        this.taColumnCommentsInRDBMS.setBorder(null);
        this.taColumnCommentsInRDBMS.setAntiAliasingEnabled(true);
        this.taColumnCommentsInRDBMS.setFont(this.tfName.getFont());
        tpComments.addTab(Messages.getString("EntityPropertiesDialogEx.CommentsInRDBMS"), new JScrollPane((Component)this.taColumnCommentsInRDBMS));
        tpComments.addTab(Messages.getString("EntityPropertiesDialogEx.Comments"), new JScrollPane((Component)this.taColumnComments));
        tpComments.addTab(Messages.getString("EntityPropertiesDialogEx.Notes"), new JScrollPane((Component)this.taColumnNotes));
        tpComments.setPreferredSize(new Dimension(300, 100));
        JPanel pnTop = new JPanel(new FlowLayout(0));
        pnTop.add(pnGrid);
        this.pnOptions.add((Component)pnTop, "North");
        this.pnOptions.add((Component)tpComments, "Center");
        jpanel.add((Component)this.pnOptions, "East");
        this.updateDTComboBox();
        return jpanel;
    }

    private void removeSelectedColumnFromPK() {
        this.chbPK.setSelected(false);
        this.chbPK.setEnabled(false);
        CandidateKey primaryKey = this.getPK();
        if (primaryKey != null && primaryKey.contains(this.selectedAttribute)) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), Messages.getString("EntityPropertiesDialogEx.PKAttributeRemoved"), Messages.getString("EntityPropertiesDialogEx.PKAttributesAssignment"), 2);
        }
        this.chbPKActionListener.actionPerformed(null);
    }

    private void removeSelectedColumnFromUK() {
        StringBuilder removedUKColumns = new StringBuilder();
        for (KeyObject uniqueKey : this.keysList) {
            if (!uniqueKey.contains(this.selectedAttribute)) continue;
            uniqueKey.remove(this.selectedAttribute);
            this.logIndexColumnRemoved(uniqueKey.getName(), removedUKColumns);
        }
        if (removedUKColumns.length() > 0) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.UKAttributeRemoved"), removedUKColumns.toString()), Messages.getString("EntityPropertiesDialogEx.UKAttributesAssignment"), 2);
        }
    }

    private void logIndexColumnRemoved(String indexName, StringBuilder removedIndexColumns) {
        if (removedIndexColumns.length() > 0) {
            removedIndexColumns.append(", ");
        }
        removedIndexColumns.append(indexName);
    }

    private void moveUp() {
        int row = this.coTable.getSelectedRow();
        if (row > 0) {
            this.coTable.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            this.setAttributeSelected();
        }
    }

    private void moveDown() {
        int row = this.coTable.getSelectedRow();
        if (row > -1) {
            if (row < this.attributesList.size() - 1) {
                this.coTable.getSelectionModel().setSelectionInterval(row + 1, row + 1);
                this.setAttributeSelected();
            } else if (!ApplicationView.IS_VIEWER && row == this.attributesList.size() - 1) {
                this.addAttribute(null);
            }
        }
    }

    private void updateLogicalDatatypeOptions() {
        this.ifDTSize.setText("");
        this.ifDTPrecision.setText("");
        this.ifDTScale.setText("");
        this.cbUnits.setSelectedIndex(0);
        this.cbUnits.setEnabled(false);
        this.pnDType.removeAll();
        this.pnDType.updateUI();
        this.sizeEnabled = false;
        this.precisionEnabled = false;
        LogicalDatatype selected = (LogicalDatatype)this.cbDatatype.getSelectedItem();
        if (selected != null) {
            Map defaults = selected.getLTDefaultValues();
            if (defaults != null) {
                this.precisionDefaultValue = (String)defaults.get("precision_default_value");
                this.sizeDefaultValue = (String)defaults.get("size_default_value");
                this.scaleDefaultValue = (String)defaults.get("scale_default_value");
            }
            Map<String, String> m = selected.getToPhysical();
            MDDataType datatype = selected.createDataType(this.entity.getSelectedRDBMSType().getName(), m);
            if (datatype instanceof MDImplicitSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.ifDTPrecision.setText(this.precisionDefaultValue);
                this.ifDTPrecision.setEnabled(false);
                this.ifDTScale.setText(this.scaleDefaultValue);
                this.ifDTScale.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
            } else if (datatype instanceof MDPackedSized) {
                this.ifDTSize.setText(this.sizeDefaultValue);
                this.ifDTSize.setEnabled(false);
                this.pnDType.removeAll();
                this.pnDType.add((Component)this.pnDTScale, "North");
                this.pnDType.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = true;
                try {
                    if (datatype.getPrecision() != 0) {
                        this.ifDTPrecision.setText(datatype.getPrecisionStr());
                    }
                    if (this.isEditable()) {
                        this.ifDTPrecision.setEnabled(true);
                        if (this.ifDTPrecision.getText().trim().length() == 0) {
                            this.ifDTPrecision.setText(this.precisionDefaultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (datatype.getScale() != 0) {
                        this.ifDTScale.setText("" + datatype.getScale());
                    }
                    if (this.isEditable()) {
                        this.ifDTScale.setEnabled(true);
                        if (this.ifDTScale.getText().trim().length() == 0) {
                            this.ifDTScale.setText(this.scaleDefaultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.ifDTScale.setEnabled(false);
                }
            } else {
                try {
                    if (datatype.hasSize()) {
                        if (!datatype.getSize().equalsIgnoreCase("0")) {
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                            String size = datatype.getSize();
                            String[] parts_n = size.split(INTERVAL_STRING);
                            this.ifDTSize.setText(parts_n[0]);
                            if (parts_n.length == 2) {
                                this.cbUnits.setSelectedItem(parts_n[1]);
                            }
                        } else {
                            this.ifDTSize.setText(this.sizeDefaultValue);
                            if (this.isEditable()) {
                                this.cbUnits.setEnabled(true);
                            }
                        }
                        if (this.isEditable()) {
                            this.ifDTSize.setEnabled(true);
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTSize, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = true;
                        this.precisionEnabled = false;
                    } else {
                        this.ifDTSize.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTSize.setEnabled(false);
                }
                try {
                    if (datatype.hasPrecision()) {
                        if (datatype.getPrecision() != 0) {
                            this.ifDTPrecision.setText("" + datatype.getPrecision());
                        }
                        if (this.isEditable()) {
                            this.ifDTPrecision.setEnabled(true);
                            if (this.ifDTPrecision.getText().trim().length() == 0) {
                                this.ifDTPrecision.setText(this.precisionDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTPrecision.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTPrecision.setEnabled(false);
                }
                try {
                    if (datatype.hasScale()) {
                        if (datatype.getScale() != 0) {
                            this.ifDTScale.setText("" + datatype.getScale());
                        }
                        if (this.isEditable()) {
                            this.ifDTScale.setEnabled(true);
                            if (this.ifDTScale.getText().trim().length() == 0) {
                                this.ifDTScale.setText(this.scaleDefaultValue);
                            }
                        }
                        this.pnDType.removeAll();
                        this.pnDType.add((Component)this.pnDTScale, "North");
                        this.pnDType.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                    } else {
                        this.ifDTScale.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    this.ifDTScale.setEnabled(false);
                }
            }
        }
    }

    protected JPanel getRelationsPanel() {
        if (this.pnRelations == null) {
            this.pnRelations = this.createPage(Messages.getString("EntityPropertiesDialogEx.76"));
            this.relationsList = new ArrayList();
            this.relationsModel = new RelationsModel();
            this.tbRelations = new RelationTable(this.relationsModel);
            this.tbRelations.setSelectionMode(0);
            TableColumn column = this.tbRelations.getColumnModel().getColumn(0);
            column.setPreferredWidth(400);
            this.tbRelations.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Relation relation;
                    int row;
                    if (e.getClickCount() == 2 && (row = EntityPropertiesDialogEx.this.tbRelations.convertRowIndexToModel(EntityPropertiesDialogEx.this.tbRelations.getSelectedRow())) != -1 && EntityPropertiesDialogEx.this.relationsList.size() > 0 && row < EntityPropertiesDialogEx.this.relationsList.size() && !(relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(row)).isDialogVisible()) {
                        relation.showModal = EntityPropertiesDialogEx.this.entity.showModal;
                        relation.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.tbRelations);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new RelationPropertiesAction());
            if (this.isEditable()) {
                this.tbRelations.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (EntityPropertiesDialogEx.this.relationsList.isEmpty()) {
                            btnProperties.setEnabled(false);
                        } else {
                            btnProperties.setEnabled(true);
                        }
                    }
                });
                this.tbRelations.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (EntityPropertiesDialogEx.this.relationsList.isEmpty()) {
                            btnProperties.setEnabled(false);
                        } else {
                            btnProperties.setEnabled(true);
                        }
                    }
                });
                ListSelectionModel rowSM = this.tbRelations.getSelectionModel();
                rowSM.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                            if (lsm.isSelectionEmpty()) {
                                btnProperties.setEnabled(false);
                            } else {
                                btnProperties.setEnabled(true);
                            }
                        }
                    }
                });
            }
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel relPanel = new JPanel(new BorderLayout());
            relPanel.add((Component)buttonGeneral, "North");
            relPanel.add(scrollpane);
            this.pnRelations.add(relPanel);
        }
        return this.pnRelations;
    }

    private void deleteKey() {
        int objectNumber = this.itable.convertRowIndexToModel(this.itable.getSelectedRow());
        if (objectNumber != -1) {
            if (this.keysList.size() > 0 && objectNumber < this.keysList.size()) {
                this.keysList.remove(objectNumber);
                if (this.itable.getRowSorter() != null) {
                    if (this.keysList.size() >= 1) {
                        this.itable.getRowSorter().setSortKeys(null);
                    } else {
                        this.itable.setAutoCreateRowSorter(false);
                        this.itable.setRowSorter(null);
                    }
                }
                this.itable.updateUI();
            }
            if (this.keysList.size() >= 1) {
                WindowsTableHeader.setSortedHeader(this.itable, 0);
            }
        }
    }

    protected JPanel getKeysPanel() {
        if (this.pnKeys == null) {
            this.pnKeys = this.createPage(Messages.getString("EntityPropertiesDialogEx.Keys"));
            this.keysList = new ArrayList<KeyObject>();
            this.indexModel = new KeyModel();
            this.itable = new JTable(this.indexModel);
            this.itable.setSelectionMode(0);
            TableColumn column = this.itable.getColumnModel().getColumn(0);
            column.setPreferredWidth(400);
            column = this.itable.getColumnModel().getColumn(1);
            column.setPreferredWidth(100);
            column = this.itable.getColumnModel().getColumn(2);
            column.setPreferredWidth(100);
            this.itable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CandidateKey key;
                    int row;
                    if (e.getClickCount() == 2 && (row = EntityPropertiesDialogEx.this.itable.convertRowIndexToModel(EntityPropertiesDialogEx.this.itable.getSelectedRow())) != -1 && EntityPropertiesDialogEx.this.keysList.size() > 0 && row < EntityPropertiesDialogEx.this.keysList.size() && !(key = (CandidateKey)EntityPropertiesDialogEx.this.keysList.get(row)).isDialogVisible()) {
                        key.showModal = true;
                        KeyPropertiesDialogEx dialog = new KeyPropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), key);
                        List nestedElements = EntityPropertiesDialogEx.this.entity.getNestedElements();
                        if (nestedElements.size() > 0) {
                            ArrayList<Attribute> expandedList = new ArrayList<Attribute>(EntityPropertiesDialogEx.this.attributesList);
                            expandedList.addAll(nestedElements);
                            dialog.setAttributesList(expandedList);
                            key.setTempObjects(expandedList);
                        } else {
                            dialog.setAttributesList(EntityPropertiesDialogEx.this.attributesList);
                            key.setTempObjects(EntityPropertiesDialogEx.this.attributesList);
                        }
                        dialog.initProperties(key);
                        dialog.show();
                        key.setTempObjects(null);
                        EntityPropertiesDialogEx.this.itable.updateUI();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.itable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 35));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            final JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setEnabled(false);
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new KeyPropertiesAction());
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                this.btnAddKey = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                this.btnAddKey.setToolTipText(BTN_ADD);
                this.btnAddKey.addActionListener(new AddKeyAction());
                final JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setEnabled(false);
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new RemoveKeyAction());
                this.itable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            if (EntityPropertiesDialogEx.this.keysList.isEmpty()) {
                                btnRemove.setEnabled(false);
                                btnProperties.setEnabled(false);
                            } else if (EntityPropertiesDialogEx.this.itable.getSelectedRow() > -1) {
                                KeyObject key = EntityPropertiesDialogEx.this.keysList.get(EntityPropertiesDialogEx.this.itable.convertRowIndexToModel(EntityPropertiesDialogEx.this.itable.getSelectedRow()));
                                if (key.isOidKey()) {
                                    btnRemove.setEnabled(false);
                                } else {
                                    btnRemove.setEnabled(true);
                                }
                                btnProperties.setEnabled(true);
                            } else {
                                btnRemove.setEnabled(false);
                                btnProperties.setEnabled(false);
                            }
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(this.btnAddKey);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            JPanel indexesPanel = new JPanel(new BorderLayout());
            indexesPanel.add((Component)buttonGeneral, "North");
            indexesPanel.add(scrollpane);
            this.pnKeys.add(indexesPanel);
            this.itable.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        EntityPropertiesDialogEx.this.deleteKey();
                    }
                }
            });
        }
        return this.pnKeys;
    }

    protected JPanel getVolumesPanel() {
        if (this.pnVolumes == null) {
            this.pnVolumes = this.createPage(Messages.getString("EntityPropertiesDialogEx.VolumeProperties"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel jpVolumes = new JPanel(new BorderLayout(10, 10));
            jpVolumes.setBorder(BorderFactory.createTitledBorder(LB_VOLUMES));
            JPanel pnGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbMinVolume = new JLabel(LB_MIN_VOLUME);
            lbMinVolume.setPreferredSize(this.getDefaultSize());
            this.tfMinVolume = new JTextField();
            this.tfMinVolume.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lbMinVolume, this.tfMinVolume));
            JLabel lbExpected = new JLabel(LB_EXPECTED);
            lbExpected.setPreferredSize(this.getDefaultSize());
            this.tfExpected = new JTextField();
            this.tfExpected.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lbExpected, this.tfExpected));
            JLabel lbMaximum = new JLabel(LB_MAXIMUM);
            lbMaximum.setPreferredSize(this.getDefaultSize());
            this.tfMaximum = new JTextField();
            this.tfMaximum.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lbMaximum, this.tfMaximum));
            jpVolumes.add((Component)pnGrid, "North");
            JPanel jpGrowthRate = new JPanel(new BorderLayout(10, 10));
            JPanel pnGridCenter = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jpGrowthRate2 = new JPanel(new BorderLayout(10, 10));
            jpGrowthRate2.setBorder(BorderFactory.createTitledBorder(LB_GROWTH_RATE));
            JLabel lbGrowthPercent = new JLabel(LB_GROWTH_PERCENT);
            lbGrowthPercent.setPreferredSize(this.getDefaultSize());
            this.tfGrowthPercent = new JTextField();
            this.tfGrowthPercent.setPreferredSize(this.getDefaultSize());
            pnGridCenter.add(this.createRow(lbGrowthPercent, this.tfGrowthPercent));
            JLabel lbYearMonthDay = new JLabel(LB_YEAR_MONTH_DAY);
            lbYearMonthDay.setPreferredSize(this.getDefaultSize());
            this.cbYearMonthDay = new JComboBox<String>(YMD);
            this.cbYearMonthDay.setPreferredSize(this.getDefaultSize());
            this.cbYearMonthDay.setMaximumRowCount(8);
            pnGridCenter.add(this.createRow(lbYearMonthDay, this.cbYearMonthDay));
            JPanel jpBottom = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jpBottom2 = new JPanel(new BorderLayout(10, 10));
            JLabel lbNormalForm = new JLabel(LB_NORMAL_FORM);
            lbNormalForm.setPreferredSize(this.getDefaultSize());
            this.cbNormalForm = new JComboBox<String>(NF);
            this.cbNormalForm.setPreferredSize(this.getDefaultSize());
            this.cbNormalForm.setMaximumRowCount(8);
            jpBottom.add((Component)this.createRow(lbNormalForm, this.cbNormalForm), "North");
            JLabel lbAdequatelyNormalized = new JLabel(LB_ADEQUATELY_NORMALIZED);
            lbAdequatelyNormalized.setPreferredSize(this.getDefaultSize());
            this.cbAdequatelyNormalized = new JComboBox<String>(YES_NO);
            this.cbAdequatelyNormalized.setPreferredSize(this.getDefaultSize());
            this.cbAdequatelyNormalized.setMaximumRowCount(8);
            jpBottom.add((Component)this.createRow(lbAdequatelyNormalized, this.cbAdequatelyNormalized), "Center");
            jpGrowthRate2.add((Component)pnGridCenter, "North");
            jpGrowthRate.add((Component)jpGrowthRate2, "North");
            jpBottom2.add((Component)jpBottom, "North");
            jpGrowthRate.add((Component)jpBottom2, "Center");
            jpanel.add((Component)jpVolumes, "North");
            jpanel.add((Component)jpGrowthRate, "Center");
            this.pnVolumes.add((Component)jpanel, "Center");
        }
        return this.pnVolumes;
    }

    protected JPanel getSubtypesPanel() {
        if (this.pnSubtypes == null) {
            this.pnSubtypes = this.createPage(Messages.getString("EntityPropertiesDialogEx.Subtypes"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel jpSubTypeGen1 = new JPanel(new BorderLayout(10, 10));
            jpSubTypeGen1.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.EntityAndSubtypes")));
            JPanel jpSubTypeGen2 = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbEngStrategy = new JLabel(Messages.getString("EntityPropertiesDialogEx.SubtreeGeneration"));
            lbEngStrategy.setPreferredSize(this.getDefaultSize());
            this.cbEngStrategy = new JComboBox();
            this.cbEngStrategy.setPreferredSize(this.getDefaultSize());
            this.cbEngStrategy.setMaximumRowCount(8);
            jpSubTypeGen2.add(this.createRow(lbEngStrategy, this.cbEngStrategy));
            JLabel lbExpected = new JLabel(Messages.getString("EntityPropertiesDialogEx.ApplyToModel"));
            lbExpected.setPreferredSize(this.getDefaultSize());
            this.cbRelationalModel = new JComboBox();
            jpSubTypeGen2.add(this.createRow(lbExpected, this.cbRelationalModel));
            jpSubTypeGen1.add((Component)jpSubTypeGen2, "South");
            JPanel jpSubImplem = new JPanel(new BorderLayout(10, 10));
            JPanel pnGridCenter = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jpSubImplem2 = new JPanel(new BorderLayout(10, 10));
            jpSubImplem2.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.SubtypesImplementation")));
            JLabel lbGrowthPercent = new JLabel(Messages.getString("EntityPropertiesDialogEx.References"));
            lbGrowthPercent.setPreferredSize(this.getDefaultSize());
            this.cbReferences = new JComboBox();
            this.tfGrowthPercent = new JTextField();
            pnGridCenter.add(this.createRow(lbGrowthPercent, this.cbReferences));
            JLabel lbAttribInheritance = new JLabel(Messages.getString("EntityPropertiesDialogEx.AttributesInheritance"));
            lbAttribInheritance.setPreferredSize(this.getDefaultSize());
            this.cbAtributesInher = new JComboBox();
            this.cbAtributesInher.setPreferredSize(this.getDefaultSize());
            pnGridCenter.add(this.createRow(lbAttribInheritance, this.cbAtributesInher));
            JPanel jpBottom = new JPanel(new GridLayout(0, 1, 10, 10));
            JPanel jpBottom2 = new JPanel(new BorderLayout(10, 10));
            jpBottom.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.DiscrimanatorColumn")));
            JLabel lbDiscrColumn = new JLabel(Messages.getString("EntityPropertiesDialogEx.GenerateDiscriminator"));
            lbDiscrColumn.setPreferredSize(this.getDefaultSize());
            this.chGenerateDiscrColumn = new JCheckBox();
            jpBottom.add((Component)this.createRow(lbDiscrColumn, this.chGenerateDiscrColumn), "North");
            JLabel lbUseAttributes = new JLabel(Messages.getString("EntityPropertiesDialogEx.UseAttribute"));
            lbUseAttributes.setPreferredSize(this.getDefaultSize());
            this.cbUseAttribute = new JComboBox<String>(YES_NO);
            this.cbUseAttribute.setPreferredSize(this.getDefaultSize());
            this.cbUseAttribute.setMaximumRowCount(8);
            jpBottom.add((Component)this.createRow(lbUseAttributes, this.cbUseAttribute), "Center");
            JLabel lbDiscrColumnName = new JLabel(Messages.getString("EntityPropertiesDialogEx.ColumnName"));
            this.tfDiscrColumnName = new JTextField();
            lbDiscrColumnName.setPreferredSize(this.getDefaultSize());
            this.tfDiscrColumnName.setPreferredSize(this.getDefaultSize());
            jpBottom.add((Component)this.createRow(lbDiscrColumnName, this.tfDiscrColumnName), "South");
            JLabel lbDiscrValue = new JLabel(Messages.getString("EntityPropertiesDialogEx.DiscriminatingValue"));
            this.tfDiscrValue = new JTextField();
            lbDiscrValue.setPreferredSize(this.getDefaultSize());
            this.tfDiscrValue.setPreferredSize(this.getDefaultSize());
            jpBottom.add((Component)this.createRow(lbDiscrValue, this.tfDiscrValue), "South");
            JLabel lbComplete = new JLabel(Messages.getString("EntityPropertiesDialogEx.CompleteSubtypes"));
            lbComplete.setPreferredSize(this.getDefaultSize());
            this.chCompleteSubtypes = new JCheckBox();
            jpBottom.add((Component)this.createRow(lbComplete, this.chCompleteSubtypes), "South");
            jpSubImplem2.add((Component)pnGridCenter, "North");
            jpSubImplem.add((Component)jpSubImplem2, "North");
            jpBottom2.add((Component)jpBottom, "North");
            jpSubImplem.add((Component)jpBottom2, "Center");
            jpanel.add((Component)jpSubTypeGen1, "North");
            jpanel.add((Component)jpSubImplem, "Center");
            this.pnSubtypes.add((Component)jpanel, "Center");
        }
        return this.pnSubtypes;
    }

    protected JPanel getImpactAnalysisPanel() {
        JPanel pnImpactAnalysis = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = EntityPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (EntityPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            EntityPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            EntityPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpactAnalysis.add((Component)scrollPane, "Center");
        return pnImpactAnalysis;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_Entity(this.entity, null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    @Override
    protected boolean canExit() {
        if (this.selectedAttribute != null) {
            this.initSelectedAttributeOptions(this.selectedAttribute, true);
        }
        this.setPreviousSelectedAttribute();
        if (super.canExit()) {
            return this.checkRequiredProperties();
        }
        return false;
    }

    protected boolean checkRequiredProperties() {
        for (KeyObject key : this.keysList) {
            if (((CandidateKey)key).getNewElementsCollection().size() != 0 || !"".equals(((CandidateKey)key).getNewElementsIDs())) continue;
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.IncompleteUIDdefinition"), key.getName()), Messages.getString("EntityPropertiesDialogEx.UIDColumnsAssignment"), 0);
            return false;
        }
        return true;
    }

    public boolean containsElement(ComboBoxModel model, Object o) {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Object obj = model.getElementAt(i);
            if (!obj.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addEditModeButtons() {
        JButton bnApplyNamingRules = new JButton(new AbstractAction(Messages.getString("EntityPropertiesDialogEx.NamingRules")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributesNamingStandards dialog = new AttributesNamingStandards(EntityPropertiesDialogEx.this.getAppView(), EntityPropertiesDialogEx.this.entity);
                dialog.getDialog().setVisible(true);
                EntityPropertiesDialogEx.this.itable.updateUI();
            }
        });
        bnApplyNamingRules.setMnemonic(78);
        bnApplyNamingRules.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
        this.pnButtons.add(bnApplyNamingRules);
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator allDesignDomainsDesignIterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            List<PreferredDomain> settingsPreferreddomainsList = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain pd : settingsPreferreddomainsList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) continue;
                this.currentPreferredDomainList.add(obj);
            }
        }
        return this.currentPreferredDomainList;
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator allLogicalDatatypeIterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (allLogicalDatatypeIterator.hasNext()) {
            LogicalDatatype ldt0 = (LogicalDatatype)allLogicalDatatypeIterator.next();
            List<LogicalDatatype> settingsPreferredLogicalDatatypeList = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype ldt1 : settingsPreferredLogicalDatatypeList) {
                if (!ldt0.getObjectID().equalsIgnoreCase(ldt1.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(ldt0);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    protected JPanel getOverlappingPanel() {
        if (this.pnOverlapping == null) {
            DisabledCellRenderer disabledRend = new DisabledCellRenderer();
            this.pnOverlapping = this.createPage(PANEL_OVERLAPPED_ATTRIBUTES);
            OverlappedAttributesModel model = new OverlappedAttributesModel();
            this.attribsJTable = new JTable(model);
            this.attribsJTable.setSelectionMode(0);
            this.attribsJTable.setAutoCreateRowSorter(true);
            TableColumn column = this.attribsJTable.getColumnModel().getColumn(0);
            column.setPreferredWidth(150);
            column.setWidth(150);
            column.setMaxWidth(150);
            column = this.attribsJTable.getColumnModel().getColumn(1);
            column.setPreferredWidth(150);
            column.setWidth(150);
            column.setMaxWidth(150);
            column.setCellRenderer(disabledRend);
            column = this.attribsJTable.getColumnModel().getColumn(2);
            column.setCellRenderer(new OverlappedCellRenderer());
            JScrollPane scrollpane = new JScrollPane(this.attribsJTable);
            this.pnOverlapping.add(scrollpane);
        }
        return this.pnOverlapping;
    }

    private void reFilter() {
        RowFilter rf = null;
        if (this.coTable != null) {
            if (!"".equals(this.filterBox.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.filterBox.getText(), this.coTable.convertColumnIndexToModel(1));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.coTable.getRowSorter()).setRowFilter(rf);
                this.bnCOUp.setEnabled(false);
                this.bnCODown.setEnabled(false);
                this.bnSort.setEnabled(false);
                this.attributesfiltered = true;
            } else {
                ((DefaultRowSorter)this.coTable.getRowSorter()).setRowFilter(null);
                this.coTable.clearSelection();
                this.attributesfiltered = false;
            }
        }
    }

    protected JPanel getClassificationTypesPanel() {
        if (this.pnClassificationTypes == null) {
            this.pnClassificationTypes = this.createPage(CLASSIFICATION_TYPE_TAB_NAME);
            JPanel northPanel = new JPanel(new SpringLayout());
            northPanel.setPreferredSize(new Dimension(100, 30));
            JLabel lbPreferredCT = new JLabel(Messages.getString("EntityPropertiesDialogEx.Preferred"));
            lbPreferredCT.setHorizontalAlignment(0);
            lbPreferredCT.setPreferredSize(new Dimension(lbPreferredCT.getPreferredSize().width + 10, lbPreferredCT.getPreferredSize().height));
            this.chbUsePreferredClassificationTypes = new JCheckBox();
            this.chbUsePreferredClassificationTypes.addItemListener(new UsePreferredClassificationTypesListener());
            CommonUtil.setObjectConstraints((SpringLayout)northPanel.getLayout(), lbPreferredCT, 5, 5);
            CommonUtil.setObjectConstraints((SpringLayout)northPanel.getLayout(), this.chbUsePreferredClassificationTypes, 70, 5);
            northPanel.add(lbPreferredCT);
            northPanel.add(this.chbUsePreferredClassificationTypes);
            JPanel centerPanel = new JPanel(new BorderLayout());
            centerPanel.setPreferredSize(new Dimension(100, 100));
            JPanel baseCTPanel = new JPanel(new GridLayout(2, 1, 10, 10));
            baseCTPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.Base")));
            JLabel lbType = new JLabel(LB_CL_TYPE);
            lbType.setPreferredSize(this.getDefaultSize());
            this.cbBaseClassificationType = new JComboBox();
            this.cbBaseClassificationType.setPreferredSize(this.getDefaultSize());
            this.cbBaseClassificationType.setMaximumRowCount(8);
            this.baseClassificationTypeCBListener = new BaseClassificationTypeCBListener();
            this.cbBaseClassificationType.addActionListener(this.baseClassificationTypeCBListener);
            this.addRowToPanel(baseCTPanel, lbType.getText(), this.cbBaseClassificationType);
            JLabel lbScope = new JLabel(LB_TEMP_TABLE_SCOPE);
            lbScope.setPreferredSize(this.getDefaultSize());
            this.tfScope = new JTextField();
            this.tfScope.setPreferredSize(this.getDefaultSize());
            this.addRowToPanel(baseCTPanel, lbScope.getText(), this.tfScope);
            JPanel additionalCTPanel = new JPanel();
            additionalCTPanel.setLayout(new BoxLayout(additionalCTPanel, 2));
            additionalCTPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.Additional")));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            this.allClassificationTypesModel = new DefaultListModel();
            this.allClassificationTypesList = new JList(this.allClassificationTypesModel);
            this.allClassificationTypesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (EntityPropertiesDialogEx.this.allClassificationTypesList.getSelectedIndex() == -1) {
                        EntityPropertiesDialogEx.this.buttonAddAdditionalClassificationType.setEnabled(false);
                    } else {
                        EntityPropertiesDialogEx.this.buttonAddAdditionalClassificationType.setEnabled(true);
                    }
                }
            });
            this.allClassificationTypesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        EntityPropertiesDialogEx.this.buttonAddAdditionalClassificationType.doClick();
                    }
                }
            });
            JPanel jp1 = new JPanel(new BorderLayout());
            jp1.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.Available")));
            JScrollPane allCTScrollPane = new JScrollPane(this.allClassificationTypesList);
            allCTScrollPane.setPreferredSize(new Dimension(100, 100));
            jp1.add(allCTScrollPane);
            this.buttonAddAdditionalClassificationType = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", 16));
            this.buttonAddAdditionalClassificationType.setToolTipText(Messages.getString("EntityPropertiesDialogEx.SetClassificationType"));
            this.buttonAddAdditionalClassificationType.setPreferredSize(new Dimension(32, 32));
            this.buttonAddAdditionalClassificationType.setEnabled(false);
            this.buttonAddAdditionalClassificationType.addActionListener(new AddClassificationTypeListener());
            this.buttonRemoveAdditionalClassificationType = new JButton(configuration.getIcon("MOVE_LEFT_ICON", 16));
            this.buttonRemoveAdditionalClassificationType.setToolTipText(Messages.getString("EntityPropertiesDialogEx.RemoveClassificationType"));
            this.buttonRemoveAdditionalClassificationType.setPreferredSize(new Dimension(32, 32));
            this.buttonRemoveAdditionalClassificationType.setEnabled(false);
            this.buttonRemoveAdditionalClassificationType.addActionListener(new RemoveClassificationTypeListener());
            Box verticalBox = Box.createVerticalBox();
            verticalBox.add(Box.createVerticalGlue());
            verticalBox.add(this.buttonAddAdditionalClassificationType);
            verticalBox.add(this.buttonRemoveAdditionalClassificationType);
            verticalBox.add(Box.createVerticalGlue());
            this.selectedClassificationTypesModel = new DefaultListModel();
            this.selectedClassificationTypesList = new JList(this.selectedClassificationTypesModel);
            this.selectedClassificationTypesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (EntityPropertiesDialogEx.this.selectedClassificationTypesList.getSelectedIndex() == -1) {
                        EntityPropertiesDialogEx.this.buttonRemoveAdditionalClassificationType.setEnabled(false);
                    } else {
                        EntityPropertiesDialogEx.this.buttonRemoveAdditionalClassificationType.setEnabled(true);
                    }
                }
            });
            this.selectedClassificationTypesList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        EntityPropertiesDialogEx.this.buttonRemoveAdditionalClassificationType.doClick();
                    }
                }
            });
            JPanel jp2 = new JPanel(new BorderLayout());
            jp2.setBorder(BorderFactory.createTitledBorder(Messages.getString("EntityPropertiesDialogEx.Selected")));
            JScrollPane selectedCTScrollPane = new JScrollPane(this.selectedClassificationTypesList);
            selectedCTScrollPane.setPreferredSize(new Dimension(100, 100));
            jp2.add(selectedCTScrollPane);
            additionalCTPanel.add(jp1);
            additionalCTPanel.add(verticalBox);
            additionalCTPanel.add(jp2);
            centerPanel.add((Component)baseCTPanel, "North");
            centerPanel.add((Component)additionalCTPanel, "Center");
            JPanel jp = new JPanel(new BorderLayout());
            jp.setPreferredSize(new Dimension(100, 100));
            jp.add((Component)northPanel, "North");
            jp.add((Component)centerPanel, "Center");
            this.pnClassificationTypes.add(jp);
        }
        return this.pnClassificationTypes;
    }

    private void sortClassificationTypes(DefaultListModel model) {
        ArrayList col = new ArrayList();
        Enumeration e = model.elements();
        while (e.hasMoreElements()) {
            col.add(e.nextElement());
        }
        Collections.sort(col, this.toStringComparator);
        model.clear();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
    }

    private void reloadClassificationTypes(boolean onInit) {
        try {
            Iterator it;
            Object selectedCType = null;
            if (onInit) {
                String typeID = this.entity.getTypeID();
                if (typeID != null && !typeID.equals("")) {
                    selectedCType = this.dlSettings.getClassificationTypeByID(typeID);
                }
            } else {
                selectedCType = this.cbBaseClassificationType.getSelectedItem();
            }
            this.cbBaseClassificationType.removeActionListener(this.baseClassificationTypeCBListener);
            this.cbBaseClassificationType.removeAllItems();
            this.cbBaseClassificationType.addItem("");
            ArrayList<Object> ctList = new ArrayList<Object>();
            if (this.chbUsePreferredClassificationTypes.isSelected()) {
                it = this.dlSettings.getPreferredClassificationTypes().iterator();
                while (it.hasNext()) {
                    ctList.add(it.next());
                }
                if (selectedCType != null && selectedCType instanceof ClassificationType && !ctList.contains(selectedCType)) {
                    ctList.add(selectedCType);
                }
            } else {
                it = this.dlSettings.getClassificationTypeList().iterator();
                while (it.hasNext()) {
                    ctList.add(it.next());
                }
                if (selectedCType != null && selectedCType instanceof ClassificationType && !ctList.contains(selectedCType)) {
                    ctList.add(selectedCType);
                }
            }
            Collections.sort(ctList, new ClassificationTypesComparator());
            Iterator ctIt = ctList.iterator();
            while (ctIt.hasNext()) {
                this.cbBaseClassificationType.addItem(ctIt.next());
            }
            this.cbBaseClassificationType.addActionListener(this.baseClassificationTypeCBListener);
            this.cbBaseClassificationType.setSelectedItem("");
            if (selectedCType != null && selectedCType instanceof ClassificationType) {
                int n = this.cbBaseClassificationType.getItemCount();
                for (int i = 0; i < n; ++i) {
                    Object obj = this.cbBaseClassificationType.getItemAt(i);
                    if (!(obj instanceof ClassificationType)) continue;
                    ClassificationType ct = (ClassificationType)this.cbBaseClassificationType.getItemAt(i);
                    if (!((ClassificationType)selectedCType).getTypeID().equals(ct.getTypeID())) continue;
                    this.cbBaseClassificationType.setSelectedItem(ct);
                    break;
                }
            }
            this.populateAdditionalClassificationTypesLists();
        }
        catch (Exception e) {
            LOGGER.error("EntityPropertiesDialogEx.reloadClassificationTypes()", e);
        }
    }

    private void populateAdditionalClassificationTypesLists() {
        this.allClassificationTypesModel.removeAllElements();
        this.selectedClassificationTypesModel.removeAllElements();
        ClassificationType baseCT = null;
        Object obj = this.cbBaseClassificationType.getSelectedItem();
        if (obj instanceof ClassificationType) {
            baseCT = (ClassificationType)this.cbBaseClassificationType.getSelectedItem();
        }
        ArrayList<ClassificationType> additionalCTList = new ArrayList<ClassificationType>();
        for (String typeId : this.entity.getAdditionalClassificationTypes()) {
            ClassificationType ct = this.dlSettings.getClassificationTypeByID(typeId);
            if (ct == null) continue;
            additionalCTList.add(ct);
        }
        if (this.chbUsePreferredClassificationTypes.isSelected()) {
            block1: for (ClassificationType ct : this.dlSettings.getClassificationTypeList()) {
                if (baseCT != null && baseCT.getTypeID().equals(ct.getTypeID())) continue;
                boolean found = false;
                for (ClassificationType ct1 : additionalCTList) {
                    if (!ct.getTypeID().equals(ct1.getTypeID())) continue;
                    found = true;
                    this.selectedClassificationTypesModel.addElement(ct);
                    break;
                }
                if (found) continue;
                for (ClassificationType ct2 : this.dlSettings.getPreferredClassificationTypes()) {
                    if (!ct.getTypeID().equals(ct2.getTypeID())) continue;
                    this.allClassificationTypesModel.addElement(ct);
                    continue block1;
                }
            }
        } else {
            for (ClassificationType ct : this.dlSettings.getClassificationTypeList()) {
                if (baseCT != null && baseCT.getTypeID().equals(ct.getTypeID())) continue;
                boolean found = false;
                for (ClassificationType ct1 : additionalCTList) {
                    if (!ct.getTypeID().equals(ct1.getTypeID())) continue;
                    found = true;
                    this.selectedClassificationTypesModel.addElement(ct);
                    break;
                }
                if (found) continue;
                this.allClassificationTypesModel.addElement(ct);
            }
        }
        this.sortClassificationTypes(this.allClassificationTypesModel);
        this.sortClassificationTypes(this.selectedClassificationTypesModel);
    }

    private JPanel createAttributesUDPPanel() {
        if (this.pnAttributesUDP == null) {
            this.pnAttributesUDP = new JPanel(new BorderLayout());
            this.attributesUserDefinedPropertiesMap = new LinkedHashMap();
            this.headerNames = new ArrayList();
            this.attrNames = new ArrayList();
            this.tbAttributesUDPFixed = new JTable(new AttributesUDPFixedDataModel(this.attrNames));
            this.tbAttributesUDPFixed.setSelectionMode(0);
            this.tbAttributesUDPFixed.getTableHeader().setReorderingAllowed(false);
            this.tbAttributesUDPFixed.setSelectionMode(0);
            this.tbAttributesUDPFixed.setAutoResizeMode(0);
            this.tbAttributesUDPFixed.setEnabled(this.isEditable());
            this.tbAttributesUDPFixed.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                }

                @Override
                public void focusGained(FocusEvent e) {
                    EntityPropertiesDialogEx.stopCellEditing(EntityPropertiesDialogEx.this.tbAttributesUDP);
                }
            });
            TableColumn column = this.tbAttributesUDPFixed.getColumnModel().getColumn(0);
            column.setPreferredWidth(30);
            column.setMaxWidth(50);
            column.setMinWidth(25);
            DefaultTableCellRenderer rightRenderer = new DefaultTableCellRenderer();
            rightRenderer.setHorizontalAlignment(4);
            column.setCellRenderer(rightRenderer);
            column = this.tbAttributesUDPFixed.getColumnModel().getColumn(1);
            column.setPreferredWidth(200);
            column.setMaxWidth(200);
            column.setMinWidth(200);
            this.tbAttributesUDP = new JTable();
            this.tbAttributesUDP.setSelectionMode(0);
            this.tbAttributesUDP.getTableHeader().setReorderingAllowed(false);
            this.tbAttributesUDP.setSelectionMode(0);
            this.tbAttributesUDP.setAutoResizeMode(0);
            this.tbAttributesUDP.setEnabled(this.isEditable());
            ListSelectionModel model = this.tbAttributesUDPFixed.getSelectionModel();
            this.tbAttributesUDP.setSelectionModel(model);
            JScrollPane scrollPane = new JScrollPane(this.tbAttributesUDP);
            Dimension fixedSize = this.tbAttributesUDPFixed.getPreferredSize();
            JViewport viewport = new JViewport();
            viewport.setView(this.tbAttributesUDPFixed);
            viewport.setPreferredSize(fixedSize);
            viewport.setMaximumSize(fixedSize);
            scrollPane.setCorner("UPPER_LEFT_CORNER", this.tbAttributesUDPFixed.getTableHeader());
            scrollPane.setRowHeaderView(viewport);
            JPanel jpGroups = new JPanel(new SpringLayout());
            jpGroups.setPreferredSize(new Dimension(100, 25));
            JLabel lbGroup = new JLabel(Messages.getString("EntityPropertiesDialogEx.Group"));
            lbGroup.setPreferredSize(new Dimension(70, 20));
            CommonUtil.setObjectConstraints((SpringLayout)jpGroups.getLayout(), lbGroup, 5, 0);
            DefaultComboBoxModel<Object> cmbGroupModel = new DefaultComboBoxModel<Object>();
            this.cmbAttributesUDPGroup = new JComboBox(cmbGroupModel);
            this.cmbAttributesUDPGroup.setPreferredSize(new Dimension(100, 20));
            CommonUtil.setObjectConstraints((SpringLayout)jpGroups.getLayout(), this.cmbAttributesUDPGroup, 80, 0);
            cmbGroupModel.addElement(INTERVAL_STRING);
            for (UDPLibrary library : this.getAppView().getCurrentDesign().getUserDefinedLibraries()) {
                for (UserDefinedPropertyGroup group : library.getUDPGroups()) {
                    cmbGroupModel.addElement(group);
                }
            }
            this.cmbAttributesUDPGroup.setRenderer(new UDPGroupRenderer());
            this.cmbAttributesUDPGroup.addItemListener(new CmbAttributesUDPGroupListener());
            jpGroups.add(lbGroup);
            jpGroups.add(this.cmbAttributesUDPGroup);
            this.pnAttributesUDP.add((Component)jpGroups, "North");
            this.pnAttributesUDP.add((Component)scrollPane, "Center");
        }
        return this.pnAttributesUDP;
    }

    private void initAttributesUDP(UserDefinedPropertyGroup group) {
        try {
            Map.Entry pairs;
            Iterator it1;
            this.attributesUserDefinedPropertiesMap.clear();
            this.headerNames.clear();
            this.attrNames.clear();
            for (Attribute a : this.attributesList) {
                this.attrNames.add(a.getName());
                ArrayList<AbstractPropertiesDialog.UDProperty> udProperties = new ArrayList<AbstractPropertiesDialog.UDProperty>();
                for (UserDefinedProperty p : this.getDesignObject().getDesign().getUserDefinedProperties()) {
                    String value;
                    String propName;
                    Iterator itV;
                    AbstractPropertiesDialog.UDProperty ud;
                    Boolean visible;
                    Class clz;
                    if (group == null) {
                        for (Map.Entry<Class, Boolean> pairs2 : p.getObjectsVisibilityMap().entrySet()) {
                            clz = pairs2.getKey();
                            visible = pairs2.getValue();
                            if (Attribute.class != clz) continue;
                            ud = new AbstractPropertiesDialog.UDProperty();
                            ud.setUserDefinedProperty(p);
                            itV = a.getPropertyNames();
                            while (itV.hasNext()) {
                                propName = (String)itV.next();
                                if (!propName.equals(p.getName())) continue;
                                value = a.getProperty(propName);
                                ud.setValue(value);
                                break;
                            }
                            udProperties.add(ud);
                        }
                        this.attributesUserDefinedPropertiesMap.put(a, udProperties);
                        continue;
                    }
                    if (p.getGroup() == null || !group.getId().equals(p.getGroup().getId())) continue;
                    for (Map.Entry<Class, Boolean> pairs2 : p.getObjectsVisibilityMap().entrySet()) {
                        clz = pairs2.getKey();
                        visible = pairs2.getValue();
                        if (Attribute.class != clz) continue;
                        ud = new AbstractPropertiesDialog.UDProperty();
                        ud.setUserDefinedProperty(p);
                        itV = a.getPropertyNames();
                        while (itV.hasNext()) {
                            propName = (String)itV.next();
                            if (!propName.equals(p.getName())) continue;
                            value = a.getProperty(propName);
                            ud.setValue(value);
                            break;
                        }
                        udProperties.add(ud);
                    }
                    this.attributesUserDefinedPropertiesMap.put(a, udProperties);
                }
            }
            if (this.attributesUserDefinedPropertiesMap.size() > 0 && (it1 = this.attributesUserDefinedPropertiesMap.entrySet().iterator()).hasNext()) {
                pairs = it1.next();
                for (AbstractPropertiesDialog.UDProperty ud : (List)pairs.getValue()) {
                    this.headerNames.add(ud.getUserDefinedProperty().getName());
                }
            }
            this.tbAttributesUDP.setModel(new AttributesUDPDataModel(this.headerNames, this.attrNames));
            Iterator it = this.attributesUserDefinedPropertiesMap.entrySet().iterator();
            if (it.hasNext()) {
                pairs = it.next();
                List l = (List)pairs.getValue();
                int i = 0;
                Iterator itL = l.iterator();
                while (itL.hasNext()) {
                    itL.next();
                    TableColumn col = this.tbAttributesUDP.getColumnModel().getColumn(i);
                    col.setCellEditor(new AbstractPropertiesDialog.UDPPropertyValueCellEditor(l, true));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("EntityPropertiesDialogEx.initColumnsUDP()", e);
        }
    }

    private void initTablesSorters() {
        TableRowSorter<TableModel> sorter;
        if (this.relationsList.size() > 0) {
            sorter = new TableRowSorter<TableModel>(this.relationsModel);
            sorter.setSortsOnUpdates(true);
            this.tbRelations.setRowSorter(sorter);
            this.tbRelations.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.tbRelations, 0);
        }
        if (this.eList.size() > 0) {
            sorter = new TableRowSorter<LogicalObjectPropertiesDialog.ETModel>(this.etModel);
            sorter.setSortsOnUpdates(true);
            this.eTable.setRowSorter(sorter);
            this.eTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.eTable, 0);
        }
    }

    private void initKeysSorter() {
        if (this.keysList.size() > 0) {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.indexModel);
            sorter.setSortsOnUpdates(true);
            this.itable.setRowSorter(sorter);
            this.itable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.itable, 0);
        }
    }

    @Override
    public void update(DesignObject object) {
        if (object instanceof Attribute) {
            Attribute attr;
            Attribute attribute = (Attribute)object;
            int row = this.coTable.getSelectedRow();
            if (row != -1 && this.attributesList.size() > 0 && row < this.attributesList.size() && (attr = this.attributesList.get(this.coTable.convertRowIndexToModel(row))).equals(attribute)) {
                this.initSelectedAttributeOptions(attribute, false);
            }
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return EntityPropertiesDialogEx.INTERVAL_STRING;
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (column == 2) {
                return Messages.getString("EntityPropertiesDialogEx.DataType");
            }
            if (column == 3) {
                return Messages.getString("EntityPropertiesDialogEx.PKColName");
            }
            if (column == 4) {
                return Messages.getString("EntityPropertiesDialogEx.FKColName");
            }
            if (column == 5) {
                return "M";
            }
            if (column == 6) {
                return "D";
            }
            if (column == 7) {
                return Messages.getString("EntityPropertiesDialogEx.Comments");
            }
            if (column == 8) {
                return Messages.getString("EntityPropertiesDialogEx.CommentsInRDBMS");
            }
            if (column == 9) {
                return Messages.getString("EntityPropertiesDialogEx.Notes");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 4) {
                return false;
            }
            Attribute attribute = EntityPropertiesDialogEx.this.attributesList.get(rowIndex);
            if (attribute.isFKElement() && columnIndex == 5) {
                return false;
            }
            Entity entity = (Entity)attribute.getContainerWithKeyObject();
            if (columnIndex == 5 && entity.getPK() != null && entity.getPK().contains(attribute)) {
                return false;
            }
            if (columnIndex == 1 || columnIndex == 2 || columnIndex == 3 || columnIndex == 5 || columnIndex == 6) {
                return true;
            }
            return super.isCellEditable(rowIndex, columnIndex);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute attribute = EntityPropertiesDialogEx.this.attributesList.get(EntityPropertiesDialogEx.this.coTable.convertRowIndexToModel(row));
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return attribute.getName();
            }
            if (col == 2) {
                return attribute;
            }
            if (col == 3) {
                CandidateKey ind = EntityPropertiesDialogEx.this.getPK();
                if (ind != null) {
                    return ind.contains(attribute);
                }
                return Boolean.FALSE;
            }
            if (col == 4) {
                return attribute.isFKElement();
            }
            if (col == 5) {
                return !attribute.getNullsAllowed();
            }
            if (col == 6) {
                return attribute.isDeprecated();
            }
            if (col == 7) {
                return attribute.getComment();
            }
            if (col == 8) {
                return attribute.getCommentInRDBMS();
            }
            if (col == 9) {
                return attribute.getNotes();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            Attribute attribute = EntityPropertiesDialogEx.this.attributesList.get(EntityPropertiesDialogEx.this.coTable.convertRowIndexToModel(row));
            if (col == 7) {
                attribute.setComment((String)aValue);
                EntityPropertiesDialogEx.this.updateAttributeProps(attribute);
            } else if (col == 8) {
                attribute.setCommentInRDBMS((String)aValue);
                EntityPropertiesDialogEx.this.updateAttributeProps(attribute);
            } else if (col == 9) {
                attribute.setNotes((String)aValue);
                EntityPropertiesDialogEx.this.updateAttributeProps(attribute);
            } else if (col == 1) {
                attribute.setName((String)aValue);
                EntityPropertiesDialogEx.this.updateAttributeProps(attribute);
            } else if (col == 6) {
                attribute.setDeprecated((Boolean)aValue);
                EntityPropertiesDialogEx.this.updateAttributeProps(attribute);
            } else if (col == 3) {
                EntityPropertiesDialogEx.this.updateAttributePK(attribute, (Boolean)aValue);
            } else if (col == 5) {
                attribute.setMandatory((Boolean)aValue);
                EntityPropertiesDialogEx.this.updateAttributeMandatory(attribute, (Boolean)aValue);
            }
        }
    }

    class AttributeTable
    extends JTable {
        AttributeTable(TableModel dataModel) {
            super(dataModel);
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            String tip = null;
            Point p = e.getPoint();
            int rowIndex = this.rowAtPoint(p);
            int colIndex = this.columnAtPoint(p);
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            Attribute attribute = EntityPropertiesDialogEx.this.attributesList.get(this.convertRowIndexToModel(rowIndex));
            if (realColumnIndex == 3) {
                TableModel model = this.getModel();
                boolean checked = (Boolean)model.getValueAt(rowIndex, 3);
                if (!checked) {
                    tip = MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.Attribute"), attribute.getName());
                } else {
                    CandidateKey ind = EntityPropertiesDialogEx.this.getPK();
                    Object ss = "";
                    if (ind != null) {
                        ss = "<html><body>" + MessageFormat.format(Messages.getString("EntityPropertiesDialogEx.PrimaryKey"), ind.getName()) + "<p>" + Messages.getString("EntityPropertiesDialogEx.PrimaryKeyAttr");
                        for (Attribute attr : ind.getElementsCollection()) {
                            ss = (String)ss + "<p>  " + attr.getName();
                        }
                        ss = (String)ss + "</body></html>";
                    }
                    tip = ss;
                }
            } else if (realColumnIndex != 4) {
                tip = realColumnIndex == 7 ? EntityPropertiesDialogEx.this.getTooltip(attribute.getComment()) : (realColumnIndex == 8 ? EntityPropertiesDialogEx.this.getTooltip(attribute.getCommentInRDBMS()) : (realColumnIndex == 9 ? EntityPropertiesDialogEx.this.getTooltip(attribute.getNotes()) : super.getToolTipText(e)));
            }
            return tip;
        }
    }

    class DataTypeCellRenderer
    extends JLabel
    implements TableCellRenderer {
        DataTypeCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Attribute attribute = (Attribute)value;
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(attribute.getGenericDatatypeString());
            return this;
        }
    }

    class StatusCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        boolean enabled = true;

        StatusCellRenderer() {
        }

        StatusCellRenderer(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(0);
            this.setEnabled(this.enabled);
            this.setSelected((Boolean)value);
            return this;
        }
    }

    public class AttributeModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return EntityPropertiesDialogEx.INTERVAL_STRING;
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (column == 2) {
                return Messages.getString("EntityPropertiesDialogEx.DataType");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Integer.class;
            }
            if (col == 1) {
                return String.class;
            }
            if (col == 2) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute column = EntityPropertiesDialogEx.this.attributesList.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return column.getName();
            }
            if (col == 2) {
                return column.getGenericDatatypeString();
            }
            return new Integer(row * col);
        }
    }

    private class COPropertiesAction
    implements ActionListener {
        private COPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = EntityPropertiesDialogEx.this.coTable.getSelectedRow();
            if (row != -1) {
                Attribute col;
                EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
                if (EntityPropertiesDialogEx.this.attributesList.size() > 0 && row < EntityPropertiesDialogEx.this.attributesList.size() && !(col = EntityPropertiesDialogEx.this.attributesList.get(EntityPropertiesDialogEx.this.coTable.convertRowIndexToModel(row))).isDialogVisible()) {
                    col.showModal = true;
                    AttributePropertiesDialogEx dialog = new AttributePropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), col, EntityPropertiesDialogEx.this.chbUsePreferredList.isSelected());
                    dialog.initProperties(col);
                    dialog.show();
                    if (EntityPropertiesDialogEx.this.selectedAttribute != null) {
                        EntityPropertiesDialogEx.this.initSelectedAttributeOptions(EntityPropertiesDialogEx.this.selectedAttribute, false);
                    }
                }
            }
        }
    }

    private class COAddAction
    implements ActionListener {
        private COAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityPropertiesDialogEx.this.addAttribute(e);
            EntityPropertiesDialogEx.this.updateModels();
        }
    }

    private class CORemoveAction
    implements ActionListener {
        private CORemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityPropertiesDialogEx.this.deleteAttribute(EntityPropertiesDialogEx.this.coTable);
            EntityPropertiesDialogEx.this.updateModels();
        }
    }

    private class COCopyAction
    extends AbstractAction {
        private COCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityPropertiesDialogEx.this.coTableIsSingleRowSelected) {
                EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
            }
            EntityPropertiesDialogEx.this.coCopyAttributes();
        }
    }

    private class COPasteAction
    extends AbstractAction {
        private COPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityPropertiesDialogEx.this.coPasteAttributes();
            if (EntityPropertiesDialogEx.this.coTableIsSingleRowSelected) {
                EntityPropertiesDialogEx.this.setAttributeSelected();
            }
        }
    }

    private class FilterItemsListener
    implements DocumentListener {
        private FilterItemsListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            EntityPropertiesDialogEx.this.reFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            EntityPropertiesDialogEx.this.reFilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            EntityPropertiesDialogEx.this.reFilter();
        }
    }

    private class RBActionListener
    implements ActionListener {
        private RBActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityPropertiesDialogEx.this.saveCurrentSelectedOldDatatype();
            EntityPropertiesDialogEx.this.updateDTComboBox();
            boolean loadDTInfo = EntityPropertiesDialogEx.this.loadCurrentSelectedNewDatatype();
            if (!loadDTInfo) {
                EntityPropertiesDialogEx.this.setSelectedDefaultDatatype();
            }
            EntityPropertiesDialogEx.this.cbDatatype.updateUI();
            EntityPropertiesDialogEx.this.saveCurrentSelectedNewDatatype();
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityPropertiesDialogEx.this.rbDomain.isSelected() || EntityPropertiesDialogEx.this.rbLogical.isSelected()) {
                EntityPropertiesDialogEx.this.setPreviousSelectedAttribute();
                EntityPropertiesDialogEx.this.updateDTComboBox();
            }
        }
    }

    public class RelationsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.relationsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.OtherEntity");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Relation relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(row);
            if (col == 0) {
                return relation.getName();
            }
            if (col == 1) {
                return relation.getSourceEntity().getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            String name;
            Relation relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(row);
            if (col == 0 && !"".equals(name = (String)aValue)) {
                relation.setName(name);
            }
        }
    }

    class RelationTable
    extends JTable {
        RelationTable(TableModel relModel) {
            super(relModel);
        }
    }

    private class RelationPropertiesAction
    implements ActionListener {
        private RelationPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = EntityPropertiesDialogEx.this.tbRelations.convertRowIndexToModel(EntityPropertiesDialogEx.this.tbRelations.getSelectedRow());
            if (row != -1 && EntityPropertiesDialogEx.this.relationsList.size() > 0 && row < EntityPropertiesDialogEx.this.relationsList.size()) {
                Relation relation;
                int icol = EntityPropertiesDialogEx.this.tbRelations.getEditingColumn();
                int irow = EntityPropertiesDialogEx.this.tbRelations.getEditingRow();
                if (icol > -1 && irow > -1) {
                    EntityPropertiesDialogEx.this.tbRelations.getCellEditor(irow, icol).stopCellEditing();
                }
                if (!(relation = (Relation)EntityPropertiesDialogEx.this.relationsList.get(row)).isDialogVisible()) {
                    relation.showModal = EntityPropertiesDialogEx.this.entity.showModal;
                    relation.showPropertyDialog();
                }
            }
        }
    }

    public class KeyModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.keysList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.PUID");
            }
            if (column == 2) {
                return Messages.getString("EntityPropertiesDialogEx.Deprecated");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            CandidateKey key = (CandidateKey)EntityPropertiesDialogEx.this.keysList.get(row);
            if (col == 0) {
                return key.getName();
            }
            if (col == 1) {
                return key.isPK();
            }
            if (col == 2) {
                return key.isDeprecated();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            CandidateKey key = (CandidateKey)EntityPropertiesDialogEx.this.keysList.get(rowIndex);
            if (columnIndex == 2) {
                key.setDeprecated((Boolean)aValue);
            }
        }
    }

    private class KeyPropertiesAction
    implements ActionListener {
        private KeyPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CandidateKey key;
            int row = EntityPropertiesDialogEx.this.itable.convertRowIndexToModel(EntityPropertiesDialogEx.this.itable.getSelectedRow());
            if (row != -1 && EntityPropertiesDialogEx.this.keysList.size() > 0 && row < EntityPropertiesDialogEx.this.keysList.size() && !(key = (CandidateKey)EntityPropertiesDialogEx.this.keysList.get(row)).isDialogVisible()) {
                key.showModal = true;
                KeyPropertiesDialogEx dialog = new KeyPropertiesDialogEx((Dialog)EntityPropertiesDialogEx.this, EntityPropertiesDialogEx.this.getAppView(), key);
                List nestedElements = EntityPropertiesDialogEx.this.entity.getNestedElements();
                if (nestedElements.size() > 0) {
                    ArrayList<Attribute> expandedList = new ArrayList<Attribute>(EntityPropertiesDialogEx.this.attributesList);
                    expandedList.addAll(nestedElements);
                    dialog.setAttributesList(expandedList);
                    key.setTempObjects(expandedList);
                } else {
                    dialog.setAttributesList(EntityPropertiesDialogEx.this.attributesList);
                    key.setTempObjects(EntityPropertiesDialogEx.this.attributesList);
                }
                dialog.initProperties(key);
                dialog.show();
                key.setTempObjects(null);
                EntityPropertiesDialogEx.this.itable.updateUI();
            }
        }
    }

    private class AddKeyAction
    implements ActionListener {
        private AddKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityPropertiesDialogEx.this.createAndAddKey(false);
            int lastRow = EntityPropertiesDialogEx.this.itable.convertRowIndexToView(EntityPropertiesDialogEx.this.itable.getModel().getRowCount() - 1);
            EntityPropertiesDialogEx.this.itable.setRowSelectionInterval(lastRow, lastRow);
        }
    }

    private class RemoveKeyAction
    implements ActionListener {
        private RemoveKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityPropertiesDialogEx.this.deleteKey();
        }
    }

    class DisabledCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        DisabledCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean val = (Boolean)value;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setSelected(val);
            this.setEnabled(false);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }

    public class OverlappedAttributesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (EntityPropertiesDialogEx.this.currentEntHolder != null) {
                return EntityPropertiesDialogEx.this.currentEntHolder.attrHolders.size();
            }
            return 0;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("EntityPropertiesDialogEx.Fold");
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Folded");
            }
            if (column == 2) {
                return Messages.getString("EntityPropertiesDialogEx.AttributesPair");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 && EntityPropertiesDialogEx.this.currentEntHolder != null) {
                LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EntityPropertiesDialogEx.this.currentEntHolder.attrHolders.get(rowIndex);
                return !holder.readOnly;
            }
            return false;
        }

        public Class getColumnClass(int c) {
            if (c == 0 || c == 1) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EntityPropertiesDialogEx.this.currentEntHolder.attrHolders.get(row);
            if (col == 0) {
                return holder.overlap;
            }
            if (col == 1) {
                return holder.inpk;
            }
            if (col == 2) {
                return holder.toString();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EntityPropertiesDialogEx.this.currentEntHolder.attrHolders.get(row);
            if (col == 0) {
                boolean overlap;
                holder.overlap = overlap = ((Boolean)aValue).booleanValue();
                this.setRelatedReadOnly(holder, overlap);
                holder.readOnly = false;
                this.fireTableDataChanged();
            }
        }

        private void setRelatedReadOnly(LogicalDesign.AttrHolder holder, boolean overlap) {
            for (LogicalDesign.AttrHolder attrHolder : holder.relatedHolders) {
                attrHolder.readOnly = overlap;
            }
        }
    }

    class OverlappedCellRenderer
    extends JLabel
    implements TableCellRenderer {
        OverlappedCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (table.getModel() instanceof OverlappedAttributesModel && EntityPropertiesDialogEx.this.currentEntHolder != null) {
                LogicalDesign.AttrHolder holder = (LogicalDesign.AttrHolder)EntityPropertiesDialogEx.this.currentEntHolder.attrHolders.get(row);
                this.setOpaque(true);
                String text = (String)value;
                this.setText(text);
                if (holder.relatedHolders.size() > 1) {
                    this.setForeground(Color.RED);
                } else {
                    this.setForeground(table.getForeground());
                }
                if (isSelected) {
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setBackground(table.getBackground());
                }
            }
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    private class UsePreferredClassificationTypesListener
    implements ItemListener {
        private UsePreferredClassificationTypesListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                EntityPropertiesDialogEx.this.dlSettings.setUsePreferredClassificationTypes(true);
                EntityPropertiesDialogEx.this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("EntityPropertiesDialogEx.UseAllClassificationTypes"));
            } else if (e.getStateChange() == 2) {
                EntityPropertiesDialogEx.this.dlSettings.setUsePreferredClassificationTypes(false);
                EntityPropertiesDialogEx.this.chbUsePreferredClassificationTypes.setToolTipText(Messages.getString("EntityPropertiesDialogEx.UsePreferredClassificationTypes"));
            }
            EntityPropertiesDialogEx.this.reloadClassificationTypes(false);
        }
    }

    private class BaseClassificationTypeCBListener
    implements ActionListener {
        private BaseClassificationTypeCBListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntityPropertiesDialogEx.this.cbBaseClassificationType.getSelectedItem() != null) {
                String typeTemporaryName = EntityPropertiesDialogEx.this.dlSettings.getClassificationTypeNameByID("5");
                Object obj = EntityPropertiesDialogEx.this.cbBaseClassificationType.getSelectedItem();
                if (obj != null && obj instanceof ClassificationType) {
                    ClassificationType ct = (ClassificationType)obj;
                    if (ct.getTypeName().equals(typeTemporaryName)) {
                        EntityPropertiesDialogEx.this.tfScope.setEnabled(true);
                    } else {
                        EntityPropertiesDialogEx.this.tfScope.setEnabled(false);
                        EntityPropertiesDialogEx.this.tfScope.setText("");
                    }
                } else {
                    EntityPropertiesDialogEx.this.tfScope.setEnabled(false);
                    EntityPropertiesDialogEx.this.tfScope.setText("");
                }
                EntityPropertiesDialogEx.this.populateAdditionalClassificationTypesLists();
            }
        }
    }

    private class AddClassificationTypeListener
    implements ActionListener {
        private AddClassificationTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<ClassificationType> listToRemove = new ArrayList<ClassificationType>();
            for (ClassificationType classificationType : Arrays.asList(EntityPropertiesDialogEx.this.allClassificationTypesList.getSelectedValues())) {
                boolean found = false;
                for (ClassificationType classificationType2 : Arrays.asList(EntityPropertiesDialogEx.this.selectedClassificationTypesList.getSelectedValues())) {
                    if (!classificationType.getTypeID().equals(classificationType2.getTypeID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                EntityPropertiesDialogEx.this.selectedClassificationTypesModel.addElement(classificationType);
                listToRemove.add(classificationType);
                EntityPropertiesDialogEx.this.tempClassificationTypes.add(classificationType);
            }
            Iterator iterator = listToRemove.iterator();
            while (iterator.hasNext()) {
                EntityPropertiesDialogEx.this.allClassificationTypesModel.removeElement(iterator.next());
            }
            EntityPropertiesDialogEx.this.sortClassificationTypes(EntityPropertiesDialogEx.this.selectedClassificationTypesModel);
        }
    }

    private class RemoveClassificationTypeListener
    implements ActionListener {
        private RemoveClassificationTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<ClassificationType> listToRemove = new ArrayList<ClassificationType>();
            for (ClassificationType classificationType : Arrays.asList(EntityPropertiesDialogEx.this.selectedClassificationTypesList.getSelectedValues())) {
                boolean found = false;
                for (ClassificationType classificationType2 : Arrays.asList(EntityPropertiesDialogEx.this.allClassificationTypesList.getSelectedValues())) {
                    if (!classificationType.getTypeID().equals(classificationType2.getTypeID())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                EntityPropertiesDialogEx.this.allClassificationTypesModel.addElement(classificationType);
                listToRemove.add(classificationType);
                EntityPropertiesDialogEx.this.tempClassificationTypes.remove(classificationType);
            }
            Iterator iterator = listToRemove.iterator();
            while (iterator.hasNext()) {
                EntityPropertiesDialogEx.this.selectedClassificationTypesModel.removeElement(iterator.next());
            }
            EntityPropertiesDialogEx.this.sortClassificationTypes(EntityPropertiesDialogEx.this.allClassificationTypesModel);
        }
    }

    class ClassificationTypesComparator
    implements Comparator {
        ClassificationTypesComparator() {
        }

        public int compare(Object o1, Object o2) {
            ClassificationType ct1 = (ClassificationType)o1;
            ClassificationType ct2 = (ClassificationType)o2;
            return ct1.getTypeName().compareTo(ct2.getTypeName());
        }
    }

    public class AttributesUDPFixedDataModel
    extends AbstractColumnModel {
        List columnNames;

        public AttributesUDPFixedDataModel(List colNames) {
            this.columnNames = new ArrayList();
            this.columnNames = colNames;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.attributesList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return EntityPropertiesDialogEx.INTERVAL_STRING;
            }
            if (column == 1) {
                return Messages.getString("EntityPropertiesDialogEx.Name");
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 0) {
                return new Integer(row + 1);
            }
            if (column == 1) {
                ContainedObject co = EntityPropertiesDialogEx.this.attributesList.get(row);
                return co.getName();
            }
            return "";
        }
    }

    class UDPGroupRenderer
    extends JLabel
    implements ListCellRenderer {
        UDPGroupRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setOpaque(true);
            if (value instanceof UserDefinedPropertyGroup) {
                this.setText(((UserDefinedPropertyGroup)value).getName());
            } else {
                this.setText(EntityPropertiesDialogEx.INTERVAL_STRING);
            }
            return this;
        }
    }

    private class CmbAttributesUDPGroupListener
    implements ItemListener {
        private CmbAttributesUDPGroupListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (EntityPropertiesDialogEx.this.cmbAttributesUDPGroup.getSelectedItem().equals(EntityPropertiesDialogEx.INTERVAL_STRING)) {
                    EntityPropertiesDialogEx.this.initAttributesUDP(null);
                } else {
                    UserDefinedPropertyGroup group = (UserDefinedPropertyGroup)EntityPropertiesDialogEx.this.cmbAttributesUDPGroup.getSelectedItem();
                    EntityPropertiesDialogEx.this.initAttributesUDP(group);
                }
                EntityPropertiesDialogEx.this.tbAttributesUDP.updateUI();
            }
        }
    }

    public class AttributesUDPDataModel
    extends AbstractTableModel {
        List headerNames = new ArrayList();
        List columnNames = new ArrayList();

        public AttributesUDPDataModel(List headerNames, List colNames) {
            this.headerNames = headerNames;
            this.columnNames = colNames;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.attributesUserDefinedPropertiesMap.size();
        }

        @Override
        public int getColumnCount() {
            return this.headerNames.size();
        }

        @Override
        public String getColumnName(int column) {
            return (String)this.headerNames.get(column);
        }

        @Override
        public Object getValueAt(int row, int column) {
            Attribute attribute = EntityPropertiesDialogEx.this.attributesList.get(row);
            List l = (List)EntityPropertiesDialogEx.this.attributesUserDefinedPropertiesMap.get(attribute);
            AbstractPropertiesDialog.UDProperty udp = (AbstractPropertiesDialog.UDProperty)l.get(column);
            return udp.getValue() != null ? udp.getValue() : "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Attribute attribute = EntityPropertiesDialogEx.this.attributesList.get(rowIndex);
            List l = (List)EntityPropertiesDialogEx.this.attributesUserDefinedPropertiesMap.get(attribute);
            AbstractPropertiesDialog.UDProperty udp = (AbstractPropertiesDialog.UDProperty)l.get(columnIndex);
            udp.setValue((String)aValue);
            attribute.setProperty(udp.getUserDefinedProperty().getName(), udp.getValue());
        }
    }

    public abstract class AbstractColumnModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return EntityPropertiesDialogEx.this.attributesList.size();
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return EntityPropertiesDialogEx.INTERVAL_STRING;
            }
            if (column == 1) {
                return EntityPropertiesDialogEx.NAME;
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            Attribute attribute = EntityPropertiesDialogEx.this.attributesList.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return attribute.getName();
            }
            return new Integer(row * col);
        }
    }
}

