/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.logical;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.impact.ImpA_Attribute;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeCaseType;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeMaxNameLength;
import oracle.dbtools.crest.model.designrules.logical.DRAttributeValidCharacters;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.domains.AVTEditor;
import oracle.dbtools.crest.swingui.admin.domains.CECheckConstraint;
import oracle.dbtools.crest.swingui.admin.domains.ValueListEditorEx;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.logical.LogicalObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.logical.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.PreferredDomain;

public class AttributePropertiesDialogEx
extends LogicalObjectPropertiesDialog {
    private static final String EMPTY_VALUE = "";
    private static final String VIEW_EDIT = Messages.getString("AttributePropertiesDialogEx.ViewEdit");
    private static final String VIEW = Messages.getString("AttributePropertiesDialogEx.View");
    private Attribute attribute;
    private JTextField tfSynonym;
    private JTextField tfAbbreviation;
    private JCheckBox chbMandatory;
    private JComboBox cbScope;
    private JComboBox cbTypeSubstitution;
    private JTextField tfEntity;
    private JTextField tfConstraintName;
    private JComboBox cbDefaultValue;
    private JTextField tfDefaultValue;
    private JComboBox cbSourceType;
    private JTextField tfFormulaDesc;
    private List permittedTypes;
    private StructuredType currentST = null;
    private List subTypes;
    private JPanel pnLevels;
    private JTable lTable;
    private JTextField tfSource;
    private JTree tree;
    private boolean usePreferredList = false;
    private JComboBox cbSensitiveTypes;
    private JTextField tfSensitiveTypeDesc;
    private JCheckBox chDeprecated;
    private JCheckBox chbPK;
    private JCheckBox chbFK;
    private DefaultMutableTreeNode udpNode;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JComboBox cbDatatype;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JTextField ifDTSize;
    private ActionListener cbDatatypeActionListener;
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private boolean sizeEnabled = false;
    private boolean precisionEnabled = false;
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private boolean initialUseLogicalTypePreferredList = true;
    private boolean initialUseDomainPreferredList = true;
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private JComboBox cbUnits;
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List currentPreferredDomainList = new ArrayList();
    private JCheckBox chbReference;
    private LogicalDatatype currentSelectedLogical = null;
    private Domain currentSelectedDomain = null;
    private JPanel dataTypePanel;
    private JPanel dataTypeAdditionalPanel;
    private JPanel sizeAndUnitsPanel;
    private JPanel precisionAndScalePanel;
    private JPanel referencePanel;
    private int distinctTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().size();
    private int structuredTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().size();
    private int collectionTypesCount = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().size();
    private static final Logger LOGGER = new Logger(AttributePropertiesDialogEx.class);
    private JPanel pnConstraint;
    private JCheckBox chUseDomainConstraints;
    private JButton btnConstraint;
    private JButton btnAVT;
    private JButton btnValueList;
    private CECheckConstraint checkEditor = null;
    private ValueListEditorEx valuesEditor = null;
    private Dimension labelSize = null;

    public AttributePropertiesDialogEx(ApplicationView view, DesignObject object, boolean usePreferred) {
        super(view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    public AttributePropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, boolean usePreferred) {
        super(owner, view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("AttributePropertiesDialogEx.AttributeProperties");
    }

    @Override
    protected int getMinimumWidth() {
        return OSEnvironment.isMacOS() ? 800 : 780;
    }

    @Override
    protected int getMinimumHeight() {
        return OSEnvironment.isMacOS() ? 680 : 600;
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Attribute) {
            boolean enable;
            this.attribute = (Attribute)object;
            this.initDefaults();
            boolean enableDescr = !ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && !this.attribute.isFKElement();
            this.taComments.setEditable(enableDescr);
            this.taCommentsInRDBMS.setEditable(enableDescr);
            this.taNotes.setEditable(enableDescr);
            boolean keepFKNamesSync = this.getAppView().getSettings().isKeepFKNamesSynchronized();
            if (this.attribute.isFKAttribute() && keepFKNamesSync || this.attribute.isNameFixed()) {
                this.tfName.setEnabled(false);
            }
            this.tfSynonym.setText(this.attribute.getSynonym());
            this.tfAbbreviation.setText(this.attribute.getPreferredAbbreviation());
            this.chbMandatory.setSelected(this.attribute.isMandatory());
            if (this.attribute.isPKElement() || this.attribute.isUnique() || this.attribute.isFKAttribute()) {
                this.chbMandatory.setEnabled(false);
            }
            this.chbPK.setSelected(this.attribute.isPKElement());
            this.chbFK.setSelected(this.attribute.isFKElement());
            boolean updatable = this.isEditable() && this.attribute.getContainer() != null && !this.attribute.getContainer().isBST() && !this.attribute.isNested();
            this.tfName.setEnabled(updatable && !this.attribute.isNameFixed());
            boolean bl = enable = !this.attribute.isFKAttribute() || this.getAppView().getSettings().isAllowSimilarTypesFK() && this.attribute.getUse() == 1;
            if (this.attribute.getContainer() != null) {
                this.tfEntity.setText(this.attribute.getContainer().getName());
            }
            this.tfConstraintName.setText(this.attribute.getConstraintName());
            this.setDefaultValueUI();
            this.chUseDomainConstraints.setSelected(this.attribute.getUseDomainConstraints());
            this.fillComboItems(ContainedObject.SOURCE_TYPE_STATES_DISPLAY, this.cbSourceType, false);
            String sourceType = this.translate(this.attribute.getSourceType(), ContainedObject.SOURCE_TYPE_STATES_INTERNAL, ContainedObject.SOURCE_TYPE_STATES_DISPLAY);
            this.cbSourceType.setSelectedItem(sourceType);
            if (sourceType != null && (sourceType.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || sourceType.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE))) {
                this.tfFormulaDesc.setEnabled(true);
                this.tfFormulaDesc.setText(this.attribute.getFormulaDesc());
            } else {
                this.tfFormulaDesc.setEnabled(false);
                this.tfFormulaDesc.setText(EMPTY_VALUE);
            }
            this.initScope();
            this.tfSource.setText(this.attribute.getSource());
            if (this.attribute.isAllowSubtypeSubstitution()) {
                if (this.attribute.isRestrictedTypeSubstitution()) {
                    this.cbTypeSubstitution.setSelectedItem("RESTRICTED");
                } else {
                    this.cbTypeSubstitution.setSelectedItem("ALL");
                }
            } else {
                this.cbTypeSubstitution.setSelectedItem("NONE");
            }
            if (this.attribute.getDataType() instanceof StructuredType && !this.attribute.isReference()) {
                this.cbTypeSubstitution.setEnabled(true);
                this.currentST = (StructuredType)this.attribute.getDataType();
                this.permittedTypes.addAll(this.attribute.getPermittedSubTypes());
                this.subTypes = this.currentST.getAllInstantiableSubTypes(true);
            } else {
                this.cbTypeSubstitution.setEnabled(false);
            }
            if (this.attribute.getCheck() != null) {
                this.btnConstraint.setText(this.isEditable() ? VIEW_EDIT : VIEW);
            }
            this.btnConstraint.setEnabled(!this.chUseDomainConstraints.isSelected());
            if (!this.attribute.getAVTs().isEmpty()) {
                this.btnAVT.setText(this.isEditable() ? VIEW_EDIT : VIEW);
            }
            this.btnAVT.setEnabled(!this.chUseDomainConstraints.isSelected());
            if (this.attribute.getValueList() != null) {
                this.btnValueList.setText(this.isEditable() ? VIEW_EDIT : VIEW);
            }
            this.btnValueList.setEnabled(!this.chUseDomainConstraints.isSelected());
            this.cbSensitiveTypes.addItem(null);
            Iterator it = this.getAppView().getSensitiveTypeSet().iterator();
            while (it.hasNext()) {
                this.cbSensitiveTypes.addItem(it.next());
            }
            this.cbSensitiveTypes.setSelectedItem(this.attribute.getSensitiveType());
            this.tfSensitiveTypeDesc.setText(this.attribute.getSensitiveTypeDescription());
            this.chDeprecated.setSelected(this.attribute.isDeprecated());
            this.initMeasurements();
            this.initChangeRequests();
            this.initResponsibleParties();
            this.initDocuments();
            this.initDynamicProperties();
            this.initUserDefinedProperties();
            this.initUDPGroupsTree(this.udpNode);
            short use = this.attribute.getUse();
            switch (use) {
                case 0: {
                    this.rbDomain.setSelected(true);
                    break;
                }
                case 1: {
                    this.rbLogical.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbDistinct.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbStructured.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbCollection.setSelected(true);
                    break;
                }
                default: {
                    this.rbDomain.setSelected(true);
                }
            }
            this.disableFKColumnOptions();
        }
    }

    @Override
    protected void setProperties() {
        this.attribute.setName(this.tfName.getText());
        this.setDataType();
        this.attribute.setComment(this.taComments.getText());
        this.attribute.setCommentInRDBMS(this.taCommentsInRDBMS.getText());
        this.attribute.setNotes(this.taNotes.getText());
        this.attribute.setConstraintName(this.tfConstraintName.getText());
        if (this.cbDefaultValue.isVisible()) {
            this.attribute.setDefaultValue((String)this.cbDefaultValue.getSelectedItem());
        } else {
            this.attribute.setDefaultValue(this.tfDefaultValue.getText());
        }
        this.attribute.setSynonym(this.tfSynonym.getText());
        this.attribute.setMandatory(this.chbMandatory.isSelected());
        this.attribute.setPreferredAbbreviation(this.tfAbbreviation.getText());
        this.attribute.setUseDomainConstraints(this.chUseDomainConstraints.isSelected());
        this.attribute.setSourceType(this.translate((String)this.cbSourceType.getSelectedItem(), ContainedObject.SOURCE_TYPE_STATES_DISPLAY, ContainedObject.SOURCE_TYPE_STATES_INTERNAL));
        this.attribute.setFormulaDesc(this.tfFormulaDesc.getText());
        if (this.cbScope.getSelectedItem() != null) {
            this.attribute.setScopeId(((ContainerObject)this.cbScope.getSelectedItem()).getObjectID());
        } else {
            this.attribute.setScopeId(null);
        }
        String typs = (String)this.cbTypeSubstitution.getSelectedItem();
        if ("NONE".equals(typs)) {
            this.attribute.setAllowSubtypeSubstitution(false);
            this.attribute.setRestrictedTypeSubstitution(false);
        } else if ("ALL".equals(typs)) {
            this.attribute.setRestrictedTypeSubstitution(false);
            this.attribute.setAllowSubtypeSubstitution(true);
        } else {
            this.attribute.setRestrictedTypeSubstitution(true);
            this.attribute.setAllowSubtypeSubstitution(true);
        }
        if (this.attribute.getCheck() != null && this.attribute.getCheck().isEmpty()) {
            this.attribute.setCheck(null);
        }
        if (this.attribute.getValueList() != null && this.attribute.getValueList().isEmpty()) {
            this.attribute.setValueList(null);
        }
        if (this.attribute.getCheck() != null) {
            this.btnConstraint.setText(VIEW_EDIT);
        }
        if (!this.attribute.getAVTs().isEmpty()) {
            this.btnAVT.setText(VIEW_EDIT);
        }
        if (this.attribute.getValueList() != null) {
            this.btnValueList.setText(VIEW_EDIT);
        }
        this.attribute.setSource(this.tfSource.getText());
        this.attribute.setSensitiveType((SensitiveType)this.cbSensitiveTypes.getSelectedItem());
        this.attribute.setSensitiveTypeDescription(this.tfSensitiveTypeDesc.getText());
        this.attribute.setDeprecated(this.chDeprecated.isSelected());
        List list = this.attribute.getPermittedSubTypes();
        list.clear();
        list.addAll(this.permittedTypes);
        this.setEngineering();
        this.setMeasurements();
        this.setChangeRequests();
        this.setResponsibleParties();
        this.setDocuments();
        AttributePropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        AttributePropertiesDialogEx.stopCellEditing(this.userDefinedPropertiesTable);
        Iterator itGroupUDPTables = this.getGroupUDPTables().iterator();
        while (itGroupUDPTables.hasNext()) {
            AttributePropertiesDialogEx.stopCellEditing((JTable)itGroupUDPTables.next());
        }
        this.attribute.clearProperties();
        for (Object dp : this.dynamicPropertiesList) {
            this.attribute.setProperty(((DynamicProperty)dp).getName(), ((DynamicProperty)dp).getValue());
        }
        for (Object dp : this.allUDPList) {
            if (((AbstractPropertiesDialog.UDProperty)dp).getValue() == null || ((AbstractPropertiesDialog.UDProperty)dp).getValue().trim().equals(EMPTY_VALUE)) continue;
            this.attribute.setProperty(((AbstractPropertiesDialog.UDProperty)dp).getUserDefinedProperty().getName(), ((AbstractPropertiesDialog.UDProperty)dp).getValue());
        }
        this.checkNamingOptions();
        this.getAppView().getCurrentDPV().getWorkSpace().repaint();
    }

    protected void checkNamingOptions() {
        this.checkDesignRule(new DRAttributeMaxNameLength(), this.attribute);
        this.checkDesignRule(new DRAttributeCaseType(), this.attribute);
        this.checkDesignRule(new DRAttributeValidCharacters(), this.attribute);
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getConstraintPanel());
        this.addToTree(root, this.getPermittedSubtypesPanel());
        this.addToTree(root, this.getEngineeringPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getCommentsInRDBMSPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getMeasurementsPanel());
        this.addToTree(root, this.getChangeRequestsPanel());
        this.addToTree(root, this.getResPartiesPanel());
        this.addToTree(root, this.getDocumentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.udpNode = this.addToTree(root, this.getUserDefinedPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "ATTRIBUTE_PROPERTIES_DIALOG";
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(this.generalPanelName);
            this.contentPanel = new JPanel((LayoutManager)new MigLayout(EMPTY_VALUE, "[130!][grow, 120:120:]10[130!][grow, 120:120:]", "[]10[]"));
            this.pnGeneral.add((Component)this.contentPanel, "Center");
            this.lbName = new JLabel(LB_NAME);
            this.tfName = new JTextField();
            this.tfName.setEnabled(this.isEditable());
        }
        return this.pnGeneral;
    }

    private void initGeneral() {
        JLabel lbSynonym = new JLabel(LB_SYNOMYM);
        this.tfSynonym = new JTextField();
        JLabel lbAbbr = new JLabel(LB_PREF_ABBREVIATION);
        this.tfAbbreviation = new JTextField();
        this.chbMandatory = new JCheckBox(LB_MANDATORY);
        JLabel lbEntity = new JLabel(LB_ENTITY);
        this.tfEntity = new JTextField();
        this.tfEntity.setEditable(false);
        JLabel lbSource = new JLabel(LB_SOURCE_NAME);
        this.tfSource = new JTextField();
        JLabel lbSourceType = new JLabel(LB_SOURCE_TYPE);
        this.cbSourceType = new JComboBox();
        this.cbSourceType.setMaximumRowCount(8);
        this.cbSourceType.addActionListener(new SourceTypeListener());
        JLabel lbFormulaDesc = new JLabel(LB_FORMULA_DESC);
        this.tfFormulaDesc = new JTextField();
        JLabel lbScope = new JLabel(LB_SCOPE);
        this.cbScope = new JComboBox();
        this.cbScope.setMaximumRowCount(8);
        JLabel lbAllowSubtypeSubstitution = new JLabel(LB_SUBTYPE_SUBSTITUTION);
        this.cbTypeSubstitution = new JComboBox<String>(ContainedObjectWithDomain.SUBST_OPTIONS);
        JLabel lbSensitiveType = new JLabel(LB_SENSITIVE_TYPE);
        this.cbSensitiveTypes = new JComboBox();
        JLabel lbSensitiveTypeDesc = new JLabel(LB_SENSITIVE_TYPE_DESC);
        this.tfSensitiveTypeDesc = new JTextField();
        this.chDeprecated = new JCheckBox(LB_DEPRECATED);
        this.chbPK = new JCheckBox(Messages.getString("AttributePropertiesDialogEx.PrimaryUID"));
        this.chbPK.setEnabled(false);
        this.chbFK = new JCheckBox(Messages.getString("AttributePropertiesDialogEx.RelationUID"));
        this.chbFK.setEnabled(false);
        this.contentPanel.add(this.lbName);
        this.contentPanel.add((Component)this.tfName, new CC().growX());
        this.contentPanel.add(lbAbbr);
        this.contentPanel.add((Component)this.tfAbbreviation, new CC().growX().wrap());
        this.contentPanel.add(lbEntity);
        this.contentPanel.add((Component)this.tfEntity, new CC().growX());
        JPanel jp = new JPanel((LayoutManager)new MigLayout(EMPTY_VALUE, "[80!][80!][80!]", "0[]0"));
        jp.add(this.chbPK);
        jp.add(this.chbFK);
        jp.add(this.chbMandatory);
        this.contentPanel.add((Component)jp, new CC().wrap());
        this.initDataTypePanel();
        this.contentPanel.add(lbSynonym);
        this.contentPanel.add((Component)this.tfSynonym, new CC().growX());
        this.contentPanel.add((Component)this.chDeprecated, new CC().wrap());
        this.contentPanel.add(lbSourceType);
        this.contentPanel.add((Component)this.cbSourceType, new CC().width("130!"));
        this.contentPanel.add(lbSource);
        this.contentPanel.add((Component)this.tfSource, new CC().growX().wrap());
        this.contentPanel.add(lbFormulaDesc);
        this.contentPanel.add((Component)this.tfFormulaDesc, new CC().growX());
        this.contentPanel.add(lbScope);
        this.contentPanel.add((Component)this.cbScope, new CC().width("130:130:").growX().wrap());
        this.contentPanel.add(lbAllowSubtypeSubstitution);
        this.contentPanel.add((Component)this.cbTypeSubstitution, new CC().wrap());
        this.contentPanel.add(lbSensitiveType);
        this.contentPanel.add((Component)this.cbSensitiveTypes, new CC().width("120:120:").growX());
        this.contentPanel.add(lbSensitiveTypeDesc);
        this.contentPanel.add((Component)this.tfSensitiveTypeDesc, new CC().growX().wrap());
    }

    private void initScope() {
        if (this.attribute.isReference() && this.attribute.getUse() == 3) {
            this.cbScope.removeAllItems();
            this.cbScope.addItem(null);
            StructuredType attStructType = this.attribute.getStructuredType();
            Iterator it = ((LogicalDesign)this.attribute.getDesignPart()).getEntitySet().iterator();
            while (it.hasNext()) {
                Entity t = (Entity)it.next();
                if (!t.isBST() || !attStructType.isParentOf(t.getBasedOnStructuredType())) continue;
                this.cbScope.addItem(t);
            }
            this.cbScope.setSelectedItem(this.attribute.getScope());
            this.cbScope.setEnabled(true);
        } else {
            this.cbScope.setEnabled(false);
        }
    }

    protected JPanel getPermittedSubtypesPanel() {
        if (this.pnLevels == null) {
            this.pnLevels = this.createPage(Messages.getString("AttributePropertiesDialogEx.PermittedSubtypes"));
            this.permittedTypes = new ArrayList();
            this.subTypes = new ArrayList();
            this.lTable = new JTable(new DataModel());
            this.lTable.setSelectionMode(0);
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = AttributePropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && AttributePropertiesDialogEx.this.subTypes.size() > 0 && row < AttributePropertiesDialogEx.this.subTypes.size()) {
                        DesignObject dobj = (DesignObject)AttributePropertiesDialogEx.this.subTypes.get(row);
                        dobj.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.lTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = AttributePropertiesDialogEx.this.lTable.getSelectedRow();
                    if (row != -1 && AttributePropertiesDialogEx.this.subTypes.size() > 0 && row < AttributePropertiesDialogEx.this.subTypes.size()) {
                        DesignObject dobj = (DesignObject)AttributePropertiesDialogEx.this.subTypes.get(row);
                        dobj.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnLevels.add(pPanel);
        }
        return this.pnLevels;
    }

    private Dimension getLabelDefaultSize() {
        if (this.labelSize == null) {
            this.labelSize = new Dimension(200, 20);
        }
        return this.labelSize;
    }

    protected JPanel getConstraintPanel() {
        if (this.pnConstraint == null) {
            this.pnConstraint = this.createPage(Messages.getString("AttributePropertiesDialogEx.DefaultAndConstraint"));
            JPanel pnMain = new JPanel(new BorderLayout());
            JPanel jpanel = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbConstraintName = new JLabel(Messages.getString("AttributePropertiesDialogEx.ConstraintName"));
            lbConstraintName.setPreferredSize(this.getLabelDefaultSize());
            this.tfConstraintName = new JTextField();
            this.tfConstraintName.setPreferredSize(this.getDefaultSize());
            jpanel.add(this.createRow(lbConstraintName, this.tfConstraintName));
            JLabel lbDefaultValue = new JLabel(LB_DEFAULT_VALUE);
            lbDefaultValue.setPreferredSize(this.getLabelDefaultSize());
            JPanel pnDefaultValue = new JPanel();
            OverlayLayout overlay = new OverlayLayout(pnDefaultValue);
            pnDefaultValue.setLayout(overlay);
            this.cbDefaultValue = new JComboBox();
            this.cbDefaultValue.setPreferredSize(this.getDefaultSize());
            this.cbDefaultValue.setVisible(false);
            pnDefaultValue.add(this.cbDefaultValue);
            this.tfDefaultValue = new JTextField();
            this.tfDefaultValue.setPreferredSize(this.getDefaultSize());
            this.tfDefaultValue.setVisible(true);
            pnDefaultValue.add(this.tfDefaultValue);
            jpanel.add(this.createRow(lbDefaultValue, pnDefaultValue));
            JLabel lbUseDomainConstraints = new JLabel(LB_USE_DOMAIN_CONSTRAINTS);
            lbUseDomainConstraints.setPreferredSize(this.getLabelDefaultSize());
            this.chUseDomainConstraints = new JCheckBox();
            this.chUseDomainConstraints.setPreferredSize(this.getDefaultSize());
            this.chUseDomainConstraints.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.btnConstraint.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    AttributePropertiesDialogEx.this.btnAVT.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    AttributePropertiesDialogEx.this.btnValueList.setEnabled(!AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected());
                    if (AttributePropertiesDialogEx.this.chUseDomainConstraints.isSelected()) {
                        AttributePropertiesDialogEx.this.attribute.setCheck(null);
                    }
                }
            });
            jpanel.add(this.createRow(lbUseDomainConstraints, this.chUseDomainConstraints));
            JLabel lbConstraint = new JLabel(LB_CONSTRAINT);
            lbConstraint.setPreferredSize(this.getLabelDefaultSize());
            this.btnConstraint = new JButton(NONE);
            this.btnConstraint.setHorizontalAlignment(0);
            this.btnConstraint.setPreferredSize(this.getDefaultSize());
            this.btnConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    if (AttributePropertiesDialogEx.this.attribute.getCheck() == null) {
                        CheckConstraint check = new CheckConstraint();
                        AttributePropertiesDialogEx.this.attribute.setCheck(check);
                    }
                    if (AttributePropertiesDialogEx.this.attribute.getCheck().getDesign() == null) {
                        AttributePropertiesDialogEx.this.attribute.getCheck().setDesign(AttributePropertiesDialogEx.this.attribute.getDesign());
                    }
                    if (AttributePropertiesDialogEx.this.checkEditor == null) {
                        AttributePropertiesDialogEx.this.checkEditor = new CECheckConstraint((Dialog)AttributePropertiesDialogEx.this, AttributePropertiesDialogEx.this.getAppView(), !AttributePropertiesDialogEx.this.isEditable());
                    }
                    AttributePropertiesDialogEx.this.checkEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute.getCheck());
                    AttributePropertiesDialogEx.this.checkEditor.doEditing(AttributePropertiesDialogEx.this.attribute.getCheck());
                }
            });
            jpanel.add(this.createRow(lbConstraint, this.btnConstraint));
            JLabel lbAVT = new JLabel(LB_RANGES);
            lbAVT.setPreferredSize(this.getLabelDefaultSize());
            this.btnAVT = new JButton(LB_VALUES);
            this.btnAVT.setPreferredSize(this.getDefaultSize());
            this.btnAVT.setHorizontalAlignment(0);
            this.btnAVT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    AVTEditor avtEditor = new AVTEditor((Dialog)AttributePropertiesDialogEx.this, !AttributePropertiesDialogEx.this.isEditable());
                    avtEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute, AttributePropertiesDialogEx.this.attribute.getLogicalDatatype());
                    avtEditor.doEditing(AttributePropertiesDialogEx.this.attribute);
                }
            });
            jpanel.add(this.createRow(lbAVT, this.btnAVT));
            JLabel lbValueList = new JLabel(LB_VALUE_LIST);
            lbValueList.setPreferredSize(this.getLabelDefaultSize());
            this.btnValueList = new JButton(LB_VALUES);
            this.btnValueList.setPreferredSize(this.getDefaultSize());
            this.btnValueList.setHorizontalAlignment(0);
            this.btnValueList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributePropertiesDialogEx.this.attribute.setUseDomainConstraints(false);
                    if (AttributePropertiesDialogEx.this.attribute.getValueList() == null) {
                        ConstraintEnumeration valueList = new ConstraintEnumeration();
                        AttributePropertiesDialogEx.this.attribute.setValueList(valueList);
                    }
                    if (AttributePropertiesDialogEx.this.valuesEditor == null) {
                        AttributePropertiesDialogEx.this.valuesEditor = new ValueListEditorEx((Dialog)AttributePropertiesDialogEx.this, !AttributePropertiesDialogEx.this.isEditable());
                    }
                    AttributePropertiesDialogEx.this.valuesEditor.configureEditComponentFor(AttributePropertiesDialogEx.this.attribute.getValueList());
                    AttributePropertiesDialogEx.this.valuesEditor.doEditing(AttributePropertiesDialogEx.this.attribute);
                }
            });
            jpanel.add(this.createRow(lbValueList, this.btnValueList));
            pnMain.add((Component)jpanel, "North");
            this.pnConstraint.add(pnMain);
        }
        return this.pnConstraint;
    }

    @Override
    protected void onApply() {
        super.onApply();
        this.setDefaultValueUI();
    }

    private void setDefaultValueUI() {
        Object[] vals = this.attribute.getValues().toArray();
        if (vals != null && vals.length > 0) {
            Object[] defs = new Object[vals.length + 1];
            defs[0] = EMPTY_VALUE;
            int sel = 0;
            String def = this.attribute.getDefaultValue();
            for (int i = 0; i < vals.length; ++i) {
                defs[i + 1] = vals[i];
                if (def == null || !def.equals(vals[i].toString())) continue;
                sel = i + 1;
            }
            this.cbDefaultValue.setModel(new DefaultComboBoxModel<Object>(defs));
            this.cbDefaultValue.setSelectedIndex(sel);
            this.cbDefaultValue.setVisible(true);
            this.tfDefaultValue.setVisible(false);
        } else {
            this.tfDefaultValue.setText(this.attribute.getDefaultValue());
            this.tfDefaultValue.setVisible(true);
            this.cbDefaultValue.setVisible(false);
        }
    }

    @Override
    protected void onCancel() {
        if (this.attribute.getCheck() != null && this.attribute.getCheck().isEmpty()) {
            this.attribute.setCheck(null);
        }
        super.onCancel();
    }

    private JPanel getImpactAnalysisPanel() {
        final AttributePropertiesDialogEx owner = this;
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = AttributePropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        if (obj instanceof AbstractMDObject) {
                            ((AbstractMDObject)obj).showPropertyDialog(owner);
                        } else {
                            obj.showPropertyDialog();
                        }
                    } else {
                        if (AttributePropertiesDialogEx.this.tree.isCollapsed(path)) {
                            AttributePropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            AttributePropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_Attribute(this.attribute, null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void initDataTypePanel() {
        RBListener l = new RBListener();
        this.rbDomain = new JRadioButton(Messages.getString("AttributePropertiesDialogEx.Domain"));
        this.rbLogical = new JRadioButton(Messages.getString("AttributePropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("AttributePropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("AttributePropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("AttributePropertiesDialogEx.Collection"));
        this.rbDomain.addItemListener(l);
        this.rbLogical.addItemListener(l);
        this.rbDistinct.addItemListener(l);
        this.rbStructured.addItemListener(l);
        this.rbCollection.addItemListener(l);
        ButtonGroup datatypeGroup = new ButtonGroup();
        datatypeGroup.add(this.rbDomain);
        datatypeGroup.add(this.rbLogical);
        datatypeGroup.add(this.rbDistinct);
        datatypeGroup.add(this.rbStructured);
        datatypeGroup.add(this.rbCollection);
        JPanel pnRadioGroup = new JPanel(new GridLayout(2, 3, 6, 0));
        pnRadioGroup.add(this.rbDomain);
        pnRadioGroup.add(this.rbLogical);
        pnRadioGroup.add(this.rbDistinct);
        pnRadioGroup.add(this.rbStructured);
        pnRadioGroup.add(this.rbCollection);
        this.sizeAndUnitsPanel = new JPanel((LayoutManager)new MigLayout(EMPTY_VALUE, "[110!][100!]", "0[]10[]0"));
        this.precisionAndScalePanel = new JPanel((LayoutManager)new MigLayout(EMPTY_VALUE, "[110!][100!]", "0[]10[]0"));
        this.referencePanel = new JPanel((LayoutManager)new MigLayout(EMPTY_VALUE, "[110!][100!]", "0[]0"));
        JLabel lbType = new JLabel(Messages.getString("AttributePropertiesDialogEx.Type"));
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setMaximumRowCount(20);
        JLabel lbPreferred = new JLabel(Messages.getString("AttributePropertiesDialogEx.Preferred"));
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        JLabel lbSize = new JLabel(LB_SIZE);
        this.ifDTSize = new JTextField();
        JLabel lbUnits = new JLabel(Messages.getString("AttributePropertiesDialogEx.Units"));
        lbUnits.setHorizontalAlignment(2);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.sizeAndUnitsPanel.add(lbSize);
        this.sizeAndUnitsPanel.add((Component)this.ifDTSize, new CC().grow().wrap());
        this.sizeAndUnitsPanel.add(lbUnits);
        this.sizeAndUnitsPanel.add((Component)this.cbUnits, new CC().width("60!"));
        this.cbDatatypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttributePropertiesDialogEx.this.updateDataTypePanelOptions();
            }
        };
        this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
        JLabel lbPrecision = new JLabel(LB_PRECISION);
        lbPrecision.setHorizontalAlignment(2);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setAllowAsterisks(true);
        JLabel lbScale = new JLabel(LB_SCALE);
        lbScale.setHorizontalAlignment(2);
        this.ifDTScale = new JIntegerField();
        this.precisionAndScalePanel.add(lbPrecision);
        this.precisionAndScalePanel.add((Component)this.ifDTPrecision, new CC().grow().wrap());
        this.precisionAndScalePanel.add(lbScale);
        this.precisionAndScalePanel.add((Component)this.ifDTScale, new CC().grow());
        this.chbReference = new JCheckBox(Messages.getString("AttributePropertiesDialogEx.Reference"));
        this.referencePanel.add(new JLabel());
        this.referencePanel.add(this.chbReference);
        this.dataTypePanel = new JPanel((LayoutManager)new MigLayout(EMPTY_VALUE, "[110!][]", "0[]10[]0"));
        this.dataTypePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("AttributePropertiesDialogEx.DataType")));
        this.dataTypePanel.add(new JLabel());
        this.dataTypePanel.add((Component)pnRadioGroup, new CC().spanX().wrap());
        this.dataTypePanel.add(lbType);
        this.dataTypePanel.add((Component)this.cbDatatype, new CC().width("180!"));
        this.dataTypePanel.add(lbPreferred);
        this.dataTypePanel.add((Component)this.chbUsePreferredList, new CC().wrap());
        this.dataTypeAdditionalPanel = new JPanel((LayoutManager)new MigLayout(EMPTY_VALUE, "0[110!][120!]0", "0[]0[]0"));
        this.contentPanel.add((Component)this.dataTypePanel, new CC().spanX(4).grow().wrap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataTypeComboBox() {
        block58: {
            try {
                this.cbDatatype.removeAllItems();
                this.dataTypePanel.updateUI();
                if (this.rbDomain.isSelected()) {
                    Domain selDomain = null;
                    if (this.attribute != null) {
                        selDomain = this.attribute.getDomain();
                    }
                    if (selDomain == null) {
                        selDomain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                        List pDomains = this.getCurrentPreferredDomains();
                        allPreferredDomains.addAll(pDomains);
                        if (pDomains.size() > 0) {
                            for (Domain domain : pDomains) {
                                if (selDomain == null) continue;
                                if (!domain.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(selDomain)) continue;
                                    this.additionalPreferredDomains.add(selDomain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(selDomain)) {
                                    this.additionalPreferredDomains.remove(selDomain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                            this.additionalPreferredDomains.add(selDomain);
                        }
                        allPreferredDomains.addAll(this.additionalPreferredDomains);
                        boolean currentAdded = false;
                        for (Object e : allPreferredDomains) {
                            if (e == this.currentSelectedDomain) {
                                currentAdded = true;
                            }
                            this.cbDatatype.addItem(e);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        if (this.currentSelectedDomain != null && !currentAdded) {
                            this.cbDatatype.addItem(this.currentSelectedDomain);
                        }
                        this.getAppView().getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator it = this.getDesignObject().getDesign().getDomainSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = obj;
                        }
                        this.getAppView().getSettings().setUsePreferredDomains(false);
                    }
                    this.cbDatatype.setSelectedItem(selDomain);
                    break block58;
                }
                if (this.rbLogical.isSelected()) {
                    try {
                        this.selLogicalDatatype = null;
                        if (this.attribute != null) {
                            this.selLogicalDatatype = this.attribute.getLogicalDatatype();
                        }
                        if (this.initialUseLogicalTypePreferredList) {
                            this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                            this.initialUseLogicalTypePreferredList = false;
                        }
                        if (this.chbUsePreferredList.isSelected()) {
                            ArrayList<LogicalDatatype> allPreferredLogicalDatatypes = new ArrayList<LogicalDatatype>();
                            List pLogicalDatatypes = this.getCurrentPreferredLogicalDatatypes();
                            allPreferredLogicalDatatypes.addAll(pLogicalDatatypes);
                            if (pLogicalDatatypes.size() > 0) {
                                for (LogicalDatatype ldt : pLogicalDatatypes) {
                                    if (this.selLogicalDatatype == null) continue;
                                    if (!ldt.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                        if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                        this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                        continue;
                                    }
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                        this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                    }
                                    break;
                                }
                            } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                            }
                            allPreferredLogicalDatatypes.addAll(this.additionalPreferredLogicalTypes);
                            boolean currentAdded = false;
                            for (Object e : allPreferredLogicalDatatypes) {
                                if (e == this.currentSelectedLogical) {
                                    currentAdded = true;
                                }
                                this.cbDatatype.addItem(e);
                                if (this.logicalDefaultDataType == null) {
                                    this.logicalDefaultDataType = e;
                                }
                                if (!e.toString().equalsIgnoreCase("unknown")) continue;
                                this.logicalDefaultDataType = e;
                            }
                            if (this.currentSelectedLogical != null && !currentAdded) {
                                this.cbDatatype.addItem(this.currentSelectedLogical);
                            }
                            this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
                            break block58;
                        }
                        Iterator it = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = obj;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
                        break block58;
                    }
                    finally {
                        this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    }
                }
                if (this.rbDistinct.isSelected()) {
                    Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    DistinctType selDistinctType = null;
                    if (this.attribute != null) {
                        selDistinctType = this.attribute.getDistinctType();
                    }
                    if (selDistinctType != null) {
                        this.cbDatatype.setSelectedItem(selDistinctType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbStructured.isSelected()) {
                    Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    StructuredType selStructuredType = null;
                    if (this.attribute != null) {
                        selStructuredType = this.attribute.getStructuredType();
                    }
                    if (selStructuredType != null) {
                        this.cbDatatype.setSelectedItem(selStructuredType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbCollection.isSelected()) {
                    Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    CollectionType selCollectionType = null;
                    if (this.attribute != null) {
                        selCollectionType = this.attribute.getCollectionType();
                    }
                    if (selCollectionType != null) {
                        this.cbDatatype.setSelectedItem(selCollectionType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("updateDTComboBox() ", e);
            }
        }
    }

    private void updateDataTypePanelOptions() {
        block54: {
            try {
                this.ifDTSize.setText(EMPTY_VALUE);
                this.ifDTPrecision.setText(EMPTY_VALUE);
                this.ifDTScale.setText(EMPTY_VALUE);
                this.cbUnits.setSelectedIndex(0);
                this.cbUnits.setEnabled(false);
                this.dataTypePanel.remove(this.dataTypeAdditionalPanel);
                this.dataTypePanel.updateUI();
                this.dataTypeAdditionalPanel.removeAll();
                this.dataTypeAdditionalPanel.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
                Object obj = this.cbDatatype.getSelectedItem();
                if (obj == null) break block54;
                if (obj instanceof LogicalDatatype) {
                    String size;
                    LogicalDatatype selected = (LogicalDatatype)obj;
                    Map defaults = selected.getLTDefaultValues();
                    if (defaults != null) {
                        this.precisionDefaultValue = (String)defaults.get("precision_default_value");
                        this.sizeDefaultValue = (String)defaults.get("size_default_value");
                        this.scaleDefaultValue = (String)defaults.get("scale_default_value");
                    }
                    Map<String, String> m = selected.getToPhysical();
                    MDDataType datatype = selected.createDataType(this.attribute.getEntity().getSelectedRDBMSType().getName(), m);
                    if (datatype instanceof MDImplicitSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.ifDTPrecision.setText(this.precisionDefaultValue);
                        this.ifDTPrecision.setEnabled(false);
                        this.ifDTScale.setText(this.scaleDefaultValue);
                        this.ifDTScale.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = false;
                    } else if (datatype instanceof MDPackedSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                        try {
                            if (datatype.getPrecision() != 0) {
                                this.ifDTPrecision.setText(datatype.getPrecisionStr());
                            }
                            if (this.isEditable()) {
                                this.ifDTPrecision.setEnabled(true);
                                if (this.ifDTPrecision.getText().trim().length() == 0) {
                                    this.ifDTPrecision.setText(this.precisionDefaultValue);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.getScale() != 0) {
                                this.ifDTScale.setText(EMPTY_VALUE + datatype.getScale());
                            }
                            if (this.isEditable()) {
                                this.ifDTScale.setEnabled(true);
                                if (this.ifDTScale.getText().trim().length() == 0) {
                                    this.ifDTScale.setText(this.scaleDefaultValue);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    } else {
                        try {
                            if (datatype.hasSize()) {
                                if (!datatype.getSize().equalsIgnoreCase("0")) {
                                    if (this.isEditable()) {
                                        this.cbUnits.setEnabled(true);
                                    }
                                    size = datatype.getSize();
                                    String[] parts_n = size.split(" ");
                                    this.ifDTSize.setText(parts_n[0]);
                                    if (parts_n.length == 2) {
                                        this.cbUnits.setSelectedItem(parts_n[1]);
                                    }
                                } else {
                                    this.ifDTSize.setText(this.sizeDefaultValue);
                                    if (this.isEditable()) {
                                        this.cbUnits.setEnabled(true);
                                    }
                                }
                                if (this.isEditable()) {
                                    this.ifDTSize.setEnabled(true);
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.sizeAndUnitsPanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = true;
                                this.precisionEnabled = false;
                            } else {
                                this.ifDTSize.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTSize.setEnabled(false);
                        }
                        try {
                            if (datatype.hasPrecision()) {
                                if (datatype.getPrecision() != 0) {
                                    this.ifDTPrecision.setText(datatype.getPrecisionStr());
                                }
                                if (this.isEditable()) {
                                    this.ifDTPrecision.setEnabled(true);
                                    if (this.ifDTPrecision.getText().trim().length() == 0) {
                                        this.ifDTPrecision.setText(this.precisionDefaultValue);
                                    }
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                            } else {
                                this.ifDTPrecision.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.hasScale()) {
                                if (datatype.getScale() != 0) {
                                    this.ifDTScale.setText(EMPTY_VALUE + datatype.getScale());
                                }
                                if (this.isEditable()) {
                                    this.ifDTScale.setEnabled(true);
                                    if (this.ifDTScale.getText().trim().length() == 0) {
                                        this.ifDTScale.setText(this.scaleDefaultValue);
                                    }
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                            } else {
                                this.ifDTScale.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    }
                    size = this.attribute.getDataTypeParameter("size");
                    String precision = this.attribute.getDataTypeParameter("precision");
                    String scale = this.attribute.getDataTypeParameter("scale");
                    String units = EMPTY_VALUE;
                    String[] parts_n = size.split(" ");
                    if (parts_n.length == 2) {
                        size = parts_n[0];
                        units = parts_n[1];
                    }
                    if (this.ifDTSize.isEnabled()) {
                        try {
                            this.ifDTSize.setText(size != null && size != EMPTY_VALUE ? size : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTPrecision.isEnabled()) {
                        try {
                            this.ifDTPrecision.setValue((long)Integer.parseInt(precision != null && precision != EMPTY_VALUE ? precision : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTScale.isEnabled()) {
                        try {
                            this.ifDTScale.setValue((long)Integer.parseInt(scale != null && scale != EMPTY_VALUE ? scale : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.cbUnits.isEnabled()) {
                        this.cbUnits.setSelectedItem(units);
                    }
                    break block54;
                }
                if (obj instanceof StructuredType) {
                    this.dataTypeAdditionalPanel.removeAll();
                    this.chbReference.setSelected(this.attribute.isReference());
                    this.dataTypeAdditionalPanel.add(this.referencePanel);
                    this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                    this.dataTypePanel.updateUI();
                }
            }
            catch (Exception e) {
                LOGGER.error("updateLogicalDatatypeOptions() ", e);
            }
        }
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator allLogicalDatatypeIterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (allLogicalDatatypeIterator.hasNext()) {
            LogicalDatatype ldt0 = (LogicalDatatype)allLogicalDatatypeIterator.next();
            List<LogicalDatatype> settingsPreferredLogicalDatatypeList = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype ldt1 : settingsPreferredLogicalDatatypeList) {
                if (!ldt0.getObjectID().equalsIgnoreCase(ldt1.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(ldt0);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator allDesignDomainsDesignIterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            List<PreferredDomain> settingsPreferreddomainsList = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain pd : settingsPreferreddomainsList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) continue;
                this.currentPreferredDomainList.add(obj);
            }
        }
        return this.currentPreferredDomainList;
    }

    private void setDataType() {
        if (this.rbDomain.isSelected()) {
            Object datatype = this.cbDatatype.getSelectedItem();
            if (datatype instanceof Domain) {
                Domain domain = (Domain)datatype;
                this.attribute.setUse((short)0);
                if (this.attribute.getDomain() != domain) {
                    this.attribute.setDomain(domain);
                    if (domain.getCheck() != null && !domain.getCheck().isEmpty()) {
                        this.attribute.setUseDomainConstraints(true);
                    }
                }
            }
        } else if (this.rbLogical.isSelected()) {
            int scaleDefaultValue;
            this.attribute.setDataTypeParameter("size", EMPTY_VALUE);
            this.attribute.setDataTypeParameter("precision", EMPTY_VALUE);
            this.attribute.setDataTypeParameter("scale", EMPTY_VALUE);
            this.attribute.setUse((short)1);
            this.attribute.setLogicalDatatype((LogicalDatatype)this.cbDatatype.getSelectedItem());
            Map defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
            String pdf = (String)defaults.get("precision_default_value");
            if (pdf == null) {
                pdf = EMPTY_VALUE;
            }
            String sizeDefaultValue = (String)defaults.get("size_default_value");
            String scdf = (String)defaults.get("scale_default_value");
            int n = scaleDefaultValue = scdf != EMPTY_VALUE && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
            if (this.sizeEnabled) {
                String size = this.ifDTSize.getText();
                if (size != EMPTY_VALUE && !size.equals(sizeDefaultValue)) {
                    if (this.cbUnits.getSelectedIndex() > 0) {
                        this.attribute.setDataTypeParameter("size", String.valueOf(size) + " " + this.cbUnits.getSelectedItem());
                    } else {
                        this.attribute.setDataTypeParameter("size", String.valueOf(size));
                    }
                } else {
                    this.attribute.setDataTypeParameter("size", EMPTY_VALUE);
                    this.attribute.setDataTypeParameter("precision", EMPTY_VALUE);
                    this.attribute.setDataTypeParameter("scale", EMPTY_VALUE);
                }
            } else if (this.precisionEnabled) {
                this.attribute.setDataTypeParameter("size", EMPTY_VALUE);
                if (!pdf.equals(this.ifDTPrecision.getText())) {
                    this.attribute.setDataTypeParameter("precision", this.ifDTPrecision.getText());
                } else {
                    this.attribute.setDataTypeParameter("precision", EMPTY_VALUE);
                }
                if (this.ifDTScale.getIntValue() != scaleDefaultValue) {
                    this.attribute.setDataTypeParameter("scale", String.valueOf(this.ifDTScale.getIntValue()));
                } else {
                    this.attribute.setDataTypeParameter("scale", EMPTY_VALUE);
                }
            }
        } else if (this.rbDistinct.isSelected()) {
            this.attribute.setUse((short)2);
            this.attribute.setDistinctType((DistinctType)this.cbDatatype.getSelectedItem());
        } else if (this.rbStructured.isSelected()) {
            this.attribute.setUse((short)3);
            this.attribute.setReference(this.chbReference.isSelected());
            this.attribute.setStructuredType((StructuredType)this.cbDatatype.getSelectedItem());
        } else if (this.rbCollection.isSelected()) {
            this.attribute.setUse((short)4);
            this.attribute.setCollectionType((CollectionType)this.cbDatatype.getSelectedItem());
        }
    }

    private void disableFKColumnOptions() {
        if (this.isEditable()) {
            boolean enableDataParams = !this.attribute.isFKElement() || this.getAppView().getSettings().isAllowSimilarTypesFK();
            boolean enable = !this.attribute.isFKElement();
            boolean enableDescr = !ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION || ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION && !this.attribute.isFKElement();
            boolean basedOnStructuredTypeTable = this.attribute.getEntity().getBasedOnStructuredType() != null;
            boolean enableBasedOnStructureType = enable && !basedOnStructuredTypeTable;
            enableDataParams = enableDataParams && !basedOnStructuredTypeTable;
            this.rbDomain.setEnabled(enableBasedOnStructureType);
            this.rbLogical.setEnabled(enableBasedOnStructureType);
            if (!enable) {
                this.rbDistinct.setEnabled(enableBasedOnStructureType);
                this.rbStructured.setEnabled(enableBasedOnStructureType);
                this.rbCollection.setEnabled(enableBasedOnStructureType);
            } else {
                if (this.structuredTypesCount > 0) {
                    this.rbStructured.setEnabled(enableBasedOnStructureType);
                } else {
                    this.rbStructured.setEnabled(false);
                }
                if (this.distinctTypesCount > 0) {
                    this.rbDistinct.setEnabled(enableBasedOnStructureType);
                } else {
                    this.rbDistinct.setEnabled(false);
                }
                if (this.collectionTypesCount > 0) {
                    this.rbCollection.setEnabled(enableBasedOnStructureType);
                } else {
                    this.rbCollection.setEnabled(false);
                }
            }
            this.cbDatatype.setEnabled(enableBasedOnStructureType);
            this.ifDTSize.setEnabled(enableDataParams);
            this.cbUnits.setEnabled(enableDataParams);
            this.ifDTPrecision.setEnabled(enableDataParams);
            this.ifDTScale.setEnabled(enableDataParams);
            this.chbMandatory.setEnabled(enable);
            this.chDeprecated.setEnabled(enable);
            this.chbUsePreferredList.setEnabled(enableBasedOnStructureType);
        }
    }

    @Override
    protected void showComponent(Component component) {
        if (this.userDefinedPropertiesTable != null) {
            AttributePropertiesDialogEx.stopCellEditing(this.userDefinedPropertiesTable);
        }
        Iterator itGroupUDPTables = this.getGroupUDPTables().iterator();
        while (itGroupUDPTables.hasNext()) {
            AttributePropertiesDialogEx.stopCellEditing((JTable)itGroupUDPTables.next());
        }
        super.showComponent(component);
    }

    private class SourceTypeListener
    implements ActionListener {
        private SourceTypeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String type = (String)AttributePropertiesDialogEx.this.cbSourceType.getSelectedItem();
            if (type != null) {
                if (type.equalsIgnoreCase(ContainedObject.NLS_TYPE_DERIVED) || type.equalsIgnoreCase(ContainedObject.NLS_TYPE_AGGREGATE)) {
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setEnabled(true);
                } else {
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setEnabled(false);
                    AttributePropertiesDialogEx.this.tfFormulaDesc.setText(AttributePropertiesDialogEx.EMPTY_VALUE);
                }
            }
        }
    }

    public class DataModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AttributePropertiesDialogEx.this.subTypes.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AttributePropertiesDialogEx.Permitted");
            }
            if (column == 1) {
                return Messages.getString("AttributePropertiesDialogEx.Name");
            }
            return AttributePropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StructuredType st = (StructuredType)AttributePropertiesDialogEx.this.subTypes.get(row);
            if (col == 1) {
                return st.getName();
            }
            if (col == 0) {
                return AttributePropertiesDialogEx.this.permittedTypes.contains(st);
            }
            return AttributePropertiesDialogEx.EMPTY_VALUE;
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            StructuredType st = (StructuredType)AttributePropertiesDialogEx.this.subTypes.get(row);
            if (col == 0) {
                if (((Boolean)aValue).booleanValue()) {
                    if (!AttributePropertiesDialogEx.this.permittedTypes.contains(st)) {
                        AttributePropertiesDialogEx.this.permittedTypes.add(st);
                    }
                } else {
                    AttributePropertiesDialogEx.this.permittedTypes.remove(st);
                }
            }
        }
    }

    private class RBListener
    implements ItemListener {
        private RBListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                AttributePropertiesDialogEx.this.updateDataTypeComboBox();
                AttributePropertiesDialogEx.this.cbDatatype.updateUI();
            }
            catch (Exception e1) {
                LOGGER.error("RBListener", e1);
            }
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AttributePropertiesDialogEx.this.rbDomain.isSelected() || AttributePropertiesDialogEx.this.rbLogical.isSelected()) {
                AttributePropertiesDialogEx.this.updateDataTypeComboBox();
            }
        }
    }

    private class DatatypeListener
    implements ChangeListener {
        private DatatypeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            AttributePropertiesDialogEx.this.initScope();
            AttributePropertiesDialogEx.this.cbTypeSubstitution.setEnabled(AttributePropertiesDialogEx.this.attribute.getDataType() instanceof StructuredType && !AttributePropertiesDialogEx.this.attribute.isReference());
        }
    }
}

