/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.PreferredDomain;
import oracle.ide.Ide;

public class TypeElementPropertiesDialogEx
extends AbstractPropertiesDialog {
    private TypeElement typeElement;
    private TypeElement temp;
    private JCheckBox chMandatory;
    private boolean usePreferredList = false;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JComboBox cbDatatype;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JTextField ifDTSize;
    private ActionListener cbDatatypeActionListener;
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private boolean sizeEnabled = false;
    private boolean precisionEnabled = false;
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private JCheckBox chbUsePreferredList;
    private LogicalDatatype selLogicalDatatype = null;
    private boolean initialUseLogicalTypePreferredList = true;
    private boolean initialUseDomainPreferredList = true;
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private JComboBox cbUnits;
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List currentPreferredDomainList = new ArrayList();
    private JCheckBox chbReference;
    private LogicalDatatype currentSelectedLogical = null;
    private Domain currentSelectedDomain = null;
    private JPanel dataTypePanel;
    private JPanel dataTypeAdditionalPanel;
    private JPanel sizeAndUnitsPanel;
    private JPanel precisionAndScalePanel;
    private JPanel referencePanel;
    private DefaultMutableTreeNode udpNode;
    private static final Logger LOGGER = new Logger(TypeElementPropertiesDialogEx.class);

    public TypeElementPropertiesDialogEx(ApplicationView view, DesignObject object, boolean usePreferred) {
        super(view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    public TypeElementPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, boolean usePreferred) {
        super(owner, view, object);
        this.usePreferredList = usePreferred;
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TypeElementPropertiesDialogEx.AttributeProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof TypeElement) {
            this.typeElement = (TypeElement)object;
            this.initDefaults(false);
            this.chMandatory.setSelected(this.typeElement.isMandatory());
            this.temp = new TypeElement(this.typeElement.getDesignPart(), this.typeElement.getStructuredType());
            this.temp.setDesign(this.typeElement.getDesign());
            this.typeElement.copyDataType(this.temp);
            if (this.typeElement.getType() instanceof Domain) {
                this.rbDomain.setSelected(true);
            } else if (this.typeElement.getType() instanceof LogicalDatatype) {
                this.rbLogical.setSelected(true);
            } else if (this.typeElement.getType() instanceof DistinctType) {
                this.rbDistinct.setSelected(true);
            } else if (this.typeElement.getType() instanceof StructuredType) {
                this.rbStructured.setSelected(true);
            } else if (this.typeElement.getType() instanceof CollectionType) {
                this.rbCollection.setSelected(true);
            } else {
                this.rbDomain.setSelected(true);
            }
            this.initDynamicProperties();
            this.initUserDefinedProperties();
            this.initUDPGroupsTree(this.udpNode);
        }
    }

    @Override
    protected void setProperties() {
        this.typeElement.setName(this.tfName.getText());
        this.typeElement.setComment(this.taComments.getText());
        this.typeElement.setNotes(this.taNotes.getText());
        this.typeElement.setMandatory(this.chMandatory.isSelected());
        this.temp.copyDataType(this.typeElement);
        this.typeElement.updateReference();
        this.setDataType();
        TypeElementPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.typeElement.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.typeElement.setProperty(dp.getName(), dp.getValue());
        }
        TypeElementPropertiesDialogEx.stopCellEditing(this.userDefinedPropertiesTable);
        Iterator itGroupUDPTables = this.getGroupUDPTables().iterator();
        while (itGroupUDPTables.hasNext()) {
            TypeElementPropertiesDialogEx.stopCellEditing((JTable)itGroupUDPTables.next());
        }
        for (AbstractPropertiesDialog.UDProperty dp : this.allUDPList) {
            if (dp.getValue() == null || dp.getValue().trim().equals("")) continue;
            this.typeElement.setProperty(dp.getUserDefinedProperty().getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.udpNode = this.addToTree(root, this.getUserDefinedPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "STRUCTUREDTYPE_ATTRIBUTE_PROPERTIES_DIALOG";
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(this.generalPanelName);
            this.contentPanel = new JPanel((LayoutManager)new MigLayout("", "[120!][grow, 120:120:]10[120!][grow, 120:120:]", "[]10[]"));
            this.pnGeneral.add((Component)this.contentPanel, "Center");
            this.lbName = new JLabel(LB_NAME);
            this.tfName = new JTextField();
        }
        return this.pnGeneral;
    }

    private void initGeneral() {
        this.chMandatory = new JCheckBox(LB_MANDATORY);
        this.chMandatory.setEnabled(this.isEditable());
        this.contentPanel.add(this.lbName);
        this.contentPanel.add((Component)this.tfName, new CC().growX());
        this.contentPanel.add((Component)this.chMandatory, new CC().wrap());
        this.initDataTypePanel();
    }

    private boolean hasValidContainment(StructuredType owner, TypeElement inte) {
        TypeElement ct;
        TypeElement te = inte;
        if (inte.getType() instanceof CollectionType && (ct = ((CollectionType)inte.getType()).getElementType()).getType() instanceof StructuredType) {
            te = ct;
        }
        if (te.getType() instanceof StructuredType) {
            StructuredType st = (StructuredType)te.getType();
            if (!te.isReference()) {
                if (owner.isParentOf(st) || st.isParentOf(owner)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypeElementPropertiesDialogEx.TypePartOf"), st.getName(), owner.getName()), Messages.getString("TypeElementPropertiesDialogEx.ForbidenSelfContainment"), 0);
                    return false;
                }
                if (st.containsElementOfStructuredType(owner)) {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("TypeElementPropertiesDialogEx.CyclicContainment"), st.getName()), Messages.getString("TypeElementPropertiesDialogEx.ForbidenCyclicContainment"), 0);
                    return false;
                }
            }
        }
        return true;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void initDataTypePanel() {
        RBListener l = new RBListener();
        this.rbDomain = new JRadioButton(Messages.getString("TypeElementPropertiesDialogEx.Domain"));
        this.rbLogical = new JRadioButton(Messages.getString("TypeElementPropertiesDialogEx.Logical"));
        this.rbDistinct = new JRadioButton(Messages.getString("TypeElementPropertiesDialogEx.Distinct"));
        this.rbStructured = new JRadioButton(Messages.getString("TypeElementPropertiesDialogEx.Structured"));
        this.rbCollection = new JRadioButton(Messages.getString("TypeElementPropertiesDialogEx.Collection"));
        this.rbDomain.addItemListener(l);
        this.rbLogical.addItemListener(l);
        this.rbDistinct.addItemListener(l);
        this.rbStructured.addItemListener(l);
        this.rbCollection.addItemListener(l);
        ButtonGroup datatypeGroup = new ButtonGroup();
        datatypeGroup.add(this.rbDomain);
        datatypeGroup.add(this.rbLogical);
        datatypeGroup.add(this.rbDistinct);
        datatypeGroup.add(this.rbStructured);
        datatypeGroup.add(this.rbCollection);
        JPanel pnRadioGroup = new JPanel(new GridLayout(2, 3, 6, 0));
        pnRadioGroup.add(this.rbDomain);
        pnRadioGroup.add(this.rbLogical);
        pnRadioGroup.add(this.rbDistinct);
        pnRadioGroup.add(this.rbStructured);
        pnRadioGroup.add(this.rbCollection);
        this.sizeAndUnitsPanel = new JPanel((LayoutManager)new MigLayout("", "[110!][100!]", "0[]10[]0"));
        this.precisionAndScalePanel = new JPanel((LayoutManager)new MigLayout("", "[110!][100!]", "0[]10[]0"));
        this.referencePanel = new JPanel((LayoutManager)new MigLayout("", "[110!][100!]", "0[]0"));
        JLabel lbType = new JLabel(Messages.getString("TypeElementPropertiesDialogEx.Type"));
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setMaximumRowCount(20);
        JLabel lbPreferred = new JLabel(Messages.getString("TypeElementPropertiesDialogEx.Preferred"));
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        JLabel lbSize = new JLabel(LB_SIZE);
        this.ifDTSize = new JTextField();
        JLabel lbUnits = new JLabel(Messages.getString("TypeElementPropertiesDialogEx.Units"));
        lbUnits.setHorizontalAlignment(2);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.sizeAndUnitsPanel.add(lbSize);
        this.sizeAndUnitsPanel.add((Component)this.ifDTSize, new CC().grow().wrap());
        this.sizeAndUnitsPanel.add(lbUnits);
        this.sizeAndUnitsPanel.add((Component)this.cbUnits, new CC().width("60!"));
        this.cbDatatypeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeElementPropertiesDialogEx.this.updateDataTypePanelOptions();
            }
        };
        this.cbDatatype.addActionListener(this.cbDatatypeActionListener);
        JLabel lbPrecision = new JLabel(LB_PRECISION);
        lbPrecision.setHorizontalAlignment(2);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setAllowAsterisks(true);
        JLabel lbScale = new JLabel(LB_SCALE);
        lbScale.setHorizontalAlignment(2);
        this.ifDTScale = new JIntegerField();
        this.precisionAndScalePanel.add(lbPrecision);
        this.precisionAndScalePanel.add((Component)this.ifDTPrecision, new CC().grow().wrap());
        this.precisionAndScalePanel.add(lbScale);
        this.precisionAndScalePanel.add((Component)this.ifDTScale, new CC().grow());
        this.chbReference = new JCheckBox(Messages.getString("TypeElementPropertiesDialogEx.Reference"));
        this.referencePanel.add(new JLabel());
        this.referencePanel.add(this.chbReference);
        this.dataTypePanel = new JPanel((LayoutManager)new MigLayout("", "[110!][]", "0[]10[]0"));
        this.dataTypePanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TypeElementPropertiesDialogEx.DataType")));
        this.dataTypePanel.add(new JLabel());
        this.dataTypePanel.add((Component)pnRadioGroup, new CC().spanX().wrap());
        this.dataTypePanel.add(lbType);
        this.dataTypePanel.add((Component)this.cbDatatype, new CC().width("180!"));
        this.dataTypePanel.add(lbPreferred);
        this.dataTypePanel.add((Component)this.chbUsePreferredList, new CC().wrap());
        this.dataTypeAdditionalPanel = new JPanel((LayoutManager)new MigLayout("", "0[110!][120!]0", "0[]0[]0"));
        this.contentPanel.add((Component)this.dataTypePanel, new CC().spanX(3).grow().wrap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataTypeComboBox() {
        block60: {
            try {
                this.cbDatatype.removeAllItems();
                this.dataTypePanel.updateUI();
                if (this.rbDomain.isSelected()) {
                    Domain selDomain = null;
                    if (this.typeElement != null) {
                        selDomain = this.typeElement.getDomain();
                    }
                    if (selDomain == null) {
                        selDomain = this.getDesignObject().getDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                        List pDomains = this.getCurrentPreferredDomains();
                        allPreferredDomains.addAll(pDomains);
                        if (pDomains.size() > 0) {
                            for (Domain domain : pDomains) {
                                if (selDomain == null) continue;
                                if (!domain.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(selDomain)) continue;
                                    this.additionalPreferredDomains.add(selDomain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(selDomain)) {
                                    this.additionalPreferredDomains.remove(selDomain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                            this.additionalPreferredDomains.add(selDomain);
                        }
                        allPreferredDomains.addAll(this.additionalPreferredDomains);
                        boolean currentAdded = false;
                        for (Object e : allPreferredDomains) {
                            if (e == this.currentSelectedDomain) {
                                currentAdded = true;
                            }
                            this.cbDatatype.addItem(e);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        if (this.currentSelectedDomain != null && !currentAdded) {
                            this.cbDatatype.addItem(this.currentSelectedDomain);
                        }
                        this.getAppView().getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator it = this.getDesignObject().getDesign().getDomainSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = obj;
                        }
                        this.getAppView().getSettings().setUsePreferredDomains(false);
                    }
                    this.cbDatatype.setSelectedItem(selDomain);
                    break block60;
                }
                if (this.rbLogical.isSelected()) {
                    try {
                        this.selLogicalDatatype = null;
                        if (this.typeElement.getType() instanceof Domain) {
                            this.selLogicalDatatype = ((Domain)this.typeElement.getType()).getLogicalDatatype();
                        } else if (this.typeElement.getType() instanceof LogicalDatatype) {
                            this.selLogicalDatatype = (LogicalDatatype)this.typeElement.getType();
                        }
                        if (this.initialUseLogicalTypePreferredList) {
                            this.chbUsePreferredList.setSelected(this.getAppView().getSettings().isUsePreferredLogicalTypes());
                            this.initialUseLogicalTypePreferredList = false;
                        }
                        if (this.chbUsePreferredList.isSelected()) {
                            ArrayList<LogicalDatatype> allPreferredLogicalDatatypes = new ArrayList<LogicalDatatype>();
                            List pLogicalDatatypes = this.getCurrentPreferredLogicalDatatypes();
                            allPreferredLogicalDatatypes.addAll(pLogicalDatatypes);
                            if (pLogicalDatatypes.size() > 0) {
                                for (LogicalDatatype ldt : pLogicalDatatypes) {
                                    if (this.selLogicalDatatype == null) continue;
                                    if (!ldt.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                        if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                        this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                        continue;
                                    }
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                        this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                    }
                                    break;
                                }
                            } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                            }
                            allPreferredLogicalDatatypes.addAll(this.additionalPreferredLogicalTypes);
                            boolean currentAdded = false;
                            for (Object e : allPreferredLogicalDatatypes) {
                                if (e == this.currentSelectedLogical) {
                                    currentAdded = true;
                                }
                                this.cbDatatype.addItem(e);
                                if (this.logicalDefaultDataType == null) {
                                    this.logicalDefaultDataType = e;
                                }
                                if (!e.toString().equalsIgnoreCase("unknown")) continue;
                                this.logicalDefaultDataType = e;
                            }
                            if (this.currentSelectedLogical != null && !currentAdded) {
                                this.cbDatatype.addItem(this.currentSelectedLogical);
                            }
                            this.getAppView().getSettings().setUsePreferredLogicalTypes(true);
                            break block60;
                        }
                        Iterator it = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = obj;
                        }
                        this.getAppView().getSettings().setUsePreferredLogicalTypes(false);
                        break block60;
                    }
                    finally {
                        this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                    }
                }
                if (this.rbDistinct.isSelected()) {
                    Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    DistinctType selDistinctType = null;
                    if (this.typeElement != null) {
                        selDistinctType = (DistinctType)this.typeElement.getType();
                    }
                    if (selDistinctType != null) {
                        this.cbDatatype.setSelectedItem(selDistinctType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbStructured.isSelected()) {
                    Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    StructuredType selStructuredType = null;
                    if (this.typeElement != null) {
                        selStructuredType = (StructuredType)this.typeElement.getType();
                    }
                    if (selStructuredType != null) {
                        this.cbDatatype.setSelectedItem(selStructuredType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbCollection.isSelected()) {
                    Iterator it = this.getDesignObject().getDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    CollectionType selCollectionType = null;
                    if (this.typeElement != null) {
                        selCollectionType = (CollectionType)this.typeElement.getType();
                    }
                    if (selCollectionType != null) {
                        this.cbDatatype.setSelectedItem(selCollectionType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("updateDTComboBox() ", e);
            }
        }
    }

    private void updateDataTypePanelOptions() {
        block53: {
            try {
                this.ifDTSize.setText("");
                this.ifDTPrecision.setText("");
                this.ifDTScale.setText("");
                this.cbUnits.setSelectedIndex(0);
                this.cbUnits.setEnabled(false);
                this.dataTypePanel.remove(this.dataTypeAdditionalPanel);
                this.dataTypePanel.updateUI();
                this.dataTypeAdditionalPanel.removeAll();
                this.dataTypeAdditionalPanel.updateUI();
                this.sizeEnabled = false;
                this.precisionEnabled = false;
                Object obj = this.cbDatatype.getSelectedItem();
                if (obj == null) break block53;
                if (obj instanceof LogicalDatatype) {
                    String size;
                    LogicalDatatype selected = (LogicalDatatype)obj;
                    Map defaults = selected.getLTDefaultValues();
                    if (defaults != null) {
                        this.precisionDefaultValue = (String)defaults.get("precision_default_value");
                        this.sizeDefaultValue = (String)defaults.get("size_default_value");
                        this.scaleDefaultValue = (String)defaults.get("scale_default_value");
                    }
                    Map<String, String> m = selected.getToPhysical();
                    MDDataType datatype = selected.createDataType(this.typeElement.getStructuredType().getSelectedRDBMSType().getName(), m);
                    if (datatype instanceof MDImplicitSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.ifDTPrecision.setText(this.precisionDefaultValue);
                        this.ifDTPrecision.setEnabled(false);
                        this.ifDTScale.setText(this.scaleDefaultValue);
                        this.ifDTScale.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = false;
                    } else if (datatype instanceof MDPackedSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                        try {
                            if (datatype.getPrecision() != 0) {
                                this.ifDTPrecision.setText(datatype.getPrecisionStr());
                            }
                            if (this.isEditable()) {
                                this.ifDTPrecision.setEnabled(true);
                                if (this.ifDTPrecision.getText().trim().length() == 0) {
                                    this.ifDTPrecision.setText(this.precisionDefaultValue);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.getScale() != 0) {
                                this.ifDTScale.setText("" + datatype.getScale());
                            }
                            if (this.isEditable()) {
                                this.ifDTScale.setEnabled(true);
                                if (this.ifDTScale.getText().trim().length() == 0) {
                                    this.ifDTScale.setText(this.scaleDefaultValue);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    } else {
                        try {
                            if (datatype.hasSize()) {
                                if (!datatype.getSize().equalsIgnoreCase("0")) {
                                    if (this.isEditable()) {
                                        this.cbUnits.setEnabled(true);
                                    }
                                    size = datatype.getSize();
                                    String[] parts_n = size.split(" ");
                                    this.ifDTSize.setText(parts_n[0]);
                                    if (parts_n.length == 2) {
                                        this.cbUnits.setSelectedItem(parts_n[1]);
                                    }
                                } else {
                                    this.ifDTSize.setText(this.sizeDefaultValue);
                                    if (this.isEditable()) {
                                        this.cbUnits.setEnabled(true);
                                    }
                                }
                                if (this.isEditable()) {
                                    this.ifDTSize.setEnabled(true);
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.sizeAndUnitsPanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = true;
                                this.precisionEnabled = false;
                            } else {
                                this.ifDTSize.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTSize.setEnabled(false);
                        }
                        try {
                            if (datatype.hasPrecision()) {
                                if (datatype.getPrecision() != 0) {
                                    this.ifDTPrecision.setText(datatype.getPrecisionStr());
                                }
                                if (this.isEditable()) {
                                    this.ifDTPrecision.setEnabled(true);
                                    if (this.ifDTPrecision.getText().trim().length() == 0) {
                                        this.ifDTPrecision.setText(this.precisionDefaultValue);
                                    }
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                            } else {
                                this.ifDTPrecision.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.hasScale()) {
                                if (datatype.getScale() != 0) {
                                    this.ifDTScale.setText("" + datatype.getScale());
                                }
                                if (this.isEditable()) {
                                    this.ifDTScale.setEnabled(true);
                                    if (this.ifDTScale.getText().trim().length() == 0) {
                                        this.ifDTScale.setText(this.scaleDefaultValue);
                                    }
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                            } else {
                                this.ifDTScale.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    }
                    size = this.typeElement.getSize();
                    int precision = this.typeElement.getPrecision();
                    int scale = this.typeElement.getScale();
                    String units = this.typeElement.getUnits();
                    if (this.ifDTSize.isEnabled()) {
                        try {
                            this.ifDTSize.setText(size != null && size != "" ? size : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTPrecision.isEnabled()) {
                        try {
                            this.ifDTPrecision.setValue(precision > 0 ? Integer.valueOf(precision) : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTScale.isEnabled()) {
                        try {
                            this.ifDTScale.setValue(scale > 0 ? Integer.valueOf(scale) : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.cbUnits.isEnabled()) {
                        this.cbUnits.setSelectedItem(units);
                    }
                    break block53;
                }
                if (obj instanceof StructuredType) {
                    this.dataTypeAdditionalPanel.removeAll();
                    this.chbReference.setSelected(this.typeElement.isReference());
                    this.dataTypeAdditionalPanel.add(this.referencePanel);
                    this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                    this.dataTypePanel.updateUI();
                }
            }
            catch (Exception e) {
                LOGGER.error("updateLogicalDatatypeOptions() ", e);
            }
        }
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator allLogicalDatatypeIterator = this.getDesignObject().getDesign().getLogicalDatatypeSet().iterator();
        while (allLogicalDatatypeIterator.hasNext()) {
            LogicalDatatype ldt0 = (LogicalDatatype)allLogicalDatatypeIterator.next();
            List<LogicalDatatype> settingsPreferredLogicalDatatypeList = this.getAppView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype ldt1 : settingsPreferredLogicalDatatypeList) {
                if (!ldt0.getObjectID().equalsIgnoreCase(ldt1.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(ldt0);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator allDesignDomainsDesignIterator = this.getDesignObject().getDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            List<PreferredDomain> settingsPreferreddomainsList = this.getAppView().getSettings().getPreferredDomains();
            for (PreferredDomain pd : settingsPreferreddomainsList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) continue;
                this.currentPreferredDomainList.add(obj);
            }
        }
        return this.currentPreferredDomainList;
    }

    private void setDataType() {
        if (this.rbDomain.isSelected()) {
            this.typeElement.setType((Domain)this.cbDatatype.getSelectedItem());
        } else if (this.rbLogical.isSelected()) {
            int scaleDefaultValueInt;
            String pdf;
            this.typeElement.setType((LogicalDatatype)this.cbDatatype.getSelectedItem());
            Map defaults = new TreeMap();
            defaults.clear();
            if (this.cbDatatype.getSelectedItem() != null) {
                defaults = ((LogicalDatatype)this.cbDatatype.getSelectedItem()).getLTDefaultValues();
            }
            int precisionDefaultValueInt = (pdf = (String)defaults.get("precision_default_value")) != "" && pdf != null ? new Integer((String)defaults.get("precision_default_value")) : 0;
            String sdf = (String)defaults.get("size_default_value");
            int sizeDefaultValue = sdf != "" && sdf != null ? new Integer((String)defaults.get("size_default_value")) : 0;
            String scdf = (String)defaults.get("scale_default_value");
            int n = scaleDefaultValueInt = scdf != "" && scdf != null ? new Integer((String)defaults.get("scale_default_value")) : 0;
            if (this.sizeEnabled) {
                if (!this.ifDTSize.getText().equals(sizeDefaultValue)) {
                    this.typeElement.setSize(this.ifDTSize.getText());
                    if (this.cbUnits.getSelectedIndex() > 0) {
                        this.typeElement.setUnits((String)this.cbUnits.getSelectedItem());
                    }
                } else {
                    this.typeElement.setSize("");
                }
                this.typeElement.setPrecision(0);
                this.typeElement.setScale(0);
            } else if (this.precisionEnabled) {
                this.typeElement.setSize("");
                if (this.ifDTPrecision.getIntValue() != precisionDefaultValueInt || this.ifDTScale.getIntValue() != scaleDefaultValueInt) {
                    this.typeElement.setPrecision(this.ifDTPrecision.getIntValue());
                    this.typeElement.setScale(this.ifDTScale.getIntValue());
                } else {
                    this.typeElement.setPrecision(0);
                    this.typeElement.setScale(0);
                }
            } else {
                this.typeElement.setSize("");
                this.typeElement.setPrecision(0);
                this.typeElement.setScale(0);
            }
        } else if (this.rbDistinct.isSelected()) {
            this.typeElement.setType((DistinctType)this.cbDatatype.getSelectedItem());
        } else if (this.rbStructured.isSelected()) {
            this.typeElement.setType((StructuredType)this.cbDatatype.getSelectedItem());
            this.typeElement.setReference(this.chbReference.isSelected());
        } else if (this.rbCollection.isSelected()) {
            this.typeElement.setType((CollectionType)this.cbDatatype.getSelectedItem());
        }
    }

    @Override
    protected int getMinimumWidth() {
        return 630;
    }

    private class RBListener
    implements ItemListener {
        private RBListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                TypeElementPropertiesDialogEx.this.updateDataTypeComboBox();
                TypeElementPropertiesDialogEx.this.cbDatatype.updateUI();
            }
            catch (Exception e1) {
                LOGGER.error("RBListener", e1);
            }
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (TypeElementPropertiesDialogEx.this.rbDomain.isSelected() || TypeElementPropertiesDialogEx.this.rbLogical.isSelected()) {
                TypeElementPropertiesDialogEx.this.updateDataTypeComboBox();
            }
        }
    }
}

