/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.datatype.MDDataType;
import oracle.dbtools.crest.model.datatype.MDImplicitSized;
import oracle.dbtools.crest.model.datatype.MDPackedSized;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TempDataTypeObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.PreferredDomain;

public class SelectDataTypeDialog
extends CustomDialogML {
    private final String EMPTY_STRING = "";
    private final String INTERVAL_STRING = " ";
    public static final int MR_CANCEL = 0;
    public static final int MR_OK = 1;
    private final JPanel generalPanel;
    private DataTypeObject dtObject;
    private JPanel buttonPanel;
    private JRadioButton rbDomain;
    private JRadioButton rbLogical;
    private JRadioButton rbDistinct;
    private JRadioButton rbStructured;
    private JRadioButton rbCollection;
    private JComboBox cbDatatype;
    private JIntegerField ifDTPrecision;
    private JIntegerField ifDTScale;
    private JTextField ifDTSize;
    private JCheckBox chbReference;
    private LogicalDatatype currentSelectedLogical = null;
    private Domain currentSelectedDomain = null;
    private JPanel dataTypePanel;
    private JPanel dataTypeAdditionalPanel;
    private JPanel sizeAndUnitsPanel;
    private JPanel precisionAndScalePanel;
    private JPanel referencePanel;
    private JCheckBox chbUsePreferredList;
    private JComboBox cbUnits;
    private ActionListener cbDatatypeActionListener;
    private boolean initialUseLogicalTypePreferredList = true;
    private boolean initialUseDomainPreferredList = true;
    private List currentPreferredLogicalTypeList = new ArrayList();
    private List currentPreferredDomainList = new ArrayList();
    private LogicalDatatype selLogicalDatatype = null;
    private List<Domain> additionalPreferredDomains = new ArrayList<Domain>();
    private List<LogicalDatatype> additionalPreferredLogicalTypes = new ArrayList<LogicalDatatype>();
    private Object domainDefaultDataType;
    private Object logicalDefaultDataType;
    private boolean sizeEnabled = false;
    private boolean precisionEnabled = false;
    private JDialog dialog;
    protected JPanel buttonsPanel;
    public JButton btnOK;
    public JButton btnCancel;
    public JButton btnHelp;
    private String precisionDefaultValue;
    private String scaleDefaultValue;
    private String sizeDefaultValue;
    private int result = 0;
    protected boolean canExit = true;
    private CollectionType temp;
    private DataTypeObject object;
    private int dialogMinWidth = 420;
    private int dialogMinHeight = 190;
    private static final Logger LOGGER = new Logger(SelectDataTypeDialog.class);

    public SelectDataTypeDialog(ApplicationView view, DataTypeObject object) {
        super(view);
        this.object = object;
        this.generalPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[grow]0[]0"));
        this.initMainPanel();
        this.initButtonsPanel();
        this.dtObject = new TempDataTypeObject(object.getDesign());
        this.dtObject.setType(object.getType());
        this.dtObject.setSize(object.getSize());
        this.dtObject.setPrecision(object.getPrecision());
        this.dtObject.setScale(object.getScale());
        this.dtObject.setReference(object.isReference());
        DesignObject dataType = object.getType();
        if (dataType != null) {
            if (dataType instanceof LogicalDatatype) {
                this.rbLogical.setSelected(true);
            } else if (dataType instanceof Domain) {
                this.rbDomain.setSelected(true);
            } else if (dataType instanceof StructuredType) {
                this.rbStructured.setSelected(true);
            } else if (dataType instanceof CollectionType) {
                this.rbCollection.setSelected(true);
            } else if (dataType instanceof DistinctType) {
                this.rbDistinct.setSelected(true);
            }
        } else {
            this.rbLogical.setSelected(true);
        }
        this.generalPanel.add((Component)this.dataTypePanel, new CC().grow().wrap());
        this.generalPanel.add((Component)this.buttonsPanel, new CC().spanX().alignX("right"));
        this.add((Component)this.generalPanel, new CC().grow());
    }

    private void initMainPanel() {
        RBListener l = new RBListener();
        this.rbDomain = new JRadioButton("Domain");
        this.rbLogical = new JRadioButton("Logical");
        this.rbDistinct = new JRadioButton("Distinct");
        this.rbStructured = new JRadioButton("Structured");
        this.rbCollection = new JRadioButton("Collection");
        this.rbDomain.addItemListener(l);
        this.rbLogical.addItemListener(l);
        this.rbDistinct.addItemListener(l);
        this.rbStructured.addItemListener(l);
        this.rbCollection.addItemListener(l);
        ButtonGroup datatypeGroup = new ButtonGroup();
        datatypeGroup.add(this.rbDomain);
        datatypeGroup.add(this.rbLogical);
        datatypeGroup.add(this.rbDistinct);
        datatypeGroup.add(this.rbStructured);
        datatypeGroup.add(this.rbCollection);
        JPanel pnRadioGroup = new JPanel(new GridLayout(2, 3, 6, 0));
        pnRadioGroup.add(this.rbDomain);
        pnRadioGroup.add(this.rbLogical);
        pnRadioGroup.add(this.rbDistinct);
        pnRadioGroup.add(this.rbStructured);
        pnRadioGroup.add(this.rbCollection);
        this.sizeAndUnitsPanel = new JPanel((LayoutManager)new MigLayout("", "[110!][100!]", "0[]10[]0"));
        this.precisionAndScalePanel = new JPanel((LayoutManager)new MigLayout("", "[110!][100!]", "0[]10[]0"));
        this.referencePanel = new JPanel((LayoutManager)new MigLayout("", "[110!][100!]", "0[]0"));
        JLabel lbType = new JLabel("Type");
        this.cbDatatype = new JComboBox();
        this.cbDatatype.setMaximumRowCount(20);
        JLabel lbPreferred = new JLabel("Preferred");
        this.chbUsePreferredList = new JCheckBox();
        this.chbUsePreferredList.addActionListener(new UsePreferredListListener());
        JLabel lbSize = new JLabel("Size");
        this.ifDTSize = new JTextField();
        JLabel lbUnits = new JLabel("Units");
        lbUnits.setHorizontalAlignment(2);
        this.cbUnits = new JComboBox<String>(LogicalDatatype.UNITS);
        this.sizeAndUnitsPanel.add(lbSize);
        this.sizeAndUnitsPanel.add((Component)this.ifDTSize, new CC().grow().wrap());
        this.sizeAndUnitsPanel.add(lbUnits);
        this.sizeAndUnitsPanel.add((Component)this.cbUnits, new CC().width("60!"));
        this.cbDatatype.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SelectDataTypeDialog.this.updateDataTypePanelOptions();
                }
            }
        });
        JLabel lbPrecision = new JLabel("Precision");
        lbPrecision.setHorizontalAlignment(2);
        this.ifDTPrecision = new JIntegerField();
        this.ifDTPrecision.setAllowAsterisks(true);
        JLabel lbScale = new JLabel("Scale");
        lbScale.setHorizontalAlignment(2);
        this.ifDTScale = new JIntegerField();
        this.precisionAndScalePanel.add(lbPrecision);
        this.precisionAndScalePanel.add((Component)this.ifDTPrecision, new CC().grow().wrap());
        this.precisionAndScalePanel.add(lbScale);
        this.precisionAndScalePanel.add((Component)this.ifDTScale, new CC().grow());
        this.chbReference = new JCheckBox("Reference");
        this.referencePanel.add(new JLabel());
        this.referencePanel.add(this.chbReference);
        this.dataTypePanel = new JPanel((LayoutManager)new MigLayout("", "[110!][]", "0[]10[]0"));
        this.dataTypePanel.setBorder(BorderFactory.createTitledBorder("Data type"));
        this.dataTypePanel.add(new JLabel());
        this.dataTypePanel.add((Component)pnRadioGroup, new CC().spanX().wrap());
        this.dataTypePanel.add(lbType);
        this.dataTypePanel.add((Component)this.cbDatatype, new CC().width("180!"));
        this.dataTypePanel.add(lbPreferred);
        this.dataTypePanel.add((Component)this.chbUsePreferredList, new CC().wrap());
        this.dataTypeAdditionalPanel = new JPanel((LayoutManager)new MigLayout("", "0[110!][120!]0", "0[]0[]0"));
        this.add((Component)this.dataTypePanel, new CC().grow().wrap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataTypeComboBox() {
        block60: {
            try {
                this.cbDatatype.removeAllItems();
                this.dataTypePanel.updateUI();
                DesignObject dataType = this.object.getType();
                if (this.rbDomain.isSelected()) {
                    Domain selDomain = null;
                    if (dataType instanceof Domain) {
                        selDomain = (Domain)dataType;
                    }
                    if (selDomain == null) {
                        selDomain = this.getApplicationView().getCurrentDesign().getDomainSet().getDefaultDomain();
                    }
                    if (this.initialUseDomainPreferredList) {
                        this.chbUsePreferredList.setSelected(this.getApplicationView().getSettings().isUsePreferredDomains());
                        this.initialUseDomainPreferredList = false;
                    }
                    if (this.chbUsePreferredList.isSelected()) {
                        ArrayList<Domain> allPreferredDomains = new ArrayList<Domain>();
                        List pDomains = this.getCurrentPreferredDomains();
                        allPreferredDomains.addAll(pDomains);
                        if (pDomains.size() > 0) {
                            for (Domain domain : pDomains) {
                                if (selDomain == null) continue;
                                if (!domain.getObjectID().equalsIgnoreCase(selDomain.getObjectID())) {
                                    if (this.additionalPreferredDomains.contains(selDomain)) continue;
                                    this.additionalPreferredDomains.add(selDomain);
                                    continue;
                                }
                                if (this.additionalPreferredDomains.contains(selDomain)) {
                                    this.additionalPreferredDomains.remove(selDomain);
                                }
                                break;
                            }
                        } else if (!this.additionalPreferredDomains.contains(selDomain)) {
                            this.additionalPreferredDomains.add(selDomain);
                        }
                        allPreferredDomains.addAll(this.additionalPreferredDomains);
                        boolean currentAdded = false;
                        for (Object e : allPreferredDomains) {
                            if (e == this.currentSelectedDomain) {
                                currentAdded = true;
                            }
                            this.cbDatatype.addItem(e);
                            if (this.domainDefaultDataType == null) {
                                this.domainDefaultDataType = e;
                            }
                            if (!e.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = e;
                        }
                        if (this.currentSelectedDomain != null && !currentAdded) {
                            this.cbDatatype.addItem(this.currentSelectedDomain);
                        }
                        this.getApplicationView().getSettings().setUsePreferredDomains(true);
                    } else {
                        Iterator it = this.getApplicationView().getCurrentDesign().getDomainSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.domainDefaultDataType = obj;
                        }
                        this.getApplicationView().getSettings().setUsePreferredDomains(false);
                    }
                    this.cbDatatype.setSelectedItem(selDomain);
                    break block60;
                }
                if (this.rbLogical.isSelected()) {
                    try {
                        this.selLogicalDatatype = null;
                        if (dataType instanceof LogicalDatatype) {
                            this.selLogicalDatatype = (LogicalDatatype)dataType;
                        }
                        if (this.initialUseLogicalTypePreferredList) {
                            this.chbUsePreferredList.setSelected(this.getApplicationView().getSettings().isUsePreferredLogicalTypes());
                            this.initialUseLogicalTypePreferredList = false;
                        }
                        if (this.chbUsePreferredList.isSelected()) {
                            ArrayList<LogicalDatatype> allPreferredLogicalDatatypes = new ArrayList<LogicalDatatype>();
                            List pLogicalDatatypes = this.getCurrentPreferredLogicalDatatypes();
                            allPreferredLogicalDatatypes.addAll(pLogicalDatatypes);
                            if (pLogicalDatatypes.size() > 0) {
                                for (LogicalDatatype ldt : pLogicalDatatypes) {
                                    if (this.selLogicalDatatype == null) continue;
                                    if (!ldt.getObjectID().equalsIgnoreCase(this.selLogicalDatatype.getObjectID())) {
                                        if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) continue;
                                        this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                                        continue;
                                    }
                                    if (this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                        this.additionalPreferredLogicalTypes.remove(this.selLogicalDatatype);
                                    }
                                    break;
                                }
                            } else if (!this.additionalPreferredLogicalTypes.contains(this.selLogicalDatatype)) {
                                this.additionalPreferredLogicalTypes.add(this.selLogicalDatatype);
                            }
                            allPreferredLogicalDatatypes.addAll(this.additionalPreferredLogicalTypes);
                            boolean currentAdded = false;
                            for (Object e : allPreferredLogicalDatatypes) {
                                if (e == this.currentSelectedLogical) {
                                    currentAdded = true;
                                }
                                this.cbDatatype.addItem(e);
                                if (this.logicalDefaultDataType == null) {
                                    this.logicalDefaultDataType = e;
                                }
                                if (!e.toString().equalsIgnoreCase("unknown")) continue;
                                this.logicalDefaultDataType = e;
                            }
                            if (this.currentSelectedLogical != null && !currentAdded) {
                                this.cbDatatype.addItem(this.currentSelectedLogical);
                            }
                            this.getApplicationView().getSettings().setUsePreferredLogicalTypes(true);
                            break block60;
                        }
                        Iterator it = this.getApplicationView().getCurrentDesign().getLogicalDatatypeSet().iterator();
                        while (it.hasNext()) {
                            Object obj = it.next();
                            this.cbDatatype.addItem(obj);
                            if (!obj.toString().equalsIgnoreCase("unknown")) continue;
                            this.logicalDefaultDataType = obj;
                        }
                        this.getApplicationView().getSettings().setUsePreferredLogicalTypes(false);
                        break block60;
                    }
                    finally {
                        if (this.selLogicalDatatype != null) {
                            this.cbDatatype.setSelectedItem(this.selLogicalDatatype);
                        } else {
                            this.cbDatatype.setSelectedItem(this.logicalDefaultDataType);
                        }
                    }
                }
                if (this.rbDistinct.isSelected()) {
                    Iterator it = this.getApplicationView().getCurrentDesign().getDataTypesDesign().getDistinctTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    DistinctType selDistinctType = null;
                    if (dataType instanceof DistinctType) {
                        selDistinctType = (DistinctType)dataType;
                    }
                    if (selDistinctType != null) {
                        this.cbDatatype.setSelectedItem(selDistinctType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbStructured.isSelected()) {
                    Iterator it = this.getApplicationView().getCurrentDesign().getDataTypesDesign().getStructuredTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    StructuredType selStructuredType = null;
                    if (dataType instanceof StructuredType) {
                        selStructuredType = (StructuredType)dataType;
                    }
                    if (selStructuredType != null) {
                        this.cbDatatype.setSelectedItem(selStructuredType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                } else if (this.rbCollection.isSelected()) {
                    Iterator it = this.getApplicationView().getCurrentDesign().getDataTypesDesign().getCollectionTypeSet().iterator();
                    Object first = null;
                    while (it.hasNext()) {
                        Object obj = it.next();
                        if (first == null) {
                            first = obj;
                        }
                        this.cbDatatype.addItem(obj);
                    }
                    CollectionType selCollectionType = null;
                    if (dataType instanceof CollectionType) {
                        selCollectionType = (CollectionType)dataType;
                    }
                    if (selCollectionType != null) {
                        this.cbDatatype.setSelectedItem(selCollectionType);
                    } else {
                        this.cbDatatype.setSelectedItem(first);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("SelectDataTypeDialog.updateDTComboBox() ", e);
            }
        }
    }

    private void updateDataTypePanelOptions() {
        try {
            this.ifDTSize.setText("");
            this.ifDTPrecision.setText("");
            this.ifDTScale.setText("");
            this.cbUnits.setSelectedIndex(0);
            this.cbUnits.setEnabled(false);
            this.dataTypePanel.remove(this.dataTypeAdditionalPanel);
            this.dataTypePanel.updateUI();
            this.dataTypeAdditionalPanel.removeAll();
            this.dataTypeAdditionalPanel.updateUI();
            this.sizeEnabled = false;
            this.precisionEnabled = false;
            Object obj = this.cbDatatype.getSelectedItem();
            if (obj != null) {
                if (obj instanceof LogicalDatatype) {
                    String[] parts_n;
                    String size;
                    LogicalDatatype selected = (LogicalDatatype)obj;
                    Map defaults = selected.getLTDefaultValues();
                    if (defaults != null) {
                        this.precisionDefaultValue = (String)defaults.get("precision_default_value");
                        this.sizeDefaultValue = (String)defaults.get("size_default_value");
                        this.scaleDefaultValue = (String)defaults.get("scale_default_value");
                    }
                    Map<String, String> m = selected.getToPhysical();
                    MDDataType datatype = null;
                    datatype = selected.createDataType(this.object.getDesign().getSelectedRDBMSType().getName(), m);
                    if (datatype instanceof MDImplicitSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.ifDTPrecision.setText(this.precisionDefaultValue);
                        this.ifDTPrecision.setEnabled(false);
                        this.ifDTScale.setText(this.scaleDefaultValue);
                        this.ifDTScale.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = false;
                        this.dialogMinHeight = 190;
                    } else if (datatype instanceof MDPackedSized) {
                        this.ifDTSize.setText(this.sizeDefaultValue);
                        this.ifDTSize.setEnabled(false);
                        this.dataTypeAdditionalPanel.removeAll();
                        this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                        this.dataTypeAdditionalPanel.updateUI();
                        this.sizeEnabled = false;
                        this.precisionEnabled = true;
                        this.dialogMinHeight = 250;
                        try {
                            if (datatype.getPrecision() != 0) {
                                this.ifDTPrecision.setText(datatype.getPrecisionStr());
                            }
                            if (this.isEditable()) {
                                this.ifDTPrecision.setEnabled(true);
                                if (this.ifDTPrecision.getText().trim().length() == 0) {
                                    this.ifDTPrecision.setText(this.precisionDefaultValue);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.getScale() != 0) {
                                this.ifDTScale.setText("" + datatype.getScale());
                            }
                            if (this.isEditable()) {
                                this.ifDTScale.setEnabled(true);
                                if (this.ifDTScale.getText().trim().length() == 0) {
                                    this.ifDTScale.setText(this.scaleDefaultValue);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    } else {
                        try {
                            if (datatype.hasSize()) {
                                if (!datatype.getSize().equalsIgnoreCase("0")) {
                                    if (this.isEditable()) {
                                        this.cbUnits.setEnabled(true);
                                    }
                                    size = datatype.getSize();
                                    String[] parts_n2 = size.split(" ");
                                    this.ifDTSize.setText(parts_n2[0]);
                                    if (parts_n2.length == 2) {
                                        this.cbUnits.setSelectedItem(parts_n2[1]);
                                    }
                                } else {
                                    this.ifDTSize.setText(this.sizeDefaultValue);
                                    if (this.isEditable()) {
                                        this.cbUnits.setEnabled(true);
                                    }
                                }
                                if (this.isEditable()) {
                                    this.ifDTSize.setEnabled(true);
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.sizeAndUnitsPanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = true;
                                this.precisionEnabled = false;
                                this.dialogMinHeight = 250;
                            } else {
                                this.ifDTSize.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTSize.setEnabled(false);
                        }
                        try {
                            if (datatype.hasPrecision()) {
                                if (datatype.getPrecision() != 0) {
                                    this.ifDTPrecision.setText(datatype.getPrecisionStr());
                                }
                                if (this.isEditable()) {
                                    this.ifDTPrecision.setEnabled(true);
                                    if (this.ifDTPrecision.getText().trim().length() == 0) {
                                        this.ifDTPrecision.setText(this.precisionDefaultValue);
                                    }
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                                this.dialogMinHeight = 250;
                            } else {
                                this.ifDTPrecision.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTPrecision.setEnabled(false);
                        }
                        try {
                            if (datatype.hasScale()) {
                                if (datatype.getScale() != 0) {
                                    this.ifDTScale.setText("" + datatype.getScale());
                                }
                                if (this.isEditable()) {
                                    this.ifDTScale.setEnabled(true);
                                    if (this.ifDTScale.getText().trim().length() == 0) {
                                        this.ifDTScale.setText(this.scaleDefaultValue);
                                    }
                                }
                                this.dataTypeAdditionalPanel.removeAll();
                                this.dataTypeAdditionalPanel.add(this.precisionAndScalePanel);
                                this.dataTypeAdditionalPanel.updateUI();
                                this.sizeEnabled = false;
                                this.precisionEnabled = true;
                                this.dialogMinHeight = 250;
                            } else {
                                this.ifDTScale.setEnabled(false);
                            }
                        }
                        catch (Exception e) {
                            this.ifDTScale.setEnabled(false);
                        }
                        this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                        this.dataTypePanel.updateUI();
                    }
                    size = this.object.getSize();
                    String precision = Integer.toString(this.object.getPrecision());
                    String scale = Integer.toString(this.object.getScale());
                    String units = "";
                    if (size != null && (parts_n = size.split(" ")).length == 2) {
                        size = parts_n[0];
                        units = parts_n[1];
                    }
                    if (this.ifDTSize.isEnabled()) {
                        try {
                            this.ifDTSize.setText(size != null && size != "" ? size : null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTPrecision.isEnabled()) {
                        try {
                            this.ifDTPrecision.setValue((long)Integer.parseInt(precision != null && precision != "" ? precision : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.ifDTScale.isEnabled()) {
                        try {
                            this.ifDTScale.setValue((long)Integer.parseInt(scale != null && scale != "" ? scale : null));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.cbUnits.isEnabled()) {
                        this.cbUnits.setSelectedItem(units);
                    }
                } else if (obj instanceof StructuredType) {
                    this.dataTypeAdditionalPanel.removeAll();
                    this.chbReference.setSelected(this.object.isReference());
                    this.dataTypeAdditionalPanel.add(this.referencePanel);
                    this.dataTypePanel.add((Component)this.dataTypeAdditionalPanel, new CC().spanX(2).grow().wrap());
                    this.dataTypePanel.updateUI();
                    this.dialogMinHeight = 200;
                } else {
                    this.dialogMinHeight = 190;
                }
            }
            this.getDialog().pack();
        }
        catch (Exception e) {
            LOGGER.error("SelectDataTypeDialog.updateLogicalDatatypeOptions() ", e);
        }
    }

    private void initButtonsPanel() {
        this.buttonsPanel = new JPanel(new FlowLayout(2));
        this.btnOK = new JButton(Messages.getString("SelectDataTypeDialog.OK"));
        this.btnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnOK.addActionListener(new OKAction());
        this.btnOK.setMnemonic(65);
        this.buttonsPanel.add(this.btnOK);
        this.btnCancel = new JButton(Messages.getString("SelectDataTypeDialog.Cancel"));
        this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnCancel.addActionListener(new CancelAction());
        this.btnCancel.setMnemonic(67);
        this.buttonsPanel.add(this.btnCancel);
        this.btnHelp = new JButton(this.getHelpAction());
        this.btnHelp.setMnemonic(72);
        this.btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonsPanel.add(this.btnHelp);
    }

    public DataTypeObject getDataType() {
        return this.dtObject;
    }

    public int showDialog() {
        this.getDialog().setVisible(true);
        return this.result;
    }

    private List getCurrentPreferredDomains() {
        this.currentPreferredDomainList.clear();
        Iterator allDesignDomainsDesignIterator = this.getApplicationView().getCurrentDesign().getDomainSet().iterator();
        while (allDesignDomainsDesignIterator.hasNext()) {
            Domain obj = (Domain)allDesignDomainsDesignIterator.next();
            PreferredDomain pd0 = new PreferredDomain();
            pd0.setObjectId(obj.getObjectID());
            List<PreferredDomain> settingsPreferreddomainsList = this.getApplicationView().getSettings().getPreferredDomains();
            for (PreferredDomain pd : settingsPreferreddomainsList) {
                if (!pd0.getObjectId().equalsIgnoreCase(pd.getObjectId())) continue;
                this.currentPreferredDomainList.add(obj);
            }
        }
        return this.currentPreferredDomainList;
    }

    private List getCurrentPreferredLogicalDatatypes() {
        this.currentPreferredLogicalTypeList.clear();
        Iterator allLogicalDatatypeIterator = this.getApplicationView().getCurrentDesign().getLogicalDatatypeSet().iterator();
        while (allLogicalDatatypeIterator.hasNext()) {
            LogicalDatatype ldt0 = (LogicalDatatype)allLogicalDatatypeIterator.next();
            List<LogicalDatatype> settingsPreferredLogicalDatatypeList = this.getApplicationView().getSettings().getPreferredLogicaltypes();
            for (LogicalDatatype ldt1 : settingsPreferredLogicalDatatypeList) {
                if (!ldt0.getObjectID().equalsIgnoreCase(ldt1.getObjectID())) continue;
                this.currentPreferredLogicalTypeList.add(ldt0);
            }
        }
        return this.currentPreferredLogicalTypeList;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectDataTypeDialog.SelectDataType"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "DATATYPE_DIALOG";
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    private class RBListener
    implements ItemListener {
        private RBListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                SelectDataTypeDialog.this.updateDataTypeComboBox();
                SelectDataTypeDialog.this.cbDatatype.updateUI();
            }
            catch (Exception e1) {
                LOGGER.error("SelectDataTypeDialog.RBListener", e1);
            }
        }
    }

    private class UsePreferredListListener
    implements ActionListener {
        private UsePreferredListListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectDataTypeDialog.this.rbDomain.isSelected() || SelectDataTypeDialog.this.rbLogical.isSelected()) {
                SelectDataTypeDialog.this.updateDataTypeComboBox();
            }
        }
    }

    protected class OKAction
    implements ActionListener {
        protected OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDataTypeDialog.this.dtObject.setType((DesignObject)SelectDataTypeDialog.this.cbDatatype.getSelectedItem());
            if (SelectDataTypeDialog.this.rbLogical.isSelected()) {
                if (SelectDataTypeDialog.this.ifDTSize.getText() != null && SelectDataTypeDialog.this.ifDTSize.getText().trim() != "") {
                    SelectDataTypeDialog.this.dtObject.setSize(SelectDataTypeDialog.this.ifDTSize.getText());
                }
                if (SelectDataTypeDialog.this.ifDTPrecision.getText() != null && SelectDataTypeDialog.this.ifDTPrecision.getText().trim() != "") {
                    try {
                        SelectDataTypeDialog.this.dtObject.setPrecision(Integer.parseInt(SelectDataTypeDialog.this.ifDTPrecision.getText()));
                    }
                    catch (NumberFormatException ex) {
                        SelectDataTypeDialog.this.dtObject.setPrecision(0);
                    }
                }
                if (SelectDataTypeDialog.this.ifDTScale.getText() != null && SelectDataTypeDialog.this.ifDTScale.getText().trim() != "") {
                    try {
                        SelectDataTypeDialog.this.dtObject.setScale(Integer.parseInt(SelectDataTypeDialog.this.ifDTScale.getText()));
                    }
                    catch (NumberFormatException ex) {
                        SelectDataTypeDialog.this.dtObject.setScale(0);
                    }
                }
                SelectDataTypeDialog.this.dtObject.setReference(false);
            } else if (SelectDataTypeDialog.this.rbDomain.isSelected()) {
                SelectDataTypeDialog.this.dtObject.setSize("");
                SelectDataTypeDialog.this.dtObject.setPrecision(0);
                SelectDataTypeDialog.this.dtObject.setScale(0);
                SelectDataTypeDialog.this.dtObject.setReference(false);
            } else if (SelectDataTypeDialog.this.rbDistinct.isSelected()) {
                SelectDataTypeDialog.this.dtObject.setSize("");
                SelectDataTypeDialog.this.dtObject.setPrecision(0);
                SelectDataTypeDialog.this.dtObject.setScale(0);
                SelectDataTypeDialog.this.dtObject.setReference(false);
            } else if (SelectDataTypeDialog.this.rbStructured.isSelected()) {
                SelectDataTypeDialog.this.dtObject.setSize("");
                SelectDataTypeDialog.this.dtObject.setPrecision(0);
                SelectDataTypeDialog.this.dtObject.setScale(0);
                SelectDataTypeDialog.this.dtObject.setReference(SelectDataTypeDialog.this.chbReference.isSelected());
            } else if (SelectDataTypeDialog.this.rbCollection.isSelected()) {
                SelectDataTypeDialog.this.dtObject.setSize("");
                SelectDataTypeDialog.this.dtObject.setPrecision(0);
                SelectDataTypeDialog.this.dtObject.setScale(0);
                SelectDataTypeDialog.this.dtObject.setReference(false);
            }
            SelectDataTypeDialog.this.result = 1;
            SelectDataTypeDialog.this.close();
        }
    }

    protected class CancelAction
    implements ActionListener {
        protected CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDataTypeDialog.this.result = 0;
            SelectDataTypeDialog.this.close();
        }
    }
}

