/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.datatypes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.datatypes.Messages;
import oracle.dbtools.crest.swingui.editor.datatypes.SelectDataTypeDialog;
import oracle.dbtools.crest.util.gui.swing.SQLSyntaxTextArea;

public class MethodPropertiesDialogEx
extends AbstractPropertiesDialog {
    private Method method;
    private JCheckBox chConstructor;
    private JCheckBox chOverriding;
    private JComboBox cbOverrided;
    private JTextField tfReturnType;
    private JButton bnSelectReturnType;
    private JButton bnRemoveReturnType;
    private MethodParam temp;
    private JTable pTable;
    private List pList;
    private int counter = 0;
    private JPanel pnParameters;
    private JPanel pnBody;
    private SQLSyntaxTextArea taBody;
    private JButton btnRemove;
    private JButton btnMoveUp;
    private JButton btnMoveDown;

    public MethodPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
    }

    public MethodPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("MethodPropertiesDialogEx.MethodProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof Method) {
            this.method = (Method)object;
            this.initDefaults(false);
            this.chConstructor.setSelected(this.method.isConstructor());
            this.chOverriding.setSelected(this.method.isOverriding());
            this.fillComboItems(this.getInheritedMethods(), this.cbOverrided, true);
            this.cbOverrided.setSelectedItem(this.method.getOverridedMethod());
            MethodParam returnValue = this.method.getReturnValue();
            if (returnValue != null) {
                this.temp = new MethodParam(this.method.getDesignPart());
                returnValue.copyDataType(this.temp);
                this.tfReturnType.setText(returnValue.getDataType());
            } else {
                this.tfReturnType.setText(Messages.getString("MethodPropertiesDialogEx.NoReturn"));
                this.bnRemoveReturnType.setEnabled(false);
            }
            for (MethodParam mp : this.method.getParameters()) {
                MethodParam mpC = new MethodParam(mp.getDesignPart());
                mp.copyDataType(mpC);
                mpC.setObjectID(mp.getObjectID());
                this.pList.add(mpC);
            }
            this.taBody.setText(this.method.getBody());
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        MethodPropertiesDialogEx.stopCellEditing(this.pTable);
        MethodPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.method.setName(this.tfName.getText());
        this.method.setComment(this.taComments.getText());
        this.method.setNotes(this.taNotes.getText());
        this.method.setConstructor(this.chConstructor.isSelected());
        this.method.setOverriding(this.chOverriding.isSelected());
        this.method.setOverridedMethod((Method)this.cbOverrided.getSelectedItem());
        this.method.setBody(this.taBody.getText());
        this.method.setReturnValue(this.temp);
        Object[] originalParams = this.method.getParameters().toArray();
        this.method.clearParams();
        boolean reorder = originalParams.length != this.pList.size();
        Iterator it = this.pList.iterator();
        int k = 0;
        while (it.hasNext()) {
            MethodParam param = (MethodParam)it.next();
            if (!reorder) {
                MethodParam originalParam = (MethodParam)originalParams[k];
                if (!param.getObjectID().equals(originalParam.getObjectID())) {
                    reorder = true;
                }
            }
            this.method.addParameter(k, param);
            ++k;
        }
        if (reorder) {
            this.method.fireParamsOrderChanged();
        }
        this.method.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.method.setProperty(dp.getName(), dp.getValue());
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getParametersPanel());
        this.addToTree(root, this.getBodyPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "METHOD_PROPERTIES_DIALOG";
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(this.generalPanelName);
            this.contentPanel = new JPanel((LayoutManager)new MigLayout("", "[120!][grow, 120:120:]", "[]10[]"));
            this.pnGeneral.add((Component)this.contentPanel, "Center");
            this.lbName = new JLabel(LB_NAME);
            this.tfName = new JTextField();
            this.tfName.setEnabled(this.isEditable());
        }
        return this.pnGeneral;
    }

    private void initGeneral() {
        this.chConstructor = new JCheckBox(LB_CONSTRUCTOR);
        this.chConstructor.setEnabled(this.isEditable());
        this.chOverriding = new JCheckBox(LB_OVERRIDING);
        this.chOverriding.setEnabled(this.isEditable());
        JLabel lbOverrided = new JLabel(LB_OVERRIDED_METHOD);
        this.cbOverrided = new JComboBox();
        this.cbOverrided.setEnabled(this.isEditable());
        JLabel lbReturnType = new JLabel(LB_RETURN_TYPE);
        this.tfReturnType = new JTextField();
        this.tfReturnType.setDisabledTextColor(Color.BLACK);
        this.tfReturnType.setEnabled(false);
        this.bnSelectReturnType = new JButton("...");
        this.bnSelectReturnType.setEnabled(this.isEditable());
        this.bnSelectReturnType.setToolTipText(Messages.getString("MethodPropertiesDialogEx.SelectDataType"));
        this.bnSelectReturnType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MethodPropertiesDialogEx.this.temp == null) {
                    MethodPropertiesDialogEx.this.temp = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                }
                SelectDataTypeDialog datatypeDialog = new SelectDataTypeDialog(MethodPropertiesDialogEx.this.getAppView(), MethodPropertiesDialogEx.this.temp);
                int result = datatypeDialog.showDialog();
                DataTypeObject dt = datatypeDialog.getDataType();
                if (result == 1) {
                    MethodPropertiesDialogEx.this.temp.setType(dt.getType());
                    MethodPropertiesDialogEx.this.temp.setSize(dt.getSize());
                    MethodPropertiesDialogEx.this.temp.setPrecision(dt.getPrecision());
                    MethodPropertiesDialogEx.this.temp.setScale(dt.getScale());
                    MethodPropertiesDialogEx.this.temp.setReference(dt.isReference());
                    MethodPropertiesDialogEx.this.tfReturnType.setText(MethodPropertiesDialogEx.this.temp.getDataType());
                    MethodPropertiesDialogEx.this.bnRemoveReturnType.setEnabled(true);
                }
            }
        });
        this.bnRemoveReturnType = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON"));
        this.bnRemoveReturnType.setToolTipText(BTN_REMOVE);
        this.bnRemoveReturnType.setEnabled(this.isEditable());
        this.bnRemoveReturnType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MethodPropertiesDialogEx.this.temp = null;
                MethodPropertiesDialogEx.this.tfReturnType.setText(Messages.getString("MethodPropertiesDialogEx.NoReturn"));
                MethodPropertiesDialogEx.this.bnRemoveReturnType.setEnabled(false);
            }
        });
        JPanel jp = new JPanel((LayoutManager)new MigLayout("", "0[100!][100!]", "0[]0"));
        jp.add(this.chConstructor);
        jp.add(this.chOverriding);
        JPanel jp1 = new JPanel((LayoutManager)new MigLayout("", "0[grow, 120:120:]0[20!]0[20!]0", "0[]0"));
        jp1.add((Component)this.tfReturnType, new CC().growX());
        jp1.add((Component)this.bnSelectReturnType, new CC().width("20!"));
        jp1.add((Component)this.bnRemoveReturnType, new CC().width("20!"));
        this.contentPanel.add(this.lbName);
        this.contentPanel.add((Component)this.tfName, new CC().span(new int[]{3}).growX().wrap());
        this.contentPanel.add((Component)jp, new CC().wrap());
        this.contentPanel.add(lbOverrided);
        this.contentPanel.add((Component)this.cbOverrided, new CC().span(new int[]{3}).growX().wrap());
        this.contentPanel.add(lbReturnType);
        this.contentPanel.add((Component)jp1, new CC().growX().wrap());
    }

    private Object[] getInheritedMethods() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (StructuredType st = this.method.getStructuredType().getParentType(); st != null; st = st.getParentType()) {
            for (int i = 0; i < st.getMethods().length; ++i) {
                result.add(st.getMethod(i));
            }
        }
        return result.toArray();
    }

    protected String generateName() {
        String name = Messages.getString("MethodPropertiesDialogEx.Arg");
        int newNumber = 0;
        int lastNumber = this.pList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        String attrName = name.concat(Integer.toString(newNumber));
        while (this.attributeExists(attrName)) {
            newNumber = ++this.counter;
            attrName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return attrName;
    }

    private boolean attributeExists(String name) {
        for (int i = 0; i < this.pList.size(); ++i) {
            MethodParam param = (MethodParam)this.pList.get(i);
            if (!name.equalsIgnoreCase(param.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean moveToIndex(DesignObject object, int index) {
        if (this.pList.contains(object) && this.pList.size() > index && index >= 0) {
            this.pList.remove(object);
            this.pList.add(index, object);
            return true;
        }
        return false;
    }

    protected JPanel getParametersPanel() {
        if (this.pnParameters == null) {
            this.pnParameters = this.createPage(Messages.getString("MethodPropertiesDialogEx.Parameters"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new ParamModel());
            this.pTable.setSelectionMode(0);
            DatatypeEditorRenderer re = new DatatypeEditorRenderer();
            this.pTable.getColumnModel().getColumn(1).setCellRenderer(re);
            this.pTable.getColumnModel().getColumn(1).setCellEditor(re);
            this.pTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int row = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (row != -1) {
                            MethodPropertiesDialogEx.this.btnRemove.setEnabled(true);
                            MethodPropertiesDialogEx.this.btnMoveUp.setEnabled(true);
                            MethodPropertiesDialogEx.this.btnMoveDown.setEnabled(true);
                        } else {
                            MethodPropertiesDialogEx.this.btnRemove.setEnabled(false);
                            MethodPropertiesDialogEx.this.btnMoveUp.setEnabled(false);
                            MethodPropertiesDialogEx.this.btnMoveDown.setEnabled(false);
                        }
                    }
                }
            });
            DefaultCellEditor singleclick = new DefaultCellEditor(new JTextField());
            singleclick.setClickCountToStart(1);
            this.pTable.getColumnModel().getColumn(0).setCellEditor(singleclick);
            this.pTable.getColumnModel().getColumn(2).setCellEditor(singleclick);
            JScrollPane scrollpane = new JScrollPane(this.pTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MethodParam param = new MethodParam(MethodPropertiesDialogEx.this.method.getDesignPart());
                        param.setName(MethodPropertiesDialogEx.this.generateName());
                        param.setDesign(MethodPropertiesDialogEx.this.method.getDesign());
                        MethodPropertiesDialogEx.this.pList.add(param);
                        MethodPropertiesDialogEx.this.pTable.updateUI();
                        int lastRow = MethodPropertiesDialogEx.this.pTable.convertRowIndexToView(MethodPropertiesDialogEx.this.pTable.getModel().getRowCount() - 1);
                        MethodPropertiesDialogEx.this.pTable.setRowSelectionInterval(lastRow, lastRow);
                        MethodPropertiesDialogEx.this.pTable.scrollRectToVisible(new Rectangle(MethodPropertiesDialogEx.this.pTable.getCellRect(lastRow, 0, true)));
                    }
                });
                this.btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                this.btnRemove.setEnabled(false);
                this.btnRemove.setToolTipText(BTN_REMOVE);
                this.btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (objectNumber != -1 && MethodPropertiesDialogEx.this.pList.size() > 0 && objectNumber < MethodPropertiesDialogEx.this.pList.size()) {
                            MethodPropertiesDialogEx.this.pList.remove(objectNumber);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                            if (MethodPropertiesDialogEx.this.pList.size() > 0) {
                                int lastRow = MethodPropertiesDialogEx.this.pTable.convertRowIndexToView(MethodPropertiesDialogEx.this.pTable.getModel().getRowCount() - 1);
                                MethodPropertiesDialogEx.this.pTable.setRowSelectionInterval(lastRow, lastRow);
                                MethodPropertiesDialogEx.this.pTable.scrollRectToVisible(new Rectangle(MethodPropertiesDialogEx.this.pTable.getCellRect(lastRow, 0, true)));
                            } else {
                                MethodPropertiesDialogEx.this.btnRemove.setEnabled(false);
                                MethodPropertiesDialogEx.this.btnMoveUp.setEnabled(false);
                                MethodPropertiesDialogEx.this.btnMoveDown.setEnabled(false);
                            }
                        }
                    }
                });
                this.btnMoveUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
                this.btnMoveUp.setEnabled(false);
                this.btnMoveUp.setToolTipText(BTN_MOVE_UP);
                this.btnMoveUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (objectNumber > -1 && objectNumber < MethodPropertiesDialogEx.this.pList.size()) {
                            DesignObject obj = (DesignObject)MethodPropertiesDialogEx.this.pList.get(objectNumber);
                            MethodPropertiesDialogEx.this.moveToIndex(obj, objectNumber - 1);
                            MethodPropertiesDialogEx.this.pTable.changeSelection(objectNumber - 1, 0, false, false);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                this.btnMoveDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
                this.btnMoveDown.setEnabled(false);
                this.btnMoveDown.setToolTipText(BTN_MOVE_DOWN);
                this.btnMoveDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                        if (objectNumber > -1 && objectNumber < MethodPropertiesDialogEx.this.pList.size()) {
                            DesignObject obj = (DesignObject)MethodPropertiesDialogEx.this.pList.get(objectNumber);
                            MethodPropertiesDialogEx.this.moveToIndex(obj, objectNumber + 1);
                            MethodPropertiesDialogEx.this.pTable.changeSelection(objectNumber + 1, 0, false, false);
                            MethodPropertiesDialogEx.this.pTable.updateUI();
                        }
                    }
                });
                JToolBar toolBar = new JToolBar(0);
                toolBar.setFloatable(false);
                toolBar.add(btnAdd);
                toolBar.add(this.btnRemove);
                toolBar.add(this.btnMoveUp);
                toolBar.add(this.btnMoveDown);
                buttonGeneral.add(toolBar);
            }
            JPanel aPanel = new JPanel(new BorderLayout());
            aPanel.add((Component)buttonGeneral, "North");
            aPanel.add(scrollpane);
            this.pnParameters.add(aPanel);
        }
        return this.pnParameters;
    }

    protected JPanel getBodyPanel() {
        if (this.pnBody == null) {
            this.pnBody = this.createPage(Messages.getString("MethodPropertiesDialogEx.Body"));
            this.taBody = new SQLSyntaxTextArea(false);
            this.taBody.setBorder(null);
            this.taBody.setEditable(this.isEditable());
            this.pnBody.add(new JScrollPane((Component)((Object)this.taBody)));
        }
        return this.pnBody;
    }

    private class ParamModel
    extends AbstractTableModel {
        private ParamModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return MethodPropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("MethodPropertiesDialogEx.Name");
            }
            if (column == 1) {
                return Messages.getString("MethodPropertiesDialogEx.Datatype");
            }
            if (column == 2) {
                return Messages.getString("MethodPropertiesDialogEx.DefaultValue");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return MethodPropertiesDialogEx.this.isEditable();
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            MethodParam param = (MethodParam)MethodPropertiesDialogEx.this.pList.get(row);
            if (column == 0) {
                param.setName(String.valueOf(aValue));
            } else if (column == 2) {
                param.setDefaultValue(String.valueOf(aValue));
            }
        }

        @Override
        public Object getValueAt(int row, int col) {
            MethodParam param = (MethodParam)MethodPropertiesDialogEx.this.pList.get(row);
            if (col == 0) {
                return param.getName();
            }
            if (col == 1) {
                return param;
            }
            if (col == 2) {
                return param.getDefaultValue();
            }
            return new Integer(row * col);
        }
    }

    public class DatatypeEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        private JPanel rendererPanel = new JPanel(new BorderLayout());
        private JPanel editorPanel = new JPanel(new BorderLayout());
        private JButton jbR = new JButton();
        private JButton jbE = new JButton();
        private JLabel jlR = new JLabel();
        private JLabel jlE = new JLabel();

        DatatypeEditorRenderer() {
            this.jbR.setText("...");
            this.jbR.setToolTipText(Messages.getString("MethodPropertiesDialogEx.SelectDataType"));
            this.jbR.setPreferredSize(new Dimension(18, 18));
            this.jbE.setText("...");
            this.jbE.setToolTipText(Messages.getString("MethodPropertiesDialogEx.SelectDataType"));
            this.jbE.setPreferredSize(new Dimension(18, 18));
            this.jbE.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = MethodPropertiesDialogEx.this.pTable.getSelectedRow();
                    MethodParam mp = (MethodParam)MethodPropertiesDialogEx.this.pList.get(MethodPropertiesDialogEx.this.pTable.convertRowIndexToModel(row));
                    SelectDataTypeDialog datatypeDialog = new SelectDataTypeDialog(MethodPropertiesDialogEx.this.getAppView(), mp);
                    int result = datatypeDialog.showDialog();
                    DataTypeObject dt = datatypeDialog.getDataType();
                    if (result == 1) {
                        mp.setType(dt.getType());
                        mp.setSize(dt.getSize());
                        mp.setPrecision(dt.getPrecision());
                        mp.setScale(dt.getScale());
                        mp.setReference(dt.isReference());
                        MethodPropertiesDialogEx.this.pTable.getColumnModel().getColumn(1).getCellEditor().getTableCellEditorComponent(MethodPropertiesDialogEx.this.pTable, mp, true, row, 1);
                    }
                }
            });
            this.jlR.setOpaque(true);
            this.jlR.setBackground(Color.WHITE);
            this.jlE.setOpaque(true);
            this.jlE.setBackground(Color.WHITE);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.jlR.setText(value.toString());
            this.rendererPanel.add((Component)this.jlR, "Center");
            this.rendererPanel.add((Component)this.jbR, "East");
            return this.rendererPanel;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.jlE.setText(value.toString());
            this.editorPanel.add((Component)this.jlE, "Center");
            this.editorPanel.add((Component)this.jbE, "East");
            return this.editorPanel;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }
}

