/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.util.MessageDialogs;

public abstract class AbstractAddObjectDialog
extends JDialog
implements AbstractEditorConstants {
    private Design design;
    protected List sList;
    private JPanel generalPanel;
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;
    private JButton bnCancel;
    private static boolean objectAdded = false;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAddObjectDialog.this.bnCancel.doClick();
        }
    };

    public AbstractAddObjectDialog(ApplicationView view, Design design, List sList) {
        super(view.getFrame());
        this.setModal(true);
        this.design = design;
        this.sList = sList;
        this.setTitle(this.getAddObjectString());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractAddObjectDialog.this.dispose();
            }
        });
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new GridLayout(0, 1));
        pnTop.setBorder(BorderFactory.createTitledBorder(this.getSelectObjectString()));
        RadioListener listener = new RadioListener();
        this.rbNew = new JRadioButton(this.getNewObjectString());
        this.rbNew.addActionListener(listener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(this.getAvailableObjectsString());
        this.rbAll.addActionListener(listener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbNew);
        group.add(this.rbAll);
        pnTop.add(this.rbNew);
        pnTop.add(this.rbAll);
        this.generalPanel.add((Component)pnTop, "North");
        JPanel pnList = new JPanel();
        pnList.setBorder(BorderFactory.createTitledBorder(this.getAllObjectsString()));
        this.allList.addAll(this.getAllObjects());
        this.allTable = new JTable(new AllObjectsModel());
        this.allTable.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.allTable);
        scrollpane.setPreferredSize(new Dimension(240, 220));
        pnList.add(scrollpane);
        this.generalPanel.add(pnList);
        this.enableControls(!this.rbNew.isSelected());
        this.getContentPane().add((Component)this.generalPanel, "Center");
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        this.bnCancel = new JButton(BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(this.bnCancel);
        this.getContentPane().add((Component)bottomPanel, "South");
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
        this.pack();
        this.centerOnScreen(this);
        this.setResizable(false);
    }

    protected abstract String getAddObjectString();

    protected abstract String getSelectObjectString();

    protected abstract String getNewObjectString();

    protected abstract String getAvailableObjectsString();

    protected abstract String getAllObjectsString();

    public Design getDesign() {
        return this.design;
    }

    protected abstract List getAllObjects();

    protected abstract String getColumnCaption();

    private void enableControls(boolean enable) {
        this.allTable.setEnabled(enable);
        this.allTable.clearSelection();
        if (!enable) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
    }

    protected abstract DesignObject createObject();

    public void centerOnScreen(JDialog window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = window.getSize();
        Point newLocation = new Point((screenSize.width - mySize.width) / 2, (screenSize.height - mySize.height) / 2);
        window.setLocation(newLocation);
    }

    public static boolean isObjectAdded() {
        return objectAdded;
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAddObjectDialog.this.enableControls(!AbstractAddObjectDialog.this.rbNew.isSelected());
        }
    }

    private class AllObjectsModel
    extends AbstractTableModel {
        private AllObjectsModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return AbstractAddObjectDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return AbstractAddObjectDialog.this.getColumnCaption();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)AbstractAddObjectDialog.this.allList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractAddObjectDialog.this.rbNew.isSelected()) {
                AbstractAddObjectDialog.this.sList.add(AbstractAddObjectDialog.this.createObject());
            } else {
                int row = AbstractAddObjectDialog.this.allTable.getSelectedRow();
                if (row != -1 && AbstractAddObjectDialog.this.allList.size() > 0 && row < AbstractAddObjectDialog.this.allList.size()) {
                    AbstractAddObjectDialog.this.sList.add(AbstractAddObjectDialog.this.allList.get(row));
                }
            }
            objectAdded = true;
            AbstractAddObjectDialog.this.dispose();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractAddObjectDialog.this.dispose();
        }
    }
}

