/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.SensitiveType;
import oracle.dbtools.crest.model.TSDPPolicy;
import oracle.dbtools.crest.model.TSDPSubPolicy;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractModelIDObjectPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.MoveUpDownListJTable;

public class TSDPPolicyPropertiesDialog
extends AbstractModelIDObjectPropertiesDialog {
    private TSDPPolicy tsdpPolicy;
    private List<TSDPSubPolicy> subPoliciesList;
    private JTable tbSubPolicies;
    private TSDPSubPolicy selectedSubPolicy = null;
    private final int INIT = 0;
    private final int ADD = 1;
    private final int DELETE = 2;
    private final int INIT_SELECTED = 3;
    private JTextField tfColumnName;
    private JTextArea taColumnComments;
    private JTextArea taColumnNotes;
    private JButton bnCOAdd;
    private JButton bnCORemove;
    private JButton bnCOUp;
    private JButton bnCODown;
    private JButton bnCOCopy;
    private JButton bnCOPaste;
    private int attrCounter = 0;
    private List<TSDPSubPolicy> copiedObjects = new ArrayList<TSDPSubPolicy>();
    private JTextField tfSubPolicyExpression;
    private JComboBox cbMaskType;
    private JComboBox cbMaskTemplate;
    private JTextField tfDatatype;
    private JIntegerField ifLength;
    private JTextField tfParentSchema;
    private JTextField tfParentTable;
    private List selectedSTList;
    private List allSTList;
    private JList selectedSensitiveTypes;
    private JList allSensitiveTypes;
    private JPanel pnSensitiveTypes;
    private JButton btnAddST;
    private JButton btnRemoveST;
    private DefaultListModel allSTModel;
    private DefaultListModel selectedSTModel;
    private JCheckBox chGenerateInDDL;

    public TSDPPolicyPropertiesDialog(ApplicationView view, ModelIDObject object) {
        super(view, object);
        this.initGeneral();
    }

    @Override
    public String getCaption() {
        return Messages.getString("TSDPPolicyPropertiesDialog.TSDPPolicyProperties");
    }

    private void initGeneral() {
        JLabel lbGenerateInDDL = new JLabel(LB_GENERATE_IN_DDL);
        lbGenerateInDDL.setPreferredSize(this.getDefaultSize());
        this.chGenerateInDDL = new JCheckBox();
        this.chGenerateInDDL.setPreferredSize(this.getDefaultSize());
        this.addRowToGeneralPanel(this.createRow(lbGenerateInDDL, this.chGenerateInDDL));
    }

    @Override
    public void initProperties(ModelIDObject object) {
        if (object instanceof TSDPPolicy) {
            this.tsdpPolicy = (TSDPPolicy)object;
            this.tfName.setText(this.tsdpPolicy.getName());
            this.taComments.setText(this.tsdpPolicy.getComment());
            this.taNotes.setText(this.tsdpPolicy.getNotes());
            this.tfObjectID.setText(this.tsdpPolicy.getObjectID());
            this.tfCreationTime.setText(this.tsdpPolicy.getCreationTime());
            this.tfCreator.setText(this.tsdpPolicy.getCreator().getName());
            this.tfDesign.setText(this.tsdpPolicy.getOwnerDesignName());
            this.tfGeneratorName.setText(NONE);
            this.tfLastChangedBy.setText(this.tsdpPolicy.getChanger().getName());
            this.tfLastChangedTime.setText(this.tsdpPolicy.getChangeTime());
            this.chGenerateInDDL.setSelected(this.tsdpPolicy.getGenerateInDDL());
            this.cbMaskTemplate.addItem(null);
            Iterator it = this.getAppView().getMaskTemplateSet().iterator();
            while (it.hasNext()) {
                this.cbMaskTemplate.addItem(it.next());
            }
            this.subPoliciesList.addAll(this.tsdpPolicy.getElements());
            this.enableSubPolicyOptions(this.subPoliciesList.size() > 0 && this.tbSubPolicies.getSelectedRow() > 0, 0);
            this.getAppView().getSensitiveTypeSet().addAllElementsTo(this.allSTList);
            this.selectedSTList.addAll(this.tsdpPolicy.getSensitiveTypesList());
            this.fillSensitiveTypesLists();
        }
    }

    @Override
    protected int getMinimumWidth() {
        return 800;
    }

    @Override
    protected int getMinimumHeight() {
        return 500;
    }

    @Override
    protected void setProperties() {
        TSDPSubPolicy policy;
        Object ob;
        int i;
        if (this.selectedSubPolicy != null) {
            this.initSelectedSubPolicyOptions(this.selectedSubPolicy, true);
        }
        this.setPreviousSelectedSubPolicy();
        this.tsdpPolicy.setName(this.checkName(this.tsdpPolicy, this.tfName.getText()));
        this.tsdpPolicy.setComment(this.taComments.getText());
        this.tsdpPolicy.setNotes(this.taNotes.getText());
        this.tsdpPolicy.setGenerateInDDL(this.chGenerateInDDL.isSelected());
        Object[] elements = this.tsdpPolicy.getElements().toArray();
        for (int i2 = elements.length - 1; i2 >= 0; --i2) {
            TSDPSubPolicy element = (TSDPSubPolicy)elements[i2];
            if (this.subPoliciesList.contains(element)) continue;
            element.remove();
        }
        Object[] eSet = this.subPoliciesList.toArray();
        for (i = 0; i < eSet.length; ++i) {
            ob = eSet[i];
            if (!(ob instanceof TSDPSubPolicy) || this.tsdpPolicy.contains(policy = (TSDPSubPolicy)ob)) continue;
            this.tsdpPolicy.add(policy);
        }
        for (i = 0; i < eSet.length; ++i) {
            ob = eSet[i];
            if (!(ob instanceof TSDPSubPolicy)) continue;
            policy = (TSDPSubPolicy)ob;
            this.tsdpPolicy.moveElementToIndex(policy, i);
        }
        int entsize = this.selectedSTModel.size();
        this.tsdpPolicy.getSensitiveTypesList().clear();
        for (int i3 = 0; i3 < entsize; ++i3) {
            this.tsdpPolicy.addSensitiveType((SensitiveType)this.selectedSTModel.getElementAt(i3));
        }
        this.getAppView().saveTSDPPolicies();
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getSubPoliciesPanel());
        this.addToTree(root, this.getSensitiveTypesPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "TSDP_POLICY_PROPERTIES_DIALOG";
    }

    private JPanel getSubPoliciesPanel() {
        JPanel jpanel = this.createPage(Messages.getString("TSDPPolicyPropertiesDialog.SubPolicies"));
        this.subPoliciesList = new ArrayList<TSDPSubPolicy>();
        this.tbSubPolicies = new JTable(new SubPolicyModel());
        this.tbSubPolicies.setSelectionMode(2);
        TableColumn column = this.tbSubPolicies.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column.setMaxWidth(50);
        column.setMinWidth(25);
        this.tbSubPolicies.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    TSDPPolicyPropertiesDialog.this.setSubPolicySelected();
                } else if (e.getClickCount() == 2) {
                    // empty if block
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.tbSubPolicies);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(250, 35));
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        if (this.isEditable()) {
            MoveUpDownListJTable upDown = new MoveUpDownListJTable(this.subPoliciesList, this.tbSubPolicies);
            this.bnCOAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
            this.bnCOAdd.addActionListener(new COAddAction());
            this.bnCORemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
            this.bnCORemove.addActionListener(new CORemoveAction());
            this.bnCOUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
            this.bnCOUp.addActionListener(new MoveUpDownListJTable.MoveUpAction(upDown));
            this.bnCODown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
            this.bnCODown.addActionListener(new MoveUpDownListJTable.MoveDownAction(upDown));
            this.bnCOCopy = new JButton(configuration.getIcon("COPY_ICON", this.getPreferredIconSize()));
            this.bnCOCopy.addActionListener(new COCopyAction());
            this.bnCOPaste = new JButton(configuration.getIcon("PASTE_ICON", this.getPreferredIconSize()));
            this.bnCOPaste.addActionListener(new COPasteAction());
            this.tbSubPolicies.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (TSDPPolicyPropertiesDialog.this.subPoliciesList.isEmpty()) {
                        TSDPPolicyPropertiesDialog.this.bnCORemove.setEnabled(false);
                        TSDPPolicyPropertiesDialog.this.bnCOUp.setEnabled(false);
                        TSDPPolicyPropertiesDialog.this.bnCODown.setEnabled(false);
                    } else {
                        TSDPPolicyPropertiesDialog.this.bnCORemove.setEnabled(true);
                        TSDPPolicyPropertiesDialog.this.bnCOUp.setEnabled(true);
                        TSDPPolicyPropertiesDialog.this.bnCODown.setEnabled(true);
                        TSDPPolicyPropertiesDialog.this.setSubPolicySelected();
                    }
                }
            });
            this.tbSubPolicies.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (TSDPPolicyPropertiesDialog.this.subPoliciesList.isEmpty()) {
                        TSDPPolicyPropertiesDialog.this.bnCORemove.setEnabled(false);
                        TSDPPolicyPropertiesDialog.this.bnCOUp.setEnabled(false);
                        TSDPPolicyPropertiesDialog.this.bnCODown.setEnabled(false);
                    } else {
                        TSDPPolicyPropertiesDialog.this.bnCORemove.setEnabled(true);
                        TSDPPolicyPropertiesDialog.this.bnCOUp.setEnabled(true);
                        TSDPPolicyPropertiesDialog.this.bnCODown.setEnabled(true);
                    }
                }
            });
            ListSelectionModel rowSM = this.tbSubPolicies.getSelectionModel();
            rowSM.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                        if (lsm.isSelectionEmpty()) {
                            TSDPPolicyPropertiesDialog.this.bnCORemove.setEnabled(false);
                        } else {
                            TSDPPolicyPropertiesDialog.this.bnCORemove.setEnabled(true);
                        }
                    }
                }
            });
        }
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        if (this.isEditable()) {
            toolBar.addSeparator();
            toolBar.add(this.bnCOAdd);
            toolBar.add(this.bnCORemove);
            toolBar.add(this.bnCOUp);
            toolBar.add(this.bnCODown);
            toolBar.addSeparator();
            toolBar.add(this.bnCOCopy);
            toolBar.add(this.bnCOPaste);
        }
        buttonGeneral.add(toolBar);
        JPanel columnsPanel = new JPanel(new BorderLayout());
        columnsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TSDPPolicyPropertiesDialog.SubPolicies")));
        columnsPanel.add((Component)buttonGeneral, "North");
        columnsPanel.add(scrollpane);
        jpanel.add((Component)columnsPanel, "Center");
        this.tbSubPolicies.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    TSDPPolicyPropertiesDialog.this.deleteSubPolicy(TSDPPolicyPropertiesDialog.this.tbSubPolicies);
                }
            }
        });
        JPanel pnOptions = new JPanel(new BorderLayout());
        pnOptions.setBorder(BorderFactory.createTitledBorder(Messages.getString("TSDPPolicyPropertiesDialog.SubPolicyProperties")));
        JPanel pnGrid = new JPanel(new BorderLayout());
        Dimension dim = new Dimension(120, 20);
        Dimension dim2 = new Dimension(260, 20);
        JLabel lbColumnName = new JLabel(LB_NAME);
        lbColumnName.setPreferredSize(dim);
        this.tfColumnName = new JTextField();
        this.tfColumnName.setPreferredSize(dim2);
        this.tfColumnName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    TSDPPolicyPropertiesDialog.this.moveUp();
                } else if (e.getKeyCode() == 40) {
                    TSDPPolicyPropertiesDialog.this.moveDown();
                }
            }
        });
        JPanel pnSize = new JPanel(new BorderLayout());
        pnSize.add((Component)this.createRow(lbColumnName, this.tfColumnName), "North");
        pnSize.add((Component)new JPanel(), "Center");
        pnGrid.add((Component)pnSize, "North");
        JLabel lbExpression = new JLabel(LB_EXPRESSION);
        lbExpression.setPreferredSize(dim);
        this.tfSubPolicyExpression = new JTextField();
        this.tfSubPolicyExpression.setPreferredSize(dim2);
        JLabel lbMaskType = new JLabel(LB_MASK_TYPE);
        lbMaskType.setPreferredSize(dim);
        this.cbMaskType = new JComboBox();
        this.cbMaskType.setPreferredSize(dim2);
        this.cbMaskType.setMaximumRowCount(20);
        this.cbMaskType.addItem("FULL");
        this.cbMaskType.addItem("RANDOM");
        this.cbMaskType.addItem("PARTIAL");
        this.cbMaskType.addItem("REGEXP");
        this.cbMaskType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (e.getItem().equals("FULL") || e.getItem().equals("RANDOM")) {
                        TSDPPolicyPropertiesDialog.this.cbMaskTemplate.setSelectedIndex(0);
                        TSDPPolicyPropertiesDialog.this.cbMaskTemplate.setEnabled(false);
                    } else {
                        TSDPPolicyPropertiesDialog.this.cbMaskTemplate.setEnabled(true);
                    }
                }
            }
        });
        JLabel lbMaskTemplate = new JLabel(LB_MASK_TEMPLATE);
        lbMaskTemplate.setPreferredSize(dim);
        this.cbMaskTemplate = new JComboBox();
        this.cbMaskTemplate.setPreferredSize(dim2);
        this.cbMaskTemplate.setMaximumRowCount(20);
        JLabel lbDatatype = new JLabel(LB_DATA_TYPE);
        lbDatatype.setPreferredSize(dim);
        this.tfDatatype = new JTextField();
        this.tfDatatype.setPreferredSize(dim2);
        JLabel lbLength = new JLabel(LB_LENGTH);
        lbLength.setPreferredSize(dim);
        this.ifLength = new JIntegerField();
        this.ifLength.setPreferredSize(dim2);
        JLabel lbParentSchema = new JLabel(LB_PARENT_SCHEMA);
        lbParentSchema.setPreferredSize(dim);
        this.tfParentSchema = new JTextField();
        this.tfParentSchema.setPreferredSize(dim2);
        JLabel lbParentTable = new JLabel(LB_PARENT_TABLE);
        lbParentTable.setPreferredSize(dim);
        this.tfParentTable = new JTextField();
        this.tfParentTable.setPreferredSize(dim2);
        JPanel pnDTGrid = new JPanel(new GridLayout(0, 1, 0, 10));
        pnDTGrid.add(this.createRow(lbExpression, this.tfSubPolicyExpression));
        pnDTGrid.add(this.createRow(lbMaskType, this.cbMaskType));
        pnDTGrid.add(this.createRow(lbMaskTemplate, this.cbMaskTemplate));
        pnDTGrid.add(this.createRow(lbDatatype, this.tfDatatype));
        pnDTGrid.add(this.createRow(lbLength, this.ifLength));
        pnDTGrid.add(this.createRow(lbParentSchema, this.tfParentSchema));
        pnDTGrid.add(this.createRow(lbParentTable, this.tfParentTable));
        pnGrid.add((Component)pnDTGrid, "Center");
        JTabbedPane tpComments = new JTabbedPane();
        this.taColumnComments = new JTextArea();
        this.taColumnComments.setLineWrap(true);
        this.taColumnComments.setWrapStyleWord(true);
        this.taColumnNotes = new JTextArea();
        this.taColumnNotes.setLineWrap(true);
        this.taColumnNotes.setWrapStyleWord(true);
        tpComments.addTab(Messages.getString("TSDPPolicyPropertiesDialog.Comments"), new JScrollPane(this.taColumnComments));
        tpComments.addTab(Messages.getString("TSDPPolicyPropertiesDialog.Notes"), new JScrollPane(this.taColumnNotes));
        tpComments.setPreferredSize(new Dimension(300, 100));
        JPanel pnTop = new JPanel(new FlowLayout(0));
        pnTop.add(pnGrid);
        pnOptions.add((Component)pnTop, "North");
        pnOptions.add((Component)tpComments, "Center");
        jpanel.add((Component)pnOptions, "East");
        return jpanel;
    }

    private void setSubPolicySelected() {
        int row = this.tbSubPolicies.getSelectedRow();
        if (row != -1 && this.subPoliciesList.size() > 0 && row < this.subPoliciesList.size()) {
            TSDPSubPolicy policy = this.subPoliciesList.get(row);
            this.initSelectedSubPolicyOptions(policy, true);
        }
    }

    private void initSelectedSubPolicyOptions(TSDPSubPolicy policy, boolean setPrevious) {
        if (setPrevious && this.selectedSubPolicy == policy) {
            return;
        }
        if (setPrevious) {
            this.setPreviousSelectedSubPolicy();
        }
        this.selectedSubPolicy = policy;
        if (this.isEditable()) {
            this.enableSubPolicyOptions(true, 3);
        } else {
            this.enableSubPolicyOptions(false, 3);
        }
        this.tfColumnName.setText(policy.getName());
        this.tfSubPolicyExpression.setText(policy.getExpression());
        String mt = policy.getMaskType();
        MaskTemplate templ = policy.getMaskTemplate();
        if ((mt == null || "".equals(mt)) && templ != null) {
            this.cbMaskType.setSelectedItem("PARTIAL");
        } else {
            this.cbMaskType.setSelectedItem(mt);
        }
        this.cbMaskTemplate.setSelectedItem(templ);
        this.tfDatatype.setText(policy.getPropertyDatatype());
        this.ifLength.setValue((long)policy.getPropertyLenght());
        this.tfParentSchema.setText(policy.getPropertyParentSchema());
        this.tfParentTable.setText(policy.getPropertyParentTable());
        this.taColumnComments.setText(policy.getComment());
        this.taColumnNotes.setText(policy.getNotes());
        this.tbSubPolicies.updateUI();
        this.tfColumnName.selectAll();
        this.tfColumnName.requestFocus();
    }

    private void setPreviousSelectedSubPolicy() {
        if (this.selectedSubPolicy != null) {
            this.selectedSubPolicy.setName(this.tfColumnName.getText());
            this.selectedSubPolicy.setExpression(this.tfSubPolicyExpression.getText());
            this.selectedSubPolicy.setMaskType((String)this.cbMaskType.getSelectedItem());
            this.selectedSubPolicy.setMaskTemplate((MaskTemplate)this.cbMaskTemplate.getSelectedItem());
            this.selectedSubPolicy.setPropertyDatatype(this.tfDatatype.getText());
            this.selectedSubPolicy.setPropertyLenght(this.ifLength.getIntValue());
            this.selectedSubPolicy.setPropertyParentSchema(this.tfParentSchema.getText());
            this.selectedSubPolicy.setPropertyParentTable(this.tfParentTable.getText());
            this.selectedSubPolicy.setComment(this.taColumnComments.getText());
            this.selectedSubPolicy.setNotes(this.taColumnNotes.getText());
            this.tbSubPolicies.updateUI();
        }
    }

    private void enableSubPolicyOptions(boolean enabled, int operation) {
        this.tfColumnName.setEnabled(enabled);
        this.tfSubPolicyExpression.setEnabled(enabled);
        this.cbMaskType.setEnabled(enabled);
        this.cbMaskTemplate.setEnabled(enabled);
        this.tfDatatype.setEnabled(enabled);
        this.ifLength.setEnabled(enabled);
        this.tfParentSchema.setEnabled(enabled);
        this.tfParentTable.setEnabled(enabled);
        if (operation == 0 || operation == 1 || operation == 2 || operation == 3) {
            // empty if block
        }
        this.taColumnComments.setEnabled(enabled);
        this.taColumnNotes.setEnabled(enabled);
        if (!enabled) {
            this.tfColumnName.setText("");
            this.taColumnComments.setText("");
            this.taColumnNotes.setText("");
            this.tfSubPolicyExpression.setText("");
            this.cbMaskType.setSelectedIndex(0);
            this.cbMaskTemplate.setSelectedIndex(0);
            this.tfDatatype.setText("");
            this.ifLength.setText("");
            this.tfParentSchema.setText("");
            this.tfParentTable.setText("");
        }
    }

    private void addSubPolicy(ActionEvent e) {
        boolean shift = false;
        boolean ctrl = false;
        if (e != null) {
            shift = (e.getModifiers() & 1) == 1;
            ctrl = (e.getModifiers() & 2) == 2;
        }
        int irow = this.tbSubPolicies.getSelectedRow();
        int rowCount = this.subPoliciesList.size();
        TSDPSubPolicy policy = new TSDPSubPolicy(this.getAppView());
        policy.setName(this.generateName());
        int added = rowCount;
        if (irow > -1) {
            if (shift) {
                if (rowCount == 0) {
                    this.subPoliciesList.add(policy);
                } else {
                    this.subPoliciesList.add(irow, policy);
                    added = irow;
                }
            } else if (ctrl) {
                if (rowCount == 0 || rowCount - 1 == irow) {
                    this.subPoliciesList.add(policy);
                } else {
                    this.subPoliciesList.add(irow + 1, policy);
                    added = irow + 1;
                }
            } else {
                this.subPoliciesList.add(policy);
            }
        } else {
            this.subPoliciesList.add(policy);
        }
        this.tbSubPolicies.updateUI();
        this.tbSubPolicies.changeSelection(added, 1, false, false);
        this.initSelectedSubPolicyOptions(policy, true);
        this.enableSubPolicyOptions(true, 1);
    }

    protected String generatePastedSubPolicyName(String pastedSubPolicyName) {
        if (!this.subPolicyExists(pastedSubPolicyName)) {
            return pastedSubPolicyName;
        }
        int newNumber = 0;
        for (TSDPSubPolicy policy : this.subPoliciesList) {
            String policyName = policy.getName();
            if (policyName.indexOf(pastedSubPolicyName) < 0) continue;
            ++newNumber;
        }
        String policyName = pastedSubPolicyName.concat("_").concat(Integer.toString(newNumber));
        while (this.subPolicyExists(policyName)) {
            policyName = pastedSubPolicyName.concat("_").concat(Integer.toString(++newNumber));
        }
        return policyName;
    }

    protected String generateName() {
        String name = "TSDPSubPolicy";
        int newNumber = 0;
        int lastNumber = this.subPoliciesList.size();
        if (lastNumber != 0) {
            newNumber = this.attrCounter = lastNumber + 1;
        } else {
            ++this.attrCounter;
            newNumber = this.attrCounter;
        }
        String policyName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.subPolicyExists(policyName)) {
            newNumber = ++this.attrCounter;
            policyName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return policyName;
    }

    private boolean subPolicyExists(String name) {
        for (int i = 0; i < this.subPoliciesList.size(); ++i) {
            TSDPSubPolicy policy = this.subPoliciesList.get(i);
            if (!name.equalsIgnoreCase(policy.getName())) continue;
            return true;
        }
        return false;
    }

    private void deleteSubPolicy(JTable jtable) {
        int icol = jtable.getEditingColumn();
        int irow = jtable.getEditingRow();
        if (icol > -1 && irow > -1) {
            jtable.getCellEditor(irow, icol).stopCellEditing();
        }
        int[] rows = jtable.getSelectedRows();
        ArrayList<TSDPSubPolicy> list = new ArrayList<TSDPSubPolicy>();
        for (int i = rows.length - 1; i >= 0; --i) {
            int objectNumber = rows[i];
            if (objectNumber != -1 && this.subPoliciesList.size() > 0 && objectNumber < this.subPoliciesList.size()) {
                TSDPSubPolicy policy = this.subPoliciesList.get(objectNumber);
                list.add(policy);
            }
            for (Object e : list) {
                this.subPoliciesList.remove(e);
            }
            this.tbSubPolicies.clearSelection();
            this.tbSubPolicies.updateUI();
            this.selectedSubPolicy = null;
            this.enableSubPolicyOptions(this.subPoliciesList.size() > 0 && this.tbSubPolicies.getSelectedRow() > 0, 2);
        }
    }

    private void coCopySubPolicies() {
        this.getAppView().clearCopiedObjects();
        int[] rows = this.tbSubPolicies.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            int ind = rows[i];
            if (ind <= -1 || ind >= this.subPoliciesList.size()) continue;
            this.copiedObjects.add(this.subPoliciesList.get(ind));
        }
        this.bnCOPaste.setEnabled(this.copiedObjects.size() > 0);
    }

    private void coPasteSubPolicies() {
        for (TSDPSubPolicy obj : this.copiedObjects) {
            if (!(obj instanceof TSDPSubPolicy)) continue;
            TSDPSubPolicy source = obj;
            TSDPSubPolicy policy = new TSDPSubPolicy(this.getAppView());
            policy.setName(this.generatePastedSubPolicyName(source.getName()));
            String name = policy.getName();
            source.copy(policy);
            policy.setName(name);
            this.subPoliciesList.add(policy);
        }
        if (this.copiedObjects.size() > 0) {
            this.tbSubPolicies.updateUI();
            this.tbSubPolicies.changeSelection(this.subPoliciesList.size() - 1, 1, false, false);
        }
        this.copiedObjects.clear();
    }

    private void moveUp() {
        int row = this.tbSubPolicies.getSelectedRow();
        if (row > 0) {
            this.tbSubPolicies.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            this.setSubPolicySelected();
        }
    }

    private void moveDown() {
        int row = this.tbSubPolicies.getSelectedRow();
        if (row > -1) {
            if (row < this.subPoliciesList.size() - 1) {
                this.tbSubPolicies.getSelectionModel().setSelectionInterval(row + 1, row + 1);
                this.setSubPolicySelected();
            } else if (!ApplicationView.IS_VIEWER && row == this.subPoliciesList.size() - 1) {
                this.addSubPolicy(null);
            }
        }
    }

    protected JPanel getSensitiveTypesPanel() {
        if (this.pnSensitiveTypes == null) {
            this.pnSensitiveTypes = this.createPage(Messages.getString("TSDPPolicyPropertiesDialog.SensitiveTypes"));
            this.selectedSTList = new ArrayList();
            this.allSTList = new ArrayList();
            JPanel jpanel = new JPanel();
            BoxLayout bl = new BoxLayout(jpanel, 2);
            jpanel.setLayout(bl);
            this.pnSensitiveTypes.add((Component)jpanel, "Center");
            this.initAllSensitiveTypesList(jpanel);
            this.initButtons(jpanel);
            this.initSelectedSensitiveTypesList(jpanel);
        }
        return this.pnSensitiveTypes;
    }

    private void initAllSensitiveTypesList(JPanel jpanel) {
        JPanel pnList = new JPanel(new BorderLayout());
        this.allSTModel = new DefaultListModel();
        this.allSensitiveTypes = new JList(this.allSTModel);
        ListSelectionModel listSelectionModel = this.allSensitiveTypes.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allSensitiveTypes);
        sp.setPreferredSize(new Dimension(145, 220));
        pnList.add(sp);
        jpanel.add(pnList);
    }

    private void initSelectedSensitiveTypesList(JPanel jpanel) {
        JPanel pnSelected = new JPanel(new BorderLayout());
        this.selectedSTModel = new DefaultListModel();
        this.selectedSensitiveTypes = new JList(this.selectedSTModel);
        ListSelectionModel listSelectionModel = this.selectedSensitiveTypes.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedSensitiveTypes);
        sp.setPreferredSize(new Dimension(145, 220));
        pnSelected.add(sp);
        jpanel.add(pnSelected);
    }

    private void initButtons(JPanel jpanel) {
        JPanel buttonsPanel = new JPanel();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        toolBar.setBorder(null);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddST = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddST.addActionListener(new AddSTActionListener());
        this.btnAddST.setEnabled(false);
        this.btnAddST.setToolTipText(BTN_ADD);
        this.btnRemoveST = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveST.setEnabled(false);
        this.btnRemoveST.addActionListener(new RemoveSTActionListener());
        this.btnRemoveST.setToolTipText(BTN_REMOVE);
        toolBar.add(this.btnAddST);
        toolBar.add(this.btnRemoveST);
        buttonsPanel.add(toolBar);
        jpanel.add(buttonsPanel);
    }

    private void fillSensitiveTypesLists() {
        for (Object next : this.allSTList) {
            if (!this.selectedSTList.contains(next)) {
                this.allSTModel.addElement(next);
                continue;
            }
            this.selectedSTModel.addElement(next);
        }
    }

    public String checkName(TSDPPolicy policy, String name) {
        boolean found = false;
        for (TSDPPolicy st : this.getAppView().getTSDPPolicySet()) {
            if (!st.getName().equals(name) || st == policy) continue;
            found = true;
            break;
        }
        if (found) {
            String newName = this.createNameVariant(name);
            return newName;
        }
        return name;
    }

    public String createNameVariant(String name) {
        ArrayList<String> names = new ArrayList<String>();
        for (TSDPPolicy st : this.getAppView().getTSDPPolicySet()) {
            names.add(st.getName());
        }
        StringBuffer buffer = new StringBuffer(name);
        String newName = name;
        buffer.append("v");
        int length = buffer.length();
        for (int i = 1; i <= names.size(); ++i) {
            buffer.setLength(length);
            buffer.append(i);
            newName = buffer.toString();
            if (names.contains(newName)) continue;
            return newName;
        }
        throw new IllegalStateException("NoNameVariantFound");
    }

    @Override
    protected boolean isEditable() {
        if (this.getModelIDObject().isReadOnly()) {
            return false;
        }
        if (this.getModelIDObject().isRemoteObject()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER;
    }

    public class SubPolicyModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return TSDPPolicyPropertiesDialog.this.subPoliciesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return " ";
            }
            if (column == 1) {
                return Messages.getString("TSDPPolicyPropertiesDialog.SubPolicyName");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int col) {
            if (col == 0) {
                return Integer.class;
            }
            if (col == 1) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            TSDPSubPolicy policy = TSDPPolicyPropertiesDialog.this.subPoliciesList.get(row);
            if (col == 0) {
                return new Integer(row + 1);
            }
            if (col == 1) {
                return policy.getName();
            }
            return new Integer(row * col);
        }
    }

    private class COAddAction
    implements ActionListener {
        private COAddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TSDPPolicyPropertiesDialog.this.addSubPolicy(e);
        }
    }

    private class CORemoveAction
    implements ActionListener {
        private CORemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TSDPPolicyPropertiesDialog.this.deleteSubPolicy(TSDPPolicyPropertiesDialog.this.tbSubPolicies);
        }
    }

    private class COCopyAction
    extends AbstractAction {
        private COCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TSDPPolicyPropertiesDialog.this.setPreviousSelectedSubPolicy();
            TSDPPolicyPropertiesDialog.this.coCopySubPolicies();
        }
    }

    private class COPasteAction
    extends AbstractAction {
        private COPasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TSDPPolicyPropertiesDialog.this.coPasteSubPolicies();
            TSDPPolicyPropertiesDialog.this.setSubPolicySelected();
        }
    }

    private class AllListSelectionHandler
    implements ListSelectionListener {
        private AllListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TSDPPolicyPropertiesDialog.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TSDPPolicyPropertiesDialog.this.allSensitiveTypes.getSelectedIndex() == -1) {
                    TSDPPolicyPropertiesDialog.this.btnAddST.setEnabled(false);
                } else {
                    TSDPPolicyPropertiesDialog.this.btnAddST.setEnabled(true);
                }
            }
        }
    }

    private class SelectedListSelectionHandler
    implements ListSelectionListener {
        private SelectedListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TSDPPolicyPropertiesDialog.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TSDPPolicyPropertiesDialog.this.selectedSensitiveTypes.getSelectedIndex() == -1) {
                    TSDPPolicyPropertiesDialog.this.btnRemoveST.setEnabled(false);
                } else {
                    TSDPPolicyPropertiesDialog.this.btnRemoveST.setEnabled(true);
                }
            }
        }
    }

    private class AddSTActionListener
    implements ActionListener {
        private AddSTActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TSDPPolicyPropertiesDialog.this.allSTModel.isEmpty()) {
                Object[] selectedObjects = TSDPPolicyPropertiesDialog.this.allSensitiveTypes.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TSDPPolicyPropertiesDialog.this.selectedSTModel.contains(ob)) continue;
                    TSDPPolicyPropertiesDialog.this.selectedSTModel.addElement(ob);
                    TSDPPolicyPropertiesDialog.this.allSTModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveSTActionListener
    implements ActionListener {
        private RemoveSTActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TSDPPolicyPropertiesDialog.this.selectedSTModel.isEmpty()) {
                Object[] selectedObjects = TSDPPolicyPropertiesDialog.this.selectedSensitiveTypes.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TSDPPolicyPropertiesDialog.this.allSTModel.contains(ob)) continue;
                    TSDPPolicyPropertiesDialog.this.allSTModel.addElement(ob);
                    TSDPPolicyPropertiesDialog.this.selectedSTModel.removeElement(ob);
                }
            }
        }
    }
}

