/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.SQLSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class StringEditor
extends CustomDialog
implements AbstractEditorConstants {
    private RSyntaxTextArea editorPane;
    private JPanel buttonPanel;
    private String oldText;
    private String newText;
    private String caption;
    public boolean cancel = true;
    private JDialog dialog;
    private boolean readOnly = false;
    private boolean syntaxHighlight = false;

    public StringEditor(ApplicationView view, String text, String caption) {
        this(view, text, caption, false);
    }

    public StringEditor(ApplicationView view, String text, String caption, int width, int height, boolean syntaxHighlight) {
        this(view, text, caption, false, width, height, syntaxHighlight);
    }

    public StringEditor(ApplicationView view, String text, String caption, boolean readOnly) {
        this(view, text, caption, readOnly, 550, 450, false);
    }

    public StringEditor(ApplicationView view, String text, String caption, boolean readOnly, int width, int height, boolean syntaxHighlight) {
        super(view);
        this.oldText = text;
        this.newText = text;
        this.readOnly = readOnly;
        this.caption = caption;
        this.syntaxHighlight = syntaxHighlight;
        this.editorPane = this.getEditorPane();
        this.initProperties();
        this.cancel = true;
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)this.editorPane);
        scrollPane.setPreferredSize(new Dimension(width, height));
        this.add((Component)scrollPane, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.add((Component)bottomPanel, "South");
    }

    public String getCaption() {
        return this.caption;
    }

    private void setProperties() {
        this.newText = this.editorPane.getText();
    }

    protected RSyntaxTextArea getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new SQLSyntaxTextArea(this.readOnly);
            if (this.syntaxHighlight) {
                this.editorPane.setSyntaxEditingStyle("text/sql");
            } else {
                this.editorPane.setSyntaxEditingStyle("text/plain");
            }
        }
        return this.editorPane;
    }

    public void initProperties() {
        this.editorPane.setText(this.oldText);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            if (!this.readOnly) {
                JButton ok = new JButton(Messages.getString("StringEditor.OK"));
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StringEditor.this.setProperties();
                        StringEditor.this.cancel = false;
                        StringEditor.this.close();
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonPanel.add(ok);
            }
            JButton cancel = new JButton(!this.readOnly ? Messages.getString("StringEditor.Cancel") : Messages.getString("StringEditor.Close"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringEditor.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(cancel);
        }
        return this.buttonPanel;
    }

    public String getText() {
        return this.newText;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.getCaption());
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    StringEditor.this.editorPane.selectAll();
                }
            });
            this.setDefaultActions(this.dialog, false);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    @Override
    public void show() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    public void setModal(boolean modal) {
        ((JDialog)this.getDialog()).setModal(modal);
    }
}

