/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class SelectObjectsDialog
extends CustomDialog {
    private JDialog dialog;
    private List allObjects;
    private List selectedObjects;
    private JPanel generalPanel;
    private String title;
    private JList selectedObjectsList;
    private JList allObjectsList;
    private DefaultListModel allObjectsModel;
    private DefaultListModel selectedObjectsModel;
    private JButton btnAdd;
    private JButton btnRemove;
    private boolean cancelled = false;

    public SelectObjectsDialog(ApplicationView appView, List allObjects, List selectedObjects, String title) {
        super(appView);
        this.allObjects = allObjects;
        this.selectedObjects = selectedObjects;
        this.title = title;
        this.generalPanel = new JPanel(new BorderLayout());
        this.allObjectsModel = new DefaultListModel();
        this.selectedObjectsModel = new DefaultListModel();
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void init() {
        this.initAllObjectsList();
        this.initButtons();
        this.initSelectedObjectsList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.selectedObjects.iterator();
        while (it.hasNext()) {
            this.selectedObjectsModel.addElement(it.next());
        }
        for (Object next : this.allObjects) {
            if (this.selectedObjects.contains(next)) continue;
            this.allObjectsModel.addElement(next);
        }
    }

    private void initAllObjectsList() {
        JPanel attributesList = new JPanel();
        this.allObjectsList = new JList(this.allObjectsModel);
        ListSelectionModel listSelectionModel = this.allObjectsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllObjectsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allObjectsList);
        sp.setPreferredSize(new Dimension(220, 300));
        attributesList.add(sp);
        this.generalPanel.add((Component)attributesList, "West");
    }

    private void initSelectedObjectsList() {
        JPanel selectedList = new JPanel();
        this.selectedObjectsList = new JList(this.selectedObjectsModel);
        ListSelectionModel listSelectionModel = this.selectedObjectsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedObjectsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedObjectsList);
        sp.setPreferredSize(new Dimension(220, 300));
        selectedList.add(sp);
        this.generalPanel.add((Component)selectedList, "East");
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initButtons() {
        JPanel buttonsPanel = new JPanel();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAdd = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAdd.addActionListener(new AddActionListener());
        this.btnAdd.setEnabled(false);
        this.btnAdd.setToolTipText(Messages.getString("SelectObjectsDialog.Add"));
        this.btnRemove = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveActionListener());
        this.btnRemove.setToolTipText(Messages.getString("SelectObjectsDialog.Remove"));
        toolBar.add(this.btnAdd);
        toolBar.add(this.btnRemove);
        buttonsPanel.add(toolBar);
        buttonsPanel.setPreferredSize(new Dimension(32, 300));
        this.generalPanel.add((Component)buttonsPanel, "Center");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().show();
        return !this.cancelled;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private void setProperties() {
        this.selectedObjects.clear();
        for (int i = 0; i < this.selectedObjectsModel.size(); ++i) {
            this.selectedObjects.add(this.selectedObjectsModel.getElementAt(i));
        }
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton(Messages.getString("SelectObjectsDialog.OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectObjectsDialog.this.setProperties();
                SelectObjectsDialog.this.cancelled = false;
                SelectObjectsDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("SelectObjectsDialog.Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectObjectsDialog.this.selectedObjects.clear();
                SelectObjectsDialog.this.cancelled = true;
                SelectObjectsDialog.this.close();
            }
        });
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    private class AllObjectsListSelectionHandler
    implements ListSelectionListener {
        private AllObjectsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectObjectsDialog.this.allObjectsList.getSelectedIndex() == -1) {
                    SelectObjectsDialog.this.btnAdd.setEnabled(false);
                } else {
                    SelectObjectsDialog.this.btnAdd.setEnabled(true);
                }
            }
        }
    }

    private class SelectedObjectsListSelectionHandler
    implements ListSelectionListener {
        private SelectedObjectsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectObjectsDialog.this.selectedObjectsList.getSelectedIndex() == -1) {
                    SelectObjectsDialog.this.btnRemove.setEnabled(false);
                } else {
                    SelectObjectsDialog.this.btnRemove.setEnabled(true);
                }
            }
        }
    }

    private class AddActionListener
    implements ActionListener {
        private AddActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectObjectsDialog.this.allObjectsModel.isEmpty()) {
                Object[] selectedObjects = SelectObjectsDialog.this.allObjectsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectObjectsDialog.this.selectedObjectsModel.contains(ob)) continue;
                    SelectObjectsDialog.this.selectedObjectsModel.addElement(ob);
                    SelectObjectsDialog.this.allObjectsModel.removeElement(ob);
                }
            }
        }
    }

    private class RemoveActionListener
    implements ActionListener {
        private RemoveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectObjectsDialog.this.selectedObjectsModel.isEmpty()) {
                Object[] selectedObjects = SelectObjectsDialog.this.selectedObjectsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectObjectsDialog.this.allObjectsModel.contains(ob)) continue;
                    SelectObjectsDialog.this.allObjectsModel.addElement(ob);
                    SelectObjectsDialog.this.selectedObjectsModel.removeElement(ob);
                }
            }
        }
    }
}

