/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.DMDExportsPersistence;
import oracle.dbtools.crest.swingui.editor.ExpObject;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialogML;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.string.ToStringComparator;

public class SelectExportDialog
extends CustomDialogML {
    private static final String TEMPLATE_NAME = "Export Configuration";
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private Action actionEscape;
    private JDialog dialog;
    private String title;
    private Design design;
    private boolean cancelled = false;
    private ToStringComparator toStringComparator = new ToStringComparator();
    private JPanel mainPanel;
    private JPanel configurationsPanel;
    private JPanel configurationDetailsPanel;
    private JPanel nameDescriptionScopePanel;
    private JPanel modelsPanel;
    private JPanel subviewsPanel;
    private JPanel buttonsPanel;
    private JButton btnSave;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnCancel;
    private JButton btnRemove;
    private JButton btnOK = new JButton(Messages.getString("SelectExportDialog.OK"));
    private JTextField txtName;
    private JTextArea txtDescription;
    private DefaultListModel exportsModel;
    private int cgCounter = 0;
    private JList exportsList;
    private boolean manuallyClicked = false;
    private boolean isSaved = true;
    private ExportsListSelectionHandler exportsListHandler;
    private JScrollPane exportstSP;
    private List<ExpObject> allExportsList;
    private ArrayList allAvailableModelsList;
    private ArrayList allAvailableSubViewsList;
    private JSearchTextField modelsFilter;
    private JSearchTextField subviewsFilter;
    private List currentNonSelectedModelsList = new ArrayList();
    private JPanel selectedModelsPanel;
    private FilteredModelsJList modelsList;
    private DefaultListModel selectedModelsListModel;
    private JList selectedModelsList;
    private JScrollPane selectedModelsPane;
    private JScrollPane modelsPane;
    private JButton btnModelAdd;
    private JButton btnModelRemove;
    private List currentNonSelectedSubViewsList = new ArrayList();
    private FilteredSUbViewsJList subviewsList;
    private DefaultListModel selectedCurrentModelSubviewsModel;
    private DefaultListModel selectedAllSubviewsListModel;
    private JList selectedCurrentModelSubviewsList;
    private JList selectedAllSubviewsList;
    private JScrollPane selectedStandaloneSubviewsSPane;
    private JScrollPane selectedAllSubviewsSPane;
    private JScrollPane subviewsSPane;
    private JButton btnSubviewAdd;
    private JButton btnSubviewRemove;
    private DMDExportsPersistence exportsPersistence;
    private JTabbedPane jpane;
    private boolean isSelectedExportConfig = false;
    private int dialogMinWidth = 700;
    private int dialogMinHeight = 550;

    public SelectExportDialog(ApplicationView appView, String title) {
        super(appView);
        this.design = appView.getCurrentDesign();
        this.title = title;
        this.allExportsList = appView.getDMDExports();
        this.exportsPersistence = new DMDExportsPersistence(appView, this.design);
        this.design = appView.getCurrentDesign();
        this.mainPanel = new JPanel((LayoutManager)new MigLayout("", "0[150!]0[grow]0", "0[grow]0[]0"));
        this.initGUI();
        this.initButtons();
        this.loadModels();
        this.loadSubViews();
        this.loadExports();
        this.mainPanel.add((Component)this.configurationsPanel, new CC().grow());
        this.mainPanel.add((Component)this.configurationDetailsPanel, new CC().grow().wrap());
        this.mainPanel.add((Component)this.buttonsPanel, new CC().spanX().alignX("right"));
        this.add((Component)this.mainPanel, new CC().grow());
    }

    private void initGUI() {
        this.configurationsPanel = new JPanel((LayoutManager)new MigLayout("", "0[]0", "0[]0[grow]0"));
        this.configurationsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.ExportConfigurations")));
        this.btnAdd = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        this.btnAdd.setToolTipText(Messages.getString("SelectExportDialog.Add"));
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new AddAction());
        this.btnAdd.setMnemonic(65);
        this.btnEdit = new JButton(this.configuration.getIcon("EDIT_ICON", 16));
        this.btnEdit.setToolTipText(Messages.getString("SelectExportDialog.Edit"));
        this.btnEdit.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnEdit.setEnabled(false);
        this.btnEdit.addActionListener(new EditAction());
        this.btnEdit.setMnemonic(69);
        this.btnCancel = new JButton(this.configuration.getIcon("CANCEL_ICON", 16));
        this.btnCancel.setToolTipText(Messages.getString("SelectExportDialog.Cancel"));
        this.btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new CancelAction());
        this.btnCancel.setMnemonic(67);
        this.btnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        this.btnRemove.setToolTipText(Messages.getString("SelectExportDialog.Remove"));
        this.btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setMnemonic(82);
        this.btnSave = new JButton(this.configuration.getIcon("SAVE_ICON", 16));
        this.btnSave.setToolTipText(Messages.getString("SelectExportDialog.Save"));
        this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new SaveAction());
        this.btnSave.setMnemonic(83);
        JToolBar configurationsPanelToolBar = new JToolBar(0);
        configurationsPanelToolBar.setFloatable(false);
        configurationsPanelToolBar.setRollover(true);
        configurationsPanelToolBar.setBorder(null);
        configurationsPanelToolBar.add(this.btnAdd);
        configurationsPanelToolBar.add(this.btnEdit);
        configurationsPanelToolBar.add(this.btnCancel);
        configurationsPanelToolBar.add(this.btnRemove);
        configurationsPanelToolBar.add(this.btnSave);
        this.exportsModel = new DefaultListModel();
        this.exportsList = new JList(this.exportsModel);
        this.exportsListHandler = new ExportsListSelectionHandler();
        this.exportsList.addListSelectionListener(this.exportsListHandler);
        this.exportsList.setCellRenderer(new ExportRenderer());
        this.exportsList.setSelectionMode(0);
        this.exportstSP = new JScrollPane(this.exportsList);
        this.configurationsPanel.add((Component)configurationsPanelToolBar, new CC().wrap());
        this.configurationsPanel.add((Component)this.exportstSP, new CC().grow());
        this.nameDescriptionScopePanel = new JPanel((LayoutManager)new MigLayout("", "5[]0[grow]0", "0[]5[]0"));
        this.nameDescriptionScopePanel.setPreferredSize(new Dimension(180, 50));
        JLabel lblName = new JLabel(Messages.getString("SelectExportDialog.Name"));
        this.txtName = new JTextField();
        this.txtName.setEnabled(false);
        this.txtName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        });
        JLabel lblComments = new JLabel(Messages.getString("SelectExportDialog.Description"));
        lblComments.setPreferredSize(new Dimension(70, 20));
        this.txtDescription = new JTextArea();
        this.txtDescription.setEnabled(false);
        this.txtDescription.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        });
        this.txtDescription.setLineWrap(true);
        this.txtDescription.setWrapStyleWord(true);
        JScrollPane commentsScrollPane = new JScrollPane(this.txtDescription);
        commentsScrollPane.setMinimumSize(new Dimension(300, 50));
        this.nameDescriptionScopePanel.add(lblName);
        this.nameDescriptionScopePanel.add((Component)this.txtName, new CC().grow().wrap());
        this.nameDescriptionScopePanel.add(lblComments);
        this.nameDescriptionScopePanel.add((Component)commentsScrollPane, new CC().grow());
        this.modelsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0[32!]0[grow]0", "0[grow]0"));
        this.modelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.Models")));
        JPanel allModelsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        allModelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.AllModels")));
        allModelsPanel.setPreferredSize(new Dimension(100, 150));
        this.modelsList = new FilteredModelsJList();
        this.modelsList.setCellRenderer(new AllModelsRenderer());
        this.modelsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SelectExportDialog.this.btnModelAdd.doClick();
                }
            }
        });
        this.modelsPane = new JScrollPane(this.modelsList);
        this.modelsList.setEnabled(false);
        this.modelsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectExportDialog.this.subviewsList.clearSelection();
                SelectExportDialog.this.selectedCurrentModelSubviewsModel.clear();
                if (SelectExportDialog.this.modelsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnModelAdd.setEnabled(false);
                } else {
                    SubViewsFilterModel subviewsFilterModel = (SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel();
                    subviewsFilterModel.clear();
                    int[] selectedModelsIndices = SelectExportDialog.this.modelsList.getSelectedIndices();
                    for (int i = 0; i < selectedModelsIndices.length; ++i) {
                        DesignPart dp = (DesignPart)SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelsIndices[i]);
                        Iterator it0 = dp.getDesignSubviews().iterator();
                        while (it0.hasNext()) {
                            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                            if (SelectExportDialog.this.selectedAllSubviewsListModel.contains(ph)) {
                                SelectExportDialog.this.selectedCurrentModelSubviewsModel.addElement(ph);
                                continue;
                            }
                            subviewsFilterModel.addElement(ph);
                        }
                    }
                    SelectExportDialog.this.btnModelAdd.setEnabled(true);
                    ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).setInitialState();
                }
            }
        });
        this.modelsFilter = new JSearchTextField(false, true, Messages.getString("SelectExportDialog.Name"));
        this.modelsFilter.setEnabled(false);
        this.modelsFilter.setPreferredSize(new Dimension(148, 20));
        this.modelsFilter.getDocument().addDocumentListener(new ModelsFilterListener());
        allModelsPanel.add((Component)this.modelsFilter, new CC().wrap());
        allModelsPanel.add((Component)this.modelsPane, new CC().grow());
        JPanel jpButtonsM = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.btnModelAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnModelAdd.addActionListener(new AddModelActionListener());
        this.btnModelAdd.setEnabled(false);
        this.btnModelAdd.setMaximumSize(new Dimension(32, 32));
        this.btnModelRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnModelRemove.addActionListener(new RemoveModelActionListener());
        this.btnModelRemove.setEnabled(false);
        this.btnModelRemove.setMaximumSize(new Dimension(32, 32));
        jpButtonsM.add((Component)this.btnModelAdd, new CC().wrap());
        jpButtonsM.add(this.btnModelRemove);
        this.selectedModelsPanel = new JPanel(new BorderLayout());
        this.selectedModelsPanel.setPreferredSize(new Dimension(100, 150));
        this.selectedModelsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.SelectedModels")));
        this.selectedModelsListModel = new DefaultListModel();
        this.selectedModelsList = new JList(this.selectedModelsListModel);
        this.selectedModelsList.setEnabled(false);
        this.selectedModelsList.setCellRenderer(new SelectedModelsRenderer());
        this.selectedModelsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SelectExportDialog.this.btnModelRemove.doClick();
                }
            }
        });
        this.selectedModelsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectExportDialog.this.selectedModelsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnModelRemove.setEnabled(false);
                } else {
                    SelectExportDialog.this.btnModelRemove.setEnabled(true);
                }
            }
        });
        this.selectedModelsPane = new JScrollPane(this.selectedModelsList);
        this.selectedModelsPanel.add(this.selectedModelsPane);
        this.modelsPanel.add((Component)allModelsPanel, new CC().grow());
        this.modelsPanel.add(jpButtonsM);
        this.modelsPanel.add((Component)this.selectedModelsPanel, new CC().grow());
        this.subviewsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0[32!]0[grow]0", "0[grow]0"));
        this.subviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.Subviews")));
        JPanel allSubviewsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[]5[grow]0"));
        allSubviewsPanel.setPreferredSize(new Dimension(100, 150));
        allSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.AllSW")));
        this.subviewsList = new FilteredSUbViewsJList();
        this.subviewsList.setCellRenderer(new AllSubviewsRenderer());
        this.subviewsSPane = new JScrollPane(this.subviewsList);
        this.subviewsList.setEnabled(false);
        this.subviewsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SelectExportDialog.this.btnSubviewAdd.doClick();
                }
            }
        });
        this.subviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectExportDialog.this.subviewsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
                } else {
                    SelectExportDialog.this.btnSubviewAdd.setEnabled(true);
                }
            }
        });
        this.subviewsFilter = new JSearchTextField(false, true, Messages.getString("SelectExportDialog.Name"));
        this.subviewsFilter.setEnabled(false);
        this.subviewsFilter.setPreferredSize(new Dimension(148, 20));
        this.subviewsFilter.getDocument().addDocumentListener(new SubViewsFilterListener());
        allSubviewsPanel.add((Component)this.subviewsFilter, new CC().wrap());
        allSubviewsPanel.add((Component)this.subviewsSPane, new CC().grow());
        JPanel jpButtonsS = new JPanel((LayoutManager)new MigLayout("", "0[32!]0", "0[]0[]0"));
        this.btnSubviewAdd = new JButton(this.configuration.getIcon("MOVE_RIGHT_ICON", 16));
        this.btnSubviewAdd.addActionListener(new AddSubviewActionListener());
        this.btnSubviewAdd.setEnabled(false);
        this.btnSubviewAdd.setMaximumSize(new Dimension(32, 32));
        this.btnSubviewRemove = new JButton(this.configuration.getIcon("MOVE_LEFT_ICON", 16));
        this.btnSubviewRemove.addActionListener(new RemoveSubviewActionListener());
        this.btnSubviewRemove.setEnabled(false);
        this.btnSubviewRemove.setMaximumSize(new Dimension(32, 32));
        jpButtonsS.add((Component)this.btnSubviewAdd, new CC().wrap());
        jpButtonsS.add(this.btnSubviewRemove);
        JPanel selectedSubviewsPanel = new JPanel(new BorderLayout());
        selectedSubviewsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.SelectedSW")));
        selectedSubviewsPanel.setPreferredSize(new Dimension(100, 150));
        this.selectedCurrentModelSubviewsModel = new DefaultListModel();
        this.selectedCurrentModelSubviewsList = new JList(this.selectedCurrentModelSubviewsModel);
        this.selectedCurrentModelSubviewsList.setCellRenderer(new SelectedSubviewsRenderer());
        this.selectedCurrentModelSubviewsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SelectExportDialog.this.selectedCurrentModelSubviewsList.getSelectedIndex() == -1) {
                    SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
                } else {
                    SelectExportDialog.this.btnSubviewRemove.setEnabled(true);
                }
            }
        });
        this.selectedCurrentModelSubviewsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SelectExportDialog.this.btnSubviewRemove.doClick();
                }
            }
        });
        this.selectedStandaloneSubviewsSPane = new JScrollPane(this.selectedCurrentModelSubviewsList);
        this.selectedCurrentModelSubviewsList.setEnabled(false);
        this.selectedAllSubviewsListModel = new DefaultListModel();
        this.selectedAllSubviewsList = new JList(this.selectedAllSubviewsListModel);
        this.selectedAllSubviewsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SelectExportDialog.this.btnSubviewRemove.doClick();
                }
            }
        });
        this.selectedAllSubviewsSPane = new JScrollPane(this.selectedAllSubviewsList);
        this.selectedAllSubviewsList.setEnabled(false);
        this.jpane = new JTabbedPane();
        this.jpane.addTab(Messages.getString("SelectExportDialog.CurrentModel"), this.selectedStandaloneSubviewsSPane);
        this.jpane.addTab(Messages.getString("SelectExportDialog.AllSelected"), this.selectedAllSubviewsSPane);
        selectedSubviewsPanel.add(this.jpane);
        this.subviewsPanel.add((Component)allSubviewsPanel, new CC().grow());
        this.subviewsPanel.add(jpButtonsS);
        this.subviewsPanel.add((Component)selectedSubviewsPanel, new CC().grow());
        this.configurationDetailsPanel = new JPanel((LayoutManager)new MigLayout("", "0[grow]0", "0[80!]0[grow]0"));
        this.configurationDetailsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectExportDialog.ConfigurationDetails")));
        this.configurationDetailsPanel.add((Component)this.nameDescriptionScopePanel, new CC().grow().wrap());
        this.configurationDetailsPanel.add((Component)this.modelsPanel, new CC().grow().wrap());
        this.configurationDetailsPanel.add((Component)this.subviewsPanel, new CC().grow());
    }

    private void loadModels() {
        this.allAvailableModelsList = new ArrayList();
        for (Object o : this.design.getStorableDesignParts()) {
            if (o instanceof DataFlowDesign) continue;
            this.allAvailableModelsList.add(o);
        }
        this.resetModels();
    }

    private void resetModels() {
        this.selectedModelsListModel.clear();
        ModelsFilterModel modelsFilterModel = (ModelsFilterModel)this.modelsList.getModel();
        modelsFilterModel.clear();
        Iterator it0 = this.allAvailableModelsList.iterator();
        while (it0.hasNext()) {
            modelsFilterModel.addElement(it0.next());
        }
        ((ModelsFilterModel)this.modelsList.getModel()).setInitialState();
    }

    private void loadSubViews() {
        this.allAvailableSubViewsList = new ArrayList();
        Iterator it = this.design.getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it.next();
            this.allAvailableSubViewsList.add(ph);
        }
        for (DesignPart dp : this.design.getRelationalDesigns()) {
            Iterator it0 = dp.getDesignSubviews().iterator();
            while (it0.hasNext()) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                this.allAvailableSubViewsList.add(ph);
            }
        }
        this.resetSubViews();
    }

    private void resetSubViews() {
        this.selectedCurrentModelSubviewsModel.clear();
        this.selectedAllSubviewsListModel.clear();
        SubViewsFilterModel subviewsFilterModel = (SubViewsFilterModel)this.subviewsList.getModel();
        subviewsFilterModel.clear();
        Iterator it = this.allAvailableSubViewsList.iterator();
        while (it.hasNext()) {
            subviewsFilterModel.addElement(it.next());
        }
        ((SubViewsFilterModel)this.subviewsList.getModel()).setInitialState();
    }

    @Override
    protected Action getEscapeAction() {
        if (this.actionEscape == null) {
            this.actionEscape = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SelectExportDialog.this.canClose()) {
                        SelectExportDialog.this.cancelled = true;
                        SelectExportDialog.this.close();
                    }
                }
            };
        }
        return this.actionEscape;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectExportDialog.SelectModelsSubviews"));
            this.dialog.setPreferredSize(new Dimension(560, 730));
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "EXPORT_CONFIGURATIONS_DIALOG";
    }

    private void initButtons() {
        this.buttonsPanel = new JPanel(new FlowLayout(2));
        this.btnOK.setMnemonic(79);
        this.btnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectExportDialog.this.getSelectedModelsAndSWs().size() > 0) {
                    SelectExportDialog.this.cancelled = false;
                    SelectExportDialog.this.close();
                } else {
                    JOptionPane.showMessageDialog(SelectExportDialog.this, Messages.getString("SelectExportDialog.ExportCanNotContinue"), Messages.getString("SelectExportDialog.ExportToDMD"), 0);
                    SelectExportDialog.this.cancelled = true;
                }
            }
        });
        JButton btnCancel = new JButton(Messages.getString("SelectExportDialog.Cancel"));
        btnCancel.setMnemonic(67);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectExportDialog.this.canClose()) {
                    SelectExportDialog.this.cancelled = true;
                    SelectExportDialog.this.close();
                }
            }
        });
        btnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonsPanel.add(this.btnOK);
        this.buttonsPanel.add(btnCancel);
        this.buttonsPanel.add(btnHelp);
    }

    public boolean showDialog() {
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    public List getSelectedModelsAndSWs() {
        ArrayList<Object> all = new ArrayList<Object>();
        all.addAll(Arrays.asList(this.selectedModelsListModel.toArray()));
        all.addAll(Arrays.asList(this.selectedAllSubviewsListModel.toArray()));
        return all;
    }

    private String generateName() {
        String name = TEMPLATE_NAME;
        int newNumber = 0;
        int lastNumber = this.exportsModel.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsForDesign(nName, null)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsForDesign(String name, ExpObject current) {
        for (int i = 0; i < this.exportsModel.size(); ++i) {
            ExpObject ex = (ExpObject)this.exportsModel.get(i);
            if (ex == current || !name.equalsIgnoreCase(ex.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = Messages.getString("SelectExportDialog.Yes");
            String s2 = Messages.getString("SelectExportDialog.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("SelectExportDialog.ConfigNotSaved"), Messages.getString("SelectExportDialog.CloseConfirm"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    @Override
    public void setDefaultActions(JDialog dialog, boolean enableHelp) {
        this.setDefaultActions((JComponent)dialog.getContentPane(), enableHelp);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SelectExportDialog.this.cancelled = true;
                if (SelectExportDialog.this.canClose()) {
                    SelectExportDialog.this.close();
                }
            }
        });
    }

    private DefaultListModel sortDMDExports(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = ((ExpObject)list.get(i)).getName().toString();
                String s2 = ((ExpObject)list.get(i - 1)).getName().toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private void loadExports() {
        this.exportsPersistence.loadExports();
        for (ExpObject ex : this.allExportsList) {
            if (!ex.getDesignID().equals(this.design.getObjectID())) continue;
            this.exportsModel.addElement(ex);
        }
        if (this.exportsModel.getSize() > 0) {
            this.sortDMDExports(this.exportsModel);
            this.exportsList.setSelectedIndex(-1);
        }
    }

    private void showDetails(ExpObject ex) {
        this.txtName.setText(ex.getName());
        this.txtDescription.setText(ex.getDescription());
        this.resetModels();
        this.resetSubViews();
        SubViewsFilterModel subViewsFilterModel = (SubViewsFilterModel)this.subviewsList.getModel();
        ArrayList<ModelIDObject> tempList = new ArrayList<ModelIDObject>();
        if (ex.getModels().size() > 0) {
            block0: for (String string : ex.getModels()) {
                for (DesignPart dp : this.allAvailableModelsList) {
                    if (!dp.getObjectID().equals(string)) continue;
                    this.selectedModelsListModel.addElement(dp);
                    Iterator it1 = dp.getDesignSubviews().iterator();
                    while (it1.hasNext()) {
                        DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it1.next();
                        subViewsFilterModel.remove(ph);
                    }
                    tempList.add(dp);
                    continue block0;
                }
            }
            ModelsFilterModel modelsFilterModel = (ModelsFilterModel)this.modelsList.getModel();
            Iterator it = tempList.iterator();
            while (it.hasNext()) {
                modelsFilterModel.remove(it.next());
            }
        }
        if (ex.getSubViews().size() > 0) {
            tempList.clear();
            block4: for (String string : ex.getSubViews()) {
                for (DesignPartViewPlaceHolder ph : this.allAvailableSubViewsList) {
                    if (!ph.getObjectID().equals(string)) continue;
                    this.selectedAllSubviewsListModel.addElement(ph);
                    tempList.add(ph);
                    continue block4;
                }
            }
            for (Object e : tempList) {
                subViewsFilterModel.remove(e);
            }
        }
    }

    private DefaultListModel sort(DefaultListModel list) {
        for (int k = 0; k < list.size() - 1; ++k) {
            boolean isSorted = true;
            for (int i = 1; i < list.size() - k; ++i) {
                String s1 = list.get(i).toString();
                String s2 = list.get(i - 1).toString();
                if (s1.toString().compareTo(s2.toString()) >= 0) continue;
                Object tmpObj = list.get(i);
                list.remove(i);
                list.add(i, list.get(i - 1));
                list.remove(i - 1);
                list.add(i - 1, tmpObj);
                isSorted = false;
            }
            if (isSorted) break;
        }
        return list;
    }

    private static boolean match(String string, String regex) {
        if ("*".equalsIgnoreCase(regex)) {
            return true;
        }
        if (regex.indexOf(42) > -1) {
            regex = regex.replaceAll("\\*", "\\.*");
        }
        Pattern p = null;
        try {
            p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(string);
            return m.find();
        }
        catch (PatternSyntaxException ex) {
            return false;
        }
    }

    @Override
    protected int getMinimumWidth() {
        return this.dialogMinWidth;
    }

    @Override
    protected int getMinimumHeight() {
        return this.dialogMinHeight;
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = SelectExportDialog.this.generateName();
            ExpObject expObject = new ExpObject("", SelectExportDialog.this.getApplicationView().getCurrentDesign().getObjectID(), name, "", new ArrayList(), new ArrayList());
            SelectExportDialog.this.exportsModel.addElement(expObject);
            SelectExportDialog.this.exportsList.setSelectedValue(expObject, true);
            SelectExportDialog.this.manuallyClicked = true;
            SelectExportDialog.this.exportsList.setEnabled(false);
            SelectExportDialog.this.txtName.setText(name);
            SelectExportDialog.this.txtName.setEnabled(true);
            SelectExportDialog.this.txtDescription.setText("");
            SelectExportDialog.this.txtDescription.setEnabled(true);
            SelectExportDialog.this.modelsFilter.setEnabled(true);
            SelectExportDialog.this.modelsList.setEnabled(true);
            SelectExportDialog.this.selectedModelsList.setEnabled(true);
            SelectExportDialog.this.subviewsFilter.setEnabled(true);
            SelectExportDialog.this.subviewsList.setEnabled(true);
            SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(true);
            SelectExportDialog.this.selectedAllSubviewsList.setEnabled(true);
            SelectExportDialog.this.btnAdd.setEnabled(false);
            SelectExportDialog.this.btnEdit.setEnabled(false);
            SelectExportDialog.this.btnCancel.setEnabled(false);
            SelectExportDialog.this.btnRemove.setEnabled(true);
            SelectExportDialog.this.btnSave.setEnabled(true);
            SelectExportDialog.this.isSaved = false;
        }
    }

    private class EditAction
    implements ActionListener {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectExportDialog.this.txtDescription.setEnabled(true);
            SelectExportDialog.this.txtName.setEnabled(true);
            SelectExportDialog.this.exportsList.setEnabled(false);
            SelectExportDialog.this.modelsFilter.setEnabled(true);
            SelectExportDialog.this.modelsList.setEnabled(true);
            SelectExportDialog.this.selectedModelsList.setEnabled(true);
            SelectExportDialog.this.subviewsFilter.setEnabled(true);
            SelectExportDialog.this.subviewsList.setEnabled(true);
            SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(true);
            SelectExportDialog.this.selectedAllSubviewsList.setEnabled(true);
            SelectExportDialog.this.btnAdd.setEnabled(false);
            SelectExportDialog.this.btnEdit.setEnabled(false);
            SelectExportDialog.this.btnCancel.setEnabled(true);
            SelectExportDialog.this.btnSave.setEnabled(true);
            SelectExportDialog.this.btnRemove.setEnabled(false);
            SubViewsFilterModel subviewsFilterModel = (SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel();
            SelectExportDialog.this.isSaved = false;
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int selected = SelectExportDialog.this.exportsList.getSelectedIndex();
            SelectExportDialog.this.exportsList.clearSelection();
            SelectExportDialog.this.exportsList.setSelectedIndex(selected);
            SelectExportDialog.this.txtName.setEnabled(false);
            SelectExportDialog.this.txtDescription.setEnabled(false);
            SelectExportDialog.this.modelsFilter.setEnabled(false);
            SelectExportDialog.this.modelsList.setEnabled(false);
            SelectExportDialog.this.selectedModelsList.setEnabled(false);
            SelectExportDialog.this.subviewsFilter.setEnabled(false);
            SelectExportDialog.this.subviewsList.setEnabled(false);
            SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(false);
            SelectExportDialog.this.selectedAllSubviewsList.setEnabled(false);
            SelectExportDialog.this.btnModelAdd.setEnabled(false);
            SelectExportDialog.this.btnModelRemove.setEnabled(false);
            SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
            SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
            SelectExportDialog.this.modelsList.clearSelection();
            SelectExportDialog.this.selectedModelsList.clearSelection();
            SelectExportDialog.this.subviewsList.clearSelection();
            SelectExportDialog.this.selectedCurrentModelSubviewsList.clearSelection();
            SelectExportDialog.this.btnSave.setEnabled(false);
            SelectExportDialog.this.btnAdd.setEnabled(true);
            SelectExportDialog.this.btnEdit.setEnabled(true);
            SelectExportDialog.this.btnCancel.setEnabled(false);
            SelectExportDialog.this.btnRemove.setEnabled(true);
            SelectExportDialog.this.exportsList.setEnabled(true);
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExpObject ex = (ExpObject)SelectExportDialog.this.exportsModel.get(SelectExportDialog.this.exportsList.getSelectedIndex());
            int result = JOptionPane.showConfirmDialog(SelectExportDialog.this, MessageFormat.format(Messages.getString("SelectExportDialog.AreYouSure"), ex.getName()), Messages.getString("SelectExportDialog.SelectAnOption"), 0);
            if (result == 0) {
                SelectExportDialog.this.exportsModel.remove(SelectExportDialog.this.exportsList.getSelectedIndex());
                for (ExpObject ex0 : SelectExportDialog.this.allExportsList) {
                    if (!ex.getExportID().equals(ex0.getExportID())) continue;
                    SelectExportDialog.this.allExportsList.remove(ex0);
                    SelectExportDialog.this.exportsPersistence.saveExports();
                    break;
                }
                if (SelectExportDialog.this.exportsList.getModel().getSize() > 0) {
                    SelectExportDialog.this.exportsList.setSelectedIndex(0);
                }
            }
            SelectExportDialog.this.exportsList.setEnabled(true);
            SelectExportDialog.this.txtName.setEnabled(false);
            SelectExportDialog.this.txtDescription.setEnabled(false);
            SelectExportDialog.this.modelsFilter.setEnabled(false);
            SelectExportDialog.this.modelsList.setEnabled(false);
            SelectExportDialog.this.selectedModelsList.setEnabled(false);
            SelectExportDialog.this.btnModelAdd.setEnabled(false);
            SelectExportDialog.this.btnModelRemove.setEnabled(false);
            SelectExportDialog.this.subviewsFilter.setEnabled(false);
            SelectExportDialog.this.subviewsList.setEnabled(false);
            SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(false);
            SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
            SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
            SelectExportDialog.this.btnSave.setEnabled(false);
            SelectExportDialog.this.btnAdd.setEnabled(true);
            SelectExportDialog.this.btnEdit.setEnabled(true);
            SelectExportDialog.this.btnCancel.setEnabled(false);
            SelectExportDialog.this.btnRemove.setEnabled(true);
            SelectExportDialog.this.isSaved = true;
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SelectExportDialog.this.txtName.getText().equals("")) {
                JOptionPane.showMessageDialog(SelectExportDialog.this, Messages.getString("SelectExportDialog.NameCanNotBeEmtpy"), Messages.getString("SelectExportDialog.Error"), 0);
                SelectExportDialog.this.txtName.requestFocus();
            } else {
                ExpObject ex = (ExpObject)SelectExportDialog.this.exportsModel.get(SelectExportDialog.this.exportsList.getSelectedIndex());
                String name = SelectExportDialog.this.txtName.getText();
                int counter = 0;
                while (SelectExportDialog.this.nameExistsForDesign(name, ex)) {
                    name = SelectExportDialog.this.txtName.getText().concat("_").concat(Integer.toString(++counter));
                }
                ex.setName(name);
                ex.setDescription(SelectExportDialog.this.txtDescription.getText());
                List sw = ex.getSubViews();
                sw.clear();
                for (Object obj : Arrays.asList(SelectExportDialog.this.selectedAllSubviewsListModel.toArray())) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)obj;
                    sw.add(ph.getObjectID());
                }
                List models = ex.getModels();
                models.clear();
                for (Object obj : Arrays.asList(SelectExportDialog.this.selectedModelsListModel.toArray())) {
                    DesignPart ph = (DesignPart)obj;
                    models.add(ph.getObjectID());
                }
                boolean found = false;
                for (ExpObject expObject : SelectExportDialog.this.allExportsList) {
                    if (!ex.getExportID().equals(expObject.getExportID()) || !ex.getDesignID().equals(expObject.getDesignID())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    SelectExportDialog.this.allExportsList.add(ex);
                }
                SelectExportDialog.this.exportsPersistence.saveExports();
                SelectExportDialog.this.txtName.setEnabled(false);
                SelectExportDialog.this.txtDescription.setEnabled(false);
                SelectExportDialog.this.modelsFilter.setEnabled(false);
                SelectExportDialog.this.modelsList.setEnabled(false);
                SelectExportDialog.this.selectedModelsList.setEnabled(false);
                SelectExportDialog.this.subviewsFilter.setEnabled(false);
                SelectExportDialog.this.subviewsList.setEnabled(false);
                SelectExportDialog.this.selectedCurrentModelSubviewsList.setEnabled(false);
                SelectExportDialog.this.selectedAllSubviewsList.setEnabled(false);
                SelectExportDialog.this.btnModelAdd.setEnabled(false);
                SelectExportDialog.this.btnModelRemove.setEnabled(false);
                SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
                SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
                SelectExportDialog.this.modelsList.clearSelection();
                SelectExportDialog.this.selectedModelsList.clearSelection();
                SelectExportDialog.this.subviewsList.clearSelection();
                SelectExportDialog.this.selectedCurrentModelSubviewsList.clearSelection();
                SelectExportDialog.this.btnSave.setEnabled(false);
                SelectExportDialog.this.btnAdd.setEnabled(true);
                SelectExportDialog.this.btnEdit.setEnabled(true);
                SelectExportDialog.this.btnCancel.setEnabled(true);
                SelectExportDialog.this.btnRemove.setEnabled(true);
                SelectExportDialog.this.exportsList.setEnabled(true);
                SelectExportDialog.this.manuallyClicked = true;
                SelectExportDialog.this.sortDMDExports(SelectExportDialog.this.exportsModel);
                SelectExportDialog.this.exportsList.setSelectedValue(ex, true);
                SelectExportDialog.this.showDetails(ex);
                SelectExportDialog.this.isSaved = true;
            }
        }
    }

    private class ExportsListSelectionHandler
    implements ListSelectionListener {
        private ExportsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int selected = SelectExportDialog.this.exportsList.getSelectedIndex();
                if (selected == -1) {
                    SelectExportDialog.this.btnAdd.setEnabled(true);
                    SelectExportDialog.this.btnEdit.setEnabled(false);
                    SelectExportDialog.this.btnCancel.setEnabled(false);
                    SelectExportDialog.this.btnRemove.setEnabled(false);
                    SelectExportDialog.this.btnSave.setEnabled(false);
                    SelectExportDialog.this.resetModels();
                    SelectExportDialog.this.resetSubViews();
                    SelectExportDialog.this.isSelectedExportConfig = false;
                } else {
                    SelectExportDialog.this.btnAdd.setEnabled(true);
                    SelectExportDialog.this.btnEdit.setEnabled(true);
                    SelectExportDialog.this.btnCancel.setEnabled(false);
                    SelectExportDialog.this.btnRemove.setEnabled(true);
                    SelectExportDialog.this.btnSave.setEnabled(false);
                    SelectExportDialog.this.isSelectedExportConfig = true;
                    SelectExportDialog.this.showDetails((ExpObject)SelectExportDialog.this.exportsModel.get(SelectExportDialog.this.exportsList.getSelectedIndex()));
                }
            }
        }
    }

    private class ExportRenderer
    extends JLabel
    implements ListCellRenderer {
        private ExportRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ExpObject ex = (ExpObject)value;
            this.setText(ex.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class FilteredModelsJList
    extends JList {
        public FilteredModelsJList() {
            this.setModel((ListModel)new ModelsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof ModelsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class AllModelsRenderer
    extends JLabel
    implements ListCellRenderer {
        private AllModelsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPart) {
                this.setText(((DesignPart)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ModelsFilterListener
    implements DocumentListener {
        private ModelsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).refilter();
        }
    }

    private class AddModelActionListener
    implements ActionListener {
        private AddModelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList selectedObjects = new ArrayList();
            ArrayList removalList = new ArrayList();
            int[] selectedModelIndices = SelectExportDialog.this.modelsList.getSelectedIndices();
            for (int i = 0; i < selectedModelIndices.length; ++i) {
                o = SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelIndices[i]);
                selectedObjects.add(o);
                if (SelectExportDialog.this.selectedModelsListModel.contains(o)) continue;
                SelectExportDialog.this.selectedModelsListModel.addElement(o);
                removalList.add(o);
            }
            for (DesignPart dp : removalList) {
                ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).remove(dp);
                Iterator it0 = dp.getDesignSubviews().iterator();
                while (it0.hasNext()) {
                    DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)it0.next();
                    ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).remove(ph);
                    SelectExportDialog.this.selectedCurrentModelSubviewsModel.removeElement(ph);
                    SelectExportDialog.this.selectedAllSubviewsListModel.removeElement(ph);
                }
            }
            if (((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).getSize() > 0) {
                SelectExportDialog.this.modelsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.modelsList.setSelectedIndex(selectedModelIndices[0] - 1);
                } else {
                    SelectExportDialog.this.modelsList.setSelectedIndex(selectedModelIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnModelAdd.setEnabled(false);
            }
            Iterator it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.selectedModelsList.setSelectedValue(it.next(), true);
            }
            SelectExportDialog.this.sort(SelectExportDialog.this.selectedModelsListModel);
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class RemoveModelActionListener
    implements ActionListener {
        private RemoveModelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList removalList = new ArrayList();
            ArrayList selectedObjects = new ArrayList();
            int[] selectedModelsIndices = SelectExportDialog.this.selectedModelsList.getSelectedIndices();
            for (int i = 0; i < selectedModelsIndices.length; ++i) {
                o = SelectExportDialog.this.selectedModelsList.getModel().getElementAt(selectedModelsIndices[i]);
                selectedObjects.add(o);
                if (((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).contains(o)) continue;
                ((ModelsFilterModel)SelectExportDialog.this.modelsList.getModel()).add(o);
                removalList.add(o);
            }
            Iterator it = removalList.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.selectedModelsListModel.removeElement(it.next());
            }
            if (SelectExportDialog.this.selectedModelsListModel.size() > 0) {
                SelectExportDialog.this.selectedModelsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.modelsList.getModel().getElementAt(selectedModelsIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.selectedModelsList.setSelectedIndex(selectedModelsIndices[0] - 1);
                } else {
                    SelectExportDialog.this.selectedModelsList.setSelectedIndex(selectedModelsIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnModelRemove.setEnabled(false);
            }
            it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.modelsList.setSelectedValue(it.next(), true);
            }
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class SelectedModelsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SelectedModelsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPart) {
                this.setText(((DesignPart)value).getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class FilteredSUbViewsJList
    extends JList {
        public FilteredSUbViewsJList() {
            this.setModel((ListModel)new SubViewsFilterModel());
        }

        public void setModel(ListModel m) {
            if (!(m instanceof SubViewsFilterModel)) {
                throw new IllegalArgumentException();
            }
            super.setModel(m);
        }
    }

    private class AllSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private AllSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)value;
                DesignPart dp = ph.getDesignPart();
                this.setText(ph.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class SubViewsFilterListener
    implements DocumentListener {
        private SubViewsFilterListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).refilter();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).refilter();
        }
    }

    private class AddSubviewActionListener
    implements ActionListener {
        private AddSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList selectedObjects = new ArrayList();
            ArrayList removalList = new ArrayList();
            int[] selectedSubviewsIndices = SelectExportDialog.this.subviewsList.getSelectedIndices();
            for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                o = SelectExportDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                selectedObjects.add(o);
                if (!SelectExportDialog.this.selectedCurrentModelSubviewsModel.contains(o)) {
                    SelectExportDialog.this.selectedCurrentModelSubviewsModel.addElement(o);
                    removalList.add(o);
                }
                if (SelectExportDialog.this.selectedAllSubviewsListModel.contains(o)) continue;
                SelectExportDialog.this.selectedAllSubviewsListModel.addElement(o);
            }
            Iterator it = removalList.iterator();
            while (it.hasNext()) {
                ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).remove(it.next());
            }
            if (((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).getSize() > 0) {
                SelectExportDialog.this.subviewsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.subviewsList.setSelectedIndex(selectedSubviewsIndices[0] - 1);
                } else {
                    SelectExportDialog.this.subviewsList.setSelectedIndex(selectedSubviewsIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnSubviewAdd.setEnabled(false);
            }
            it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedValue(it.next(), true);
            }
            SelectExportDialog.this.sort(SelectExportDialog.this.selectedCurrentModelSubviewsModel);
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class RemoveSubviewActionListener
    implements ActionListener {
        private RemoveSubviewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o;
            ArrayList removalList = new ArrayList();
            ArrayList selectedObjects = new ArrayList();
            int[] selectedSubviewsIndices = SelectExportDialog.this.selectedCurrentModelSubviewsList.getSelectedIndices();
            for (int i = 0; i < selectedSubviewsIndices.length; ++i) {
                o = SelectExportDialog.this.selectedCurrentModelSubviewsList.getModel().getElementAt(selectedSubviewsIndices[i]);
                selectedObjects.add(o);
                if (((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).contains(o)) continue;
                ((SubViewsFilterModel)SelectExportDialog.this.subviewsList.getModel()).add(o);
                removalList.add(o);
            }
            for (DesignPartViewPlaceHolder ph : removalList) {
                if (SelectExportDialog.this.selectedCurrentModelSubviewsModel.contains(ph)) {
                    SelectExportDialog.this.selectedCurrentModelSubviewsModel.removeElement(ph);
                }
                if (!SelectExportDialog.this.selectedAllSubviewsListModel.contains(ph)) continue;
                SelectExportDialog.this.selectedAllSubviewsListModel.removeElement(ph);
            }
            if (SelectExportDialog.this.selectedCurrentModelSubviewsModel.size() > 0) {
                SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedIndex(-1);
                o = SelectExportDialog.this.subviewsList.getModel().getElementAt(selectedSubviewsIndices[0]);
                if (o == null) {
                    SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedIndex(selectedSubviewsIndices[0] - 1);
                } else {
                    SelectExportDialog.this.selectedCurrentModelSubviewsList.setSelectedIndex(selectedSubviewsIndices[0]);
                }
            } else {
                SelectExportDialog.this.btnSubviewRemove.setEnabled(false);
            }
            Iterator it = selectedObjects.iterator();
            while (it.hasNext()) {
                SelectExportDialog.this.subviewsList.setSelectedValue(it.next(), true);
            }
            if (SelectExportDialog.this.isSelectedExportConfig) {
                SelectExportDialog.this.isSaved = false;
                SelectExportDialog.this.btnSave.setEnabled(true);
            }
        }
    }

    private class SelectedSubviewsRenderer
    extends JLabel
    implements ListCellRenderer {
        private SelectedSubviewsRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof DesignPartViewPlaceHolder) {
                DesignPartViewPlaceHolder ph = (DesignPartViewPlaceHolder)value;
                DesignPart dp = ph.getDesignPart();
                this.setText(ph.getName());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private class ModelsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            SelectExportDialog.this.currentNonSelectedModelsList.add(o);
            this.fireContentsChanged(this, 0, this.getSize());
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            SelectExportDialog.this.currentNonSelectedModelsList.remove(o);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = SelectExportDialog.this.modelsFilter.getText();
            for (int i = 0; i < SelectExportDialog.this.currentNonSelectedModelsList.size(); ++i) {
                String name = ((DesignPart)SelectExportDialog.this.currentNonSelectedModelsList.get(i)).getName();
                if (SelectExportDialog.match(name, term)) {
                    this.filterItems.add(SelectExportDialog.this.currentNonSelectedModelsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
            SelectExportDialog.this.currentNonSelectedModelsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            SelectExportDialog.this.currentNonSelectedModelsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }

    private class SubViewsFilterModel
    extends AbstractListModel {
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        private void add(Object o) {
            this.filterItems.add(o);
            SelectExportDialog.this.currentNonSelectedSubViewsList.add(o);
            this.fireContentsChanged(this, 0, this.getSize());
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void remove(Object o) {
            this.filterItems.remove(o);
            SelectExportDialog.this.currentNonSelectedSubViewsList.remove(o);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private void refilter() {
            this.filterItems.clear();
            String term = SelectExportDialog.this.subviewsFilter.getText();
            for (int i = 0; i < SelectExportDialog.this.currentNonSelectedSubViewsList.size(); ++i) {
                String name = ((DesignPartViewPlaceHolder)SelectExportDialog.this.currentNonSelectedSubViewsList.get(i)).getName();
                if (SelectExportDialog.match(name, term)) {
                    this.filterItems.add(SelectExportDialog.this.currentNonSelectedSubViewsList.get(i));
                }
                this.fireContentsChanged(this, 0, this.getSize());
            }
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
        }

        private void setInitialState() {
            this.filterItems.addAll(this.items);
            Collections.sort(this.filterItems, SelectExportDialog.this.toStringComparator);
            SelectExportDialog.this.currentNonSelectedSubViewsList.addAll(this.items);
        }

        private void addElement(Object o) {
            this.items.add(o);
        }

        private void clear() {
            this.items.clear();
            this.filterItems.clear();
            SelectExportDialog.this.currentNonSelectedSubViewsList.clear();
            this.fireContentsChanged(this, 0, this.getSize());
        }

        private boolean contains(Object element) {
            return this.filterItems.contains(element);
        }
    }
}

