/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.ExpandVetoException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.HelpManager;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.OSEnvironment;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.string.StringUtilities;

public abstract class AbstractModelIDObjectPropertiesDialog
extends JDialog
implements AbstractEditorConstants,
TreeWillExpandListener {
    public static final String EMPTY_STRING = "";
    public static final String YES = Messages.getString("AbstractPropertiesDialog.YES");
    public static final String NO = Messages.getString("AbstractPropertiesDialog.NO");
    protected static final String[] YES_NO = new String[]{YES, NO};
    protected static final String[] YES_NO_INTERNAL = new String[]{"YES", "NO"};
    protected static final String[] EMPTY_STRING_YES_NO = new String[]{"", YES, NO};
    public static final String NONE = Messages.getString("AbstractPropertiesDialog.NONE");
    public static final String BTN_PROPERTIES = Messages.getString("AbstractPropertiesDialog.Properties");
    public static final String BTN_ADD = Messages.getString("AbstractPropertiesDialog.Add");
    public static final String BTN_REMOVE = Messages.getString("AbstractPropertiesDialog.Remove");
    public static final String BTN_MOVE_UP = Messages.getString("AbstractPropertiesDialog.MoveUp");
    public static final String BTN_MOVE_DOWN = Messages.getString("AbstractPropertiesDialog.MoveDown");
    protected static final int FIELD_WIDTH = OSEnvironment.isMacOS() ? 200 : 180;
    protected static final int FIELD_HEIGHT = 20;
    private static final String ATTRIBUTES_TAB = Messages.getString("AbstractPropertiesDialog.Attributes");
    private static final String COLUMNS_TAB = Messages.getString("AbstractPropertiesDialog.Columns");
    protected static final String IMPACT_ANALYSIS = Messages.getString("AbstractPropertiesDialog.ImpactAnalysis");
    protected boolean impAnInitialized = false;
    private ApplicationView appView;
    private ModelIDObject modelIDObject;
    private JTabbedPane tabbedPane;
    protected JPanel pnButtons;
    protected JLabel lbName;
    protected JTextField tfName;
    private JButton bnCancel;
    private JTree tree;
    private JPanel pnMain;
    private CardLayout cardLayout = new CardLayout(10, 10);
    private JPanel pnGeneral;
    private JPanel pnComments;
    private JPanel pnCommentsInRDBMS;
    private JPanel pnNotes;
    private JPanel pnUsedIn;
    private JPanel pnSummary;
    private JPanel pnAttributes;
    private JPanel pnColumns;
    protected JTextArea taComments;
    protected JTextArea taCommentsInRDBMS;
    protected JTextArea taNotes;
    protected JTextArea taUsedIn;
    private JPanel pnGeneralGrid;
    protected JPanel pnAdditionalPanel;
    private Dimension defaultSize = new Dimension(FIELD_WIDTH, 20);
    private int summaryPanelMinHeight = 460;
    private int summaryPanelMinWidth = 650;
    private JPanel pnSummaryGrid;
    protected JTextField tfComment;
    protected JTextField tfObjectID;
    protected JTextField tfCreator;
    protected JTextField tfCreationTime;
    protected JTextField tfLastChangedBy;
    protected JTextField tfLastChangedTime;
    protected JTextField tfGeneratorName;
    protected JTextField tfRepositoryOID;
    protected JTextField tfDesign;
    private int summaryCount = 8;
    private JPanel pnDataDictConnection;
    private JPanel pnDataDictSchema;
    private JPanel pnDataDictObject;
    private JPanel pnDDLFileName;
    protected JTextField tfDataDictConnection;
    protected JTextField tfDataDictSchema;
    protected JTextField tfDataDictObject;
    protected JTextField tfDDLFileName;
    protected JCheckBox chGenerateScript;
    protected String oldObjectStatus;
    private boolean oldGenerateInDDL;
    protected List<DynamicProperty> dynamicPropertiesList;
    protected JTable dynamicPropertiesTable;
    private Action actF1 = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractModelIDObjectPropertiesDialog.this.showHelp();
        }
    };
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractModelIDObjectPropertiesDialog.this.bnCancel.doClick();
        }
    };

    public AbstractModelIDObjectPropertiesDialog(ApplicationView view, ModelIDObject object) {
        super(view.getFrame());
        this.init(view, object);
    }

    public AbstractModelIDObjectPropertiesDialog(Dialog owner, ApplicationView view, ModelIDObject object) {
        super(owner);
        this.init(view, object);
    }

    private void init(ApplicationView view, ModelIDObject object) {
        this.modelIDObject = object;
        this.appView = view;
        this.oldObjectStatus = this.appView.getXMLTransformationManager().getFilteredXMLString(object);
        this.oldGenerateInDDL = object.isMarkedGenerate();
        this.initCaption(object.getName());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractModelIDObjectPropertiesDialog.this.onCancel();
                AbstractModelIDObjectPropertiesDialog.this.modelIDObject.setDialogVisible(false, null);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                AbstractModelIDObjectPropertiesDialog.this.modelIDObject.setDialogVisible(false, null);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int w = AbstractModelIDObjectPropertiesDialog.this.getWidth();
                int h = AbstractModelIDObjectPropertiesDialog.this.getHeight();
                w = Math.max(AbstractModelIDObjectPropertiesDialog.this.getMinimumWidth(), w);
                h = Math.max(AbstractModelIDObjectPropertiesDialog.this.getMinimumHeight(), h);
                AbstractModelIDObjectPropertiesDialog.this.setSize(w, h);
            }
        });
        this.initLayout();
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
        KeyStroke ksF1 = KeyStroke.getKeyStroke(112, 0, false);
        c.getInputMap(condition).put(ksF1, "KEY_F1");
        c.getActionMap().put("KEY_F1", this.actF1);
        this.pack();
        Settings.DialogSettings ds = this.getAppView().getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            int w = Math.max(this.getMinimumWidth(), this.summaryPanelMinWidth);
            int h = Math.max(this.getMinimumHeight(), this.summaryPanelMinHeight);
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
        } else {
            int w = Math.max(this.getMinimumWidth(), (int)ds.rec.getSize().getWidth());
            int h = Math.max(this.getMinimumHeight(), (int)ds.rec.getSize().getHeight());
            this.setSize(w, h);
            this.setLocation(ds.rec.getLocation());
        }
    }

    protected void showHelp() {
        HelpManager.showTopic(this, this.getHelpIndex());
    }

    public abstract String getCaption();

    public abstract void initProperties(ModelIDObject var1);

    protected abstract void setProperties();

    protected abstract void initTree(DefaultMutableTreeNode var1);

    protected abstract String getHelpIndex();

    protected ApplicationView getAppView() {
        return this.appView;
    }

    protected ModelIDObject getModelIDObject() {
        return this.modelIDObject;
    }

    protected void setModelIDObject(ModelIDObject modelIDObject) {
        this.modelIDObject = modelIDObject;
    }

    protected void initCaption(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getCaption()).append(" - ").append(name);
        this.setTitle(buffer.toString());
    }

    protected void selectName() {
        this.tfName.requestFocus();
        this.tfName.selectAll();
    }

    @Override
    public void show() {
        if (this.modelIDObject.showModal || this.modelIDObject.showForFirstTime()) {
            this.setModal(true);
        }
        this.selectName();
        if (!this.isEditable()) {
            this.disableControls(this);
            this.getTree().requestFocus();
        }
        super.show();
        this.modelIDObject.setDialogVisible(true, this);
    }

    private void disableControls(Container container) {
        Component[] components = container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            if (c == this.getTree() || c == this.pnButtons || c instanceof JTable || c instanceof JButton || c instanceof JList || c instanceof JScrollPane) continue;
            if (!(c instanceof JTabbedPane) && !(c instanceof JLabel)) {
                c.setEnabled(false);
            }
            if (!(c instanceof Container)) continue;
            this.disableControls((Container)c);
        }
    }

    protected int getMinimumWidth() {
        return this.summaryPanelMinWidth;
    }

    protected int getMinimumHeight() {
        return this.summaryPanelMinHeight;
    }

    protected JPanel getMainPanel() {
        if (this.pnMain == null) {
            this.pnMain = new JPanel(this.cardLayout);
            this.pnMain.setMinimumSize(new Dimension(400, 0));
        }
        return this.pnMain;
    }

    protected void fillComboItems(Object[] items, JComboBox comboBox, boolean addNull) {
        comboBox.removeAllItems();
        if (addNull) {
            comboBox.addItem(null);
        }
        for (int i = 0; i < items.length; ++i) {
            comboBox.addItem(items[i]);
        }
    }

    protected JPanel createPage(String title) {
        JPanel panel = new JPanel(new BorderLayout(0, 10));
        panel.setName(title);
        JPanel caption = new JPanel();
        caption.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        caption.setBackground(Color.WHITE);
        JLabel lb = new JLabel(title);
        lb.setPreferredSize(new Dimension((int)lb.getPreferredSize().getWidth(), 22));
        caption.add(lb);
        panel.add((Component)caption, "North");
        return panel;
    }

    protected void addRowToGeneralPanel(JPanel newRow) {
        this.pnGeneralGrid.add(newRow);
    }

    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp) {
        this.addRowToPanel(panel, labelText, rightComp, null);
    }

    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp, String toolTipText) {
        this.addRowToPanel(panel, labelText, rightComp, toolTipText, null);
    }

    protected void addRowToPanel(JPanel panel, String labelText, JComponent rightComp, String toolTipText, Object constraints) {
        JLabel label = new JLabel(labelText);
        label.setLabelFor(rightComp);
        label.setPreferredSize(this.getDefaultSize());
        if (toolTipText != null) {
            label.setToolTipText(toolTipText);
            rightComp.setToolTipText(toolTipText);
        }
        panel.add((Component)this.createRow(label, rightComp), constraints);
    }

    protected Dimension getDefaultSize() {
        return this.defaultSize;
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(Messages.getString("AbstractPropertiesDialog.General"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            this.pnAdditionalPanel = new JPanel(new GridLayout(0, 1, 10, 10));
            this.lbName = new JLabel(LB_NAME);
            this.lbName.setPreferredSize(this.defaultSize);
            this.tfName = new JTextField();
            this.tfName.setPreferredSize(this.defaultSize);
            this.tfName.setEnabled(this.isEditable());
            this.pnGeneralGrid.add(this.createRow(this.lbName, this.tfName));
            jpanel.add((Component)this.pnGeneralGrid, "North");
            jpanel.add((Component)this.pnAdditionalPanel, "Center");
            this.pnGeneral.add((Component)jpanel, "Center");
        }
        return this.pnGeneral;
    }

    protected JPanel getCommentsPanel() {
        if (this.pnComments == null) {
            this.pnComments = this.createPage(Messages.getString("AbstractPropertiesDialog.Comments"));
            this.taComments = new JTextArea();
            this.taComments.setEditable(this.isEditable());
            this.taComments.setLineWrap(true);
            this.taComments.setWrapStyleWord(true);
            this.pnComments.add(new JScrollPane(this.taComments));
        }
        return this.pnComments;
    }

    protected JPanel getCommentsInRDBMSPanel() {
        if (this.pnCommentsInRDBMS == null) {
            this.pnCommentsInRDBMS = this.createPage(Messages.getString("AbstractPropertiesDialog.CommentsInRDBMS"));
            this.taCommentsInRDBMS = new JTextArea();
            this.taCommentsInRDBMS.setEditable(this.isEditable());
            this.taCommentsInRDBMS.setLineWrap(true);
            this.taCommentsInRDBMS.setWrapStyleWord(true);
            this.pnCommentsInRDBMS.add(new JScrollPane(this.taCommentsInRDBMS));
        }
        return this.pnCommentsInRDBMS;
    }

    protected JPanel getNotesPanel() {
        if (this.pnNotes == null) {
            this.pnNotes = this.createPage(Messages.getString("AbstractPropertiesDialog.Notes"));
            this.taNotes = new JTextArea();
            this.taNotes.setEditable(this.isEditable());
            this.taNotes.setLineWrap(true);
            this.taNotes.setWrapStyleWord(true);
            this.pnNotes.add(new JScrollPane(this.taNotes));
        }
        return this.pnNotes;
    }

    protected JPanel getUsedInPanel() {
        if (this.pnUsedIn == null) {
            this.pnUsedIn = this.createPage(Messages.getString("AbstractPropertiesDialog.UsedIn"));
            this.taUsedIn = new JTextArea();
            this.taUsedIn.setEnabled(this.isEditable());
            this.pnUsedIn.add(new JScrollPane(this.taUsedIn));
            this.pnAttributes = new JPanel(new BorderLayout());
            this.pnColumns = new JPanel(new BorderLayout());
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab(ATTRIBUTES_TAB, this.pnAttributes);
            this.tabbedPane.addTab(COLUMNS_TAB, this.pnColumns);
            this.pnUsedIn.add(this.tabbedPane);
        }
        return this.pnUsedIn;
    }

    protected JPanel getSummaryPanel() {
        if (this.pnSummary == null) {
            this.pnSummary = this.createPage(Messages.getString("AbstractPropertiesDialog.Summary"));
            JPanel jpanel = new JPanel(new BorderLayout());
            this.pnSummaryGrid = new JPanel(new GridLayout(0, 1, 10, 10));
            JLabel lbObjectID = new JLabel(LB_OBJECT_ID);
            lbObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID = new JTextField();
            this.tfObjectID.setPreferredSize(this.getDefaultSize());
            this.tfObjectID.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbObjectID, this.tfObjectID));
            JLabel lbCreator = new JLabel(LB_CREATOR);
            lbCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator = new JTextField();
            this.tfCreator.setPreferredSize(this.getDefaultSize());
            this.tfCreator.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbCreator, this.tfCreator));
            JLabel lbCreationTime = new JLabel(LB_CREATION_TIME);
            lbCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime = new JTextField();
            this.tfCreationTime.setPreferredSize(this.getDefaultSize());
            this.tfCreationTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbCreationTime, this.tfCreationTime));
            JLabel lbLastChangedBy = new JLabel(LB_LAST_CHANGED_BY);
            lbLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy = new JTextField();
            this.tfLastChangedBy.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedBy.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbLastChangedBy, this.tfLastChangedBy));
            JLabel lbLastChangedTime = new JLabel(LB_LAST_CHANGED_TIME);
            lbLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime = new JTextField();
            this.tfLastChangedTime.setPreferredSize(this.getDefaultSize());
            this.tfLastChangedTime.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbLastChangedTime, this.tfLastChangedTime));
            JLabel lbGeneratorName = new JLabel(LB_GENERATOR_NAME);
            lbGeneratorName.setPreferredSize(this.getDefaultSize());
            this.tfGeneratorName = new JTextField();
            this.tfGeneratorName.setPreferredSize(this.getDefaultSize());
            this.tfGeneratorName.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbGeneratorName, this.tfGeneratorName));
            JLabel lbDesign = new JLabel(LB_DESIGN);
            lbDesign.setPreferredSize(this.getDefaultSize());
            this.tfDesign = new JTextField();
            this.tfDesign.setPreferredSize(this.getDefaultSize());
            this.tfDesign.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbDesign, this.tfDesign));
            JLabel lbRepositoryOID = new JLabel(LB_REPOSITORY_OID);
            lbRepositoryOID.setPreferredSize(this.getDefaultSize());
            this.tfRepositoryOID = new JTextField();
            this.tfRepositoryOID.setPreferredSize(this.getDefaultSize());
            this.tfRepositoryOID.setEditable(false);
            this.pnSummaryGrid.add(this.createRow(lbRepositoryOID, this.tfRepositoryOID));
            this.summaryCount = this.pnSummaryGrid.getComponentCount();
            JLabel lbDataDictConnection = new JLabel(LB_SOURCE_DB_CONNECTION);
            lbDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection = new JTextField();
            this.tfDataDictConnection.setPreferredSize(this.getDefaultSize());
            this.tfDataDictConnection.setEditable(false);
            this.pnDataDictConnection = this.createRow(lbDataDictConnection, this.tfDataDictConnection);
            JLabel lbDataDictSchema = new JLabel(LB_SOURCE_DB_SCHEMA);
            lbDataDictSchema.setPreferredSize(this.getDefaultSize());
            this.tfDataDictSchema = new JTextField();
            this.tfDataDictSchema.setPreferredSize(this.getDefaultSize());
            this.tfDataDictSchema.setEditable(false);
            this.pnDataDictSchema = this.createRow(lbDataDictSchema, this.tfDataDictSchema);
            JLabel lbDataDictObject = new JLabel(LB_SOURCE_DB_OBJECT);
            lbDataDictObject.setPreferredSize(this.getDefaultSize());
            this.tfDataDictObject = new JTextField();
            this.tfDataDictObject.setPreferredSize(this.getDefaultSize());
            this.tfDataDictObject.setEditable(false);
            this.pnDataDictObject = this.createRow(lbDataDictObject, this.tfDataDictObject);
            JLabel lbDDLFileName = new JLabel(LB_SOURCE_DDL_FILE);
            lbDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName = new JTextField();
            this.tfDDLFileName.setPreferredSize(this.getDefaultSize());
            this.tfDDLFileName.setEditable(false);
            this.pnDDLFileName = this.createRow(lbDDLFileName, this.tfDDLFileName);
            jpanel.add((Component)this.pnSummaryGrid, "North");
            this.pnSummary.add((Component)jpanel, "Center");
        }
        return this.pnSummary;
    }

    protected JPanel createRow(Component leftComp, Component rightComp) {
        return this.createRow(leftComp, rightComp, false);
    }

    protected JPanel createRow(Component leftComp, Component rightComp, boolean leftIsCentered) {
        JPanel newRow = new JPanel(new BorderLayout());
        if (leftIsCentered) {
            newRow.add(leftComp, "Center");
            newRow.add(rightComp, "East");
        } else {
            newRow.add(leftComp, "West");
            newRow.add(rightComp, "Center");
        }
        return newRow;
    }

    protected void showComponent(Component component) {
        String componentName = component.getName();
        this.cardLayout.show(this.getMainPanel(), componentName);
    }

    protected void addToTree(DefaultMutableTreeNode node, JPanel panel) {
        node.add(new DefaultMutableTreeNode(panel));
        this.getMainPanel().add((Component)panel, panel.getName());
    }

    protected JTree getTree() {
        if (this.tree == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode(EMPTY_STRING);
            this.tree = new JTree(root);
            this.tree.setCellRenderer(new TreeRenderer());
            this.tree.addTreeSelectionListener(new TreeListener());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.initTree(root);
            this.tree.expandRow(0);
            this.tree.setRootVisible(false);
            this.tree.setSelectionRow(0);
            this.tree.setShowsRootHandles(true);
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == '\u001b') {
                        AbstractModelIDObjectPropertiesDialog.this.bnCancel.doClick();
                    } else if (e.getKeyCode() == 112) {
                        AbstractModelIDObjectPropertiesDialog.this.showHelp();
                    }
                }
            });
        }
        return this.tree;
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        this.getAppView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dispose();
    }

    protected void onOK() {
        if (this.canExit()) {
            this.setProperties();
            this.modelIDObject.setShowForFirstTime(false);
            this.close();
        }
    }

    protected void onApply() {
        if (this.canExit()) {
            this.setProperties();
            this.modelIDObject.setShowForFirstTime(false);
        }
    }

    protected void onCancel() {
        if (this.modelIDObject.showForFirstTime()) {
            this.modelIDObject.remove();
        }
    }

    protected boolean canExit() {
        if (StringUtilities.isNotEmpty(this.tfName.getText())) {
            return true;
        }
        MessageDialogs.showErrorMessage(this, Messages.getString("AbstractPropertiesDialog.NameCanNotBeEmpty"));
        this.tfName.requestFocus();
        return false;
    }

    protected void initLayout() {
        JScrollPane scrollPane = new JScrollPane(this.getTree());
        scrollPane.setMinimumSize(new Dimension(this.getMinimumTreeWidth(), 0));
        JSplitPane splitPane = new JSplitPane(1, scrollPane, this.getMainPanel());
        splitPane.setDividerLocation(this.getMinimumTreeWidth());
        splitPane.setDividerSize(3);
        FlowLayout flowLayout = new FlowLayout(2);
        this.pnButtons = new JPanel(flowLayout);
        String cancelStr = Messages.getString("AbstractPropertiesDialog.Close");
        if (this.isEditable()) {
            JButton bnOK = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.OK")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractModelIDObjectPropertiesDialog.this.onOK();
                }
            });
            bnOK.setMnemonic(79);
            bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.getRootPane().setDefaultButton(bnOK);
            JButton bnApply = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.Apply")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractModelIDObjectPropertiesDialog.this.onApply();
                }
            });
            bnApply.setMnemonic(65);
            bnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.pnButtons.add(bnOK);
            this.pnButtons.add(bnApply);
            cancelStr = Messages.getString("AbstractPropertiesDialog.Cancel");
        }
        this.bnCancel = new JButton(new AbstractAction(cancelStr){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractModelIDObjectPropertiesDialog.this.onCancel();
                AbstractModelIDObjectPropertiesDialog.this.close();
            }
        });
        this.bnCancel.setMnemonic(67);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        JButton bnHelp = new JButton(new AbstractAction(Messages.getString("AbstractPropertiesDialog.Help")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractModelIDObjectPropertiesDialog.this.showHelp();
            }
        });
        bnHelp.setMnemonic(72);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.pnButtons.add(this.bnCancel);
        this.pnButtons.add(bnHelp);
        this.getContentPane().add((Component)splitPane, "Center");
        this.getContentPane().add((Component)this.pnButtons, "South");
    }

    protected void initDefaults() {
        this.initDefaults(true);
    }

    protected void initDefaults(boolean initCommentsInRDBMS) {
        this.tfName.setText(this.modelIDObject.getName());
        this.taComments.setText(this.modelIDObject.getComment());
        if (initCommentsInRDBMS) {
            this.taCommentsInRDBMS.setText(this.modelIDObject.getCommentInRDBMS());
        }
        this.taNotes.setText(this.modelIDObject.getNotes());
        this.tfObjectID.setText(this.modelIDObject.getObjectID());
        this.tfCreationTime.setText(this.modelIDObject.getCreationTime());
        this.tfCreator.setText(this.modelIDObject.getCreator().getName());
        this.tfDesign.setText(this.modelIDObject.getOwnerDesignName());
        this.tfGeneratorName.setText(NONE);
        this.tfLastChangedBy.setText(this.modelIDObject.getChanger().getName());
        this.tfLastChangedTime.setText(this.modelIDObject.getChangeTime());
        if (this.modelIDObject.getRepositoryOID() != null) {
            this.tfRepositoryOID.setText(this.modelIDObject.getRepositoryOID());
        } else {
            this.tfRepositoryOID.setText(NONE);
        }
        this.initSummaryExtras();
    }

    protected void initSummaryExtras() {
        for (int i = this.pnSummaryGrid.getComponentCount(); i > this.summaryCount; --i) {
            this.pnSummaryGrid.remove(i - 1);
        }
        if (!EMPTY_STRING.equals(this.modelIDObject.getSourceConnName())) {
            this.pnSummaryGrid.add(this.pnDataDictConnection);
            this.pnSummaryGrid.add(this.pnDataDictSchema);
            this.pnSummaryGrid.add(this.pnDataDictObject);
            this.tfDataDictConnection.setText(this.modelIDObject.getSourceConnName());
            this.tfDataDictSchema.setText(this.modelIDObject.getSourceObjSchema());
            this.tfDataDictObject.setText(this.modelIDObject.getSourceObjName());
        }
        if (!EMPTY_STRING.equals(this.modelIDObject.getSourceDDLFile())) {
            this.pnSummaryGrid.add(this.pnDDLFileName);
            this.tfDDLFileName.setText(this.modelIDObject.getSourceDDLFile());
        }
        this.pnSummaryGrid.validate();
    }

    protected int getMinimumTreeWidth() {
        return 190;
    }

    protected boolean isEditable() {
        if (this.getModelIDObject().getDesign().isHidden()) {
            return false;
        }
        if (this.getModelIDObject().isReadOnly()) {
            return false;
        }
        if (this.getModelIDObject().isRemoteObject()) {
            return false;
        }
        return !ApplicationView.IS_VIEWER;
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent arg0) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent arg0) throws ExpandVetoException {
        ModelIdObjectSelection sel;
        Object object = arg0.getPath().getLastPathComponent();
        if (object instanceof ModelIdObjectSelection && !(sel = (ModelIdObjectSelection)object).isLoaded()) {
            sel.load();
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    protected String translate(String value, String[] inputValues, String[] outputValues) {
        for (int i = 0; i < inputValues.length; ++i) {
            if (!inputValues[i].equals(value)) continue;
            return outputValues[i];
        }
        return EMPTY_STRING;
    }

    class TreeRenderer
    extends DefaultTreeCellRenderer {
        TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof Component) {
                Component c = (Component)node.getUserObject();
                this.setText(c.getName());
            }
            return this;
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)AbstractModelIDObjectPropertiesDialog.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object obj = node.getUserObject();
            if (obj instanceof Component) {
                AbstractModelIDObjectPropertiesDialog.this.showComponent((Component)obj);
            }
        }
    }
}

