/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.ide.Ide;

public class FKEdge
extends DefaultEdge {
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    public FKIndexAssociation getFK() {
        return (FKIndexAssociation)this.getTopView().getModel();
    }

    @Override
    public String getName() {
        return this.getFK().getName();
    }

    @Override
    public Object getUserObject() {
        if (this.getTopView() != null && this.getFK() != null) {
            return this.getName();
        }
        return null;
    }

    @Override
    public void showPopupMenu(Point pt) {
        this.point.setLocation(pt);
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu.removeAll();
        if (this.getTopView().getDesign().isHidden()) {
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FKEdge.this.showProperty();
                }
            });
            return this.menu;
        }
        if (this.isEditable()) {
            AbstractAction act;
            boolean canDelete = true;
            for (Object obj : this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects()) {
                if (!(obj instanceof FKIndexAssociation) || !((FKIndexAssociation)obj).getContainerWithKeyObject().isRemoteObject()) continue;
                canDelete = false;
                break;
            }
            if (this.selectedObjects.length > 1) {
                DesignPartView dpv;
                act = new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDiagramCell.deleteObjects(FKEdge.this.selectedObjects, FKEdge.this.getDiagram().getAppView());
                    }
                };
                act.setEnabled(canDelete);
                this.menu.add(act);
                final List list = this.getConnectors(this.selectedObjects);
                if (list.size() > 0 && this.getTopView() != null && !(dpv = this.getTopView().getDesignPartView()).isMainDiagram() && dpv.isSupportLineHiding()) {
                    this.menu.addSeparator();
                    this.menu.add(new AbstractAction(HIDE_LINES){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FKEdge.this.hideRelations(list);
                        }
                    });
                }
            } else {
                DesignPartView dpv;
                act = new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FKEdge.this.deleteFK();
                    }
                };
                act.setEnabled(canDelete);
                this.menu.add(act);
                if (this.getTopView() != null && !(dpv = this.getTopView().getDesignPartView()).isMainDiagram() && dpv.isSupportLineHiding()) {
                    this.menu.addSeparator();
                    this.menu.add(new AbstractAction(HIDE){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FKEdge.this.hideRelation();
                        }
                    });
                }
            }
            this.menu.addSeparator();
            this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FKEdge.this.straightenLine();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FKEdge.this.format();
                }
            });
            this.menu.addSeparator();
            this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FKEdge.this.addBreakpoint(FKEdge.this.point);
                }
            });
            this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FKEdge.this.removeBreakpoint(FKEdge.this.point);
                }
            });
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKEdge.this.showProperty();
            }
        });
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean b = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!b);
                this.miRemoveBP.setEnabled(b && this.canDeleteBreakpoint());
            }
        }
        return this.menu;
    }

    public void deleteFK() {
        FKIndexAssociation fkIndex = this.getFK();
        if (!fkIndex.getContainerWithKeyObject().isRemoteObject()) {
            ((RelationalDesign)fkIndex.getDesignPart()).postFKRemoveEdit(fkIndex);
            KeyObject key = fkIndex.getLocalFKIndex();
            TVConnector connector = (TVConnector)this.getTopView();
            if (connector.remove(key)) {
                ApplicationView.log(MessageFormat.format(Messages.getString("FKEdge.DeleteFKRelation"), key.getName()));
            }
        } else {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("FKEdge.DeleteRemoteFK"), fkIndex.getName(), fkIndex.getTable().getName()));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteFK();
    }
}

