/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.process.InOutParams;
import oracle.dbtools.crest.model.design.process.ParameterObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.process.DFDRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class InOutParamsRenderer
extends DFDRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(250, 250, 250);
    private InOutParams inOutParams;

    public InOutParamsRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
    }

    @Override
    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("In-Out Parameters");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.processObject.getDesign().getDesignLevelSettings().getDefaultFCObject("In-Out Parameters");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public void paint(Graphics g) {
        this.inOutParams = (InOutParams)this.processObject;
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        g2.setPaint(this.getBackgroundColor());
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(this.getBorderColor());
        g.drawRect(0, 0, width - 1, height - 1);
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getHeight();
        int yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(this.title)) / 2;
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        g.setFont(titleFont);
        g.drawString(this.title, xCursor, yCursor);
        DesignPartView dpv = this.getDesignPartView();
        if (dpv != null && !dpv.clearDetails() && !dpv.isShowNamesOnly()) {
            g2.setStroke(lineStroke);
            g.setColor(this.getBorderColor());
            g.drawLine(0, yCursor += fm.getMaxDescent(), width - 2, yCursor);
            g2.setStroke(textStroke);
            g.setFont(efo.getFontObject(EditableFonts.FO_PARAMETERS).getFont());
            Object[] elements = this.inOutParams.getParams().toArray();
            String longestName = this.getLongestName(elements);
            fm = g.getFontMetrics();
            int anLeft = fm.stringWidth(longestName) + 20;
            for (int i = 0; i < elements.length; ++i) {
                ParameterObject element = (ParameterObject)elements[i];
                g.setColor(efo.getFontObject(EditableFonts.FO_PARAMETERS).getColor());
                g.drawString(element.getName(), 5, yCursor += fm.getHeight());
                g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                g.drawString(element.getLogicalDatatype().toString(), anLeft, yCursor);
                if (yCursor <= height) continue;
                g.setColor(this.getBorderColor());
                int right = width - 4;
                int left = right - 8;
                int center = right - 4;
                int bottom = height - 4;
                int top = bottom - 8;
                int[] xPts = new int[]{center, left, right};
                int[] yPts = new int[]{bottom, top, top};
                g.fillPolygon(xPts, yPts, 3);
                break;
            }
        }
    }

    private String getLongestName(Object[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = ((DesignObject)elements[i]).getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }
}

