/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.NoteDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.NoteView;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TextRenderer
extends JTextArea
implements CellViewRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = Color.WHITE;
    public static final Color DEFAULT_BORDER_COLOR = Color.BLACK;
    protected transient Color bordercolor;
    protected transient Color defaultForeground = DEFAULT_FOREGROUND;
    protected transient Color defaultBackground = DEFAULT_BACKGROUND;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient AbstractDiagram diagram;
    protected transient int borderWidth;
    protected transient Note note;
    protected CellView view;

    public TextRenderer() {
        this.bordercolor = DEFAULT_BORDER_COLOR;
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView cellview, boolean sel, boolean focus, boolean preview) {
        if (cellview instanceof NoteView) {
            NoteDiagramCell cell = (NoteDiagramCell)cellview.getCell();
            this.note = cell.getNote();
            this.setText(this.note.getText());
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            this.view = cellview;
        }
        this.installAttributes(cellview);
        return this;
    }

    protected void installAttributes(CellView view) {
        Map map = view.getAllAttributes();
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground(this.getForegroundColor());
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setFont(this.diagram.getFont());
    }

    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.note.getDesign().getDesignLevelSettings().getDefaultFCObject("Note");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return Color.LIGHT_GRAY;
        }
        return this.getTopView().getBackgroundColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.note.getDesign().getDesignLevelSettings().getDefaultFCObject("Note");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.bordercolor;
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.note != null) {
            return this.note.getTopView();
        }
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        TopView efo = this.getTopView();
        this.setFont(efo.getFontObject(EditableFonts.FO_TITLE).getFont());
        this.setForeground(this.getForegroundColor());
        g2.setPaint(this.getBackgroundColor());
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(this.getForegroundColor());
        g.drawRect(0, 0, width - 1, height - 1);
        this.setOpaque(false);
        this.setForeground(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        super.paint(g);
        g.setColor(this.diagram.getBackground());
        g.drawRect(0, 0, width - 1, height - 1);
        g.fillRect(width - 15, 0, width - 1, 14);
        g.setColor(this.getForegroundColor());
        g2.drawLine(0, 0, width - 15, 0);
        g2.drawLine(0, 0, 0, height - 1);
        g2.drawLine(0, height - 1, width - 1, height - 1);
        g2.drawLine(width - 1, height - 1, width - 1, 14);
        g2.drawLine(width - 15, 0, width - 1, 14);
        g2.drawLine(width - 15, 0, width - 15, 14);
        g2.drawLine(width - 15, 14, width - 1, 14);
    }

    public Point2D getPerimeterPoint(NoteView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }
}

