/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.LabelView;

public class LabelDiagramCell
extends DefaultDiagramCell {
    private JPopupMenu menu;
    private JCheckBoxMenuItem mTargetAboveLine;
    private JCheckBoxMenuItem mSourceBelowLine;
    private Label label;
    DefaultEdge edge;

    public LabelDiagramCell(Label label) {
        this(label, DiagramConstants.createMap());
    }

    public LabelDiagramCell(Label label, Map attributeMap) {
        this.label = label;
        this.setAttributes(attributeMap);
        DiagramConstants.setValue(this.getAttributes(), label.getName());
    }

    @Override
    public void doubleClick() {
        TVConnector tv;
        if (this.label.isRelationshipAttributesLabel() && (tv = this.label.getTVConnector()) != null) {
            tv.getModel().showPropertyDialog();
        }
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            this.menu.add(new AbstractAction(FORMAT){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelDiagramCell.this.format();
                }
            });
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(RESET_LABEL_SIZE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelDiagramCell.this.resetLabelSize();
                }
            });
            if (this.label.isTargetLabel()) {
                this.mTargetAboveLine = new JCheckBoxMenuItem(TARGET_LABEL_ABOVE);
                this.menu.add(this.mTargetAboveLine);
                this.mTargetAboveLine.setSelected(this.label.isTargetAboveTheLine());
                this.mTargetAboveLine.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        TVConnector tc;
                        LabelDiagramCell.this.label.setTargetAboveTheLine(!LabelDiagramCell.this.label.isTargetAboveTheLine());
                        LabelView lv = (LabelView)LabelDiagramCell.this.getCellView();
                        if (lv != null && (tc = LabelDiagramCell.this.label.getTVConnector()) != null) {
                            try {
                                EdgeView ev = (EdgeView)tc.getCellView();
                                if (ev != null) {
                                    ev.refreshLabels();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            tc.getDesignPartView().setDirty(true);
                        }
                    }
                });
            }
            if (this.label.isSourceLabel()) {
                this.mSourceBelowLine = new JCheckBoxMenuItem(SOURCE_LABEL_BELOW);
                this.menu.add(this.mSourceBelowLine);
                this.mSourceBelowLine.setSelected(this.label.isTargetAboveTheLine());
                this.mSourceBelowLine.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        TVConnector tc;
                        LabelDiagramCell.this.label.setSourceBelowTheLine(!LabelDiagramCell.this.label.isSourceBelowTheLine());
                        LabelView lv = (LabelView)LabelDiagramCell.this.getCellView();
                        if (lv != null && (tc = LabelDiagramCell.this.label.getTVConnector()) != null) {
                            try {
                                EdgeView ev = (EdgeView)tc.getCellView();
                                if (ev != null) {
                                    ev.refreshLabels();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            tc.getDesignPartView().setDirty(true);
                        }
                    }
                });
            }
            this.menu.addSeparator();
            this.menu.add(new AbstractAction(SEND_TO_BACK){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LabelDiagramCell.this.getTopView().sendToBack();
                }
            });
        }
        return this.menu;
    }

    public Label getLabel() {
        return this.label;
    }

    public void resetLabelSize() {
        ((LabelView)this.getCellView()).resetLabelSize(true);
    }

    public DefaultEdge getEdge() {
        return this.edge;
    }

    public void setEdge(DefaultEdge edge) {
        this.edge = edge;
    }
}

