/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.designrules;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.designrules.CompositeRuleHandler;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DesignRule;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.designrules.domains.RHDomain;
import oracle.dbtools.crest.model.designrules.logical.RHAttribute;
import oracle.dbtools.crest.model.designrules.logical.RHEntity;
import oracle.dbtools.crest.model.designrules.logical.RHEntityView;
import oracle.dbtools.crest.model.designrules.logical.RHKey;
import oracle.dbtools.crest.model.designrules.process.RHAgent;
import oracle.dbtools.crest.model.designrules.process.RHFlow;
import oracle.dbtools.crest.model.designrules.process.RHProcess;
import oracle.dbtools.crest.model.designrules.process.RHStore;
import oracle.dbtools.crest.model.designrules.process.RHTransformation;
import oracle.dbtools.crest.model.designrules.process.RHTransformationTask;
import oracle.dbtools.crest.model.designrules.relational.RHColumn;
import oracle.dbtools.crest.model.designrules.relational.RHIndex;
import oracle.dbtools.crest.model.designrules.relational.RHTable;
import oracle.dbtools.crest.model.designrules.relational.RHTableLevelConstraint;
import oracle.dbtools.crest.model.designrules.relational.RHView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.designrules.DRTemporary;
import oracle.dbtools.crest.util.GUID;

public class DesignRuleSet {
    private String objectID;
    private String name;
    private ArrayList<DesignRule> designRules = new ArrayList();
    private ArrayList<DRTemporary> designRulesTemporary = new ArrayList();
    private ArrayList designRulesMissing = new ArrayList();

    public DesignRuleSet(String name, String objId) {
        this.name = name;
        this.objectID = objId == null ? new GUID().toString() : objId;
    }

    public DesignRuleSet(String name, String objId, ArrayList<DesignRule> designRules, ArrayList<DRTemporary> designRulesTemporary) {
        this(name, objId);
        this.designRules = designRules;
        this.designRulesTemporary = designRulesTemporary;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addRule(DesignRule designRule) {
        this.getDesignRules().add(designRule);
    }

    public void removeRuleSet(DesignRule designRule) {
        this.designRules.remove(designRule);
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<DesignRule> getDesignRules() {
        return this.designRules;
    }

    public void setDesignRules(ArrayList<DesignRule> desRules) {
        this.designRules = desRules;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    public void addDesignRuleTemporary(DRTemporary dr) {
        if (!this.getDesignRulesTemporary().contains(dr)) {
            this.getDesignRulesTemporary().add(dr);
        }
    }

    public ArrayList<DRTemporary> getDesignRulesTemporary() {
        return this.designRulesTemporary;
    }

    public void setDesignRulesTemporary(ArrayList<DRTemporary> designRulesTemporary) {
        this.designRulesTemporary = designRulesTemporary;
    }

    public DesignRuleSet copy() {
        return new DesignRuleSet(this.name, this.objectID, this.designRules, this.designRulesTemporary);
    }

    public void initDesignRules(ApplicationView appView) {
        this.getDesignRules().clear();
        ArrayList<DRTemporary> drTemporaryDRBasic = this.getDesignRulesTemporary();
        Iterator<DRTemporary> itDRTemporaryDRBasicIterator = drTemporaryDRBasic.iterator();
        DesignRule dr = null;
        boolean found = false;
        while (itDRTemporaryDRBasicIterator.hasNext()) {
            found = false;
            DRTemporary drT = itDRTemporaryDRBasicIterator.next();
            CompositeRuleHandler rhGeneral = new CompositeRuleHandler();
            RHDomain domainRH = new RHDomain();
            rhGeneral.add(domainRH);
            for (int i = 0; i <= rhGeneral.size() - 1; ++i) {
                RuleHandler rh = (RuleHandler)rhGeneral.getElement(i);
                for (int n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                    this.addRule(dr);
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            CompositeRuleHandler rhRelational = new CompositeRuleHandler();
            RHTable tableRH = new RHTable();
            rhRelational.add(tableRH);
            RHColumn columnRH = new RHColumn();
            rhRelational.add(columnRH);
            RHIndex indexRH = new RHIndex();
            rhRelational.add(indexRH);
            RHTableLevelConstraint constrRH = new RHTableLevelConstraint();
            rhRelational.add(constrRH);
            RHView viewRH = new RHView();
            rhRelational.add(viewRH);
            if (rhRelational != null) {
                for (int i = 0; i <= rhRelational.size() - 1; ++i) {
                    RuleHandler rh = (RuleHandler)rhRelational.getElement(i);
                    for (int n = 0; n <= rh.size() - 1; ++n) {
                        dr = (DesignRule)rh.getElement(n);
                        if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                        this.addRule(dr);
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (found) continue;
            }
            CompositeRuleHandler rhLogical = new CompositeRuleHandler();
            RHEntity entityRH = new RHEntity();
            rhLogical.add(entityRH);
            RHAttribute attributeRH = new RHAttribute();
            rhLogical.add(attributeRH);
            RHKey keyRH = new RHKey();
            rhLogical.add(keyRH);
            RHEntityView entityViewRH = new RHEntityView();
            rhLogical.add(entityViewRH);
            for (int i = 0; i <= rhLogical.size() - 1; ++i) {
                RuleHandler rh = (RuleHandler)rhLogical.getElement(i);
                for (int n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                    this.addRule(dr);
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            CompositeRuleHandler rhProcess = new CompositeRuleHandler();
            RHProcess processRH = new RHProcess();
            rhProcess.add(processRH);
            RHFlow flowRH = new RHFlow();
            rhProcess.add(flowRH);
            RHStore storeRH = new RHStore();
            rhProcess.add(storeRH);
            RHAgent agentRH = new RHAgent();
            rhProcess.add(agentRH);
            RHTransformation transformationRH = new RHTransformation();
            rhProcess.add(transformationRH);
            RHTransformationTask trTaskRH = new RHTransformationTask();
            rhProcess.add(trTaskRH);
            for (int i = 0; i <= rhProcess.size() - 1; ++i) {
                RuleHandler rh = (RuleHandler)rhProcess.getElement(i);
                for (int n = 0; n <= rh.size() - 1; ++n) {
                    dr = (DesignRule)rh.getElement(n);
                    if (!drT.getRuleId().equals(dr.getRuleId())) continue;
                    this.addRule(dr);
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) continue;
            ArrayList<DRCustomValidationScript> currentCustomValidationRules = appView.getCustomValidationRules();
            for (DRCustomValidationScript cs0 : currentCustomValidationRules) {
                if (drT.getRuleId().equals(cs0.getRuleId())) {
                    this.addRule(cs0);
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found || found) continue;
            this.designRulesMissing.add(dr);
        }
    }

    public ArrayList getDesignRulesMissing() {
        return this.designRulesMissing;
    }
}

