/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import oracle.dbtools.crest.swingui.ddl.DDLFileMakerEditor;
import oracle.javatools.editor.ActionInvoker;

public final class DDLFileMakerEditorActions {
    private HashMap actionMap;
    public static final String undoActionName = "undo-edit";
    public static final String redoActionName = "redo-edit";
    private DDLFileMakerEditor ddlFileMakerEditor;
    private UndoSupport _undoSupport;

    public DDLFileMakerEditorActions(DDLFileMakerEditor ddlFileMakerEditor) {
        this.ddlFileMakerEditor = ddlFileMakerEditor;
        this.actionMap = new HashMap();
        AbstractAction action = new UndoAction();
        this.addAction(undoActionName, action);
        action = new RedoAction();
        this.addAction(redoActionName, action);
        action = new InvokerAction("cut-to-clipboard");
        this.addAction("cut-to-clipboard", action);
        action = new InvokerAction("copy-to-clipboard");
        this.addAction("copy-to-clipboard", action);
        action = new InvokerAction("paste-from-clipboard");
        this.addAction("paste-from-clipboard", action);
        action = new InvokerAction("select-all");
        this.addAction("select-all", action);
        this._undoSupport = new UndoSupport();
        ddlFileMakerEditor.getEditorPane().addPropertyChangeListener((PropertyChangeListener)this._undoSupport);
        ddlFileMakerEditor.getEditorPane().getDocument().addUndoableEditListener(this._undoSupport);
    }

    public void clearAllEdits() {
        this._undoSupport.discardAllEdits();
    }

    void updateUndoRedo() {
        Action undoAction = this.findAction(undoActionName);
        undoAction.setEnabled(this._undoSupport.canUndo());
        Action redoAction = this.findAction(redoActionName);
        redoAction.setEnabled(this._undoSupport.canRedo());
    }

    public Action findAction(String actionKey) {
        return (Action)this.actionMap.get(actionKey);
    }

    public void addAction(String actionKey, Action action) {
        this.actionMap.put(actionKey, action);
    }

    public Action getUndoAction() {
        return this.findAction(undoActionName);
    }

    public Action getRedoAction() {
        return this.findAction(redoActionName);
    }

    public class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(DDLFileMakerEditorActions.undoActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DDLFileMakerEditorActions.this._undoSupport.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            DDLFileMakerEditorActions.this.updateUndoRedo();
        }
    }

    public class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(DDLFileMakerEditorActions.redoActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DDLFileMakerEditorActions.this._undoSupport.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            DDLFileMakerEditorActions.this.updateUndoRedo();
        }
    }

    public class InvokerAction
    extends AbstractAction {
        public InvokerAction(String actionKey) {
            super(actionKey);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionInvoker invoker = DDLFileMakerEditorActions.this.ddlFileMakerEditor.getEditorPane().getActionInvoker();
            invoker.invokeAction((String)this.getValue("Name"));
        }
    }

    private class UndoSupport
    extends UndoManager
    implements PropertyChangeListener {
        private UndoSupport() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            super.undoableEditHappened(e);
            DDLFileMakerEditorActions.this.updateUndoRedo();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("document".equals(name)) {
                Document newD;
                this.discardAllEdits();
                Document old = (Document)e.getOldValue();
                if (old != null) {
                    old.removeUndoableEditListener(this);
                }
                if ((newD = (Document)e.getNewValue()) != null) {
                    newD.addUndoableEditListener(this);
                }
            }
        }
    }
}

