/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.PackageBodyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PackageOracle;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ddl.DDLFileMakerEditor;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionDialog;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DDLSelectionPersistence {
    public static final String DDL_SELECTION_LIST = "DDLSelection.local";
    public static final String PRESERVED_DDL_SELECTION_LIST = "Preserved_DDLSelection.local";
    public static final String PERSISTED_DDL_SELECTION = "DatamodelerPersistedDDLSelection";
    public static final String DESIGN_NAME = "designName";
    public static final String SELECTED_SUBVIEW = "selectedSubView";
    public static final String SUBVIEW_NAME = "subviewName";
    public static final String INCLUDE_COMMENTS = "IncludeComments";
    public static final String GENERATE_DDL_IN_FILES = "generateDDLInFiles";
    public static final String GENERATE_REST_SERVICES = "generateRESTServices";
    public static final String APPLY_NAME_SUBSTITUTION = "applyNameSubstitution";
    public static final String INCLUDE_TABLE_SCRIPTS = "includeTableScripts";
    public static final String TABLE_SCRIPT = "tableScript";
    public static final String TABLE_NAME = "tableName";
    public static final String SD_OBJECT = "storageDesignObject";
    public static final String SD_CLASS = "storageDesignClass";
    public static final String SD_NAME = "storageDesignName";
    public static final String NAMES_SUBSTITUTION = "namesSubstitution";
    public static final String NAME_SUBSTITUTION = "nameSubstitution";
    public static final String IS_CASE_SENSITIVE = "isCaseSensitive";
    public static final String OLD_NAME = "oldName";
    public static final String NEW_NAME = "newName";
    public static final String COMMENTS = "comments";
    public static final String OBJECT_TYPES = "objectTypes";
    public static final String USE_DDL_TRANSFORMATION_SCRIPT = "UseDDLTransformationScript";
    public static final String TYPE = "type";
    public static final String KEY = "OSDDM_DDLPP";
    public static final String TABLE_LEVEL_CONSTRAINTS = "tableLevelConstraints";
    public static final String TABLE_LEVEL_CONSTRAINT = "tableLevelConstraint";
    public static final String CONSTRAINT_NAME = "constraintName";
    public static final String CONSTRAINT_RULE = "constraintRule";
    public static final String TABLE_COLUMNS = "tableColumns";
    public static final String TABLE_COLUMN = "tableColumn";
    public static final String COLUMN_ID = "columnID";
    public static final String CONSTRAINT_MARKED_GENERATE = "constraintMarkedGenerate";
    public static final String EXISTENCE_DEPENDENCIES = "existenceDependencies";
    public static final String EXISTENCE_DEPENDENCY = "existenceDependency";
    public static final String EXISTENCE_DEPENDENCY_NAME = "existenceDependencyName";
    public static final String FK_DEP_COLUMN_CONSTRAINT_IN_DDL = "dependantColConstrInDDL";
    public static final String DROP_SELECTION = "dropSelection";
    public static final String DROP_GENERATED_OBJECTS_ONLY = "dropGeneratedObjectsOnly";
    public static final String USE_DROP_DEPENDENCIES = "useDropDependencies";
    public static final String DROPABLE_OBJECT = "dropableObject";
    public static final String ACTIVE_SCRIPT_SET_CB_INDEX = "activeScriptSetCBIndex";
    public static final String SELECTED_INDEX = "selectedIndex";
    public static final String MARKED_GENERATE = "markedGenerate";
    private String ddlSelectionFileNameBLPS = null;
    private String persistedDDLSelectionPath = null;
    private static final Logger LOGGER = new Logger(DDLSelectionPersistence.class);
    private boolean saveSelectionsBLPS = false;
    private boolean DDLGenerated = false;
    private IncludeCommentsAndApplyNameSubstitutionHelper icansHelper;
    private boolean selectedSubViewChanged = false;
    private boolean DDLSelectionLoaded = false;

    public void saveDDLSelectionForDesign(Design design, boolean isIncludeCommentsSelected, boolean isApplyNameSubstitutionSelected, boolean isDropGeneratedObjectsOnly, boolean isUseDropDependencies, JTable insertionTable, JTable tbSubstitution, JTable tbObjectTypes, JList dropableList, boolean isGenerateDDLInFilesSelected, boolean isGenerateRESTServicesEnabled, DDLFileMakerEditor fileMakerEditor, int cbActiveSelectedIndex) {
        String ddlSelectionFilePath;
        Object ddlSelectionFileName;
        RDBMSSite rdbmsSite = design.getSelectedRDBMSSite();
        DesignPartView dpView = (DesignPartView)fileMakerEditor.getDesignSubViewCombo().getSelectedItem();
        List listOfDDLObjects = design.getRelationalDesign().getStorageDesign(rdbmsSite).getListOfDDLObjects();
        DesignPartStorableObjectsSelectionPair wdpso = new DesignPartStorableObjectsSelectionPair();
        wdpso.designPart = dpView.getDesignPart();
        wdpso.storableObjects = listOfDDLObjects;
        ArrayList<DesignPartStorableObjectsSelectionPair> wddlSelectionlist = new ArrayList<DesignPartStorableObjectsSelectionPair>();
        wddlSelectionlist.add(wdpso);
        DataTypesDesign dataTypesDesign = design.getDataTypesDesign();
        DesignPartStorableObjectsSelectionPair dpso = null;
        StorageDesignModelIDObjectsSelectionPair sdmo = null;
        URLFilter fileFilter = new URLFilter(){

            public boolean accept(URL url) {
                File file = new File(url.getPath());
                return file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".xmlz") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("XMLTransformationManager.OracleSQLDeveloperModelingDDLSelection");
            }
        };
        ArrayList<DesignPartStorableObjectsSelectionPair> ddlSelectionlist = new ArrayList<DesignPartStorableObjectsSelectionPair>();
        ArrayList<StorageDesignModelIDObjectsSelectionPair> ddlSelectionlistSD = new ArrayList<StorageDesignModelIDObjectsSelectionPair>();
        if (this.saveSelectionsBLPS) {
            ddlSelectionFileName = PRESERVED_DDL_SELECTION_LIST;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("-ddMMyy-hhmmss.SSS");
            this.ddlSelectionFileNameBLPS = ddlSelectionFileName = (String)ddlSelectionFileName + simpleDateFormat.format(new Date());
            ddlSelectionFilePath = new File(design.getAppView().getUserHomeDirectory().getPath()).getAbsolutePath();
        } else {
            ddlSelectionFileName = this.selectDDLGenerationSelectionFileName(design, design.getName(), Messages.getString("XMLTransformationManager.SaveSelection"), fileFilter, true);
            if (ddlSelectionFileName == null) {
                return;
            }
            ddlSelectionFilePath = this.getPersistedDDLSelectionPath();
        }
        if (dataTypesDesign.isLoaded() && (design.shouldExportFull(dataTypesDesign) || design.shouldExportPartial(dataTypesDesign))) {
            dpso = new DesignPartStorableObjectsSelectionPair();
            dpso.designPart = dataTypesDesign;
            dpso.storableObjects = dataTypesDesign.getMarkedGenerateObjects();
            ddlSelectionlist.add(dpso);
        }
        for (DesignPart model : design.getRelationalDesigns()) {
            if (!model.isLoaded() || !design.shouldExportFull(model) && !design.shouldExportPartial(model)) continue;
            RelationalDesign relationalDesign = (RelationalDesign)model;
            dpso = new DesignPartStorableObjectsSelectionPair();
            dpso.designPart = relationalDesign;
            dpso.storableObjects = relationalDesign.getMarkedGenerateObjects();
            ddlSelectionlist.add(dpso);
            StorageDesign[] storageDesigns = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
            for (int i = 0; i < storageDesigns.length; ++i) {
                StorageDesign stDes = storageDesigns[i];
                if (!stDes.isOpen()) continue;
                sdmo = new StorageDesignModelIDObjectsSelectionPair();
                sdmo.storageDesign = stDes;
                sdmo.modelIDObjects = stDes.getAllMarkedAndNotMarkedGenerateObjects();
                ddlSelectionlistSD.add(sdmo);
            }
        }
        this.saveDDLSelection(design, (String)ddlSelectionFileName, ddlSelectionFilePath, wddlSelectionlist, ddlSelectionlistSD, isIncludeCommentsSelected, isApplyNameSubstitutionSelected, isDropGeneratedObjectsOnly, isUseDropDependencies, insertionTable, tbSubstitution, tbObjectTypes, dropableList, isGenerateDDLInFilesSelected, isGenerateRESTServicesEnabled, cbActiveSelectedIndex);
    }

    private boolean saveDDLSelection(Design design, String ddlSelectionFileName, String ddlSelectionFilePath, List<DesignPartStorableObjectsSelectionPair> ddlSelectionlist, List<StorageDesignModelIDObjectsSelectionPair> ddlSelectionlistSD, boolean isIncludeCommentsSelected, boolean isApplyNameSubstitutionSelected, boolean isDropGeneratedObjectsOnly, boolean isUseDropDependencies, JTable insertionTable, JTable tbSubstitution, JTable tbObjectTypes, JList dropableList, boolean isGenerateDDLInFilesSelected, boolean isGenerateRESTServicesEnabled, int cbActiveSelectedIndex) {
        DesignPart designPart = null;
        String dpClassName = "";
        StorageDesign storageDesign = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element rootElement = doc.createElement(PERSISTED_DDL_SELECTION);
            rootElement.setAttribute(DESIGN_NAME, design.getName());
            rootElement.setAttribute("objectID", design.getObjectID());
            doc.appendChild(rootElement);
            if (design.getSelectedSubView() != null) {
                Element selectedSubViewdElement = doc.createElement(SELECTED_SUBVIEW);
                selectedSubViewdElement.setAttribute(SUBVIEW_NAME, design.getSelectedSubView().getName());
                selectedSubViewdElement.setAttribute("objectID", design.getSelectedSubView().getDPVId());
                rootElement.appendChild(selectedSubViewdElement);
            }
            Element includeCommentsSelectedElement = doc.createElement(INCLUDE_COMMENTS);
            includeCommentsSelectedElement.setAttribute("isSelected", Boolean.valueOf(isIncludeCommentsSelected).toString());
            rootElement.appendChild(includeCommentsSelectedElement);
            Element applyNameSubstitutionSelectedElement = doc.createElement(APPLY_NAME_SUBSTITUTION);
            applyNameSubstitutionSelectedElement.setAttribute("isSelected", Boolean.valueOf(isApplyNameSubstitutionSelected).toString());
            rootElement.appendChild(applyNameSubstitutionSelectedElement);
            Element generateDDLInFilesElement = doc.createElement(GENERATE_DDL_IN_FILES);
            generateDDLInFilesElement.setAttribute("isSelected", Boolean.valueOf(isGenerateDDLInFilesSelected).toString());
            rootElement.appendChild(generateDDLInFilesElement);
            Element generateRESTServicesElement = doc.createElement(GENERATE_REST_SERVICES);
            generateRESTServicesElement.setAttribute("isSelected", Boolean.valueOf(isGenerateRESTServicesEnabled).toString());
            rootElement.appendChild(generateRESTServicesElement);
            Element cbActiveSelectedIndexElement = doc.createElement(ACTIVE_SCRIPT_SET_CB_INDEX);
            cbActiveSelectedIndexElement.setAttribute(SELECTED_INDEX, new Integer(cbActiveSelectedIndex).toString());
            rootElement.appendChild(cbActiveSelectedIndexElement);
            for (DesignPartStorableObjectsSelectionPair dpsoPair : ddlSelectionlist) {
                String className;
                designPart = dpsoPair.designPart;
                dpClassName = className = designPart.getClass().getName();
                Iterator<StorableObject> objects = dpsoPair.storableObjects.iterator();
                Element dpRootElement = doc.createElement(className);
                dpRootElement.setAttribute("objectID", designPart.getObjectID());
                while (objects.hasNext()) {
                    StorableObject obj = objects.next();
                    Element child = doc.createElement("object");
                    if (obj instanceof DesignObject) {
                        child.setAttribute("objectID", ((DesignObject)obj).getObjectID());
                        child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((DesignObject)obj).isMarkedGenerate()).toString());
                        if (ApplicationView.debugMode) {
                            child.setAttribute("objectType", ((DesignObject)obj).getObjectTypeName());
                            if (obj instanceof Table) {
                                Table table = (Table)obj;
                                child.setAttribute(USE_DDL_TRANSFORMATION_SCRIPT, Boolean.valueOf(table.isUseDDLTransformationScript()).toString());
                                List tlcc = table.getCheckConstraints();
                                if (tlcc.size() > 0) {
                                    Element tableLevelConstraints = doc.createElement(TABLE_LEVEL_CONSTRAINTS);
                                    for (TableLevelConstraint tc : tlcc) {
                                        Element tableLevelConstraint = doc.createElement(TABLE_LEVEL_CONSTRAINT);
                                        tableLevelConstraint.setAttribute(CONSTRAINT_NAME, tc.getName());
                                        tableLevelConstraint.setAttribute(CONSTRAINT_RULE, tc.getRule());
                                        tableLevelConstraint.setAttribute(MARKED_GENERATE, tc.getGenerateInDDL());
                                        tableLevelConstraints.appendChild(tableLevelConstraint);
                                    }
                                    child.appendChild(tableLevelConstraints);
                                }
                                Element ed = doc.createElement(EXISTENCE_DEPENDENCIES);
                                Element ed1 = doc.createElement(EXISTENCE_DEPENDENCY);
                                ed1.setAttribute(EXISTENCE_DEPENDENCY_NAME, table.getExistDependencyConstraintName());
                                ed1.setAttribute(MARKED_GENERATE, Boolean.valueOf(table.isExistDependencyGenerateInDDl()).toString());
                                ed.appendChild(ed1);
                                child.appendChild(ed);
                                ColumnSet tcs = table.getColumnSet();
                                Element tableColumns = doc.createElement(TABLE_COLUMNS);
                                for (int i = 0; i < tcs.size(); ++i) {
                                    Element tableColumn = doc.createElement(TABLE_COLUMN);
                                    Column column = (Column)tcs.getElement(i);
                                    if (column.getTable() != table || !column.hasConstraintsDefined()) continue;
                                    tableColumn.setAttribute(COLUMN_ID, column.getObjectID());
                                    tableColumn.setAttribute(CONSTRAINT_MARKED_GENERATE, column.getGenerateConstraintInDDL());
                                    tableColumns.appendChild(tableColumn);
                                }
                                child.appendChild(tableColumns);
                            } else if (obj instanceof FKIndexAssociation) {
                                child.setAttribute(FK_DEP_COLUMN_CONSTRAINT_IN_DDL, Boolean.valueOf(((FKIndexAssociation)obj).isColumnDependencyConstraintGenerateInDDL()).toString());
                            }
                        }
                    } else {
                        if (!(obj instanceof StorageObject)) continue;
                        child.setAttribute("objectID", ((StorageObject)obj).getObjectID());
                        child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((StorageObject)obj).isMarkedGenerate()).toString());
                        if (ApplicationView.debugMode) {
                            child.setAttribute("objectType", ((StorageObject)obj).getObjectTypeName());
                            if (obj instanceof TableProxy) {
                                TableProxy tableProxy = (TableProxy)obj;
                                child.setAttribute(USE_DDL_TRANSFORMATION_SCRIPT, Boolean.valueOf(tableProxy.getObject().isUseDDLTransformationScript()).toString());
                            }
                        }
                    }
                    dpRootElement.appendChild(child);
                }
                rootElement.appendChild(dpRootElement);
            }
            for (StorageDesignModelIDObjectsSelectionPair sdmoPair : ddlSelectionlistSD) {
                storageDesign = sdmoPair.storageDesign;
                String className = storageDesign.getClass().getName();
                Iterator<ModelIDObject> modelIDObjects = sdmoPair.modelIDObjects.iterator();
                Element sdRootElement = doc.createElement(SD_OBJECT);
                sdRootElement.setAttribute(SD_CLASS, className);
                sdRootElement.setAttribute("objectID", storageDesign.getObjectID());
                sdRootElement.setAttribute(SD_NAME, storageDesign.getName());
                while (modelIDObjects.hasNext()) {
                    ModelIDObject obj = modelIDObjects.next();
                    Element child = doc.createElement("object");
                    if (obj instanceof DesignObject) {
                        child.setAttribute("objectID", ((DesignObject)obj).getObjectID());
                        child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((DesignObject)obj).isMarkedGenerate()).toString());
                        if (ApplicationView.debugMode) {
                            child.setAttribute("objectType", ((DesignObject)obj).getObjectTypeName());
                        }
                    } else {
                        if (!(obj instanceof StorageObject)) continue;
                        child.setAttribute("objectID", ((StorageObject)obj).getObjectID());
                        child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((StorageObject)obj).isMarkedGenerate()).toString());
                        if (ApplicationView.debugMode) {
                            child.setAttribute("objectType", ((StorageObject)obj).getObjectTypeName());
                        }
                        if (obj instanceof PackageOracle) {
                            sdRootElement.appendChild(child);
                            PackageBodyOracle pbo = ((PackageOracle)obj).getBody();
                            if (pbo != null) {
                                child = doc.createElement("object");
                                child.setAttribute("objectID", pbo.getObjectID());
                                child.setAttribute(MARKED_GENERATE, Boolean.valueOf(pbo.isMarkedGenerate()).toString());
                                if (ApplicationView.debugMode) {
                                    child.setAttribute("objectType", pbo.getObjectTypeName());
                                }
                            }
                        }
                    }
                    sdRootElement.appendChild(child);
                }
                rootElement.appendChild(sdRootElement);
            }
            Element includeTableScriptsElement = doc.createElement(INCLUDE_TABLE_SCRIPTS);
            int rowCount = insertionTable.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Element tableScriptElement = doc.createElement(TABLE_SCRIPT);
                tableScriptElement.setAttribute("isSelected", insertionTable.getModel().getValueAt(i, 0).toString());
                tableScriptElement.setAttribute(TABLE_NAME, insertionTable.getModel().getValueAt(i, 1).toString());
                includeTableScriptsElement.appendChild(tableScriptElement);
            }
            rootElement.appendChild(includeTableScriptsElement);
            Element namesSubstitutionElement = doc.createElement(NAMES_SUBSTITUTION);
            rowCount = tbSubstitution.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Element nameSubstitutionElement = doc.createElement(NAME_SUBSTITUTION);
                nameSubstitutionElement.setAttribute("isSelected", tbSubstitution.getModel().getValueAt(i, 0).toString());
                nameSubstitutionElement.setAttribute(IS_CASE_SENSITIVE, tbSubstitution.getModel().getValueAt(i, 1).toString());
                nameSubstitutionElement.setAttribute(OLD_NAME, tbSubstitution.getModel().getValueAt(i, 2).toString());
                nameSubstitutionElement.setAttribute(NEW_NAME, tbSubstitution.getModel().getValueAt(i, 3).toString());
                nameSubstitutionElement.setAttribute(COMMENTS, tbSubstitution.getModel().getValueAt(i, 4).toString());
                namesSubstitutionElement.appendChild(nameSubstitutionElement);
            }
            rootElement.appendChild(namesSubstitutionElement);
            Element objectTypesElement = doc.createElement(OBJECT_TYPES);
            rowCount = tbObjectTypes.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Element objectTypeElement = doc.createElement("objectType");
                objectTypeElement.setAttribute("isSelected", tbObjectTypes.getModel().getValueAt(i, 0).toString());
                objectTypeElement.setAttribute(TYPE, tbObjectTypes.getModel().getValueAt(i, 1).toString());
                objectTypesElement.appendChild(objectTypeElement);
            }
            rootElement.appendChild(objectTypesElement);
            Element ddlPreferencesElements = doc.createElement(KEY);
            this.appendElement(doc, "db2_term_char", design.getAppView().getSettings().getDB2TerminationCharacter(), ddlPreferencesElements);
            this.appendElement(doc, "type_subst_triggers", design.getAppView().getSettings().isGenerateTypeSubstTriggers(), ddlPreferencesElements);
            this.appendElement(doc, "fkarct_triggers", design.getAppView().getSettings().isGenerateFKArcTriggers(), ddlPreferencesElements);
            this.appendElement(doc, "fk_none_transferable_triggers", design.getAppView().getSettings().isGenerateFKNoneTransferableTriggers(), ddlPreferencesElements);
            this.appendElement(doc, "show_char_byte_in_ddl", design.getAppView().getSettings().isShowByteCharInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "extended_size_for_chars", design.getAppView().getSettings().isExtendedSizeForCharacters(), ddlPreferencesElements);
            this.appendElement(doc, "not_null_short_form_generation", design.getAppView().getSettings().notNullShortFormGeneration(), ddlPreferencesElements);
            this.appendElement(doc, "use_quoted_identifiers", design.getAppView().getSettings().isUseQuotedIdentifiers(), ddlPreferencesElements);
            this.appendElement(doc, "create_domains_during_import", design.getAppView().getSettings().isCreateDomainsDuringImport(), ddlPreferencesElements);
            this.appendElement(doc, "generate_comments_in_rdbms", design.getAppView().getSettings().isGenerateCommentsInRDBMS(), ddlPreferencesElements);
            this.appendElement(doc, "generate_inline_column_cc", design.getAppView().getSettings().isGenerateInlineColumnCC(), ddlPreferencesElements);
            this.appendElement(doc, "generate_valid_value_cc", design.getAppView().getSettings().isGenerateValidValueCC(), ddlPreferencesElements);
            this.appendElement(doc, "include_default_settings_in_ddl", design.getAppView().getSettings().isIncludeDefaultSettingsInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_logging_in_ddl", design.getAppView().getSettings().isIncludeLoggingInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_schema_in_ddl", design.getAppView().getSettings().isIncludeSchemaInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_storage_in_ddl", design.getAppView().getSettings().isIncludeStorageInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_tablespace_in_ddl", design.getAppView().getSettings().isIncludeTablespaceInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "automatic_pk_generation", design.getDesignLevelSettings().isAutomaticPKGeneration(), ddlPreferencesElements);
            this.appendElement(doc, "automatic_uk_generation", design.getDesignLevelSettings().isAutomaticUKGeneration(), ddlPreferencesElements);
            this.appendElement(doc, "automatic_fk_generation", design.getDesignLevelSettings().isAutomaticFKGeneration(), ddlPreferencesElements);
            this.appendElement(doc, "include_pctfree_in_ddl", design.getAppView().getSettings().isIncludePctFreeInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_pctused_in_ddl", design.getAppView().getSettings().isIncludePctUsedInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_initrans_in_ddl", design.getAppView().getSettings().isIncludeInitransInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_initialextent_in_ddl", design.getAppView().getSettings().isIncludeInitialExtentInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_nextextent_in_ddl", design.getAppView().getSettings().isIncludeNextExtentInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_minextents_in_ddl", design.getAppView().getSettings().isIncludeMinExtentsInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_maxextents_in_ddl", design.getAppView().getSettings().isIncludeMaxExtentsInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_pctincrease_in_ddl", design.getAppView().getSettings().isIncludePctIncreaseInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_bufferpool_in_ddl", design.getAppView().getSettings().isIncludeBufferPoolInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_freelists_in_ddl", design.getAppView().getSettings().isIncludeFreeListsInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_freelistgroups_in_ddl", design.getAppView().getSettings().isIncludeFreeListGroupsInDDL(), ddlPreferencesElements);
            this.appendElement(doc, "include_optimal_in_ddl", design.getAppView().getSettings().isIncludeOptimalInDDL(), ddlPreferencesElements);
            rootElement.appendChild(ddlPreferencesElements);
            Element dropSelectionElement = doc.createElement(DROP_SELECTION);
            Element dropGeneratedObjectsOnlyElement = doc.createElement(DROP_GENERATED_OBJECTS_ONLY);
            dropGeneratedObjectsOnlyElement.setAttribute("isSelected", Boolean.valueOf(isDropGeneratedObjectsOnly).toString());
            dropSelectionElement.appendChild(dropGeneratedObjectsOnlyElement);
            Element useDropDependenciesElement = doc.createElement(USE_DROP_DEPENDENCIES);
            useDropDependenciesElement.setAttribute("isSelected", Boolean.valueOf(isUseDropDependencies).toString());
            dropSelectionElement.appendChild(useDropDependenciesElement);
            for (int i = 0; i < dropableList.getModel().getSize(); ++i) {
                Object obj = dropableList.getModel().getElementAt(i);
                if (obj == null || !(obj instanceof DDLSelectionDialog.Dropable)) continue;
                DDLSelectionDialog.Dropable drp = (DDLSelectionDialog.Dropable)obj;
                Element dropableElement = doc.createElement(DROPABLE_OBJECT);
                dropableElement.setAttribute("name", drp.collection.getName());
                dropableElement.setAttribute("isSelected", Boolean.valueOf(drp.selected).toString());
                dropSelectionElement.appendChild(dropableElement);
            }
            rootElement.appendChild(dropSelectionElement);
            if (designPart != null) {
                return XMLTransformationManager.saveDocument(new File(ddlSelectionFilePath, ddlSelectionFileName + ".xml").getCanonicalPath(), doc, designPart.getDesign().isCompressedDesign());
            }
            return false;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Can not save DDL Selection list for: " + dpClassName, e);
        }
        catch (IOException e) {
            LOGGER.error("Can not save DDL Selection list for: " + dpClassName, e);
        }
        return false;
    }

    public static void saveDDLSelection(StorageDesign storageDesign, boolean markedGenerate) {
        if (!markedGenerate) {
            DDLSelectionPersistence.saveDDLSelection(storageDesign.getClass().getName(), storageDesign.getStoragePath(), storageDesign.getNotMarkedGenerateObjects().iterator(), DDL_SELECTION_LIST, storageDesign.getDesign().isCompressedDesign());
        } else {
            DDLSelectionPersistence.saveDDLSelection(storageDesign.getClass().getName(), storageDesign.getStoragePath(), storageDesign.getMarkedGenerateObjects().iterator(), DDL_SELECTION_LIST, storageDesign.getDesign().isCompressedDesign());
        }
    }

    protected static boolean saveDDLSelection(String className, String storagePath, Iterator objects, String fileName, boolean useCompressedFiles) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element rootElement = doc.createElement(className);
            doc.appendChild(rootElement);
            while (objects.hasNext()) {
                Object obj = objects.next();
                Element child = doc.createElement("object");
                if (obj instanceof DesignObject) {
                    child.setAttribute("objectID", ((DesignObject)obj).getObjectID());
                    child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((DesignObject)obj).isMarkedGenerate()).toString());
                    if (ApplicationView.debugMode) {
                        child.setAttribute("objectType", ((DesignObject)obj).getObjectTypeName());
                    }
                } else {
                    if (!(obj instanceof StorageObject)) continue;
                    child.setAttribute("objectID", ((StorageObject)obj).getObjectID());
                    child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((StorageObject)obj).isMarkedGenerate()).toString());
                    if (ApplicationView.debugMode) {
                        child.setAttribute("objectType", ((StorageObject)obj).getObjectTypeName());
                    }
                }
                rootElement.appendChild(child);
            }
            boolean saved = XMLTransformationManager.saveDocument(new File(storagePath, fileName).getCanonicalPath(), doc, useCompressedFiles);
            return true;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Can not save DDL Selection list for: " + className, e);
        }
        catch (IOException e) {
            LOGGER.error("Can not save DDL Selection list for: " + className, e);
        }
        return false;
    }

    public static void saveDDLSelection(DesignPart designPart, List<StorableObject> markedGenerateObjects) {
        DDLSelectionPersistence.saveDDLSelection(designPart, designPart.getStoragePath(), markedGenerateObjects.iterator(), DDL_SELECTION_LIST, designPart.getDesign().isCompressedDesign());
    }

    protected static boolean saveDDLSelection(DesignPart designPart, String storagePath, Iterator objects, String fileName, boolean useCompressedFiles) {
        String className = designPart.getClass().getName();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element rootElement = doc.createElement(className);
            rootElement.setAttribute("objectID", designPart.getObjectID());
            doc.appendChild(rootElement);
            while (objects.hasNext()) {
                Object obj = objects.next();
                Element child = doc.createElement("object");
                if (obj instanceof DesignObject) {
                    child.setAttribute("objectID", ((DesignObject)obj).getObjectID());
                    child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((DesignObject)obj).isMarkedGenerate()).toString());
                    if (ApplicationView.debugMode) {
                        child.setAttribute("objectType", ((DesignObject)obj).getObjectTypeName());
                    }
                } else {
                    if (!(obj instanceof StorageObject)) continue;
                    child.setAttribute("objectID", ((StorageObject)obj).getObjectID());
                    child.setAttribute(MARKED_GENERATE, Boolean.valueOf(((StorageObject)obj).isMarkedGenerate()).toString());
                    if (ApplicationView.debugMode) {
                        child.setAttribute("objectType", ((StorageObject)obj).getObjectTypeName());
                    }
                }
                rootElement.appendChild(child);
            }
            boolean saved = XMLTransformationManager.saveDocument(new File(storagePath, fileName).getCanonicalPath(), doc, useCompressedFiles);
            return true;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Can not save DDL Selection list for: " + className, e);
        }
        catch (IOException e) {
            LOGGER.error("Can not save DDL Selection list for: " + className, e);
        }
        return false;
    }

    public String selectDDLGenerationSelectionFileName(Design design, String defaultName, String title, URLFilter urlFilter, boolean isFileForSave) {
        try {
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(urlFilter);
            fileChooser.setPathContext("dataModeler_DDL");
            String lastDir = this.getPersistedDDLSelectionPath();
            if (lastDir != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
            } else {
                URL url = design.getAppView().getUserHomeDirectory();
                if (url != null) {
                    fileChooser.setSelectedURL(url);
                }
            }
            if (isFileForSave) {
                fileChooser.setFileNameURL(defaultName + ".xml");
            }
            boolean chooseAgain = true;
            while (chooseAgain) {
                chooseAgain = false;
                int status = isFileForSave ? fileChooser.showSaveDialog((Component)Ide.getMainWindow(), title) : fileChooser.showOpenDialog((Component)Ide.getMainWindow(), title);
                if (status == 0) {
                    File selected = new File(fileChooser.getSelectedURL().getPath());
                    this.setPersistedDDLSelectionPath(selected.getParentFile().getAbsolutePath());
                    String fileName = selected.getName();
                    if (fileName.endsWith(".dmdz")) {
                        // empty if block
                    }
                    if (isFileForSave && selected.exists()) {
                        int fileOverride = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("XMLTransformationManager.Override"), selected), Messages.getString("XMLTransformationManager.FileExists"), 0, 2);
                        chooseAgain = fileOverride == 1;
                    }
                    if (chooseAgain) continue;
                    return FileUtils.removeExt(fileName);
                }
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error select DDL file name", e);
        }
        return null;
    }

    public String getPersistedDDLSelectionPath() {
        return this.persistedDDLSelectionPath;
    }

    public void setPersistedDDLSelectionPath(String persistedDDLSelectionPath) {
        this.persistedDDLSelectionPath = persistedDDLSelectionPath;
    }

    private void appendElement(Document doc, String elementName, char termChar, Element parrentElement) {
        Element ddlPreferencesElement = doc.createElement(elementName);
        ddlPreferencesElement.setAttribute(elementName, Character.toString(termChar));
        parrentElement.appendChild(ddlPreferencesElement);
    }

    private void appendElement(Document doc, String elementName, boolean isChecked, Element parrentElement) {
        Element ddlPreferencesElement = doc.createElement(elementName);
        ddlPreferencesElement.setAttribute("isSelected", Boolean.valueOf(isChecked).toString());
        parrentElement.appendChild(ddlPreferencesElement);
    }

    public boolean restoreDDLSelectionForDesign(Design design, DDLFileMakerEditor fileMakerEditor, JTable insertionTable, JTable tbSubstitution, JTable tbObjectTypes, JList dropableList) {
        String ddlSelectionFilePath;
        String ddlSelectionFileName;
        DataTypesDesign dataTypesDesign = design.getDataTypesDesign();
        URLFilter fileFilter = new URLFilter(){

            public boolean accept(URL url) {
                File file = new File(url.getPath());
                return file.getName().toLowerCase().endsWith(".xml") || file.getName().toLowerCase().endsWith(".xmlz") || file.isDirectory();
            }

            public String toString() {
                return Messages.getString("XMLTransformationManager.OracleSQLDeveloperModelingDDLSelection");
            }
        };
        if (this.saveSelectionsBLPS && this.DDLGenerated) {
            ddlSelectionFileName = this.ddlSelectionFileNameBLPS;
            if (ddlSelectionFileName == null) {
                return false;
            }
            ddlSelectionFilePath = new File(design.getAppView().getUserHomeDirectory().getPath()).getAbsolutePath();
        } else {
            ddlSelectionFileName = this.selectDDLGenerationSelectionFileName(design, design.getName(), Messages.getString("XMLTransformationManager.RestoreSelection"), fileFilter, false);
            if (ddlSelectionFileName == null) {
                return false;
            }
            ddlSelectionFilePath = this.getPersistedDDLSelectionPath();
        }
        this.icansHelper = this.restoreDDLSelection(design, ddlSelectionFilePath, ddlSelectionFileName, fileMakerEditor);
        if (this.icansHelper == null) {
            return false;
        }
        this.restoreDDLSelection(design, ddlSelectionFilePath, ddlSelectionFileName, design.isCompressedDesign(), fileMakerEditor, insertionTable, tbSubstitution, tbObjectTypes, dropableList);
        if (dataTypesDesign.isLoaded() && (design.shouldExportFull(dataTypesDesign) || design.shouldExportPartial(dataTypesDesign))) {
            this.restoreDDLSelection(dataTypesDesign, ddlSelectionFilePath, ddlSelectionFileName);
        }
        Iterator it = design.getRelationalDesigns().iterator();
        RelationalDesign modelForWhichToRestoreDDLSelection = fileMakerEditor.getRelationalDesign();
        while (it.hasNext()) {
            DesignPart model = (DesignPart)it.next();
            if (!model.isLoaded() || !design.shouldExportFull(model) && !design.shouldExportPartial(model) || !model.getObjectID().equals(modelForWhichToRestoreDDLSelection.getObjectID())) continue;
            RelationalDesign relationalDesign = (RelationalDesign)model;
            this.restoreDDLSelection(relationalDesign, ddlSelectionFilePath, ddlSelectionFileName);
            StorageDesign[] storageDesigns = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
            for (int i = 0; i < storageDesigns.length; ++i) {
                StorageDesign storageDesign = storageDesigns[i];
                if (!storageDesign.isOpen()) continue;
                this.restoreDDLSelection(storageDesign, ddlSelectionFilePath, ddlSelectionFileName);
            }
        }
        Iterator<ID_Name_Pair> sdIt = this.getStoredDDLSelectionSDIDs(design, ddlSelectionFilePath, ddlSelectionFileName).iterator();
        for (DesignPart model : design.getRelationalDesigns()) {
            if (!model.isLoaded() || !design.shouldExportFull(model) && !design.shouldExportPartial(model)) continue;
            RelationalDesign relationalDesign = (RelationalDesign)model;
            StorageDesign[] storageDesigns = relationalDesign.getStorageDesignFactory().getOpenStorageDesigns();
            ID_Name_Pair sdId = null;
            boolean sdOpen = false;
            while (sdIt.hasNext()) {
                sdId = sdIt.next();
                sdOpen = false;
                for (int i = 0; i < storageDesigns.length; ++i) {
                    StorageDesign storageDesign = storageDesigns[i];
                    if (storageDesign.getObjectID().compareTo(sdId.id) != 0) continue;
                    if (!storageDesign.isOpen()) {
                        JLabel msgText = new JLabel(MessageFormat.format(Messages.getString("XMLTransformationManager.PhysicalModelNotOpen"), sdId.name));
                        JOptionPane.showMessageDialog(null, msgText, Messages.getString("XMLTransformationManager.Warning"), 2, null);
                        sdOpen = false;
                        continue;
                    }
                    sdOpen = true;
                }
                if (sdOpen) continue;
                JLabel msgText = new JLabel(MessageFormat.format(Messages.getString("XMLTransformationManager.PhysicalModelNotOpen"), sdId.name));
                JOptionPane.showMessageDialog(null, msgText, Messages.getString("XMLTransformationManager.Warning"), 2, null);
            }
        }
        if (this.saveSelectionsBLPS && this.DDLGenerated) {
            File file = null;
            file = design.isCompressedDesign() ? new File(ddlSelectionFilePath, this.ddlSelectionFileNameBLPS + ".xmlz") : new File(ddlSelectionFilePath, this.ddlSelectionFileNameBLPS + ".xml");
            if (file.exists()) {
                file.delete();
                this.ddlSelectionFileNameBLPS = null;
            }
        }
        return true;
    }

    private IncludeCommentsAndApplyNameSubstitutionHelper restoreDDLSelection(Design design, String ddlSelectionFilePath, String ddlSelectionFileName, DDLFileMakerEditor fileMakerEditor) {
        return this.getCSObjects(design, ddlSelectionFilePath, ddlSelectionFileName + ".xml", fileMakerEditor);
    }

    private void restoreDDLSelection(Design design, String ddlSelectionFilePath, String ddlSelectionFileName, boolean isCompressedDesign, DDLFileMakerEditor fileMakerEditor, JTable insertionTable, JTable tbSubstitution, JTable tbObjectTypes, JList dropableList) {
        try {
            Document doc = null;
            if (isCompressedDesign) {
                doc = XMLTransformationManager.getDocument(new File(ddlSelectionFilePath, ddlSelectionFileName + ".xmlz"));
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                File file = new File(ddlSelectionFilePath, ddlSelectionFileName + ".xml");
                if (file.exists()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
            }
            if (doc != null) {
                Element node;
                int i;
                NodeList nodeList = doc.getElementsByTagName(TABLE_SCRIPT);
                for (i = 0; i < nodeList.getLength(); ++i) {
                    node = (Element)nodeList.item(i);
                    this.setInsertionTableTableScriptsSelectionStatus(insertionTable, node.getAttribute(TABLE_NAME), node.getAttribute("isSelected"));
                }
                nodeList = doc.getElementsByTagName(NAME_SUBSTITUTION);
                for (i = 0; i < nodeList.getLength(); ++i) {
                    node = (Element)nodeList.item(i);
                    this.setNamesSubstitutionSelectionStatus(tbSubstitution, node.getAttribute("isSelected"), node.getAttribute(IS_CASE_SENSITIVE), node.getAttribute(OLD_NAME), node.getAttribute(NEW_NAME), node.getAttribute(COMMENTS));
                }
                nodeList = doc.getElementsByTagName("objectType");
                for (i = 0; i < nodeList.getLength(); ++i) {
                    node = (Element)nodeList.item(i);
                    this.setObjectTypeSelectionStatus(tbObjectTypes, node.getAttribute("isSelected"), node.getAttribute(TYPE));
                }
                design.getAppView().getSettings().setDB2TerminationCharacter(this.loadDDLPPTerminationCharacterSetting(doc, "db2_term_char"));
                design.getAppView().getSettings().setGenerateTypeSubstTriggers(this.loadDDLPPSetting(doc, "type_subst_triggers"));
                design.getAppView().getSettings().setGenerateFKArcTriggers(this.loadDDLPPSetting(doc, "fkarct_triggers"));
                design.getAppView().getSettings().setGenerateFKNoneTransferableTriggers(this.loadDDLPPSetting(doc, "fk_none_transferable_triggers"));
                design.getAppView().getSettings().setShowByteCharInDDL(this.loadDDLPPSetting(doc, "show_char_byte_in_ddl"));
                design.getAppView().getSettings().setExtendedSizeForCharacters(this.loadDDLPPSetting(doc, "extended_size_for_chars"));
                design.getAppView().getSettings().setNotNullShortFormGeneration(this.loadDDLPPSetting(doc, "not_null_short_form_generation"));
                design.getAppView().getSettings().setUseQuotedIdentifiers(this.loadDDLPPSetting(doc, "use_quoted_identifiers"));
                design.getAppView().getSettings().setCreateDomainsDuringImport(this.loadDDLPPSetting(doc, "create_domains_during_import"));
                design.getAppView().getSettings().setGenerateCommentsInRDBMS(this.loadDDLPPSetting(doc, "generate_comments_in_rdbms"));
                design.getAppView().getSettings().setGenerateInlineColumnCC(this.loadDDLPPSetting(doc, "generate_inline_column_cc"));
                design.getAppView().getSettings().setGenerateValidValueCC(this.loadDDLPPSetting(doc, "generate_valid_value_cc"));
                design.getAppView().getSettings().setIncludeDefaultSettingsInDDL(this.loadDDLPPSetting(doc, "include_default_settings_in_ddl"));
                design.getAppView().getSettings().setIncludeLoggingInDDL(this.loadDDLPPSetting(doc, "include_logging_in_ddl"));
                design.getAppView().getSettings().setIncludeSchemaInDDL(this.loadDDLPPSetting(doc, "include_schema_in_ddl"));
                design.getAppView().getSettings().setIncludeStorageInDDL(this.loadDDLPPSetting(doc, "include_storage_in_ddl"));
                design.getAppView().getSettings().setIncludeTablespaceInDDL(this.loadDDLPPSetting(doc, "include_tablespace_in_ddl"));
                design.getAppView().getSettings().setIncludeRedactionInDDL(this.loadDDLPPSetting(doc, "include_redaction_in_ddl"));
                design.getAppView().getSettings().setIncludeTSDPInDDL(this.loadDDLPPSetting(doc, "include_tsdp_in_ddl"));
                design.getDesignLevelSettings().setAutomaticPKGeneration(this.loadDDLPPSetting(doc, "automatic_pk_generation"));
                design.getDesignLevelSettings().setAutomaticUKGeneration(this.loadDDLPPSetting(doc, "automatic_uk_generation"));
                design.getDesignLevelSettings().setAutomaticFKGeneration(this.loadDDLPPSetting(doc, "automatic_fk_generation"));
                design.getAppView().getSettings().setIncludePctFreeInDDL(this.loadDDLPPSetting(doc, "include_pctfree_in_ddl"));
                design.getAppView().getSettings().setIncludePctUsedInDDL(this.loadDDLPPSetting(doc, "include_pctused_in_ddl"));
                design.getAppView().getSettings().setIncludeInitransInDDL(this.loadDDLPPSetting(doc, "include_initrans_in_ddl"));
                design.getAppView().getSettings().setIncludeInitialExtentInDDL(this.loadDDLPPSetting(doc, "include_initialextent_in_ddl"));
                design.getAppView().getSettings().setIncludeNextExtentInDDL(this.loadDDLPPSetting(doc, "include_nextextent_in_ddl"));
                design.getAppView().getSettings().setIncludeMinExtentsInDDL(this.loadDDLPPSetting(doc, "include_minextents_in_ddl"));
                design.getAppView().getSettings().setIncludeMaxExtentsInDDL(this.loadDDLPPSetting(doc, "include_maxextents_in_ddl"));
                design.getAppView().getSettings().setIncludePctIncreaseInDDL(this.loadDDLPPSetting(doc, "include_pctincrease_in_ddl"));
                design.getAppView().getSettings().setIncludeBufferPoolInDDL(this.loadDDLPPSetting(doc, "include_bufferpool_in_ddl"));
                design.getAppView().getSettings().setIncludeFreeListsInDDL(this.loadDDLPPSetting(doc, "include_freelists_in_ddl"));
                design.getAppView().getSettings().setIncludeFreeListGroupsInDDL(this.loadDDLPPSetting(doc, "include_freelistgroups_in_ddl"));
                design.getAppView().getSettings().setIncludeOptimalInDDL(this.loadDDLPPSetting(doc, "include_optimal_in_ddl"));
                design.getAppView().getSettings().setIncludeEncryptionInDDL(this.loadDDLPPSetting(doc, "include_encryption_in_ddl"));
                nodeList = doc.getElementsByTagName(DROPABLE_OBJECT);
                block5: for (i = 0; i < nodeList.getLength(); ++i) {
                    node = (Element)nodeList.item(i);
                    for (int j = 0; j < dropableList.getModel().getSize(); ++j) {
                        Object obj = dropableList.getModel().getElementAt(j);
                        if (obj == null || !(obj instanceof DDLSelectionDialog.Dropable)) continue;
                        DDLSelectionDialog.Dropable drp = (DDLSelectionDialog.Dropable)obj;
                        if (drp.collection.getName().compareTo(node.getAttribute("name")) != 0) continue;
                        drp.selected = new Boolean(node.getAttribute("isSelected"));
                        continue block5;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not parse CD Object List: " + ddlSelectionFilePath + File.separatorChar + ddlSelectionFileName, e);
        }
    }

    private boolean loadDDLPPSetting(Document doc, String elementName) {
        int i = 0;
        NodeList nodeList = doc.getElementsByTagName(elementName);
        if (i < nodeList.getLength()) {
            Element node = (Element)nodeList.item(i);
            return new Boolean(node.getAttribute("isSelected"));
        }
        return false;
    }

    private char loadDDLPPTerminationCharacterSetting(Document doc, String elementName) {
        int i = 0;
        NodeList nodeList = doc.getElementsByTagName(elementName);
        if (i < nodeList.getLength()) {
            Element node = (Element)nodeList.item(i);
            return node.getAttribute(elementName).charAt(0);
        }
        return ' ';
    }

    private void setInsertionTableTableScriptsSelectionStatus(JTable insertionTable, String tableName, String isSelected) {
        for (int i = 0; i < insertionTable.getRowCount(); ++i) {
            String insertionTableTableName = insertionTable.getModel().getValueAt(i, 1).toString();
            if (!insertionTableTableName.equals(tableName)) continue;
            insertionTable.getModel().setValueAt((boolean)new Boolean(isSelected), i, 0);
            return;
        }
    }

    private void setNamesSubstitutionSelectionStatus(JTable tbSubstitution, String isSelected, String isCaseSensitive, String oldName, String newName, String comments) {
        for (int i = 0; i < tbSubstitution.getRowCount(); ++i) {
            if (!tbSubstitution.getModel().getValueAt(i, 2).toString().equals(oldName) || !tbSubstitution.getModel().getValueAt(i, 3).toString().equals(newName) || !tbSubstitution.getModel().getValueAt(i, 4).toString().equals(comments)) continue;
            tbSubstitution.getModel().setValueAt((boolean)new Boolean(isSelected), i, 0);
            tbSubstitution.getModel().setValueAt((boolean)new Boolean(isCaseSensitive), i, 1);
            return;
        }
        SubstitutionPattern substPattern = new SubstitutionPattern();
        substPattern.setSelected(new Boolean(isSelected));
        substPattern.setCaseSensitive(new Boolean(isCaseSensitive));
        substPattern.setSourceString(oldName);
        substPattern.setReplacementString(newName);
        substPattern.setComments(comments);
        ((DDLSelectionDialog.SubstitutionModel)tbSubstitution.getModel()).getSubstitutionList().add(substPattern);
        tbSubstitution.updateUI();
    }

    private void setObjectTypeSelectionStatus(JTable tbObjectTypes, String isSelected, String type) {
        for (int i = 0; i < tbObjectTypes.getRowCount(); ++i) {
            String objectTypesTableTypeName = tbObjectTypes.getModel().getValueAt(i, 1).toString();
            if (!objectTypesTableTypeName.equals(type)) continue;
            tbObjectTypes.getModel().setValueAt((boolean)new Boolean(isSelected), i, 0);
            return;
        }
    }

    public static void restoreDDLSelection(StorageDesign storageDesign) {
        List<XMLTransformationManager.ObjectHelper> notMarkedGenerateObjects = XMLTransformationManager.getObjects(storageDesign.getStoragePath(), DDL_SELECTION_LIST, storageDesign.getDesign().isCompressedDesign());
        for (XMLTransformationManager.ObjectHelper notMarkedGenerateObject : notMarkedGenerateObjects) {
            ModelIDObject object = storageDesign.getModelIDObject(notMarkedGenerateObject.id);
            if (object == null) continue;
            object.setMarkedGenerate(false);
        }
    }

    public static void restoreDDLSelection(DesignPart designPart) {
        Design design = designPart.getDesign();
        List<XMLTransformationManager.ObjectHelper> markedGenerateObjects = XMLTransformationManager.getObjects(designPart.getStoragePath(), DDL_SELECTION_LIST, design.isCompressedDesign());
        for (XMLTransformationManager.ObjectHelper markedGenerateObject : markedGenerateObjects) {
            DesignObject designObject = design.getDesignObject(markedGenerateObject.id);
            if (designObject == null) continue;
            designObject.setMarkedGenerate(markedGenerateObject.markedGenerate);
        }
    }

    private void restoreDDLSelection(DesignPart designPart, String ddlSelectionFilePath, String ddlSelectionFileName) {
        Design design = designPart.getDesign();
        List<XMLTransformationManager.ObjectHelper> markedGenerateObjects = XMLTransformationManager.getObjects(ddlSelectionFilePath, ddlSelectionFileName + ".xml", design.isCompressedDesign());
        for (XMLTransformationManager.ObjectHelper markedGenerateObject : markedGenerateObjects) {
            DesignObject designObject = design.getDesignObject(markedGenerateObject.id);
            if (designObject == null) continue;
            designObject.setMarkedGenerate(markedGenerateObject.markedGenerate);
        }
        NodeList nodeList = this.getNodeObjects(ddlSelectionFilePath, ddlSelectionFileName + ".xml", design.isCompressedDesign());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element node = (Element)nodeList.item(i);
            DesignObject obj = design.getDesignObject(node.getAttribute("objectID"));
            if (obj instanceof Table) {
                Table table = (Table)obj;
                String useDDLTransformationScript = node.getAttribute(USE_DDL_TRANSFORMATION_SCRIPT);
                if (useDDLTransformationScript != null && !useDDLTransformationScript.isEmpty()) {
                    table.setUseDDLTransformationScript(new Boolean(useDDLTransformationScript));
                }
                ColumnSet tcs = table.getColumnSet();
                NodeList tableColumnList = node.getElementsByTagName(TABLE_COLUMN);
                for (int ic = 0; ic < tableColumnList.getLength(); ++ic) {
                    Element columnNode = (Element)tableColumnList.item(ic);
                    this.setColumnGenerateConstraintInDDL(table.getObjectID(), tcs, columnNode.getAttribute(COLUMN_ID), columnNode.getAttribute(CONSTRAINT_MARKED_GENERATE));
                }
                NodeList tableLevelConstraintsList = node.getElementsByTagName(TABLE_LEVEL_CONSTRAINT);
                for (int tc = 0; tc < tableLevelConstraintsList.getLength(); ++tc) {
                    Element tableLevelConstraintNode = (Element)tableLevelConstraintsList.item(tc);
                    this.setTableLevelGenerateConstraintInDDL(table, tableLevelConstraintNode);
                }
                NodeList existanceDepenndanciesList = node.getElementsByTagName(EXISTENCE_DEPENDENCY);
                for (int tc = 0; tc < existanceDepenndanciesList.getLength(); ++tc) {
                    Element existanceDepenndancyNode = (Element)existanceDepenndanciesList.item(tc);
                    if (!table.getExistDependencyConstraintName().equals(existanceDepenndancyNode.getAttribute(EXISTENCE_DEPENDENCY_NAME))) continue;
                    if (new Boolean(existanceDepenndancyNode.getAttribute(MARKED_GENERATE)).booleanValue()) {
                        table.setExistDependencyGenerateInDDl(true);
                        continue;
                    }
                    table.setExistDependencyGenerateInDDl(false);
                }
                continue;
            }
            if (!(obj instanceof FKIndexAssociation)) continue;
            ((FKIndexAssociation)obj).setColumnDependencyConstraintGenerateInDDL(new Boolean(node.getAttribute(FK_DEP_COLUMN_CONSTRAINT_IN_DDL)));
        }
    }

    private NodeList getNodeObjects(String storagePath, String fileName, boolean useCompressedFiles) {
        NodeList nodeList = null;
        try {
            Document doc = null;
            if (useCompressedFiles) {
                doc = XMLTransformationManager.getDocument(new File(storagePath, fileName + "z"));
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                File file = new File(storagePath, fileName);
                if (file.exists()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
            }
            if (doc != null) {
                nodeList = doc.getElementsByTagName("object");
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not parse Object List: " + storagePath + File.separatorChar + fileName, e);
        }
        return nodeList;
    }

    private void setColumnGenerateConstraintInDDL(String tableObjectID, ColumnSet tcs, String columnID, String GenerateConstraintInDDL) {
        for (int i = 0; i < tcs.size(); ++i) {
            Column column = (Column)tcs.getElement(i);
            if (!column.getTable().getObjectID().equalsIgnoreCase(tableObjectID) || !column.getObjectID().equals(columnID)) continue;
            if (GenerateConstraintInDDL.equalsIgnoreCase("yes")) {
                column.setGenerateConstraintInDDL(true);
            } else {
                column.setGenerateConstraintInDDL(false);
            }
            return;
        }
    }

    private void setTableLevelGenerateConstraintInDDL(Table table, Element tableLevelConstraintNode) {
        List tlcc = table.getCheckConstraints();
        if (tlcc == null) {
            return;
        }
        if (tlcc.size() > 0) {
            for (TableLevelConstraint tc : tlcc) {
                if (!tc.getName().equals(tableLevelConstraintNode.getAttribute(CONSTRAINT_NAME))) continue;
                if (tableLevelConstraintNode.getAttribute(MARKED_GENERATE).equalsIgnoreCase("yes")) {
                    tc.setGenerateInDDL(true);
                } else {
                    tc.setGenerateInDDL(false);
                }
                return;
            }
        }
    }

    private void restoreDDLSelection(StorageDesign storageDesign, String ddlSelectionFilePath, String ddlSelectionFileName) {
        List<XMLTransformationManager.ObjectHelper> markedGenerateObjects = XMLTransformationManager.getObjects(ddlSelectionFilePath, ddlSelectionFileName + ".xml", storageDesign.getDesign().isCompressedDesign());
        for (XMLTransformationManager.ObjectHelper markedGenerateObject : markedGenerateObjects) {
            ModelIDObject object = storageDesign.getModelIDObject(markedGenerateObject.id);
            if (object == null) continue;
            if (markedGenerateObject.type.equals("Package Body")) {
                PackageBodyOracle pbo = ((PackageOracle)object).getBody();
                if (pbo == null) continue;
                pbo.setMarkedGenerate(markedGenerateObject.markedGenerate);
                continue;
            }
            object.setMarkedGenerate(markedGenerateObject.markedGenerate);
        }
    }

    private List<ID_Name_Pair> getStoredDDLSelectionSDIDs(Design design, String ddlSelectionFilePath, String ddlSelectionFileName) {
        return this.getStorageDesignObjectIDs(ddlSelectionFilePath, ddlSelectionFileName + ".xml", design.isCompressedDesign());
    }

    private List<ID_Name_Pair> getStorageDesignObjectIDs(String storagePath, String fileName, boolean useCompressedFiles) {
        ArrayList<ID_Name_Pair> list = new ArrayList<ID_Name_Pair>();
        try {
            Document doc = null;
            if (useCompressedFiles) {
                doc = XMLTransformationManager.getDocument(new File(storagePath, fileName + "z"));
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                File file = new File(storagePath, fileName);
                if (file.exists()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
            }
            if (doc != null) {
                NodeList nodeList = doc.getElementsByTagName(SD_OBJECT);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element node = (Element)nodeList.item(i);
                    ID_Name_Pair sdIDAndName = new ID_Name_Pair(node.getAttribute("objectID"), node.getAttribute(SD_NAME));
                    list.add(sdIDAndName);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not parse Object List: " + storagePath + File.separatorChar + fileName, e);
        }
        return list;
    }

    private IncludeCommentsAndApplyNameSubstitutionHelper getCSObjects(Design design, String storagePath, String fileName, DDLFileMakerEditor fileMakerEditor) {
        boolean useCompressedFiles = design.isCompressedDesign();
        IncludeCommentsAndApplyNameSubstitutionHelper icansHelper = new IncludeCommentsAndApplyNameSubstitutionHelper();
        try {
            Document doc = null;
            if (useCompressedFiles) {
                doc = XMLTransformationManager.getDocument(new File(storagePath, fileName + "z"));
            } else {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                File file = new File(storagePath, fileName);
                if (file.exists()) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    doc = db.parse(new InputSource(reader));
                    reader.close();
                }
            }
            if (doc != null) {
                NodeList nodeList = doc.getElementsByTagName(PERSISTED_DDL_SELECTION);
                if (nodeList.getLength() == 0) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("XMLTransformationManager.NotADDLSelectionFile"), fileName), Messages.getString("XMLTransformationManager.Warning"), 2, null);
                    return null;
                }
                Element node = (Element)nodeList.item(0);
                if (!design.getObjectID().equals(node.getAttribute("objectID"))) {
                    JOptionPane.showMessageDialog(null, MessageFormat.format(Messages.getString("XMLTransformationManager.NotADDLSelectionForThisDesign"), fileName), Messages.getString("XMLTransformationManager.Warning"), 2, null);
                    return null;
                }
                nodeList = doc.getElementsByTagName(SELECTED_SUBVIEW);
                if (nodeList.getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    this.selectedSubViewChanged = design.getSelectedSubView() != design.getDesignPartView(node.getAttribute("objectID"));
                    design.setSelectedSubView(design.getDesignPartView(node.getAttribute("objectID")));
                    fileMakerEditor.getDesignSubViewCombo().setSelectedItem(design.getSelectedSubView());
                } else {
                    if (design.getSelectedSubView() != null) {
                        this.selectedSubViewChanged = true;
                    }
                    design.setSelectedSubView(null);
                    fileMakerEditor.getDesignSubViewCombo().setSelectedIndex(0);
                }
                nodeList = doc.getElementsByTagName(INCLUDE_COMMENTS);
                if (nodeList.getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    icansHelper.includeComments = Boolean.parseBoolean(node.getAttribute("isSelected"));
                } else {
                    icansHelper.includeComments = false;
                }
                nodeList = doc.getElementsByTagName(APPLY_NAME_SUBSTITUTION);
                if (nodeList.getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    icansHelper.applyNameSubstitution = Boolean.parseBoolean(node.getAttribute("isSelected"));
                }
                if ((nodeList = doc.getElementsByTagName(GENERATE_DDL_IN_FILES)).getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    icansHelper.generateDDLInFiles = Boolean.parseBoolean(node.getAttribute("isSelected"));
                } else {
                    icansHelper.generateDDLInFiles = false;
                }
                nodeList = doc.getElementsByTagName(GENERATE_REST_SERVICES);
                if (nodeList.getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    icansHelper.generateRESTServices = Boolean.parseBoolean(node.getAttribute("isSelected"));
                } else {
                    icansHelper.generateRESTServices = false;
                }
                nodeList = doc.getElementsByTagName(ACTIVE_SCRIPT_SET_CB_INDEX);
                if (nodeList.getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    icansHelper.activeScriptSetCBIndex = new Integer(node.getAttribute(SELECTED_INDEX));
                } else {
                    icansHelper.activeScriptSetCBIndex = 1;
                }
                nodeList = doc.getElementsByTagName(DROP_GENERATED_OBJECTS_ONLY);
                if (nodeList.getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    icansHelper.dropGeneratedObjectsOnly = Boolean.parseBoolean(node.getAttribute("isSelected"));
                } else {
                    icansHelper.dropGeneratedObjectsOnly = false;
                }
                nodeList = doc.getElementsByTagName(USE_DROP_DEPENDENCIES);
                if (nodeList.getLength() > 0) {
                    node = (Element)nodeList.item(0);
                    icansHelper.useDropDependencies = Boolean.parseBoolean(node.getAttribute("isSelected"));
                } else {
                    icansHelper.useDropDependencies = false;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Can not parse CD Object List: " + storagePath + File.separatorChar + fileName, e);
        }
        return icansHelper;
    }

    public boolean getSelectedSubViewChanged() {
        return this.selectedSubViewChanged;
    }

    public void setSelectedSubViewChanged(boolean selectedSubViewChanged) {
        this.selectedSubViewChanged = selectedSubViewChanged;
    }

    public void setSaveSelectionsBLPS(boolean saveSelectionsBLPS) {
        this.saveSelectionsBLPS = saveSelectionsBLPS;
    }

    public boolean getSaveSelectionsBLPS() {
        return this.saveSelectionsBLPS;
    }

    public void setDDLGenerated(boolean DDLGenerated) {
        this.DDLGenerated = DDLGenerated;
    }

    public boolean getDDLGenerated() {
        return this.DDLGenerated;
    }

    public boolean getPersistedIncludeCommentsSelection() {
        return this.icansHelper.includeComments;
    }

    public boolean getPersistedGenerateDDLInFilesSelection() {
        return this.icansHelper.generateDDLInFiles;
    }

    public boolean getPersistedGenerateRESTServicesSelection() {
        return this.icansHelper.generateRESTServices;
    }

    public int getPersistedActiveScriptSetCBIndex() {
        return this.icansHelper.activeScriptSetCBIndex;
    }

    public boolean getPersistedApplyNamesSubstitutionSelection() {
        return this.icansHelper.applyNameSubstitution;
    }

    public boolean getPersistedDropGeneratedObjectsOnly() {
        return this.icansHelper.dropGeneratedObjectsOnly;
    }

    public boolean getPersistedUseDropDependencies() {
        return this.icansHelper.useDropDependencies;
    }

    public boolean getDDLSelectionLoaded() {
        return this.DDLSelectionLoaded;
    }

    public void setDDLSelectionLoaded(boolean DDLSelectionLoaded) {
        this.DDLSelectionLoaded = DDLSelectionLoaded;
    }

    private class DesignPartStorableObjectsSelectionPair {
        public DesignPart designPart;
        public List<StorableObject> storableObjects;

        private DesignPartStorableObjectsSelectionPair() {
        }
    }

    private class StorageDesignModelIDObjectsSelectionPair {
        public StorageDesign storageDesign;
        public List<ModelIDObject> modelIDObjects;

        private StorageDesignModelIDObjectsSelectionPair() {
        }
    }

    private class IncludeCommentsAndApplyNameSubstitutionHelper {
        public boolean includeComments;
        public boolean applyNameSubstitution;
        public boolean dropGeneratedObjectsOnly;
        public boolean useDropDependencies;
        public boolean generateDDLInFiles;
        public boolean generateRESTServices;
        public int activeScriptSetCBIndex;

        private IncludeCommentsAndApplyNameSubstitutionHelper() {
        }
    }

    private class ID_Name_Pair {
        public String id;
        public String name;

        public ID_Name_Pair(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

